/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.CData;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.Text;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.xel.Function;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.util.Evaluators;
import org.zkoss.xel.util.MethodFunction;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.impl.ZScriptInitiator;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.ForwardInfo;
import org.zkoss.zk.ui.metainfo.HeaderInfo;
import org.zkoss.zk.ui.metainfo.InitiatorInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariableResolverInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.ui.util.Initiator;

public class Parser {
    private static final Log log = Log.lookup((Class)Parser.class);
    private final WebApp _wapp;
    private final Locator _locator;

    public Parser(WebApp wapp, Locator locator) {
        if (wapp == null) {
            throw new IllegalArgumentException("null");
        }
        this._wapp = wapp;
        this._locator = locator != null ? locator : wapp;
    }

    public PageDefinition parse(File file, String path) throws Exception {
        PageDefinition pgdef = this.parse(new SAXBuilder(true, false, true).build(file), Servlets.getExtension((String)file.getName()));
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(URL url, String path) throws Exception {
        PageDefinition pgdef = this.parse(new SAXBuilder(true, false, true).build(url), Servlets.getExtension((String)url.toExternalForm()));
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(Reader reader, String extension) throws Exception {
        return this.parse(new SAXBuilder(true, false, true).build(reader), extension);
    }

    public PageDefinition parse(Document doc, String extension) throws Exception {
        LinkedList<ProcessingInstruction> pis = new LinkedList<ProcessingInstruction>();
        LinkedList<String[]> imports = new LinkedList<String[]>();
        String lang = null;
        Iterator it = doc.getChildren().iterator();
        while (it.hasNext()) {
            Map params;
            Object o = it.next();
            if (!(o instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)o;
            String target = pi.getTarget();
            if ("page".equals(target)) {
                params = pi.parseData();
                String l = (String)params.remove("language");
                if (l != null) {
                    Parser.noEL("language", l, (Item)pi);
                    lang = l;
                }
                if (params.isEmpty()) continue;
                pis.add(pi);
                continue;
            }
            if ("import".equals(target)) {
                params = pi.parseData();
                String src = (String)params.remove("src");
                String dirs = (String)params.remove("directives");
                if (!params.isEmpty()) {
                    log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
                }
                Parser.noELnorEmpty("src", src, (Item)pi);
                Parser.noEL("directives", dirs, (Item)pi);
                imports.add(new String[]{src, dirs});
                continue;
            }
            pis.add(pi);
        }
        LanguageDefinition langdef = extension != null && lang == null ? LanguageDefinition.getByExtension(extension) : LanguageDefinition.lookup(lang);
        PageDefinition pgdef = new PageDefinition(langdef, this.getLocator());
        if (!imports.isEmpty()) {
            RequestInfoImpl ri = new RequestInfoImpl(this._wapp, null, null, null, this._locator);
            UiFactory uf = ((WebAppCtrl)((Object)this._wapp)).getUiFactory();
            Iterator it2 = imports.iterator();
            while (it2.hasNext()) {
                String[] imprt = (String[])it2.next();
                String path = imprt[0];
                String dirs = imprt[1];
                try {
                    PageDefinition pd = uf.getPageDefinition(ri, path);
                    if (pd == null) {
                        throw new UiException("Import page not found: " + path);
                    }
                    pgdef.imports(pd, Parser.parseToArray(dirs));
                }
                catch (PotentialDeadLockException ex) {
                    throw new UiException("Recursive import: " + path, (Throwable)ex);
                }
            }
        }
        Iterator it3 = pis.iterator();
        while (it3.hasNext()) {
            this.parse(pgdef, (ProcessingInstruction)it3.next());
        }
        Element root = doc.getRootElement();
        if (root != null) {
            this.parse(pgdef, (NodeInfo)pgdef, root, new AnnotationHelper());
        }
        return pgdef;
    }

    private static Class locateClass(String clsnm) throws Exception {
        try {
            return Classes.forNameByThread((String)clsnm);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException("Class not found: " + clsnm, ex);
        }
    }

    private static String[] parseToArray(String s) {
        if (s == null) {
            return null;
        }
        Collection ims = CollectionsX.parse(null, (String)s, (char)',', (boolean)false);
        return ims.toArray(new String[ims.size()]);
    }

    public Locator getLocator() {
        return this._locator;
    }

    private void parse(PageDefinition pgdef, ProcessingInstruction pi) throws Exception {
        String target = pi.getTarget();
        Map params = pi.parseData();
        if ("page".equals(target)) {
            Parser.parsePageDirective(pgdef, pi, params);
        } else if ("init".equals(target)) {
            this.parseInitDirective(pgdef, pi, params);
        } else if ("variable-resolver".equals(target)) {
            String arg;
            String clsnm = (String)params.remove("class");
            if (Parser.isEmpty(clsnm)) {
                throw new UiException("The class attribute is required, " + pi.getLocator());
            }
            LinkedList<String> args = new LinkedList<String>();
            int j = 0;
            while ((arg = (String)params.remove("arg" + j)) != null) {
                args.add(arg);
                ++j;
            }
            if (!params.isEmpty()) {
                log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
            }
            pgdef.addVariableResolverInfo(clsnm.indexOf("${") >= 0 ? new VariableResolverInfo(clsnm, args) : new VariableResolverInfo(Parser.locateClass(clsnm), args));
        } else if ("component".equals(target)) {
            this.parseComponentDirective(pgdef, pi, params);
        } else if ("taglib".equals(target)) {
            String uri = (String)params.remove("uri");
            String prefix = (String)params.remove("prefix");
            if (!params.isEmpty()) {
                log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
            }
            if (uri == null || prefix == null) {
                throw new UiException("Both uri and prefix attribute are required, " + pi.getLocator());
            }
            Parser.noEL("prefix", prefix, (Item)pi);
            Parser.noEL("uri", uri, (Item)pi);
            pgdef.addTaglib(new Taglib(prefix, this.toAbsoluteURI(uri, false)));
        } else if ("evaluator".equals(target)) {
            Parser.parseEvaluatorDirective(pgdef, pi, params);
        } else if ("xel-method".equals(target)) {
            Parser.parseXelMethod(pgdef, pi, params);
        } else if ("link".equals(target) || "meta".equals(target)) {
            pgdef.addHeaderInfo(new HeaderInfo(target, params));
        } else if ("root-attributes".equals(target)) {
            Iterator it = pi.parseData().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                pgdef.setRootAttribute((String)me.getKey(), (String)me.getValue());
            }
        } else if ("forward".equals(target)) {
            String uri = (String)params.remove("uri");
            String ifc = (String)params.remove("if");
            String unless = (String)params.remove("unless");
            if (!params.isEmpty()) {
                log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
            }
            Parser.noEmpty("uri", uri, (Item)pi);
            pgdef.addForwardInfo(new ForwardInfo(uri, ConditionImpl.getInstance(ifc, unless)));
        } else {
            if ("import".equals(target)) {
                throw new UiException("The import directive can be used only at the top level, " + pi.getLocator());
            }
            log.warning("Unknown processing instruction: " + target + ", " + pi.getLocator());
        }
    }

    private void parseInitDirective(PageDefinition pgdef, ProcessingInstruction pi, Map params) throws Exception {
        String arg;
        LinkedList<String> args = new LinkedList<String>();
        int j = 0;
        while ((arg = (String)params.remove("arg" + j)) != null) {
            args.add(arg);
            ++j;
        }
        String clsnm = (String)params.remove("class");
        String zsrc = (String)params.remove("zscript");
        if (!params.isEmpty()) {
            log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
        }
        if (Parser.isEmpty(clsnm)) {
            ZScript zs;
            if (Parser.isEmpty(zsrc)) {
                throw new UiException("Either the class or zscript attribute must be specified, " + pi.getLocator());
            }
            String zslang = pgdef.getZScriptLanguage();
            if (zsrc.indexOf("${") >= 0) {
                zs = new ZScript(pgdef.getEvaluatorRef(), zslang, zsrc, null, this.getLocator());
            } else {
                URL url = this.getLocator().getResource(zsrc);
                if (url == null) {
                    throw new UiException("File not found: " + zsrc + ", at " + pi.getLocator());
                }
                zs = new ZScript(pgdef.getEvaluatorRef(), zslang, url, null);
            }
            pgdef.addInitiatorInfo(new InitiatorInfo((Initiator)new ZScriptInitiator(zs), args));
        } else {
            if (!Parser.isEmpty(zsrc)) {
                throw new UiException("You cannot specify both class and zscript, " + pi.getLocator());
            }
            pgdef.addInitiatorInfo(clsnm.indexOf("${") >= 0 ? new InitiatorInfo(clsnm, args) : new InitiatorInfo(Parser.locateClass(clsnm), args));
        }
    }

    private static void parsePageDirective(PageDefinition pgdef, ProcessingInstruction pi, Map params) throws Exception {
        Iterator it = pi.parseData().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String nm = (String)me.getKey();
            String val = (String)me.getValue();
            if ("language".equals(nm)) {
                if (pi.getParent() instanceof Document) continue;
                log.warning("Ignored language attribute since the page directive is not at the top level, " + pi.getLocator());
                continue;
            }
            if ("title".equals(nm)) {
                pgdef.setTitle(val);
                continue;
            }
            if ("style".equals(nm)) {
                pgdef.setStyle(val);
                continue;
            }
            if ("id".equals(nm)) {
                pgdef.setId(val);
                continue;
            }
            if ("zscriptLanguage".equals(nm) || "zscript-language".equals(nm)) {
                Parser.noELnorEmpty("zscriptLanguage", val, (Item)pi);
                pgdef.setZScriptLanguage(val);
                continue;
            }
            if ("cacheable".equals(nm)) {
                Parser.noELnorEmpty("cacheable", val, (Item)pi);
                pgdef.setCacheable("true".equals(val));
                continue;
            }
            if ("contentType".equals(nm)) {
                Parser.noEmpty("contentType", val, (Item)pi);
                pgdef.setContentType(val);
                continue;
            }
            if ("docType".equals(nm)) {
                Parser.noEmpty("docType", val, (Item)pi);
                pgdef.setDocType("<!DOCTYPE " + val + '>');
                continue;
            }
            if ("xml".equals(nm)) {
                Parser.noEmpty("xml", val, (Item)pi);
                pgdef.setFirstLine("<?xml " + val + "?>");
                continue;
            }
            log.warning("Ignored unknown attribute: " + nm + ", " + pi.getLocator());
        }
    }

    private void parseComponentDirective(PageDefinition pgdef, ProcessingInstruction pi, Map params) throws Exception {
        ComponentDefinition compdef;
        String name = (String)params.remove("name");
        Parser.noELnorEmpty("name", name, (Item)pi);
        String macroURI = (String)params.remove("macroURI");
        if (macroURI == null) {
            macroURI = (String)params.remove("macro-uri");
        }
        String extds = (String)params.remove("extends");
        String clsnm = (String)params.remove("class");
        if (macroURI != null) {
            String inline = (String)params.remove("inline");
            Parser.noEL("inline", inline, (Item)pi);
            Parser.noEL("macroURI", macroURI, (Item)pi);
            boolean bInline = "true".equals(inline);
            compdef = pgdef.getLanguageDefinition().getMacroDefinition(name, this.toAbsoluteURI(macroURI, false), bInline, pgdef);
            if (!Parser.isEmpty(clsnm)) {
                if (bInline) {
                    throw new UiException("class not allowed with inline macros, " + pi.getLocator());
                }
                Parser.noEL("class", clsnm, (Item)pi);
                compdef.setImplementationClass(clsnm);
            }
        } else if (extds != null) {
            Parser.noEL("extends", extds, (Item)pi);
            ComponentDefinition ref = pgdef.getLanguageDefinition().getComponentDefinition(extds);
            if (ref.isMacro()) {
                throw new UiException("Unable to extend from a macro component, " + pi.getLocator());
            }
            compdef = ref.clone(null, name);
            if (!Parser.isEmpty(clsnm)) {
                Parser.noEL("class", clsnm, (Item)pi);
                compdef.setImplementationClass(clsnm);
            }
        } else {
            Parser.noELnorEmpty("class", clsnm, (Item)pi);
            ComponentDefinitionImpl cdi = new ComponentDefinitionImpl(null, pgdef, name, null);
            cdi.setCurrentDirectory(this.getLocator().getDirectory());
            compdef = cdi;
            compdef.setImplementationClass(clsnm);
        }
        pgdef.addComponentDefinition(compdef);
        String moldnm = (String)params.remove("moldName");
        if (moldnm == null) {
            moldnm = (String)params.remove("mold-name");
        }
        Parser.noEL("moldName", moldnm, (Item)pi);
        String moldURI = (String)params.remove("moldURI");
        if (moldURI == null) {
            moldURI = (String)params.remove("mold-uri");
        }
        if (!Parser.isEmpty(moldURI)) {
            compdef.addMold(Parser.isEmpty(moldnm) ? "default" : moldnm, moldURI.startsWith("class:") ? moldURI : this.toAbsoluteURI(moldURI, true));
        }
        Iterator e = params.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry me = e.next();
            compdef.addProperty((String)me.getKey(), (String)me.getValue());
        }
    }

    private static void parseEvaluatorDirective(PageDefinition pgdef, ProcessingInstruction pi, Map params) throws Exception {
        String clsnm = (String)params.remove("class");
        if (clsnm != null && clsnm.length() > 0) {
            Parser.noELnorEmpty("class", clsnm, (Item)pi);
            pgdef.setExpressionFactoryClass(Parser.locateClass(clsnm));
        } else {
            String nm = (String)params.remove("name");
            if (nm != null) {
                pgdef.setExpressionFactoryClass(Evaluators.getEvaluatorClass((String)nm));
            }
        }
        String imports = (String)params.remove("import");
        if (imports != null && imports.length() > 0) {
            Collection ims = CollectionsX.parse(null, (String)imports, (char)',', (boolean)false);
            Iterator it = ims.iterator();
            while (it.hasNext()) {
                String im = (String)it.next();
                int k = im.indexOf(61);
                String nm = k > 0 ? im.substring(0, k).trim() : null;
                String cn = (k >= 0 ? im.substring(k + 1) : im).trim();
                if (cn.length() == 0) continue;
                Class cs = Parser.locateClass(cn);
                if (nm == null || nm.length() == 0) {
                    int j = cn.lastIndexOf(46);
                    nm = j >= 0 ? cn.substring(j + 1) : cn;
                }
                pgdef.addExpressionImport(nm, cs);
            }
        }
    }

    private static void parseXelMethod(PageDefinition pgdef, ProcessingInstruction pi, Map params) throws Exception {
        Method mtd;
        String prefix = (String)params.remove("prefix");
        Parser.noELnorEmpty("prefix", prefix, (Item)pi);
        String nm = (String)params.remove("name");
        Parser.noELnorEmpty("name", nm, (Item)pi);
        String clsnm = (String)params.remove("class");
        Parser.noELnorEmpty("class", clsnm, (Item)pi);
        String sig = (String)params.remove("signature");
        Parser.noELnorEmpty("signature", sig, (Item)pi);
        try {
            Class cls = Classes.forNameByThread((String)clsnm);
            mtd = Classes.getMethodBySignature((Class)cls, (String)sig, null);
        }
        catch (ClassNotFoundException ex) {
            throw new UiException("Class not found: " + clsnm + ", " + pi.getLocator());
        }
        catch (Exception ex) {
            throw new UiException("Method not found: " + sig + " in " + clsnm + ", " + pi.getLocator());
        }
        if ((mtd.getModifiers() & 8) == 0) {
            throw new UiException("Not a static method: " + mtd);
        }
        pgdef.addXelMethod(prefix, nm, (Function)new MethodFunction(mtd));
    }

    private static void noELnorEmpty(String nm, String val, Item item) throws UiException {
        if (Parser.isEmpty(val)) {
            throw new UiException(nm + " cannot be empty, " + item.getLocator());
        }
        Parser.noEL(nm, val, item);
    }

    private static void noEL(String nm, String val, Item item) throws UiException {
        if (val != null && val.indexOf("${") >= 0) {
            throw new UiException(nm + " does not support EL expressions, " + item.getLocator());
        }
    }

    private static void noEmpty(String nm, String val, Item item) throws UiException {
        if (val != null && val.length() == 0) {
            throw new UiException(nm + " cannot be empty, " + item.getLocator());
        }
    }

    private String toAbsoluteURI(String uri, boolean allowEL) {
        String dir;
        char cc;
        if (!(uri == null || uri.length() <= 0 || (cc = uri.charAt(0)) == '/' || cc == '~' || allowEL && uri.indexOf("${") >= 0 || Servlets.isUniversalURL((String)uri) || (dir = this.getLocator().getDirectory()) == null || dir.length() <= 0)) {
            return dir.charAt(dir.length() - 1) == '/' ? dir + uri : dir + '/' + uri;
        }
        return uri;
    }

    private void parse(PageDefinition pgdef, NodeInfo parent, Collection items, AnnotationHelper annHelper) throws Exception {
        ComponentInfo parentInfo = parent instanceof ComponentInfo ? (ComponentInfo)parent : null;
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Element) {
                this.parse(pgdef, parent, (Element)o, annHelper);
                continue;
            }
            if (o instanceof ProcessingInstruction) {
                this.parse(pgdef, (ProcessingInstruction)o);
                continue;
            }
            if (!(o instanceof Text) && !(o instanceof CData)) continue;
            String label = ((Item)o).getText();
            String trimLabel = label.trim();
            LanguageDefinition parentlang = Parser.getLanguageDefinition(parent);
            if (parentlang == null) {
                parentlang = pgdef.getLanguageDefinition();
            }
            if (trimLabel.length() <= 0) continue;
            if (parentInfo instanceof NativeInfo) {
                ((NativeInfo)parentInfo).appendChild(new TextInfo(pgdef.getEvaluatorRef(), trimLabel));
                continue;
            }
            String textAs = parentInfo.getTextAs();
            if (textAs != null) {
                parentInfo.addProperty(textAs, trimLabel, null);
                continue;
            }
            if (!parentlang.isRawLabel()) {
                label = trimLabel;
            }
            parentlang.newLabelInfo(parentInfo, label);
        }
    }

    private static final LanguageDefinition getLanguageDefinition(NodeInfo node) {
        while (node != null) {
            if (node instanceof ComponentInfo) {
                LanguageDefinition langdef = ((ComponentInfo)node).getLanguageDefinition();
                if (langdef != null) {
                    return langdef;
                }
            } else if (node instanceof PageDefinition) {
                return ((PageDefinition)node).getLanguageDefinition();
            }
            node = node.getParent();
        }
        return null;
    }

    private void parse(PageDefinition pgdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        String nm = el.getLocalName();
        Namespace ns = el.getNamespace();
        String pref = ns != null ? ns.getPrefix() : "";
        String uri = ns != null ? ns.getURI() : "";
        LanguageDefinition langdef = pgdef.getLanguageDefinition();
        if ("zscript".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            this.parseZScript(parent, el, annHelper);
        } else if ("attribute".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            if (!(parent instanceof ComponentInfo)) {
                throw new UiException("<attribute> cannot be the root element, " + el.getLocator());
            }
            Parser.parseAttribute((ComponentInfo)parent, el, annHelper);
        } else if ("custom-attributes".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            Parser.parseCustomAttributes(parent, el, annHelper);
        } else if ("variables".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            Parser.parseVariables(parent, el, annHelper);
        } else if ("http://www.zkoss.org/2005/zk/annotation".equals(uri)) {
            Parser.parseAnnotation(el, annHelper);
        } else {
            ComponentInfo compInfo;
            if ("zk".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
                if (annHelper.clear()) {
                    log.warning("Annotations are ignored since <zk> doesn't support them, " + el.getLocator());
                }
                compInfo = new ComponentInfo(parent, ComponentDefinition.ZK);
            } else {
                boolean bNative;
                boolean prefRequired = uri.startsWith("native:");
                boolean bl = bNative = prefRequired || "http://www.zkoss.org/2005/zk/native".equals(uri);
                if (!bNative && langdef.isNative() && !langdef.getNamespace().equals(uri)) {
                    prefRequired = "".equals(pref) && "".equals(uri) || !LanguageDefinition.exists(uri);
                    bNative = prefRequired;
                }
                if (bNative) {
                    if (annHelper.clear()) {
                        log.warning("Annotations are ignored since native doesn't support them, " + el.getLocator());
                    }
                    NativeInfo ni = new NativeInfo(parent, langdef.getNativeDefinition(), prefRequired && pref.length() > 0 ? pref + ":" + nm : nm);
                    compInfo = ni;
                    Collection dns = el.getDeclaredNamespaces();
                    if (!dns.isEmpty()) {
                        Parser.addDeclaredNamespace(ni, dns, langdef);
                    }
                } else {
                    LanguageDefinition complangdef = Parser.isDefaultNS(langdef, pref, uri) ? langdef : LanguageDefinition.lookup(uri);
                    ComponentDefinition compdef = pgdef.getComponentDefinitionMap().get(nm);
                    if (compdef != null) {
                        compInfo = new ComponentInfo(parent, compdef);
                    } else if (complangdef.hasComponentDefinition(nm)) {
                        compdef = complangdef.getComponentDefinition(nm);
                        compInfo = new ComponentInfo(parent, compdef);
                        langdef = complangdef;
                    } else {
                        compdef = complangdef.getDynamicTagDefinition();
                        if (compdef == null) {
                            throw new DefinitionNotFoundException("Component definition not found: " + nm + " in " + complangdef + ", " + el.getLocator());
                        }
                        compInfo = new ComponentInfo(parent, compdef, nm);
                        langdef = complangdef;
                    }
                    String use = el.getAttributeValue("use");
                    if (use != null && (use = use.trim()).length() != 0) {
                        compInfo.setImplementationClass(use);
                    }
                }
            }
            String ifc = null;
            String unless = null;
            String forEach = null;
            String forEachBegin = null;
            String forEachEnd = null;
            AnnotationHelper attrAnnHelper = null;
            Iterator it = el.getAttributeItems().iterator();
            while (it.hasNext()) {
                String attruri;
                Attribute attr = (Attribute)it.next();
                Namespace attrns = attr.getNamespace();
                String attnm = attr.getLocalName();
                String attval = attr.getValue();
                if (attrns != null && "http://www.zkoss.org/2005/zk/annotation".equals(attrns.getURI())) {
                    if (attrAnnHelper == null) {
                        attrAnnHelper = new AnnotationHelper();
                    }
                    attrAnnHelper.addByRawValue(attnm, attval);
                    continue;
                }
                if ("apply".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    compInfo.setApply(attval);
                    continue;
                }
                if ("forward".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    compInfo.setForward(attval);
                    continue;
                }
                if ("if".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    ifc = attval;
                    continue;
                }
                if ("unless".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    unless = attval;
                    continue;
                }
                if ("forEach".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEach = attval;
                    continue;
                }
                if ("forEachBegin".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEachBegin = attval;
                    continue;
                }
                if ("forEachEnd".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEachEnd = attval;
                    continue;
                }
                if ("fulfill".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    compInfo.setFulfill(attval);
                    continue;
                }
                if ("use".equals(attnm) && Parser.isZkAttr(langdef, attrns)) continue;
                Namespace attns = attr.getNamespace();
                String attpref = attns != null ? attns.getPrefix() : "";
                String string = attruri = attns != null ? attns.getURI() : "";
                if ("xmlns".equals(attpref) || "xmlns".equals(attnm) && "".equals(attpref) || "http://www.w3.org/2001/XMLSchema-instance".equals(attruri)) continue;
                int len = attval.length();
                if (len >= 3 && attval.charAt(0) == '@' && attval.charAt(1) == '{' && attval.charAt(len - 1) == '}') {
                    if (attrAnnHelper == null) {
                        attrAnnHelper = new AnnotationHelper();
                    }
                    attrAnnHelper.addByCompoundValue(attval.substring(2, len - 1));
                    attrAnnHelper.applyAnnotations(compInfo, "self".equals(attnm) ? null : attnm, true);
                    continue;
                }
                Parser.addAttribute(compInfo, attns, attnm, attval, null);
                if (attrAnnHelper == null) continue;
                attrAnnHelper.applyAnnotations(compInfo, attnm, true);
            }
            compInfo.setCondition(ConditionImpl.getInstance(ifc, unless));
            compInfo.setForEach(forEach, forEachBegin, forEachEnd);
            annHelper.applyAnnotations(compInfo, null, true);
            this.parse(pgdef, (NodeInfo)compInfo, el.getChildren(), annHelper);
            if (compInfo instanceof NativeInfo && !compInfo.getChildren().isEmpty()) {
                Parser.optimizeNativeInfos((NativeInfo)compInfo);
            }
        }
    }

    private void parseZScript(NodeInfo parent, Element el, AnnotationHelper annHelper) {
        String script;
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException("forEach not applicable to <zscript>, " + el.getLocator());
        }
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <zscript> doesn't support them, " + el.getLocator());
        }
        String ifc = el.getAttributeValue("if");
        String unless = el.getAttributeValue("unless");
        String zsrc = el.getAttributeValue("src");
        boolean deferred = "true".equals(el.getAttributeValue("deferred"));
        String zslang = el.getAttributeValue("language");
        if (zslang == null) {
            zslang = parent.getPageDefinition().getZScriptLanguage();
        } else {
            Parser.noEmpty("language", zslang, (Item)el);
            Parser.noEL("language", zslang, (Item)el);
        }
        ConditionImpl cond = ConditionImpl.getInstance(ifc, unless);
        if (!Parser.isEmpty(zsrc)) {
            ZScript zs;
            if (zsrc.indexOf("${") >= 0) {
                zs = new ZScript(parent.getEvaluatorRef(), zslang, zsrc, cond, this.getLocator());
            } else {
                URL url = this.getLocator().getResource(zsrc);
                if (url == null) {
                    throw new UiException("File not found: " + zsrc + ", at " + el.getLocator());
                }
                zs = new ZScript(parent.getEvaluatorRef(), zslang, url, cond);
            }
            if (deferred) {
                zs.setDeferred(true);
            }
            parent.appendChild(zs);
        }
        if (!Parser.isEmpty(script = el.getText(true))) {
            ZScript zs = new ZScript(parent.getEvaluatorRef(), zslang, script, cond);
            if (deferred) {
                zs.setDeferred(true);
            }
            parent.appendChild(zs);
        }
    }

    private static void parseAttribute(ComponentInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException("forEach not applicable to attribute, " + el.getLocator());
        }
        String attnm = IDOMs.getRequiredAttributeValue((Element)el, (String)"name");
        String trim = el.getAttributeValue("trim");
        Parser.noEL("trim", trim, (Item)el);
        String attval = el.getText(trim != null && "true".equals(trim));
        Parser.addAttribute(parent, null, attnm, attval, ConditionImpl.getInstance(el.getAttributeValue("if"), el.getAttributeValue("unless")));
        annHelper.applyAnnotations(parent, attnm, true);
    }

    private static void parseCustomAttributes(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (parent instanceof PageDefinition) {
            throw new UiException("custom-attributes must be used under a component, " + el.getLocator());
        }
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <custom-attribute> doesn't support them, " + el.getLocator());
        }
        String ifc = null;
        String unless = null;
        String scope = null;
        HashMap<String, String> attrs = new HashMap<String, String>();
        Iterator it = el.getAttributeItems().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            if ("scope".equals(attnm)) {
                scope = attval;
                continue;
            }
            if ("forEach".equals(attnm)) {
                throw new UiException("forEach not applicable to <custom-attributes>, " + el.getLocator());
            }
            attrs.put(attnm, attval);
        }
        if (!attrs.isEmpty()) {
            parent.appendChild(new AttributesInfo(parent.getEvaluatorRef(), attrs, scope, ConditionImpl.getInstance(ifc, unless)));
        }
    }

    private static void parseVariables(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException("forEach not applicable to <variables>, " + el.getLocator());
        }
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <variables> doesn't support them, " + el.getLocator());
        }
        String ifc = null;
        String unless = null;
        boolean local = false;
        HashMap<String, String> vars = new HashMap<String, String>();
        Iterator it = el.getAttributeItems().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            if ("local".equals(attnm)) {
                local = "true".equals(attval);
                continue;
            }
            if ("forEach".equals(attnm)) {
                throw new UiException("forEach not applicable to <variables>, " + el.getLocator());
            }
            vars.put(attnm, attval);
        }
        if (!vars.isEmpty()) {
            parent.appendChild(new VariablesInfo(parent.getEvaluatorRef(), vars, local, ConditionImpl.getInstance(ifc, unless)));
        }
    }

    private static void parseAnnotation(Element el, AnnotationHelper annHelper) throws Exception {
        if (!el.getElements().isEmpty()) {
            throw new UiException("Child elements are not allowed for the annotations, " + el.getLocator());
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        Iterator it = el.getAttributeItems().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            attrs.put(attr.getLocalName(), attr.getValue());
        }
        annHelper.add(el.getLocalName(), attrs);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static final boolean isDefaultNS(LanguageDefinition langdef, String pref, String uri) {
        return !langdef.isNative() && "".equals(pref) && "".equals(uri) || langdef.getNamespace().equals(uri);
    }

    private static final boolean isZkElement(LanguageDefinition langdef, String nm, String pref, String uri) {
        if (Parser.isDefaultNS(langdef, pref, uri)) {
            return !langdef.hasComponentDefinition(nm);
        }
        return "http://www.zkoss.org/2005/zk".equals(uri);
    }

    private static final boolean isZkAttr(LanguageDefinition langdef, Namespace attrns) {
        if (langdef.isNative()) {
            String uri = attrns.getURI();
            return "http://www.zkoss.org/2005/zk".equals(uri) || langdef.getNamespace().equals(uri);
        }
        return true;
    }

    private static void addAttribute(ComponentInfo compInfo, Namespace attrns, String name, String value, ConditionImpl cond) throws Exception {
        if (Events.isValid(name)) {
            boolean bZkAttr;
            boolean bl = bZkAttr = attrns == null;
            if (!bZkAttr) {
                String pref = attrns.getPrefix();
                String uri = attrns.getURI();
                LanguageDefinition langdef = compInfo.getLanguageDefinition();
                bZkAttr = langdef == null ? true : (Parser.isDefaultNS(langdef, pref, uri) ? !langdef.isDynamicReservedAttributes("[event]") : "http://www.zkoss.org/2005/zk".equals(uri));
            }
            if (bZkAttr) {
                ZScript zscript = ZScript.parseContent(value);
                if (zscript.getLanguage() == null) {
                    zscript.setLanguage(compInfo.getPageDefinition().getZScriptLanguage());
                }
                compInfo.addEventHandler(name, zscript, cond);
                return;
            }
        }
        compInfo.addProperty(name, value, cond);
    }

    private static void addDeclaredNamespace(NativeInfo nativeInfo, Collection namespaces, LanguageDefinition langdef) {
        Iterator it = namespaces.iterator();
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            String uri = ns.getURI();
            boolean bNatPrefix = uri.startsWith("native:");
            if (!bNatPrefix && (!langdef.isNative() || "http://www.zkoss.org/2005/zk".equals(uri) || "http://www.zkoss.org/2005/zk/annotation".equals(uri) || "http://www.zkoss.org/2005/zk/native".equals(uri) || langdef.getNamespace().equals(uri))) continue;
            nativeInfo.addDeclaredNamespace(new Namespace(ns.getPrefix(), bNatPrefix ? uri.substring("native:".length()) : uri));
        }
    }

    private static void optimizeNativeInfos(NativeInfo compInfo) {
        NativeInfo childInfo;
        Object o;
        Iterator it;
        int sz;
        Iterator it2 = compInfo.getChildren().iterator();
        while (it2.hasNext()) {
            Object o2 = it2.next();
            if (o2 instanceof NativeInfo) {
                NativeInfo childInfo2 = (NativeInfo)o2;
                if (!childInfo2.getChildren().isEmpty()) break;
                childInfo2.setParentDirectly(null);
            } else if (o2 instanceof ComponentInfo) break;
            compInfo.addPrologChildDirectly(o2);
            it2.remove();
        }
        if ((sz = compInfo.getChildren().size()) >= 0) {
            it = compInfo.getChildren().listIterator(sz);
            while (it.hasPrevious()) {
                o = it.previous();
                if (o instanceof NativeInfo) {
                    childInfo = (NativeInfo)o;
                    if (!childInfo.getChildren().isEmpty()) {
                        it.next();
                        break;
                    }
                    childInfo.setParentDirectly(null);
                    continue;
                }
                if (!(o instanceof ComponentInfo)) continue;
                it.next();
                break;
            }
            while (it.hasNext()) {
                o = it.next();
                compInfo.addEpilogChildDirectly(o);
                it.remove();
            }
        }
        if (compInfo.getChildren().size() == 1 && !compInfo.withForEach() && compInfo.getSplitChild() == null && (o = (it = compInfo.getChildren().iterator()).next()) instanceof NativeInfo) {
            childInfo = (NativeInfo)o;
            childInfo.setParentDirectly(null);
            compInfo.setSplitChild(childInfo);
            it.remove();
            it = childInfo.getChildren().iterator();
            while (it.hasNext()) {
                Object gc = it.next();
                it.remove();
                compInfo.appendChildDirectly(gc);
                if (!(gc instanceof ComponentInfo)) continue;
                ((ComponentInfo)gc).setParentDirectly(compInfo);
            }
        }
    }
}

