/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.metainfo.EvalRefStub;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;

public class Property
extends EvalRefStub
implements Condition,
Serializable {
    private static final Log log = Log.lookup((Class)Property.class);
    private static final long serialVersionUID = 20060622L;
    private final String _name;
    private final ExValue _value;
    private final ConditionImpl _cond;
    private transient Class _lastcls;
    private transient Method _mtd;
    private transient Method[] _mtds;

    public Property(EvaluatorRef evalr, String name, String value, ConditionImpl cond) {
        if (name == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._name = name;
        this._cond = cond;
        this._value = new ExValue(value, Object.class);
    }

    public String getName() {
        return this._name;
    }

    public String getRawValue() {
        return this._value.getRawValue();
    }

    public void setRawValue(String value) {
        this._value.setRawValue(value);
    }

    private final void resolve(Class cls) {
        String mtdnm = Classes.toMethodName((String)this._name, (String)"set");
        if (this._value.isExpression()) {
            this._mtds = Classes.getCloseMethods((Class)cls, (String)mtdnm, (Class[])new Class[]{null});
            if (this._mtds.length == 0) {
                if (!DynamicPropertied.class.isAssignableFrom(cls)) {
                    throw new UiException("Method " + mtdnm + " not found for " + cls);
                }
                this._mtds = null;
            } else if (this._mtds.length == 1) {
                this._mtd = this._mtds[0];
                this._mtds = null;
            }
        } else {
            try {
                this._mtd = Classes.getCloseMethod((Class)cls, (String)mtdnm, (Class[])new Class[]{String.class});
            }
            catch (NoSuchMethodException ex) {
                try {
                    this._mtd = Classes.getCloseMethod((Class)cls, (String)mtdnm, (Class[])new Class[]{null});
                }
                catch (NoSuchMethodException e2) {
                    if (!DynamicPropertied.class.isAssignableFrom(cls)) {
                        throw new UiException("Method, " + mtdnm + ", not found for " + cls);
                    }
                    this._mtd = null;
                }
            }
        }
    }

    public Object getValue(Component comp) {
        return this._value.getValue((Evaluator)this._evalr, comp);
    }

    public Object getValue(Page page) {
        return this._value.getValue((Evaluator)this._evalr, page);
    }

    public void assign(Component comp) {
        if (!this.isEffective(comp)) {
            return;
        }
        try {
            Method mtd;
            Class<?> cls = comp.getClass();
            if (this._lastcls != cls) {
                this.resolve(cls);
                this._lastcls = cls;
            }
            Class type = this._mtd != null ? this._mtd.getParameterTypes()[0] : Object.class;
            this._value.setExpectedType(type);
            Object val = this._value.getValue((Evaluator)this._evalr, comp);
            if (this._mtd != null) {
                mtd = this._mtd;
            } else {
                if (this._mtds == null) {
                    ((DynamicPropertied)((Object)comp)).setDynamicProperty(this._name, val);
                    return;
                }
                if (val == null) {
                    mtd = this._mtds[0];
                    val = Classes.coerce(mtd.getParameterTypes()[0], (Object)val);
                } else {
                    int j = 0;
                    while (true) {
                        if (j == this._mtds.length) {
                            mtd = this._mtds[0];
                            val = Classes.coerce(mtd.getParameterTypes()[0], (Object)val);
                            break;
                        }
                        if (this._mtds[j].getParameterTypes()[0].isInstance(val)) {
                            mtd = this._mtds[j];
                            break;
                        }
                        ++j;
                    }
                }
            }
            mtd.invoke((Object)comp, val);
        }
        catch (Exception ex) {
            log.error("Failed to assign " + this + " to " + comp + "\n" + Exceptions.getMessage((Throwable)ex));
            throw UiException.Aide.wrap(ex);
        }
    }

    public boolean isEffective(Component comp) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, comp);
    }

    public boolean isEffective(Page page) {
        return this._cond == null || this._cond.isEffective((Evaluator)this._evalr, page);
    }

    public String toString() {
        return "[" + this._name + "=" + this._value + ']';
    }
}

