/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.impl.MacroDefinition;
import org.zkoss.zk.ui.metainfo.impl.NativeDefinition;
import org.zkoss.zk.ui.render.ComponentRenderer;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;

public class ComponentDefinitionImpl
implements ComponentDefinition,
Serializable {
    private String _name;
    private transient LanguageDefinition _langdef;
    private transient PageDefinition _pgdef;
    private EvaluatorRef _evalr;
    private Object _implcls;
    private transient Map _molds;
    private Map _custAttrs;
    private List _props;
    private String _curdir;
    private String _textAs;
    private AnnotationMap _annots;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ComponentDefinitionImpl(LanguageDefinition langdef, PageDefinition pgdef, String name, Class cls) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (cls != null && !Component.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(cls + " must implement " + Component.class);
        }
        if (langdef != null && pgdef != null) {
            throw new IllegalArgumentException("langdef and pgdef cannot both null or both non-null");
        }
        this._langdef = langdef;
        this._pgdef = pgdef;
        this._name = name;
        this._implcls = cls;
        this._evalr = this._langdef != null ? this._langdef.getEvaluatorRef() : (this._pgdef != null ? this._pgdef.getEvaluatorRef() : null);
    }

    public static final ComponentDefinition newMacroDefinition(LanguageDefinition langdef, PageDefinition pgdef, String name, Class cls, String macroURI, boolean inline) {
        return new MacroDefinition(langdef, pgdef, name, cls, macroURI, inline);
    }

    public static final ComponentDefinition newNativeDefinition(LanguageDefinition langdef, String name, Class cls) {
        return new NativeDefinition(langdef, name, cls);
    }

    public void addCustomAttribute(String name, String value) {
        if (name == null || value == null || name.length() == 0 || value.length() == 0) {
            throw new IllegalArgumentException();
        }
        ExValue ev = new ExValue(value, Object.class);
        if (this._custAttrs == null) {
            this._custAttrs = new HashMap(4);
        }
        this._custAttrs.put(name, ev);
    }

    public void addAnnotation(String annotName, Map annotAttrs) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(annotName, annotAttrs);
    }

    public void addAnnotation(String propName, String annotName, Map annotAttrs) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(propName, annotName, annotAttrs);
    }

    public String getCurrentDirectory() {
        return this._curdir;
    }

    public void setCurrentDirectory(String curdir) {
        this._curdir = curdir != null && curdir.length() > 0 ? (curdir.charAt(curdir.length() - 1) != '/' ? curdir + '/' : curdir) : null;
    }

    public void setTextAs(String propnm) {
        this._textAs = propnm != null && propnm.length() > 0 ? propnm : null;
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    public String getName() {
        return this._name;
    }

    public String getTextAs() {
        return this._textAs;
    }

    public boolean isMacro() {
        return false;
    }

    public String getMacroURI() {
        return null;
    }

    public boolean isInlineMacro() {
        return false;
    }

    public boolean isNative() {
        return false;
    }

    public Object getImplementationClass() {
        return this._implcls;
    }

    public void setImplementationClass(Class cls) {
        if (!Component.class.isAssignableFrom(cls)) {
            throw new UiException(Component.class.getName() + " must be implemented by " + cls);
        }
        this._implcls = cls;
    }

    public void setImplementationClass(String clsnm) {
        if (clsnm == null || clsnm.length() == 0) {
            throw new UiException("Non-empty class name is required");
        }
        this._implcls = clsnm;
    }

    public Component newInstance(Page page, String clsnm) {
        try {
            return this.newInstance(this.resolveImplementationClass(page, clsnm));
        }
        catch (ClassNotFoundException ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public Component newInstance(Class cls) {
        Component comp;
        boolean bSet;
        Object curInfo = ComponentsCtrl.getCurrentInfo();
        boolean bl = bSet = !(curInfo instanceof ComponentInfo) || ((ComponentInfo)curInfo).getComponentDefinition() != this;
        if (bSet) {
            ComponentsCtrl.setCurrentInfo(this);
        }
        try {
            comp = (Component)cls.newInstance();
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            if (bSet) {
                ComponentsCtrl.setCurrentInfo((ComponentDefinition)null);
            }
        }
        return comp;
    }

    public boolean isInstance(Component comp) {
        Class cls;
        if (this._implcls instanceof String) {
            Page page = comp.getPage();
            if (page != null) {
                try {
                    cls = this.resolveImplementationClass(page, null);
                }
                catch (ClassNotFoundException ex) {
                    return true;
                }
            } else {
                try {
                    cls = Classes.forNameByThread((String)((String)this._implcls));
                }
                catch (ClassNotFoundException ex) {
                    return true;
                }
            }
        } else {
            cls = (Class)this._implcls;
        }
        return cls.isInstance(comp);
    }

    public Class resolveImplementationClass(Page page, String clsnm) throws ClassNotFoundException {
        Object cls;
        Object object = cls = clsnm != null ? clsnm : this._implcls;
        if (cls instanceof String) {
            clsnm = (String)cls;
            try {
                Class found = Classes.forNameByThread((String)clsnm);
                if (clsnm == null) {
                    this._implcls = found;
                }
                return found;
            }
            catch (ClassNotFoundException ex) {
                if (page != null) {
                    Iterator it = page.getLoadedInterpreters().iterator();
                    while (it.hasNext()) {
                        Class c = ((Interpreter)it.next()).getClass(clsnm);
                        if (c == null) continue;
                        return c;
                    }
                }
                throw ex;
            }
        }
        return (Class)cls;
    }

    public AnnotationMap getAnnotationMap() {
        return this._annots;
    }

    public void addProperty(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        Property prop = new Property(this._evalr, name, value, null);
        if (this._props == null) {
            this._props = new LinkedList();
        }
        this._props.add(prop);
    }

    public void applyProperties(Component comp) {
        Iterator it;
        if (this._custAttrs != null) {
            it = this._custAttrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                comp.setAttribute((String)me.getKey(), ((ExValue)me.getValue()).getValue((Evaluator)this._evalr, comp));
            }
        }
        if (this._props != null) {
            it = this._props.iterator();
            while (it.hasNext()) {
                Property prop = (Property)((Object)it.next());
                prop.assign(comp);
            }
        }
    }

    public Map evalProperties(Map propmap, Page owner, Component parent) {
        if (propmap == null) {
            propmap = new HashMap<String, Object>();
        }
        if (this._props != null) {
            Iterator it = this._props.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                if (parent != null) {
                    if (!prop.isEffective(parent)) continue;
                    propmap.put(prop.getName(), prop.getValue(parent));
                    continue;
                }
                if (!prop.isEffective(owner)) continue;
                propmap.put(prop.getName(), prop.getValue(owner));
            }
        }
        return propmap;
    }

    public void addMold(String name, String moldURI) {
        if (moldURI.startsWith("class:")) {
            String clsnm = moldURI.substring(6);
            try {
                this.addMold(name, (ComponentRenderer)Classes.newInstanceByThread((String)clsnm));
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Failed to instantiate " + clsnm);
            }
        } else {
            if (moldURI.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.addMold0(name, new ExValue(moldURI, String.class));
        }
    }

    public void addMold(String name, ComponentRenderer renderer) {
        this.addMold0(name, renderer);
    }

    private void addMold0(String name, Object mold) {
        if (name == null || name.length() == 0 || mold == null) {
            throw new IllegalArgumentException();
        }
        if (this._molds == null) {
            this._molds = new HashMap(4);
        }
        this._molds.put(name, mold);
    }

    public Object getMoldURI(Component comp, String name) {
        Object o = this._molds.get(name);
        if (o instanceof ExValue) {
            ExValue mold = this._molds != null ? (ExValue)o : null;
            return mold == null ? null : this.toAbsoluteURI((String)mold.getValue((Evaluator)this._evalr, comp));
        }
        return o;
    }

    public boolean hasMold(String name) {
        return this._molds != null && this._molds.containsKey(name);
    }

    public Collection getMoldNames() {
        return this._molds != null ? this._molds.keySet() : Collections.EMPTY_LIST;
    }

    private String toAbsoluteURI(String uri) {
        char cc;
        if (this._curdir != null && uri != null && uri.length() > 0 && (cc = uri.charAt(0)) != '/' && cc != '~' && !Servlets.isUniversalURL((String)uri)) {
            return this._curdir + uri;
        }
        return uri;
    }

    public ComponentDefinition clone(LanguageDefinition langdef, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        ComponentDefinitionImpl cd = (ComponentDefinitionImpl)this.clone();
        cd._name = name;
        cd._langdef = langdef;
        return cd;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this._langdef != null ? this._langdef.getName() : null);
        Iterator it = this._molds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            s.writeObject(me.getKey());
            Object o = me.getValue();
            if (o instanceof Serializable || o instanceof Externalizable) {
                s.writeObject(o);
                continue;
            }
            if (!$assertionsDisabled && !(o instanceof ComponentRenderer)) {
                throw new AssertionError((Object)("Unexpected " + o));
            }
            s.writeObject(o.getClass());
        }
        s.writeObject(null);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object nm;
        s.defaultReadObject();
        String langnm = (String)s.readObject();
        if (langnm != null) {
            this._langdef = LanguageDefinition.lookup(langnm);
        }
        this._molds = new HashMap(4);
        while ((nm = s.readObject()) != null) {
            Object val = s.readObject();
            if (val instanceof Class) {
                try {
                    val = ((Class)val).newInstance();
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            this._molds.put(nm, val);
        }
    }

    public String toString() {
        return "[ComponentDefinition: " + this._name + ']';
    }

    public Object clone() {
        ComponentDefinitionImpl compdef;
        try {
            compdef = (ComponentDefinitionImpl)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (this._annots != null) {
            compdef._annots = (AnnotationMap)this._annots.clone();
        }
        if (this._props != null) {
            compdef._props = new LinkedList(this._props);
        }
        if (this._molds != null) {
            compdef._molds = new HashMap(this._molds);
        }
        if (this._custAttrs != null) {
            compdef._custAttrs = new HashMap(this._custAttrs);
        }
        return compdef;
    }

    static {
        $assertionsDisabled = !ComponentDefinitionImpl.class.desiredAssertionStatus();
    }
}

