/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.render;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zk.ui.Component;

public final class SmartWriter {
    private static final String LF = "\n";
    private final Writer _w;

    public SmartWriter(Writer writer) {
        this._w = writer;
    }

    public void close() throws IOException {
        this._w.close();
    }

    public void flush() throws IOException {
        this._w.flush();
    }

    public SmartWriter write(Component comp) throws IOException {
        if (comp != null) {
            comp.redraw(this._w);
        }
        return this;
    }

    public SmartWriter writeln(Component comp) throws IOException {
        return this.write(comp).write(LF);
    }

    public SmartWriter writeChildren(Component comp) throws IOException {
        return this.writeComponents(comp.getChildren());
    }

    public SmartWriter writeChildren(Component comp, int from, int to) throws IOException {
        return this.writeComponents(comp.getChildren(), from, to);
    }

    public SmartWriter writeComponents(Collection comps) throws IOException {
        Iterator it = comps.iterator();
        while (it.hasNext()) {
            ((Component)it.next()).redraw(this._w);
        }
        return this;
    }

    public SmartWriter writeComponents(List comps, int from, int to) throws IOException {
        if (from < comps.size()) {
            ListIterator it = comps.listIterator(from);
            int cnt = to - from + 1;
            while (it.hasNext() && --cnt >= 0) {
                ((Component)it.next()).redraw(this._w);
            }
        }
        return this;
    }

    public SmartWriter write(String str) throws IOException {
        if (str != null) {
            this._w.write(str);
        }
        return this;
    }

    public SmartWriter writeln() throws IOException {
        this._w.write(LF);
        return this;
    }

    public SmartWriter writeln(String str) throws IOException {
        if (str != null) {
            this._w.write(str);
            this._w.write(LF);
        }
        return this;
    }

    public SmartWriter write(String str, boolean trim) throws IOException {
        if (str != null) {
            this._w.write(trim ? str.trim() : str);
        }
        return this;
    }

    public SmartWriter writeln(String str, boolean trim) throws IOException {
        if (str != null) {
            this._w.write(trim ? str.trim() : str);
            this._w.write(LF);
        }
        return this;
    }

    public SmartWriter write(boolean b) throws IOException {
        this._w.write(Boolean.toString(b));
        return this;
    }

    public SmartWriter write(char c) throws IOException {
        this._w.write(Character.toString(c));
        return this;
    }

    public SmartWriter writeln(char c) throws IOException {
        this._w.write(Character.toString(c));
        this._w.write(LF);
        return this;
    }

    public SmartWriter write(byte v) throws IOException {
        this._w.write(Byte.toString(v));
        return this;
    }

    public SmartWriter write(short v) throws IOException {
        this._w.write(Short.toString(v));
        return this;
    }

    public SmartWriter write(int v) throws IOException {
        this._w.write(Integer.toString(v));
        return this;
    }

    public SmartWriter write(float v) throws IOException {
        this._w.write(Float.toString(v));
        return this;
    }

    public SmartWriter write(double v) throws IOException {
        this._w.write(Double.toString(v));
        return this;
    }

    public SmartWriter writeAttr(String name, Object val) throws IOException {
        if (!(val == null || val instanceof String && ((String)val).length() == 0)) {
            return this.write(" ").write(name).write("=\"").write(val.toString()).write("\"");
        }
        return this;
    }
}

