/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.Cache;
import org.zkoss.util.Maps;
import org.zkoss.util.Pair;
import org.zkoss.util.ThreadLocalCache;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.render.ComponentRenderer;

public class ComponentsCtrl {
    private static final String AUTO_ID_PREFIX = "z_";
    public static final String ANONYMOUS_ID = "z__i";
    private static final ThreadLocal _compdef = new ThreadLocal();
    private static Cache _evtmtds = new ThreadLocalCache();
    public static final ComponentDefinition DUMMY = new ComponentDefinition(){

        public LanguageDefinition getLanguageDefinition() {
            return null;
        }

        public String getName() {
            return "[anonymous]";
        }

        public String getTextAs() {
            return null;
        }

        public boolean isMacro() {
            return false;
        }

        public String getMacroURI() {
            return null;
        }

        public boolean isInlineMacro() {
            return false;
        }

        public boolean isNative() {
            return false;
        }

        public Object getImplementationClass() {
            return class$org$zkoss$zk$ui$Component == null ? (class$org$zkoss$zk$ui$Component = ComponentsCtrl.class$("org.zkoss.zk.ui.Component")) : class$org$zkoss$zk$ui$Component;
        }

        public void setImplementationClass(Class cls) {
            throw new UnsupportedOperationException();
        }

        public void setImplementationClass(String clsnm) {
            throw new UnsupportedOperationException();
        }

        public Class resolveImplementationClass(Page page, String clsnm) throws ClassNotFoundException {
            return class$org$zkoss$zk$ui$Component == null ? (class$org$zkoss$zk$ui$Component = ComponentsCtrl.class$("org.zkoss.zk.ui.Component")) : class$org$zkoss$zk$ui$Component;
        }

        public boolean isInstance(Component comp) {
            return comp != null;
        }

        public Component newInstance(Page page, String clsnm) {
            throw new UnsupportedOperationException();
        }

        public Component newInstance(Class cls) {
            throw new UnsupportedOperationException();
        }

        public void addMold(String name, String moldURI) {
            throw new UnsupportedOperationException();
        }

        public void addMold(String name, ComponentRenderer renderer) {
            throw new UnsupportedOperationException();
        }

        public Object getMoldURI(Component comp, String name) {
            return null;
        }

        public boolean hasMold(String name) {
            return false;
        }

        public Collection getMoldNames() {
            return Collections.EMPTY_LIST;
        }

        public void addProperty(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void applyProperties(Component comp) {
        }

        public Map evalProperties(Map propmap, Page owner, Component parent) {
            return propmap != null ? propmap : new HashMap(3);
        }

        public AnnotationMap getAnnotationMap() {
            return null;
        }

        public ComponentDefinition clone(LanguageDefinition langdef, String name) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }
    };
    static /* synthetic */ Class class$org$zkoss$zk$ui$Component;

    public static final String toAutoId(String prefix, int id) {
        StringBuffer sb = new StringBuffer(16).append(AUTO_ID_PREFIX).append(prefix).append('_');
        Strings.encode((StringBuffer)sb, (int)id);
        return sb.toString();
    }

    public static final String getAnonymousId() {
        return ANONYMOUS_ID;
    }

    public static final boolean isAutoId(String id) {
        return id.startsWith(AUTO_ID_PREFIX) && id.indexOf(95, AUTO_ID_PREFIX.length()) > 0;
    }

    public static final boolean isUuid(String id) {
        return ComponentsCtrl.isAutoId(id);
    }

    public static final boolean isReservedAttribute(String name) {
        return name != null && !"use".equals(name) && !"if".equals(name) && !"unless".equals(name) && !"apply".equals(name) && !"forEach".equals(name);
    }

    public static final Object getCurrentInfo() {
        return _compdef.get();
    }

    public static final void setCurrentInfo(ComponentDefinition compdef) {
        _compdef.set(compdef);
    }

    public static void setCurrentInfo(ComponentInfo compInfo) {
        _compdef.set(compInfo);
    }

    public static Object[] parseEventExpression(Component comp, String evtexpr, Component defaultComp, boolean deferred) throws ComponentNotFoundException {
        Object target;
        String evtnm;
        int j = evtexpr.lastIndexOf(46);
        if (j >= 0) {
            evtnm = evtexpr.substring(j + 1).trim();
            String path = evtexpr.substring(0, j);
            if (path.length() > 0) {
                target = null;
                if (path.indexOf("${") >= 0) {
                    Object v = Executions.evaluate(comp, path, Object.class);
                    if (v instanceof Component) {
                        target = (Component)v;
                    } else {
                        if (v == null) {
                            throw new ComponentNotFoundException("EL evaluated to null: " + path);
                        }
                        path = Objects.toString((Object)v);
                    }
                }
                if (target == null) {
                    if ("self".equals(path = path.trim())) {
                        path = ".";
                    }
                    target = deferred ? path : (".".equals(path) ? comp : Path.getComponent(comp.getSpaceOwner(), path));
                }
            } else {
                target = defaultComp;
            }
        } else {
            evtnm = evtexpr.trim();
            target = defaultComp;
        }
        if (!Events.isValid(evtnm)) {
            throw new UiException("Not an event name: " + evtnm);
        }
        return new Object[]{target, evtnm};
    }

    public static final void applyForward(Component comp, String forward) {
        if (forward == null) {
            return;
        }
        LinkedHashMap fwds = new LinkedHashMap();
        Maps.parse(fwds, (String)forward, (char)',', (char)'\'', (boolean)true);
        Iterator it = fwds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String orgEvent = (String)me.getKey();
            if (orgEvent != null && !Events.isValid(orgEvent)) {
                throw new UiException("Not an event name: " + orgEvent);
            }
            Object[] result = ComponentsCtrl.parseEventExpression(comp, (String)me.getValue(), null, true);
            Object target = result[0];
            if (target instanceof String) {
                comp.addForward(orgEvent, (String)target, (String)result[1]);
                continue;
            }
            comp.addForward(orgEvent, (Component)target, (String)result[1]);
        }
    }

    public static String parseClientScript(Component comp, String script) {
        StringBuffer sb = null;
        int j = 0;
        int len = script.length();
        int k;
        while ((k = script.indexOf("#{", j)) >= 0) {
            int l = script.indexOf(125, k + 2);
            if (l < 0) {
                throw new WrongValueException("Illegal script: unclosed EL expression.\n" + script);
            }
            if (sb == null) {
                sb = new StringBuffer(len);
            }
            sb.append(script.substring(j, k));
            Object val = Executions.evaluate(comp, '$' + script.substring(k + 1, l + 1), class$java$lang$Object == null ? ComponentsCtrl.class$("java.lang.Object") : class$java$lang$Object);
            if (val == null || val instanceof Number) {
                sb.append(val);
            } else if (val instanceof Component) {
                sb.append(" $e('").append(Strings.escape((String)((Component)val).getUuid(), (String)"'\\")).append("')");
            } else if (val instanceof Date) {
                sb.append(" new Date(").append(((Date)val).getTime()).append(')');
            } else {
                sb.append('\'').append(Strings.escape((String)val.toString(), (String)"'\\")).append('\'');
            }
            j = l + 1;
        }
        return sb != null ? sb.append(script.substring(j)).toString() : script;
    }

    public static final Method getEventMethod(Class cls, String evtnm) {
        Pair key = new Pair((Object)cls, (Object)evtnm);
        Object o = _evtmtds.get((Object)key);
        if (o != null) {
            return o == Objects.UNKNOWN ? null : (Method)o;
        }
        Method mtd = null;
        try {
            mtd = Classes.getCloseMethodBySubclass((Class)cls, (String)evtnm, (Class[])new Class[]{Event.class});
        }
        catch (NoSuchMethodException ex) {
            try {
                mtd = cls.getMethod(evtnm, null);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        _evtmtds.put((Object)key, mtd != null ? mtd : Objects.UNKNOWN);
        return mtd;
    }

    public static final void setEventMethodCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        _evtmtds = cache;
    }
}

