/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.Expressions;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.event.EventThreadSuspend;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.RichletConfigImpl;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.PerformanceMeter;
import org.zkoss.zk.ui.util.RequestInterceptor;
import org.zkoss.zk.ui.util.SessionCleanup;
import org.zkoss.zk.ui.util.SessionInit;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zk.ui.util.URIInterceptor;
import org.zkoss.zk.ui.util.WebAppCleanup;
import org.zkoss.zk.ui.util.WebAppInit;

public class Configuration {
    private static final Log log = Log.lookup((Class)Configuration.class);
    private static final String PROP_EXPRESS_FACTORY = "org.zkoss.xel.ExpressionFactory.class";
    private WebApp _wapp;
    private final List _evtInits = new LinkedList();
    private final List _evtCleans = new LinkedList();
    private final List _evtSusps = new LinkedList();
    private final List _evtResus = new LinkedList();
    private final List _appInits = new LinkedList();
    private final List _appCleans = new LinkedList();
    private final List _sessInits = new LinkedList();
    private final List _sessCleans = new LinkedList();
    private final List _dtInits = new LinkedList();
    private final List _dtCleans = new LinkedList();
    private final List _execInits = new LinkedList();
    private final List _execCleans = new LinkedList();
    private final List _uriIntcps = new LinkedList();
    private final List _reqIntcps = new LinkedList();
    private final Map _prefs = Collections.synchronizedMap(new HashMap());
    private final Map _errURIs = Collections.synchronizedMap(new HashMap());
    private final Map _richlets = new HashMap();
    private final Map _richletmaps = new HashMap();
    private final Map _errpgs = new HashMap(3);
    private Monitor _monitor;
    private PerformanceMeter _pfmeter;
    private final List _themeURIs = new LinkedList();
    private transient String[] _roThemeURIs = new String[0];
    private ThemeProvider _themeProvider;
    private Set _disThemeURIs;
    private Class _wappcls;
    private Class _uiengcls;
    private Class _dcpcls;
    private Class _uiftycls;
    private Class _failmancls;
    private Class _idgencls;
    private int _dtTimeout = 3600;
    private int _sessDktMax = 15;
    private int _sessReqMax = 5;
    private int _sessTimeout = 0;
    private int _sparThdMax = 100;
    private int _suspThdMax = -1;
    private int _maxUploadSize = 5120;
    private int _maxProcTime = 3000;
    private int _promptDelay = 900;
    private int _tooltipDelay = 800;
    private int _resendDelay = 9000;
    private String _charsetResp = "UTF-8";
    private String _charsetUpload = "UTF-8";
    private CharsetFinder _charsetFinderUpload;
    private final EventInterceptors _eis = new EventInterceptors();
    private boolean _useEvtThd = true;
    private boolean _keepDesktop;
    private boolean _disableBehindModal = true;
    private boolean _timerKeepAlive;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Component;
    static /* synthetic */ Class class$org$zkoss$zk$ui$event$Event;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Session;
    static /* synthetic */ Class class$org$zkoss$zk$ui$Desktop;

    public Configuration() {
        this._errURIs.put(new Integer(302), "");
        this._errURIs.put(new Integer(401), "");
        this._errURIs.put(new Integer(403), "");
    }

    public WebApp getWebApp() {
        return this._wapp;
    }

    public void setWebApp(WebApp wapp) {
        this._wapp = wapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Class klass) throws Exception {
        List list;
        Object obj;
        List list2;
        boolean added = false;
        if (Monitor.class.isAssignableFrom(klass)) {
            if (this._monitor != null) {
                throw new UiException("Monitor listener can be assigned only once");
            }
            this._monitor = (Monitor)klass.newInstance();
            added = true;
        }
        if (PerformanceMeter.class.isAssignableFrom(klass)) {
            if (this._pfmeter != null) {
                throw new UiException("PerformanceMeter listener can be assigned only once");
            }
            this._pfmeter = (PerformanceMeter)klass.newInstance();
            added = true;
        }
        if (EventThreadInit.class.isAssignableFrom(klass)) {
            list2 = this._evtInits;
            synchronized (list2) {
                this._evtInits.add(klass);
            }
            added = true;
        }
        if (EventThreadCleanup.class.isAssignableFrom(klass)) {
            list2 = this._evtCleans;
            synchronized (list2) {
                this._evtCleans.add(klass);
            }
            added = true;
        }
        if (EventThreadSuspend.class.isAssignableFrom(klass)) {
            list2 = this._evtSusps;
            synchronized (list2) {
                this._evtSusps.add(klass);
            }
            added = true;
        }
        if (EventThreadResume.class.isAssignableFrom(klass)) {
            list2 = this._evtResus;
            synchronized (list2) {
                this._evtResus.add(klass);
            }
            added = true;
        }
        if (WebAppInit.class.isAssignableFrom(klass)) {
            list2 = this._appInits;
            synchronized (list2) {
                this._appInits.add(klass);
            }
            added = true;
        }
        if (WebAppCleanup.class.isAssignableFrom(klass)) {
            list2 = this._appCleans;
            synchronized (list2) {
                this._appCleans.add(klass);
            }
            added = true;
        }
        if (SessionInit.class.isAssignableFrom(klass)) {
            list2 = this._sessInits;
            synchronized (list2) {
                this._sessInits.add(klass);
            }
            added = true;
        }
        if (SessionCleanup.class.isAssignableFrom(klass)) {
            list2 = this._sessCleans;
            synchronized (list2) {
                this._sessCleans.add(klass);
            }
            added = true;
        }
        if (DesktopInit.class.isAssignableFrom(klass)) {
            list2 = this._dtInits;
            synchronized (list2) {
                this._dtInits.add(klass);
            }
            added = true;
        }
        if (DesktopCleanup.class.isAssignableFrom(klass)) {
            list2 = this._dtCleans;
            synchronized (list2) {
                this._dtCleans.add(klass);
            }
            added = true;
        }
        if (ExecutionInit.class.isAssignableFrom(klass)) {
            list2 = this._execInits;
            synchronized (list2) {
                this._execInits.add(klass);
            }
            added = true;
        }
        if (ExecutionCleanup.class.isAssignableFrom(klass)) {
            list2 = this._execCleans;
            synchronized (list2) {
                this._execCleans.add(klass);
            }
            added = true;
        }
        if (URIInterceptor.class.isAssignableFrom(klass)) {
            try {
                obj = klass.newInstance();
                list = this._uriIntcps;
                synchronized (list) {
                    this._uriIntcps.add(obj);
                }
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (RequestInterceptor.class.isAssignableFrom(klass)) {
            try {
                obj = klass.newInstance();
                list = this._reqIntcps;
                synchronized (list) {
                    this._reqIntcps.add(obj);
                }
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (EventInterceptor.class.isAssignableFrom(klass)) {
            try {
                this._eis.addEventInterceptor((EventInterceptor)klass.newInstance());
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (!added) {
            throw new UiException("Unknown listener: " + klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Class klass) {
        Object obj;
        Iterator it;
        List list = this._evtInits;
        synchronized (list) {
            this._evtInits.remove(klass);
        }
        list = this._evtCleans;
        synchronized (list) {
            this._evtCleans.remove(klass);
        }
        list = this._evtSusps;
        synchronized (list) {
            this._evtSusps.remove(klass);
        }
        list = this._evtResus;
        synchronized (list) {
            this._evtResus.remove(klass);
        }
        list = this._appInits;
        synchronized (list) {
            this._appInits.remove(klass);
        }
        list = this._appCleans;
        synchronized (list) {
            this._appCleans.remove(klass);
        }
        list = this._sessInits;
        synchronized (list) {
            this._sessInits.remove(klass);
        }
        list = this._sessCleans;
        synchronized (list) {
            this._sessCleans.remove(klass);
        }
        list = this._dtInits;
        synchronized (list) {
            this._dtInits.remove(klass);
        }
        list = this._dtCleans;
        synchronized (list) {
            this._dtCleans.remove(klass);
        }
        list = this._execInits;
        synchronized (list) {
            this._execInits.remove(klass);
        }
        list = this._execCleans;
        synchronized (list) {
            this._execCleans.remove(klass);
        }
        list = this._uriIntcps;
        synchronized (list) {
            it = this._uriIntcps.iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!obj.getClass().equals(klass)) continue;
                it.remove();
            }
        }
        list = this._reqIntcps;
        synchronized (list) {
            it = this._reqIntcps.iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!obj.getClass().equals(klass)) continue;
                it.remove();
            }
        }
        this._eis.removeEventInterceptor(klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List newEventThreadInits(Component comp, Event evt) throws UiException {
        if (this._evtInits.isEmpty()) {
            return null;
        }
        LinkedList<EventThreadInit> inits = new LinkedList<EventThreadInit>();
        List list = this._evtInits;
        synchronized (list) {
            Iterator it = this._evtInits.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    EventThreadInit init = (EventThreadInit)klass.newInstance();
                    init.prepare(comp, evt);
                    inits.add(init);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
        return inits;
    }

    public boolean invokeEventThreadInits(List inits, Component comp, Event evt) throws UiException {
        if (inits == null || inits.isEmpty()) {
            return true;
        }
        Iterator it = inits.iterator();
        while (it.hasNext()) {
            EventThreadInit fn = (EventThreadInit)it.next();
            try {
                try {
                    if (fn.init(comp, evt)) continue;
                    return false;
                }
                catch (AbstractMethodError ex) {
                    fn.getClass().getMethod("init", class$org$zkoss$zk$ui$Component == null ? Configuration.class$("org.zkoss.zk.ui.Component") : class$org$zkoss$zk$ui$Component, class$org$zkoss$zk$ui$event$Event == null ? Configuration.class$("org.zkoss.zk.ui.event.Event") : class$org$zkoss$zk$ui$event$Event).invoke((Object)fn, comp, evt);
                }
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List newEventThreadCleanups(Component comp, Event evt, List errs) {
        if (this._evtCleans.isEmpty()) {
            return null;
        }
        LinkedList<EventThreadCleanup> cleanups = new LinkedList<EventThreadCleanup>();
        List list = this._evtCleans;
        synchronized (list) {
            Iterator it = this._evtCleans.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    EventThreadCleanup cleanup = (EventThreadCleanup)klass.newInstance();
                    cleanup.cleanup(comp, evt, errs);
                    cleanups.add(cleanup);
                }
                catch (Throwable t) {
                    if (errs != null) {
                        errs.add(t);
                    }
                    log.error("Failed to invoke " + klass, t);
                }
            }
        }
        return cleanups;
    }

    public void invokeEventThreadCompletes(List cleanups, Component comp, Event evt, List errs) {
        if (cleanups == null || cleanups.isEmpty()) {
            return;
        }
        Iterator it = cleanups.iterator();
        while (it.hasNext()) {
            EventThreadCleanup fn = (EventThreadCleanup)it.next();
            try {
                fn.complete(comp, evt);
            }
            catch (Throwable ex) {
                if (errs != null) {
                    errs.add(ex);
                }
                log.error("Failed to invoke " + fn, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List newEventThreadSuspends(Component comp, Event evt, Object obj) {
        if (this._evtSusps.isEmpty()) {
            return null;
        }
        LinkedList<EventThreadSuspend> suspends = new LinkedList<EventThreadSuspend>();
        List list = this._evtSusps;
        synchronized (list) {
            Iterator it = this._evtSusps.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    EventThreadSuspend suspend = (EventThreadSuspend)klass.newInstance();
                    suspend.beforeSuspend(comp, evt, obj);
                    suspends.add(suspend);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
        return suspends;
    }

    public void invokeEventThreadSuspends(List suspends, Component comp, Event evt) throws UiException {
        if (suspends == null || suspends.isEmpty()) {
            return;
        }
        Iterator it = suspends.iterator();
        while (it.hasNext()) {
            EventThreadSuspend fn = (EventThreadSuspend)it.next();
            try {
                fn.afterSuspend(comp, evt);
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + fn + " after suspended", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List newEventThreadResumes(Component comp, Event evt) throws UiException {
        if (this._evtResus.isEmpty()) {
            return null;
        }
        LinkedList<EventThreadResume> resumes = new LinkedList<EventThreadResume>();
        List list = this._evtResus;
        synchronized (list) {
            Iterator it = this._evtResus.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    EventThreadResume resume = (EventThreadResume)klass.newInstance();
                    resume.beforeResume(comp, evt);
                    resumes.add(resume);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
        return resumes;
    }

    public void invokeEventThreadResumes(List resumes, Component comp, Event evt) throws UiException {
        if (resumes == null || resumes.isEmpty()) {
            return;
        }
        Iterator it = resumes.iterator();
        while (it.hasNext()) {
            EventThreadResume fn = (EventThreadResume)it.next();
            try {
                fn.afterResume(comp, evt);
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEventThreadResumeAborts(Component comp, Event evt) {
        if (this._evtResus.isEmpty()) {
            return;
        }
        List list = this._evtResus;
        synchronized (list) {
            Iterator it = this._evtResus.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((EventThreadResume)klass.newInstance()).abortResume(comp, evt);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass + " for aborting", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeWebAppInits() throws UiException {
        if (this._appInits.isEmpty()) {
            return;
        }
        List list = this._appInits;
        synchronized (list) {
            Iterator it = this._appInits.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((WebAppInit)klass.newInstance()).init(this._wapp);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeWebAppCleanups() {
        if (this._appCleans.isEmpty()) {
            return;
        }
        List list = this._appCleans;
        synchronized (list) {
            Iterator it = this._appCleans.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((WebAppCleanup)klass.newInstance()).cleanup(this._wapp);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeSessionInits(Session sess, Object request) throws UiException {
        if (this._sessInits.isEmpty()) {
            return;
        }
        List list = this._sessInits;
        synchronized (list) {
            Iterator it = this._sessInits.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    SessionInit fn = (SessionInit)klass.newInstance();
                    try {
                        fn.init(sess, request);
                    }
                    catch (AbstractMethodError ex) {
                        klass.getMethod("init", class$org$zkoss$zk$ui$Session == null ? Configuration.class$("org.zkoss.zk.ui.Session") : class$org$zkoss$zk$ui$Session).invoke((Object)fn, sess);
                    }
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeSessionCleanups(Session sess) {
        if (this._sessCleans.isEmpty()) {
            return;
        }
        List list = this._sessCleans;
        synchronized (list) {
            Iterator it = this._sessCleans.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((SessionCleanup)klass.newInstance()).cleanup(sess);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeDesktopInits(Desktop desktop, Object request) throws UiException {
        if (this._dtInits.isEmpty()) {
            return;
        }
        List list = this._dtInits;
        synchronized (list) {
            Iterator it = this._dtInits.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    DesktopInit fn = (DesktopInit)klass.newInstance();
                    try {
                        fn.init(desktop, request);
                    }
                    catch (AbstractMethodError ex) {
                        klass.getMethod("init", class$org$zkoss$zk$ui$Desktop == null ? Configuration.class$("org.zkoss.zk.ui.Desktop") : class$org$zkoss$zk$ui$Desktop).invoke((Object)fn, desktop);
                    }
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeDesktopCleanups(Desktop desktop) {
        if (this._dtCleans.isEmpty()) {
            return;
        }
        List list = this._dtCleans;
        synchronized (list) {
            Iterator it = this._dtCleans.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((DesktopCleanup)klass.newInstance()).cleanup(desktop);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeExecutionInits(Execution exec, Execution parent) throws UiException {
        if (this._execInits.isEmpty()) {
            return;
        }
        List list = this._execInits;
        synchronized (list) {
            Iterator it = this._execInits.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((ExecutionInit)klass.newInstance()).init(exec, parent);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeExecutionCleanups(Execution exec, Execution parent, List errs) {
        if (this._execCleans.isEmpty()) {
            return;
        }
        List list = this._execCleans;
        synchronized (list) {
            Iterator it = this._execCleans.iterator();
            while (it.hasNext()) {
                Class klass = (Class)it.next();
                try {
                    ((ExecutionCleanup)klass.newInstance()).cleanup(exec, parent, errs);
                }
                catch (Throwable ex) {
                    log.error("Failed to invoke " + klass, ex);
                    if (errs == null) continue;
                    errs.add(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeURIInterceptors(String uri) {
        if (this._uriIntcps.isEmpty()) {
            return;
        }
        List list = this._uriIntcps;
        synchronized (list) {
            Iterator it = this._uriIntcps.iterator();
            while (it.hasNext()) {
                try {
                    ((URIInterceptor)it.next()).request(uri);
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRequestInterceptors(Session sess, Object request, Object response) {
        if (this._reqIntcps.isEmpty()) {
            return;
        }
        List list = this._reqIntcps;
        synchronized (list) {
            Iterator it = this._reqIntcps.iterator();
            while (it.hasNext()) {
                try {
                    ((RequestInterceptor)it.next()).request(sess, request, response);
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        List list = this._themeURIs;
        synchronized (list) {
            this._themeURIs.add(uri);
            this._roThemeURIs = this._themeURIs.toArray(new String[this._themeURIs.size()]);
        }
    }

    public String[] getThemeURIs() {
        return this._roThemeURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisabledThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException();
        }
        Configuration configuration = this;
        synchronized (configuration) {
            if (this._disThemeURIs == null) {
                this._disThemeURIs = Collections.synchronizedSet(new HashSet(4));
            }
        }
        this._disThemeURIs.add(uri);
    }

    public Set getDisabledThemeURIs() {
        return this._disThemeURIs != null ? this._disThemeURIs : Collections.EMPTY_SET;
    }

    public ThemeProvider getThemeProvider() {
        return this._themeProvider;
    }

    public void setThemeProvider(ThemeProvider provider) {
        this._themeProvider = provider;
    }

    public void setTimeoutURI(String uri) {
        Devices.setTimeoutURI("ajax", uri);
    }

    public String getTimeoutURI() {
        return Devices.getTimeoutURI("ajax");
    }

    public void setUiEngineClass(Class cls) {
        if (cls != null && !UiEngine.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiEngine not implemented: " + cls);
        }
        this._uiengcls = cls;
    }

    public Class getUiEngineClass() {
        return this._uiengcls;
    }

    public void setWebAppClass(Class cls) {
        if (!(cls == null || WebApp.class.isAssignableFrom(cls) && WebAppCtrl.class.isAssignableFrom(cls))) {
            throw new IllegalArgumentException("WebApp or WebAppCtrl not implemented: " + cls);
        }
        this._wappcls = cls;
    }

    public Class getWebAppClass() {
        return this._wappcls;
    }

    public void setDesktopCacheProviderClass(Class cls) {
        if (cls != null && !DesktopCacheProvider.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("DesktopCacheProvider not implemented: " + cls);
        }
        this._dcpcls = cls;
    }

    public Class getDesktopCacheProviderClass() {
        return this._dcpcls;
    }

    public void setUiFactoryClass(Class cls) {
        if (cls != null && !UiFactory.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiFactory not implemented: " + cls);
        }
        this._uiftycls = cls;
    }

    public Class getUiFactoryClass() {
        return this._uiftycls;
    }

    public void setFailoverManagerClass(Class cls) {
        if (cls != null && !FailoverManager.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("FailoverManager not implemented: " + cls);
        }
        this._failmancls = cls;
    }

    public Class getFailoverManagerClass() {
        return this._failmancls;
    }

    public void setIdGeneratorClass(Class cls) {
        if (cls != null && !IdGenerator.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("IdGenerator not implemented: " + cls);
        }
        this._idgencls = cls;
    }

    public Class getIdGeneratorClass() {
        return this._idgencls;
    }

    public void setMaxProcessTime(int time) {
        this._maxProcTime = time;
    }

    public int getMaxProcessTime() {
        return this._maxProcTime;
    }

    public void setMaxUploadSize(int sz) {
        this._maxUploadSize = sz;
    }

    public int getMaxUploadSize() {
        return this._maxUploadSize;
    }

    public String getUploadCharset() {
        return this._charsetUpload;
    }

    public void setUploadCharset(String charset) {
        this._charsetUpload = charset != null && charset.length() > 0 ? charset : "UTF-8";
    }

    public CharsetFinder getUploadCharsetFinder() {
        return this._charsetFinderUpload;
    }

    public void setUploadCharsetFinder(CharsetFinder finder) {
        this._charsetFinderUpload = finder;
    }

    public void setDesktopMaxInactiveInterval(int secs) {
        this._dtTimeout = secs;
    }

    public int getDesktopMaxInactiveInterval() {
        return this._dtTimeout;
    }

    public void setProcessingPromptDelay(int minisecs) {
        this._promptDelay = minisecs;
    }

    public int getProcessingPromptDelay() {
        return this._promptDelay;
    }

    public void setTooltipDelay(int minisecs) {
        this._tooltipDelay = minisecs;
    }

    public int getTooltipDelay() {
        return this._tooltipDelay;
    }

    public void setResendDelay(int minisecs) {
        this._resendDelay = minisecs;
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public String addClientErrorReload(int errCode, String uri) {
        if (uri == null) {
            return this.removeClientErrorReload(errCode);
        }
        return this._errURIs.put(new Integer(errCode), uri);
    }

    public String removeClientErrorReload(int errCode) {
        return (String)this._errURIs.remove(new Integer(errCode));
    }

    public String getClientErrorReload(int errCode) {
        return (String)this._errURIs.get(new Integer(errCode));
    }

    public int[] getClientErrorReloadCodes() {
        Set ks = this._errURIs.keySet();
        int[] cers = new int[ks.size()];
        int j = 0;
        Iterator it = ks.iterator();
        while (j < cers.length && it.hasNext()) {
            cers[j++] = (Integer)it.next();
        }
        return cers;
    }

    public void setSessionMaxInactiveInterval(int secs) {
        this._sessTimeout = secs;
    }

    public int getSessionMaxInactiveInterval() {
        return this._sessTimeout;
    }

    public void setSessionMaxDesktops(int max) {
        this._sessDktMax = max;
    }

    public void setMaxDesktops(int max) {
        this.setSessionMaxDesktops(max);
    }

    public int getSessionMaxDesktops() {
        return this._sessDktMax;
    }

    public int getMaxDesktops() {
        return this.getSessionMaxDesktops();
    }

    public void setSessionMaxRequests(int max) {
        this._sessReqMax = max;
    }

    public int getSessionMaxRequests() {
        return this._sessReqMax;
    }

    public void setMaxSpareThreads(int max) {
        this._sparThdMax = max;
    }

    public int getMaxSpareThreads() {
        return this._sparThdMax;
    }

    public void setMaxSuspendedThreads(int max) {
        this._suspThdMax = max;
    }

    public int getMaxSuspendedThreads() {
        return this._suspThdMax;
    }

    public void enableEventThread(boolean enable) {
        UiEngine engine;
        if (!enable && this._wapp != null && (engine = ((WebAppCtrl)((Object)this._wapp)).getUiEngine()) != null && engine.hasSuspendedThread()) {
            throw new IllegalStateException("Unable to disable due to suspended threads");
        }
        this._useEvtThd = enable;
    }

    public boolean isEventThreadEnabled() {
        return this._useEvtThd;
    }

    public boolean isDisableBehindModalEnabled() {
        return this._disableBehindModal;
    }

    public void enableDisableBehindModal(boolean enable) {
        this._disableBehindModal = enable;
    }

    public Monitor getMonitor() {
        return this._monitor;
    }

    public Monitor setMonitor(Monitor monitor) {
        Monitor old = this._monitor;
        this._monitor = monitor;
        return old;
    }

    public PerformanceMeter getPerformanceMeter() {
        return this._pfmeter;
    }

    public PerformanceMeter setPerformanceMeter(PerformanceMeter meter) {
        PerformanceMeter old = this._pfmeter;
        this._pfmeter = meter;
        return old;
    }

    public String getResponseCharset() {
        return this._charsetResp;
    }

    public void setResponseCharset(String charset) {
        this._charsetResp = charset != null && charset.length() > 0 ? charset : null;
    }

    public String getPreference(String name, String defaultValue) {
        String value = (String)this._prefs.get(name);
        return value != null ? value : defaultValue;
    }

    public void setPreference(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("null");
        }
        this._prefs.put(name, value);
    }

    public Set getPreferenceNames() {
        return this._prefs.keySet();
    }

    public Object addRichlet(String name, Class richletClass, Map params) {
        if (!Richlet.class.isAssignableFrom(richletClass)) {
            throw new IllegalArgumentException("A richlet class, " + richletClass + ", must implement " + Richlet.class.getName());
        }
        return this.addRichlet0(name, richletClass, params);
    }

    public Object addRichlet(String name, String richletClassName, Map params) {
        if (richletClassName == null || richletClassName.length() == 0) {
            throw new IllegalArgumentException("richletClassName is required");
        }
        return this.addRichlet0(name, richletClassName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addRichlet0(String name, Object richletClass, Map params) {
        Object[] o;
        Map map = this._richlets;
        synchronized (map) {
            o = this._richlets.put(name, new Object[]{richletClass, params});
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Richlet) {
            Configuration.destroy((Richlet)o);
            return o.getClass();
        }
        return o[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRichletMapping(String name, String path) {
        Map map = this._richlets;
        synchronized (map) {
            if (!this._richlets.containsKey(name)) {
                throw new UiException("Richlet not defined: " + name);
            }
        }
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path must start with '/', not " + path);
        }
        boolean wildcard = path.endsWith("/*");
        if (wildcard) {
            path = path.substring(0, path.length() - 2);
        }
        Map map2 = this._richletmaps;
        synchronized (map2) {
            this._richletmaps.put(path, new Object[]{name, wildcard});
        }
    }

    private static void destroy(Richlet richlet) {
        try {
            richlet.destroy();
        }
        catch (Throwable ex) {
            log.error("Unable to destroy " + richlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Richlet getRichlet(String name) {
        Object[] info;
        WaitLock lock;
        block21: {
            lock = null;
            do {
                Map map = this._richlets;
                synchronized (map) {
                    Object o = this._richlets.get(name);
                    if (o == null || o instanceof Richlet) {
                        return (Richlet)o;
                    }
                    if (!(o instanceof WaitLock)) {
                        info = (Object[])o;
                        lock = new WaitLock();
                        this._richlets.put(name, lock);
                        break block21;
                    }
                    lock = (WaitLock)o;
                }
            } while (lock.waitUntilUnlock(300000));
            PotentialDeadLockException ex = new PotentialDeadLockException("Unable to load richlet " + name + "\nCause: conflict too long.");
            log.warningBriefly((Throwable)ex);
            throw ex;
        }
        try {
            Object o;
            if (info[0] instanceof String) {
                try {
                    info[0] = Classes.forNameByThread((String)((String)info[0]));
                }
                catch (Throwable ex) {
                    throw new UiException("Failed to load " + info[0]);
                }
            }
            if (!((o = ((Class)info[0]).newInstance()) instanceof Richlet)) {
                throw new UiException(Richlet.class + " must be implemented by " + info[0]);
            }
            Richlet richlet = (Richlet)o;
            richlet.init(new RichletConfigImpl(this._wapp, (Map)info[1]));
            Object object = this._richlets;
            synchronized (object) {
                this._richlets.put(name, richlet);
            }
            object = richlet;
            return object;
        }
        catch (Throwable ex) {
            Map map = this._richlets;
            synchronized (map) {
                this._richlets.put(name, info);
            }
            throw UiException.Aide.wrap(ex, "Unable to instantiate " + info[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public Richlet getRichletByPath(String path) {
        int len;
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        int j = len = path.length();
        Richlet richlet;
        while ((richlet = this.getRichletByPath0(path.substring(0, j), j != len)) == null && j != 0) {
            j = path.lastIndexOf(47, j - 1);
        }
        return richlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Richlet getRichletByPath0(String path, boolean wildcardOnly) {
        Object[] info;
        Map map = this._richletmaps;
        synchronized (map) {
            info = (Object[])this._richletmaps.get(path);
        }
        return info != null && (!wildcardOnly || (Boolean)info[1] != false) ? this.getRichlet((String)info[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detroyRichlets() {
        Map map = this._richlets;
        synchronized (map) {
            Iterator it = this._richlets.values().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Richlet)) continue;
                Configuration.destroy((Richlet)o);
            }
            this._richlets.clear();
        }
    }

    public void setKeepDesktopAcrossVisits(boolean keep) {
        this._keepDesktop = keep;
    }

    public boolean isKeepDesktopAcrossVisits() {
        return this._keepDesktop;
    }

    public void setTimerKeepAlive(boolean alive) {
        this._timerKeepAlive = alive;
    }

    public boolean isTimerKeepAlive() {
        return this._timerKeepAlive;
    }

    public void setExpressionFactoryClass(Class expfcls) {
        Expressions.setExpressionFactoryClass((Class)expfcls);
    }

    public Class getExpressionFactoryClass() {
        return Expressions.getExpressionFactoryClass();
    }

    public Event beforeSendEvent(Event event) {
        return this._eis.beforeSendEvent(event);
    }

    public Event beforePostEvent(Event event) {
        return this._eis.beforePostEvent(event);
    }

    public Event beforeProcessEvent(Event event) {
        return this._eis.beforeProcessEvent(event);
    }

    public void afterProcessEvent(Event event) {
        this._eis.afterProcessEvent(event);
    }

    public void addErrorPage(Class type, String location) {
        this.addErrorPage("ajax", type, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addErrorPage(String deviceType, Class type, String location) {
        LinkedList<ErrorPage> l;
        if (!Throwable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Throwable or derived is required: " + type);
        }
        if (location == null || deviceType == null) {
            throw new IllegalArgumentException();
        }
        Map map = this._errpgs;
        synchronized (map) {
            l = (LinkedList<ErrorPage>)this._errpgs.get(deviceType);
            if (l == null) {
                l = new LinkedList<ErrorPage>();
                this._errpgs.put(deviceType, l);
            }
        }
        String previous = null;
        LinkedList<ErrorPage> linkedList = l;
        synchronized (linkedList) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ErrorPage errpg = (ErrorPage)it.next();
                if (!errpg.type.equals(type)) continue;
                previous = errpg.location;
                it.remove();
                break;
            }
            l.add(new ErrorPage(type, location));
        }
        return previous;
    }

    public String getErrorPage(Throwable error) {
        return this.getErrorPage("ajax", error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorPage(String deviceType, Throwable error) {
        if (!this._errpgs.isEmpty()) {
            List l;
            Object object = this._errpgs;
            synchronized (object) {
                l = (List)this._errpgs.get(deviceType);
            }
            if (l != null) {
                object = l;
                synchronized (object) {
                    Iterator it = l.iterator();
                    while (it.hasNext()) {
                        ErrorPage errpg = (ErrorPage)it.next();
                        if (!errpg.type.isInstance(error)) continue;
                        return errpg.location;
                    }
                }
            }
        }
        return null;
    }

    private static class ErrorPage {
        private final Class type;
        private final String location;

        private ErrorPage(Class type, String location) {
            this.type = type;
            this.location = location;
        }
    }
}

