/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel.impl;

import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.util.SimpleXelContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.ExecutionResolver;

public class SimpleEvaluator
implements Evaluator {
    private transient ExpressionFactory _expf;
    private final Class _expfcls;
    private final FunctionMapper _mapper;

    public SimpleEvaluator(FunctionMapper mapper, Class expfcls) {
        this._expfcls = expfcls;
        this._mapper = mapper;
    }

    public Expression parseExpression(String expression, Class expectedType) throws XelException {
        return this.getExpressionFactory().parseExpression(this.getXelContext(null), expression, expectedType);
    }

    public Object evaluate(Page page, Expression expression) throws XelException {
        return expression.evaluate(this.getXelContext(page));
    }

    public Object evaluate(Component comp, Expression expression) throws XelException {
        return expression.evaluate(this.getXelContext(comp));
    }

    public Class getExpressionFactoryClass() {
        return this._expfcls;
    }

    private ExpressionFactory getExpressionFactory() {
        if (this._expf == null) {
            this._expf = Expressions.newExpressionFactory((Class)this._expfcls);
        }
        return this._expf;
    }

    private XelContext getXelContext(Object ref) {
        FunctionMapper mapper = this.getFunctionMapper(ref);
        VariableResolver resolver = this.getVariableResolver(ref);
        return new SimpleXelContext(resolver, mapper);
    }

    public FunctionMapper getFunctionMapper(Object ref) {
        return this._mapper;
    }

    public VariableResolver getVariableResolver(Object ref) {
        Execution exec = Executions.getCurrent();
        VariableResolver resolver = exec.getVariableResolver();
        if (resolver == null) {
            RequestContext rc = RequestContexts.getCurrent();
            if (rc != null) {
                resolver = rc.getVariableResolver();
            }
            if (resolver == null) {
                return null;
            }
        }
        if (resolver instanceof ExecutionResolver) {
            ((ExecutionResolver)resolver).setSelf(ref);
        }
        return resolver;
    }
}

