/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import org.zkforge.json.simple.JSONArray;
import org.zkforge.timeline.Bandinfo;
import org.zkforge.timeline.impl.TimelineComponent;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;

public class Timeline
extends TimelineComponent {
    private String _orient = "horizontal";
    private String _height = "150px";
    private String _width = "100%";

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public String getInnerAttrs() {
        return "z.orientation=" + this.getOrient();
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Bandinfo)) {
            throw new UiException("Unsupported child for timeline: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (!Objects.equals((Object)this._height, (Object)height)) {
            this._height = height;
            this.smartUpdate("z.height", height);
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.smartUpdate("z.width", width);
        }
    }

    public void performFiltering(String filterText) {
        this.smartUpdate("z.filter", filterText);
    }

    public void clearFilter() {
        this.smartUpdate("z.clearFilter", "");
    }

    public void performHighlitht(String[] highlightText) {
        JSONArray matchers = new JSONArray();
        for (int i = 0; i < highlightText.length; ++i) {
            matchers.add(highlightText[i]);
        }
        this.smartUpdate("z.highlight", matchers.toString());
    }

    public void clearHighlight() {
        this.smartUpdate("z.clearHighlight", "");
    }
}

