/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import java.io.Serializable;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Verifier;

public final class Namespace
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20060622L;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    public static final Namespace XMLNS_NAMESPACE;
    private String _prefix;
    private String _uri;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Namespace getSpecial(String prefix) {
        if (prefix.equals("xml")) {
            return XML_NAMESPACE;
        }
        if (prefix.equals("xmlns")) {
            return XMLNS_NAMESPACE;
        }
        return null;
    }

    private static final Namespace newSpecialNamespace(String prefix, String uri) {
        Namespace ns = new Namespace("", uri);
        ns._prefix = prefix;
        return ns;
    }

    public Namespace(String prefix, String uri) {
        Verifier.checkNamespacePrefix(prefix, null);
        Verifier.checkNamespaceURI(uri, null);
        if (prefix.length() != 0 && uri.length() == 0) {
            throw new DOMException(14, "Non-empty prefix, " + prefix + ", requires a URI");
        }
        this._prefix = prefix;
        this._uri = uri;
    }

    public final String tagNameOf(String name) {
        if (!$assertionsDisabled && name.indexOf(58) >= 0) {
            throw new AssertionError();
        }
        int len = this._prefix.length();
        return len == 0 ? name : this._prefix + ':' + name;
    }

    public final String getPrefix() {
        return this._prefix;
    }

    public final String getURI() {
        return this._uri;
    }

    public final boolean equalsAll(Namespace ns) {
        if (this._prefix.equals(ns._prefix)) {
            if (this._uri.equals(ns._uri)) {
                return true;
            }
            throw new DOMException(14, "The same prefix, " + this._prefix + ", cannot have different URI: " + this._uri + " vs " + ns._uri);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Namespace && this._uri.equals(((Namespace)o)._uri);
    }

    public int hashCode() {
        return this._uri.hashCode();
    }

    public String toString() {
        return "[Namespace: \"" + this._prefix + "\", \"" + this._uri + "\"]";
    }

    static {
        $assertionsDisabled = !Namespace.class.desiredAssertionStatus();
        NO_NAMESPACE = Namespace.newSpecialNamespace("", "");
        XML_NAMESPACE = Namespace.newSpecialNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        XMLNS_NAMESPACE = Namespace.newSpecialNamespace("xmlns", "http://www.w3.org/XML/1998/namespace");
    }
}

