/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.File;
import org.zkoss.lang.Threads;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;

public class FileWatchdog
extends Thread {
    private static final Log log = Log.lookup(FileWatchdog.class);
    private File _file;
    private Callback _callback;
    private long _delay;
    private long _lastModified = 0L;
    private boolean _warnedAlready = false;
    private boolean _ceased = false;

    public FileWatchdog(File file, long delay, Callback callback) {
        this.setup(file, delay, callback);
    }

    public FileWatchdog(String filename, long delay, Callback callback) {
        if (filename == null) {
            throw new IllegalArgumentException("null");
        }
        this.setup(new File(filename), delay, callback);
    }

    private void setup(File file, long delay, Callback callback) {
        if (file == null || callback == null) {
            throw new IllegalArgumentException("null");
        }
        this._file = file;
        this._delay = delay;
        this._callback = callback;
        Threads.setPriority(this, 1);
        Threads.setDaemon(this, true);
    }

    public void start() {
        this._ceased = false;
        super.start();
    }

    public void cease() {
        this._ceased = true;
    }

    public void run() {
        do {
            try {
                if (this._file.exists()) {
                    long l = this._file.lastModified();
                    if (l > this._lastModified) {
                        if (!this._ceased && log.debugable()) {
                            log.debug(this._file + " modified: " + l + " vs " + this._lastModified);
                        }
                        this._lastModified = l;
                        this._warnedAlready = false;
                        if (!this._ceased) {
                            this._callback.onModified(this._file);
                        }
                    }
                } else if (!this._warnedAlready) {
                    if (!this._ceased) {
                        log.debug(MCommon.FILE_NOT_FOUND, this._file.getPath());
                    }
                    this._warnedAlready = true;
                }
            }
            catch (Exception ex) {
                if (!this._ceased) {
                    log.warning(MCommon.FILE_READ_FAILED, this._file, (Throwable)ex);
                }
                return;
            }
            try {
                if (this._ceased) continue;
                FileWatchdog.sleep(this._delay);
            }
            catch (InterruptedException ex) {
                System.out.println("The file watchdog is interrupted");
                break;
            }
        } while (!this._ceased);
        System.out.println(Thread.currentThread().getName() + ": the file watchdog stops");
    }

    public static interface Callback {
        public void onModified(File var1) throws Exception;
    }
}

