/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.lang.reflect.Field;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;

public class ThreadLocals {
    public static ThreadLocal getThreadLocal(String clsname, String fldname) {
        try {
            Class cls = Classes.forNameByThread(clsname);
            return ThreadLocals.getThreadLocal(cls, fldname);
        }
        catch (ClassNotFoundException ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }

    public static ThreadLocal getThreadLocal(Class cls, String fldname) {
        try {
            Field fld = cls.getDeclaredField(fldname);
            fld.setAccessible(true);
            return (ThreadLocal)fld.get(cls);
        }
        catch (NoSuchFieldException ex) {
            throw SystemException.Aide.wrap(ex);
        }
        catch (IllegalAccessException ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }
}

