/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.zkoss.util.ListX;

public class TreeArray
extends AbstractList
implements ListX,
Cloneable,
Serializable {
    private static final long serialVersionUID = 20060622L;
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected transient RbEntry _root = null;
    protected transient int _size = 0;
    protected transient int _hashCode = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TreeArray() {
    }

    public TreeArray(Collection c) {
        this();
        if (c != null) {
            this.addAll(c);
        }
    }

    public final void addByOrder(Object element) {
        int j = this.search(element);
        if (j < 0) {
            j = -j - 1;
        }
        this.add(j, element);
    }

    public final void addByOrder(Object element, Comparator c) {
        int j = this.search(element, c);
        if (j < 0) {
            j = -j - 1;
        }
        this.add(j, element);
    }

    public final boolean removeByOrder(Object element) {
        int j = this.search(element);
        if (j >= 0) {
            this.remove(j);
            return true;
        }
        return false;
    }

    public final boolean removeByOrder(Object element, Comparator c) {
        int j = this.search(element, c);
        if (j >= 0) {
            this.remove(j);
            return true;
        }
        return false;
    }

    public final void addAllByOrder(Collection cn) {
        Iterator it = cn.iterator();
        while (it.hasNext()) {
            this.addByOrder(it.next());
        }
    }

    public final void addAllByOrder(Collection cn, Comparator c) {
        Iterator it = cn.iterator();
        while (it.hasNext()) {
            this.addByOrder(it.next(), c);
        }
    }

    public final int search(Object element) {
        return Collections.binarySearch(this, element);
    }

    public final int search(Object element, Comparator c) {
        return Collections.binarySearch(this, element, c);
    }

    public final Object getByOrder(Object element) {
        int j = this.search(element);
        return j >= 0 ? this.get(j) : null;
    }

    public final Object getByOrder(Object element, Comparator c) {
        int j = this.search(element, c);
        return j >= 0 ? this.get(j) : null;
    }

    public final void sort() {
        Collections.sort(this);
    }

    public final void sort(Comparator c) {
        Collections.sort(this, c);
    }

    public final int size() {
        return this._size;
    }

    public final Object get(int index) {
        return this.getRbEntry(index).getElement();
    }

    public Object set(int index, Object element) {
        RbEntry p = this.getRbEntry(index);
        Object old = p.getElement();
        p.setElement(element);
        return old;
    }

    public void add(int index, Object element) {
        this.addEntry(index, element);
    }

    public Object remove(int index) {
        RbEntry p = this.getRbEntry(index);
        this.delete(p);
        return p.getElement();
    }

    public final Iterator iterator() {
        return this.listIterator();
    }

    public final ListIterator listIterator(int index) {
        return new Iter(index);
    }

    public void clear() {
        if (this._root != null) {
            this._root.clear();
            ++this.modCount;
            this._size = 0;
            this._root = null;
        }
    }

    protected final RbEntry getRbEntry(int index) {
        this.checkRange(index);
        int baseIndex = 0;
        RbEntry p = this._root;
        do {
            int thisIndex;
            if (index == (thisIndex = baseIndex + p.leftNum)) {
                return p;
            }
            if (index < thisIndex) {
                p = p.left;
                continue;
            }
            baseIndex = thisIndex + 1;
            p = p.right;
        } while (p != null);
        throw new ConcurrentModificationException();
    }

    public final ListX.Entry getEntry(int index) {
        return this.getRbEntry(index);
    }

    protected final int indexOfEntry(RbEntry p) {
        if (p.orphan) {
            return -1;
        }
        int v = p.leftNum;
        RbEntry lowParent = p.firtLeftAncestor();
        if (lowParent != null) {
            v += this.indexOfEntry(lowParent) + 1;
        }
        return v;
    }

    public final int indexOfEntry(ListX.Entry p) {
        return this.indexOfEntry((RbEntry)p);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = super.hashCode();
        }
        return this._hashCode;
    }

    public final ListIterator entryIterator(int index) {
        return new EntryIter(index);
    }

    public final ListIterator entryIterator() {
        return new EntryIter(0);
    }

    protected RbEntry newEntry(Object element) {
        return new RbEntry(element);
    }

    public final ListX.Entry addEntry(ListX.Entry insertBefore, Object element) {
        return this.insert(this.checkNotOrphan(insertBefore), this.newEntry(element));
    }

    public final ListX.Entry addEntry(int index, Object element) {
        return this.insert(index, this.newEntry(element));
    }

    public final ListX.Entry addEntry(Object element) {
        return this.addEntry(this._size, element);
    }

    public final void removeEntry(ListX.Entry p) {
        this.delete(this.checkNotOrphan(p));
    }

    public final ListX.Entry removeEntry(int index) {
        return this.delete(index);
    }

    protected final RbEntry first() {
        return this._root == null ? null : this._root.leftMost();
    }

    private static final boolean colorOf(RbEntry p) {
        return p == null ? true : p.color;
    }

    private static final RbEntry parentOf(RbEntry p) {
        return p == null ? null : p.parent;
    }

    private static final void setColor(RbEntry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static final RbEntry leftOf(RbEntry p) {
        return p == null ? null : p.left;
    }

    private static final RbEntry rightOf(RbEntry p) {
        return p == null ? null : p.right;
    }

    protected final RbEntry insert(int index, RbEntry p) {
        this.checkRangePlus(index);
        return this.insert(index < this._size ? this.getRbEntry(index) : null, p);
    }

    private static final void changeAncestorLeftNum(RbEntry p, int diff) {
        while (p.parent != null) {
            if (p.parent.left == p) {
                p.parent.leftNum += diff;
            }
            p = p.parent;
        }
    }

    protected RbEntry insert(RbEntry insertBefore, RbEntry p) {
        if (!$assertionsDisabled && p.orphan) {
            throw new AssertionError();
        }
        if (this._root == null) {
            this._root = p;
        } else {
            if (insertBefore != null && insertBefore.left == null) {
                insertBefore.left = p;
            } else {
                insertBefore = insertBefore == null ? this._root : insertBefore.left;
                insertBefore = insertBefore.rightMost();
                insertBefore.right = p;
            }
            p.parent = insertBefore;
            TreeArray.changeAncestorLeftNum(p, 1);
        }
        this.fixAfterInsert(p);
        this.incSize();
        return p;
    }

    private final void rotateLeft(RbEntry x) {
        RbEntry y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this._root = y;
        } else if (x.parent.left == x) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
        y.leftNum += x.leftNum + 1;
    }

    private final void rotateRight(RbEntry y) {
        RbEntry x = y.left;
        y.left = x.right;
        if (x.right != null) {
            x.right.parent = y;
        }
        x.parent = y.parent;
        if (y.parent == null) {
            this._root = x;
        } else if (y.parent.right == y) {
            y.parent.right = x;
        } else {
            y.parent.left = x;
        }
        x.right = y;
        y.parent = x;
        y.leftNum -= x.leftNum + 1;
    }

    private final void fixAfterInsert(RbEntry x) {
        x.color = false;
        while (x != null && x != this._root && !x.parent.color) {
            RbEntry y;
            if (TreeArray.parentOf(x) == TreeArray.leftOf(TreeArray.parentOf(TreeArray.parentOf(x)))) {
                y = TreeArray.rightOf(TreeArray.parentOf(TreeArray.parentOf(x)));
                if (!TreeArray.colorOf(y)) {
                    TreeArray.setColor(TreeArray.parentOf(x), true);
                    TreeArray.setColor(y, true);
                    TreeArray.setColor(TreeArray.parentOf(TreeArray.parentOf(x)), false);
                    x = TreeArray.parentOf(TreeArray.parentOf(x));
                    continue;
                }
                if (x == TreeArray.rightOf(TreeArray.parentOf(x))) {
                    x = TreeArray.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeArray.setColor(TreeArray.parentOf(x), true);
                TreeArray.setColor(TreeArray.parentOf(TreeArray.parentOf(x)), false);
                if (TreeArray.parentOf(TreeArray.parentOf(x)) == null) continue;
                this.rotateRight(TreeArray.parentOf(TreeArray.parentOf(x)));
                continue;
            }
            y = TreeArray.leftOf(TreeArray.parentOf(TreeArray.parentOf(x)));
            if (!TreeArray.colorOf(y)) {
                TreeArray.setColor(TreeArray.parentOf(x), true);
                TreeArray.setColor(y, true);
                TreeArray.setColor(TreeArray.parentOf(TreeArray.parentOf(x)), false);
                x = TreeArray.parentOf(TreeArray.parentOf(x));
                continue;
            }
            if (x == TreeArray.leftOf(TreeArray.parentOf(x))) {
                x = TreeArray.parentOf(x);
                this.rotateRight(x);
            }
            TreeArray.setColor(TreeArray.parentOf(x), true);
            TreeArray.setColor(TreeArray.parentOf(TreeArray.parentOf(x)), false);
            if (TreeArray.parentOf(TreeArray.parentOf(x)) == null) continue;
            this.rotateLeft(TreeArray.parentOf(TreeArray.parentOf(x)));
        }
        this._root.color = true;
    }

    protected RbEntry delete(int index) {
        RbEntry p = this.getRbEntry(index);
        this.delete(p);
        return p;
    }

    protected void delete(RbEntry p) {
        RbEntry replacement;
        if (!$assertionsDisabled && p.orphan) {
            throw new AssertionError();
        }
        if (p.left != null && p.right != null) {
            this.swapPosition(p.nextEntry(), p);
        }
        TreeArray.changeAncestorLeftNum(p, -1);
        this.decSize();
        RbEntry rbEntry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this._root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            if (p.color) {
                this.fixAfterDelete(replacement);
            }
        } else if (p.parent == null) {
            this._root = null;
        } else if (p == p.parent.left) {
            p.parent.left = null;
        } else if (p == p.parent.right) {
            p.parent.right = null;
        }
        p.setOrphan();
    }

    private final void swapPosition(RbEntry x, RbEntry y) {
        boolean yWasLeftChild;
        RbEntry px = x.parent;
        RbEntry lx = x.left;
        RbEntry rx = x.right;
        RbEntry py = y.parent;
        RbEntry ly = y.left;
        RbEntry ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        boolean c = x.color;
        x.color = y.color;
        y.color = c;
        int v = x.leftNum;
        x.leftNum = y.leftNum;
        y.leftNum = v;
        if (this._root == x) {
            this._root = y;
        } else if (this._root == y) {
            this._root = x;
        }
    }

    private void fixAfterDelete(RbEntry x) {
        while (x != this._root && TreeArray.colorOf(x)) {
            RbEntry sib;
            if (x == TreeArray.leftOf(TreeArray.parentOf(x))) {
                sib = TreeArray.rightOf(TreeArray.parentOf(x));
                if (!TreeArray.colorOf(sib)) {
                    TreeArray.setColor(sib, true);
                    TreeArray.setColor(TreeArray.parentOf(x), false);
                    this.rotateLeft(TreeArray.parentOf(x));
                    sib = TreeArray.rightOf(TreeArray.parentOf(x));
                }
                if (TreeArray.colorOf(TreeArray.leftOf(sib)) && TreeArray.colorOf(TreeArray.rightOf(sib))) {
                    TreeArray.setColor(sib, false);
                    x = TreeArray.parentOf(x);
                    continue;
                }
                if (TreeArray.colorOf(TreeArray.rightOf(sib))) {
                    TreeArray.setColor(TreeArray.leftOf(sib), true);
                    TreeArray.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeArray.rightOf(TreeArray.parentOf(x));
                }
                TreeArray.setColor(sib, TreeArray.colorOf(TreeArray.parentOf(x)));
                TreeArray.setColor(TreeArray.parentOf(x), true);
                TreeArray.setColor(TreeArray.rightOf(sib), true);
                this.rotateLeft(TreeArray.parentOf(x));
                x = this._root;
                continue;
            }
            sib = TreeArray.leftOf(TreeArray.parentOf(x));
            if (!TreeArray.colorOf(sib)) {
                TreeArray.setColor(sib, true);
                TreeArray.setColor(TreeArray.parentOf(x), false);
                this.rotateRight(TreeArray.parentOf(x));
                sib = TreeArray.leftOf(TreeArray.parentOf(x));
            }
            if (TreeArray.colorOf(TreeArray.rightOf(sib)) && TreeArray.colorOf(TreeArray.leftOf(sib))) {
                TreeArray.setColor(sib, false);
                x = TreeArray.parentOf(x);
                continue;
            }
            if (TreeArray.colorOf(TreeArray.leftOf(sib))) {
                TreeArray.setColor(TreeArray.rightOf(sib), true);
                TreeArray.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeArray.leftOf(TreeArray.parentOf(x));
            }
            TreeArray.setColor(sib, TreeArray.colorOf(TreeArray.parentOf(x)));
            TreeArray.setColor(TreeArray.parentOf(x), true);
            TreeArray.setColor(TreeArray.leftOf(sib), true);
            this.rotateRight(TreeArray.parentOf(x));
            x = this._root;
        }
        TreeArray.setColor(x, true);
    }

    protected final void incSize() {
        ++this.modCount;
        ++this._size;
    }

    protected final void decSize() {
        ++this.modCount;
        --this._size;
    }

    protected final void checkRange(int index) {
        if (index >= this._size || index < 0) {
            this.indexOutOfBounds(index);
        }
    }

    protected final void checkRangePlus(int index) {
        if (index > this._size || index < 0) {
            this.indexOutOfBounds(index);
        }
    }

    protected final void indexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
    }

    protected final RbEntry checkNotOrphan(ListX.Entry entry) {
        RbEntry p = (RbEntry)entry;
        if (p.orphan) {
            throw new IllegalStateException();
        }
        return p;
    }

    public Object clone() {
        TreeArray clone;
        try {
            clone = (TreeArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._size = 0;
        clone._root = null;
        clone.modCount = 0;
        for (RbEntry p = this.first(); p != null; p = p.nextEntry()) {
            clone.add(p.getElement());
        }
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._size);
        for (RbEntry p = this.first(); p != null; p = p.nextEntry()) {
            s.writeObject(p.getElement());
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(s.readObject());
        }
    }

    static {
        $assertionsDisabled = !TreeArray.class.desiredAssertionStatus();
    }

    private class Iter
    extends EntryIter {
        private Iter(int index) {
            super(index);
        }

        public final Object next() {
            return ((RbEntry)super.next()).getElement();
        }

        public final Object previous() {
            return ((RbEntry)super.previous()).getElement();
        }
    }

    private class EntryIter
    implements ListIterator {
        private RbEntry _cursor;
        private RbEntry _lastRet = null;
        private int _expectedModCount;

        private EntryIter(int index) {
            TreeArray.this.checkRangePlus(index);
            this._cursor = index < TreeArray.this._size ? TreeArray.this.getRbEntry(index) : null;
            this._expectedModCount = TreeArray.this.modCount;
        }

        public final boolean hasNext() {
            this.checkComodification();
            return this._cursor != null;
        }

        public Object next() {
            this.checkComodification();
            if (this._cursor == null) {
                throw new NoSuchElementException();
            }
            this._lastRet = this._cursor;
            RbEntry obj = this._cursor;
            this._cursor = this._cursor.nextEntry();
            return obj;
        }

        public final boolean hasPrevious() {
            this.checkComodification();
            if (this._cursor == null) {
                return TreeArray.this._size > 0;
            }
            return this._cursor.previousEntry() != null;
        }

        public Object previous() {
            this.checkComodification();
            if (this._cursor == null) {
                if (TreeArray.this._size == 0) {
                    throw new NoSuchElementException();
                }
                this._cursor = TreeArray.this.getRbEntry(TreeArray.this._size - 1);
            } else {
                RbEntry prev = this._cursor.previousEntry();
                if (prev == null) {
                    throw new NoSuchElementException();
                }
                this._cursor = prev;
            }
            this._lastRet = this._cursor;
            return this._cursor;
        }

        public final int nextIndex() {
            return this._cursor == null ? TreeArray.this._size : TreeArray.this.indexOfEntry(this._cursor);
        }

        public final int previousIndex() {
            return this._cursor == null ? TreeArray.this._size - 1 : TreeArray.this.indexOfEntry(this._cursor) - 1;
        }

        public final void remove() {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            if (this._lastRet == this._cursor) {
                this._cursor = this._cursor.nextEntry();
            }
            TreeArray.this.delete(this._lastRet);
            this._expectedModCount = TreeArray.this.modCount;
            this._lastRet = null;
        }

        public final void set(Object obj) {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            this._lastRet.setElement(obj);
        }

        public final Object get() {
            return this._lastRet.getElement();
        }

        public final void add(Object obj) {
            this.checkComodification();
            TreeArray.this.insert(this._cursor, TreeArray.this.newEntry(obj));
            this._expectedModCount = TreeArray.this.modCount;
        }

        private final void checkComodification() {
            if (TreeArray.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static class RbEntry
    implements ListX.Entry {
        protected Object element;
        protected int leftNum;
        protected RbEntry left;
        protected RbEntry right;
        protected RbEntry parent;
        protected boolean color;
        protected boolean orphan = false;

        protected RbEntry(Object element) {
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }

        public void setElement(Object element) {
            this.element = element;
        }

        public final boolean isOrphan() {
            return this.orphan;
        }

        protected final RbEntry nextEntry() {
            if (this.right != null) {
                return this.right.leftMost();
            }
            return this.firstRightAncestor();
        }

        public final ListX.Entry next() {
            return this.nextEntry();
        }

        protected final RbEntry previousEntry() {
            if (this.left != null) {
                return this.left.rightMost();
            }
            return this.firtLeftAncestor();
        }

        public final ListX.Entry previous() {
            return this.previousEntry();
        }

        protected final RbEntry leftMost() {
            RbEntry p = this;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }

        protected final RbEntry rightMost() {
            RbEntry p = this;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }

        protected final RbEntry firtLeftAncestor() {
            RbEntry p = this;
            while (p.parent != null) {
                if (p.parent.right == p) {
                    return p.parent;
                }
                p = p.parent;
            }
            return null;
        }

        protected final RbEntry firstRightAncestor() {
            RbEntry p = this;
            while (p.parent != null) {
                if (p.parent.left == p) {
                    return p.parent;
                }
                p = p.parent;
            }
            return null;
        }

        private final void setOrphan() {
            this.orphan = true;
            this.parent = null;
            this.right = null;
            this.left = null;
        }

        protected void clear() {
            if (this.left != null) {
                this.left.clear();
            }
            if (this.right != null) {
                this.right.clear();
            }
            this.setOrphan();
        }
    }
}

