/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.zkoss.util.resource.Loader;

public abstract class AbstractLoader
implements Loader {
    public boolean shallCheck(Object src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(Object src) {
        if (src instanceof URL) {
            URL url = (URL)src;
            String protocol = url.getProtocol().toLowerCase();
            if (!("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol))) {
                try {
                    return url.openConnection().getLastModified();
                }
                catch (IOException ex) {
                    return -1L;
                }
            }
            return -1L;
        }
        if (src instanceof File) {
            return ((File)src).lastModified();
        }
        if (src == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException("Unknown soruce: " + src + "\nOnly File and URL are supported");
    }
}

