/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel;

import org.zkoss.util.logging.Log;
import org.zkoss.xel.DummyExpr;
import org.zkoss.xel.EmptyMapper;
import org.zkoss.xel.EmptyResolver;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.el.ELFactory;

public class Expressions {
    private static final Log log = Log.lookup(Expressions.class);
    public static final FunctionMapper EMPTY_MAPPER = new EmptyMapper();
    public static final VariableResolver EMPTY_RESOLVER = new EmptyResolver();
    public static final Expression DUMMY_EXPRESSION = new DummyExpr();
    private static Class _expfcls;

    public static final ExpressionFactory newExpressionFactory() throws XelException {
        return Expressions.newExpressionFactory(_expfcls);
    }

    public static final ExpressionFactory newExpressionFactory(Class expfcls) {
        if (expfcls != null) {
            try {
                return (ExpressionFactory)expfcls.newInstance();
            }
            catch (Throwable ex) {
                throw XelException.Aide.wrap(ex, "Unable to instantiate " + expfcls);
            }
        }
        return Expressions.newDefautFactory();
    }

    private static final ExpressionFactory newDefautFactory() {
        return new ELFactory();
    }

    public static final Object evaluate(XelContext ctx, String expression, Class expectedType) throws XelException {
        return Expressions.newExpressionFactory().evaluate(ctx, expression, expectedType);
    }

    public static final void setExpressionFactoryClass(Class expfcls) {
        if (expfcls != null && !ExpressionFactory.class.isAssignableFrom(expfcls)) {
            throw new IllegalArgumentException(expfcls + " must implement " + ExpressionFactory.class);
        }
        _expfcls = expfcls;
    }

    public static final Class getExpressionFactoryClass() {
        return _expfcls;
    }
}

