/*
 * This file is part of NavalPlan
 *
 * Copyright (C) 2009-2010 Fundación para o Fomento da Calidade Industrial e
 *                         Desenvolvemento Tecnolóxico de Galicia
 * Copyright (C) 2010-2011 Igalia, S.L.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.navalplanner.web.orders;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;

import org.navalplanner.business.calendars.entities.BaseCalendar;
import org.navalplanner.business.common.exceptions.ValidationException;
import org.navalplanner.business.externalcompanies.entities.ExternalCompany;
import org.navalplanner.business.labels.entities.Label;
import org.navalplanner.business.orders.entities.Order;
import org.navalplanner.business.orders.entities.OrderElement;
import org.navalplanner.business.orders.entities.OrderLineGroup;
import org.navalplanner.business.qualityforms.entities.QualityForm;
import org.navalplanner.business.resources.entities.Criterion;
import org.navalplanner.business.resources.entities.CriterionType;
import org.navalplanner.business.templates.entities.OrderElementTemplate;
import org.navalplanner.business.templates.entities.OrderTemplate;
import org.navalplanner.web.common.IIntegrationEntityModel;
import org.zkoss.ganttz.IPredicate;

/**
 * Contract for {@link OrderModel}<br />
 *
 * @author Óscar González Fernández <ogonzalez@igalia.com>
 * @author Diego Pino García <dpino@igalia.com>
 */
public interface IOrderModel extends IIntegrationEntityModel {

    /**
     * Adds {@link Label} to list of labels
     *
     * @param label
     */
    void addLabel(Label label);

    /**
     * Returns a list of {@link Label}
     *
     * @return
     */
    List<Criterion> getCriterionsFor(CriterionType criterionType);

    Map<CriterionType, List<Criterion>> getMapCriterions();

    List<Label> getLabels();

    List<QualityForm> getQualityForms();

    OrderLineGroup getOrder();

    IOrderElementModel getOrderElementModel(OrderElement orderElement);

    /**
     * Iterates through all the orderElements of an order, and checks if
     * orderElement holds predicate. In case it is true, adds orderElement.
     */
    OrderElementTreeModel getOrderElementsFilteredByPredicate(IPredicate predicate);

    OrderElementTreeModel getOrderElementTreeModel();

    List<Order> getOrders();

    void initEdit(Order order);

    void prepareForCreate() throws ConcurrentModificationException;

    void remove(Order order);

    void save() throws ValidationException;

    void setOrder(Order order);

    List<BaseCalendar> getBaseCalendars();

    BaseCalendar getDefaultCalendar();

    BaseCalendar getCalendar();

    void setCalendar(BaseCalendar calendar);

    boolean isCodeAutogenerated();

    void prepareCreationFrom(OrderTemplate template);

    OrderElement createFrom(OrderLineGroup parent, OrderElementTemplate template);

    List<ExternalCompany> getExternalCompaniesAreClient();

    void setExternalCompany(ExternalCompany externalCompany);

    public String gettooltipText(Order order);

    List<Order> getFilterOrders(OrderPredicate predicate);

    boolean userCanRead(Order order, String loginName);

    boolean userCanWrite(Order order, String loginName);

    boolean isAlreadyInUse(OrderElement orderElement);

    boolean isAlreadyInUseAndIsOnlyInCurrentScenario(Order order);

    void useSchedulingDataForCurrentScenario(Order order);

}
