/*
 * This file is part of NavalPlan
 *
 * Copyright (C) 2009-2010 Fundación para o Fomento da Calidade Industrial e
 *                         Desenvolvemento Tecnolóxico de Galicia
 * Copyright (C) 2010-2011 Igalia, S.L.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.navalplanner.ws.resources.api;

import javax.xml.bind.annotation.XmlAttribute;

/**
 * DTO for <code>Machine</code> entity.
 *
 * @author Fernando Bellas Permuy <fbellas@udc.es>
 */
public class MachineDTO extends ResourceDTO {

    public final static String ENTITY_TYPE = "machine";

    @XmlAttribute
    public String name;

    @XmlAttribute
    public String description;

    public MachineDTO() {}

    public MachineDTO(String code, String name, String description) {
        super(code);
        this.name = name;
        this.description = description;
    }

    /**
     * This constructor automatically generates a unique code. It is intended
     * to facilitate the implementation of test cases that add new instances
     * (such instances will have a unique code).
     */
    public MachineDTO(String name, String description) {
        this(generateCode(), name, description);
    }

    @Override
    public String getEntityType() {
        return ENTITY_TYPE;
    }

}
