package FS::cdr::transnexus;

use strict;
use base qw( FS::cdr );
use vars qw( %info );
use MIME::Base64;
use FS::cdr qw( _cdr_date_parser_maker _cdr_min_parser_maker );

%info = (
  'name'          => 'Transnexus',
  'weight'        => 18,
  'type'          => 'csv',
  'sep_char'      => "\t",

  #listref of what to do with each field from the CDR, in order
  'import_fields' => [

    _cdr_date_parser_maker('startddate'),        #O_CallStartTime
    'src',            #CallingNumberReported
    'dst',            #CalledNumberReported
    'channel',        #SourceDeviceName      / O_ReportingDeviceName
    'dstchannel',     #O_ReportingDeviceName / DestinationDeviceName
    sub { $_[0]->clid( decode_base64($_[1]) ); }, #CallId
    'uniqueid',       #TransactionId
    'duration',       #RatedDuration
    'billsec',        #O_BillingDuration
    'upstream_price', #O_BillingAmountCustCurr
  ],
);

1;

__END__

O_CallStartTime - Date and time stamp of the call setup as reported in the CDR from the source device.

CallingNumberReported - Calling number from the source device reported in authorization request to the OSPrey server.

CalledNumberReported - Called number from the source device reported in authorization request to the OSPrey server.

----
1.1.1 Customer CDR Archive File

SourceDeviceName - The IP address or Domain Name of the device which is the call source.

O_ReportingDeviceName - IP address or Domain Name of the source (Originating) device reporting the CDR to the OSPrey Server. If a proxy is used, (such as SIP proxy for signaling or FreeRADIUS for CDR reporting) this field is the IP address of the proxy device, not the actual source device.

---
or 1.1.2 Provider CDR Archive File

O_ReportingDeviceName - IP address or Domain Name of the source (Originating) device reporting the CDR to the OSPrey Server. If a proxy is used, (such as SIP proxy for signaling or FreeRADIUS for CDR reporting) this field is the IP address of the proxy device, not the actual source device.  

DestinationDeviceName - The IP address or Domain Name of the destination device.

----

CallId - The Call Identifier generated by the source VoIP device.

TransactionId - The unique Transaction Identification number created by the OSPrey server for each call

RatedDuration - The rateable duration calculated by NexOSS.

O_BillingDuration - The duration used to calculate the billable amount for a call from the source (Originating) network. This value is derived from RatedDuration and rounded up based on the First Increment or Next Increment rules defined in the Product or Customer Rate Plan used to rate the call.

O_BillingAmountCustCurr - Amount billable to the source (Originating) Customer. Provided in the currency of the Product or Customer Rate Plan.  

