<?php

/**
 *      [Discuz!] (C)2001-2099 Comsenz Inc.
 *      This is NOT a freeware, use is subject to license terms
 *
 *      $Id: function_connect.php 23058 2011-06-15 09:46:18Z monkey $
 */

function connect_output_javascript($jsurl) {
	return '<script type="text/javascript">function con_handle_response(str){} _attachEvent(window, \'load\', function () { appendscript(\''.$jsurl.'\', \'\', 1, \'utf-8\') }, document);</script>';
}

function connect_output_php($url, $postData = '') {
	global $_G;

	$response = dfsockopen($url, 0, $postData, '', false, $_G['setting']['connect_api_ip']);
	return $response;

}

// û֪ͨ
function connect_user_bind_js($params) {
	global $_G;

	$jsname = $_G['cookie']['connect_js_name'];
	if($jsname != 'user_bind') {
		return false;
	}

	$jsparams = unserialize(base64_decode($_G['cookie']['connect_js_params']));
	$jsurl = $_G['connect']['url'].'/notify/user/bind';

	if($jsparams) {
		$params = array_merge($params, $jsparams);
	}

	$func = 'connect_'.$jsname.'_params';
	$other_params = $func ();
	$params = array_merge($other_params, $params);
	$params['sig'] = connect_get_sig($params, connect_get_sig_key());

	$jsurl .= '?'.connect_http_build_query($params, '', '&');

	dsetcookie('connect_js_name');
	dsetcookie('connect_js_params');
	return connect_output_javascript($jsurl);
}

// û֪ͨ
function connect_user_unbind() {
	global $_G;

	$api_url = $_G['connect']['connect_api_url'].'/connect/user/unbind';

	$params = array (
		'oauth_consumer_key' => $_G['setting']['connectappid'],
		'client_ip' => $_G['clientip'],
		'response_type' => 'php',
		'openid' => $_G['member']['conopenid'],
		'source' => 'qzone',
	);

	$params['sig'] = connect_get_sig($params, connect_get_sig_key());

	$response = connect_output_php($api_url.'?', connect_http_build_query($params, '', '&'));
	$result = (array) unserialize($response);
	return $result;
}

// û֪ͨҪύĲ
function connect_user_bind_params() {
	global $_G;

	connect_merge_member();
	getuserprofile('birthyear');
	getuserprofile('birthmonth');
	getuserprofile('birthday');
	switch ($_G['member']['gender']) {
		case 1 :
			$sex = 'male';
			break;
		case 2 :
			$sex = 'female';
			break;
		default :
			$sex = 'unknown';
	}

	$is_public_email = 2;
	$is_use_qq_avatar = $_G['member']['conisqzoneavatar'] == 1 ? 1 : 2;
	$birthday = sprintf('%04d', $_G['member']['birthyear']).'-'.sprintf('%02d', $_G['member']['birthmonth']).'-'.sprintf('%02d', $_G['member']['birthday']);

	$agent = md5(time().rand().uniqid());
	$inputArray = array (
		'uid' => $_G['uid'],
		'agent' => $agent,
		'time' => TIMESTAMP
	);
	require_once DISCUZ_ROOT.'./config/config_ucenter.php';
	$input = 'uid='.$_G['uid'].'&agent='.$agent.'&time='.TIMESTAMP;
	$avatar_input = authcode($input, 'ENCODE', UC_KEY);

	$params = array (
		'oauth_consumer_key' => $_G['setting']['connectappid'],
		'u_id' => $_G['uid'],
		'username' => $_G['member']['username'],
		'email' => $_G['member']['email'],
		'birthday' => $birthday,
		'sex' => $sex,
		'is_public_email' => $is_public_email,
		'is_use_qq_avatar' => $is_use_qq_avatar,
		'avatar_input' => $avatar_input,
		'avatar_agent' => $agent,
		's_id' => null,
		'site_ucenter_id' => UC_APPID,
		'source' => 'qzone',
	);

	return $params;
}

/**
 * ֤Connectصsig
 */
function connect_check_sig($params) {
	global $_G;

	if(!$params) {
		return false;
	}

	$valid_params = array();
	foreach($params as $key => $value) {
		if(substr($key, 0, 4) == 'con_') {
			$valid_params[$key] = $value;
		}
	}
	$sig = $valid_params['con_sig'];
	unset($valid_params['con_sig']);
	ksort($valid_params);
	$str = '';
	foreach($valid_params as $k => $v) {
		if($v) {
			$str .= $k.'='.$v.'&';
		}
	}

	return $sig === md5($str.$_G['setting']['connectappkey']);
}

/**
 * ȡվǩԿ
 * @global  $_G
 * @return string ǩԿ = appid + | + appkeyԭվkey
 */
function connect_get_sig_key() {
	global $_G;

	return $_G['setting']['connectappid'] . '|' . $_G['setting']['connectappkey'];
}

/**
 * ȡ Connect ǩ
 * @param array $params 
 * @param string $app_key key
 * @return string
 */
function connect_get_sig($params, $app_key) {
	ksort($params);
	$base_string = '';
	foreach($params as $key => $value) {
		$base_string .= $key.'='.$value;
	}
	$base_string .= $app_key;
	return md5($base_string);
}

// ȡûtmp token
function connect_get_request_token() {
	global $_G;

	$api_url = $_G['connect']['api_url'].'/oauth/qzoneoauth_request_token';

	$extra = array();
	$sig_params = connect_get_oauth_signature_params($extra);
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'GET');

	$response = connect_output_php($api_url.'?'.connect_http_build_query($sig_params, '', '&'));
	parse_str($response, $params);
	return $params;
}

// ȡûaccess token
function connect_get_access_token($request_token, $verify_code) {
	global $_G;

	$api_url = $_G['connect']['api_url'].'/oauth/qzoneoauth_access_token';

	$extra = array();
	$extra['oauth_token'] = $request_token;
	$extra['oauth_vericode'] = $verify_code;
	$sig_params = connect_get_oauth_signature_params($extra);
	$oauth_token_secret = $_G['cookie']['con_request_token_secret'];
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'GET', $oauth_token_secret);

	dsetcookie('con_request_token');
	dsetcookie('con_request_token_secret');

	$response = connect_output_php($api_url.'?'.connect_http_build_query($sig_params, '', '&'));
	parse_str($response, $params);
	return $params;
}

// OAuthǩ
function connect_get_oauth_signature($url, $params, $method = 'POST', $oauth_token_secret = '') {

	global $_G;

	// http method
	$method = strtoupper($method);
	if(!in_array($method, array ('GET', 'POST'))) {
		return FALSE;
	}

	// URL
	$url = rawurlencode($url);

	// OAuth
	$param_str = rawurlencode(connect_http_build_query($params, '', '&'));

	// Signature Base String
	$base_string = $method.'&'.$url.'&'.$param_str;

	// Կ
	$key = $_G['setting']['connectappkey'].'&'.$oauth_token_secret;

	$signature = connect_custom_hmac($base_string, $key);

	return $signature;
}

// OAuth
function connect_get_oauth_signature_params($extra = array ()) {
	global $_G;

	$params = array (
		'oauth_version' => '1.0',
		'oauth_consumer_key' => $_G['setting']['connectappid'],
		'oauth_nonce' => connect_get_nonce(),
		'oauth_signature_method' => 'HMAC-SHA1',
		'oauth_timestamp' => TIMESTAMP
	);
	if($extra) {
		$params = array_merge($params, $extra);
	}
	ksort($params);

	return $params;
}

// ԶHMAC_SHA1PHP汾5.1.2Ļ
function connect_custom_hmac($str, $key) {
	$signature = "";
	if(function_exists('hash_hmac')) {
		$signature = base64_encode(hash_hmac("sha1", $str, $key, true));
	} else {
		$blocksize = 64;
		$hashfunc = 'sha1';
		if(strlen($key) > $blocksize) {
			$key = pack('H*', $hashfunc($key));
		}
		$key = str_pad($key,$blocksize,chr(0x00));
		$ipad = str_repeat(chr(0x36),$blocksize);
		$opad = str_repeat(chr(0x5c),$blocksize);
		$hmac = pack(
					   'H*',$hashfunc(
									  ($key^$opad).pack(
														'H*',$hashfunc(
																	   ($key^$ipad).$str
																	  )
													   )
									 )
					  );
		$signature = base64_encode($hmac);
	}

	return $signature;
}

// 
function connect_get_nonce() {
	return time();
}

// jsϢ
function connect_js_ouput_message($msg = '', $errMsg = '', $errCode = '') {
	$result = array (
		'result' => $msg,
		'errMessage' => $errMsg,
		'errCode' => $errCode
	);
	echo sprintf('con_handle_response(%s);', json_encode(connect_urlencode($result)));
	exit;
}

function connect_urlencode($value) {

	if (is_array($value)) {
		foreach ($value as $k => $v) {
			$value[$k] = connect_urlencode($v);
		}
	} else if (is_string($value)) {
		$value = urlencode(str_replace(array("\r\n", "\r", "\n", "\"", "\/", "\t"), array('\\n', '\\n', '\\n', '\\"', '\\/', '\\t'), $value));
	}

	return $value;
}

function connect_merge_member() {
	global $_G;

	$connect_member = DB::fetch_first("SELECT * FROM ".DB::table('common_member_connect')." WHERE uid='$_G[uid]'");
	if ($connect_member) {
		$_G['member'] = array_merge($_G['member'], $connect_member);
		$user_auth_fields = $connect_member['conisfeed'];
		if ($user_auth_fields == 0) {
			$_G['member']['is_user_info'] = 0;
			$_G['member']['is_feed'] = 0;
		} elseif ($user_auth_fields == 1) {
			$_G['member']['is_user_info'] = 1;
			$_G['member']['is_feed'] = 1;
		} elseif ($user_auth_fields == 2) {
			$_G['member']['is_user_info'] = 1;
			$_G['member']['is_feed'] = 0;
		} elseif ($user_auth_fields == 3) {
			$_G['member']['is_user_info'] = 0;
			$_G['member']['is_feed'] = 1;
		}
		unset($connect_member, $_G['member']['conisfeed']);
	}
}

function connect_auth_field($is_user_info, $is_feed) {
	if ($is_user_info && $is_feed) {
		return 1;
	} elseif (!$is_user_info && !$is_feed) {
		return 0;
	} elseif ($is_user_info && !$is_feed) {
		return 2;
	} elseif (!$is_user_info && $is_feed) {
		return 3;
	}
}

function connect_errlog($errno, $error) {
	global $_G;
	writelog('errorlog', $_G['timestamp']."\t[QQConnect]".$errno." ".$error);
}

// note غ
define('X_BOARDURL', $_G['setting']['discuzurl']);

function connect_parse_bbcode($bbcode, $fId, $pId, $isHtml, &$attachImages) {
	include_once libfile('function/discuzcode');

	$result = preg_replace('/\[hide(=\d+)?\].+?\[\/hide\](\r\n|\n|\r)/i', '', $bbcode);
	$result = preg_replace('/\[payto(=\d+)?\].+?\[\/payto\](\r\n|\n|\r)/i', '', $result);
	$result = discuzcode($result, 0, 0, $isHtml, 1, 2, 1, 0, 0, 0, 0, 1, 0);
	$result = preg_replace('/<img src="images\//i', "<img src=\"".$_G['siteurl']."images/", $result);
	$result = connect_parse_attach($result, $fId, $pId, $attachImages, $attachImageThumb);
	return $result;
}

function connect_parse_attach($content, $fId, $pId, &$attachImages) {
	global $_G;

	$permissions = connect_get_user_group_permissions(array(7));
	$visitorPermission = $permissions[7];

	$attachIds = array();
	$attachImages = array ();
	$query = DB :: query("SELECT aid, filename, isimage, readperm, price FROM ".DB :: table('forum_attachment')." WHERE pid='$pId'");
	while ($attach = DB :: fetch($query)) {
		$aid = $attach['aid'];
		if($attach['isimage'] == 0 || $attach['price'] > 0 || $attach['readperm'] > $visitorPermission['readPermission'] || in_array($fId, $visitorPermission['forbidViewAttachForumIds']) || in_array($attach['aid'], $attachIds)) {
			continue;
		}

		$imageItem = array ();
		$thumbWidth = '100';
		$thumbHeight = '100';
		$bigWidth = '400';
		$bigHeight = '400';
		$key = authcode("$aid\t$thumbWidth\t$thumbHeight", 'ENCODE', $_G['config']['security']['authkey']);
		$thumbImageURL = $_G['siteurl'] . 'forum.php?mod=image&aid='.$aid.'&size='.$thumbWidth.'x'.$thumbHeight.'&key='.rawurlencode($key).'&type=fixwr&nocache=1';
		$key = authcode("$aid\t$bigWidth\t$bigHeight", 'ENCODE', $_G['config']['security']['authkey']);
		$bigImageURL = $_G['siteurl'] . 'forum.php?mod=image&aid='.$aid.'&size='.$bigWidth.'x'.$bigHeight.'&key='.rawurlencode($key).'&type=fixnone&nocache=1';
		$imageItem['aid'] = $aid;
		$imageItem['thumb'] = $thumbImageURL;
		$imageItem['big'] = $bigImageURL;

		$attachIds[] = $aid;
		$attachImages[] = $imageItem;
	}
	$content = preg_replace('/\[attach\](\d+)\[\/attach\]/ie', 'connect_parse_attach_tag(\\1, $attachNames)', $content);
	return $content;
}

function connect_parse_attach_tag($attachId, $attachNames) {
	include_once libfile('function/discuzcode');
	if(array_key_exists($attachId, $attachNames)) {
		return '<span class="attach"><a href="'.$_G['siteurl'].'/attachment.php?aid='.aidencode($attachId).'">'.$attachNames[$attachId].'</a></span>';
	}
	return '';
}

function connect_get_user_group_permissions($userGroupIds) {
	global $_G;

	$fields = array (
		'groupid' => 'userGroupId',
		'grouptitle' => 'userGroupName',
		'readaccess' => 'readPermission',
		'allowvisit' => 'allowVisit'
	);
	$userGroups = array ();
	$query = DB :: query("SELECT f.*,ff.* FROM ".DB :: table('common_usergroup')." f
			LEFT JOIN ".DB :: table('common_usergroup_field')." ff USING(groupid)
			WHERE f.groupid IN (".dimplode($userGroupIds).")");
	while ($row = DB :: fetch($query)) {
		foreach ($row as $k => $v) {
			if(array_key_exists($k, $fields)) {
				$userGroups[$row['groupid']][$fields[$k]] = $v;
			}
			$userGroups[$row['groupid']]['forbidForumIds'] = array ();
			$userGroups[$row['groupid']]['allowForumIds'] = array ();
			$userGroups[$row['groupid']]['specifyAllowForumIds'] = array ();
			$userGroups[$row['groupid']]['allowViewAttachForumIds'] = array ();
			$userGroups[$row['groupid']]['forbidViewAttachForumIds'] = array ();
		}
	}

	$query = DB :: query("SELECT ff.* FROM ".DB :: table('forum_forum')." f
			INNER JOIN ".DB :: table('forum_forumfield')." ff USING(fid) WHERE f.status='1'");
	while ($row = DB :: fetch($query)) {
		$allowViewGroupIds = array ();
		if($row['viewperm']) {
			$allowViewGroupIds = explode("\t", $row['viewperm']);
		}
		$allowViewAttachGroupIds = array ();
		if($row['getattachperm']) {
			$allowViewAttachGroupIds = explode("\t", $row['getattachperm']);
		}
		foreach ($userGroups as $gid => $_v) {
			if($row['password']) {
				$userGroups[$gid]['forbidForumIds'][] = $row['fid'];
				continue;
			}
			$perm = unserialize($row['formulaperm']);
			if(is_array($perm)) {
				if($perm[0] || $perm[1] || $perm['users']) {
					$userGroups[$gid]['forbidForumIds'][] = $row['fid'];
					continue;
				}
			}
			if(!$allowViewGroupIds) {
				$userGroups[$gid]['allowForumIds'][] = $row['fid'];
			}
			elseif(!in_array($gid, $allowViewGroupIds)) {
				$userGroups[$gid]['forbidForumIds'][] = $row['fid'];
			}
			elseif(in_array($gid, $allowViewGroupIds)) {
				$userGroups[$gid]['allowForumIds'][] = $row['fid'];
				$userGroups[$gid]['specifyAllowForumIds'][] = $row['fid'];
			}
			if(!$allowViewAttachGroupIds) {
				$userGroups[$gid]['allowViewAttachForumIds'][] = $row['fid'];
			}
			elseif(!in_array($gid, $allowViewAttachGroupIds)) {
				$userGroups[$gid]['forbidViewAttachForumIds'][] = $row['fid'];
			}
			elseif(in_array($gid, $allowViewGroupIds)) {
				$userGroups[$gid]['allowViewAttachForumIds'][] = $row['fid'];
			}
		}
	}
	return $userGroups;
}

function connect_share_error($message, $type = 'alert') {
	echo "connect_share_loaded = 1;";
	echo "\n";
	echo "connect_show_dialog('', '$message', '$type');";
	exit;
}

function connect_http_build_query($data, $numeric_prefix='', $arg_separator='', $prefix='') {
	$render = array();
	if (empty($arg_separator)) {
		$arg_separator = @ini_get('arg_separator.output');
		empty($arg_separator) && $arg_separator = '&';
	}
	foreach ((array) $data as $key => $val) {
		if (is_array($val) || is_object($val)) {
			$_key = empty($prefix) ? "{$key}[%s]" : sprintf($prefix, $key) . "[%s]";
			$_render = connect_http_build_query($val, '', $arg_separator, $_key);
			if (!empty($_render)) {
				$render[] = $_render;
			}
		} else {
			if (is_numeric($key) && empty($prefix)) {
				$render[] = urlencode("{$numeric_prefix}{$key}") . "=" . urlencode($val);
			} else {
				if (!empty($prefix)) {
					$_key = sprintf($prefix, $key);
					$render[] = urlencode($_key) . "=" . urlencode($val);
				} else {
					$render[] = urlencode($key) . "=" . urlencode($val);
				}
			}
		}
	}
	$render = implode($arg_separator, $render);
	if (empty($render)) {
		$render = '';
	}
	return $render;
}

function connect_is_valid_openid($openid, $timestamp, $sig) {
	global $_G;
	$key = $_G['setting']['connectappkey'];
	$str = $openid.$timestamp;
	$signature = connect_custom_hmac($str, $key);

	return $sig == $signature;
}

// URLݵconenctŵӦ
function connect_params($params, & $connect_params) {
	global $_G;

	if(!$params) {
		return false;
	}
	$connect_params = array ();
	foreach ($params as $key => $value) {
		if(substr($key, 0, 4) == 'con_') {
			$connect_params[substr($key, 4)] = $value;
		}
	}
}

function connect_get_user_info($openid, $access_token, $access_token_secret) {
	global $_G;

	$api_url = $_G['connect']['api_url'].'/user/get_user_info';

	$extra = array();
	$extra['oauth_token'] = $access_token;
	$extra['openid'] = $openid;
	$extra['format'] = 'xml';

	$sig_params = connect_get_oauth_signature_params($extra);
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'GET', $access_token_secret);

	$response = connect_output_php($api_url.'?'.connect_http_build_query($sig_params, '', '&'), '', 'xml');

	$data = connect_parse_xml($response);

	if(strtoupper(CHARSET) != 'UTF-8') {
		require_once libfile('class/chinese');
		$c = new Chinese('utf8', CHARSET, TRUE);
		foreach($data as $k => $v) {
			$data[$k] = $c->Convert($v);
		}
	}
	
	if(!$data) {
		$res = array();
	} else {
		$res = $data;
	}

	return $res;
}

function connect_parse_xml($xml) {

	$handle = xml_parser_create();
	xml_parser_set_option($handle, XML_OPTION_CASE_FOLDING, false);
	$result = xml_parse_into_struct($handle, $xml, $vals, $index);
	xml_parser_free($handle);

	$data = array();
	if ($result === 0) {
		return $data;
	}

	$num = count($index['data']);
	$ret = array_slice($vals, $index['data'][0] + 1, ($index['data'][$num] - $index['data'][0] - 1));
	foreach ($ret as $row) {
		if (trim($row['value'])) {
			$data[$row['tag']] = trim($row['value']);
		} else if ($row['data']) {
			$data[$row['tag']] = trim($row['data']);
		}
	}

	return $data;
}

function generateSiteSignUrl($params = array(), $isEncode = true, $isCamelCase = false) {
	global $_G;

	$ts = TIMESTAMP;
	$sId = $_G['setting']['my_siteid'];
	$sKey = $_G['setting']['my_sitekey'];
	$uid = $_G['uid'];

	if(!is_array($params)) {
		$params = array();
	}

	unset($params['sig'], $params['ts']);

	if ($isCamelCase) {
		$params['sId'] = $sId;
		$params['sSiteUid'] = $uid;
	} else {
		$params['s_id'] = $sId;
		$params['s_site_uid'] = $uid;
	}

	ksort($params);

	$str = buildArrayQuery($params, '', $isEncode);
	$sig = md5(sprintf('%s|%s|%s', $str, $sKey, $ts));

	$params['ts'] = $ts;
	$params['sig'] = $sig;

	$url = buildArrayQuery($params, '', $isEncode);
	return $url;
}

function buildArrayQuery($data, $key = '', $isEncode = false) {

	if ($key) {
		$query =  array($key => $data);
	} else {
		$query = $data;
	}

	if ($isEncode) {
		return connect_http_build_query($query, '', '&');
	} else {
		return connect_http_build_query($query);
	}
}

function connect_decode_appkey($appkey) {

	if (!$appkey) {
		return;
	}
	$parse_result = base64_decode($appkey);
	$data = explode('|', $parse_result);
	if(count($data) != 3) {
		return;
	}

	$result = array(
					'connectappkey' => $data[0],
					'my_siteid' => $data[1],
					'my_sitekey' => $data[2],
					);
	return $result;
}

function connect_encode_appkey($connectAppKey, $sId, $sKey) {

	if(!$connectAppKey || !$sId || !$sKey) {
		return;
	}

	return base64_encode(sprintf("%s|%s|%s", $connectAppKey, $sId, $sKey));
}

function connect_get_manyou_sig($params, $sKey = '') {

	$ts = $params['ts'];
	unset($params['ts']);

	ksort($params);
	if($sKey) {
		$base_string = sprintf("%s|%s|%s", connect_http_build_query($params, '', '&'), $ts, $sKey);
	} else {
		$base_string = sprintf("%s|%s", connect_http_build_query($params, '', '&'), $ts);
	}

	return md5($base_string);
}

function connect_filter_username($username) {
	$username = str_replace(' ', '_', trim($username));
	return cutstr($username, 15, '');
}

?>
