<?php

/**
 *      [Discuz!] (C)2001-2099 Comsenz Inc.
 *      This is NOT a freeware, use is subject to license terms
 *
 *      $Id: connect_login.php 22999 2011-06-13 06:01:54Z yangli $
 */

if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

require_once libfile('function/connect');

$referer = dreferer();
preg_match('/^(http|https|ftp|javascript):/i', $referer, $matches);
if($matches) {
    $referer = 'forum.php';
}

$op = !empty($_G['gp_op']) ? trim($_G['gp_op'], '/') : '';
if(!in_array($op, array('init', 'callback', 'change'))) {
	showmessage('undefined_action');
}

// debug ȡδȨrequest token
if($op == 'init') {

	dsetcookie('con_request_token');
	dsetcookie('con_request_token_secret');

	// debug ûδȨtmp token
	$response = connect_get_request_token();
	if(empty($response) || isset($response['error_code'])) {
		if(!isset($response['error_code'])) {
			connect_errlog('100', lang('connect', 'connect_errlog_server_no_response'));
		} else {
			connect_errlog($response['error_code'], $response['result']);
		}
		showmessage('qqconnect:connect_get_request_token_failed', $referer);
	}

	$request_token = $response['oauth_token'];
	$request_token_secret = $response['oauth_token_secret'];

	// debug δȨoauth_tokenoauth_token_secretǵcookie
	dsetcookie('con_request_token', $request_token);
	dsetcookie('con_request_token_secret', $request_token_secret);

	// debug ظConnectӦȨҳĲ
	$params = array(
		'oauth_token' => $request_token,
		'oauth_consumer_key' => $_G['setting']['connectappid'],
		'oauth_callback' => $_G['connect']['callback_url'],
	);

	dsetcookie('connect_referer', $referer);

	// debug ûӦȨҳ
	$redirect = $_G['connect']['api_url'] . '/oauth/qzoneoauth_authorize?'.connect_http_build_query($params, '', '&');
	dheader('Location:' . $redirect);

// debug Callback
} elseif($op == 'callback') {

	$params = $_GET;

	// debug ֤ConnectصSig
	if(!connect_is_valid_openid($_G['gp_openid'], $_G['gp_timestamp'], $_G['gp_oauth_signature'])) {
		connect_errlog('103', lang('connect', 'connect_errlog_sig_incorrect'));
		showmessage('qqconnect:connect_invalid_params', $referer);
	}

	// debug ̳ҳضconnectе¼Ȩǰconnectص̳callbackҳIE9˼ͼcallback⵼֮ǰcookie޷ȡ
	// debug һ±ҳʹ֮صͼĿǽIE9ͼòcookie
	if(!isset($_G['gp_receive'])) {
		echo '<script type="text/javascript">setTimeout("window.location.href=\'connect.php?receive=yes&'.str_replace("'", "\'", connect_http_build_query($_GET, '', '&')).'\'", 1)</script>';
		exit;
	}

	// debug ûȨtmp token
	$request_token = $_G['gp_oauth_token'];
	$verify_code = $_G['gp_oauth_vericode'];

	if($request_token && $verify_code) {
		$response = connect_get_access_token($request_token, $verify_code);

		if(empty($response) || isset($response['error_code'])) {
			if(isset($response['error_code'])) {
				connect_errlog($response['error_code'], 'connect_errlog_server_no_response');
			}
			showmessage('qqconnect:connect_get_access_token_failed', $referer);
		}

		$conuin = $response['oauth_token'];
		$conuinsecret = $response['oauth_token_secret'];
		$conopenid = $response['openid'];
		if(!$conuin || !$conuinsecret || !$conopenid) {
			connect_errlog('101', 'connect_errlog_access_token_incomplete');
			showmessage('qqconnect:connect_get_access_token_failed', $referer);
		}
	} else {
		connect_errlog('102', lang('connect', 'connect_errlog_request_token_not_authorized'));
		showmessage('qqconnect:connect_get_request_token_failed', $referer);
	}

	// debug 
	loadcache('connect_blacklist');
	if(in_array($conuin, $_G['cache']['connect_blacklist'])) {
		$params = array(
			'oauth_token' => $request_token,
			'oauth_consumer_key' => $_G['setting']['connectappid']
		);
		$change_qq_url = $_G['connect']['change_qq_url'];
		showmessage('qqconnect:connect_uin_in_blacklist', $referer, array('changeqqurl' => $change_qq_url));
	}

	// debug ½ɹ󷵻صĵַ
	$referer = $_G['cookie']['connect_referer'];
	$referer = $referer && (strpos($referer, 'logging') === false) && (strpos($referer, 'login') === false) ? $referer : 'forum.php';

	// debug Cookies
	$cookie_expires = 2592000;
	dsetcookie('client_created', TIMESTAMP, $cookie_expires);
	dsetcookie('client_token', $conopenid, $cookie_expires);

	$connect_member = array();
	// debug ȡQCû󶨹ϵ
	$connect_member = DB::fetch_first("SELECT uid, conuin, conuinsecret, conopenid FROM ".DB::table('common_member_connect')." WHERE conopenid='$conopenid'");
	if($connect_member) {
		$member = DB::fetch_first("SELECT uid, conisbind FROM ".DB::table('common_member')." WHERE uid='$connect_member[uid]'");
		if($member) {
			if(!$member['conisbind']) {
				unset($connect_member);
			} else {
				$connect_member['conisbind'] = $member['conisbind'];
			}
		} else {
			DB::delete('common_member_connect', array('uid' => $connect_member['uid']));
			unset($connect_member);
		}
	}

	// debug ̳˺ŵ¼ȻٵQQ
	if($_G['uid']) {

		// debug ǰʹõQQѾһ̳˺ţ̳˺Ųǵǰ¼̳˺
		if($connect_member && $connect_member['uid'] != $_G['uid']) {
			showmessage('qqconnect:connect_register_bind_uin_already', $referer, array('username' => $_G['member']['username']));
		}

		$current_connect_member = DB::fetch_first("SELECT * FROM ".DB::table('common_member_connect')." WHERE uid='$_G[uid]'");
		if($current_connect_member) {
			// debug ǰ̳¼ѾһQQˣ޷ٰ󶨵ǰQQ
			if($current_connect_member['conopenid'] && $current_connect_member['conopenid'] != $conopenid) {
				showmessage('qqconnect:connect_register_bind_already', $referer);
			}

			DB::query("UPDATE ".DB::table('common_member_connect')." SET conuin='$conuin', conuinsecret='$conuinsecret', conopenid='$conopenid', conisregister='0' WHERE uid='$_G[uid]'");

		} else { // debug ǰ¼̳˺ŲûаκQQţ԰󶨵ǰQQ
			DB::query("INSERT INTO ".DB::table('common_member_connect')." (uid, conuin, conuinsecret, conopenid, conisregister) VALUES ('$_G[uid]', '$conuin', '$conuinsecret', '$conopenid', '0')");
		}

		DB::query("UPDATE ".DB::table('common_member')." SET conisbind='1' WHERE uid='$_G[uid]'");

		// debug û֪ͨConnect
		dsetcookie('connect_js_name', 'user_bind', 86400);
		dsetcookie('connect_js_params', base64_encode(serialize(array('type' => 'loginbind'))), 86400);
		dsetcookie('connect_login', 1, 31536000);
		dsetcookie('connect_is_bind', '1', 31536000);
		dsetcookie('connect_uin', $conopenid, 31536000);
		$_G['inshowmessage'] = 1;

		// debug ¼QCû
		DB::query("INSERT INTO ".DB::table('connect_memberbindlog')." (uid, uin, type, dateline) VALUES ('$_G[uid]', '$conopenid', '1', '$_G[timestamp]')");

		showmessage('qqconnect:connect_register_bind_success', $referer);

	// debug δ¼û
	} else {

		if($connect_member) { // debug ˷֧ûֱӵQQ¼QQѾһ̳˺ˣֱӵǽ̳

			DB::query("UPDATE ".DB::table('common_member_connect')." SET conuin='$conuin', conuinsecret='$conuinsecret' WHERE uid='$connect_member[uid]'");

			$params['mod'] = 'login';
			connect_login($connect_member);

			loadcache('usergroups');
			$usergroups = $_G['cache']['usergroups'][$_G['groupid']]['grouptitle'];
			$param = array('username' => $_G['member']['username'], 'usergroup' => $_G['group']['grouptitle']);

			DB::query("UPDATE ".DB::table('common_member_status')." SET lastip='".$_G['clientip']."', lastvisit='".time()."' WHERE uid='$connect_member[uid]'");
			$ucsynlogin = '';
			if($_G['setting']['allowsynlogin']) {
				loaducenter();
				$ucsynlogin = uc_user_synlogin($_G['uid']);
			}

			showmessage('login_succeed', $referer, $param, array('extrajs' => $ucsynlogin));

		} else { // debug ˷֧ûֱӵQQ¼QQŻδκ̳˺ţתһҳûע̳˺Żһе̳˺

			// debug Ϊaccess token
			// debug access tokenܺ󣬴ע
			$encode[] = authcode($conuin, 'ENCODE');
			$encode[] = authcode($conuinsecret, 'ENCODE');
			$encode[] = authcode($conopenid, 'ENCODE');
			$auth_hash = authcode(implode('|', $encode), 'ENCODE');
			// debug ܴCookie
			dsetcookie('con_auth_hash', $auth_hash);

			unset($params['op']);
			$params['mod'] = 'register';
			$params['referer'] = $referer;

			unset($params['oauth_token']);
			unset($params['oauth_verifycode']);

			$redirect = 'connect.php?'.connect_http_build_query($params, '', '&');
			dheader("Location: $redirect");
		}
	}

// debug QQ˺ص¼
} elseif($op == 'change') {

	dsetcookie('con_request_token');
	dsetcookie('con_request_token_secret');

	// debug ûδȨtmp token
	$response = connect_get_request_token();
	if(empty($response) || isset($response['error_code'])) {
		if(isset($response['error_code'])) {
			connect_errlog($response['error_code'], $response['result']);
		}
		showmessage('qqconnect:connect_get_request_token_failed', $referer);
	}

	$request_token = $response['oauth_token'];
	$request_token_secret = $response['oauth_token_secret'];

	dsetcookie('con_request_token', $request_token);
	dsetcookie('con_request_token_secret', $request_token_secret);

	$params = array(
		'oauth_token' => $request_token,
		'oauth_consumer_key' => $_G['setting']['connectappid'],
		'oauth_callback' => $_G['connect']['callback_url'],
	);

	$redirect = $_G['connect']['api_url'] . '/oauth/qzoneoauth_authorize?'.connect_http_build_query($params, '', '&');
	dheader('Location:' . $redirect);
}

function connect_login($connect_member) {
	global $_G;

	$member = DB::fetch_first("SELECT * FROM ".DB::table('common_member')." WHERE uid='$connect_member[uid]'");
	if(!$member) {
		return false;
	}

	require_once libfile('function/member');
	$cookietime = 1296000;
	setloginstatus($member, $cookietime);

	dsetcookie('connect_login', 1, $cookietime);
	dsetcookie('connect_is_bind', '1', 31536000);
	dsetcookie('connect_uin', $connect_member['conopenid'], 31536000);

	include_once libfile('function/stat');
	updatestat('login', 1);

	updatecreditbyaction('daylogin', $_G['uid']);
	checkusergroup($_G['uid']);
	return true;
}
?>
