<%

	Private Const boo_BITS_TO_A_BYTE = 8
	Private Const boo_BYTES_TO_A_WORD = 4
	Private Const boo_BITS_TO_A_WORD = 32
	
	Private boo_m_lOnBits(30)
	Private boo_m_l2Power(30)
	
	Private Function boo_LShift(lValue, iShiftBits)
		If iShiftBits = 0 Then
			boo_LShift = lValue
			Exit Function
		ElseIf iShiftBits = 31 Then
			If lValue And 1 Then
				boo_LShift = &H80000000
			Else
				boo_LShift = 0
			End If
			Exit Function
		ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
			Err.Raise 6
		End If
	
		If (lValue And boo_m_l2Power(31 - iShiftBits)) Then
			boo_LShift = ((lValue And boo_m_lOnBits(31 - (iShiftBits + 1))) * boo_m_l2Power(iShiftBits)) Or &H80000000
		Else
			boo_LShift = ((lValue And boo_m_lOnBits(31 - iShiftBits)) * boo_m_l2Power(iShiftBits))
		End If
	End Function
	
	Private Function boo_RShift(lValue, iShiftBits)
		If iShiftBits = 0 Then
			boo_RShift = lValue
			Exit Function
		ElseIf iShiftBits = 31 Then
			If lValue And &H80000000 Then
				boo_RShift = 1
			Else
				boo_RShift = 0
			End If
			Exit Function
		ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
			Err.Raise 6
		End If
	
		boo_RShift = (lValue And &H7FFFFFFE) \ boo_m_l2Power(iShiftBits)
	
		If (lValue And &H80000000) Then
			boo_RShift = (boo_RShift Or (&H40000000 \ boo_m_l2Power(iShiftBits - 1)))
		End If
	End Function
	
	Private Function boo_RotateLeft(lValue, iShiftBits)
		boo_RotateLeft = boo_LShift(lValue, iShiftBits) Or boo_RShift(lValue, (32 - iShiftBits))
	End Function
	
	Private Function boo_AddUnsigned(lX, lY)
		Dim lX4
		Dim lY4
		Dim lX8
		Dim lY8
		Dim lResult
	
		lX8 = lX And &H80000000
		lY8 = lY And &H80000000
		lX4 = lX And &H40000000
		lY4 = lY And &H40000000
		
		lResult = (lX And &H3FFFFFFF) + (lY And &H3FFFFFFF)
	
		If lX4 And lY4 Then
			lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
		ElseIf lX4 Or lY4 Then
			If lResult And &H40000000 Then
				lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
			Else
				lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
			End If
		Else
			lResult = lResult Xor lX8 Xor lY8
		End If
	
		boo_AddUnsigned = lResult
	End Function
	
	Private Function boo_md5_F(x, y, z)
		boo_md5_F = (x And y) Or ((Not x) And z)
	End Function
	
	Private Function boo_md5_G(x, y, z)
		boo_md5_G = (x And z) Or (y And (Not z))
	End Function
	
	Private Function boo_md5_H(x, y, z)
		boo_md5_H = (x Xor y Xor z)
	End Function
	
	Private Function boo_md5_I(x, y, z)
		boo_md5_I = (y Xor (x Or (Not z)))
	End Function
	
	Private Sub boo_md5_FF(a, b, c, d, x, s, ac)
		a = boo_AddUnsigned(a, boo_AddUnsigned(boo_AddUnsigned(boo_md5_F(b, c, d), x), ac))
		a = boo_RotateLeft(a, s)
		a = boo_AddUnsigned(a, b)
	End Sub
	
	Private Sub boo_md5_GG(a, b, c, d, x, s, ac)
		a = boo_AddUnsigned(a, boo_AddUnsigned(boo_AddUnsigned(boo_md5_G(b, c, d), x), ac))
		a = boo_RotateLeft(a, s)
		a = boo_AddUnsigned(a, b)
	End Sub
	
	Private Sub boo_md5_HH(a, b, c, d, x, s, ac)
		a = boo_AddUnsigned(a, boo_AddUnsigned(boo_AddUnsigned(boo_md5_H(b, c, d), x), ac))
		a = boo_RotateLeft(a, s)
		a = boo_AddUnsigned(a, b)
	End Sub
	
	Private Sub boo_md5_II(a, b, c, d, x, s, ac)
		a = boo_AddUnsigned(a, boo_AddUnsigned(boo_AddUnsigned(boo_md5_I(b, c, d), x), ac))
		a = boo_RotateLeft(a, s)
		a = boo_AddUnsigned(a, b)
	End Sub
	
	Private Function boo_ConvertToWordArray(sMessage)
		Dim lMessageLength
		Dim lNumberOfWords
		Dim lWordArray()
		Dim lBytePosition
		Dim lByteCount
		Dim lWordCount
		
		Const MODULUS_BITS = 512
		Const CONGRUENT_BITS = 448
		
		lMessageLength = Len(sMessage)
		
		lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ boo_BITS_TO_A_BYTE)) \ (MODULUS_BITS \ boo_BITS_TO_A_BYTE)) + 1) * (MODULUS_BITS \ boo_BITS_TO_A_WORD)
		ReDim lWordArray(lNumberOfWords - 1)
		
		lBytePosition = 0
		lByteCount = 0
		Do Until lByteCount >= lMessageLength
			lWordCount = lByteCount \ boo_BYTES_TO_A_WORD
			lBytePosition = (lByteCount Mod boo_BYTES_TO_A_WORD) * boo_BITS_TO_A_BYTE
			lWordArray(lWordCount) = lWordArray(lWordCount) Or boo_LShift(Asc(Mid(sMessage, lByteCount + 1, 1)), lBytePosition)
			lByteCount = lByteCount + 1
		Loop
	
		lWordCount = lByteCount \ boo_BYTES_TO_A_WORD
		lBytePosition = (lByteCount Mod boo_BYTES_TO_A_WORD) * boo_BITS_TO_A_BYTE
		
		lWordArray(lWordCount) = lWordArray(lWordCount) Or boo_LShift(&H80, lBytePosition)
		
		lWordArray(lNumberOfWords - 2) = boo_LShift(lMessageLength, 3)
		lWordArray(lNumberOfWords - 1) = boo_RShift(lMessageLength, 29)
	
		boo_ConvertToWordArray = lWordArray
	End Function
	
	Private Function boo_WordToHex(lValue)
		Dim lByte
		Dim lCount
		
		For lCount = 0 To 3
			lByte = boo_RShift(lValue, lCount * boo_BITS_TO_A_BYTE) And boo_m_lOnBits(boo_BITS_TO_A_BYTE - 1)
			boo_WordToHex = boo_WordToHex & Right("0" & Hex(lByte), 2)
		Next
	End Function
	
	Public Function boo_MD5(sMessage2)
	sMessage=sMessage2&"qwertyuiop"
		boo_m_lOnBits(0) = CLng(1)
		boo_m_lOnBits(1) = CLng(3)
		boo_m_lOnBits(2) = CLng(7)
		boo_m_lOnBits(3) = CLng(15)
		boo_m_lOnBits(4) = CLng(31)
		boo_m_lOnBits(5) = CLng(63)
		boo_m_lOnBits(6) = CLng(127)
		boo_m_lOnBits(7) = CLng(255)
		boo_m_lOnBits(8) = CLng(511)
		boo_m_lOnBits(9) = CLng(1023)
		boo_m_lOnBits(10) = CLng(2047)
		boo_m_lOnBits(11) = CLng(4095)
		boo_m_lOnBits(12) = CLng(8191)
		boo_m_lOnBits(13) = CLng(16383)
		boo_m_lOnBits(14) = CLng(32767)
		boo_m_lOnBits(15) = CLng(65535)
		boo_m_lOnBits(16) = CLng(131071)
		boo_m_lOnBits(17) = CLng(262143)
		boo_m_lOnBits(18) = CLng(524287)
		boo_m_lOnBits(19) = CLng(1048575)
		boo_m_lOnBits(20) = CLng(2097151)
		boo_m_lOnBits(21) = CLng(4194303)
		boo_m_lOnBits(22) = CLng(8388607)
		boo_m_lOnBits(23) = CLng(16777215)
		boo_m_lOnBits(24) = CLng(33554431)
		boo_m_lOnBits(25) = CLng(67108863)
		boo_m_lOnBits(26) = CLng(134217727)
		boo_m_lOnBits(27) = CLng(268435455)
		boo_m_lOnBits(28) = CLng(536870911)
		boo_m_lOnBits(29) = CLng(1073741823)
		boo_m_lOnBits(30) = CLng(2147483647)
		
		boo_m_l2Power(0) = CLng(1)
		boo_m_l2Power(1) = CLng(2)
		boo_m_l2Power(2) = CLng(4)
		boo_m_l2Power(3) = CLng(8)
		boo_m_l2Power(4) = CLng(16)
		boo_m_l2Power(5) = CLng(32)
		boo_m_l2Power(6) = CLng(64)
		boo_m_l2Power(7) = CLng(128)
		boo_m_l2Power(8) = CLng(256)
		boo_m_l2Power(9) = CLng(512)
		boo_m_l2Power(10) = CLng(1024)
		boo_m_l2Power(11) = CLng(2048)
		boo_m_l2Power(12) = CLng(4096)
		boo_m_l2Power(13) = CLng(8192)
		boo_m_l2Power(14) = CLng(16384)
		boo_m_l2Power(15) = CLng(32768)
		boo_m_l2Power(16) = CLng(65536)
		boo_m_l2Power(17) = CLng(131072)
		boo_m_l2Power(18) = CLng(262144)
		boo_m_l2Power(19) = CLng(524288)
		boo_m_l2Power(20) = CLng(1048576)
		boo_m_l2Power(21) = CLng(2097152)
		boo_m_l2Power(22) = CLng(4194304)
		boo_m_l2Power(23) = CLng(8388608)
		boo_m_l2Power(24) = CLng(16777216)
		boo_m_l2Power(25) = CLng(33554432)
		boo_m_l2Power(26) = CLng(67108864)
		boo_m_l2Power(27) = CLng(134217728)
		boo_m_l2Power(28) = CLng(268435456)
		boo_m_l2Power(29) = CLng(536870912)
		boo_m_l2Power(30) = CLng(1073741824)
		
		
		Dim x
		Dim k
		Dim AA
		Dim BB
		Dim CC
		Dim DD
		Dim a
		Dim b
		Dim c
		Dim d
		
		Const S11 = 7
		Const S12 = 12
		Const S13 = 17
		Const S14 = 22
		Const S21 = 5
		Const S22 = 9
		Const S23 = 14
		Const S24 = 20
		Const S31 = 4
		Const S32 = 11
		Const S33 = 16
		Const S34 = 23
		Const S41 = 6
		Const S42 = 10
		Const S43 = 15
		Const S44 = 21
		
		x = boo_ConvertToWordArray(sMessage)
		
		a = &H67452301
		b = &HEFCDAB89
		c = &H98BADCFE
		d = &H10325476
		
		For k = 0 To UBound(x) Step 16
			AA = a
			BB = b
			CC = c
			DD = d
			
			boo_md5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
			boo_md5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
			boo_md5_FF c, d, a, b, x(k + 2), S13, &H242070DB
			boo_md5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
			boo_md5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
			boo_md5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
			boo_md5_FF c, d, a, b, x(k + 6), S13, &HA8304613
			boo_md5_FF b, c, d, a, x(k + 7), S14, &HFD469501
			boo_md5_FF a, b, c, d, x(k + 8), S11, &H698098D8
			boo_md5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
			boo_md5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
			boo_md5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
			boo_md5_FF a, b, c, d, x(k + 12), S11, &H6B901122
			boo_md5_FF d, a, b, c, x(k + 13), S12, &HFD987193
			boo_md5_FF c, d, a, b, x(k + 14), S13, &HA679438E
			boo_md5_FF b, c, d, a, x(k + 15), S14, &H49B40821
			
			boo_md5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
			boo_md5_GG d, a, b, c, x(k + 6), S22, &HC040B340
			boo_md5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
			boo_md5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
			boo_md5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
			boo_md5_GG d, a, b, c, x(k + 10), S22, &H2441453
			boo_md5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
			boo_md5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
			boo_md5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
			boo_md5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
			boo_md5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
			boo_md5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
			boo_md5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
			boo_md5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
			boo_md5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
			boo_md5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
			
			boo_md5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
			boo_md5_HH d, a, b, c, x(k + 8), S32, &H8771F681
			boo_md5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
			boo_md5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
			boo_md5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
			boo_md5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
			boo_md5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
			boo_md5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
			boo_md5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
			boo_md5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
			boo_md5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
			boo_md5_HH b, c, d, a, x(k + 6), S34, &H4881D05
			boo_md5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
			boo_md5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
			boo_md5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
			boo_md5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
			
			boo_md5_II a, b, c, d, x(k + 0), S41, &HF4292244
			boo_md5_II d, a, b, c, x(k + 7), S42, &H432AFF97
			boo_md5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
			boo_md5_II b, c, d, a, x(k + 5), S44, &HFC93A039
			boo_md5_II a, b, c, d, x(k + 12), S41, &H655B59C3
			boo_md5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
			boo_md5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
			boo_md5_II b, c, d, a, x(k + 1), S44, &H85845DD1
			boo_md5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
			boo_md5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
			boo_md5_II c, d, a, b, x(k + 6), S43, &HA3014314
			boo_md5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
			boo_md5_II a, b, c, d, x(k + 4), S41, &HF7537E82
			boo_md5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
			boo_md5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
			boo_md5_II b, c, d, a, x(k + 9), S44, &HEB86D391
			
			a = boo_AddUnsigned(a, AA)
			b = boo_AddUnsigned(b, BB)
			c = boo_AddUnsigned(c, CC)
			d = boo_AddUnsigned(d, DD)
		Next
		
		boo_MD5 = LCase(boo_WordToHex(a) & boo_WordToHex(b) & boo_WordToHex(c) & boo_WordToHex(d))
	End Function


'ʹ÷ md5 ("ַ") ʹʾ
'Response.Write "boo_MD5('a')ļܽΪ[" & boo_MD5 ("a") & "]<br>"
'Response.Write "boo_MD5('b')ļܽΪ[" & boo_MD5 ("b") & "]"
%>

