$(function(){
	jQuery.extend(jQuery.validator.messages,{
	required: "ֶ",
	remote: "ֶ",
	email: "ȷʽĵʼ",
	url: "Ϸַ",
	date: "Ϸ",
	dateISO: "Ϸ (ISO).",
	number: "Ϸ",
	digits: "ֻ",
	creditcard: "Ϸÿ",
	equalTo: "ٴֵͬ",
	accept: "ӵкϷ׺ַ",
	maxlength: jQuery.validator.format(" {0} "),
	minlength: jQuery.validator.format(" {0} "),
	rangelength: jQuery.validator.format("һȽ {0}  {1} ַ֮"),
	range: jQuery.validator.format("һ {0}  {1} ֵ֮"),
	max: jQuery.validator.format("Ϊ {0} "),
	min: jQuery.validator.format("СΪ {0} ")
	});
	
	
	jQuery.validator.addMethod("CheckPics",function(value, element, param){
		var P=value.split(","),L=0;
		for(var i=0;i<P.length;i++){if(P[i]!='')L++;}
		return this.optional(element) || param>=L;
	},$.validator.format("ϴ{0}ͼƬ"));
	jQuery.validator.addMethod("CheckUserName",function(value, element){
		return this.optional(element) || /^[\u4e00-\u9fa5\w]+$/.test(value);
	},'ֻܰ֡Ӣĸֺ»ߣ');
	jQuery.validator.addMethod("CheckUserName1",function(value, element){
		return this.optional(element) || /^\w+$/.test(value);
	},"ֻܰӢĸֺ»ߣ");
	jQuery.validator.addMethod("CheckUserName2", function(value, element){
		return this.optional(element) || !/^\d+$/.test(value);
	}, "ȫעᣡ");  
	jQuery.validator.addMethod("No0", function(value, element){ 
		return this.optional(element) || parseFloat(value)!=0;       
	},"Ϊ0"); 
	jQuery.validator.addMethod("isChina",function(value, element){
		return this.optional(element) || /^[\u4e00-\u9fa5]+$/.test(value);
	},'ֻģ');
	jQuery.validator.addMethod("CheckQQ", function(value, element){return this.optional(element) || /^[1-9][0-9]{4,}$/i.test(value);	}, "ȷдQQ룡"); 
	jQuery.validator.addMethod("byteRangeLength",function(value, element, param){
		value = $.trim(value);
    	var length = value.length;
		$(element).val(value);
   		for(var i = 0; i < value.length; i++){if(value.charCodeAt(i) > 127){length++;}}
		return this.optional(element) || ( length >= param[0] && length <= param[1] );    
	},$.validator.format("ȷֵ{0}-{1}ֽ֮(һ2ֽ)"));

	// ֤       
	jQuery.validator.addMethod("strnumber", function(value, element, param) {
		if(value==param[0])return true;
		if(!$.validator.methods.number.call(this,value,element))return false;
		return this.optional(element) || (parseFloat(value)>=param[1] && parseFloat(value)<=param[2]);  
	}, $.validator.format("ȷдЧֻ{0}"));  
	
	jQuery.validator.addMethod("comparenumber", function(value, element, param){
		if($("#"+param[0]).val()=='')return true;
		var N1=parseFloat(value);
		var N2=parseFloat($("#"+param[0]).val());
		if(param[1]>1){N1=Math.abs(N1);N2=Math.abs(N2);param[1]=param[1]-2}
		return this.optional(element) || (param[1]==0?N1>=N2:N1<=N2);
	});  
		
		
		
		
		
	// ֻ֤
	jQuery.validator.addMethod("isMobile", function(value, element) {       
		var length = value.length;   
		var mobile = /^(((13[0-9]{1})|(15[0-9]{1}))+\d{8})$/;   
		return this.optional(element) || (mobile.test(value));      
	}, "ȷдֻ룡");       
		 
	// 绰֤       
	jQuery.validator.addMethod("isTel", function(value, element) {       
		var tel = /^\d{3,4}-?\d{7,9}$/;    //绰ʽ010-12345678   
		return this.optional(element) || (tel.test(value));       
	}, "ȷдĵ绰룡");
	
	// ϵ绰(ֻ/绰Կ)֤
	jQuery.validator.addMethod("isPhone", function(value,element) {   
		var length = value.length;   
		var mobile = /^(((13[0-9]{1})|(15[0-9]{1}))+\d{8})$/;   
		var tel = /^\d{3,4}-?\d{7,9}$/;  
		return this.optional(element) || (tel.test(value) || mobile.test(value));   
	  
	}, "ȷдϵ绰(ֻ/绰Կ)");   
		 
	// ֤
	jQuery.validator.addMethod("isZipCode", function(value, element) {       
	   var str = /^[0-9]{6}$/;       
		return this.optional(element) || (str.test(value));       
	}, "ȷд룡"); 
	// 
	jQuery.validator.addMethod("Integer", function(value, element) {       
	   var str = /^\-?\d+$/;       
		return this.optional(element) || (str.test(value));
	}, "д"); 
    //Ƚʱ
	jQuery.validator.addMethod("endDate",function(value, element,param) {
		if( /^\d{4}[\/-]\d{1,2}[\/-]\d{1,2}$/.test(param[0]) )
		{
			var D1=new Date(Date.parse(param[0].replace(/\-/g, "/")));
			var D2=new Date(Date.parse(value.replace(/\-/g, "/")));
			return param[1]==0?(D1>=D2):(D1<=D2);
		}else{
			return this.optional(element);
		}
   }, "ڱڿʼ!");

	
	
	
	
	$.validator.setDefaults(
	{
		//errorElement: "em",
		errorPlacement:function(error,element)
		{
			var ID = element.attr('box') || element.attr('id');
			error.removeClass().addClass("error").attr("for",element.attr('id'));
			if($("#box_"+ID).length==0)element.parent().append("<span id=\"box_"+ID+"\"></span>");
			
			if($("#box_"+ID +">label").size()==0)
			{
				$("#box_"+ID).append(error); 
			}else{
				var L=$("#box_"+ID +">label");
				if($.trim(L.html())=='' || L.attr("for")==element.attr('id'))
				{
					L.html(error.html());
					L.attr("for",element.attr('id'));
				}
				L.removeClass().addClass("error")
			}
		},
		success:function(label)
		{
			var Obj = $('#'+label.attr("for"));
			var ID = Obj.attr('box') || Obj.attr('id');
			if($.trim($("#box_"+ID).text())=='')$("#box_"+ID +">label").removeClass().addClass("success").html(' ');
		},
		focusInvalid: true, // ýʱ֤ 
		onkeyup: false //,debug: true
	});
});
