<%
Private Const a_BITS_TO_A_BYTE = 8
Private Const a_BYTES_TO_A_WORD = 4
Private Const a_BITS_TO_A_WORD = 32

Private a_m_lOnBits(30)
Private a_m_l2Power(30)

Private Function a_LShift(lValue, iShiftBits)
	If iShiftBits = 0 Then
		a_LShift = lValue
		Exit Function
	ElseIf iShiftBits = 31 Then
		If lValue And 1 Then
			a_LShift = &H80000000
		Else
			a_LShift = 0
		End If
		Exit Function
	ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
		Err.Raise 6
	End If

	If (lValue And a_m_l2Power(31 - iShiftBits)) Then
		a_LShift = ((lValue And a_m_lOnBits(31 - (iShiftBits + 1))) * a_m_l2Power(iShiftBits)) Or &H80000000
	Else
		a_LShift = ((lValue And a_m_lOnBits(31 - iShiftBits)) * a_m_l2Power(iShiftBits))
	End If
End Function

Private Function str2bin(varstr) 
    Dim varasc
    Dim i
    Dim varchar
    Dim varlow
    Dim varhigh
    
	str2bin="" 
    For i=1 To Len(varstr) 
        varchar=mid(varstr,i,1) 
        varasc = Asc(varchar) 
        
        If varasc<0 Then 
        varasc = varasc + 65535 
        End If 
        
        If varasc>255 Then 
        varlow = Left(Hex(Asc(varchar)),2) 
        varhigh = right(Hex(Asc(varchar)),2) 
        str2bin = str2bin & chrB("&H" & varlow) & chrB("&H" & varhigh) 
        Else 
        str2bin = str2bin & chrB(AscB(varchar)) 
        End If 
    Next 
End Function 

Private Function a_RShift(lValue, iShiftBits)
	If iShiftBits = 0 Then
		a_RShift = lValue
		Exit Function
	ElseIf iShiftBits = 31 Then
		If lValue And &H80000000 Then
			a_RShift = 1
		Else
			a_RShift = 0
		End If
		Exit Function
	ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
		Err.Raise 6
	End If

	a_RShift = (lValue And &H7FFFFFFE) \ a_m_l2Power(iShiftBits)

	If (lValue And &H80000000) Then
		a_RShift = (a_RShift Or (&H40000000 \ a_m_l2Power(iShiftBits - 1)))
	End If
End Function

Private Function a_RotateLeft(lValue, iShiftBits)
	a_RotateLeft = a_LShift(lValue, iShiftBits) Or a_RShift(lValue, (32 - iShiftBits))
End Function

Private Function a_AddUnsigned(lX, lY)
	Dim lX4
	Dim lY4
	Dim lX8
	Dim lY8
	Dim lResult

	lX8 = lX And &H80000000
	lY8 = lY And &H80000000
	lX4 = lX And &H40000000
	lY4 = lY And &H40000000
	
	lResult = (lX And &H3FFFFFFF) + (lY And &H3FFFFFFF)

	If lX4 And lY4 Then
		lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
	ElseIf lX4 Or lY4 Then
		If lResult And &H40000000 Then
			lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
		Else
			lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
		End If
	Else
		lResult = lResult Xor lX8 Xor lY8
	End If

	a_AddUnsigned = lResult
End Function

Private Function a_md5_F(x, y, z)
	a_md5_F = (x And y) Or ((Not x) And z)
End Function

Private Function a_md5_G(x, y, z)
	a_md5_G = (x And z) Or (y And (Not z))
End Function

Private Function a_md5_H(x, y, z)
	a_md5_H = (x Xor y Xor z)
End Function

Private Function a_md5_I(x, y, z)
	a_md5_I = (y Xor (x Or (Not z)))
End Function

Private Sub a_md5_FF(a, b, c, d, x, s, ac)
	a = a_AddUnsigned(a, a_AddUnsigned(a_AddUnsigned(a_md5_F(b, c, d), x), ac))
	a = a_RotateLeft(a, s)
	a = a_AddUnsigned(a, b)
End Sub

Private Sub a_md5_GG(a, b, c, d, x, s, ac)
	a = a_AddUnsigned(a, a_AddUnsigned(a_AddUnsigned(a_md5_G(b, c, d), x), ac))
	a = a_RotateLeft(a, s)
	a = a_AddUnsigned(a, b)
End Sub

Private Sub a_md5_HH(a, b, c, d, x, s, ac)
	a = a_AddUnsigned(a, a_AddUnsigned(a_AddUnsigned(a_md5_H(b, c, d), x), ac))
	a = a_RotateLeft(a, s)
	a = a_AddUnsigned(a, b)
End Sub

Private Sub a_md5_II(a, b, c, d, x, s, ac)
	a = a_AddUnsigned(a, a_AddUnsigned(a_AddUnsigned(a_md5_I(b, c, d), x), ac))
	a = a_RotateLeft(a, s)
	a = a_AddUnsigned(a, b)
End Sub

Private Function a_ConvertToWordArray(sMessage)
	Dim lMessageLength
	Dim lNumberOfWords
	Dim lWordArray()
	Dim lBytePosition
	Dim lByteCount
	Dim lWordCount
	
	Const MODULUS_BITS = 512
	Const CONGRUENT_BITS = 448
	
	lMessageLength = LenB(sMessage)
	
	lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ a_BITS_TO_A_BYTE)) \ (MODULUS_BITS \ a_BITS_TO_A_BYTE)) + 1) * (MODULUS_BITS \ a_BITS_TO_A_WORD)
	ReDim lWordArray(lNumberOfWords - 1)
	
	lBytePosition = 0
    lByteCount = 0
	Do Until lByteCount >= lMessageLength
		lWordCount = lByteCount \ a_BYTES_TO_A_WORD
		lBytePosition = (lByteCount Mod a_BYTES_TO_A_WORD) * a_BITS_TO_A_BYTE
		lWordArray(lWordCount) = lWordArray(lWordCount) Or a_LShift(AscB(MidB(sMessage, lByteCount + 1, 1)), lBytePosition)
		lByteCount = lByteCount + 1
	Loop

	lWordCount = lByteCount \ a_BYTES_TO_A_WORD
	lBytePosition = (lByteCount Mod a_BYTES_TO_A_WORD) * a_BITS_TO_A_BYTE
	
	lWordArray(lWordCount) = lWordArray(lWordCount) Or a_LShift(&H80, lBytePosition)
	
	lWordArray(lNumberOfWords - 2) = a_LShift(lMessageLength, 3)
	lWordArray(lNumberOfWords - 1) = a_RShift(lMessageLength, 29)

	a_ConvertToWordArray = lWordArray
End Function

Private Function a_WordToHex(lValue)
	Dim lByte
	Dim lCount
	
	For lCount = 0 To 3
		lByte = a_RShift(lValue, lCount * a_BITS_TO_A_BYTE) And a_m_lOnBits(a_BITS_TO_A_BYTE - 1)
		a_WordToHex = a_WordToHex & Right("0" & Hex(lByte), 2)
	Next
End Function

Public Function a_MD5(sMessage)
	a_m_lOnBits(0) = CLng(1)
	a_m_lOnBits(1) = CLng(3)
	a_m_lOnBits(2) = CLng(7)
	a_m_lOnBits(3) = CLng(15)
	a_m_lOnBits(4) = CLng(31)
	a_m_lOnBits(5) = CLng(63)
	a_m_lOnBits(6) = CLng(127)
	a_m_lOnBits(7) = CLng(255)
	a_m_lOnBits(8) = CLng(511)
	a_m_lOnBits(9) = CLng(1023)
	a_m_lOnBits(10) = CLng(2047)
	a_m_lOnBits(11) = CLng(4095)
	a_m_lOnBits(12) = CLng(8191)
	a_m_lOnBits(13) = CLng(16383)
	a_m_lOnBits(14) = CLng(32767)
	a_m_lOnBits(15) = CLng(65535)
	a_m_lOnBits(16) = CLng(131071)
	a_m_lOnBits(17) = CLng(262143)
	a_m_lOnBits(18) = CLng(524287)
	a_m_lOnBits(19) = CLng(1048575)
	a_m_lOnBits(20) = CLng(2097151)
	a_m_lOnBits(21) = CLng(4194303)
	a_m_lOnBits(22) = CLng(8388607)
	a_m_lOnBits(23) = CLng(16777215)
	a_m_lOnBits(24) = CLng(33554431)
	a_m_lOnBits(25) = CLng(67108863)
	a_m_lOnBits(26) = CLng(134217727)
	a_m_lOnBits(27) = CLng(268435455)
	a_m_lOnBits(28) = CLng(536870911)
	a_m_lOnBits(29) = CLng(1073741823)
	a_m_lOnBits(30) = CLng(2147483647)
	
	a_m_l2Power(0) = CLng(1)
	a_m_l2Power(1) = CLng(2)
	a_m_l2Power(2) = CLng(4)
	a_m_l2Power(3) = CLng(8)
	a_m_l2Power(4) = CLng(16)
	a_m_l2Power(5) = CLng(32)
	a_m_l2Power(6) = CLng(64)
	a_m_l2Power(7) = CLng(128)
	a_m_l2Power(8) = CLng(256)
	a_m_l2Power(9) = CLng(512)
	a_m_l2Power(10) = CLng(1024)
	a_m_l2Power(11) = CLng(2048)
	a_m_l2Power(12) = CLng(4096)
	a_m_l2Power(13) = CLng(8192)
	a_m_l2Power(14) = CLng(16384)
	a_m_l2Power(15) = CLng(32768)
	a_m_l2Power(16) = CLng(65536)
	a_m_l2Power(17) = CLng(131072)
	a_m_l2Power(18) = CLng(262144)
	a_m_l2Power(19) = CLng(524288)
	a_m_l2Power(20) = CLng(1048576)
	a_m_l2Power(21) = CLng(2097152)
	a_m_l2Power(22) = CLng(4194304)
	a_m_l2Power(23) = CLng(8388608)
	a_m_l2Power(24) = CLng(16777216)
	a_m_l2Power(25) = CLng(33554432)
	a_m_l2Power(26) = CLng(67108864)
	a_m_l2Power(27) = CLng(134217728)
	a_m_l2Power(28) = CLng(268435456)
	a_m_l2Power(29) = CLng(536870912)
	a_m_l2Power(30) = CLng(1073741824)
	
	
	Dim x
	Dim k
	Dim AA
	Dim BB
	Dim CC
	Dim DD
	Dim a
	Dim b
	Dim c
	Dim d
	
	Const S11 = 7
	Const S12 = 12
	Const S13 = 17
	Const S14 = 22
	Const S21 = 5
	Const S22 = 9
	Const S23 = 14
	Const S24 = 20
	Const S31 = 4
	Const S32 = 11
	Const S33 = 16
	Const S34 = 23
	Const S41 = 6
	Const S42 = 10
	Const S43 = 15
	Const S44 = 21
	
	x = a_ConvertToWordArray(str2bin(sMessage))
	
	a = &H67452301
	b = &HEFCDAB89
	c = &H98BADCFE
	d = &H10325476
	
	For k = 0 To UBound(x) Step 16
		AA = a
		BB = b
		CC = c
		DD = d
		
		a_md5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
		a_md5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
		a_md5_FF c, d, a, b, x(k + 2), S13, &H242070DB
		a_md5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
		a_md5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
		a_md5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
		a_md5_FF c, d, a, b, x(k + 6), S13, &HA8304613
		a_md5_FF b, c, d, a, x(k + 7), S14, &HFD469501
		a_md5_FF a, b, c, d, x(k + 8), S11, &H698098D8
		a_md5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
		a_md5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
		a_md5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
		a_md5_FF a, b, c, d, x(k + 12), S11, &H6B901122
		a_md5_FF d, a, b, c, x(k + 13), S12, &HFD987193
		a_md5_FF c, d, a, b, x(k + 14), S13, &HA679438E
		a_md5_FF b, c, d, a, x(k + 15), S14, &H49B40821
		
		a_md5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
		a_md5_GG d, a, b, c, x(k + 6), S22, &HC040B340
		a_md5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
		a_md5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
		a_md5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
		a_md5_GG d, a, b, c, x(k + 10), S22, &H2441453
		a_md5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
		a_md5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
		a_md5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
		a_md5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
		a_md5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
		a_md5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
		a_md5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
		a_md5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
		a_md5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
		a_md5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
		
		a_md5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
		a_md5_HH d, a, b, c, x(k + 8), S32, &H8771F681
		a_md5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
		a_md5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
		a_md5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
		a_md5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
		a_md5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
		a_md5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
		a_md5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
		a_md5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
		a_md5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
		a_md5_HH b, c, d, a, x(k + 6), S34, &H4881D05
		a_md5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
		a_md5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
		a_md5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
		a_md5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
		
		a_md5_II a, b, c, d, x(k + 0), S41, &HF4292244
		a_md5_II d, a, b, c, x(k + 7), S42, &H432AFF97
		a_md5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
		a_md5_II b, c, d, a, x(k + 5), S44, &HFC93A039
		a_md5_II a, b, c, d, x(k + 12), S41, &H655B59C3
		a_md5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
		a_md5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
		a_md5_II b, c, d, a, x(k + 1), S44, &H85845DD1
		a_md5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
		a_md5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
		a_md5_II c, d, a, b, x(k + 6), S43, &HA3014314
		a_md5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
		a_md5_II a, b, c, d, x(k + 4), S41, &HF7537E82
		a_md5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
		a_md5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
		a_md5_II b, c, d, a, x(k + 9), S44, &HEB86D391
		
		a = a_AddUnsigned(a, AA)
		b = a_AddUnsigned(b, BB)
		c = a_AddUnsigned(c, CC)
		d = a_AddUnsigned(d, DD)
	Next
	
	a_MD5 = LCase(a_WordToHex(a) & a_WordToHex(b) & a_WordToHex(c) & a_WordToHex(d))
End Function
%>
