﻿
(function(ns){

	ns.Browser={
		IE:     !!(window.attachEvent &&
						  navigator.userAgent.indexOf('Opera') === -1),
						Opera:  navigator.userAgent.indexOf('Opera') > -1,
						WebKit: navigator.userAgent.indexOf('AppleWebKit/') > -1,
						Gecko:  navigator.userAgent.indexOf('Gecko') > -1 &&
						  navigator.userAgent.indexOf('KHTML') === -1,
						MobileSafari: !!navigator.userAgent.match(/Apple.*Mobile.*Safari/),
						Width: function(){
									var bodyCW; 
									if(window.innerWidth){
										bodyCW=window.innerWidth;
									}
									else if(document.documentElement&&document.documentElement.clientWidth){ 
										bodyCW=document.documentElement.clientWidth;
									}else if(document.body){
										bodyCW=document.body.clientWidth; 
									}
									return bodyCW;
						},
						Height: function(){
									var bodyCH;
									if(window.innerHeight){
										bodyCH=window.innerHeight;
									}else if(document.documentElement&&document.documentElement.clientHeight){ 
										bodyCH=document.documentElement.clientHeight; 
									}else if(document.body){
										bodyCH=document.body.clientHeight;
									}
									return bodyCH;
						}
	}


	ns.offset = function(node){
		var x = node.offsetLeft;
		var y = node.offsetTop;
		var w = node.offsetWidth;
		var h = node.offsetHeight;
		var parent = node.offsetParent;
		while (parent != null){
			x += parent.offsetLeft;
			y += parent.offsetTop;
			parent = parent.offsetParent;
		}
		if(w==0){
			w+=parseInt(node.currentStyle.width);
			w+=parseInt(node.currentStyle.paddingRight);
			w+=parseInt(node.currentStyle.paddingLeft);
			w+=parseInt(node.currentStyle.borderWidth) * 2;
		}
		if(h==0){
			h+=parseInt(node.currentStyle.height);
			h+=parseInt(node.currentStyle.paddingTop);
			h+=parseInt(node.currentStyle.paddingBottom);
			h+=parseInt(node.currentStyle.borderWidth) * 2;
		}
		return {x: x, y: y, w: w, h: h};
	}

	/*******************************事件操作(可保留原有事件)***********************************/
	ns.events = [];
	ns.findEvent = function(node, event, handler){
		var i;
		for (i in events){
			if (events[i].node == node && events[i].event == event && events[i].handler == handler){
				return i;
			}
		}
		return null;
	}
	
	ns.addEvent = function(node, event, handler){
		var i = findEvent(node, event, handler);
		if (i != null){
			return i;
		}
		events.push({node: node, event: event, handler: handler});
		
		i = events.length - 1;
		
		if (!node.addEventListener){
			//node.attachEvent('on' + event, handler);
			node.attachEvent('on' + event, handler.bindNode(node));
		}else{
			node.addEventListener(event, handler, false);
		}
		return i;
	}

	ns.removeEventIndex = function(index){
		var eventListener = events[index];
		delete events[index];
		if (!eventListener.node.removeEventListener){
			eventListener.node.detachEvent('on' + eventListener.event,
			eventListener.handler);
		}else{
			eventListener.node.removeEventListener(eventListener.event,
			eventListener.handler, false);
		}
	}
	ns.removeEvent = function(node, event, handler){
		var index = findEvent(node, event, handler);
		if (index == null) return;
		removeEventIndex(index);
	}
	ns.clearEvents = function(){
		var i;
		for (i = events.length; i > 0; i--){
			if (events[i] != undefined){
				removeEventIndex(i);
			}
		}
	}
	/****************解决IE使用attachEvent函数时，this指向被绑定的元素的问题***********************/
	ns.Function.prototype.bindNode=function(node){
		var foo=this 
		return function(e){ 
			foo.call(node,e||event) 
		} 
	} 

	ns.$=function(id){return document.getElementById(id)};

})(window);




function DragDrop(objName){
	
	this.objName = objName;
	
	this.popupWinmousemoveBack = null;
	
	this.popupWinmouseupBack = null;
	
	this.popupWinofsX = 0;

	this.popupWinofsY = 0;
	
	var This = this;
	
	$(this.objName).onmousedown = function(){
	
		return This.Set(event);
	
	
	}
	
	this.Set = function(e){
	
		this.popupWinmousemoveBack=document.body.onmousemove;
		
		this.popupWinmouseupBack=document.body.onmouseup;
		
		var ox=(e.offsetX==null)?e.layerX:e.offsetX;
		
		var oy=(e.offsetY==null)?e.layerY:e.offsetY;
		
		this.popupWinofsX=ox; this.popupWinofsY=oy;
		
		document.body.onmousemove = function(){
	
			This.dragDropMove();
	
		}
		
		document.body.onmouseup = function(){
	
			return This.dragDropStop();
	
		}
	}
	

	this.dragDropStop = function(){
	
		document.body.onmousemove = this.popupWinmousemoveBack;
		
		document.body.onmouseup = this.popupWinmouseupBack;
	}

	this.dragDropMove = function(e){

		var el=$(this.objName);   
		 
		if (e==null&&event!=null){
		
			el.style.left=(event.clientX * 1 + document.body.scrollLeft - this.popupWinofsX)+'px';
			
			el.style.top=(event.clientY * 1 + document.body.scrollTop - this.popupWinofsY)+'px';
			
			event.cancelBubble=true;
			
		}else{
		
			el.style.left=(e.pageX * 1 - this.popupWinofsX)+'px';
			
			el.style.top=(e.pageY * 1 - this.popupWinofsY)+'px';
			
			e.cancelBubble=true;
		}
		
		if ((event.button&1)==0) this.dragDropStop();
		
	}
}