﻿/*
类似msn信息提示类
 by andy976，2011-03-10  andy976@126.com  QQ: 282886356

//用法 
var objName=new msgWin("objName")
objName.config.width = 230; //宽度
objName.config.height = 230; //高度

//objName.config.left = 230; //左位置
//objName.config.top = 230; //顶位置
objName.config.right = 0; //右位置
objName.config.bottom = 0; //底位置
objName.config.drag = false; //是否可以拖动
objName.config.colorStyle = "blue"; //样式  red, blue, green, violet, random随机
objName.config.Filters = false; //应用滤镜
objName.config.showAfter = 1; //设置提示窗口显示的时间延迟 单位S
objName.config.hideafter = 5; //什么时候隐藏，如果不隐藏除非用户去关闭它，将其值设为-1 单位S
objName.config.popupSpeed	:	{time : 20, pixel : 5}, //设置提示窗口弹出的速度； time单位MS  pixel单位PX

objName.title=""; //窗口标题

objName.add(text, link, target, content); //增加窗口内容区项目
//text窗口内容区项目内容项目标题  link链接  target链接目标或者弹窗窗口名  content不为空的话就弹窗
//objName.clear(itemId) //清除窗口内容区项目
objName.show(); //执行
*/
function msgWin(objName){

	this.objName = objName;

	this.config = {
		
		width		:	230,
		
		height		:	100,
		
		left		:	null,
		
		top			:	null,
		
		right		:	0,
		
		bottom		:	0,
		
		showAfter	:	1, //设置提示窗口显示的时间延迟 单位S
		
		hideafter	:	5, //什么时候隐藏，如果不隐藏除非用户去关闭它，将其值设为-1 单位S
	
		popupSpeed	:	{time : 20, pixel : 5}, //设置提示窗口弹出的速度； time单位MS  pixel单位PX
		
		drag		:	true,  //是否可以拖动
		
		colorStyle	:	"blue", // red, blue, green, violet, random随机
		
		templet		:	null,	//模板
		
		popTemplet	:	null,	//模板
		
		Filters		:	true  //应用滤镜
	
	}
	
	this.config.templet='<div id="{msgWin}" class="msgWin_blue" onselectstart="return false;"><div id="{header}" class="header"><span id="{title}"></span><span id="{close}" class="close" onmousedown="event.cancelBubble=true;">X</span></div><div id="{content}" class="content" onMouseDown="event.cancelBubble=true;"></div></div>'
	
	this.config.popTemplet="<head><title>Title here</title><style type=\"text/css\">body {    background:#E0E9F8; padding:5px;    filter:progid:DXImageTransform.Microsoft.Gradient(     GradientType=0,StartColorStr='#FFE0E9F8', EndColorStr='#FFFFFFFF');  }  h1 {    font:bold 16px arial,sans-serif; color:#1F336B;     text-align:center; margin:0px;  }  p {    font:14px arial,sans-serif; color:#1F336B;  }</style></head><body><h1>{title}</h1><p>{content}</p></body>";
	
	
	this.initalized = false;
	
	this.obj = null;
	
	this.popupWintmrId = -1;
	
	this.popupWintmrHide = -1;
	
	this.popupWindxTimer = -1;
	
	this.popupWinshowBy = null;
	
	this.popupWinactualHgt = 0;
	
	this.popupWinresetTimer = false;
	
	this.popupWintitHgt = 0;
	
	this.popupWincntDelta = 0;
	
	this.title = null;
	
	this.items = [];
}



msgWin.prototype.toString = function(){

	var str = "";

	if($(this.objName) != null) return str;

	str = this.config.templet;
	
	str = str.replace("{msgWin}", this.objName);
	
	str = str.replace("{header}", this.objName +"_header");

	str = str.replace("{title}", this.objName +"_title");

	str = str.replace("{content}", this.objName +"_content");
	
	str = str.replace("{close}", this.objName +"_close");
	
	return str;
}

msgWin.prototype.initalize = function(){

	if(this.initalized == true)return;
	
	document.write(this);
	
	this.obj = $(this.objName);

	addEvent($(this.objName +"_close"), "click", new Function(this.objName +".close()"));
	
	if(this.config.drag==true){
	
		var dragDrop = new DragDrop(this.objName);
		
		var This = this;
		
		this.obj.onmousedown = function(){
		
			if (This.popupWintmrHide!=-1) clearInterval(This.popupWintmrHide);
			
			return dragDrop.Set(event);
		}
	}

	this.initalized = true;
}


msgWin.prototype.close = function(){

	  if (this.popupWintmrId == -1){
	  
		this.obj.style.filter="";
		
		this.obj.style.display="none";
		
		if (this.popupWintmrHide != -1) clearInterval(this.popupWintmrHide); this.popupWintmrHide = -1;
		
	  }
}





msgWin.prototype.show = function(){

	var This = this;
	
	This.initalize();
	
	This.msgBoxInitalize();
	
	this.popupWinresetTimer=true;
	
	if(this.config.showAfter!=-1){
	
		setTimeout(function(){This.run(This, null)}, This.config.showAfter * 1000);
		
	}else{
	
		this.run(this, null);
		
	}
}

msgWin.prototype.run = function(This, showObj){

	if (This.popupWindxTimer != -1) { This.obj.filters.blendTrans.stop(); }
	
	if ((This.popupWintmrHide!=-1) && ((showObj != null) && (showObj == This.popupWinshowBy))){
	
		clearInterval(This.popupWintmrHide);
		
		This.popupWintmrHide=setInterval(function(){This.tmrHideTimer(This)}, This.config.hideafter * 1000);
		
		return;
	
	}
	
	if (This.popupWintmrId!=-1) return;
	
	This.popupWinshowBy=showObj;
	
	var elCnt = $(This.objName +"_content");
	
	var elTit = $(This.objName +"_header");
	
	var el = This.obj;

	el.style.left = This.config.left;
	
	el.style.top = '';
	
	el.style.filter = '';
		  
	if (This.popupWintmrHide != -1) clearInterval(This.popupWintmrHide); This.popupWintmrHide=-1;
	
	elCnt.style.display='none';
	
    elTit.style.display='none';

	if (navigator.userAgent.indexOf('Opera')!=-1){
	
		el.style.bottom=(document.body.scrollHeight * 1 - document.body.scrollTop * 1
		
		-document.body.offsetHeight * 1 + 1 * This.config.bottom) + 'px';

	}
					
	/*						
	if (popupWinbChangeTexts)
	{
	popupWinbChangeTexts=false;
	document.getElementById('popupWinaCnt').innerHTML=popupWinnMsg;
	document.getElementById('popupWintitleEl').innerHTML=popupWinnTitle;
	}
	*/	  

    el.style.height = This.popupWinactualHgt + 'px';

	el.style.visibility='';

	if (!This.popupWinresetTimer) el.style.display='block';
	
	This.popupWintmrId = setInterval(function(){This.tmrTimer(This)}, (This.popupWinresetTimer?1000:20));
}


msgWin.prototype.tmrTimer = function(This){

	var el = This.obj;
	
	if(This.popupWinresetTimer){
	
		el.style.display='block'; //el.style.display='';
		
		clearInterval(This.popupWintmrId); This.popupWinresetTimer=false;
		
		This.popupWintmrId=setInterval(function(){This.tmrTimer(This)}, This.config.popupSpeed.time);
		
	}

	This.popupWinactualHgt += This.config.popupSpeed.pixel;
		  
	if (This.popupWinactualHgt >= This.config.height){
	
		This.popupWinactualHgt = This.config.height;
		
		clearInterval(This.popupWintmrId); This.popupWintmrId=-1;
		
		$(This.objName +"_content").style.display='block';
		
		if (This.config.hideafter!=-1) This.popupWintmrHide=setInterval(function(){This.tmrHideTimer(This)}, This.config.hideafter * 1000);
		
	}
		  
	if (This.popupWintitHgt < This.popupWinactualHgt-6) $(This.objName +"_header").style.display='block';
	
	if ((This.popupWinactualHgt - This.popupWincntDelta)>0){
	
		var elCnt=$(This.objName +"_content");
		
		elCnt.style.display='block';

		elCnt.style.height=(This.popupWinactualHgt - This.popupWincntDelta)+'px';
		
	}

	el.style.height = This.popupWinactualHgt + 'px';
}


msgWin.prototype.tmrHideTimer = function(This){

	clearInterval(This.popupWintmrHide); This.popupWintmrHide = -1;

	var el = This.obj;

	if(This.config.Filters){
	
		var backCnt = $(This.objName +"_content").innerHTML;
		
		var backTit = $(This.objName +"_header").innerHTML;
		
		$(This.objName +"_content").innerHTML = '';
		
		$(This.objName +"_header").innerHTML = '';
		
		el.style.filter='blendTrans(duration=1)';
		
		el.filters.blendTrans.apply();
		
		el.style.visibility = 'hidden';
		
		el.filters.blendTrans.play();
		
		$(This.objName +"_content").innerHTML = backCnt;
		
		$(This.objName +"_header").innerHTML = backTit;
		
		This.popupWindxTimer = setInterval(function(){This.dxTimer(This)}, 1000);
		
	}else{
	
		el.style.visibility = 'hidden';
	
	}
}
        
msgWin.prototype.dxTimer = function(This){
		
	clearInterval(This.popupWindxTimer);
	
	This.popupWindxTimer=-1;
	
}		

msgWin.prototype.msgBoxInitalize = function(){

	var elCnt = $(this.objName +"_content");
	
	var elTit = $(this.objName +"_header")
	
	var el = this.obj;
	
	var colorStyle = {blue : "msgWin_blue", red : "msgWin_red", green : "msgWin_green", violet : "msgWin_violet"}
	
	var ClassName;
	
	if(colorStyle[this.config.colorStyle.toLowerCase()]==undefined){
	
		var colorList = new Array("blue", "red", "green", "violet");
		
		ClassName = colorStyle[colorList[Math.round(Math.random() * (colorList.length - 1))]];
		
	}else{
	
		ClassName = colorStyle[this.config.colorStyle];
	
	}

	el.className = ClassName;
	
	el.style.width = this.config.width + "px";
	
	el.style.height = this.config.height + "px";
	
	elTit.style.width = (this.config.width - 6) + "px";
	
	elCnt.style.width = (this.config.width - 6) + "px";
	
	elCnt.style.height = (this.config.height - 24) + "px";
	
	if(this.config.left != null && this.config.top != null){
		
		el.style.left = this.config.left + "px";
		
		el.style.top = this.config.top + "px";

	}else{
	
		if(this.config.right != null && this.config.bottom != null){
			
			el.style.right = this.config.right + "px";
			
			el.style.bottom = this.config.bottom + "px";
	
		}
	
	}

	this.config.height = offset(el).h;
	
	this.popupWintitHgt = this.config.height -	offset(elCnt).h;
	
	this.config.width = offset(el).w
	
	if(this.config.left != null && this.config.top != null){
	
		this.config.bottom = Browser.Height() - this.config.top - this.config.height;
		
		el.style.bottom = this.config.bottom + "px";
	
	}else{
	
		this.config.left = Browser.Width() - this.config.right - this.config.width;
	
	}
	
	this.popupWinactualHgt=0;

	var borderWidth=isNaN(parseInt(el.currentStyle.borderTopWidth))?0:parseInt(el.currentStyle.borderTopWidth);
	borderWidth+=isNaN(parseInt(el.currentStyle.borderBottomWidth))?0:parseInt(el.currentStyle.borderBottomWidth);
	borderWidth+=isNaN(parseInt(elCnt.currentStyle.borderTopWidth))?0:parseInt(elCnt.currentStyle.borderTopWidth);
	borderWidth+=isNaN(parseInt(elCnt.currentStyle.borderBottomWidth))?0:parseInt(elCnt.currentStyle.borderBottomWidth);
	borderWidth+=isNaN(parseInt(elTit.currentStyle.borderTopWidth))?0:parseInt(elTit.currentStyle.borderTopWidth);
	borderWidth+=isNaN(parseInt(elTit.currentStyle.borderBottomWidth))?0:parseInt(elTit.currentStyle.borderBottomWidth);

	this.popupWincntDelta = this.config.height -  offset(elCnt).h + borderWidth;
	
	$(this.objName +"_title").innerHTML = (this.title==null)?"":this.title;
	
	var ContentStr = "";
	
	if(this.items.length!=0){
	
		ContentStr = "<ul>"
		
		for(var n=0; n<this.items.length; n++){
		
			ContentStr += "<li>"
		
			if(this.items[n].link != null){
			
				ContentStr += "<a href=\""+ this.items[n].link +"\" "
				
				ContentStr += " target=\""+ ((this.items[n].target != null)? this.items[n].target : "_blank") +"\" " ;
				
				ContentStr += ">"
				
			}else{
			
				if(this.items[n].content != null){
			
					ContentStr += "<a href=\"javascript:void(0);\" onclick=\""+ this.objName
					
					ContentStr += ".showWindow("+ n +", "+ this.items[n].target +")\">"
			
				}
			
			}
		
			ContentStr += this.items[n].text;
		
			if(this.items[n].link != null || this.items[n].content!=null) ContentStr += "</a>"
		
			ContentStr += "</li>"
			
		}
	
		ContentStr += "</ul>"
	}

	elCnt.innerHTML = ContentStr;
}


function msgItem(text, link, target, content){
	
	this.text = text;

	this.link = (link == "" || link == undefined) ? null : link;

	this.target = (target == "" || target == undefined) ? null : target;

	this.content = (content == "" || content == undefined) ? null : content;

}

msgWin.prototype.add = function(text, link, target, content){

	this.items[this.items.length] = new msgItem(text, link, target, content);

}


msgWin.prototype.clear = function(itemId){

	if(itemId==undefined){
	
		this.items.length = 0;
		
	}else{
	
		this.items.splice(itemId, 1);
	
	}

}

msgWin.prototype.showWindow = function(itemId){

	if(this.items.length==0)return;

	if(this.items.length==10)this.close();
	
	var target = ((this.items[itemId].target==null)?'popWindow': this.items[itemId].target);

	var popWindow = window.open("",  target ,"width=300,height=200,scrollbars=no, "+
            "menubar=no, resizable=no, status=no, toolbar=no, location=no");

	var popupWinnText = this.config.popTemplet;
	
	popupWinnText = popupWinnText.replace("{title}", this.items[itemId].text);
	
	popupWinnText = popupWinnText.replace("{content}", this.items[itemId].content);
	
	popWindow.focus()

	popWindow.document.write(popupWinnText);
	
	popWindow.document.close()
	
	popupWinnText = popupWinnText.replace(/<style.+?\>.+?\<\/style\>/gi, "")
	
	popupWinnText = popupWinnText.replace(/<[^>]*>/gi, "")
	
	var TextAreaSize = this.items[itemId].text.length * 20 * 20 + this.items[itemId].content.length * 16 * 16;
	
	TextAreaSize = Math.round(Math.sqrt(TextAreaSize));
	
	if(TextAreaSize>300) popWindow.resizeTo(TextAreaSize, TextAreaSize + 20);
	
}