CREATE TABLE [dbo].[{tablepre}wordsfilter](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[theword] [nvarchar](255) NOT NULL,
	[replacewith] [nvarchar](255) NOT NULL,
	[username] [nvarchar](20) NOT NULL,
 CONSTRAINT [PK_{tablepre}wordsfilter] PRIMARY KEY CLUSTERED 
(
	[id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}usergroups](
	[gid] [smallint] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50) NOT NULL,
	[types] [varchar](20) NOT NULL,
	[initialize] [tinyint] NOT NULL,
	[allowvisit] [tinyint] NOT NULL,
	[disableperiodctrl] [tinyint] NOT NULL,
	[allowpost] [tinyint] NOT NULL,
	[allowdirectpost] [tinyint] NOT NULL,
	[allowreply] [tinyint] NOT NULL,
	[anonymitysuc] [tinyint] NOT NULL,
	[allowpostpoll] [tinyint] NOT NULL,
	[allowpoll] [tinyint] NOT NULL,
	[allowsearch] [tinyint] NOT NULL,
	[allowgetattach] [tinyint] NOT NULL,
	[allowpostattach] [tinyint] NOT NULL,
	[maxattachsize] [int] NOT NULL,
	[attachextensions] [varchar](255) NOT NULL,
	[allowviewuserinfo] [tinyint] NOT NULL,
	[allowuseitem] [tinyint] NOT NULL,
	[allowhtml] [tinyint] NOT NULL,
	[allowchat] [tinyint] NOT NULL,
	[specialinterface] [ntext] NOT NULL,
	[allowinvate] [tinyint] NOT NULL,
	[invateprice] [int] NOT NULL,
	[invatemaxnum] [int] NOT NULL,
	[invateexpiryday] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}usergroups] PRIMARY KEY CLUSTERED 
(
	[gid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}topictypes](
	[typeid] [int] IDENTITY(1,1) NOT NULL,
	[fid] [smallint] NOT NULL,
	[name] [nvarchar](100) NOT NULL,
	[description] [nvarchar](255) NOT NULL,
	[displayorder] [smallint] NOT NULL,
 CONSTRAINT [PK_{tablepre}topictypes] PRIMARY KEY CLUSTERED 
(
	[typeid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}topictypes] ON [dbo].[{tablepre}topictypes] 
(
	[fid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}topictask](
	[tid] [int] NOT NULL,
	[expirytime] [datetime] NOT NULL,
	[action] [varchar](30) NOT NULL,
	[itemid] [smallint] NOT NULL,
 CONSTRAINT [PK_{tablepre}topictask] PRIMARY KEY NONCLUSTERED 
(
	[tid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}topictask] ON [dbo].[{tablepre}topictask] 
(
	[expirytime] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}topics](
	[tid] [int] IDENTITY(1,1) NOT NULL,
	[fid] [smallint] NOT NULL,
	[typeid] [smallint] NOT NULL,
	[displayorder] [smallint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[usershow] [nvarchar](100) NOT NULL,
	[title] [nvarchar](255) NOT NULL,
	[posttime] [datetime] NOT NULL,
	[lastupdate] [datetime] NOT NULL,
	[clicks] [int] NOT NULL,
	[posts] [int] NOT NULL,
	[types] [tinyint] NOT NULL,
	[special] [tinyint] NOT NULL,
	[price] [int] NOT NULL,
	[leagueid] [int] NOT NULL,
	[ifelite] [tinyint] NOT NULL,
	[iflocked] [tinyint] NOT NULL,
	[ifanonymity] [tinyint] NOT NULL,
	[iftask] [tinyint] NOT NULL,
	[disablemodify] [tinyint] NOT NULL,
 CONSTRAINT [PK_{tablepre}topics] PRIMARY KEY CLUSTERED 
(
	[tid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}topics] ON [dbo].[{tablepre}topics] 
(
	[fid] ASC,
	[displayorder] ASC,
	[lastupdate] DESC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}topics_1] ON [dbo].[{tablepre}topics] 
(
	[fid] ASC,
	[typeid] ASC,
	[displayorder] ASC,
	[lastupdate] DESC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}topics_2] ON [dbo].[{tablepre}topics] 
(
	[types] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}topics_3] ON [dbo].[{tablepre}topics] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}sticktopics](
	[tid] [int] NOT NULL,
	[fid] [smallint] NOT NULL
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}sticktopic] ON [dbo].[{tablepre}sticktopics] 
(
	[tid] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}sticktopic_1] ON [dbo].[{tablepre}sticktopics] 
(
	[fid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}settings](
	[site_settings] [ntext] NOT NULL,
	[item_settings] [ntext] NOT NULL,
	[wordsfilter] [ntext] NOT NULL,
	[banip] [text] NOT NULL,
	[banner] [ntext] NOT NULL,
	[todayposts] [int] NOT NULL,
	[invatenum] [int] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}searchindex](
	[searchid] [int] IDENTITY(1,1) NOT NULL,
	[keyword] [nvarchar](50) NOT NULL,
	[searchtype] [tinyint] NOT NULL,
	[searchcount] [int] NOT NULL,
	[recordcount] [int] NOT NULL,
	[tid] [text] NOT NULL,
	[expirytime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}searchindex] PRIMARY KEY CLUSTERED 
(
	[searchid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}searchindex_1] ON [dbo].[{tablepre}searchindex] 
(
	[keyword] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}posts](
	[pid] [int] IDENTITY(1,1) NOT NULL,
	[fid] [smallint] NOT NULL,
	[tid] [int] NOT NULL,
	[first] [tinyint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[usershow] [nvarchar](100) NOT NULL,
	[message] [ntext] NOT NULL,
	[posttime] [datetime] NOT NULL,
	[userip] [char](15) NOT NULL,
	[ifanonymity] [tinyint] NOT NULL,
	[ratemark] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}posts] PRIMARY KEY CLUSTERED 
(
	[pid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}posts_1] ON [dbo].[{tablepre}posts] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}posts_2] ON [dbo].[{tablepre}posts] 
(
	[tid] ASC,
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}polls](
	[tid] [int] NOT NULL,
	[multiple] [tinyint] NOT NULL,
	[visible] [tinyint] NOT NULL,
	[maxchoices] [tinyint] NOT NULL,
	[totalpoll] [int] NOT NULL,
	[expirytime] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}polls] PRIMARY KEY CLUSTERED 
(
	[tid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}polloptions](
	[optionid] [int] IDENTITY(1,1) NOT NULL,
	[tid] [int] NOT NULL,
	[votes] [int] NOT NULL,
	[displayorder] [tinyint] NOT NULL,
	[title] [nvarchar](100) NOT NULL,
	[voteuids] [text] NOT NULL,
 CONSTRAINT [PK_{tablepre}polloptions] PRIMARY KEY CLUSTERED 
(
	[optionid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}polloptions] ON [dbo].[{tablepre}polloptions] 
(
	[tid] ASC,
	[displayorder] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}pms](
	[pmid] [int] IDENTITY(1,1) NOT NULL,
	[uid] [int] NOT NULL,
	[message] [ntext] NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}pms] PRIMARY KEY CLUSTERED 
(
	[pmid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}pms] ON [dbo].[{tablepre}pms] 
(
	[uid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}pm](
	[pmid] [int] IDENTITY(1,1) NOT NULL,
	[msgfrom] [nvarchar](20) NOT NULL,
	[msgfromid] [int] NOT NULL,
	[msgtoid] [int] NOT NULL,
	[message] [ntext] NOT NULL,
	[remessage] [ntext] NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}pm] PRIMARY KEY CLUSTERED 
(
	[pmid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}pm] ON [dbo].[{tablepre}pm] 
(
	[msgtoid] ASC,
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}online](
	[sid] [char](10) COLLATE Chinese_PRC_BIN NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[userip] [char](15) NOT NULL,
	[usergroupid] [smallint] NOT NULL,
	[lastupdate] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}online] PRIMARY KEY CLUSTERED 
(
	[sid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}online] ON [dbo].[{tablepre}online] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}moderators](
	[fid] [smallint] NOT NULL,
	[uid] [int] NOT NULL
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}moderators] ON [dbo].[{tablepre}moderators] 
(
	[fid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}members](
	[uid] [int] IDENTITY(1,1) NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[password] [char](32) NOT NULL,
	[secques] [varchar](32) NOT NULL,
	[admingroupid] [tinyint] NOT NULL,
	[usergroupid] [smallint] NOT NULL,
	[credits] [int] NOT NULL,
	[regtime] [datetime] NOT NULL,
	[regip] [char](15) NOT NULL,
	[lastlogintime] [datetime] NOT NULL,
	[lastloginip] [char](15) NOT NULL,
	[logintime] [datetime] NOT NULL,
	[loginip] [char](15) NOT NULL,
	[logincount] [int] NOT NULL,
	[newtopictime] [int] NOT NULL,
	[postfloodctrl] [int] NOT NULL,
	[topics] [int] NOT NULL,
	[posts] [int] NOT NULL,
	[accessmasks] [tinyint] NOT NULL,
	[groupexpiry] [int] NOT NULL,
	[newpm] [tinyint] NOT NULL,
	[leaguegid] [tinyint] NOT NULL,
 CONSTRAINT [PK_{tablepre}members] PRIMARY KEY CLUSTERED 
(
	[uid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE UNIQUE NONCLUSTERED INDEX [IX_{tablepre}members] ON [dbo].[{tablepre}members] 
(
	[username] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}members_1] ON [dbo].[{tablepre}members] 
(
	[usergroupid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}memberprofiles](
	[uid] [int] NOT NULL,
	[profile] [ntext] NOT NULL,
	[province] [nvarchar](10) NOT NULL,
	[area] [nvarchar](10) NOT NULL,
	[gender] [tinyint] NOT NULL,
	[birthyear] [smallint] NOT NULL,
	[birthmonth] [tinyint] NOT NULL,
	[birthday] [tinyint] NOT NULL,
	[constellation] [tinyint] NOT NULL,
	[ifphoto] [tinyint] NOT NULL,
 CONSTRAINT [PK_{tablepre}memberprofiles] PRIMARY KEY CLUSTERED 
(
	[uid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}memberitems](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[uid] [int] NOT NULL,
	[itemid] [smallint] NOT NULL,
	[num] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}memberitems] PRIMARY KEY CLUSTERED 
(
	[id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}memberitems] ON [dbo].[{tablepre}memberitems] 
(
	[uid] ASC,
	[itemid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}memberfields](
	[uid] [int] NOT NULL,
	[designation] [nvarchar](100) NOT NULL,
	[signature] [ntext] NOT NULL,
	[ignorepm] [ntext] NOT NULL,
 CONSTRAINT [PK_{tablepre}memberfields] PRIMARY KEY CLUSTERED 
(
	[uid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}logs](
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[userip] [char](15) NOT NULL,
	[targetuid] [int] NOT NULL,
	[targetusername] [nvarchar](20) NOT NULL,
	[operation] [nvarchar](255) NOT NULL,
	[reason] [nvarchar](255) NOT NULL,
	[posttime] [datetime] NOT NULL
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}logs_2] ON [dbo].[{tablepre}logs] 
(
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}logs] ON [dbo].[{tablepre}logs] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}logs_1] ON [dbo].[{tablepre}logs] 
(
	[targetuid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leaguetopics](
	[leagueid] [int] NOT NULL,
	[tid] [int] NOT NULL
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguetopics] ON [dbo].[{tablepre}leaguetopics] 
(
	[leagueid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leagues](
	[leagueid] [int] IDENTITY(1,1) NOT NULL,
	[ifadulting] [tinyint] NOT NULL,
	[name] [nvarchar](50) NOT NULL,
	[description] [ntext] NOT NULL,
	[createtime] [datetime] NOT NULL,
	[members] [int] NOT NULL,
	[news] [int] NOT NULL,
	[topics] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}leagues] PRIMARY KEY CLUSTERED 
(
	[leagueid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leaguenews](
	[articleid] [int] IDENTITY(1,1) NOT NULL,
	[leagueid] [smallint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[title] [nvarchar](255) NOT NULL,
	[message] [ntext] NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}leaguenews] PRIMARY KEY CLUSTERED 
(
	[articleid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguenews] ON [dbo].[{tablepre}leaguenews] 
(
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [leagueid] ON [dbo].[{tablepre}leaguenews] 
(
	[leagueid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leaguemembers](
	[joinid] [int] IDENTITY(1,1) NOT NULL,
	[uid] [int] NOT NULL,
	[leagueid] [int] NOT NULL,
	[groupid] [smallint] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[designation] [nvarchar](100) NOT NULL,
	[jointime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}leaguemembers] PRIMARY KEY CLUSTERED 
(
	[joinid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguemember] ON [dbo].[{tablepre}leaguemembers] 
(
	[uid] ASC,
	[groupid] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguemembers] ON [dbo].[{tablepre}leaguemembers] 
(
	[leagueid] ASC,
	[groupid] ASC,
	[joinid] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leaguelogs](
	[leagueid] [smallint] NOT NULL,
	[typeid] [tinyint] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[operation] [nvarchar](200) NOT NULL,
	[posttime] [datetime] NOT NULL
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}leaguelogs] ON [dbo].[{tablepre}leaguelogs] 
(
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguelogs_2] ON [dbo].[{tablepre}leaguelogs] 
(
	[leagueid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leaguefavorites](
	[uid] [int] NOT NULL,
	[leagueid] [int] NOT NULL
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}leaguefavorites] ON [dbo].[{tablepre}leaguefavorites] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}leagueelite](
	[eliteid] [int] IDENTITY(1,1) NOT NULL,
	[tid] [int] NOT NULL,
	[leagueid] [smallint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[title] [nvarchar](255) NOT NULL,
	[message] [ntext] NOT NULL,
	[lastupdate] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}leagueelite] PRIMARY KEY CLUSTERED 
(
	[eliteid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [leagueid_lastupdate] ON [dbo].[{tablepre}leagueelite] 
(
	[leagueid] ASC,
	[lastupdate] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}itemuselogs](
	[itemid] [int] NOT NULL,
	[tid] [int] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[userip] [char](15) NOT NULL,
	[targetuid] [int] NOT NULL,
	[targetusername] [nvarchar](20) NOT NULL,
	[operation] [nvarchar](255) NOT NULL,
	[posttime] [datetime] NOT NULL
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}itemuselogs] ON [dbo].[{tablepre}itemuselogs] 
(
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemuselogs_1] ON [dbo].[{tablepre}itemuselogs] 
(
	[itemid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemuselogs_2] ON [dbo].[{tablepre}itemuselogs] 
(
	[tid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}items](
	[itemid] [int] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50) NOT NULL,
	[types] [varchar](10) NOT NULL,
	[identifier] [varchar](30) NOT NULL,
	[available] [tinyint] NOT NULL,
	[iflog] [tinyint] NOT NULL,
	[description] [nvarchar](255) NOT NULL,
	[displayorder] [smallint] NOT NULL,
 CONSTRAINT [PK_{tablepre}items] PRIMARY KEY CLUSTERED 
(
	[itemid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE UNIQUE NONCLUSTERED INDEX [IX_{tablepre}items] ON [dbo].[{tablepre}items] 
(
	[identifier] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}itemmessages](
	[messageid] [int] IDENTITY(1,1) NOT NULL,
	[itemid] [smallint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[message] [nvarchar](255) NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}itemmessages] PRIMARY KEY CLUSTERED 
(
	[messageid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemmessages] ON [dbo].[{tablepre}itemmessages] 
(
	[itemid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}itemmarketlogs](
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[userip] [nchar](15) NOT NULL,
	[targetuid] [int] NOT NULL,
	[targetusername] [nvarchar](20) NOT NULL,
	[itemid] [smallint] NOT NULL,
	[num] [int] NOT NULL,
	[price] [int] NOT NULL,
	[posttime] [datetime] NOT NULL
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}itemmarketlogs_2] ON [dbo].[{tablepre}itemmarketlogs] 
(
	[posttime] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemmarketlogs] ON [dbo].[{tablepre}itemmarketlogs] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemmarketlogs_1] ON [dbo].[{tablepre}itemmarketlogs] 
(
	[targetuid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}itemmarket](
	[marketid] [int] IDENTITY(1,1) NOT NULL,
	[itemid] [smallint] NOT NULL,
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[price] [int] NOT NULL,
	[num] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}itemmarket] PRIMARY KEY CLUSTERED 
(
	[marketid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemmarket] ON [dbo].[{tablepre}itemmarket] 
(
	[itemid] ASC,
	[price] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}itemmarket_1] ON [dbo].[{tablepre}itemmarket] 
(
	[uid] ASC,
	[itemid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}invate](
	[uid] [int] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[status] [tinyint] NOT NULL,
	[invatecode] [char](16) NOT NULL,
	[buytime] [datetime] NOT NULL,
	[expirytime] [datetime] NOT NULL,
	[reguid] [int] NOT NULL,
	[regtime] [int] NOT NULL
) ON [PRIMARY]
{next}
CREATE CLUSTERED INDEX [IX_{tablepre}invate] ON [dbo].[{tablepre}invate] 
(
	[expirytime] ASC
) ON [PRIMARY]
{next}
CREATE UNIQUE NONCLUSTERED INDEX [IX_{tablepre}invated] ON [dbo].[{tablepre}invate] 
(
	[invatecode] ASC
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}invated_1] ON [dbo].[{tablepre}invate] 
(
	[uid] ASC,
	[status] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}groupexpiry](
	[uid] [int] NOT NULL,
	[usergroupid] [smallint] NOT NULL,
	[admingroupid] [smallint] NOT NULL,
 CONSTRAINT [PK_{tablepre}groupexpiry] PRIMARY KEY CLUSTERED 
(
	[uid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}forums](
	[fid] [smallint] IDENTITY(1,1) NOT NULL,
	[name] [nvarchar](50) NOT NULL,
	[parentid] [smallint] NOT NULL,
	[childs] [int] NOT NULL,
	[rootfid] [smallint] NOT NULL,
	[displayorder] [smallint] NOT NULL,
	[topics] [int] NOT NULL,
	[posts] [int] NOT NULL,
	[todayposts] [int] NOT NULL,
	[allowpost] [tinyint] NOT NULL,
	[adultingpost] [tinyint] NOT NULL,
	[showtopictype] [tinyint] NOT NULL,
	[choosetopictype] [tinyint] NOT NULL,
	[allowpolltopic] [tinyint] NOT NULL,
	[autoclose] [smallint] NOT NULL,
	[recyclebin] [tinyint] NOT NULL,
	[visitndcredits] [int] NOT NULL,
	[postndcredits] [int] NOT NULL,
	[replyndcredits] [int] NOT NULL,
	[anonyndmitycredits] [int] NOT NULL,
	[htmlndcredits] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}forums] PRIMARY KEY CLUSTERED 
(
	[fid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}forumfields](
	[fid] [int] NOT NULL,
	[moderators] [ntext] NOT NULL,
	[viewperm] [text] NOT NULL,
	[posttopicperm] [text] NOT NULL,
	[postreplyperm] [text] NOT NULL,
	[postattachperm] [text] NOT NULL,
	[getattachperm] [text] NOT NULL,
	[topictype] [ntext] NOT NULL,
 CONSTRAINT [PK_{tablepre}forumfields] PRIMARY KEY CLUSTERED 
(
	[fid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}favorites](
	[uid] [int] NOT NULL,
	[tid] [int] NOT NULL
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}favorites] ON [dbo].[{tablepre}favorites] 
(
	[uid] ASC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}failedlogins](
	[userip] [char](15) NOT NULL,
	[falsecount] [tinyint] NOT NULL,
	[locktime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}failedlogins] PRIMARY KEY NONCLUSTERED 
(
	[userip] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}chatmessages](
	[msgid] [int] IDENTITY(1,1) NOT NULL,
	[roomid] [int] NOT NULL,
	[uid] [int] NOT NULL,
	[usershow] [nvarchar](20) NOT NULL,
	[message] [nvarchar](255) NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}chatmessages] PRIMARY KEY CLUSTERED 
(
	[msgid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE NONCLUSTERED INDEX [IX_{tablepre}chatmessages] ON [dbo].[{tablepre}chatmessages] 
(
	[roomid] ASC,
	[posttime] DESC
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}chatannounces](
	[roomid] [int] NOT NULL,
	[uid] [int] NOT NULL,
	[usershow] [nvarchar](20) NOT NULL,
	[message] [nvarchar](100) NOT NULL,
 CONSTRAINT [PK_{tablepre}chatannounces] PRIMARY KEY CLUSTERED 
(
	[roomid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}banip](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[ip1] [smallint] NOT NULL,
	[ip2] [smallint] NOT NULL,
	[ip3] [smallint] NOT NULL,
	[ip4] [smallint] NOT NULL,
	[username] [nvarchar](20) NOT NULL,
	[posttime] [datetime] NOT NULL,
 CONSTRAINT [PK_{tablepre}banip] PRIMARY KEY CLUSTERED 
(
	[id] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}admingroups](
	[gid] [smallint] NOT NULL,
	[allowmanagetopic] [tinyint] NOT NULL,
	[alloweditpoll] [tinyint] NOT NULL,
	[allowsticktopic] [tinyint] NOT NULL,
	[allowauditingtopic] [tinyint] NOT NULL,
	[allowviewip] [tinyint] NOT NULL,
	[allowbanip] [tinyint] NOT NULL,
	[allowedituser] [tinyint] NOT NULL,
	[allowpunishuser] [tinyint] NOT NULL,
	[disablepostctrl] [tinyint] NOT NULL,
	[allowdelitemmsg] [tinyint] NOT NULL,
	[disablepmctrl] [tinyint] NOT NULL,
	[allowviewlog] [tinyint] NOT NULL,
 CONSTRAINT [PK_{tablepre}admingroups] PRIMARY KEY CLUSTERED 
(
	[gid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
{next}
CREATE TABLE [dbo].[{tablepre}access](
	[uid] [int] NOT NULL,
	[allowvisit] [tinyint] NOT NULL,
	[disableperiodctrl] [tinyint] NOT NULL,
	[allowpost] [tinyint] NOT NULL,
	[allowdirectpost] [tinyint] NOT NULL,
	[allowreply] [tinyint] NOT NULL,
	[anonymitysuc] [tinyint] NOT NULL,
	[allowpostpoll] [tinyint] NOT NULL,
	[allowpoll] [tinyint] NOT NULL,
	[allowsearch] [tinyint] NOT NULL,
	[allowgetattach] [tinyint] NOT NULL,
	[allowpostattach] [tinyint] NOT NULL,
	[maxattachsize] [int] NOT NULL,
	[attachextensions] [varchar](200) NOT NULL,
	[allowviewuserinfo] [tinyint] NOT NULL,
	[allowuseitem] [tinyint] NOT NULL,
	[allowhtml] [tinyint] NOT NULL,
	[allowchat] [tinyint] NOT NULL,
	[specialinterface] [ntext] NOT NULL,
	[allowinvate] [tinyint] NOT NULL,
	[invateprice] [int] NOT NULL,
	[invatemaxnum] [int] NOT NULL,
	[invateexpiryday] [int] NOT NULL,
 CONSTRAINT [PK_{tablepre}access] PRIMARY KEY CLUSTERED 
(
	[uid] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
{next}
CREATE PROCEDURE [dbo].[{tablepre}sp_topiclist]
@fid smallint,
@page int,             
@pagesize smallint,
@typeid tinyint

AS

SET NOCOUNT ON

DECLARE @sql NVARCHAR(1000)

IF @page > 1
	BEGIN
		IF @typeid > 0
			SET @sql = N'SELECT TOP '+ CAST(@pagesize AS VARCHAR(10)) +' tid, typeid, usershow, title, clicks, posts, lastupdate 
				FROM {tablepre}topics 
				WHERE fid = @fid AND typeid = @typeid AND displayorder = 0 AND lastupdate < (
					SELECT MIN(lastupdate) 
					FROM (
						SELECT TOP '+ CAST(@pagesize * (@page - 1) AS VARCHAR(10)) +' lastupdate 
						FROM {tablepre}topics 
						WHERE fid = @fid AND typeid = @typeid AND displayorder = 0 
						ORDER BY lastupdate DESC
					) AS tblTemp
				) 
				ORDER BY lastupdate DESC'
		ELSE
			SET @sql = N'SELECT TOP '+ CAST(@pagesize AS VARCHAR(10)) +' tid, typeid, usershow, title, clicks, posts, lastupdate 
				FROM {tablepre}topics 
				WHERE fid = @fid AND displayorder = 0 AND lastupdate < (
					SELECT MIN(lastupdate) 
					FROM (
						SELECT TOP '+ CAST(@pagesize * (@page - 1) AS VARCHAR(10)) +' lastupdate 
						FROM {tablepre}topics 
						WHERE fid = @fid AND displayorder = 0 
						ORDER BY lastupdate DESC
					) AS tblTemp
				)
				ORDER BY lastupdate DESC'
	END
ELSE
	BEGIN
		IF @typeid > 0
			SET @sql = N'SELECT TOP '+ CAST(@pagesize AS VARCHAR(10)) +' tid, typeid, usershow, title, clicks, posts, lastupdate
				FROM {tablepre}topics 
				WHERE fid = @fid AND typeid = @typeid AND displayorder = 0 
				ORDER BY lastupdate DESC'
		ELSE
			SET @sql = N'SELECT TOP '+ CAST(@pagesize AS VARCHAR(10)) +' tid, typeid, usershow, title, clicks, posts, lastupdate 
				FROM {tablepre}topics 
				WHERE fid = @fid AND displayorder = 0 
				ORDER BY lastupdate DESC'
	END

EXEC sp_executesql @sql, N'@fid smallint, @typeid tinyint', @fid = @fid, @typeid = @typeid

SET NOCOUNT OFF
{next}
CREATE procedure [dbo].[{tablepre}sp_online_newpm]
@sid char(10),
@uid int,
@username nvarchar(20),
@userip char(15),
@usergroupid smallint,
@onlinehold smallint
AS

SET NOCOUNT ON

IF EXISTS(SELECT 1 FROM {tablepre}online WHERE sid = @sid AND uid = @uid)
	UPDATE {tablepre}online SET uid = @uid, username = @username, userip = @userip, usergroupid = @usergroupid, lastupdate = GetDate() WHERE sid = @sid
ELSE
	BEGIN
		DELETE FROM {tablepre}online WHERE sid = @sid OR lastupdate < DATEADD(n, -@onlinehold, GETDATE()) OR (uid > 0 AND uid = @uid) OR (uid = 0 AND userip = @userip AND lastupdate < DATEADD(n, -60, GETDATE()))
		INSERT INTO {tablepre}online (sid, uid, username, userip, usergroupid) VALUES (@sid, @uid, @username, @userip, @usergroupid)
	END

--Ƿ´
IF @uid > 0
	BEGIN
		IF EXISTS(SELECT 1 FROM {tablepre}pm WHERE msgtoid = @uid AND posttime <= GetDate())
			RETURN 1
	END

SET NOCOUNT OFF
{next}
CREATE PROCEDURE [dbo].[{tablepre}sp_newtopic]
@fid smallint,
@typeid tinyint,
@displayorder smallint,
@uid int,
@username nvarchar(20),
@usershow nvarchar(100),
@title nvarchar(255),
@types tinyint,
@special tinyint,
@price int,
@leaguejoinid int,
@iflocked tinyint,
@ifanonymity tinyint,
@message ntext,
@userip char(15)
AS
SET NOCOUNT ON

DECLARE @league_name nvarchar(50)
DECLARE @league_userid int
DECLARE @leagueid smallint
DECLARE @tid int

--֤
SET @leagueid = 0
IF @leaguejoinid > 0 AND @uid > 0
BEGIN
	SELECT @league_userid = lm.uid, @leagueid = lm.leagueid, @league_name = l.name FROM {tablepre}leaguemembers lm INNER JOIN {tablepre}leagues l ON lm.leagueid = l.leagueid WHERE lm.joinid = @leaguejoinid
	IF @league_userid = @uid
		SET @title = '' + @league_name + '' + @title
END

--Ϣ
INSERT INTO {tablepre}topics (fid, typeid, displayorder, uid, username, usershow, title, types, special, price, leagueid, iflocked, ifanonymity)
VALUES (@fid, @typeid, @displayorder, @uid, @username, @usershow, @title, @types, @special, @price, @leagueid, @iflocked, @ifanonymity)

--ȡӵı
SELECT @tid = SCOPE_IDENTITY()

--
INSERT INTO {tablepre}posts (fid, tid, first, uid, username, usershow, message, userip, ifanonymity)
VALUES (@fid, @tid, 1, @uid, @username, @usershow, @message, @userip, @ifanonymity)

--˲
IF @leagueid > 0
	BEGIN
		INSERT INTO {tablepre}leaguetopics (leagueid, tid) VALUES (@leagueid, @tid)
		INSERT INTO {tablepre}leaguelogs (leagueid, username, operation) VALUES (@leagueid, @username, '<b>'+ @title +'</b>('+ @userip +')')
		UPDATE {tablepre}leagues SET topics = topics + 1 WHERE leagueid = @leagueid
	END

--°ͳ
UPDATE {tablepre}forums SET topics = topics + 1 WHERE fid = @fid

--ûͳ
IF @uid > 0
	UPDATE {tablepre}members SET topics = topics + 1, newtopictime = DateDiff(s, '1970-01-01 0:00:00', GETDATE()) WHERE uid = @uid

RETURN @tid
SET NOCOUNT OFF
{next}
CREATE PROCEDURE [dbo].[{tablepre}sp_newreply]
@fid smallint,
@tid int,
@uid int,
@username nvarchar(20),
@usershow nvarchar(100),
@message ntext,
@userip char(15),
@ifanonymity tinyint,
@ratemark int,
@disable_update tinyint,
@postfloodctrl int

AS
SET NOCOUNT ON

--ظ
INSERT INTO {tablepre}posts(fid, tid, uid, username, usershow, message, userip, ifanonymity, ratemark) 
VALUES(@fid, @tid, @uid, @username, @usershow, @message, @userip, @ifanonymity, @ratemark)

--ӻظ; Ƿ
IF @disable_update = 1
	UPDATE {tablepre}topics SET posts = posts + 1 WHERE tid = @tid
ELSE
	UPDATE {tablepre}topics SET lastupdate = GetDate(), posts = posts + 1 WHERE tid = @tid

--°ͳ
UPDATE {tablepre}forums SET posts = posts + 1 WHERE fid = @fid

--ûͳ; Ƿˮ
IF @uid > 0
	UPDATE {tablepre}members SET postfloodctrl = @postfloodctrl, posts = posts + 1 WHERE uid = @uid

SET NOCOUNT OFF
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowvisit]  DEFAULT ((0)) FOR [allowvisit]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_disableperiodctrl]  DEFAULT ((0)) FOR [disableperiodctrl]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowpost]  DEFAULT ((0)) FOR [allowpost]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowdirectpost]  DEFAULT ((0)) FOR [allowdirectpost]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowreply]  DEFAULT ((0)) FOR [allowreply]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_anonymitysuc]  DEFAULT ((0)) FOR [anonymitysuc]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowpostpoll]  DEFAULT ((0)) FOR [allowpostpoll]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowpoll]  DEFAULT ((0)) FOR [allowpoll]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowsearch]  DEFAULT ((0)) FOR [allowsearch]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowgetattach]  DEFAULT ((0)) FOR [allowgetattach]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowpostattach]  DEFAULT ((0)) FOR [allowpostattach]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_maxattachsize]  DEFAULT ((0)) FOR [maxattachsize]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_attachextensions]  DEFAULT ('') FOR [attachextensions]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowviewuserinfo]  DEFAULT ((0)) FOR [allowviewuserinfo]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowuseitem]  DEFAULT ((0)) FOR [allowuseitem]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowhtml]  DEFAULT ((0)) FOR [allowhtml]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowchat]  DEFAULT ((0)) FOR [allowchat]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_specialinterface]  DEFAULT ('') FOR [specialinterface]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_allowinvate]  DEFAULT ((0)) FOR [allowinvate]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_invateprice]  DEFAULT ((0)) FOR [invateprice]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_invatemaxnum]  DEFAULT ((0)) FOR [invatemaxnum]
{next}
ALTER TABLE [dbo].[{tablepre}access] ADD  CONSTRAINT [DF_{tablepre}access_invateexpiryday]  DEFAULT ((0)) FOR [invateexpiryday]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_alloweditpost]  DEFAULT (0) FOR [allowmanagetopic]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_alloweditpoll]  DEFAULT (0) FOR [alloweditpoll]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowsticktopic]  DEFAULT (0) FOR [allowsticktopic]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowauditingtopic]  DEFAULT (0) FOR [allowauditingtopic]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowviewip]  DEFAULT (0) FOR [allowviewip]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowbanip]  DEFAULT (0) FOR [allowbanip]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowedituser]  DEFAULT (0) FOR [allowedituser]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowpunishuser]  DEFAULT (0) FOR [allowpunishuser]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowdisablecontrol]  DEFAULT (0) FOR [disablepostctrl]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowdelitemmsg]  DEFAULT (0) FOR [allowdelitemmsg]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_disablepmctrl]  DEFAULT (0) FOR [disablepmctrl]
{next}
ALTER TABLE [dbo].[{tablepre}admingroups] ADD  CONSTRAINT [DF_{tablepre}admingroups_allowviewlog]  DEFAULT (0) FOR [allowviewlog]
{next}
ALTER TABLE [dbo].[{tablepre}banip] ADD  CONSTRAINT [DF_{tablepre}banip_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}chatmessages] ADD  CONSTRAINT [DF_{tablepre}chatmessages_uid]  DEFAULT (0) FOR [uid]
{next}
ALTER TABLE [dbo].[{tablepre}chatmessages] ADD  CONSTRAINT [DF_{tablepre}chatmessages_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}failedlogins] ADD  CONSTRAINT [DF_{tablepre}failedlogins_falsecount]  DEFAULT (1) FOR [falsecount]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_moderators]  DEFAULT ('') FOR [moderators]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_viewperm]  DEFAULT ('') FOR [viewperm]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_posttopicperm]  DEFAULT ('') FOR [posttopicperm]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_postreplyperm]  DEFAULT ('') FOR [postreplyperm]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_postattachperm]  DEFAULT ('') FOR [postattachperm]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_getattachperm]  DEFAULT ('') FOR [getattachperm]
{next}
ALTER TABLE [dbo].[{tablepre}forumfields] ADD  CONSTRAINT [DF_{tablepre}forumfields_topictype]  DEFAULT ('') FOR [topictype]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_name]  DEFAULT ('') FOR [name]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_parentid]  DEFAULT (0) FOR [parentid]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_childs]  DEFAULT (0) FOR [childs]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_rootfid]  DEFAULT (0) FOR [rootfid]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_displayorder]  DEFAULT (0) FOR [displayorder]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_topics]  DEFAULT (0) FOR [topics]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_posts]  DEFAULT (0) FOR [posts]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_todayposts]  DEFAULT (0) FOR [todayposts]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_allowpost]  DEFAULT (0) FOR [allowpost]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_adultingpost]  DEFAULT (0) FOR [adultingpost]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_showtopictype]  DEFAULT (0) FOR [showtopictype]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_choosetopictype]  DEFAULT (0) FOR [choosetopictype]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_allowpolltopic]  DEFAULT (0) FOR [allowpolltopic]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_autoclose]  DEFAULT (0) FOR [autoclose]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_recyclebin]  DEFAULT (0) FOR [recyclebin]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_visitndcredits]  DEFAULT (0) FOR [visitndcredits]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_postndcredits]  DEFAULT (0) FOR [postndcredits]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_replyndcredits]  DEFAULT (0) FOR [replyndcredits]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_anonymitycredits]  DEFAULT (0) FOR [anonyndmitycredits]
{next}
ALTER TABLE [dbo].[{tablepre}forums] ADD  CONSTRAINT [DF_{tablepre}forums_htmlndcredits]  DEFAULT (0) FOR [htmlndcredits]
{next}
ALTER TABLE [dbo].[{tablepre}invate] ADD  CONSTRAINT [DF_{tablepre}invate_status]  DEFAULT ((0)) FOR [status]
{next}
ALTER TABLE [dbo].[{tablepre}invate] ADD  CONSTRAINT [DF_{tablepre}invate_buytime]  DEFAULT (getdate()) FOR [buytime]
{next}
ALTER TABLE [dbo].[{tablepre}invate] ADD  CONSTRAINT [DF_{tablepre}invate_reguid]  DEFAULT ((0)) FOR [reguid]
{next}
ALTER TABLE [dbo].[{tablepre}invate] ADD  CONSTRAINT [DF_{tablepre}invate_regtime]  DEFAULT ((0)) FOR [regtime]
{next}
ALTER TABLE [dbo].[{tablepre}itemmarketlogs] ADD  CONSTRAINT [DF_{tablepre}itemmarketlogs_price]  DEFAULT (0) FOR [price]
{next}
ALTER TABLE [dbo].[{tablepre}itemmarketlogs] ADD  CONSTRAINT [DF_{tablepre}itemmarketlogs_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}itemmessages] ADD  CONSTRAINT [DF_{tablepre}itemmessages_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}items] ADD  CONSTRAINT [DF_{tablepre}items_available]  DEFAULT ((0)) FOR [available]
{next}
ALTER TABLE [dbo].[{tablepre}items] ADD  CONSTRAINT [DF_{tablepre}items_iflog]  DEFAULT ((0)) FOR [iflog]
{next}
ALTER TABLE [dbo].[{tablepre}items] ADD  CONSTRAINT [DF_{tablepre}items_description]  DEFAULT ('') FOR [description]
{next}
ALTER TABLE [dbo].[{tablepre}items] ADD  CONSTRAINT [DF_{tablepre}items_displayorder]  DEFAULT ((0)) FOR [displayorder]
{next}
ALTER TABLE [dbo].[{tablepre}itemuselogs] ADD  CONSTRAINT [DF_{tablepre}itemuselogs_operation]  DEFAULT ('') FOR [operation]
{next}
ALTER TABLE [dbo].[{tablepre}itemuselogs] ADD  CONSTRAINT [DF_{tablepre}itemuselogs_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}leaguelogs] ADD  CONSTRAINT [DF_{tablepre}leaguelogs_typeid]  DEFAULT (0) FOR [typeid]
{next}
ALTER TABLE [dbo].[{tablepre}leaguelogs] ADD  CONSTRAINT [DF_{tablepre}leaguelogs_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}leaguemembers] ADD  CONSTRAINT [DF_{tablepre}leaguemembers_jointime]  DEFAULT (getdate()) FOR [jointime]
{next}
ALTER TABLE [dbo].[{tablepre}leaguenews] ADD  CONSTRAINT [DF_{tablepre}leaguenews_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}leagues] ADD  CONSTRAINT [DF_{tablepre}leagues_ifadulting]  DEFAULT (0) FOR [ifadulting]
{next}
ALTER TABLE [dbo].[{tablepre}leagues] ADD  CONSTRAINT [DF_{tablepre}leagues_createtime]  DEFAULT (getdate()) FOR [createtime]
{next}
ALTER TABLE [dbo].[{tablepre}leagues] ADD  CONSTRAINT [DF_{tablepre}leagues_members]  DEFAULT (1) FOR [members]
{next}
ALTER TABLE [dbo].[{tablepre}leagues] ADD  CONSTRAINT [DF_{tablepre}leagues_news]  DEFAULT (0) FOR [news]
{next}
ALTER TABLE [dbo].[{tablepre}leagues] ADD  CONSTRAINT [DF_{tablepre}leagues_topics]  DEFAULT (0) FOR [topics]
{next}
ALTER TABLE [dbo].[{tablepre}logs] ADD  CONSTRAINT [DF_{tablepre}logs_operation]  DEFAULT ('') FOR [operation]
{next}
ALTER TABLE [dbo].[{tablepre}logs] ADD  CONSTRAINT [DF_{tablepre}logs_reason]  DEFAULT ('') FOR [reason]
{next}
ALTER TABLE [dbo].[{tablepre}logs] ADD  CONSTRAINT [DF_{tablepre}logs_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}memberfields] ADD  CONSTRAINT [DF_{tablepre}memberfields_designation]  DEFAULT ('') FOR [designation]
{next}
ALTER TABLE [dbo].[{tablepre}memberfields] ADD  CONSTRAINT [DF_{tablepre}memberfields_signature]  DEFAULT ('') FOR [signature]
{next}
ALTER TABLE [dbo].[{tablepre}memberfields] ADD  CONSTRAINT [DF_{tablepre}memberfields_ignorepm]  DEFAULT ('') FOR [ignorepm]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_profile]  DEFAULT ('') FOR [profile]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_province]  DEFAULT ('') FOR [province]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_area]  DEFAULT ('') FOR [area]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_gender]  DEFAULT (0) FOR [gender]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_birthyear]  DEFAULT (0) FOR [birthyear]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_birthmonth]  DEFAULT (0) FOR [birthmonth]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_birthday]  DEFAULT (0) FOR [birthday]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_constellation]  DEFAULT (0) FOR [constellation]
{next}
ALTER TABLE [dbo].[{tablepre}memberprofiles] ADD  CONSTRAINT [DF_{tablepre}memberprofiles_ifphoto]  DEFAULT (0) FOR [ifphoto]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_secques]  DEFAULT ('') FOR [secques]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_admingroupid]  DEFAULT ((0)) FOR [admingroupid]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_credits]  DEFAULT ((0)) FOR [credits]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_regtime]  DEFAULT (getdate()) FOR [regtime]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_lastlogintime]  DEFAULT (getdate()) FOR [lastlogintime]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_logintime]  DEFAULT (getdate()) FOR [logintime]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_logincount]  DEFAULT ((1)) FOR [logincount]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_newtopictime]  DEFAULT ((0)) FOR [newtopictime]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_postfloodctrl]  DEFAULT ((0)) FOR [postfloodctrl]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_topics]  DEFAULT ((0)) FOR [topics]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_posts]  DEFAULT ((0)) FOR [posts]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_accessmasks]  DEFAULT ((0)) FOR [accessmasks]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_groupexpiry]  DEFAULT ((0)) FOR [groupexpiry]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_newpm]  DEFAULT ((0)) FOR [newpm]
{next}
ALTER TABLE [dbo].[{tablepre}members] ADD  CONSTRAINT [DF_{tablepre}members_leaguegid]  DEFAULT ((0)) FOR [leaguegid]
{next}
ALTER TABLE [dbo].[{tablepre}online] ADD  CONSTRAINT [DF_{tablepre}online_lastupdate]  DEFAULT (getdate()) FOR [lastupdate]
{next}
ALTER TABLE [dbo].[{tablepre}pm] ADD  CONSTRAINT [DF_{tablepre}pm_remessage]  DEFAULT ('') FOR [remessage]
{next}
ALTER TABLE [dbo].[{tablepre}pm] ADD  CONSTRAINT [DF_{tablepre}pm_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}polloptions] ADD  CONSTRAINT [DF_{tablepre}polloptions_votes]  DEFAULT ((0)) FOR [votes]
{next}
ALTER TABLE [dbo].[{tablepre}polloptions] ADD  CONSTRAINT [DF_{tablepre}polloptions_displayorder]  DEFAULT ((0)) FOR [displayorder]
{next}
ALTER TABLE [dbo].[{tablepre}polloptions] ADD  CONSTRAINT [DF_{tablepre}polloptions_voteuids]  DEFAULT ('') FOR [voteuids]
{next}
ALTER TABLE [dbo].[{tablepre}polls] ADD  CONSTRAINT [DF_{tablepre}polls_multiple]  DEFAULT ((0)) FOR [multiple]
{next}
ALTER TABLE [dbo].[{tablepre}polls] ADD  CONSTRAINT [DF_{tablepre}polls_visible]  DEFAULT ((0)) FOR [visible]
{next}
ALTER TABLE [dbo].[{tablepre}polls] ADD  CONSTRAINT [DF_{tablepre}polls_maxchoices]  DEFAULT ((0)) FOR [maxchoices]
{next}
ALTER TABLE [dbo].[{tablepre}polls] ADD  CONSTRAINT [DF_{tablepre}polls_totalpoll]  DEFAULT ((0)) FOR [totalpoll]
{next}
ALTER TABLE [dbo].[{tablepre}polls] ADD  CONSTRAINT [DF_{tablepre}polls_expirytime]  DEFAULT ((0)) FOR [expirytime]
{next}
ALTER TABLE [dbo].[{tablepre}posts] ADD  CONSTRAINT [DF_{tablepre}posts_first]  DEFAULT ((0)) FOR [first]
{next}
ALTER TABLE [dbo].[{tablepre}posts] ADD  CONSTRAINT [DF_{tablepre}posts_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}posts] ADD  CONSTRAINT [DF_{tablepre}posts_ifanonymity]  DEFAULT ((0)) FOR [ifanonymity]
{next}
ALTER TABLE [dbo].[{tablepre}posts] ADD  CONSTRAINT [DF_{tablepre}posts_ratemark]  DEFAULT ((0)) FOR [ratemark]
{next}
ALTER TABLE [dbo].[{tablepre}searchindex] ADD  CONSTRAINT [DF_{tablepre}searchindex_searchcount]  DEFAULT (1) FOR [searchcount]
{next}
ALTER TABLE [dbo].[{tablepre}settings] ADD  CONSTRAINT [DF_{tablepre}settings_wordsfilter]  DEFAULT ('') FOR [wordsfilter]
{next}
ALTER TABLE [dbo].[{tablepre}settings] ADD  CONSTRAINT [DF_{tablepre}settings_banip]  DEFAULT ('') FOR [banip]
{next}
ALTER TABLE [dbo].[{tablepre}settings] ADD  CONSTRAINT [DF_{tablepre}settings_todayposts]  DEFAULT (0) FOR [todayposts]
{next}
ALTER TABLE [dbo].[{tablepre}settings] ADD  CONSTRAINT [DF_{tablepre}settings_invatenum]  DEFAULT (0) FOR [invatenum]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_fid]  DEFAULT ((0)) FOR [fid]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_typeid]  DEFAULT ((0)) FOR [typeid]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_displayorder]  DEFAULT ((0)) FOR [displayorder]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_uid]  DEFAULT ((0)) FOR [uid]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_posttime]  DEFAULT (getdate()) FOR [posttime]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_lastupdate]  DEFAULT (getdate()) FOR [lastupdate]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_clicks]  DEFAULT ((0)) FOR [clicks]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_posts]  DEFAULT ((0)) FOR [posts]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_types]  DEFAULT ((0)) FOR [types]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_special]  DEFAULT ((0)) FOR [special]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_price]  DEFAULT ((0)) FOR [price]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_leagueid]  DEFAULT ((0)) FOR [leagueid]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_ifelite]  DEFAULT ((0)) FOR [ifelite]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_iflocked]  DEFAULT ((0)) FOR [iflocked]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_ifanonymity]  DEFAULT ((0)) FOR [ifanonymity]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_ifmod]  DEFAULT ((0)) FOR [iftask]
{next}
ALTER TABLE [dbo].[{tablepre}topics] ADD  CONSTRAINT [DF_{tablepre}topics_disablemodify]  DEFAULT ((0)) FOR [disablemodify]
{next}
ALTER TABLE [dbo].[{tablepre}topictask] ADD  CONSTRAINT [DF_{tablepre}topictask_action]  DEFAULT ('') FOR [action]
{next}
ALTER TABLE [dbo].[{tablepre}topictask] ADD  CONSTRAINT [DF_{tablepre}topictask_itemid]  DEFAULT (0) FOR [itemid]
{next}
ALTER TABLE [dbo].[{tablepre}topictypes] ADD  CONSTRAINT [DF_{tablepre}topictypes_description]  DEFAULT ('') FOR [description]
{next}
ALTER TABLE [dbo].[{tablepre}topictypes] ADD  CONSTRAINT [DF_{tablepre}topictypes_displayorder]  DEFAULT (0) FOR [displayorder]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_initialize]  DEFAULT ((0)) FOR [initialize]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowvisit]  DEFAULT ((0)) FOR [allowvisit]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_disableperiodctrl]  DEFAULT ((0)) FOR [disableperiodctrl]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowpost]  DEFAULT ((0)) FOR [allowpost]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowdirectpost]  DEFAULT ((0)) FOR [allowdirectpost]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowreply]  DEFAULT ((0)) FOR [allowreply]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_anonymitysuc]  DEFAULT ((0)) FOR [anonymitysuc]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowpostpoll]  DEFAULT ((0)) FOR [allowpostpoll]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowpoll]  DEFAULT ((0)) FOR [allowpoll]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowsearch]  DEFAULT ((0)) FOR [allowsearch]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowgetattach]  DEFAULT ((0)) FOR [allowgetattach]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowpostattach]  DEFAULT ((0)) FOR [allowpostattach]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_maxattachsize]  DEFAULT ((0)) FOR [maxattachsize]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_attachextensions]  DEFAULT ('') FOR [attachextensions]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowviewuserinfo]  DEFAULT ((0)) FOR [allowviewuserinfo]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowuseitem]  DEFAULT ((0)) FOR [allowuseitem]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowhtml]  DEFAULT ((0)) FOR [allowhtml]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowchat]  DEFAULT ((0)) FOR [allowchat]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_specialinterface]  DEFAULT ('') FOR [specialinterface]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_allowinvate]  DEFAULT ((0)) FOR [allowinvate]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_invateprice]  DEFAULT ((0)) FOR [invateprice]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_invatemaxnum]  DEFAULT ((0)) FOR [invatemaxnum]
{next}
ALTER TABLE [dbo].[{tablepre}usergroups] ADD  CONSTRAINT [DF_{tablepre}usergroups_invateexpiryday]  DEFAULT ((0)) FOR [invateexpiryday]
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'վ', CONVERT(TEXT, N'moderator'), 1, 1, 1, 1, 1, 1, 100, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 1, N'', 1, 1, 9999, 999)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'߼Ա', CONVERT(TEXT, N'moderator'), 1, 1, 1, 1, 1, 1, 90, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 1, N'', 1, 10, 999, 99)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'Ա', CONVERT(TEXT, N'moderator'), 1, 1, 1, 1, 1, 1, 80, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 1, N'', 1, 30, 50, 60)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'ͨû', CONVERT(TEXT, N'member'), 1, 1, 0, 1, 1, 1, 60, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 0, 1, 1, 1, N'', 1, 50, 10, 30)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'ο', CONVERT(TEXT, N'member'), 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CONVERT(TEXT, N''), 0, 0, 0, 0, N'', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'', CONVERT(TEXT, N'restricted'), 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 0, 1, N'<body style="background:#000;">', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'', CONVERT(TEXT, N'restricted'), 1, 1, 0, 1, 0, 1, 50, 0, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 1, N'', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'ֹHTML', CONVERT(TEXT, N'restricted'), 1, 1, 0, 1, 1, 1, 50, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 0, 1, N'', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'Һ', CONVERT(TEXT, N'restricted'), 1, 1, 0, 1, 1, 1, 50, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 0, N'', 1, 100, 5, 5)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'ֹ', CONVERT(TEXT, N'restricted'), 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 0, 0, 0, N'', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'ֹ', CONVERT(TEXT, N'restricted'), 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CONVERT(TEXT, N''), 0, 0, 0, 0, N'', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}usergroups] ([name], [types], [initialize], [allowvisit], [disableperiodctrl], [allowpost], [allowdirectpost], [allowreply], [anonymitysuc], [allowpostpoll], [allowpoll], [allowsearch], [allowgetattach], [allowpostattach], [maxattachsize], [attachextensions], [allowviewuserinfo], [allowuseitem], [allowhtml], [allowchat], [specialinterface], [allowinvate], [invateprice], [invatemaxnum], [invateexpiryday]) VALUES (N'Բһ', CONVERT(TEXT, N'restricted'), 1, 1, 0, 1, 1, 1, 50, 1, 1, 1, 0, 0, 0, CONVERT(TEXT, N''), 1, 1, 1, 1, N'<script type="text/javascript" src="js/marsconver.js"></script>', 0, 0, 0, 0)
{next}
INSERT [dbo].[{tablepre}settings] ([site_settings], [item_settings], [wordsfilter], [banip], [banner], [todayposts], [invatenum]) VALUES (N'{bbsname}_____SETTINGS__________SETTINGS__________SETTINGS_____0_____SETTINGS_____̳άУԺ_____SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS_____0_____SETTINGS_____login.asp_____SETTINGS__________SETTINGS_____1_____SETTINGS_____20_____SETTINGS_____1_____SETTINGS_____5_____SETTINGS_____0_____SETTINGS_____30_____SETTINGS_____1_____SETTINGS_____3_____SETTINGS_____20_____SETTINGS_____200_____SETTINGS_____5_____SETTINGS_____0_____SETTINGS_____15_____SETTINGS_____60_____SETTINGS_____10000_____SETTINGS_____100_____SETTINGS_____0_____SETTINGS_____100_____SETTINGS_____<p>_____SETTINGS_____⵳_____SETTINGS_____3_____SETTINGS_____5_____SETTINGS_____3_____SETTINGS_____1_____SETTINGS_____غ´_____SETTINGS_____0_____SETTINGS_____1_____SETTINGS_____60_____SETTINGS_____{username}ͼ, ǿɳܵʧ<img src="face/846.gif" />_____SETTINGS_____edit_____SETTINGS__________SETTINGS_____60_____SETTINGS_____500_____SETTINGS_____1_____SETTINGS_____0_____SETTINGS_____1_____SETTINGS_____1_____SETTINGS_____300_____SETTINGS_____5_____SETTINGS_____15_____SETTINGS_____500_____SETTINGS_____300_____SETTINGS_____20_____SETTINGS_____100_____SETTINGS_____͵{username}ѷɨøɸɾ_____SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS__________SETTINGS_____', N'1_____SETTINGS_____60_____SETTINGS_____24_____SETTINGS_____72_____SETTINGS_____2_____SETTINGS_____4_____SETTINGS_____100_____SETTINGS_____4700_____SETTINGS_____470_____SETTINGS_____170_____SETTINGS_____17_____SETTINGS_____7', CONVERT(TEXT, N''), CONVERT(TEXT, N''), N'ҹ΢ Ц ֪ Ƿ', 0, 99)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'MPת', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'credittransfer'), 1, 1, N'תýǮû¼춯档', 1)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'߹ۼ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'uptopic'), 1, 1, N'UPӵб', 2)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ֽ', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'setsig'), 1, 1, N'ǩ', 3)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'Ȧ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'sticktopicplus'), 1, 1, N'ȾȦöʱ䡣', 4)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'requestmusic'), 1, 1, N'衣', 5)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ħʱջ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'sinktopic'), 1, 1, N'ͻؼǰбʧ', 6)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'鹭', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'sinksticktopic'), 1, 1, N'ƻȦЧ', 7)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'β', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'setdesignation'), 1, 1, N'óƺţûʱƺŽû档', 8)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'Ȧ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'sticktopic'), 1, 1, N'öһʱ䡣', 9)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ͼ', CONVERT(TEXT, N'anonymity'), CONVERT(TEXT, N'clearallanonymity'), 1, 1, N'ʹĿǰʧЧʹӳ⣩', 10)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'õ', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'statusbar'), 1, 1, N'״̬ϢúõϢ״̬֧IE6', 11)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'', CONVERT(TEXT, N'other'), CONVERT(TEXT, N'anonymity'), 1, 1, N'ûûʹ÷ΪûڵĴе', 12)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'۾', CONVERT(TEXT, N'anonymity'), CONVERT(TEXT, N'clearanonymity'), 1, 1, N'ʹǰԵûʧЧ', 13)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'reversetopic'), 1, 1, N'תӱַ˳', 14)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'Ŀ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'settopiccolor'), 1, 1, N'ıӱɫ', 15)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'Զ֮', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'userdetail'), 1, 1, N'鿴ûϢ', 16)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'', CONVERT(TEXT, N'anonymity'), CONVERT(TEXT, N'viewanonymity'), 1, 1, N'鿴ûʵơ', 17)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ˮ', CONVERT(TEXT, N'member'), CONVERT(TEXT, N'viewip'), 1, 1, N'ѯûIPͬʱгͬIPû', 18)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ϰ', CONVERT(TEXT, N'other'), CONVERT(TEXT, N'clearchatroom'), 1, 1, N'', 19)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'ĳȯ', CONVERT(TEXT, N'other'), CONVERT(TEXT, N'dice'), 1, 1, N'ӣݹýǮ', 20)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'֮Ĭ', CONVERT(TEXT, N'topic'), CONVERT(TEXT, N'disablereply'), 1, 1, N'ʹӲܻظ¥лظ', 21)
{next}
INSERT [dbo].[{tablepre}items] ([name], [types], [identifier], [available], [iflog], [description], [displayorder]) VALUES (N'', CONVERT(TEXT, N'anonymity'), CONVERT(TEXT, N'face'), 1, 1, N'ӵ', 22)
{next}
INSERT [dbo].[{tablepre}forums] ([name], [parentid], [childs], [rootfid], [displayorder], [topics], [posts], [todayposts], [allowpost], [adultingpost], [showtopictype], [choosetopictype], [allowpolltopic], [autoclose], [recyclebin], [visitndcredits], [postndcredits], [replyndcredits], [anonyndmitycredits], [htmlndcredits]) VALUES (N'Ĭϰ', 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 50, 100)
{next}
INSERT [dbo].[{tablepre}forumfields] ([fid], [moderators], [viewperm], [posttopicperm], [postreplyperm], [postattachperm], [getattachperm], [topictype]) VALUES (1, CONVERT(TEXT, N''), CONVERT(TEXT, N''), CONVERT(TEXT, N''), CONVERT(TEXT, N''), CONVERT(TEXT, N''), CONVERT(TEXT, N''), CONVERT(TEXT, N''))
{next}
INSERT [dbo].[{tablepre}admingroups] ([gid], [allowmanagetopic], [alloweditpoll], [allowsticktopic], [allowauditingtopic], [allowviewip], [allowbanip], [allowedituser], [allowpunishuser], [disablepostctrl], [allowdelitemmsg], [disablepmctrl], [allowviewlog]) VALUES (1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
{next}
INSERT [dbo].[{tablepre}admingroups] ([gid], [allowmanagetopic], [alloweditpoll], [allowsticktopic], [allowauditingtopic], [allowviewip], [allowbanip], [allowedituser], [allowpunishuser], [disablepostctrl], [allowdelitemmsg], [disablepmctrl], [allowviewlog]) VALUES (2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
{next}
INSERT [dbo].[{tablepre}admingroups] ([gid], [allowmanagetopic], [alloweditpoll], [allowsticktopic], [allowauditingtopic], [allowviewip], [allowbanip], [allowedituser], [allowpunishuser], [disablepostctrl], [allowdelitemmsg], [disablepmctrl], [allowviewlog]) VALUES (3, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0)