<%
  ' Begin upgrading the database

  response.write "Checking for presence of [threads].[approved]"
  if not (FieldExists("threads", "approved")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [threads] add column [approved] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [threads] add [approved] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if


  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [messages].[approved]"
  if not (FieldExists("messages", "approved")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [messages] add column [approved] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [messages] add [approved] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  SQL = "update messages set approved=1"
  response.write "SQL =: " & SQL & "<br/>"
  dbConnection.Execute SQL

  SQL = "update threads set approved=1"
  response.write "SQL =: " & SQL & "<br/>"
  dbConnection.Execute SQL

  response.write "Checking for presence of [languages].[id]"
  if not (TableExists("languages")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "Create Table [languages] (id int identity(1,1) PRIMARY KEY)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Create Table [dbo].[languages] (id int identity(1,1) PRIMARY KEY)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if
  response.flush

  response.write "Checking for presence of [languages].[longname]"
  if not (FieldExists("languages", "longname")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [languages] add column [longname] varchar(100) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [languages] add [longname] [NVARCHAR] (100) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [languages].[shortname]"
  if not (FieldExists("languages", "shortname")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [languages] add column [shortname] varchar(100) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [languages] add [shortname] [NVARCHAR] (100) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [languages].[isdefault]"
  if not (FieldExists("languages", "isdefault")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [languages] add column [isdefault] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [languages] add [isdefault] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     response.write "Inserting default language: US English<br/>"
     SQL = "insert into languages (longname, shortname, isdefault) values('US English', 'us', 1)"
     response.write "SQL =: " & SQL & "<br/>"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[languageid]"
  if not (FieldExists("members", "languageid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [languageid] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [languageid] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update members set languageid=1"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[oktopost]"
  if not (FieldExists("members", "oktopost")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [oktopost] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [oktopost] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update members set oktopost=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if


  response.write "Checking for presence of [attachments].[sortorder]"
  if not (FieldExists("attachments", "sortorder")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [attachments] add column [sortorder] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [attachments] add [sortorder] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update attachments set sortorder=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [settings]"
  if not (TableExists("settings")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
    SQL = "CREATE TABLE [settings] ([settingskey] varchar(100) not null, [settingsvalue] varchar(100) not null, [settingsgroup] text not null)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
    SQL = "CREATE TABLE [dbo].[settings] ([settingskey] nvarchar(100) not null default '', "
    SQL = SQL & "[settingsgroup] nvarchar(100) not null default '', [settingsvalue] ntext not null default '')"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
  end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[disallowbroadcasts]"
  if not (FieldExists("members", "disallowbroadcasts")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [disallowbroadcasts] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [disallowbroadcasts] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update members set disallowbroadcasts=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[viewavatars]"
  if not (FieldExists("members", "viewavatars")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [viewavatars] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [viewavatars] int not null default 1"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update members set viewavatars=1"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[salt]"
  if not (FieldExists("members", "salt")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [salt] varchar(10) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [salt] nvarchar(10) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
      end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[vcode]"
  if not (FieldExists("members", "vcode")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [vcode] varchar(10) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [vcode] nvarchar(10) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
     SQL = "update members set vcode=''"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[quickreplymode]"
  if not (FieldExists("members", "quickreplymode")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [quickreplymode] varchar(7) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add [quickreplymode] nvarchar(7) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
      end if

      SQL = "update members set quickreplymode='compact'"
      dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [schemes].[hidden]"
  if not (FieldExists("schemes", "hidden")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [schemes] add column [hidden] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [schemes] add [hidden] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update schemes set hidden=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  ' ==================================================================================
  ' REMOVE FOR FULL RELEASE OF 2.2
  ' ==================================================================================
  response.write "Checking for presence of [messages].[revisions]"
  if  (FieldExists("messages", "revisions")) then
     response.write " <font color=""red"">FOUND.. REMOVING</font><br/>"

     DropColumn "messages", "revisions"

  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [forums].[rss]"
  if not (FieldExists("forums", "rss")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [forums] add column [rss] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [forums] add [rss] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update forums set rss=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [signups].[unavailable]"
  if not (FieldExists("signups", "unavailable")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [signups] add column [unavailable] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [signups] add [unavailable] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update signups set unavailable=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  ' ==================================================================================
  ' REMOVE FOR FULL RELEASE OF 2.2
  ' ==================================================================================
  if TableExists("alerts") and not(FieldExists("alerts", "type")) then
    response.write " <font color=""red"">CLEARING OLD VERSION OF ALERTS TABLE</font><br/>"
    if sDBType = "access" then
        SQL = "Drop Table [alerts];"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Drop Table [dbo].[alerts];"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  end if
  ' ==================================================================================
  ' REMOVE FOR FULL RELEASE OF 2.2
  ' ==================================================================================

  response.write "Checking for presence of [alerts]"
  if not (TableExists("alerts")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "Create Table [alerts] ([alertid] int identity(1,1) PRIMARY KEY, [type] int not null default 0, [messageid] int default 0, [memberid] int default 0, [approved] int not null default 0, [reported] date not null default #1/1/2002#, [message] text not null)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Create Table [dbo].[alerts] ([alertid] int identity(1,1) PRIMARY KEY, [type] int not null default 0, [messageid] int default 0, [memberid] int default 0, [approved] int not null default 0, [reported] smalldatetime not null default '1/1/2002', [message] ntext not null default '')"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if


  response.write "Checking for presence of [photos].[fullfile]"
  if not (FieldExists("photos", "fullfile")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [photos] add column [fullfile] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [photos] add [fullfile] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update photos set fullfile=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [photos].[thumbfile]"
  if not (FieldExists("photos", "thumbfile")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [photos] add column [thumbfile] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [photos] add [thumbfile] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update photos set thumbfile=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [threads].[lastpostid]"
  if not (FieldExists("threads", "lastpostid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [threads] add column [lastpostid] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [threads] add [lastpostid] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update threads set lastpostid=0"
     response.write "SQL =: " & SQL & "<br/>"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [threads].[seed]"
  if not (FieldExists("threads", "seed")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [threads] add column [seed] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [threads] add [seed] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update threads set seed=0"
     response.write "SQL =: " & SQL & "<br/>"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[lastmaintenance]"
  if not (FieldExists("dbconfigs", "lastmaintenance")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [lastmaintenance] date not null default #1/1/2002#"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [lastmaintenance] smalldatetime not null default '1/1/2002'"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set lastmaintenance=" & sDateDelimiter & "2002-1-1" & sDateDelimiter
     response.write "SQL =: " & SQL & "<br/>"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[passwordsencrypted]"
  if not (FieldExists("dbconfigs", "passwordsencrypted")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [passwordsencrypted] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [passwordsencrypted] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set passwordsencrypted=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[footerunlocked]"
  if not (FieldExists("dbconfigs", "footerunlocked")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [footerunlocked] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [footerunlocked] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set footerunlocked=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[featuresunlocked]"
  if not (FieldExists("dbconfigs", "featuresunlocked")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [featuresunlocked] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [featuresunlocked] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set featuresunlocked=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[footercode]"
  if not (FieldExists("dbconfigs", "footercode")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [footercode] varchar(10) default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [footercode] nvarchar(10) default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set footercode='', footerunlocked=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [dbconfigs].[featurescode]"
  if not (FieldExists("dbconfigs", "featurescode")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [dbconfigs] add column [featurescode] varchar(10) default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [dbconfigs] add [featurescode] nvarchar(10) default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update dbconfigs set featurescode='', featuresunlocked=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [rssfeeds]"
  if not (TableExists("rssfeeds")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "Create Table [rssfeeds] ([rssname] varchar(10) not null PRIMARY KEY)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
        SQL = "alter table [rssfeeds] add column [expiration] date not null default #1/1/2002#"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
        SQL = "alter table [rssfeeds] add column [feed] text"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Create Table [dbo].[rssfeeds] ([rssname] nvarchar(10) not null PRIMARY KEY)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
        SQL = "alter table [rssfeeds] add  [expiration] smalldatetime not null default '1/1/2002'"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
        SQL = "alter table [rssfeeds] add  [feed] ntext"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [revisions]"
  if not (TableExists("revisions")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "Create Table [revisions] ([revisionid] int identity(1,1) PRIMARY KEY, [messageid] int not null default 0, [dateedited] date not null default #1/1/2002#, [editedbyname] varchar(20) not null, [editedbyid] int not null default 0, [revisionbody] text not null)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Create Table [dbo].[revisions] ([revisions] int identity(1,1) PRIMARY KEY, [messageid] int not null default 0, [dateedited] smalldatetime not null default '1/1/2002', [editedbyname] nvarchar(20) not null default '', [editedbyid] int not null default 0, [revisionbody] ntext not null default '')"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [messages].[hasrevisions]"
  if not (FieldExists("messages", "hasrevisions")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [messages] add column [hasrevisions] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [messages] add [hasrevisions] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update messages set hasrevisions=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [albums].[commentcount]"
  if not (FieldExists("albums", "commentcount")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [albums] add column [commentcount] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [albums] add [commentcount] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "select albumid, commentcount from albums"
     rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockOptimistic
     do until rsMaster.EOF
       SQL = "select count(photocomments.photoid) as commentcount FROM photocomments, photos where photos.photoid=photocomments.photoid AND photos.albumid=" & rsMaster.fields("albumid").value
       rsMaster2.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
       rsMaster.fields("commentcount") = rsMaster2.fields(0).value
       rsMaster2.Close
       rsMaster.update
       response.write "Updated comment count for album: " & rsMaster.fields("albumid").value & "<br/>"
       response.flush
       rsMaster.movenext
     loop
     rsMaster.Close

  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [albums].[photocount]"
  if not (FieldExists("albums", "photocount")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [albums] add column [photocount] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [albums] add [photocount] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "select albumid, photocount from albums"
     rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockOptimistic
     do until rsMaster.EOF
       SQL = "select count(*) as totalcount from photos where albumid=" & BBS.ValidateNumeric(rsMaster.fields("albumid").value)
       rsMaster2.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
       rsMaster.fields("photocount") = rsMaster2.fields(0).value
       rsMaster2.Close
       rsMaster.update
       response.write "Updated photo count for album: " & rsMaster.fields("albumid").value & "<br/>"
       response.flush
       rsMaster.movenext
     loop
     rsMaster.Close

  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [attachments].[infilesystem]"
  if not (FieldExists("attachments", "infilesystem")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [attachments] add column [infilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [attachments] add [infilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update attachments set infilesystem=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [attachments].[fileguid]"
  if not (FieldExists("attachments", "fileguid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [attachments] add column [fileguid] char (36) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [attachments] add [fileguid] char (36) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update attachments set fileguid=''"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [photos].[fileguid]"
  if not (FieldExists("photos", "fileguid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [photos] add column [fileguid] char (36) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [photos] add [fileguid] char (36) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update photos set fileguid=''"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [memberphotos].[photofileguid]"
  if not (FieldExists("memberphotos", "photofileguid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [memberphotos] add column [photofileguid] char (36) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [memberphotos] add [photofileguid] char (36) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update memberphotos set photofileguid=''"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if


  response.write "Checking for presence of [memberphotos].[avatarfileguid]"
  if not (FieldExists("memberphotos", "avatarfileguid")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [memberphotos] add column [avatarfileguid] char (36) not null default"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [memberphotos] add [avatarfileguid] char (36) not null default ''"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update memberphotos set avatarfileguid=''"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [memberphotos].[photoinfilesystem]"
  if not (FieldExists("memberphotos", "photoinfilesystem")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [memberphotos] add column [photoinfilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [memberphotos] add [photoinfilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update memberphotos set photoinfilesystem=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [memberphotos].[avatarinfilesystem]"
  if not (FieldExists("memberphotos", "avatarinfilesystem")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [memberphotos] add column [avatarinfilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [memberphotos] add [avatarinfilesystem] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update memberphotos set avatarinfilesystem=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if


  response.write "Checking for presence of [categories].[collapsedbydefault]"
  if not (FieldExists("categories", "collapsedbydefault")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [categories] add column [collapsedbydefault] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [categories] add [collapsedbydefault] int not null default 0"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if

     SQL = "update categories set collapsedbydefault=0"
     dbConnection.execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [floodlimits]"
  if not (TableExists("floodlimits")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "Create Table [floodlimits] ([id] int not null default 0, [idtype] int not null default 0, [limit] int not null default 0)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "Create Table [dbo].[floodlimits] ([id] int not null default 0, [idtype] int not null default 0, [limit] int not null default 0)"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "Checking for presence of [members].[ignorelist]"
  if not (FieldExists("members", "ignorelist")) then
     response.write " <font color=""red"">NOT FOUND.. UPGRADING DATABASE</font><br/>"

     if sDBType = "access" then
        SQL = "alter table [members] add column [ignorelist] text"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     elseif sDBType = "ms-sql" then
        SQL = "alter table [members] add  [ignorelist] ntext"
        response.write "SQL =: " & SQL & "<br/>"
        dbConnection.Execute SQL
     end if


     SQL = "update members set ignorelist=''"
     dbConnection.Execute SQL
  else
     response.write " <font color=""green"">FOUND</font><br/>"
  end if

  response.write "upgrading [mbbscode].[html] to unlimited length<br/>"
  if sDBType = "access" then
    SQL = "alter table [mbbscode] alter column [html] text not null"
    response.write "SQL =: " & SQL & "<br/>"
    dbConnection.Execute SQL

  elseif sDBType = "ms-sql" then
    DropConstraint "mbbscode", "html"
    on error resume next
    SQL = "alter table [mbbscode] alter column [html] ntext not null"
    response.write "SQL =: " & SQL & "<br/>"
    dbConnection.Execute SQL
    on error goto 0
  end if

  response.write "upgrading [mbbscode].[closehtml] to unlimited length<br/>"
  if sDBType = "access" then
    SQL = "alter table [mbbscode] alter column [closehtml] text not null"
    response.write "SQL =: " & SQL & "<br/>"
    dbConnection.Execute SQL

  elseif sDBType = "ms-sql" then
    DropConstraint "mbbscode", "closehtml"
    on error resume next
    SQL = "alter table [mbbscode] alter column [closehtml] ntext not null"
    response.write "SQL =: " & SQL & "<br/>"
    dbConnection.Execute SQL
    on error goto 0
  end if

  response.write "Photos is no longer a required field<br/>"
  if sDBType = "access" then
    SQL = "alter table [photos] alter column [picture] LONGBINARY null "
    response.write "SQL =: " & SQL & "<br/>"
    dbConnection.Execute SQL
  end if

  response.write "Removing unneeded poll data<br/>"
  SQL = "delete from polls where pollid not in(select distinct pollid from polloptions)"
  response.write "SQL =: " & SQL & "<br/>"
  dbConnection.Execute SQL

  response.flush

  rsMaster.open "select * from bbsconfiguration where configname='iPURGEHISTORYDAYS'", dbConnection, adOpenStatic, adLockOptimistic
  if rsMaster.EOF then
    rsMaster.AddNew
    rsMaster.fields("configname")  = "iPURGEHISTORYDAYS"
    rsMaster.fields("configvalue") = 0
    rsMaster.update
  end if
  rsMaster.Close


  ' Set the default scheme to /original
  SQL = "update schemes set isdefault=0"
  dbConnection.execute SQL
  rsMaster.open "select * from schemes where schemepath='/original'", dbConnection, adOpenStatic, adLockOptimistic
  if rsMaster.EOF then
    rsMaster.addnew
    rsmaster.fields("schemepath") = "/original"
    rsMaster.fields("schemename") = "MegaBBS 2.0 original"
    rsMaster.fields("hidden")     = 0
  end if
  rsMaster.update
  rsMaster.Close
  SQL = "update schemes set isdefault=1 where schemepath='/original'"
  dbConnection.execute SQL

  ' Add the ocean scheme if it doesn't exist (but hide it in case people have restricted skin configurations)
  dbConnection.execute SQL
  rsMaster.open "select * from schemes where schemepath='/ocean'", dbConnection, adOpenStatic, adLockOptimistic
  if rsMaster.EOF then
    rsMaster.addnew
    rsmaster.fields("schemepath") = "/ocean"
    rsMaster.fields("schemename") = "Ocean"
    rsMaster.fields("hidden")     = 1
  end if
  rsMaster.update
  rsMaster.Close

  bShowEncryptButton = 1

  rsmaster.open "select * from dbconfigs", dbConnection, adOpenforwardOnly, adLockOptimistic
  if rsMaster.EOF then rsMaster.AddNew
  rsMaster("bbsversion") = "2.2"
  if rsMaster("passwordsencrypted") = 1 then bShowEncryptButton = 0
  rsMaster.update
  rsMaster.close
  iSrcDBVersion = 2.2
  response.write "<br/><br/>Your database structure is now 2.2 compliant<br/><br/>"
%>
