<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="includes/include.asp"-->
<!-- #include file="includes/include-alerts.asp"-->
<!-- #include file="includes/include-forums.asp"-->
<%
  sBBSLangPage = "alert-list"
  BBS.SetupBBS()
  BBS.SetScheme(0)

  dim iAlertType, sTypeDropDown, vAlerts, index, sAlertList, vAlertInfo, vUserInfo, vMessageInfo, vThreadInfo, vForumInfo
  dim iAlertMemberLevel, bCanView

  iAlertType = BBS.ValidateNumeric(request.querystring("type"))

  if iBBSUserLevel >= USERLEVEL_SupportAdministrator then
    iAlertMemberLevel = USERLEVEL_SupportAdministrator
  else
    ' Is the user a moderator in any forum at all?
    iAlertMemberLevel = BBS.GetUserLevel(MODULE_Forums, -1)
  end if

  ' Moderators or below are not allowed
  if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"

  ' Default
  if iAlertType = 0 then iAlertType = ALERT_BADPost

  ' Get the alert type we are viewing and make sure we can view this page

  if iAlertType = ALERT_BadPost then
    if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    dictEnvironment.add "V-ALERTTYPE", "MESSAGE"
  elseif iAlertType = ALERT_NewPost then
    if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    if dictConfiguration.item("bLETMODERATORSAPPROVEPOSTS") = 0 and iBBSUserLevel = USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    if dictConfiguration.item("bFORCEPOSTVALIDATION") = 0 then response.redirect sBBSForumRoot & "/category-view.asp"
    dictEnvironment.add "V-ALERTTYPE", "MESSAGE"
  elseif iAlertType = ALERT_NewUser then
    if not(BBS.HasPermission(PERM_admineditusers,-1)) then response.redirect "alert-list.asp?type=" & ALERT_NEWPOST
    dictEnvironment.add "V-ALERTTYPE", "USER"
  else
    if not(BBS.HasPermission(PERM_admineditusers,-1)) then response.redirect "alert-list.asp?type=" & ALERT_NEWPOST
  end if

  ' Generate drop-down for types of alerts this user can view
  sTypeDropDown = "<select class='bbsdropdownbox' name='type'>"
  if iAlertMemberLevel >= USERLEVEL_Moderator then
    sTypeDropDown = sTypeDropDown & "<option value='" & ALERT_BadPost & "'" & BBS.IsSelected(iAlertType = ALERT_BadPost) & ">" & dictLanguage.item("GLOBAL-BADPOSTALERT") & " (" & BBS.GetComplexVariable(CV_BadPostAlerts) & ")</option>"
  end if
  if dictConfiguration.item("bFORCEPOSTVALIDATION") = 1 then
    sTypeDropDown = sTypeDropDown & "<option value='" & ALERT_NewPost & "'" & BBS.IsSelected(iAlertType = ALERT_NewPost) & ">" & dictLanguage.item("GLOBAL-NEWPOSTALERT") & " (" & BBS.GetComplexVariable(CV_NewPostAlerts) & ")</option>"
  end if
  if BBS.HasPermission(PERM_admineditusers,-1) then sTypeDropDown = sTypeDropDown & "<option value='" & ALERT_NewUser & "'" & BBS.IsSelected(iAlertType = ALERT_NewUser) & ">" & dictLanguage.item("GLOBAL-NEWUSERALERT") & " (" & BBS.GetComplexVariable(CV_NewUserAlerts) & ")</option>"
  sTypeDropDown = sTypeDropDown & "</select>"
  dictEnvironment.add "U-FORMACTION", sBBSForumRoot & "/alert-list.asp"
  dictEnvironment.add "V-TYPEDROPDOWN", sTypeDropDown

if iAlertType > -1 then
  ' Get list of this type of alert
  vAlerts = Alerts.GetAlertList(iAlertType)

  ' Generate output of alerts
  if ubound(vAlerts) = -1 then
    dictEnvironment.add "C-HASALERTS", 0
  else
    dictEnvironment.add "C-HASALERTS", 1
    for index = 0 to ubound(vAlerts)
      vAlertInfo = Alerts.GetAlertInfo(vAlerts(index))
      vUserInfo = BBS.GetUserInfoByID(vAlertInfo(AL_MemberID))
      dictEnvironment.item("V-ALERTINFO") = vAlertInfo
      dictEnvironment.item("V-USERINFO") = vUserInfo

      if dictEnvironment.item("V-ALERTTYPE") = "MESSAGE" then
        vMessageInfo = Forum.GetMessageInfo(vAlertInfo(AL_MessageID))
        vThreadInfo  = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
        vForumInfo   = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
        dictEnvironment.item("V-MESSAGEINFO") = vMessageInfo
        dictEnvironment.item("V-THREADINFO") = vThreadInfo
        dictEnvironment.item("V-FORUMINFO") = vForumInfo

        ' Username
        if vMessageInfo(MI_IsRegistered) = 1 and vMessageInfo(MI_Anonymous) = 0 then
          dictEnvironment.item("V-USERNAME") = BBS.CreateUsernameLinkbyID(vMessageInfo(MI_MemberID)) & BBS.ValidateField(BBS.GetUsername(vMessageInfo(MI_MemberID))) & "</a>"
        elseif vMessageInfo(MI_IsRegistered) = 0 and vMessageInfo(MI_Anonymous) = 0 then
          dictEnvironment.item("V-USERNAME") = "<span class='notregisteredname'>" & BBS.ValidateField(vMessageInfo(MI_GuestName)) & "</span>"
        elseif vMessageInfo(MI_Anonymous) = 1 then
          dictEnvironment.item("V-USERNAME") = "<span class='notregisteredname'>" & dictLanguage("GLOBAL-ANONYMOUS") & "</span>"
          if iForumUserLevel >= USERLEVEL_ModuleAdministrator then dictEnvironment.item("V-USERNAME") = dictEnvironment.item("V-USERNAME") & "<br/><span class='notregisteredname'>(" & BBS.ValidateField(BBS.GetUsername(vMessageInfo(MI_MemberID))) & ")</span>"
        end if

      else
        dictEnvironment.item("V-USERNAME") = BBS.CreateUsernameLinkByID(vUserInfo(UI_MemberID)) & BBS.ValidateField(vUserInfo(UI_Username)) & "</a>"
      end if

      if dictEnvironment.item("V-ALERTTYPE") = "USER" then
        vbString.Append "<tr><td class='messagecellbody'>" & dictEnvironment.item("V-USERNAME") & "</td>"
        vbString.Append "<td class='messagecellbody'>" & BBS.ValidateField(dictEnvironment.item("V-USERINFO")(UI_EmailAddr)) & "</td>"
        vbString.Append "<td class='messagecellbody'>" & BBS.ValidateField(dictEnvironment.item("V-USERINFO")(UI_RealName)) & "</td>"
        vbString.Append "<td class='messagecellbody'>" & BBS.ValidateField(dictEnvironment.item("V-USERINFO")(UI_Location)) & "</td>"
        vbString.Append "<td class='messagecellbody'>" & BBS.GetShortDateTime(dictEnvironment.item("V-USERINFO")(UI_dateregistered)) & "</td>"
        vbString.Append "<td class='messagecellbody'><a href='" & sBBSForumRoot & "/alert-view.asp?id=" & dictEnvironment.item("V-ALERTINFO")(AL_AlertID) & "'>" & dictLanguage.item("ALERT-LIST-11") & "</a></td></tr>"

      elseif dictEnvironment.item("V-ALERTTYPE") = "MESSAGE" then

        if BBS.CanApprovePosts(vForumInfo(FI_ForumID)) then
          vbString.Append "<tr><td class='messagecellbody'>" & BBS.ValidateField(dictEnvironment.item("V-MESSAGEINFO")(MI_Subject)) & "</td>"
          vbString.Append "<td class='messagecellbody'>" & dictEnvironment.item("V-USERNAME") & "</td>"
          vbString.Append "<td class='messagecellbody'><a href='" & sBBSForumRoot & "/forums/thread-view.asp?tid=" & dictEnvironment.item("V-THREADINFO")(TI_ThreadID) & "'>" & BBS.ValidateField(dictEnvironment.item("V-THREADINFO")(TI_Subject)) & "</a></td>"
          vbString.Append "<td class='messagecellbody'><a href='" & sBBSForumRoot & "/forums/forum-view.asp?fid=" & dictEnvironment.item("V-FORUMINFO")(FI_ForumID) & "'>" & BBS.ValidateField(dictEnvironment.item("V-FORUMINFO")(FI_ForumName)) & "</a></td>"
          vbString.Append "<td class='messagecellbody'>" & BBS.GetShortDateTime(dictEnvironment.item("V-MESSAGEINFO")(MI_DatePosted)) & "</td>"
          vbString.Append "<td class='messagecellbody'><a href='" & sBBSForumRoot & "/alert-view.asp?id=" & dictEnvironment.item("V-ALERTINFO")(AL_AlertID) & "'>" & dictLanguage.item("ALERT-LIST-11") & "</a></td></tr>"
        else
          vbString.Append "<tr><td class='messagecellbody' colspan='3'>" & dictLanguage("ALERT-NOACCESS") & "..</td>"
          vbString.Append "<td class='messagecellbody'><a href='" & sBBSForumRoot & "/forums/forum-view.asp?fid=" & dictEnvironment.item("V-FORUMINFO")(FI_ForumID) & "'>" & BBS.ValidateField(dictEnvironment.item("V-FORUMINFO")(FI_ForumName)) & "</a></td>"
          vbString.Append "<td class='messagecellbody'>" & BBS.GetShortDateTime(dictEnvironment.item("V-MESSAGEINFO")(MI_DatePosted)) & "</td>"
          vbString.Append "<td class='messagecellbody'></td></tr>"

        end if
      end if

    next
  end if

  ' Store output
  dictEnvironment.add "V-ALERTLIST", vbString.ToString()

  ' Title of the alert table
  if iAlertType = ALERT_BadPost then
    dictEnvironment.add "V-TABLETITLE", dictLanguage.item("GLOBAL-BADPOSTALERT")
  elseif iAlertType = ALERT_NewPost then
    dictEnvironment.add "V-TABLETITLE", dictLanguage.item("GLOBAL-NEWPOSTALERT")
  else
    dictEnvironment.add "V-TABLETITLE", dictLanguage.item("GLOBAL-NEWUSERALERT")
  end if
end if

dictEnvironment.add "V-TITLE", dictLanguage.item("ALERT-LIST-TITLE")
dictEnvironment.add "C-SHOWRANDOMQUOTES", dictConfiguration("bDISPLAYBBSQUOTES")
if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1
%>
<!-- #include file="includes/header.asp"-->
<%Filesystem.ExecuteBBSTemplate("/alert-list.asp")%>
<!-- #include file="includes/footer.asp"-->