<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="includes/include.asp"-->
<!-- #include file="includes/include-alerts.asp"-->
<!-- #include file="includes/include-forums.asp"-->
<!-- #include file="includes/include-polls.asp"-->
<%
  sBBSLangPage = "alert-view"
  BBS.SetupBBS()
  BBS.SetScheme(0)

  dim vAlert, iAlertMemberLevel, vMessageInfo, vForumInfo, vThreadInfo, vUserInfo

  ' Get the alert
  vAlert = Alerts.GetAlertInfo(request.querystring("id"))
  if vAlert(AL_AlertID) = -1 then response.redirect sBBSForumRoot & "/alert-list.asp"
  vMessageInfo = Forum.GetMessageInfo(vAlert(AL_MessageID))
  vThreadInfo  = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
  vForumInfo   = Forum.GetForumInfo(vThreadInfo(TI_ForumID))

  if iBBSUserLevel >= USERLEVEL_SupportAdministrator then
    iAlertMemberLevel = USERLEVEL_SupportAdministrator
  else
    ' Is the alert a type of message? Does the user have access to this forum?
    iAlertMemberLevel = BBS.GetUserLevel(MODULE_Forums, vForumInfo(FI_ForumID))
  end if

  ' Check permissions to view this alert and generate the actions list
  if vAlert(AL_Type) = ALERT_BadPost then
    if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    dictEnvironment.add "V-ACTIONLINKS", "<a href='" & sBBSForumRoot & "/alert-approve.asp?id=" & vAlert(AL_AlertID) & "'>" & dictLanguage.item("ALERT-VIEW-2") & "</a><br/>"
    dictEnvironment.item("V-ACTIONLINKS") = dictEnvironment.item("V-ACTIONLINKS") & "<a href='" & sBBSForumRoot & "/forums/message-delete.asp?mid=" & vAlert(AL_MessageID) & "'>" & dictLanguage.item("ALERT-VIEW-3") & "</a><br/>"

  elseif vAlert(AL_Type) = ALERT_NewPost then
    if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    if dictConfiguration.item("bLETMODERATORSAPPROVEPOSTS") = 0 and iBBSUserLevel = USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    if dictConfiguration.item("bFORCEPOSTVALIDATION") = 0 then response.redirect sBBSForumRoot & "/category-view.asp"
    dictEnvironment.add "V-ACTIONLINKS", "<a href='" & sBBSForumRoot & "/forums/message-approve.asp?mid=" & vAlert(AL_MessageID) & "'>" & dictLanguage.item("ALERT-VIEW-2") & "</a><br/>"
    dictEnvironment.item("V-ACTIONLINKS") = dictEnvironment.item("V-ACTIONLINKS") & "<a href='" & sBBSForumRoot & "/forums/message-delete.asp?mid=" & vAlert(AL_MessageID) & "'>" & dictLanguage.item("ALERT-VIEW-3") & "</a><br/>"

  elseif vAlert(AL_Type) = ALERT_NewUser then
    if not(BBS.HasPermission(PERM_admineditusers,-1)) then response.redirect sBBSForumRoot & "/logon.asp?error=admin"
    dictEnvironment.add "V-ACTIONLINKS", "<a href='" & sBBSForumRoot & "/admin/user-maintenance.asp?active=false&username=" & BBS.ValidateURL(BBS.GetUsername(vAlert(AL_MemberID))) & "'>" & dictLanguage.item("ALERT-VIEW-4") & "</a><br/>"

  end if

  ' If needed, generate the initial message
  if vAlert(AL_Type) = ALERT_BadPost or vAlert(AL_Type) = ALERT_NewPost then

    vUserInfo    = BBS.GetUserInfo(iBBSMemberID)

    if not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) then response.redirect "alert-list.asp"

      dictEnvironment.add "C-SHOWINITIALMESSAGE", 1
      dictEnvironment.add "V-INITIALMESSAGE", Forum.GenerateMessage(vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1)

    ' If this is the first post in a poll thread, show the poll also
    if vThreadInfo(TI_HasPoll) = 1 and vMessageInfo(MI_InReplyTo) = -1 then
      dictEnvironment.add "C-SHOWPOLL", 1
      dictEnvironment.add "V-POLL", Polls.GeneratePoll(vThreadInfo(TI_PollID), sBBSCompleteURL)
    else
      dictEnvironment.add "C-SHOWPOLL", 0
    end if
  else
    dictEnvironment.add "C-SHOWINITIALMESSAGE", 0
    dictEnvironment.add "C-SHOWPOLL", 0
  end if

  ' Store alert details and link back to alert list
  dictEnvironment.add "V-ALERTDETAILS", Alerts.GenerateAlertBox(vAlert)
  dictEnvironment.add "V-ALERT", vAlert
  dictEnvironment.add "U-RETURNLINK", sBBSForumRoot & "/alert-list.asp?type=" & vAlert(AL_Type)

  dictEnvironment.add "V-TITLE", dictLanguage.item("ALERT-VIEW-TITLE")
  dictEnvironment.add "C-SHOWRANDOMQUOTES", dictConfiguration("bDISPLAYBBSQUOTES")
  if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1
%>
<!-- #include file="includes/header.asp"-->
<%Filesystem.ExecuteBBSTemplate("/alert-view.asp")%>
<!-- #include file="includes/footer.asp"-->