<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-forums.asp"-->
<!-- #include file="../includes/include-alerts.asp"-->
<!-- #include file="../includes/include-messenger.asp"-->
<% sBBSLangPage = "message-approve"
   BBS.SetupBBS

   dim iMessageID, vMessageInfo, vThreadInfo, vForumInfo, vCategoryInfo, bError, vUserInfo, bDeleteOwn, bDeleteOthers, SQL
   dim iAlertMemberLevel

   iMessageID = Request.QueryString("mid")
   vMessageInfo = Forum.GetMessageInfo(iMessageID)
   vThreadInfo  = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
   vForumInfo   = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
   vCategoryInfo= BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
   vUserInfo    = BBS.GetUserInfobyID(iBBSMemberID)
   BBS.SetScheme(vCategoryInfo(CA_CategoryID))
   bError       = False

   ' Check for access to the forum
   if vThreadInfo(TI_ThreadID) < 1 or vForumInfo(FI_ForumID) < 1 then response.redirect sBBSForumRoot & "/category-view.asp"
   if not(BBS.HasPermission(PERM_FORUMACCESS, vForumInfo(FI_ForumID))) then response.redirect sBBSForumRoot & "/restricted-page.asp"


   ' Are we a moderator/admin?
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then
     iAlertMemberLevel = USERLEVEL_SupportAdministrator
   else
     ' Is the user a moderator in any forum at all?
     iAlertMemberLevel = BBS.GetUserLevel(MODULE_Forums, vForumInfo(FI_ForumID))
   end if

   if iAlertMemberLevel < USERLEVEL_Moderator then response.redirect sBBSForumRoot & "/logon.asp?error=admin"

   ' Have we even opted for the message validation queue?
   if dictConfiguration.item("bFORCEPOSTVALIDATION") = 0 then response.redirect sBBSForumRoot & "/forums/thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)

   ' The tests are complete.  Now approve the message, if everything checked out OK
   if request.form("action") = "approve" and bError = False then
     forum.ApproveMessage(vMessageInfo(MI_MessageID))

     ' Delete any new post alerts for this message
     Alerts.DeleteAlertByMessageID ALERT_NewPost, vMessageInfo(MI_MessageID)

     ' Prevent any bad post alerts being made
     dim vAlert
     vAlert = Alerts.GetAlertInfoStruct()
     vAlert(AL_Type)      = ALERT_BadPost
     vAlert(AL_MessageID) = vMessageInfo(MI_MessageID)
     vAlert(AL_MemberID)  = iBBSMemberID
     vAlert(AL_Approved)  = 1
     vAlert(AL_Reported)  = now()
     vAlert(AL_Message)   = dictLanguage.item("MESSAGE-APPROVE4")
     Alerts.CreateAlert(vAlert)

     ' If it's the first message we'll approve the thread as well
     if vMessageInfo(MI_inreplyto) = -1 then
       forum.ApproveThread(vThreadInfo(TI_ThreadID))
     end if

     ' Can we consider this user OK to post, without having to approve each of their messages?
     if request.form("approveuser") = 1 then
       Forum.ApproveMember(vMessageInfo(MI_MemberID))
     end if

	 ' send out notifications
     if vMessageInfo(MI_IsRegistered) = 1 then
       Forum.ProcessNotifications sBBSUsername, 1, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
     else
       Forum.ProcessNotifications BBS.FilterPost(vMessageInfo(MI_GuestName)), 0, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
     end if

     ' Update the lastactive poster for this thread & forum
     Forum.UpdateLastThreadPoster(vThreadInfo(TI_ThreadID))
     Forum.UpdateLastActiveThread(vThreadInfo(TI_ForumID))


     response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_threadid)
   end if


   dictEnvironment.add "V-APPROVEMESSAGE", Forum.GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 0)
   dictEnvironment.add "V-MESSAGEINFO" , vMessageInfo
   dictEnvironment.add "V-FORUMINFO", vForumInfo
   dictEnvironment.add "V-THREADINFO", vThreadInfo
   dictEnvironment.add "V-CATEGORYINFO", vCategoryInfo
   dictEnvironment.add "V-FORMACTION", "approve"
   dictEnvironment.add "U-FORM", "message-approve.asp?mid=" & vMessageInfo(MI_MessageID)
   dictEnvironment.add "V-TITLE", dictLanguage.item("MESSAGE-APPROVE-TITLE")
   dictEnvironment.add "C-SHOWRANDOMQUOTES", vForumInfo(FI_ShowQuotes)
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1
   if (dictConfiguration.item("bLETMODERATORSAPPROVEMEMBERS") = 1 or iAlertMemberLevel >= USERLEVEL_Moderator) and BBS.GetUserInfoByID(vMessageInfo(MI_MemberID))(UI_OKTopost) = 0 and vMessageInfo(MI_MemberID) > 0 then
     ' Display an option to set the user OK to post. People under the Moderator userlevel have been sent away already anyway
     dictEnvironment.add "C-SHOWAPPROVEMEMBER", 1
   else
     dictEnvironment.add "C-SHOWAPPROVEMEMBER", 0
   end if

%>

<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/forum/message-approve.asp") %>
<!-- #include file="../includes/footer.asp" -->

