<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-forums.asp"-->
<% sBBSLangPage = "message-delete"
   BBS.SetupBBS

   dim iMessageID, vMessageInfo, vThreadInfo, vForumInfo, vCategoryInfo, bError, vUserInfo, bDeleteOwn, bDeleteOthers
   dim iEditTime

   iMessageID = Request.QueryString("mid")
   vMessageInfo = Forum.GetMessageInfo(iMessageID)
   vThreadInfo  = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
   vForumInfo   = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
   vCategoryInfo= BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
   vUserInfo    = BBS.GetUserInfobyID(iBBSMemberID)
   BBS.SetScheme(vCategoryInfo(CA_CategoryID))
   bError       = False

   ' Check for access to the forum
   if vThreadInfo(TI_ThreadID) < 1 or vForumInfo(FI_ForumID) < 1 then response.redirect sBBSForumRoot & "/category-view.asp"
   if not(BBS.HasPermission(PERM_FORUMACCESS, vForumInfo(FI_ForumID))) then response.redirect sBBSForumRoot & "/restricted-page.asp"

   ' Does the user have access to delete this message?
   bDeleteOwn = BBS.HasPermission(PERM_forumdeleteown, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) = iBBSMemberID)
   bDeleteOthers = BBS.HasPermission(PERM_forumdeleteothers, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) <> iBBSMemberID)
   if not(bDeleteOwn or bDeleteOthers) then response.redirect "../category-view.asp"

   if vMessageInfo(MI_inreplyto) = -1 then
      dictEnvironment("V-ERRORMESSAGE") = dictLanguage("MESSAGE-DELETE1") & "<br/><br/>" & _
                                          "<a href='thread-delete.asp?tid=" & vThreadInfo(TI_ThreadID) & "'>" & dictLanguage("MESSAGE-DELETE4") & "</a>"
      bError = True
   end if

   iEditTime = BBS.LookupPermission(MODULE_FORUMS, BBS.GetUserlevel(MODULE_Forums, vForumInfo(FI_ForumID)), PERM_forummaxedittime, vForumInfo(FI_ForumID))
   if iEditTime > 0 then
     if DateDiff("n",vMessageInfo(MI_DatePosted), now) > iEditTime then
       dictEnvironment("V-ERRORMESSAGE") = dictEnvironment("V-ERRORMESSAGE") &  dictLanguage("DELETE-TIMELIMIT1") & " " & iEditTime & " " & dictLanguage("DELETE-TIMELIMIT2") & "<br/>"
       bError = True
     end if
   end if


   ' The tests are complete.  Now delete the message, if everything checked out OK
   if request.form("action") = "delete" and bError = False then
     forum.DeleteMessage(vMessageInfo(MI_MessageID))
     Forum.ReindexThread(vMessageInfo(MI_ThreadID))
     ' If the user's been a bad boy, we can unapprove him and run his future posts through the manual validation queue again
     if request.form("unapproveuser") = 1 and (dictConfiguration.item("bLETMODERATORSAPPROVEMEMBERS") = 1 and iBBSUserLevel >= USERLEVEL_Moderator  or iBBSUserLevel = USERLEVEL_GlobalAdministrator) then
       ' Well, he was asking for it
       forum.UnapproveMember(vMessageInfo(MI_MemberID))
     end if
     response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_threadid)
   end if


   dictEnvironment.add "V-DELETEMESSAGE", Forum.GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 0)
   dictEnvironment.add "V-MESSAGEINFO" , vMessageInfo
   dictEnvironment.add "V-FORUMINFO", vForumInfo
   dictEnvironment.add "V-THREADINFO", vThreadInfo
   dictEnvironment.add "V-CATEGORYINFO", vCategoryInfo
   dictEnvironment.add "V-FORMACTION", "delete"
   dictEnvironment.add "U-FORM", "message-delete.asp"

   dictEnvironment.add "V-TITLE", dictLanguage.item("MESSAGE-DELETE-TITLE")
   dictEnvironment.add "C-SHOWRANDOMQUOTES", vForumInfo(FI_ShowQuotes)
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1
   if (dictConfiguration.item("bLETMODERATORSAPPROVEMEMBERS") = 1 and iBBSUserLevel >= USERLEVEL_Moderator  or iBBSUserLevel = USERLEVEL_GlobalAdministrator) and BBS.GetUserInfoByID(vMessageInfo(MI_MemberID))(UI_OKTopost) = 1 then
     ' Display an option to unapprove the user. People under the Moderator userlevel have been sent away already anyway
     dictEnvironment.add "C-SHOWUNAPPROVEMEMBER", 1
   end if


%>

<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/forum/message-delete.asp") %>
<!-- #include file="../includes/footer.asp" -->

