<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-forums.asp"-->
<!-- #include file="../includes/include-messenger.asp"-->
<!-- #include file="../includes/include-alerts.asp"-->
<% sBBSLangPage = "thread-post"
   BBS.SetupBBS

   dim vMessageInfo, vThreadInfo, vForumInfo, sAction, iForumID, iReplyTo, iThreadID, iMessageID, vReplyMessageInfo, iUserLevel, bIsPreview, vCategoryInfo, vUserInfo, SQL, iEditTime
   dim bError, bReplyOwn, bReplyOthers, bEditOwn, bEditOthers, sMessageList, iInReplyTo, bNeedReindex, bChangedGuest, sSpellCheckCode
   dim sRichEdit, bCanPostHTML, vAlertInfo, bEditorChange, sOldBody, sOldEdited, dOldEdited, iInsertOrder

   Messenger.Initialize
   bError        = False
   bNeedReindex  = False
   bChangedGuest = False
   sAction       = request.querystring("action")
   bIsPreview    = BBS.ValidateBoolean(request.form("preview")=dictLanguage("GLOBAL-PREVIEW"))
   bEditorChange = BBS.ValidateBoolean((request.form("editorchange")=dictLanguage("POST-21")) or (request.form("editorchange")=dictLanguage("POST-22")))
   vUserInfo     = BBS.GetUserInfobyID(iBBSMemberID)
   dictEnvironment("V-USER") = vUserInfo

   ' Check for appropriate permissions, setup default values, maybe even post a message.
   if sAction = "writenew" then
     ' Only the ForumID is supplied
     iForumID          = BBS.ValidateNumeric(request.querystring("fid"))
     if not(BBS.HasPermission(PERM_forumnewthread, iForumID)) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     vMessageInfo      = Forum.GetMessageInfoStruct()
     vReplyMessageInfo = Forum.GetMessageInfoStruct()
     vThreadInfo       = Forum.GetThreadInfoStruct()
     vForumInfo        = Forum.GetForumInfo(iForumID)
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))

     ' Set default values
     vMessageInfo(MI_Emoticons)  = vForumInfo(FI_Emoticons)
     vMessageInfo(MI_Anonymous)  = 0
     vMessageInfo(MI_FilterHTML) = not(bCanPostHTML)
     bCanPostHTML = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     if iBBSLogonType >= US_Inactive then
       vMessageInfo(MI_Signature)  = vUserInfo(UI_UseSignature)
     else
       vMessageInfo(MI_Signature)  = 0
     end if

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vUserInfo(UI_UseSignature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = ""
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(BBS.BooleanNot(vUserInfo(UI_UseRichEdit)))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = ""
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(1)

     sAction = "postnew"

   elseif sAction = "reply" then
     ' Only the ReplyTo is supplied
     iReplyTo          = BBS.ValidateNumeric(request.querystring("replyto"))
     vReplyMessageInfo = Forum.GetMessageInfo(iReplyTo)
     vThreadInfo       = Forum.GetThreadInfo(vReplyMessageInfo(MI_ThreadID))
     vForumInfo        = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
     if vCategoryInfo(CA_CategoryID) = -1 then response.redirect "../category-view.asp"
     vMessageInfo      = Forum.GetMessageInfoStruct()
     bCanPostHTML      = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     bReplyOwn = BBS.HasPermission(PERM_forumreplyown, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) = iBBSMemberID)
     bReplyOthers = BBS.HasPermission(PERM_forumreplyothers, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) <> iBBSMemberID)
     if not(bReplyOwn or bReplyOthers) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     if vThreadInfo(TI_Closed) = 1 then
       if not BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then response.redirect sBBSForumRoot & "/forums//thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)
     end if
     if vReplyMessageInfo(MI_MessageID) <= 0 then response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)

     ' Set default values
     vMessageInfo(MI_Emoticons)  = vForumInfo(FI_Emoticons)
     vMessageInfo(MI_Anonymous)  = 0
     vMessageInfo(MI_FilterHTML) = bCanPostHTML

     if iBBSLogonType >= US_Inactive then
       vMessageInfo(MI_Signature)  = vUserInfo(UI_UseSignature)
     else
       vMessageInfo(MI_Signature)  = 0
     end if

     if not(ucase(left(vReplyMessageInfo(MI_Subject), 3)) = "RE:") then
       vMessageInfo(MI_Subject) = left("RE: " & vReplyMessageInfo(MI_Subject), 100)
     else
       vMessageInfo(MI_Subject) = vReplyMessageInfo(MI_Subject)
     end if

     if request.querystring("quote") = "yes" then
       if vReplyMessageInfo(MI_Anonymous) = 1 then
         vMessageInfo(MI_Body) = "[QUOTE]" & dictLanguage("GLOBAL-ANONYMOUS") & " - " & BBS.GetShortDateTime(vReplyMessageInfo(MI_DatePosted)) & CRLF & CRLF & vReplyMessageInfo(MI_Body) & "[/QUOTE]"
       elseif vReplyMessageInfo(MI_IsRegistered) = 1 then
         vMessageInfo(MI_Body) = "[QUOTE]" & BBS.GetUsername(vReplyMessageInfo(MI_MemberID)) & " - " & BBS.GetShortDateTime(vReplyMessageInfo(MI_DatePosted)) & CRLF & CRLF & vReplyMessageInfo(MI_Body) & "[/QUOTE]"
       elseif vReplyMessageInfo(MI_IsRegistered) = 0 then
         vMessageInfo(MI_Body) = "[QUOTE]" & vReplyMessageInfo(MI_GuestName) & " - " & BBS.GetShortDateTime(vReplyMessageInfo(MI_DatePosted)) & CRLF & CRLF & vReplyMessageInfo(MI_Body) & "[/QUOTE]"
       end if
     end if

     sAction = "postreply"

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vUserInfo(UI_UseSignature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = ""
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(BBS.BooleanNot(vUserInfo(UI_UseRichEdit)))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = ""
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(1)
     dictEnvironment("C-ISREPLYING")    = 1

   elseif sAction = "edit" then
     ' Only the MessageID is supplied
     iMessageID        = BBS.ValidateNumeric(request.querystring("mid"))
     vMessageInfo      = Forum.GetMessageInfo(iMessageID)
     vThreadInfo       = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
     vForumInfo        = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
     if vCategoryInfo(CA_CategoryID) = -1 then response.redirect "../category-view.asp"
     vReplyMessageInfo = Forum.GetMessageInfoStruct()
     bCanPostHTML      = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     ' Can the user edit this message?
     bEditOwn          = BBS.HasPermission(PERM_forumeditown, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) = iBBSMemberID)
     bEditOthers       = BBS.HasPermission(PERM_forumeditothers, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) <> iBBSMemberID)
     if not(bEditOwn or bEditOthers) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     if vMessageInfo(MI_MessageID) <= 0 then response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)

     if vThreadInfo(TI_Closed) = 1 then
       if not BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then response.redirect sBBSForumRoot & "/forums//thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)
     end if
     iEditTime = BBS.LookupPermission(MODULE_FORUMS, BBS.GetUserlevel(MODULE_Forums, vForumInfo(FI_ForumID)), PERM_forummaxedittime, vForumInfo(FI_ForumID))
     if iEditTime > 0 then if DateDiff("n",vMessageInfo(MI_DatePosted), now) > iEditTime then dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") &  dictLanguage("POST-18") & " " & iEditTime & " " & dictLanguage("POST-19") & "<br/>"

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vMessageInfo(MI_Signature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = BBS.IsChecked(vMessageInfo(MI_FilterHTML))
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(vMessageInfo(MI_ForceLineBreaks))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Anonymous))
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Emoticons))

     sAction = "postedit"

   elseif sAction = "postnew" then
     ' Only the ForumID is supplied
     iForumID          = BBS.ValidateNumeric(request.form("fid"))
     if not(BBS.HasPermission(PERM_forumnewthread, iForumID)) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     vMessageInfo      = Forum.GetMessageInfoStruct()
     vReplyMessageInfo = Forum.GetMessageInfoStruct()
     vThreadInfo       = Forum.GetThreadInfoStruct()
     vForumInfo        = Forum.GetForumInfo(iForumID)
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
     if vCategoryInfo(CA_CategoryID) = -1 then response.redirect "../category-view.asp"
     bCanPostHTML      = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     if len(trim(request.form("subject"))) = 0 and bEditorChange = 0 then
       bError = True
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDSUBJECT") & "<br/>"
     end if

	   ' check if the user is flooding
	   if Forum.IsFlooding() = 1 then
	     bError = true
	     dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-FLOODING-1") & Forum.GetFloodLimit(iBBSMemberID) & dictLanguage("POST-FLOODING-2")
	   end if

     ' Create the anchor thread
     vThreadInfo(TI_ForumID)      = vForumInfo(FI_ForumID)
     vThreadInfo(TI_TotalPosts)   = 1
     vThreadInfo(TI_DateCreated)  = now
     vThreadInfo(TI_LastActivity) = vThreadInfo(TI_DateCreated)
     vThreadInfo(TI_Subject)      = BBS.FilterPost(request.form("subject"))
     if (vForumInfo(FI_AnonymousAllowed) = 1) and (request.form("anonymous") = "1") and (iBBSLogonType >= US_Inactive) then
       vThreadInfo(TI_Anonymous)  = 1
     else
       vThreadInfo(TI_Anonymous)  = 0
     end if
     vThreadInfo(TI_TimesViewed)  = 0
     if BBS.HasPermission(PERM_forumsticky, vForumInfo(FI_ForumID)) then
       vThreadInfo(TI_Sticky)     = request.form("sticky")
     else
       vThreadInfo(TI_Sticky)     = 0
     end if
     if BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then
       vThreadInfo(TI_Closed)     = request.form("freeze")
     else
       vThreadInfo(TI_Closed)     = 0
     end if
     vThreadInfo(TI_HasPoll)      = 0
     vThreadInfo(TI_HasAttachment)= 0
     vThreadInfo(TI_LastPosterAnonymous)    = vThreadInfo(TI_Anonymous)
     vThreadInfo(TI_LastPosterMemberID)     = iBBSMemberID
     vThreadInfo(TI_LastPosterIsRegistered) = BBS.ValidateBoolean(iBBSMemberID > -1)
     vThreadInfo(TI_LastPosterGuestName)    = left(trim(BBS.FilterPost(request.form("guestname"))), 20)
     vThreadInfo(TI_MemberID)     = iBBSMemberID
     vThreadInfo(TI_IsRegistered) = vThreadInfo(TI_LastPosterIsRegistered)
     vThreadInfo(TI_GuestName)    = left(trim(BBS.FilterPost(request.form("guestname"))), 20)
     if len(trim(vThreadInfo(TI_GuestName))) = 0 then vThreadInfo(TI_GuestName) = dictLanguage("GLOBAL-GUEST")
     if iBBSMemberID > 0 then
       vThreadInfo(TI_GuestName) = (sBBSUserName)
       vThreadInfo(TI_LastPosterGuestName) = (sBBSUserName)
     end if

     vThreadInfo(TI_Approved) = BBS.validateBoolean(vUserInfo(UI_OkToPost)=1 or iBBSUserLevel >= USERLEVEL_SupportAdministrator or dictConfiguration("bFORCEPOSTVALIDATION") = 0)

     ' Create the message
     vMessageInfo(MI_InReplyTo) = -1
     vMessageInfo(MI_Subject)   = vThreadInfo(TI_Subject)
     vMessageInfo(MI_Body)      = BBS.FilterPost(request.form("messagebody"))

     if (len(trim(vMessageInfo(MI_Body))) = 0 or trim(vMessageInfo(MI_Body)) = "<br />" & CRLF) and bEditorChange = 0 then
       bError = True
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDBODY") & "<br/>"
     end if

     if BBS.ValidateBoolean(request.form("filtercrlf")) = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "")
     elseif BBS.ValidateBoolean(request.form("filtercrlf")) = 0 and bEditorChange = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "<br />")
     end if

     if not(bCanPostHTML) or (request.form("disablehtml") = 1) then
       vMessageInfo(MI_FilterHTML) = 1
     else
       vMessageInfo(MI_FilterHTML) = 0
     end if
     vMessageInfo(MI_Hostname)    = request.servervariables("REMOTE_HOST")
     vMessageInfo(MI_Anonymous)   = vThreadInfo(TI_Anonymous)
     vMessageInfo(MI_DatePosted)  = vThreadInfo(TI_DateCreated)
     vMessageInfo(MI_MessageIcon) = -1
     vMessageInfo(MI_Emoticons) = request.form("emoticons")
     vMessageInfo(MI_ReplyOrder)  = 1
     vMessageInfo(MI_ReplyLevel)  = 0
     if (iBBSMemberID > 0) then
       vMessageInfo(MI_Signature) = request.form("signature")
     else
       vMessageInfo(MI_Signature) = 0
     end if
     vMessageInfo(MI_LastEditedName) = " "
     vMessageInfo(MI_LastEditedDate) = vThreadInfo(TI_DateCreated)
     vMessageInfo(MI_Edited)         = 0
     vMessageInfo(MI_HasAttachment)  = 0
     vMessageInfo(MI_IsRegistered)   = BBS.ValidateBoolean(iBBSMemberID > -1)
     vMessageInfo(MI_MemberID)       = iBBSMemberID
     vMessageInfo(MI_GuestName)      = vThreadInfo(TI_Guestname)
     vMessageInfo(MI_ForceLineBreaks)= request.form("forcelinebreaks")
     vMessageInfo(MI_Approved) = BBS.validateBoolean(vUserInfo(UI_OkToPost)=1 or iBBSUserLevel >= USERLEVEL_SupportAdministrator or dictConfiguration("bFORCEPOSTVALIDATION") = 0)

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vMessageInfo(MI_Signature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = BBS.IsChecked(vMessageInfo(MI_FilterHTML))
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(vMessageInfo(MI_ForceLineBreaks))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Anonymous))
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Emoticons))

     if bIsPreview = 0 and bEditorChange = 0 and bError = False then

       ' Create the thread and get the newly created Thread ID
       vThreadInfo(TI_ThreadID) = Forum.CreateThread(vThreadInfo)
       vMessageInfo(MI_ThreadID) = vThreadInfo(TI_ThreadID)
       vMessageInfo(MI_MessageID) = Forum.CreateMessage(vMessageInfo)

       ' If not approved, add alert about it
       if vMessageInfo(MI_Approved) = 0 then
         vAlertInfo = Alerts.GetAlertInfoStruct()
         vAlertInfo(AL_Type)      = ALERT_NewPost
         vAlertInfo(AL_MessageID) = vMessageInfo(MI_MessageID)
         vAlertInfo(AL_MemberID)  = iBBSMemberID
         vAlertInfo(AL_Approved)  = 0
         vAlertInfo(AL_Reported)  = now()
         Alerts.CreateAlert(vAlertInfo)
       end if

       ' Update the seed & last post
       SQL = "update threads set lastpostid=" & vMessageInfo(MI_MessageID) & ", seed=" & vMessageInfo(MI_MessageID) & " where threadid=" & vThreadInfo(TI_ThreadID)
       dbConnection.execute SQL

       ' Update lastactive thread, postcounts, threadcounts in the forum object.
       ' Normally we would just use Forum.UpdateLastActiveThread, but speed is critical here
       ' Let's only do this if the post is validated.
       if vMessageInfo(MI_Approved) = 1 then
         SQL = "update forums set lastactivethread=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID)) & ", threadcount=threadcount+1, postcount=postcount+1 where forumid=" & vForumInfo(FI_ForumID)
         dbConnection.execute SQL,, adTextNoRecords
         BBS.AddQuery(SQL)
       else
         SQL = "update forums set threadcount=threadcount+1, postcount=postcount+1 where forumid=" & vForumInfo(FI_ForumID)
         dbConnection.execute SQL,, adTextNoRecords
         BBS.AddQuery(SQL)
       end if
       BBS.CacheDelete "FI-" & vForumInfo(FI_ForumID)

       if iBBSMemberID > -1 then Forum.OffsetUserPostcount iBBSMemberID, 1

       if vUserInfo(UI_EmailNotifications) = "email" or (vUserInfo(UI_EmailNotifications) = "default" and dictConfiguration("bSENDNOTIFYDEFAULT") = 1) then Forum.SetNotification iBBSMemberID, vThreadInfo(TI_ThreadID), "email"

	     ' if the message is approved, send out notifications
	     if vMessageInfo(MI_Approved) = 1 then
           if vMessageInfo(MI_IsRegistered) = 1 then
             Forum.ProcessNotifications sBBSUsername, 1, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
           else
             Forum.ProcessNotifications BBS.FilterPost(vMessageInfo(MI_GuestName)), 0, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
           end if
	     end if

       if request.form("attach") = "1" then
         response.redirect "attach-file.asp?mid=" & vMessageInfo(MI_MessageID)
       elseif vMessageInfo(MI_Approved) = 0 then
         response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & vThreadInfo(TI_ThreadID) & "&note=approve"
       else
         response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & vThreadInfo(TI_ThreadID)
       end if
     end if

   elseif sAction = "postreply" then

     ' Only the ReplyTo is supplied
     iReplyTo          = request.form("replyto")
     vReplyMessageInfo = Forum.GetMessageInfo(iReplyTo)
     vThreadInfo       = Forum.GetThreadInfo(vReplyMessageInfo(MI_ThreadID))
     vForumInfo        = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
     if vCategoryInfo(CA_CategoryID) = -1 then response.redirect "../category-view.asp"
     vMessageInfo      = Forum.GetMessageInfoStruct()
     bCanPostHTML      = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     bReplyOwn = BBS.HasPermission(PERM_forumreplyown, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) = iBBSMemberID)
     bReplyOthers = BBS.HasPermission(PERM_forumreplyothers, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) <> iBBSMemberID)
     if not(bReplyOwn or bReplyOthers) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     if vReplyMessageInfo(MI_MessageID) <= 0 then response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)

     if vThreadInfo(TI_Closed) = 1 then
       if not BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then response.redirect sBBSForumRoot & "/forums/thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)
     end if

     if len(trim(request.form("subject"))) = 0 and bEditorChange = 0 then
       bError = True
       dictEnvironment("V-ERROR") =  dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDSUBJECT") & "<br/>"
     end if

	   ' check if the user is flooding
	   if Forum.IsFlooding() = 1 then
	     bError = true
	     dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-FLOODING-1") & Forum.GetFloodLimit(iBBSMemberID) & dictLanguage("POST-FLOODING-2")
	   end if

     ' Create the thread and get the newly created Thread ID
     vMessageInfo(MI_ThreadID) = vThreadInfo(TI_ThreadID)

     ' Create the message
     vMessageInfo(MI_InReplyTo) = vReplyMessageInfo(MI_MessageID)
     vMessageInfo(MI_Subject)   = BBS.FilterPost(request.form("subject"))
     vMessageInfo(MI_Body) = BBS.FilterPost(request.form("messagebody"))

     if (len(trim(vMessageInfo(MI_Body))) = 0 or trim(vMessageInfo(MI_Body)) = "<br />" & CRLF) and bEditorChange = 0 then
       bError = True
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDBODY") & "<br/>"
     end if

     if BBS.ValidateBoolean(request.form("filtercrlf")) = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "")
     elseif BBS.ValidateBoolean(request.form("filtercrlf")) = 0 and bEditorChange = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "<br />")
     end if

     if not(bCanPostHTML) or (request.form("disablehtml") = 1) then
       vMessageInfo(MI_FilterHTML) = 1
     else
       vMessageInfo(MI_FilterHTML) = 0
     end if
     vMessageInfo(MI_Hostname) = request.servervariables("REMOTE_HOST")
     if (vForumInfo(FI_AnonymousAllowed) = 1) and (request.form("anonymous") = "1") and (iBBSLogonType >= US_Inactive) then
       vMessageInfo(MI_Anonymous) = 1
     else
       vMessageInfo(MI_Anonymous) = 0
     end if
     vMessageInfo(MI_DatePosted) = Now
     vMessageInfo(MI_MessageIcon) = -1
     vMessageInfo(MI_Emoticons) = request.form("emoticons")
     vMessageInfo(MI_ReplyOrder) = 0
     vMessageInfo(MI_ReplyLevel) = vReplyMessageInfo(MI_ReplyLevel)+1
     if (iBBSMemberID > -1) then
       vMessageInfo(MI_Signature)  = request.form("signature")
     else
       vMessageInfo(MI_Signature)  = 0
     end if
     vMessageInfo(MI_LastEditedName) = " "
     vMessageInfo(MI_LastEditedDate) = vMessageInfo(MI_DatePosted)
     vMessageInfo(MI_Edited) = 0
     vMessageInfo(MI_HasAttachment) = 0
     vMessageInfo(MI_IsRegistered) = BBS.ValidateBoolean(iBBSMemberID > -1)
     vMessageInfo(MI_MemberID) = iBBSMemberID
     vMessageInfo(MI_GuestName) = left(trim(request.form("guestname")), 20)
     if len(trim(vMessageInfo(MI_Guestname))) = 0 then vMessageInfo(MI_Guestname) = dictLanguage("GLOBAL-GUEST")
     if iBBSMemberID > 0 then vMessageInfo(MI_Guestname) = sBBSUsername

     vMessageInfo(MI_ForceLineBreaks)= request.form("forcelinebreaks")

     vMessageInfo(MI_Approved) = BBS.validateBoolean(vUserInfo(UI_OkToPost)=1 or iBBSUserLevel >= USERLEVEL_SupportAdministrator or dictConfiguration("bFORCEPOSTVALIDATION") = 0)

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vMessageInfo(MI_Signature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = BBS.IsChecked(vMessageInfo(MI_FilterHTML))
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(vMessageInfo(MI_ForceLineBreaks))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Anonymous))
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Emoticons))
     dictEnvironment("C-ISREPLYING")    = 1

     if bIsPreview = 0 and bEditorChange = 0 and bError = False then

       ' Insert the message into the reply order
       iInsertOrder = vReplyMessageInfo(MI_ReplyOrder)
       Forum.GetMaxReplyOrder vThreadInfo(TI_ThreadID), vReplyMessageInfo(MI_MessageID), iInsertOrder

       ' Insert after that point
       iInsertOrder = iInsertOrder + 1

       ' Offset all the messages in the way
       SQL = "update messages set replyorder=replyorder+1 where replyorder>=" & iInsertOrder & " and threadid=" & vMessageInfo(MI_ThreadID)
       BBS.AddQuery(SQL)
       dbConnection.execute SQL,, adTextNoRecords

       ' Now create the message
       vMessageInfo(MI_ReplyOrder) = iInsertOrder
       vMessageInfo(MI_MessageID) = Forum.CreateMessage(vMessageInfo)

       ' If not approved, add alert about it
       if vMessageInfo(MI_Approved) = 0 then
         vAlertInfo = Alerts.GetAlertInfoStruct()
         vAlertInfo(AL_Type)      = ALERT_NewPost
         vAlertInfo(AL_MessageID) = vMessageInfo(MI_MessageID)
         vAlertInfo(AL_MemberID)  = iBBSMemberID
         vAlertInfo(AL_Approved)  = 0
         vAlertInfo(AL_Reported)  = now()
         Alerts.CreateAlert(vAlertInfo)
       end if

       ' Update the seed & last post
       ' Let's only do this if the post is validated.
       if vMessageInfo(MI_Approved) = 1 then
           SQL = "update threads set lastpostid=" & vMessageInfo(MI_MessageID) & " where threadid=" & vThreadInfo(TI_ThreadID)
           dbConnection.execute SQL
           BBS.CacheDelete "TI-" & vThreadInfo(TI_ThreadID)

           ' Update lastactive thread, postcounts
           ' Normally we would use Forum.UpdateLastActiveThread, Forum.OffsetForumPostCount
           SQL = "update forums set lastactivethread=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID)) & ", postcount=postcount+1 where forumid=" & vForumInfo(FI_ForumID)
           dbConnection.execute SQL,, adTextNoRecords
           BBS.AddQuery(SQL)
       else
           ' Update forum postcounts
           SQL = "update forums set postcount=postcount+1 where forumid=" & vForumInfo(FI_ForumID)
           dbConnection.execute SQL,, adTextNoRecords
           BBS.AddQuery(SQL)
       end if

       BBS.CacheDelete "FI-" & vForumInfo(FI_ForumID)

       if iBBSMemberID > -1 then Forum.OffsetUserPostcount iBBSMemberID, 1

       ' Forum.ReindexThread vThreadInfo(TI_ThreadID)

       ' Update thread lastposter, totalposts fields
       ' Normally we would use Forum.UpdateLastThreadPoster and Forum.OffsetThreadPostCount, but speed is critical here
       if vMessageInfo(MI_Approved) = 1 then
         SQL = "update threads set lastactivity=" & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter & ", lastpostermemberid=" & BBS.ValidateNumeric(vMessageInfo(MI_MemberID)) & ",  lastposterguestname='" & BBS.SQLTrim(vMessageInfo(MI_Guestname),20) & "'"
         SQL = SQL & ", lastposteranonymous=" & BBS.ValidateNumeric(vMessageInfo(MI_Anonymous)) & ", lastposterisregistered=" & BBS.ValidateNumeric(vMessageInfo(MI_IsRegistered))
         SQL = SQL & ", totalposts=totalposts+1 where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
         dbConnection.execute SQL,, adTextNoRecords
         BBS.AddQuery(SQL)
         BBS.CacheDelete "TI-" & vThreadInfo(TI_ThreadID)
       else
         SQL = "update threads set totalposts=totalposts+1 where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
         dbConnection.execute SQL,, adTextNoRecords
         BBS.AddQuery(SQL)
         BBS.CacheDelete "TI-" & vThreadInfo(TI_ThreadID)
       end if

       if vUserInfo(UI_EmailNotifications) = "email" or (vUserInfo(UI_EmailNotifications) = "default" and dictConfiguration("bSENDNOTIFYDEFAULT") = 1) then Forum.SetNotification iBBSMemberID, vThreadInfo(TI_ThreadID), "email"

	   ' if the message is approved, send out notifications
	   if vMessageInfo(MI_Approved) = 1 then
         if vMessageInfo(MI_IsRegistered) = 1 then
           Forum.ProcessNotifications sBBSUsername, 1, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
         else
           Forum.ProcessNotifications vMessageInfo(MI_GuestName), 0, vThreadInfo(TI_ThreadID), vMessageInfo(MI_Body)
         end if
	   end if

       if request.form("attach") = "1" then
         response.redirect "attach-file.asp?mid=" & vMessageInfo(MI_MessageID)
       elseif vMessageInfo(MI_Approved) = 0 then
         response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & vThreadInfo(TI_ThreadID) & "&note=approve"
       else
         response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & vThreadInfo(TI_ThreadID)
       end if
     end if

   elseif sAction = "postedit" then

     ' Only the MessageID is supplied
     iMessageID        = request.form("mid")
     vMessageInfo      = Forum.GetMessageInfo(iMessageID)
     vThreadInfo       = Forum.GetThreadInfo(vMessageInfo(MI_ThreadID))
     vForumInfo        = Forum.GetForumInfo(vThreadInfo(TI_ForumID))
     vCategoryInfo     = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
     if vCategoryInfo(CA_CategoryID) = -1 then response.redirect "../category-view.asp"
     vReplyMessageInfo = Forum.GetMessageInfoStruct()
     bCanPostHTML      = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

     ' Can the user edit this message?
     bEditOwn          = BBS.HasPermission(PERM_forumeditown, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) = iBBSMemberID)
     bEditOthers       = BBS.HasPermission(PERM_forumeditothers, vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) <> iBBSMemberID)
     if not(bEditOwn or bEditOthers) then response.redirect sBBSForumRoot & "/forums/forum-view.asp?fid=" & iForumID
     if vMessageInfo(MI_MessageID) <= 0 then response.redirect "thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)

     if vThreadInfo(TI_Closed) = 1 then
       if not BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then response.redirect sBBSForumRoot & "/forums//thread-view.asp?tid=" & vThreadInfo(TI_ThreadID)
     end if

     iEditTime = BBS.LookupPermission(MODULE_FORUMS, BBS.GetUserlevel(MODULE_Forums, vForumInfo(FI_ForumID)), PERM_forummaxedittime, vForumInfo(FI_ForumID))
     if iEditTime > 0 then
       if DateDiff("n",vMessageInfo(MI_DatePosted), now) > iEditTime then
         dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") &  dictLanguage("POST-18") & " " & iEditTime & " " & dictLanguage("POST-19") & "<br/>"
         bError = True
       end if
     end if

     if len(trim(request.form("subject"))) = 0 and bEditorChange = 0 then
       bError = True
       dictEnvironment("V-ERROR") =  dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDSUBJECT") & "<br/>"
     end if

     ' only update if there weren't any errors in pre-authorization
     if bError = False then

       ' Capture the old body and previous editor for post revisioning (if enabled)
       sOldBody = vMessageInfo(MI_Body)
       if vMessageInfo(MI_LastEditedDate) > vMessageInfo(MI_DatePosted) then
         ' Message has been edited previously
         sOldEdited = vMessageInfo(MI_LastEditedName)
         dOldEdited = vMessageInfo(MI_LastEditedDate)
       else
         ' Message has no previous revisions
         dOldEdited = vMessageInfo(MI_DatePosted)

         ' Capture the original message author
         if vMessageInfo(MI_IsRegistered) > 0 then
           sOldEdited = BBS.GetUserInfoByID(vMessageInfo(MI_MemberID))(UI_Username)

         else
           sOldEdited = vMessageInfo(MI_GuestName)
         end if
       end if

       ' Update the message
       vMessageInfo(MI_Subject) = BBS.FilterPost(request.form("subject"))
       vMessageInfo(MI_Body) = BBS.FilterPost(request.form("messagebody"))

       if (len(trim(vMessageInfo(MI_Body))) = 0 or trim(vMessageInfo(MI_Body)) = "<br />" & CRLF) and bEditorChange = 0 then
         bError = True
         dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-NEEDBODY") & "<br/>"
       end if

       if BBS.ValidateBoolean(request.form("filtercrlf")) = 1 then
         vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "")
       elseif BBS.ValidateBoolean(request.form("filtercrlf")) = 0 and bEditorChange = 1 then
         vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "<br />")
       end if

       if not(bCanPostHTML) or (request.form("disablehtml") = 1) then
         vMessageInfo(MI_FilterHTML) = 1
       else
         vMessageInfo(MI_FilterHTML) = 0
       end if
       if (vForumInfo(FI_AnonymousAllowed) = 1) and (request.form("anonymous") = "1") and (iBBSLogonType >= US_Inactive) then
         vMessageInfo(MI_Anonymous) = 1
       else
         vMessageInfo(MI_Anonymous) = 0
       end if
       vMessageInfo(MI_Emoticons) = request.form("emoticons")
       if (iBBSMemberID > -1) then
         vMessageInfo(MI_Signature)  = request.form("signature")
       else
         vMessageInfo(MI_Signature)  = 0
       end if
       if vMessageInfo(MI_Anonymous) = 1 then
         vMessageInfo(MI_LastEditedName) = dictLanguage("GLOBAL-ANONYMOUS")
       else
         vMessageInfo(MI_LastEditedName) = sBBSUserName
       end if
       vMessageInfo(MI_LastEditedDate) = Now
       vMessageInfo(MI_Edited) = BBS.ValidateBoolean(Not(BBS.HasPermission(PERM_forumhideedittag, vForumInfo(FI_ForumID))))
       vMessageInfo(MI_ForceLineBreaks)= request.form("forcelinebreaks")

       if ((dictConfiguration("bENABLEPOSTREVISIONING") = 1) and (bFeaturesUnlocked = 1)) then vMessageInfo(MI_HasRevisions) = vMessageInfo(MI_HasRevisions) + 1

       if BBS.HasPermission(PERM_modeditmessagedetails, iForumID) and vMessageInfo(MI_IsRegistered) = 0 then
         vMessageInfo(MI_GuestName) = left(trim(request.form("guestname")), 20)
         bChangedGuest = True
       end if

       if BBS.HasPermission(PERM_modmovemessages, iForumID) and vMessageInfo(MI_InReplyTo) > 0 then
         iInreplyTo = BBS.ValidateNumeric(request.form("inreplyto"))
         ' Perform some validation checking on this move
         if Forum.GetMessageInfo(iInReplyTo)(MI_ThreadID) = vThreadInfo(TI_ThreadID) then
           vMessageInfo(MI_InReplyTo) = iInReplyTo
           bNeedReindex = True
         end if
       end if


       dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vMessageInfo(MI_Signature))
       dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = BBS.IsChecked(vMessageInfo(MI_FilterHTML))
       dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(vMessageInfo(MI_ForceLineBreaks))
       dictEnvironment("C-SHOWANONYMOUSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Anonymous))
       dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(vMessageInfo(MI_Emoticons))

       if bIsPreview = 0 and bEditorChange = 0 and bError = False then
         Forum.UpdateMessage(vMessageInfo)

         ' Update thread lastposter, totalposts, possibly also the subject fields
         Forum.UpdateLastThreadPoster(vThreadInfo(TI_ThreadID))
         if bNeedReindex then Forum.reIndexThread(vThreadInfo(TI_ThreadID))

         ' Update the thread subject if we're editing the root message
         if vMessageInfo(MI_InReplyTo) = -1 then
           SQL = "update threads set threadsubject='" & BBS.SQLTrim(BBS.FilterPost(vMessageInfo(MI_Subject)), 100) & "' where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
           dbConnection.execute SQL,, adTextNoRecords
           BBS.AddQuery(SQL)
           BBS.CacheDelete("TI-" & vThreadInfo(TI_ThreadID))
         end if

         if bChangedGuest = True and vMessageInfo(MI_InReplyTo) = -1 then
           SQL = "update threads set guestname='" & BBS.ValidateSQL(BBS.FilterPost(request.form("guestname"))) & "' where threadid=" & vThreadInfo(TI_ThreadID)
           dbConnection.execute SQL,, adTextNoRecords
           BBS.AddQuery(SQL)
           BBS.CacheDelete("TI-" & vThreadInfo(TI_ThreadID))
         end if

         ' If post revisioning is enabled, log the original message
         if ((dictConfiguration("bENABLEPOSTREVISIONING") = 1) and (bFeaturesUnlocked = 1)) then
           Forum.LogPostRevision vMessageInfo(MI_MessageID), sOldBody, sOldEdited, dOldEdited
         end if

         Alerts.ResetMessageAlert(vMessageInfo(MI_MessageID))
         response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & vThreadInfo(TI_ThreadID) & "&note=edit"
       end if
     end if

   else

    ' No action specified
    response.redirect "../category-view.asp"

   end if

   BBS.SetScheme(vCategoryInfo(CA_CategoryID))

   dictEnvironment.add "C-SHOWPREVIEW", bIsPreview
   if clng(bIsPreview) = 1 then
     dictEnvironment.add "V-PREVIEW", Forum.GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1)
   end if

   if dictEnvironment("C-ISREPLYING") = 1 then dictEnvironment("V-REPLYMESSAGE") = Forum.GenerateMessage (vReplyMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1)
   dictEnvironment.add "C-SHOWSIG", BBS.ValidateBoolean(iBBSMemberID > -1)

   dictEnvironment.add "C-SHOWDISABLEHTML", BBS.ValidateBoolean(bCanPostHTML)
   dictEnvironment.add "C-SHOWLINEBREAKS", dictEnvironment("C-SHOWDISABLEHTML")
   dictEnvironment.add "C-SHOWANONYMOUS", vForumInfo(FI_AnonymousAllowed)
   dictEnvironment.add "C-SHOWEMOTICONS", vForumInfo(FI_Emoticons)
   if sAction = "postnew" then
     dictEnvironment.add "C-SHOWSTICKY", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumsticky, vForumInfo(FI_ForumID)))
     dictEnvironment.add "C-SHOWFREEZE", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)))
   end if

   dictEnvironment.add "C-EDITDETAILS", BBS.ValidateBoolean(BBS.HasPermission(PERM_modeditmessagedetails, iForumID))
   dictEnvironment.add "C-MOVEMESSAGES", BBS.ValidateBoolean(BBS.HasPermission(PERM_modmovemessages, iForumID) and (sAction="edit" or sAction="postedit"))

   if sAction = "postedit" then

     if iEditTime > 0 then
       if DateDiff("n",vMessageInfo(MI_DatePosted), now) > iEditTime then
         dictEnvironment.item("C-SHOWATTACHLINK") = 0
       else
         dictEnvironment.add "C-SHOWATTACHLINK", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)) and BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)))
       end if
     else
       dictEnvironment.add "C-SHOWATTACHLINK", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)) and BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)))
     end if

   else
     dictEnvironment.add "C-SHOWATTACH", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)))
   end if

   dictEnvironment.add "C-ISGUEST", BBS.ValidateBoolean(iBBSMemberID = -1)

   dictEnvironment.add "U-FORUMLINK", "forum-view.asp?fid=" & vForumInfo(FI_ForumID)
   dictEnvironment.add "U-CATEGORYLINK", sBBSForumRoot & "/category-view.asp?catlock=" & vCategoryInfo(CA_CategoryID)
   dictEnvironment.add "U-CATEGORYLINKALL", sBBSForumRoot & "/category-view.asp?showall=true"
   dictEnvironment.add "U-FORMACTION", sBBSForumRoot & "/forums/thread-post.asp?action=" & sAction

   ' Which editor to use
   if bEditorChange = 1 then
     ' We have only just changed
     if (BBS.ValidateBoolean(request.form("editorchange")=dictLanguage("POST-21")) = 1) and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=1"
     elseif BBS.ValidateBoolean(request.form("editorchange")=dictLanguage("POST-22")) = 1 then
       dictEnvironment.add "C-USERICHEDIT", 0
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=0"
     end if

   elseif not isempty(request.querystring("richedit")) then
     ' Changed earlier and passed on in the querystring
     if (BBS.ValidateNumeric(request.querystring("richedit")) = 1) and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=1"
     elseif BBS.ValidateNumeric(request.querystring("richedit")) = 0 then
       dictEnvironment.add "C-USERICHEDIT", 0
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=0"
     end if

   else
     ' Decide from the preferences of the user
     if dictEnvironment("V-USER")(UI_UseRichEdit) = 1 and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
     else
       dictEnvironment.add "C-USERICHEDIT", 0
     end if
   end if

   if sAction = "writenew" or sAction = "postnew" then
     dictEnvironment.add "V-ACTIONTEXT", dictLanguage("POST-1")
     dictEnvironment.add "V-ACTION", "postnew"
   elseif sAction = "reply" or sAction = "postreply" then
     dictEnvironment.add "V-ACTIONTEXT", dictLanguage("POST-17") & " " & BBS.ValidateField(vReplyMessageInfo(MI_Subject))
     dictEnvironment.add "V-ACTION", "postreply"
   elseif sAction = "edit" or sAction = "postedit" then
     dictEnvironment.add "V-ACTIONTEXT", dictLanguage("POST-2")
     dictEnvironment.add "V-ACTION", "postedit"
   end if
   if vForumInfo(FI_Emoticons) = 1 then dictEnvironment("V-EMOTICONLIST") = Forum.GenerateEmoticonBox
   dictEnvironment("V-FORUM")= vForumInfo
   dictEnvironment("V-REPLYTO")= vReplyMessageInfo
   dictEnvironment("V-MESSAGE")= vMessageInfo
   dictEnvironment("V-CATEGORY")= vCategoryInfo
   if dictEnvironment("V-USER")(UI_UseRichEdit) = 1 and vMessageInfo(MI_FilterHTML) = 0 then dictEnvironment("C-EXTRAHEADTAG") = "<link rel='stylesheet' href='../htmlarea/htmlarea.css' type='text/css'>"

   dictEnvironment.add "V-TITLE", dictLanguage.item("POST-TITLE")
   dictEnvironment.add "C-QUOTES", vForumInfo(FI_ShowQuotes)
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1

   if dictEnvironment("C-USERICHEDIT") = 1 then
     dictEnvironment.item("C-EXTRAHEADTAG") = BBS.GetRichTextConstructor()
   end if

   if dictEnvironment("C-MOVEMESSAGES") = 1 then
     ' Generate a list of messages in this thread
     sMessageList = "<select name='inreplyto' class='bbsdropdownbox'>"
     SQL = "select messageid, subject, isregistered, guestname, memberid, dateposted from messages where threadid=" & vThreadInfo(TI_ThreadID) & " and messageid<>" & vMessageInfo(MI_MessageID) & " order by replyorder asc"
     rsMaster.open SQL, dbConnection, adOpenStatic, adLockReadOnly
     do until rsMaster.EOF
       sMessageList = sMessageList & "<option " & BBS.IsSelected(rsMaster.fields("messageid").value = vMessageInfo(MI_InReplyTo)) & " value='" & rsMaster.fields("messageid").value & "'>"
       sMessageList = sMEssageList & "[#" & rsMaster.fields("messageid").value & "  " & BBS.ValidateField(rsMaster.fields("subject").value) & "] - "
       if rsMaster.fields("isregistered").value = 1 then
         sMessageList = sMEssageList & BBS.ValidateField(BBS.GetUserInfoById(rsMaster.fields("memberid").value)(UI_Username))
       else
         sMessageList = sMEssageList & BBS.ValidateField(rsmaster.fields("guestname").value)
       end if
       sMessageList = sMEssageList & " - " & BBS.GetShortDateTime(rsMaster.fields("dateposted").value)
       sMessageList = sMEssageList & "</option>"
       rsMaster.MoveNext
     loop
     rsMaster.Close
     sMessageList = sMessageList & "</option>"
     dictEnvironment("V-INREPLYTO") = sMessageList

     dictEnvironment("U-MOVETONEWTHREAD") = "message-movenewthread.asp?mid=" & vMessageInfo(MI_MessageID)
     dictEnvironment("U-MOVETOEXISTINGTHREAD") = "message-moveexistingthread.asp?mid=" & vMessageInfo(MI_MessageID)
   end if

   if (dictConfiguration("bENABLESPELLCHECKER") = 1) and (bFeaturesUnlocked = 1) and (instr(request.servervariables("HTTP_USER_AGENT"), "MSIE") > 0) then
     dictEnvironment("C-ENABLESPELLCHECKER") = 1
     dictEnvironment("U-SPELLCHECKOBJECT")    = sBBSForumRoot & "/registered/wspellam.cab#version=5,15,0,0"
     dictEnvironment("U-SPELLCHECKOBJECTLPK") = sBBSForumRoot & "/registered/wspell.lpk"
   end if

  if dictEnvironment("V-FORUM")(FI_shownavbars) = 1 then
    dictEnvironment("V-FORUMLOCATION") = "&nbsp;<a href='" & dictEnvironment("U-CATEGORYLINK")& "'>" & dictEnvironment("V-CATEGORY")(CA_CategoryName) & "</a>"
    if dictEnvironment("V-CATEGORY")(CA_Locked) = 1 then
      dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & "&nbsp;(<a href='" & dictEnvironment("U-CATEGORYLINKALL") &"'>" & dictLanguage("POST-24") & "</a>)"
    end if
    dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & " -> " & dictEnvironment("V-FORUM")(FI_ForumName)
    dictEnvironment("V-LOCATIONLINKS") = dictEnvironment("V-LOCATIONLINKS") & " -> " & dictEnvironment("V-FORUMLOCATION") & "  -> " & dictLanguage("GLOBAL-LOCATION16")
  end if


%>
<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/forum/thread-post.asp") %>
<!-- #include file="../includes/footer.asp" -->