<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-forums.asp"-->
<!-- #include file="../includes/include-polls.asp"-->
<% sBBSLangPage = "thread-view"
   BBS.SetupBBS

   dim iThreadID, iMessageID, vForumInfo, vThreadInfo, vUserInfo, sPollUsername, bHasVotePermission, iOption, iNewOptionID, bError, sError, vCategoryInfo
   dim sDisplayForm, sThreadViewMode, iStart, iNumFlatPages, sFlatPageBar, sOrder, iCurrentPage, index, stDisplayMessage, stGenerateThread
   dim sThreadBody, vMessageInfo, bReplyOwn, bReplyOthers, sReplyForm, sHighlight, iHighlightMode, bHighlight, sThreadView, iEndPage

   iThreadID      = BBS.ValidateNumeric(request("tid"))
   iMessageID     = BBS.ValidateNumeric(request("mid"))
   vMessageInfo   = Forum.GetMessageInfo(iMessageID)
   vThreadInfo    = Forum.GetThreadInfo(iThreadID)
   vForumInfo     = Forum.GetForumInfo (vThreadInfo(TI_ForumID))
   vUserInfo      = BBS.GetUserInfobyID(iBBSMemberID)
   vCategoryInfo  = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
   iStart         = BBS.ValidateNumeric(request.querystring("start"))
   sHighlight     = trim(BBS.Canonize(request.querystring("highlight")))
   iHighlightMode = BBS.ValidateNumeric(request.querystring("highlightmode"))
   bHighlight     = BBS.ValidateBoolean((len(sHighlight) > 0) and (iHighlightMode = 1 or iHighlightMode = 2))

   if vCategoryInfo(CA_Locked) = 1 then
     response.cookies(sBBSCookieRoot & "catlock") = vCategoryInfo(CA_CategoryID)
   end if
   BBS.SetScheme(vCategoryInfo(CA_CategoryID))

   ' Store highlight info
   dictEnvironment.item("C-HIGHLIGHT") = bHighlight
   dictEnvironment.item("V-HIGHLIGHT") = sHighlight
   dictEnvironment.item("V-HIGHLIGHTMODE") = iHighlightMode

   ' Check for access to the forum
   if vThreadInfo(TI_ThreadID) < 1 or vForumInfo(FI_ForumID) < 1 then response.redirect sBBSForumRoot & "/category-view.asp"
   if not(BBS.HasPermission(PERM_FORUMACCESS, vForumInfo(FI_ForumID))) then response.redirect sBBSForumRoot & "/restricted-page.asp"

   bReplyOthers = BBS.HasPermission(PERM_forumreplyothers, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) <> iBBSMemberID)
   bReplyOwn = BBS.HasPermission(PERM_forumreplyown, vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) = iBBSMemberID)

   ' Move back or forward one thread
   if request.querystring("action") = "back" or request.querystring("action") = "next" then

     if vForumInfo(FI_SortByActivity) = 1 then
       SQL = "SELECT threadid from threads where forumid = " & iforumid & " order by sticky DESC, lastactivity DESC"
     else
       SQL = "SELECT threadid from threads where forumid = " & iforumid & " order by sticky DESC, threadid DESC"
     end if
     rsMaster.open SQL, dbConnection, adOpenStatic, adLockReadOnly
     BBS.AddQuery(SQL)

     rsMaster.Find "threadid=" & vThreadInfo(TI_ThreadID)

     if request.querystring("action") = "back" then
       rsMaster.MovePrevious
     else
       rsMaster.MoveNext
     end if

     ' Set the new thread
     if rsMaster.EOF then
       dictEnvironment("C-ERROR") = 1
       dictEnvironment("V-ERROR") = dictLanguage("THREAD-16")
     else
       iThreadID = rsMaster.fields(0).value
       vThreadInfo = Forum.GetThreadInfo(iThreadID)
     end if
     rsMaster.Close
   end if

   ' Deterimine the active viewing method (in order of preference)
   ' If the user has supplied a viewing mode via the querystring, then use this mode and set the cookie
   ' If the user has already has a cookied preference, use that
   ' If the user has no cookied preference, use their profile default
   ' If the user still has not chosen a mode, use the forum default
   if len(request.querystring("DisplayType")) > 0 then
     sThreadViewMode = request.querystring("DisplayType")
     if request.querystring("setcookie") = "1" then response.cookies(sBBSCookieRoot & "ThreadViewMode") = sThreadViewMode
   elseif len(sBBSThreadViewMode) > 0 then
     sThreadViewMode = sBBSThreadViewMode
   elseif iBBSLogonType = US_Registered then
     sThreadViewMode = vUserInfo(UI_defaultthreadview)
   end if
   if len(sThreadViewMode) = 0 or sThreadViewMode = "default" then sThreadViewMode = vForumInfo(FI_defaultthreadview)
   if len(sThreadViewMode) = 0 then sThreadViewMode = "flat"

   ' Offset the view count for this thread
   if request.form("action") <> "vote" and (vThreadInfo(TI_TimesViewed) > 0 or (vThreadInfo(TI_MemberID) <> iBBSMemberID)) then
     Forum.OffsetThreadViewCount vThreadInfo(TI_ThreadID), 1
   end if

   ' ========================
   ' TEMPLATE VARIABLES
   ' ========================

   sDisplayForm = sDisplayForm & "<form name='container' action='thread-view.asp' method='get'><input type='hidden' name='tid' value='" & vThreadInfo(TI_ThreadID) & "'>"
   if bHighlight then sDisplayForm = sDisplayForm & "<input type='hidden' name='highlight' value='" & server.urlencode(sHighlight) & "'><input type='hidden' name='highlightmode' value='" & iHighlightMode & "'>"
   sDisplayForm = sDisplayForm & "<select class='bbsdropdownbox' name='DisplayType' onchange='updateCookie()' size='1'>"
   if sThreadViewMode = "flat" then
     sDisplayForm = sDisplayForm & "<option selected value='flat'>" & dictLanguage.item("THREAD-2") & "</option><option value='threaded'>" & dictLanguage.item("THREAD-3") & "</option><option value='nested'>" & dictLanguage("THREAD-4") & "</option>"
   elseif sThreadViewMode = "threaded" then
     sDisplayForm = sDisplayForm & "<option value='flat'>" & dictLanguage.item("THREAD-2") & "</option><option selected value='threaded'>" & dictLanguage.item("THREAD-3") & "</option><option value='nested'>" & dictLanguage("THREAD-4") & "</option>"
   elseif sThreadViewMode = "nested" then
     sDisplayForm = sDisplayForm & "<option value='flat'>" & dictLanguage.item("THREAD-2") & "</option><option value='threaded'>" & dictLanguage.item("THREAD-3") & "</option><option selected value='nested'>" & dictLanguage("THREAD-4") & "</option>"
   end if
   sDisplayForm = sDisplayForm & "</select>&nbsp;<input type='hidden' name='setcookie' value='1'><input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-GO") & "'></form>"


   if vThreadInfo(TI_Sticky) = 1then
     dictEnvironment("V-SPECIALIMAGE") = "<img border='0' align='middle' src='" & dictImages("THREAD-STICKY") & "' alt='" & dictLanguage("GLOBAL-STICKY") & "'>"
   elseif vThreadInfo(TI_HasPoll) = 1 then
     dictEnvironment("V-SPECIALIMAGE") = "<img border='0' align='middle' src='" & dictImages("THREAD-POLL") & "' alt='" & dictLanguage("GLOBAL-POLL") & "'>"
   elseif iBBSLogonType = US_Registered then
     if vThreadInfo(TI_LastActivity) > vUserInfo(UI_LastLogon) then
       if vThreadInfo(TI_TotalPosts) > 20 then
         dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN-NEW-HOT") & "'>"
       else
         dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN-NEW") & "'>"
       end if
     else
       if vThreadInfo(TI_TotalPosts) > 20 then
         dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN-HOT") & "'>"
       else
         dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN") & "'>"
       end if
     end if
   else
     if vThreadInfo(TI_TotalPosts) > 20 then
       dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN-HOT") & "'>"
     else
       dictEnvironment("V-SPECIALIMAGE") = "<img alt='' border='0' align='middle' src='" & dictImages("THREAD-OPEN") & "'>"
     end if
   end if



   dictEnvironment.add "C-VIEWMODE", sThreadViewMode
   dictEnvironment.add "C-THREADFREEZE", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-THREADDELETE", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumdeletethread, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-THREADMOVE", BBS.ValidateBoolean(BBS.HasPermission(PERM_forummove, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-THREADMOVEEXISTING", BBS.ValidateBoolean(BBS.HasPermission(PERM_modmovemessages, vForumInfo(FI_ForumID)) and vThreadInfo(TI_HasPoll) = 0)
   dictEnvironment.add "C-THREADSTICKY", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumsticky, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-THREADNOTIFY", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumallownotifications, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-POSTNEW", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumnewthread,  vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-CANREPLY", BBS.ValidateBoolean(bReplyOthers or bReplyOwn)
   dictEnvironment.add "C-REPLYFORM", dictConfiguration.item("sREPLYFORM")
   if vCategoryInfo(CA_Locked) then
     dictEnvironment.add "V-FORUMJUMP", "<form method='get' action='forum-view.asp'>" & dictLanguage("THREAD-23") & " <select name='fid' size='1' class='bbsdropdownbox'>" & Forum.GenerateForumDropdown(vCategoryInfo(CA_CategoryID), vForumInfo(FI_ForumID)) & "</select> <input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-GO") & "'></form>"
   else
     dictEnvironment.add "V-FORUMJUMP", "<form method='get' action='forum-view.asp'>" & dictLanguage("THREAD-23") & " <select name='fid' size='1' class='bbsdropdownbox'>" & Forum.GenerateForumDropdown(-1, vForumInfo(FI_ForumID)) & "</select> <input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-GO") & "'></form>"
   end if
   dictEnvironment.add "V-MESSAGEFORMATCHOOSER", sDisplayForm
   dictEnvironment.add "V-CATEGORY", vCategoryInfo
   dictEnvironment.add "V-FORUM", vForumInfo
   dictEnvironment.add "V-THREAD", vThreadInfo
   dictEnvironment.add "V-USER", BBS.GetUserInfobyID(iBBSMemberID)
   dictEnvironment.add "V-MESSAGE", vMessageInfo

   if vThreadInfo(TI_HasPoll) = 1 then dictEnvironment("V-POLLBOX") = Polls.GeneratePoll(vThreadInfo(TI_PollID), sBBSCompleteURL)
   dictEnvironment.add "V-MODERATORLIST", BBS.ListMembers (MODULE_FORUMS, USERLEVEL_Moderator, vForumInfo(FI_ForumID))
   if sThreadViewMode = "threaded" then
     if iMessageID <= 0  then iMessageID = vThreadInfo(TI_Seed)
     vMessageInfo = Forum.GetMessageInfo(iMessageID)
     dictEnvironment.add "U-REPLYLINK", "thread-post.asp?action=reply&amp;fid=" & vForumInfo(FI_ForumID) & "&amp;tid=" & vThreadInfo(TI_THreadID) & "&amp;replyto=" & vMessageInfo(MI_MessageID) & "&amp;displaytype=" & sThreadViewMode
   else
     vMessageInfo = Forum.GetMessageInfoStruct()
     dictEnvironment.add "U-REPLYLINK", "thread-post.asp?action=reply&amp;fid=" & vForumInfo(FI_ForumID) & "&amp;tid=" & vThreadInfo(TI_THreadID) & "&amp;replyto=" & vThreadInfo(TI_Seed) & "&amp;displaytype=" & sThreadViewMode
   end if
   dictEnvironment.add "U-POSTLINK", "thread-post.asp?action=writenew&amp;fid=" & vForumInfo(FI_ForumID) & "&amp;tid=" & vThreadInfo(TI_THreadID) & "&amp;replyto=" & vThreadInfo(TI_Seed) & "&amp;displaytype=" & sThreadViewMode
   dictEnvironment.add "U-FORUMLINK", "forum-view.asp?fid=" & vForumInfo(FI_ForumID)
   dictEnvironment.add "U-PRINTERLINK", "printer-friendly.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;mid=" & vMessageInfo(MI_MessageID)
   dictEnvironment.add "U-EMAILLINK", "email-link.asp?tid=" & vThreadInfo(TI_ThreadID)

   if clng(iBBSCatLock) = clng(vCategoryInfo(CA_CategoryID)) then
     dictEnvironment.add "U-CATEGORYLINK", sBBSForumRoot & "/category-view.asp?catlock=" & vCategoryInfo(CA_CategoryID)
   else
     dictEnvironment.add "U-CATEGORYLINK", sBBSForumRoot & "/category-view.asp?showall=true"
   end if
   dictEnvironment.add "C-CATLOCK", BBS.ValidateBoolean(iBBSCatLock > 0)

   dictEnvironment.add "U-CATEGORYLINKALL", sBBSForumRoot & "/category-view.asp?showall=true"
   dictEnvironment.add "U-NEXTTHREADLINK", sBBSForumRoot & "/forums/thread-view.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;action=next"
   dictEnvironment.add "U-BACKTHREADLINK", sBBSForumRoot & "/forums/thread-view.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;action=back"
   dictEnvironment.add "U-THREADFREEZE", sBBSForumRoot & "/forums/thread-freeze.asp?tid=" & vThreadInfo(TI_ThreadID)
   dictEnvironment.add "U-THREADMOVE", sBBSForumRoot & "/forums/thread-move.asp?tid=" & vThreadInfo(TI_ThreadID)
   dictEnvironment.add "U-THREADMOVEEXISTING", sBBSForumRoot & "/forums/message-moveexistingthread.asp?mid=" & vThreadInfo(TI_Seed)
   dictEnvironment.add "U-THREADDELETE", sBBSForumRoot & "/forums/thread-delete.asp?tid=" & vThreadInfo(TI_ThreadID)
   dictEnvironment.add "U-THREADSTICKY", sBBSForumRoot & "/forums/thread-sticky.asp?tid=" & vThreadInfo(TI_ThreadID)
   dictEnvironment.add "U-NOTIFICATION", sBBSForumRoot & "/forums/notification-toggle.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;redirect="& BBS.ValidateURL(sBBSForumRoot & "/thread-view.asp?" & sBBSCurrentQueryString)
   dictEnvironment.add "U-SEARCH", sBBSForumRoot & "/search/query.asp?fid=" & vForumInfo(FI_ForumID)
   dictEnvironment.add "U-PREVTHREAD", sBBSForumRoot & "/forums/thread-skip.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;m=1"
   dictEnvironment.add "U-NEXTTHREAD", sBBSForumRoot & "/forums/thread-skip.asp?tid=" & vThreadInfo(TI_ThreadID) & "&amp;m=2"

   dictEnvironment.add "V-TITLE", dictLanguage.item("THREAD-TITLE") & " - " & vThreadInfo(TI_Subject)
   dictEnvironment.add "C-SHOWRANDOMQUOTES", vForumInfo(FI_ShowQuotes)
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1

   dictEnvironment.add "C-SHOWSIG", BBS.ValidateBoolean(iBBSMemberID > -1)
   dictEnvironment.add "C-SHOWDISABLEHTML", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-SHOWLINEBREAKS", dictEnvironment("C-SHOWDISABLEHTML")
   dictEnvironment.add "C-SHOWANONYMOUS", vForumInfo(FI_AnonymousAllowed)
   dictEnvironment.add "C-SHOWEMOTICONS", vForumInfo(FI_Emoticons)
   dictEnvironment.add "C-SHOWATTACH", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)))

   dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(dictEnvironment.item("V-USER")(UI_UseSignature))
   dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = 0
   dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(BBS.BooleanNot(dictEnvironment.item("V-USER")(UI_UseRichEdit)))
   dictEnvironment("C-SHOWANONYMOUSCHECKED")   = 0
   dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(1)
   if (dictConfiguration("bENABLESPELLCHECKER") = 1) and (bFeaturesUnlocked = 1) and (instr(request.servervariables("HTTP_USER_AGENT"), "MSIE") > 0) then
     dictEnvironment("C-ENABLESPELLCHECKER") = 1
     dictEnvironment("U-SPELLCHECKOBJECT")    = sBBSForumRoot & "/registered/wspellam.cab#version=5,15,0,0"
     dictEnvironment("U-SPELLCHECKOBJECTLPK") = sBBSForumRoot & "/registered/wspell.lpk"
   end if

  if dictEnvironment("V-FORUM")(FI_shownavbars) = 1 then
    dictEnvironment("V-FORUMLOCATION") = "&nbsp;<a href='" & dictEnvironment("U-CATEGORYLINK")& "'>" & dictEnvironment("V-CATEGORY")(CA_CategoryName) & "</a>"
    if dictEnvironment("V-CATEGORY")(CA_Locked) = 1 then
      dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & "&nbsp;(<a href='" & dictEnvironment("U-CATEGORYLINKALL") &"'>" & dictLanguage("THREAD-15") & "</a>)"
    end if
    dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & " -> " & dictEnvironment("V-FORUM")(FI_ForumName)
    dictEnvironment("V-LOCATIONLINKS") = dictEnvironment("V-LOCATIONLINKS") & " -> " & dictEnvironment("V-FORUMLOCATION")
  end if

  dictEnvironment("C-EXTRAHEADTAG") = "<script type='text/javascript'>function updateCookie() {" & CRLF & _
                                      "  sThreadViewMode = document.container.DisplayType.options[document.container.DisplayType.selectedIndex].value;" & CRLF & _
                                      "  document.cookie = """ & sBBSCookieRoot & "ThreadViewMode="" + sThreadViewMode + ""; path=/;"";" & CRLF & _
                                      "  NewURL = document.location.pathname + ""?tid=" & vThreadInfo(TI_ThreadID) & "&DisplayType="" + sThreadViewMode + ""&setCookie=1"";" & CRLF & _
                                      "  window.location = NewURL;" & CRLF &  _
                                      "}</script>" & CRLF


   ' =============================
   ' GENERATE THE QUICK REPLY FORM
   ' =============================

   if iBBSUserLevel <= userlevel_guest then vUserInfo(UI_QuickReplyMode) = "none"
   select case vUserInfo(UI_QuickReplyMode)
   case "full"
     vbString.Append "<br/><br/>"
     vbString.Append "<form method='post' action='thread-post.asp?action=postreply'>"
     vbString.Append "<input type='hidden' name='fid' value='" & dictEnvironment("V-FORUM")(FI_ForumID) & "'>"
     if dictEnvironment("V-MESSAGE")(MI_MessageID) > 0 then
       ' Replying to a specific message
       vbString.Append "<input type='hidden' name='replyto' value='" & dictEnvironment("V-MESSAGE")(MI_MessageID) & "'>"
     else
       ' Probably in flat viewing mode, use the seed
       vbString.Append "<input type='hidden' name='replyto' value='" & dictEnvironment("V-THREAD")(TI_Seed) & "'>"
     end if
     vbString.Append "<input type='hidden' name='mid' value='" & dictEnvironment("V-MESSAGE")(MI_MessageID) & "'>"
     vbString.Append "<input type='hidden' name='filtercrlf' value='" & dictEnvironment("C-USERICHEDIT") & "'>"

     vbString.Append "<table align='center' width='95%' class='bbstable' cellspacing='" & dictTemplate("CELLSPACING") & "'><tr><td class='messagecellheader' colspan='2'>" & dictLanguage("POST-TITLE") & "</td></tr>"
     if dictEnvironment("C-ISGUEST") = 1 then
       vbString.Append "<tr><td class='messagecellbody'><b>" & dictLanguage("POST-5") & "</b></td><td class='messagecellbody'>" & _
       "<input type='text' class='bbstextbox' size='20 maxlength='20' name='guestname' value='" & _
       BBS.ValidateField(dictEnvironment("V-MESSAGE")(MI_GuestName)) & "'></td></tr>"
     else
       vbString.Append "<tr><td class='messagecellbody'><b>" & dictLanguage("POST-4") & "</b></td><td class='messagecellbody'>" & _
       BBS.ValidateField(sBBSUserName) & "</td></tr>"
     end if
     vbString.Append "<tr><td class='messagecellbody'><b>" & dictLanguage("POST-6") & "</b></td><td class='messagecellbody'>" & _
     "<input type='text' class='bbstextbox' name='subject' size='50' maxlength='100' value='Re: " & BBS.ValidateField(dictEnvironment("V-THREAD")(TI_Subject)) & _
     "'></td></tr>"
     vbString.Append "<tr><td class='messagecellbody' valign='top'><b>" & dictLanguage("POST-16") & "</b><br/><br/>"
     vbString.Append "<div align='center'><b>" & dictLanguage("POST-7") & "</div><div align='center'>" & Forum.GenerateEmoticonBox & "</div>"
     vbString.Append "</td><td class='messagecellbody' width='90%'><textarea style='width:95%' rows='10' class='bbseditbox' name='messagebody' id='messagebody'></textarea></td></tr>"

     ' Options
     vbString.Append "<tr><td nowrap align='left' class='messagecellbody smalltext'>"
     if dictEnvironment("C-SHOWDISABLEHTML") = 1 then
       vbString.Append dictLanguage("POST-HTML") & dictLanguage("GLOBAL-YES") & "<br/>"
     else
       vbString.Append dictLanguage("POST-HTML") & dictLanguage("GLOBAL-NO") & "<br/>"
     end if
     if dictEnvironment("C-SHOWANONYMOUS") = 1 then
       vbString.Append dictLanguage("POST-ANON") & dictLanguage("GLOBAL-YES") & "<br/>"
     else
       vbString.Append dictLanguage("POST-ANON") & dictLanguage("GLOBAL-NO") & "<br/>"
     end if
     if dictConfiguration("bDISABLEMBBSCODE") = 0 then
       vbString.Append dictLanguage("POST-MBBS") & "<a href='" & sBBSForumRoot & "/help-mbbscode.asp'>" & dictLanguage("GLOBAL-YES") & "</a><br/>"
     else
       vbString.Append dictLanguage("POST-MBBS") & dictLanguage("GLOBAL-NO") & "<br/>"
     end if

     vbString.Append "</td>"

     vbString.Append "<td class='messagecellbody'>"
     if dictEnvironment("C-SHOWSIG") = 1 then vbString.Append "<input " & dictEnvironment("C-SHOWSIGCHECKED") & " type='checkbox' class='bbscheckbox' name='signature' value='1'> " & dictLanguage("POST-8") & "<br/>"
     if dictEnvironment("C-SHOWDISABLEHTML") = 1 then vbString.Append "<input " & dictEnvironment("C-SHOWDISABLEHTMLCHECKED") & " type='checkbox' class='bbscheckbox' name='disablehtml' value='1'> " & dictLanguage("POST-9") & "<br/>"
     ' if dictEnvironment("C-SHOWLINEBREAKS") = 1 then vbString.Append "<input " & dictEnvironment("C-SHOWLINEBREAKSCHECKED") & " type='checkbox' class='bbscheckbox' name='linebr' value='1'> " & dictLanguage("POST-10") & "<br/>"
     if dictEnvironment("C-SHOWANONYMOUS") = 1 then vbString.Append "<input " & dictEnvironment("C-SHOWANONYMOUSCHECKED") & " type='checkbox' class='bbscheckbox' name='anonymous' value='1'> " & dictLanguage("POST-11") & "<br/>"
     if dictEnvironment("C-SHOWEMOTICONS") = 1 then vbString.Append "<input " & dictEnvironment("C-SHOWEMOTICONSCHECKED") & " type='checkbox' class='bbscheckbox' name='emoticons' value='1'> " & dictLanguage("POST-12") & "<br/>"
     vbString.Append "<br/>"
     if dictEnvironment("C-SHOWATTACH") = 1 then vbString.Append "<input type='checkbox' class='bbscheckbox' name='attach' value='1'> " & dictLanguage("POST-15") & "<br/>"
     vbString.Append "</td></tr>"
     vbString.Append "<tr><td class='messagecellfooter' colspan='2' align='center'>"
     vbString.Append "<input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-SUBMIT") & "'> <input type='submit' name='preview' class='bbsbutton' value='" & dictLanguage("GLOBAL-PREVIEW") & "'> "

     if dictEnvironment("C-ENABLESPELLCHECKER") = 1 then
       vbString.Append "<input style='display: none' id='spellcheck' onclick='document.getElementById(""wspelldiv"").innerHTML = wspellid;' type='button' name='spellcheck' class='bbsbutton' value='" & dictLanguage("GLOBAL-SPELLCHECK") & "'>"
       vbString.Append "<input style='display: none' onclick='install()' id='installspellcheck' type='button' name='installspellcheck' class='bbsbutton' value='Install Spellchecker'>"
       vbString.Append "<div style='display: none' id='wspelldiv'></div>"
       vbString.Append "<script type='text/javascript'>" & CRLF
       vbString.Append "var wspellid=""<OBJECT style='display: none'  CLASSID='clsid:5220cb21-c88d-11cf-b347-00aa00a28331' BORDER='0' VSPACE='0' HSPACE='0'><PARAM NAME='LPKPath' VALUE='" & dictEnvironment("U-SPELLCHECKOBJECTLPK") & "'></OBJECT> <OBJECT style='display: none' onreadystatechange='runchecker()' CLASSID='clsid:245338C3-BCA3-4A2C-A7B7-53345999A8E8' ID='WSpell1' CODEBASE='" & dictEnvironment("U-SPELLCHECKOBJECT") & "' WIDTH='28' HEIGHT='27' BORDER='0' VSPACE='0' HSPACE='0'><PARAM NAME='_Version' VALUE='65536'><PARAM NAME='_ExtentX' VALUE='450'><PARAM NAME='_ExtentY' VALUE='582'><PARAM NAME='_StockProps' VALUE='16'><PARAM NAME='ShowContext' VALUE='-1'><PARAM NAME='CatchMixedCaseWords' VALUE='0'><PARAM NAME='IgnoreAllCapsWords' VALUE='0'><PARAM NAME='IgnoreCapitalizedWords' VALUE='0'><PARAM NAME='IgnoreHTMLMarkups' VALUE='1'><PARAM NAME='IgnoreMixedCaseWords' VALUE='0'><PARAM NAME='IgnoreWordsWithDigits' VALUE='0'><PARAM NAME='MainDictionaryFiles' VALUE='ssceam.tlx,ssceam2.clx'><PARAM NAME='MinSuggestionDepth' VALUE='40'><PARAM NAME='PhoneticSuggestions' VALUE='0'><PARAM NAME='SplitContractedWords' VALUE='0'><PARAM NAME='SplitWords' VALUE='0'><PARAM NAME='SuggestionScoreRange' VALUE='50'><PARAM NAME='UserDictionaryFiles' VALUE='userdic.tlx'> <param name='Text' value> <param name='ShowDialog' value='1'> <param name='DialogLeft' value='-1'> <param name='DialogTop' value='-1'> <param name='ShowDictionariesButton' value='1'> <param name='ShowOptionsButton' value='1'> <param name='AllowAccentedCaps' value='1'> <param name='AutoCorrect' value='1'> <param name='BackupUserDictionary' value='0'> <param name='CaseSensitive' value='1'> <param name='CatchDoubledWords' value='1'> <param name='CatchWordsWithDigits' value='0'> <param name='CharacterSet' value='1'> <param name='IgnoreDomainNames' value='0'> <param name='IgnoreNonAlphaWords' value='1'> <param name='MaxSuggestions' value='16'> <param name='MinSuggestionScore' value='50'> <param name='SplitHyphenatedWords' value='1'> <param name='StripPossessives' value='1'> <param name='SuggestionDepthIncrement' value='10'> <param name='SuggestSplitWords' value='1'><param name='TypographicalSuggestions' value='1'></OBJECT>""" & CRLF
       vbString.Append "var useSpell = " & lcase(request.cookies(sBBSCookieRoot & "sp")="1") & ";" & CRLF

       vbString.Append "if (useSpell){" & CRLF
       vbString.Append "document.getElementById(""spellcheck"").style.display = 'inline';" & CRLF
       vbString.Append "document.getElementById(""installspellcheck"").style.display = 'none';" & CRLF
       vbString.Append "} else {" & CRLF
       vbString.Append "document.getElementById(""spellcheck"").style.display = 'none';" & CRLF
       vbString.Append "document.getElementById(""installspellcheck"").style.display = 'inline';" & CRLF
       vbString.Append "}" & CRLF
       vbString.Append "function install(){" & CRLF
       vbString.Append "open('" & sBBSForumRoot & "/registered/install-spellcheck.asp', null, 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=1,width=450,height=200,left=300,top=300');" & CRLF
       vbString.Append "}"
       vbString.Append "</script>"
     end if

     vbString.Append "</td></tr></table></form>"
     vbString.Append "<script type='text/javascript'>function inserttext(target, text) {"
     vbString.Append "target.value = (target.value+ "" "" + text + "" "");"
     vbString.Append "target.focus();}</script>"

     if dictEnvironment("C-ENABLESPELLCHECKER") = 1 then
     vbString.Append "<script type='text/javascript'>function runchecker()" & CRLF
     vbString.Append "{" & CRLF
     vbString.Append "  if (document.all.WSpell1)" & CRLF
     vbString.Append "  {" & CRLF
     vbString.Append "  document.all.WSpell1.Text = document.getElementById(""messagebody"").value;" & CRLF
     vbString.Append "  document.all.WSpell1.Start;" & CRLF
     vbString.Append "  document.getElementById(""messagebody"").value = document.all.WSpell1.Text;" & CRLF
     vbString.Append "  }" & CRLF
     vbString.Append "  else" & CRLF
     vbString.Append "  {" & CRLF
     vbString.Append "   setTimeout(""runchecker()"",150);" & CRLF
     vbString.Append "  }" & CRLF
     vbString.Append "}" & CRLF
     vbString.Append CRLF & "</script>"
     end if

   case "compact"
     vbString.Append "<br/><br/><form name='reply' action='thread-post.asp?action=postreply' method='post'>"
     vbString.Append "<input type='hidden' name='fid' value='" & dictEnvironment("V-THREAD")(TI_ForumID) & "'>"
     vbString.Append "<input type='hidden' name='tid' value='" & dictEnvironment("V-THREAD")(TI_ThreadID) & "'>"
     if dictEnvironment("V-MESSAGE")(MI_MessageID) > 0 then
       ' Replying to a specific message
       vbString.Append "<input type='hidden' name='replyto' value='" & dictEnvironment("V-MESSAGE")(MI_MessageID) & "'>"
     else
       ' Probably in flat viewing mode, use the seed
       vbString.Append "<input type='hidden' name='replyto' value='" & dictEnvironment("V-THREAD")(TI_Seed) & "'>"
     end if
     vbString.Append "<input type='hidden' name='mid' value='" & dictEnvironment("V-MESSAGE")(MI_MessageID) & "'>"
     vbString.Append "<input type='hidden' name='emoticons' value='1'>"
     if vUserInfo(UI_UseSignature) = 1 then vbString.Append "<input type='hidden' name='signature' value='1'>"
     vbString.Append "<input type='hidden' name='disablehtml' value='1'>"
     vbString.Append "<input type='hidden' name='filtercrlf' value='0'>"
     vbString.Append "<input type='hidden' name='linebr' value='0'>"
     vbString.Append "<input type='hidden' name='anonymous' value='0'>"
     vbString.Append "<input type='hidden' name='subject' value='Re: " & BBS.ValidateField(dictEnvironment("V-THREAD")(TI_Subject)) & "'>"
     vbString.Append "<table align='center' width='95%' class='bbstable' cellspacing='" & dictTemplate("CELLSPACING") & "'><tr><td class='messagecellheader'>" & dictLanguage("GLOBAL-REPLY") & "</td></tr>"
     vbString.Append "<tr><td class='messagecellbody'>"
     vbString.Append "<textarea style='width: 99%' class='bbseditbox' rows='5' cols='75' name='messagebody'></textarea></td></tr>"
     vbString.Append "<tr><td class='messagecellfooter' align='center'><input type='submit' value='" & dictLanguage("GLOBAL-SUBMIT") & "' class='bbsbutton'> "

     if dictEnvironment("C-ENABLESPELLCHECKER") = 1 then
       vbString.Append "<input style='display: none' id='spellcheck' onclick='document.getElementById(""wspelldiv"").innerHTML = wspellid;' type='button' name='spellcheck' class='bbsbutton' value='" & dictLanguage("GLOBAL-SPELLCHECK") & "'>"
       vbString.Append "<input style='display: none' onclick='install()' id='installspellcheck' type='button' name='installspellcheck' class='bbsbutton' value='Install Spellchecker'>"
       vbString.Append "<div style='display: none' id='wspelldiv'></div>"
       vbString.Append "<script type='text/javascript'>" & CRLF
       vbString.Append "var wspellid=""<OBJECT style='display: none'  CLASSID='clsid:5220cb21-c88d-11cf-b347-00aa00a28331' BORDER='0' VSPACE='0' HSPACE='0'><PARAM NAME='LPKPath' VALUE='" & dictEnvironment("U-SPELLCHECKOBJECTLPK") & "'></OBJECT> <OBJECT style='display: none' onreadystatechange='runchecker()' CLASSID='clsid:245338C3-BCA3-4A2C-A7B7-53345999A8E8' ID='WSpell1' CODEBASE='" & dictEnvironment("U-SPELLCHECKOBJECT") & "' WIDTH='28' HEIGHT='27' BORDER='0' VSPACE='0' HSPACE='0'><PARAM NAME='_Version' VALUE='65536'><PARAM NAME='_ExtentX' VALUE='450'><PARAM NAME='_ExtentY' VALUE='582'><PARAM NAME='_StockProps' VALUE='16'><PARAM NAME='ShowContext' VALUE='-1'><PARAM NAME='CatchMixedCaseWords' VALUE='0'><PARAM NAME='IgnoreAllCapsWords' VALUE='0'><PARAM NAME='IgnoreCapitalizedWords' VALUE='0'><PARAM NAME='IgnoreHTMLMarkups' VALUE='1'><PARAM NAME='IgnoreMixedCaseWords' VALUE='0'><PARAM NAME='IgnoreWordsWithDigits' VALUE='0'><PARAM NAME='MainDictionaryFiles' VALUE='ssceam.tlx,ssceam2.clx'><PARAM NAME='MinSuggestionDepth' VALUE='40'><PARAM NAME='PhoneticSuggestions' VALUE='0'><PARAM NAME='SplitContractedWords' VALUE='0'><PARAM NAME='SplitWords' VALUE='0'><PARAM NAME='SuggestionScoreRange' VALUE='50'><PARAM NAME='UserDictionaryFiles' VALUE='userdic.tlx'> <param name='Text' value> <param name='ShowDialog' value='1'> <param name='DialogLeft' value='-1'> <param name='DialogTop' value='-1'> <param name='ShowDictionariesButton' value='1'> <param name='ShowOptionsButton' value='1'> <param name='AllowAccentedCaps' value='1'> <param name='AutoCorrect' value='1'> <param name='BackupUserDictionary' value='0'> <param name='CaseSensitive' value='1'> <param name='CatchDoubledWords' value='1'> <param name='CatchWordsWithDigits' value='0'> <param name='CharacterSet' value='1'> <param name='IgnoreDomainNames' value='0'> <param name='IgnoreNonAlphaWords' value='1'> <param name='MaxSuggestions' value='16'> <param name='MinSuggestionScore' value='50'> <param name='SplitHyphenatedWords' value='1'> <param name='StripPossessives' value='1'> <param name='SuggestionDepthIncrement' value='10'> <param name='SuggestSplitWords' value='1'><param name='TypographicalSuggestions' value='1'></OBJECT>""" & CRLF
       vbString.Append "var useSpell = " & lcase(request.cookies(sBBSCookieRoot & "sp")="1") & ";" & CRLF

       vbString.Append "if (useSpell){" & CRLF
       vbString.Append "document.getElementById(""spellcheck"").style.display = 'inline';" & CRLF
       vbString.Append "document.getElementById(""installspellcheck"").style.display = 'none';" & CRLF
       vbString.Append "} else {" & CRLF
       vbString.Append "document.getElementById(""spellcheck"").style.display = 'none';" & CRLF
       vbString.Append "document.getElementById(""installspellcheck"").style.display = 'inline';" & CRLF
       vbString.Append "}" & CRLF
       vbString.Append "function install(){" & CRLF
       vbString.Append "open('" & sBBSForumRoot & "/registered/install-spellcheck.asp', null, 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=1,width=450,height=200,left=300,top=300');" & CRLF
       vbString.Append "}"
       vbString.Append "</script>"
     end if

     vbString.Append "</td></tr></table>"
     vbString.Append "</form><br/>"

     if dictEnvironment("C-ENABLESPELLCHECKER") = 1 then
     vbString.Append "<script type='text/javascript'>function runchecker()" & CRLF
     vbString.Append "{" & CRLF
     vbString.Append "  if (document.all.WSpell1)" & CRLF
     vbString.Append "  {" & CRLF
     vbString.Append "  document.all.WSpell1.Text = document.getElementById(""messagebody"").value;" & CRLF
     vbString.Append "  document.all.WSpell1.Start;" & CRLF
     vbString.Append "  document.getElementById(""messagebody"").value = document.all.WSpell1.Text;" & CRLF
     vbString.Append "  }" & CRLF
     vbString.Append "  else" & CRLF
     vbString.Append "  {" & CRLF
     vbString.Append "   setTimeout(""runchecker()"",150);" & CRLF
     vbString.Append "  }" & CRLF
     vbString.Append "}" & CRLF
     vbString.Append CRLF & "</script>"
     end if

   case else
     sReplyForm = ""

   end select
   dictEnvironment.add "V-REPLYFORM", vbString.ToString
   vbString.Clear



   ' =========================
   ' GENERATE FLAT VIEW MODE
   ' =========================
   if vThreadInfo(TI_Approved) = 0 and not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) and dictConfiguration.item("bFORCEPOSTVALIDATION") = 1 then

     dictEnvironment.add "V-MESSAGES", "<br/><br/><table align='center' width='95%' class='bbstable' cellspacing='1'><tr><td class='messagecellbody'><br><br><br><div align='center'>" & dictLanguage("THREAD-NEEDSAPPROVAL") & "</div><br/><br/><br></td></tr></table><br>"
     dictEnvironment("C-VIEWMODE") = "flat"
     dictEnvironment("C-CANREPLY") = 0
     dictEnvironment("V-POLLBOX") = ""


   elseif sThreadViewMode = "flat" then

     ' Paging widget

     if dictConfiguration("iFORUMFLATPAGESIZE") > 0 then
       iNumFlatPages = ((vThreadInfo(TI_TotalPosts)-1) \ dictConfiguration("iFORUMFLATPAGESIZE"))+1
       ' Start at the last page, if not explicitly specified
       if iStart = 0 then
         iStart = ((iNumFlatPages-1) * dictConfiguration("iFORUMFLATPAGESIZE"))+1
       end if

       ' Temporarily display all messages, if coming here from a search
       if request.querystring("action") = "search" then
         iStart = 1
         dictConfiguration("iFORUMFLATPAGESIZE") = vThreadInfo(TI_TotalPosts)+1
       end if

       iCurrentPage = int(iStart / dictConfiguration("iFORUMFLATPAGESIZE"))
       sFlatPageBar = dictLanguage("THREAD-5") & " "


       if iNumFlatPages > 6 then

          ' Write the gofirst link
          sFlatPageBar = sFlatPageBar & "<a class='threadlink' href='thread-view.asp?tid=" & BBS.ValidateNumeric(iThreadid) & "&amp;start=1"
          if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
          sFlatPageBar = sFlatPageBar & "'><</a> "

          ' Write some ellipsis
          if iCurrentPage-6 > 0 then sFlatPageBar = sFlatPageBar & " ... "

          ' Find the starting page
          index = BBS.Maximum(iCurrentPage - 6, 0)
          for index = index to iCurrentPage-1
            sFlatPageBar = sFlatPageBar & " <a href='thread-view.asp?tid=" & BBS.ValidateNumeric(iThreadid) & "&amp;start=" & (index * dictConfiguration("iFORUMFLATPAGESIZE"))+1
            if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
            sFlatPageBar = sFlatPageBar & "'>" & (index + 1) & "</a> "
          next

          ' Write the current page
          sFlatPageBar = sFlatPageBar & " " & index + 1 & " "

          ' Write the last pages (up to six)
          ' Find the starting page
          iEndPage= BBS.Minimum(iCurrentPage + 6, iNumFlatPages)
          for index = iCurrentPage+1 to iEndPage - 1
            sFlatPageBar = sFlatPageBar & " <a href='thread-view.asp?tid=" & BBS.ValidateNumeric(iThreadid) & "&amp;start=" & (index * dictConfiguration("iFORUMFLATPAGESIZE"))+1
            if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
            sFlatPageBar = sFlatPageBar & "'>" & (index + 1) & "</a> "
          next

          if iCurrentPage + 6 < iNumFlatPages then sFlatPageBar = sFlatPageBar & " ... "


          ' Write the golast link
          sFlatPageBar = sFlatPageBar & "<a class='threadlink' href='thread-view.asp?tid=" & ithreadid & "&amp;start=" & BBS.ValidateNumeric(dictConfiguration("iFORUMFLATPAGESIZE")) * (iNumFlatPages-1)+1 & "&amp;posts=" & vThreadInfo(TI_TotalPosts)
          if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
          sFlatPageBar = sFlatPageBar & "'>></a> "

       else
           for index = 0 to (iNumFlatPages-1)
             if index = (iNumFlatPages-1) then
               sFlatPageBar = sFlatPageBar & "<a class='threadlink' href='thread-view.asp?tid=" & ithreadid & "&amp;start=" & BBS.ValidateNumeric(dictConfiguration("iFORUMFLATPAGESIZE")) * (index) + 1 & "&amp;posts=" & vThreadInfo(TI_TotalPosts)
               if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
               sFlatPageBar = sFlatPageBar & "'>" & (index + 1) & "</a> "
             else
               sFlatPageBar = sFlatPageBar & "<a class='threadlink' href='thread-view.asp?tid=" & ithreadid & "&amp;start=" & BBS.ValidateNumeric(dictConfiguration("iFORUMFLATPAGESIZE")) * (index) + 1
               if bHighlight then sFlatPageBar = sFlatPageBar & "&amp;highlight=" & server.urlencode(sHighlight) & "&amp;highlightmode=" & iHighlightMode
               sFlatPageBar = sFlatPageBar & "'>" & (index + 1) & "</a> "
             end if
           next
       end if
       sFlatPageBar = sFlatPageBar &  "<br/>" & dictLanguage("THREAD-6") & " " & iCurrentPage+1 & " [" & dictConfiguration("iFORUMFLATPAGESIZE") & " " & dictLanguage("THREAD-7") & "]"
       dictEnvironment("V-FLATPAGING") = sFlatPageBar

       dictEnvironment.add "V-MESSAGES", "<table align='center' width='95%' class='bbstable' cellspacing='" & dictTemplate("CELLSPACING") & "'>" & _
                                         "<tr><td colspan='2' class='messagecellheader'> </td></tr>" & _
                                         Forum.GenerateFlatThread(vForumInfo, vThreadInfo, vUserInfo, iStart-1) & "</table>"
   end if



   ' =========================
   ' GENERATE THREADED VIEW MODE
   ' =========================
   elseif sThreadViewMode = "threaded" then

     if vMessageInfo(MI_Approved) = 0 and not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) and dictConfiguration.item("bFORCEPOSTVALIDATION") = 1 then
       sThreadView = "<br/><br/><table align='center' width='95%' class='bbstable' cellspacing='1'><tr><td class='messagecellbody'><br><br><br><div align='center'>" & dictLanguage("THREAD-NEEDSAPPROVAL") & "</div><br/><br/><br></td></tr></table><br>"
     else
       sThreadView = "<table cellspacing='0' align='center' width='95%'><tr><td>" & Forum.GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1) & "</td></tr><tr><td><br/>"
     end if
     sThreadView = sThreadView & Forum.GenerateThreadedThread (vForumInfo, vThreadInfo, vUserInfo, iMessageID) & "<br/></td></tr></table>"
     dictEnvironment.add "V-MESSAGES", sThreadView

   ' =========================
   ' GENERATE NESTED VIEW MODE
   ' =========================
   elseif sThreadViewMode = "nested" then

   dictEnvironment.add "V-MESSAGES", Forum.GenerateNestedThread (vForumInfo, vThreadInfo, vUserInfo)

   end if

  if dictEnvironment("V-FORUM")(FI_shownavbars) = 1 then
    dictEnvironment("V-FORUMLOCATION") = "&nbsp;<a href='" & dictEnvironment("U-CATEGORYLINK")& "'>" & dictEnvironment("V-CATEGORY")(CA_CategoryName) & "</a>"
    if dictEnvironment("V-CATEGORY")(CA_Locked) = 1 then
      dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & "&nbsp;(<a href='" & dictEnvironment("U-CATEGORYLINKALL") &"'>" & dictLanguage("POST-24") & "</a>)"
    end if
    dictEnvironment("V-FORUMLOCATION") = dictEnvironment("V-FORUMLOCATION") & " -> " & dictEnvironment("V-FORUM")(FI_ForumName) & " -> " & dictLanguage("GLOBAL-LOCATION15")
    dictEnvironment("V-LOCATIONLINKS") = dictEnvironment("V-LOCATIONLINKS") & " -> " & dictLanguage("GLOBAL-LOCATION15")
  end if


%>

<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/forum/thread-view.asp") %>
<!-- #include file="../includes/footer.asp"-->