<%

  ' MegaBBS Calendar API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp

dim Albums
set Albums = new MegaBBSAlbumsAPI

CLASS MegaBBSAlbumsAPI

  function GetAlbumInfoStruct()
    dim vResult(10)
    GetAlbumInfoStruct = vResult
  end function

  function CreateAlbum(byref vAlbumInfo)

    dim SQL, rsAlbumID
    set rsAlbumID = server.createobject("ADODB.Recordset")

    if not(isdate(vAlbumInfo(AI_DateUpdated))) then
      vAlbumInfo(AI_DateUpdated) = sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter
    else
      vAlbumInfo(AI_DateUpdated) = sDateDelimiter & BBS.GetSQLDateTime(vAlbumInfo(AI_DateUpdated)) & sDateDelimiter
    end if

    SQL = "insert into albums (name, description, username, allowusercomments, allowguestcomments, dateupdated, sortorder, commentcount, photocount) values("
    SQL = SQL & "'" & BBS.SQLTrim(vAlbumInfo(AI_Name), 75) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(vAlbumInfo(AI_Description)) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(vAlbumInfo(AI_Username), 50) & "', "
    SQL = SQL & BBS.ValidateNumeric(vAlbumInfo(AI_Allowusercomments)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vAlbumInfo(AI_AllowGuestComments)) & ", "
    SQL = SQL & vAlbumInfo(AI_DateUpdated) & ", "
    SQL = SQL & BBS.ValidateNumeric(vAlbumInfo(AI_SortOrder)) & ",0,0) "
    dbConnection.execute SQL
    BBS.AddQuery(SQL)

    ' Get the new forum id
    rsAlbumID.open "select @@identity", dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsAlbumID.EOF then
      vAlbumInfo(AI_AlbumID) = clng(rsAlbumID.fields(0).value)
      CreateAlbum = vAlbumInfo(AI_AlbumID)
    end if
    rsAlbumID.Close
    set rsAlbumID = nothing
  end function

  function DeleteAlbum(byval iAlbumID)
    dim SQL, rsInfo
    set rsInfo = server.createObject("ADODB.Recordset")

    ' First delete all the photos
    SQL = "select photoid from photos where albumid=" & BBS.validateNumeric(iAlbumID)
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    do until rsInfo.EOF
      DeletePhoto(rsInfo.fields(0).value)
      rsInfo.movenext
    loop
    rsInfo.close
    set rsInfo = Nothing

    SQL = "delete from albums where albumid=" & BBS.validateNumeric(iAlbumID)
    dbConnection.execute SQL
    BBS.AddQuery(SQL)

    DeleteAlbum = True

  end function

  function EditAlbum(byref vAlbumInfo)
    dim SQL

    if not(isdate(vAlbumInfo(AI_DateUpdated))) then
      vAlbumInfo(AI_DateUpdated) = sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter
    else
      vAlbumInfo(AI_DateUpdated) = sDateDelimiter & BBS.GetSQLDateTime(vAlbumInfo(AI_DateUpdated)) & sDateDelimiter
    end if

    SQL = "update albums set "
    SQL = SQL & "name='" & BBS.SQLTrim(vAlbumInfo(AI_Name), 75) & "', "
    SQL = SQL & "description='" & BBS.ValidateSQL(vAlbumInfo(AI_Description)) & "', "
    SQL = SQL & "username='" & BBS.SQLTrim(vAlbumInfo(AI_Username), 50) & "', "
    SQL = SQL & "allowusercomments=" & BBS.ValidateNumeric(vAlbumInfo(AI_Allowusercomments)) & ", "
    SQL = SQL & "allowguestcomments=" & BBS.ValidateNumeric(vAlbumInfo(AI_AllowGuestComments)) & ", "
    SQL = SQL & "dateupdated=" & vAlbumInfo(AI_DateUpdated) & ", "
    SQL = SQL & "sortorder=" & BBS.ValidateNumeric(vAlbumInfo(AI_SortOrder)) & ", "
    SQL = SQL & "photocount=" & BBS.ValidateNumeric(vAlbumInfo(AI_PhotoCount)) & ", "
    SQL = SQL & "commentcount=" & BBS.ValidateNumeric(vAlbumInfo(AI_CommentCount))
    SQL = SQL & " where albumid=" & BBS.ValidateNumeric(vAlbumInfo(AI_AlbumID))
    dbConnection.Execute SQL
    BBS.AddQuery(SQL)

  end function

  function GetAlbumInfo(byval iAlbumID)
    dim vResult, SQL, rsInfo
    vResult= GetAlbumInfoStruct()
    set rsInfo = server.CreateObject("ADODB.Recordset")

    SQL = "select albumid, name, description, username, allowusercomments, allowguestcomments, dateupdated, sortorder, photocount, commentcount from albums where albumid=" & BBS.ValidateNumeric(iAlbumID)
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not(rsInfo.EOF) then
      vResult(AI_AlbumID)             = rsInfo.fields(0).value
      vResult(AI_Name)                = rsInfo.fields(1).value
      vResult(AI_Description)         = rsInfo.fields(2).value
      vResult(AI_Username)            = rsInfo.fields(3).value
      vResult(AI_AllowUserComments)   = rsInfo.fields(4).value
      vResult(AI_AllowGuestComments)  = rsInfo.fields(5).value
      vResult(AI_DateUpdated)         = rsInfo.fields(6).value
      vResult(AI_SortOrder)           = rsInfo.fields(7).value
      vResult(AI_PhotoCount)          = rsInfo.fields(8).value
      vResult(AI_CommentCount)        = rsInfo.fields(9).value
    else
      vResult(AI_AlbumID) = -1
    end if

    rsInfo.Close
    set rsInfo = nothing
    GetAlbumInfo = vResult

  end function

  function GetNumberOfPhotos(byval iAlbumID)
    ' DESCRIPTION: Returns the number of photos in an album
    ' INPUTS     : An album ID
    ' RETURNS    : The number of photos

    dim SQL, rsPhotoCount
    set rsPhotoCount = server.Createobject("ADODB.Recordset")

    SQL = "select count(*) as totalcount from photos where albumid=" & BBS.ValidateNumeric(iAlbumID)
    rsPhotoCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    GetNumberOfPhotos = rsPhotoCount.Fields(0).value
    rsPhotoCount.close
    set rsPhotoCount = nothing
  end function

  function GetNumberOfComments(iPhotoID)
    ' DESCRIPTION : Returns the number of comments from a photo

    dim rsPhotoComments, SQL
    set rsPhotoComments = server.CreateObject("ADODB.Recordset")

    SQL = "select count(*) as commentcount from photocomments where photoid=" & BBS.ValidateNumeric(iPhotoID)
    rsPhotoComments.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not(rsPhotoComments.EOF) then
      GetNumberOfComments = rsPhotoComments.fields(0).value
    else
      GetNumberOfComments = 0
    end if
    rsPhotoComments.close
    set rsPhotoComments = nothing
  end function

  function GetNumberOfAlbumComments(iAlbumID)
    ' DESCRIPTION : Returns the number of comments in an album

    dim rsAlbumComments, SQL
    set rsAlbumComments = server.CreateObject("ADODB.Recordset")
    SQL = "select count(photocomments.photoid) as commentcount FROM photocomments, photos where photos.photoid=photocomments.photoid AND photos.albumid=" & BBS.ValidateNumeric(iAlbumID)
    rsAlbumComments.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    GetNumberOfAlbumComments = rsAlbumComments.fields(0).value
    rsAlbumComments.close
    set rsAlbumComments = nothing
  end function

  function GetPhotoInfoStruct()
    dim result(10)
    GetPHotoInfoStruct = result
  end function

  function GetPhotoInfo(iPhotoID)
    ' DESCRIPTION : Returns some information about a photo

    dim rsPhoto, SQL, vResult
    set rsPhoto = server.createobject("adodb.Recordset")

    vResult = GetPhotoInfoStruct()
    SQL = "select photoid, albumid, dateuploaded, username, filename, description, timesviewed from photos where photoid=" & BBS.ValidateNumeric(iPhotoID)
    rsPhoto.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not(rsPhoto.EOF) then
      vResult(PI_PhotoID)      = rsPhoto.fields(0).value
      vResult(PI_AlbumID)      = rsPhoto.fields(1).value
      vResult(PI_DateUploaded) = rsPhoto.fields(2).value
      vResult(PI_Username)     = rsPhoto.fields(3).value
      vResult(PI_Filename)     = rsPhoto.fields(4).value
      vResult(PI_Description)  = rsPhoto.fields(5).value
      vResult(PI_TimesViewed)  = rsPhoto.fields(6).value
    else
      vResult(PI_PhotoID)      = -1
    end if
    GetPhotoInfo = vResult
    rsPhoto.close
    set rsPhoto = nothing

  end function

  function IncreaseViewCount(byval iPhotoID)
    ' DESCRIPTION : Increases a photo's viewcount by one
    dim SQL
    SQL = "update photos set timesviewed=timesviewed+1 where photoid=" & BBS.ValidateNumeric(iPhotoID)
    dbConnection.execute SQL
    BBS.AddQuery(SQL)
  end function

  function DeletePhoto(byval iPhotoID)
    ' DESCRIPTION : Deletes a photo
    dim fsoImage, rsInfo, sGUID, SQL

    set fsoImage = server.createobject("Scripting.FilesystemObject")
    set rsInfo = server.createobject("ADODB.Recordset")

    SQL = "select photoid, fileguid from photos where photoid=" & BBS.ValidateNumeric(iPhotoID)
    rsInfo.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsInfo.EOF then
      sGUID = rsInfo.fields("fileguid").value
    end if
    rsInfo.Close
    set rsInfo=Nothing

    iPhotoID = BBS.ValidateNumeric(iPhotoID)

    on error resume next
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & sGUID)
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".jpg")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".jpg")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".jpeg")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".gif")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".bmp")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "f" & ".png")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "t" & ".jpg")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "t" & ".jpeg")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "t" & ".gif")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "t" & ".bmp")
    FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & iPhotoID & "t" & ".png")
    on error goto 0

    dbConnection.execute "delete from photos where photoid=" & BBS.ValidateNumeric(iPhotoID)
    dbConnection.execute "delete from photocomments where photoid=" & BBS.ValidateNumeric(iPhotoID)


  end function

END CLASS

%>