<%

  ' MegaBBS Alerts API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp, include-forums.asp

dim Alerts
set Alerts = new MegaBBSAlertsAPI

CLASS MegaBBSAlertsAPI

  Function GetAlertInfoStruct()
    ' DESCRIPTION : Returns an alert information structure

    dim vResult(7)
    GetAlertInfoStruct = vResult
  end function

  Function GetAlertInfo(byval iAlertID)
    ' DESCRIPTION : Gets information about an alert
    ' INPUTS      : iAlertID - an alert ID
    ' RETURNS     : An AlertInfo structure

    dim vResult, rsAlertInfo, sKey, SQL, vAlertInfo
    vResult = GetAlertInfoStruct
    set rsAlertInfo = server.createobject("ADODB.Recordset")
    iAlertID = BBS.ValidateNumeric(iAlertID)
    sKey = "AL-" & iAlertID

    GetAlertInfo = BBS.Cache(sKey)
    if not isEmpty(GetAlertInfo) then
      iBBSCachedHits = iBBSCachedHits + 1
      exit function
    end if

    SQL = "select alerts.alertid, alerts.type, alerts.messageid, alerts.memberid, alerts.approved, alerts.reported, alerts.message from alerts where alertid=" & BBS.ValidateNumeric(iAlertID)
    rsAlertInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsAlertInfo.eof then
      vAlertInfo = rsAlertInfo.getrows
      rsAlertInfo.close
      vResult(AL_AlertID)   = BBS.ValidateNumeric(vAlertInfo(0, 0))
      vResult(AL_Type)      = BBS.ValidateNumeric(vAlertInfo(1, 0))
      vResult(AL_MessageID) = BBS.ValidateNumeric(vAlertInfo(2, 0))
      vResult(AL_MemberID)  = BBS.ValidateNumeric(vAlertInfo(3, 0))
      vResult(AL_Approved)  = BBS.ValidateBoolean(vAlertInfo(4, 0))
      vResult(AL_Reported)  = vAlertInfo(5, 0)
      vResult(AL_Message)   = trim(vAlertInfo(6, 0))
    else
      rsAlertInfo.close
      vResult(AL_AlertID) = -1
    end if
    set rsAlertInfo = nothing

    GetAlertInfo = vResult
    BBS.CacheAdd sKey, vResult
  end function

  Function CreateAlert(byref vAlertInfo)
    ' DESCRIPTION : Creates a new alert
    ' INPUTS      : vAlertInfo - an AlertInfo structure
    ' RETURNS     : The ID of the newly created alert
    ' NOTES       : Ignores AL_AlertID

    dim SQL, rsAlertID

    SQL = "insert into alerts(messageid, type, memberid, approved, reported, message) values("
    SQL = SQL & BBS.ValidateNumeric(vAlertInfo(AL_MessageID)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vAlertInfo(AL_Type)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vAlertInfo(AL_MemberID)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vAlertInfo(AL_Approved)) & ", "
    SQL = SQL & sDateDelimiter & BBS.GetSQLDateTime(vAlertInfo(AL_Reported)) & sDateDelimiter & ", '"
    SQL = SQL & BBS.ValidateSQL(vAlertInfo(AL_Message)) & "')"
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Get new ID number
    set rsAlertID = server.createobject("ADODB.Recordset")
    SQL = "select @@identity"
    rsAlertID.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsAlertID.eof then
      vAlertInfo(AL_AlertID) = clng(rsAlertID.fields(0).value)
      CreateAlert = vAlertInfo(AL_AlertID)
    end if
    rsAlertID.close
    set rsAlertID = nothing
    vAlertInfo(AL_Approved) = 0
  end function

  Function UpdateAlert(byref vAlertInfo)
    ' DESCRIPTION : Updates an alert
    ' INPUTS      : An AlertInfo structure
    ' RETURNS     : True if successful, false otherwise
    ' NOTES       : AL_AlertID is used to specify what alert to update

    dim sKey, SQL
    sKey = "AL-" & vAlertInfo(AL_AlertID)

    SQL = "update alerts set messageid=" & BBS.ValidateNumeric(vAlertInfo(AL_MessageID)) & ", type=" & BBS.ValidateNumeric(vAlertInfo(AL_Type)) & ", memberid=" & BBS.ValidateNumeric(vAlertInfo(AL_MemberID)) & ", approved=" & BBS.ValidateBoolean(vAlertInfo(AL_Approved))
    SQL = SQL & ", reported=" & sDateDelimiter & BBS.GetSQLDateTime(vAlertInfo(AL_Reported)) & sDateDelimiter & ", message='" & BBS.ValidateSQL(vAlertInfo(AL_Message)) & "' where alertid=" & BBS.ValidateNumeric(vAlertInfo(AL_AlertID))
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)
  end function

  Function DeleteAlertByID(byval iAlertID)
    ' DESCRIPTION : Deletes an alert
    ' INPUTS      : An Alert ID

    dim SQL, sKey
    sKey = "AL-" & iAlertID

    SQL = "delete from alerts where alertid=" & BBS.ValidateNumeric(iAlertID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    BBS.CacheDelete(sKey)
  end function

  Function DeleteAlertByMessageID(byval iType, byval iMessageID)
    ' DESCRIPTION : Deletes an alert based on message ID.
    ' INPUTS      : The alert type
    '             : The message ID

    dim SQL

    SQL = "delete from alerts where type=" & BBS.ValidateNumeric(iType) & " and messageid=" & BBS.ValidateNumeric(iMessageID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    BBS.CacheDeleteType("AL-")
  end function

  Function DeleteAlertByMemberID(byval iType, byval iMemberID)
    ' DESCRIPTION : Deletes an alert based on member ID.
    ' INPUTS      : The alert type
    '             : The member ID

    dim SQL

    SQL = "delete from alerts where type=" & BBS.ValidateNumeric(iType) & " and memberid=" & BBS.ValidateNumeric(iMemberID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    BBS.CacheDeleteType("AL-")
  end function

  sub ResetMessageAlert(byval iMessageID)
    ' DESCRIPTION : Typically this function is called after editing a message
    '             : If the message has been previously approved, editing the message causes
    '             : successful approvals to be removed, allowing the message to be re-alerted.
    '             : Outstanding alerts are preserved
    ' INPUTS      : The message ID

    dim SQL

    SQL = "delete from alerts where type=" & ALERT_BadPost & " and messageid=" & BBS.ValidateNumeric(iMessageID) & " and approved=1"
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
  end sub

  Function HasAlertedMessage(byref iMessageID, byref iMemberID)
    ' DESCRIPTION : Checks if a user has already made an alert about a post
    ' INPUTS      : A message ID and a member ID
    ' RETURNS     : A boolean value

    dim SQL, rsCheck
    SQL = "select memberid from alerts where messageid=" & BBS.ValidateNumeric(iMessageID) & " and memberid=" & BBS.ValidateNumeric(iMemberID) & " and type=" & ALERT_BadPost
    set rsCheck = server.createobject("ADODB.Recordset")
    rsCheck.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if rsCheck.eof then
      HasAlertedMessage = 0
    else
      HasAlertedMessage = 1
    end if
    rsCheck.close
    BBS.AddQuery(SQL)
    set rsCheck = nothing
  end function

  Function IsMessageApproved(byref iMessageID)
    ' DESCRIPTION : Checks if a message has been approved by a moderator
    ' INPUTS      : A message ID
    ' RETURNS     : A boolean value

    dim SQL, rsCheck
    SQL = "select messageid from alerts where messageid=" & BBS.ValidateNumeric(iMessageID) & " and approved=1 and type=" & ALERT_BadPost
    set rsCheck = server.createobject("ADODB.Recordset")
    rsCheck.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if rsCheck.eof then
      IsMessageApproved = 0
    else
      IsMessageApproved = 1
    end if
    rsCheck.close
    BBS.AddQuery(SQL)
    set rsCheck = nothing
  end function

  Function GetWhyMessageApproved(byref iMessageID)
    ' DESCRIPTION : Gets the reason why a message was approved
    ' INPUTS      : A message ID
    ' RETURNS     : The reason

    dim SQL, rsReason
    SQL = "select message from alerts where messageid=" & BBS.ValidateNumeric(iMessageID) & " and approved=1 and type=" & ALERT_BadPost
    set rsReason = server.createobject("ADODB.Recordset")
    rsReason.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if not rsReason.eof then
      GetWhyMessageApproved = BBS.ValidateField(rsReason.fields(0).value)
    end if
    rsReason.close
    BBS.AddQuery(SQL)
    set rsReason = nothing
  end function

  Function GetAlertList(byref iType)
    ' DESCRIPTION : Gets a list of unapproved alert IDs for a certain type of alert.
    ' INPUTS      : The alert type
    ' RETURNS     : An array of alert IDs. Will have ubound() = -1 if there are no alerts.
    ' NOTES       : If iType = ALERT_NewPost or iType = ALERT_BadPost will only return results for forums the current user
    '               has moderator permissions in.

    dim SQL, SQLFragment, rsAlerted, vAlerted, vReturn, index
    set rsAlerted = server.createobject("ADODB.Recordset")

    ' Generate SQL query based on alert type. If neccessary, we'll
    ' find each forum that they have moderator permissions on.



    ' Temporarily commenting this out until we can figure out how to get the alert count correct in the header's infobox


    'if (iType = ALERT_NewPost or iType = ALERT_BadPost) and (iBBSUserLevel < USERLEVEL_SupportAdministrator) then

    '  SQL = "select forumid from forums"
    '  rsAlerted.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    '  do while not rsAlerted.eof
    '    if BBS.GetUserLevel(MODULE_Forums, rsAlerted.fields(0).value) >= USERLEVEL_Moderator then SQLFragment = SQLFragment & BBS.ValidateNumeric(rsAlerted.fields(0).value) & ", "
    '    rsAlerted.movenext
    '  loop

    '  rsAlerted.close
    '  BBS.AddQuery(SQL)

    '  if len(SQLFragment) > 0 then
    '    SQLFragment = left(SQLFragment, len(SQLFragment) - 2)
    '  else
    '    SQLFragment = "-1"
    '  end if

    '  SQL = "select alerts.alertid from alerts, messages, threads where alerts.approved=0 and alerts.type=" & BBS.ValidateNumeric(iType) & " and messages.messageid = alerts.messageid and messages.threadid = threads.threadid and threads.forumid in (" & SQLFragment & ") order by alerts.reported asc"

    'else

      SQL = "select alertid from alerts where approved=0 and type=" & BBS.ValidateNumeric(iType) & " order by reported asc"

    'end if

    ' Get alert IDs
    rsAlerted.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not rsAlerted.eof then

      vAlerted = rsAlerted.getrows
      rsAlerted.close
      redim vReturn(ubound(vAlerted, 2))
      for index = 0 to ubound(vAlerted, 2)
        vReturn(index) = vAlerted(0, index)
      next

    else

      rsAlerted.close
      redim vReturn(-1)

    end if

    BBS.AddQuery(SQL)
    set rsAlerted = nothing
    GetAlertList = vReturn
  end function

  Function GetAlertListByMessageID(byref iType, byref iMessageID)
    ' DESCRIPTION : Gets a list of unapproved alert IDs by message ID.
    ' INPUTS      : The alert type
    '               The message ID
    ' RETURNS     : An array of alert IDs. Will have ubound() = -1 if there are no alerts.
    ' NOTES       : If iType = ALERT_NewPost or iType = ALERT_BadPost will only return results for forums the current user
    '               has moderator permissions in.

    dim SQL, SQLFragment, rsAlerted, vAlerted, vReturn, index
    set rsAlerted = server.createobject("ADODB.Recordset")

    ' Generate SQL query based on alert type. If neccessary, we'll
    ' find each forum that they have moderator permissions on.
    if (iType = ALERT_NewPost or iType = ALERT_BadPost) and (iBBSUserLevel < USERLEVEL_SupportAdministrator) then

      SQL = "select forumid from forums"
      rsAlerted.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      do while not rsAlerted.eof
        if BBS.GetUserLevel(MODULE_Forums, rsAlerted.fields(0).value) >= USERLEVEL_Moderator then SQLFragment = SQLFragment & rsAlerted.fields(0).value & ", "
        rsAlerted.movenext
      loop
      rsAlerted.close
      BBS.AddQuery(SQL)

      if len(SQLFragment) > 0 then
        SQLFragment = left(SQLFragment, len(SQLFragment) - 2)
      else
        SQLFragment = "-1"
      end if

      SQL = "select alerts.alertid from alerts, messages, threads where alerts.approved=0 and alerts.type=" & BBS.ValidateNumeric(iType) & " and alerts.messageid=" & BBS.ValidateNumeric(iMessageID) & " and messages.messageid = alerts.messageid and messages.threadid = threads.threadid and threads.forumid in (" & SQLFragment & ") order by reported asc"

    else

      SQL = "select alertid from alerts where approved=0 and type=" & BBS.ValidateNumeric(iType) & " and messageid=" & BBS.ValidateNumeric(iMessageID) & " order by reported asc"

    end if

    ' Get alert IDs
    rsAlerted.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if not rsAlerted.eof then
      vAlerted = rsAlerted.getrows
      rsAlerted.close
      redim vReturn(ubound(vAlerted, 2))
      for index = 0 to ubound(vAlerted, 2)
        vReturn(index) = vAlerted(0, index)
      next
    else
      rsAlerted.close
      redim vReturn(-1)
    end if
    BBS.AddQuery(SQL)
    set rsAlerted = nothing
    GetAlertListByMessageID = vReturn
  end function

  Function GenerateAlertBox(byref vAlert)
    ' DESCRIPTION : Generates an alert information box for an alert
    ' INPUTS      : An alert information structure
    ' RETURNS     : The HTML display for the alert
    ' NOTES       : Will choose the appropriate fragment template (alert-badpost.asp, alert-newpost.asp or
    '               alert-newuser.asp)
    '               Will build up all alerts for a bad post (sorted by date alerted)

    if vAlert(AL_AlertID) = -1 then exit function

    ' Decide on which template to use
    if vAlert(AL_Type) = ALERT_BadPost then
      dim vAlertList, index

      ' Get list of alerts for the entire message
      vAlertList = GetAlertListByMessageID(ALERT_BadPost, vAlert(AL_MessageID))

      ' Generate each alert details
      for index = 0 to ubound(vAlertList)

        dictEnvironment.item("V-ALERTINFO") = GetAlertInfo(vAlertList(index))
        Filesystem.ExecuteFragmentTemplate("/alert-badpost.asp")
        GenerateAlertBox = GenerateAlertBox & sBBSFragmentOutput
        sBBSFragmentOutput = ""

      next

    elseif vAlert(AL_Type) = ALERT_NewPost then

      dictEnvironment.item("V-ALERTINFO") = vAlert
      Filesystem.ExecuteFragmentTemplate("/alert-newpost.asp")
      GenerateAlertBox = sBBSFragmentOutput
      sBBSFragmentOutput = ""

    elseif vAlert(AL_Type) = ALERT_NewUser then
      dictEnvironment.item("V-ALERTINFO") = vAlert
      dictEnvironment.item("V-USERINFO") = BBS.GetUserInfoByID(vAlert(AL_MemberID))
      Filesystem.ExecuteFragmentTemplate("/alert-newuser.asp")
      GenerateAlertBox = sBBSFragmentOutput
      sBBSFragmentOutput = ""

    else
      GenerateAlertBox = ""
    end if
  end function

  Sub ApproveMessage(byref iMessageID, byref sReason)
    ' DESCRIPTION : Approves a message
    ' INPUTS      : A message ID and a reason for approving it

    dim SQL, vApprove
    iMessageID = BBS.ValidateNumeric(iMessageID)

    ' Delete all alerts of it
    SQL = "delete from alerts where type=" & ALERT_BadPost & " and messageid=" & BBS.ValidateNumeric(iMessageID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Insert reason for approving
    vApprove = GetAlertInfoStruct
    vApprove(AL_Type)      = ALERT_BadPost
    vApprove(AL_MessageID) = iMessageID
    vApprove(AL_MemberID)  = iBBSMemberID
    vApprove(AL_Approved)  = 1
    vApprove(AL_Reported)  = now()
    vApprove(AL_Message)   = sReason
    CreateAlert(vApprove)
  end sub
END CLASS
%>