<%

  ' MegaBBS Calendar API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp

dim Calendar
set Calendar = new MegaBBSCalendarAPI

CLASS MegaBBSCalendarAPI

  function CreateCalendar(byref stCalendarInfoStruct)
    ' DESCRIPTION : Creates a calendar
    ' INPUTS      : A calendarinfo structure
    ' RETURNS     : The newly created calendarid

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into calendars(calendarname, description) values("
    SQL = SQL & "'" & BBS.SQLTrim(stCalendarInfoStruct(CI_CalendarName), 50) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(stCalendarInfoStruct(CI_Description)) & "')"

    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "select @@IDENTITY"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)
    if rsNewID.EOF then
      CreateCalendar = 0
    else
      CreateCalendar = clng(rsNewID.fields(0).value)
    end if
    rsNewID.Close
  end function

  function DeleteCalendar(byref iCalendarID)
    ' DESCRIPTION : Deletes a calendar
    ' INPUTS      : A calendarid
    ' RETURNS     : True if successful

    dim SQL, sKey
    sKey = "CI-" & iCalendarID

    SQL = "delete from calendars where calendarid=" & BBS.ValidateNumeric(iCalendarID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    DeleteCalendar = True

    ' Delete this item from the cache
    BBS.CacheDelete sKey

  end function

  function EditCalendar(byref stCalendarInfoStruct)
    ' DESCRIPTION : Updates a calendar
    ' INPUTS      : A calendarinfo structure
    ' RETURNS     : True if successful

    dim SQL, sKey
    sKey = "CI-" & stCalendarInfoStruct(CI_CalendarID)

    SQL = "update calendars set calendarname='" & BBS.SQLTrim(stCalendarInfoStruct(CI_CalendarName), 50) & "', "
    SQL = SQL & "description='" & BBS.ValidateSQL(stCalendarInfoStruct(CI_Description)) & "' where "
    SQL = SQL & "calendarid=" & BBS.ValidateNumeric(stCalendarInfoStruct(CI_CalendarID))

    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    EditCalendar = True

    ' Delete this item from the cache
    BBS.CacheDelete sKey
  end function

  function IsSignedUp(byval iEventID, byval iUnavailable)
    ' DESCRIPTION : Checks if the user is signed up for a calendar event
    '             : iEventID - EventID
    ' RETURNS     : True or False

    dim rsSignup, SQL

    set rsSignup = server.createobject("ADODB.Recordset")
    iEventID = BBS.ValidateNumeric(iEventID)

    SQL = "select memberid from signups where calendareventid=" & BBS.ValidateNumeric(iEventID) & " and memberid=" & BBS.ValidateNumeric(iBBSMemberID) & " and unavailable=" & BBS.ValidateNumeric(iUnavailable)
    rsSignup.open SQL, dbconnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    IsSignedUp = not(rsSignup.EOF)
    set rsSignup = nothing
  end function

  function DeleteSignup(byval iEventID)
    dim SQL
    SQL = "delete from signups where calendareventid=" & BBS.ValidateNumeric(iEventID) & " and memberid=" & BBS.ValidateNumeric(iBBSMemberID)
    dbConnection.execute SQL,, adTextNoRecords
  end function

  function AddSignup(byval iEventID, byval iUnavailable)
    dim SQL

    if not(isSignedUp(iEventID,iUnavailable)) then
      SQL = "insert into signups (calendareventid, memberid, unavailable) values(" & BBS.ValidateNumeric(iEventID) & ", " & BBS.ValidateNumeric(iBBSMemberID) & "," & BBS.ValidateNumeric(iUnavailable) & ")"
      dbConnection.Execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
      AddSignup= True
    else
      AddSignup= False
    end if
  end function

  function ListSignups(byval iEventID, byval iUnavailable)
    dim SQL, sResult, rsInfo, sOutput
    set rsInfo = server.createobject("ADODB.Recordset")

    SQL = "select username, signups.memberid from signups, members where signups.memberid=members.memberid and calendareventid=" & BBS.ValidateNumeric(iEventID) & " and unavailable=" & BBS.ValidateNumeric(iUnavailable)
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.ADDQUery(SQL)
    do until rsInfo.EOF
      sOutput = sOutput & BBS.Createusernamelinkbyid(rsInfo.fields("memberid").value) & BBS.ValidateField(rsInfo.fields("username").value) & "</a>, "
      rsInfo.movenext
    loop
    rsInfo.Close
    if len(sOutput) > 2 then sOutput = left(sOutput, len(sOutput)-2)
    ListSignups = sOutput
  end function

function ListDateEvents(byref iCalendarID, byVal dStartDate, byVal dEndDate, byref iNumEvents)

  ' DESCRIPTION : Returns a listing of calendar events for the specified date range
  ' INPUTS      : NumEvents   - Number of events that were returned, the size of the resulting array
  '             : calendarid  - calendarid, '-1' returns events from all calendars
  '             : Startdate
  '             : EndDate     - Inclusive daterange to search, supply these arguments in your server's default regional format
  '             :               Or if you must type in the date, run the value through BBS.ParseDate() first
  ' RETURNS     : A DateInfo array



  dim vFuncResult()
  dim SQL, dCounterDate, rsSingle, rsYearly, rsMonthly, rsWeekly, rsDaily, iUserLevel
  dim rsCalendarList, sCalendarList, bIncludeCalendar, bNoDaily, vCalendarInfoStruct, bCanView, vEventInfoStruct, sKey
  dim vResult

  sKEY = "LDE-" & iBBSMemberID & "-" & icalendarID & "-" & datevalue(dStartDate) & "-" & datevalue(dEndDate)
  vResult = BBS.Cache(sKEY)
  if not(isempty(vResult)) then
    if isArray(vResult) then
      iNumEvents = ubound(vResult)+1
    else
      iNumEvents = 0
    end if
    ListDateEvents = vResult
    iBBSCachedHits = iBBSCachedHits + 5
    exit function
  end if

  iNumEvents = 0

  ' Initialize important variables
  set rsCalendarList = Server.CreateObject("ADODB.Recordset")
  set rsDaily        = Server.CreateObject("ADODB.Recordset")
  set rsSingle       = Server.CreateObject("ADODB.Recordset")
  set rsYearly       = Server.CreateObject("ADODB.Recordset")
  set rsMonthly      = Server.CreateObject("ADODB.Recordset")
  set rsWeekly       = Server.CreateObject("ADODB.Recordset")

  dStartDate       = cdate(dStartDate)
  dEndDate         = cdate(dEndDate)
  dCounterDate     = dStartDate
  iNumEvents       = 0
  bNoDaily         = 0


  if iCalendarID > 0 then
    if not(BBS.HasPermission(PERM_Calendaraccess, iCalendarID)) then
      exit function
    else
      sCalendarList = "calendarid = " & BBS.ValidateSQL(icalendarID)
    end if
  else
    ' Get a list of calendars the user can view
    SQL = "select calendarid from calendars"
    rsCalendarList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    do until rsCalendarList.EOF
      if (BBS.HasPermission(PERM_Calendaraccess, rsCalendarlist.fields(0).value)) then
        ' Add it to the list
        if len(trim(sCalendarList)) > 0 then sCalendarList = sCalendarList & " OR "
        sCalendarList = sCalendarList & "calendarid = " & rsCalendarList.fields(0).value
      end if
      rsCalendarList.MoveNext
    loop
    rsCalendarList.Close
    set rsCalendarList = Nothing

    ' If no calendars were selected, then just exit the function
    if len(trim(sCalendarList)) = 0 then exit function
	end if

  ' So far so good, construct a SQL statement to return all the events we need.
    SQL = "select calendareventid, private, owner, day, year, month, calendarid "
    SQL = SQL & " from calendarsevents "
    SQL = SQL & " where " & sCalendarList & " and recurrence='none' and singledate >=" & sDateDelimiter & BBS.GetSQLDate(dStartDate) & sDateDelimiter
    SQL = SQL & " and singledate<=" & sDateDelimiter & BBS.GetSQLDate(dEndDate) & sDateDelimiter
    SQL = SQL & " order by timeofdaymeridian, timeofdayhour, timeofdayminute"
    rsSingle.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)

    SQL = "select calendarid, calendareventid, private, owner, hasdaterange, startdaterange, enddaterange, day, month from calendarsevents where (" & sCalendarList & ") and recurrence='yearly' order by timeofdaymeridian, timeofdayhour, timeofdayminute"
    rsYearly.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)

    SQL = "select calendarid, calendareventid, private, owner, hasdaterange, startdaterange, enddaterange, day from calendarsevents where (" & sCalendarList & ") and recurrence='monthly' order by timeofdaymeridian, timeofdayhour, timeofdayminute"
    rsMonthly.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)

    SQL = "select calendarid, calendareventid, private, owner, hasdaterange, startdaterange, enddaterange, weekday from calendarsevents where (" & sCalendarList & ") and recurrence='weekly' order by timeofdaymeridian, timeofdayhour, timeofdayminute"
    rsWeekly.open SQL, dbconnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)

    SQL = "select calendarid, calendareventid, private, owner, hasdaterange, startdaterange, enddaterange from calendarsevents where (" & sCalendarList & ") and recurrence='daily' order by timeofdaymeridian, timeofdayhour, timeofdayminute"
    rsDaily.open SQL, dbconnection, adOpenStatic, adLockReadOnly
    BBS.AddQuery(SQL)
    if rsDaily.EOF then bNoDaily = 1

    do until cdate(dCounterDate) > cdate(dEndDate)

      rsSingle.Filter  = "day= " & day(dCounterDate) & " and year= " & year(dCounterDate) & " and month= " & month(dCounterDate)
      rsWeekly.Filter  = "weekday='" & weekday(dCounterDate) & "'"
      rsYearly.Filter  = "day= " & day(dCounterDate) & " and month= " & month(dCounterDate)
      if bNoDaily = 0 then rsDaily.MoveFirst

      ' If a month ends before 31 days, we need to include any 'leftover' monthly recurring events
      if month(DateAdd("d", 1, dCounterDate)) > month(dCounterDate) then
        rsMonthly.Filter = "day >= " & day(dCounterDate)
      else
        rsMonthly.Filter = "day = " & day(dCounterDate)
      end if
      ' response.write dCounterDate
      do until (rsSingle.EOF)

        ' Can we view this event?
        bCanView = (rsSingle.fields("private")=0) or _
        ucase(rsSingle.Fields("owner").Value) = ucase(sBBSUsername) or _
        BBS.HasPermission(PERM_viewotherprivateevents, rsSingle.fields("calendarid").value)

        if bCanView then
          vEventInfoStruct = GetEventInfoStruct()
          vEventInfoStruct = GetEventInfo(rsSingle.fields("calendareventid"))
          vEventInfoStruct(CEV_META_Date) = dCounterDate

          redim preserve vFuncResult(iNumEvents)

          vFuncResult(iNumEvents) = vEventInfoStruct
          iNumEvents = iNumEvents + 1

        end if

        rsSingle.movenext

      loop

      do until (rsWeekly.EOF)
        ' Can we view this event?
        bCanView = (rsWeekly.fields("private")=0) or _
        ucase(rsWeekly.Fields("owner").Value) = ucase(sBBSUsername) or _
        BBS.HasPermission(PERM_viewotherprivateevents, rsWeekly.fields("calendarid").value)

        if bCanView and (rsWeekly("hasdaterange") = 0) or (dCounterDate >= rsWeekly("startdaterange") and dCounterDate <= rsWeekly("enddaterange") ) then
          vEventInfoStruct = GetEventInfo(rsWeekly.fields("calendareventid"))
          vEventInfoStruct(CEV_META_Date) = dCounterDate

          redim preserve vFuncResult(iNumEvents)
          vFuncResult(iNumEvents) = vEventInfoStruct
          iNumEvents = iNumEvents + 1
        end if
        rsWeekly.movenext
      loop

      do until (rsMonthly.EOF)

        ' Can we view this event?
        bCanView = (rsMonthly.fields("private")=0) or _
        ucase(rsMonthly.Fields("owner").Value) = ucase(sBBSUsername) or _
        BBS.HasPermission(PERM_viewotherprivateevents, rsMonthly.fields("calendarid").value)

        if bCanView and (rsMonthly("hasdaterange") = 0) or (dCounterDate >= rsMonthly("startdaterange") and dCounterDate <= rsMonthly("enddaterange") ) then
          vEventInfoStruct = GetEventInfo(rsMonthly.fields("calendareventid"))
          vEventInfoStruct(CEV_META_Date) = dCounterDate

          redim preserve vFuncResult(iNumEvents)
          vFuncResult(iNumEvents) = vEventInfoStruct
          iNumEvents = iNumEvents + 1
        end if
        rsMonthly.movenext
      loop

      do until (rsYearly.EOF)

        ' Can we view this event?
        bCanView = (rsYearly.fields("private")=0) or _
        ucase(rsYearly.Fields("owner").Value) = ucase(sBBSUsername) or _
        BBS.HasPermission(PERM_viewotherprivateevents, rsYearly.fields("calendarid").value)

        if bCanView and (rsYearly("hasdaterange") = 0) or (dCounterDate >= rsYearly("startdaterange") and dCounterDate <= rsYearly("enddaterange") ) then
          vEventInfoStruct = GetEventInfo(rsYearly.fields("calendareventid"))
          vEventInfoStruct(CEV_META_Date) = dCounterDate

          redim preserve vFuncResult(iNumEvents)
          vFuncResult(iNumEvents) = vEventInfoStruct
          iNumEvents = iNumEvents + 1
        end if
        rsYearly.movenext
      loop

      do until (rsDaily.EOF)

        ' Can we view this event?
        bCanView = (rsDaily.fields("private")=0) or _
        ucase(rsDaily.Fields("owner").Value) = ucase(sBBSUsername) or _
        BBS.HasPermission(PERM_viewotherprivateevents, rsDaily.fields("calendarid").value)

        if bCanView and (rsDaily("hasdaterange") = 0) or (dCounterDate >= rsDaily("startdaterange") and dCounterDate <= rsDaily("enddaterange") ) then
          vEventInfoStruct = GetEventInfo(rsDaily.fields("calendareventid"))
          vEventInfoStruct(CEV_META_Date) = dCounterDate

          redim preserve vFuncResult(iNumEvents)
          vFuncResult(iNumEvents) = vEventInfoStruct
          iNumEvents = iNumEvents + 1
        end if
        rsDaily.movenext
      loop

      dCounterDate = DateAdd("d", 1, dCounterDate)
  loop


  if iNumEvents = 0 then
    BBS.CacheAdd sKEY, "-1"
  else
    BBS.CacheAdd sKEY, vFuncResult
  end if

  ListDateEvents     = vFuncResult
  set rsCalendarList = Nothing
  set rsDaily        = Nothing
  set rsSingle       = Nothing
  set rsYearly       = Nothing
  set rsMonthly      = Nothing
  set rsWeekly       = Nothing
end function

  function GetEventInfoStruct()
    ' DESCRIPTION : Returns a calendar EventInfo structure
    dim vResult(22)
    GetEventInfoStruct = vResult
  end function

  function GetEventInfo (byVal iCalendarEvent)
    ' DESCRIPTION : Gets an event info

    dim vFuncResult, rsCalendarEvent, SQL

    set rsCalendarEvent = server.CreateObject("ADODB.Recordset")
    vFuncResult         = GetEventInfoStruct
    iCalendarEvent      = BBS.ValidateNumeric(iCalendarEvent)

    SQL = "Select calendarid, owner, weekday, singledate, day, "   '0-4
    SQL = SQL & "month, year, recurrence, private, ownerstatus, "  '5-9
    SQL = SQL & "alldayevent, timeofdayhour, timeofdayminute, timeofdaymeridian, " '10-13
    SQL = SQL & "hasdaterange, startdaterange, enddaterange, allowsignups, "       '14-17
    SQL = SQL & "shortdesc, longdesc " '18-19
    SQL = SQL & "from calendarsevents where calendarsevents.calendareventid=" & BBS.ValidateSQL(iCalendarEvent)
    rsCalendarEvent.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    ' EventInfo constants
    if not rsCalendarEvent.EOF then
      vFuncResult(CEV_calendareventid) 			     = clng(BBS.ValidateNumeric(iCalendarEvent))
      vFuncResult(CEV_calendarid)                = clng(rsCalendarEvent.fields(0).value)
      vFuncResult(CEV_owner)                     = rsCalendarEvent.fields(1).value
      vFuncResult(CEV_shortdesc)                 = BBS.FilterView(rsCalendarEvent.fields(18).value)
      vFuncResult(CEV_longdesc)                  = BBS.FilterView(rsCalendarEvent.fields(19).value)
      vFuncResult(CEV_weekday)                   = rsCalendarEvent.fields(2).value
      vFuncResult(CEV_singledate)                = rsCalendarEvent.fields(3).value
      vFuncResult(CEV_day)                       = clng(rsCalendarEvent.fields(4).value)
      vFuncResult(CEV_month)                     = clng(rsCalendarEvent.fields(5).value)
      vFuncResult(CEV_year)                      = clng(rsCalendarEvent.fields(6).value)
      vFuncResult(CEV_recurrence)                = rsCalendarEvent.fields(7).value
      vFuncResult(CEV_private)                   = cint(rsCalendarEvent.fields(8).value)
      vFuncResult(CEV_ownerstatus)				       = cint(rsCalendarEvent.fields(9).value)
      vFuncResult(CEV_alldayevent)               = cint(rsCalendarEvent.fields(10).value)
      vFuncResult(CEV_timeofdayhour)             = cint(rsCalendarEvent.fields(11).value)
      vFuncResult(CEV_timeofdayminute)           = cint(rsCalendarEvent.fields(12).value)
      vFuncResult(CEV_timeofdaymeridian)         = cint(rsCalendarEvent.fields(13).value)
      vFuncResult(CEV_hasdaterange)				       = cint(rsCalendarEvent.fields(14).value)
      vFuncResult(CEV_startdaterange)			       = rsCalendarEvent.fields(15).value
      vFuncResult(CEV_enddaterange)				       = rsCalendarEvent.fields(16).value
      vFuncResult(CEV_allowsignups)				       = cint(rsCalendarEvent.fields(17).value)

    else
      vFuncResult(CEV_calendareventid)            = -1
      vFuncResult(CEV_CalendarID)                 = -1
    end if

  GetEventInfo = vFuncResult
  end function

  function DeleteEvent(byval iEventID)
    ' DESCRIPTION : Deletes an event given an eventid
    dim SQL, sKey

    sKey = "CEV-" & iEventID
    SQL = "delete from signups where calendareventid=" & BBS.ValidateNumeric(iEventID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "delete from calendarsevents where calendareventid=" & BBS.ValidateNumeric(iEventID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    BBS.CacheDelete sKey
    ' Flush the ListDateEvents cache
    BBS.CacheDeleteType("LDE")

  end function

  function CreateEventInfo(byref vEventInfo)

    ' DESCRIPTION: Creates a calendar event
    dim rsNewID, SQL, sSingleDate, sStartDate, sEndDate
    set rsNewID = server.CreateObject("ADODB.Recordset")

    if not(isdate(vEventInfo(CEV_SingleDate))) then
      sSingleDate = sDateDelimiter & BBS.GetSQLDate(now) & sDateDelimiter
    else
      sSingleDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_Singledate)) & sDateDelimiter
    end if

    if not(isdate(vEventInfo(CEV_StartDateRange))) then
      sStartDate = sDateDelimiter & BBS.GetSQLDate(now) & sDateDelimiter
    else
      sStartDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_StartDateRange)) & sDateDelimiter
    end if

    if not(isdate(vEventInfo(CEV_EndDateRange))) then
      sEndDate = sDateDelimiter & BBS.GetSQLDate(now) & sDateDelimiter
    else
      sEndDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_EndDateRange)) & sDateDelimiter
    end if

    SQL = "insert into calendarsevents (calendarid, owner, shortdesc, longdesc, weekday, " & BBS.EscapeDBField("day") & " , " & BBS.EscapeDBField("month") & " , " & BBS.EscapeDBField("year") & ", recurrence, private, singledate, timeofdayhour, timeofdayminute, timeofdaymeridian, alldayevent, hasdaterange, startdaterange, enddaterange, allowsignups, ownerstatus) values("
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_CalendarID)) & ", "
    SQL = SQL & "'" & BBS.SQLTrim(vEventInfo(CEV_Owner),50) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(vEventInfo(CEV_ShortDesc),50) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(vEventInfo(CEV_LongDesc)) & "', "
    SQL = SQL & "'" & BBS.ValidateNumeric(vEventInfo(CEV_Weekday)) & "', "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Day)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Month)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Year)) & ", "
    SQL = SQL & "'" & BBS.SQLTrim(vEventInfo(CEV_Recurrence),10) & "', "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Private)) & ", "
    SQL = SQL & sSingleDate & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Timeofdayhour)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Timeofdayminute)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_timeofdaymeridian)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_alldayevent)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_hasdaterange)) & ", "
    SQL = SQL & sStartDate & ", "
    SQL = SQL & sEndDate & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Allowsignups)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vEventInfo(CEV_Ownerstatus)) & ") "
    dbConnection.Execute (SQL)
    BBS.AddQuery(SQL)

    SQL = "select @@IDENTITY"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)
    if rsNewID.EOF then
      CreateEventInfo = 0
    else
      CreateEventInfo = clng(rsNewID.fields(0).value)
    end if
    rsNewID.Close

    ' Flush the ListDateEvents cache
    BBS.CacheDeleteType("LDE")

  end function

  function UpdateEventInfo(byval vEventInfo)

    ' DESCRIPTION: Creates a calendar event
    dim rsNewID, SQL, sSingleDate, sStartDate, sEndDate
    set rsNewID = server.CreateObject("ADODB.Recordset")

    if not(isdate(vEventInfo(CEV_SingleDate))) then
      sSingleDate = sDateDelimiter & Now & sDateDelimiter
    else
      sSingleDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_Singledate)) & sDateDelimiter
    end if

    if not(isdate(vEventInfo(CEV_StartDateRange))) then
      sStartDate = BBS.GetDBDateNull
    else
      sStartDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_StartDateRange)) & sDateDelimiter
    end if

    if not(isdate(vEventInfo(CEV_EndDateRange))) then
      sEndDate = BBS.GetDBDateNull
    else
      sEndDate = sDateDelimiter & BBS.GetSQLDate(vEventInfo(CEV_EndDateRange)) & sDateDelimiter
    end if

    SQL = "update calendarsevents set "
    SQL = SQL & "calendarid=" & BBS.ValidateNumeric(vEventInfo(CEV_CalendarID)) & ", "
    SQL = SQL & "owner=" & "'" & BBS.SQLTrim(vEventInfo(CEV_Owner),50) & "', "
    SQL = SQL & "shortdesc=" & "'" & BBS.SQLTrim(vEventInfo(CEV_ShortDesc),50) & "', "
    SQL = SQL & "longdesc=" & "'" & BBS.ValidateSQL(vEventInfo(CEV_LongDesc)) & "', "
    SQL = SQL & "weekday=" & "'" & BBS.ValidateNumeric(vEventInfo(CEV_Weekday)) & "', "
    SQL = SQL & BBS.EscapeDBField("day") & "=" & BBS.ValidateNumeric(vEventInfo(CEV_Day)) & ", "
    SQL = SQL & BBS.EscapeDBField("month") & "=" & BBS.ValidateNumeric(vEventInfo(CEV_Month)) & ", "
    SQL = SQL & BBS.EscapeDBField("year") & "=" & BBS.ValidateNumeric(vEventInfo(CEV_Year)) & ", "
    SQL = SQL & "recurrence=" & "'" & BBS.SQLTrim(vEventInfo(CEV_Recurrence),10) & "', "
    SQL = SQL & "private=" & BBS.ValidateNumeric(vEventInfo(CEV_Private)) & ", "
    SQL = SQL & "singledate=" & sSingleDate & ", "
    SQL = SQL & "timeofdayhour=" & BBS.ValidateNumeric(vEventInfo(CEV_Timeofdayhour)) & ", "
    SQL = SQL & "timeofdayminute=" & BBS.ValidateNumeric(vEventInfo(CEV_Timeofdayminute)) & ", "
    SQL = SQL & "timeofdaymeridian=" & BBS.ValidateNumeric(vEventInfo(CEV_timeofdaymeridian)) & ", "
    SQL = SQL & "alldayevent=" & BBS.ValidateNumeric(vEventInfo(CEV_alldayevent)) & ", "
    SQL = SQL & "hasdaterange=" & BBS.ValidateNumeric(vEventInfo(CEV_hasdaterange)) & ", "
    SQL = SQL & "startdaterange=" & sStartDate & ", "
    SQL = SQL & "enddaterange=" & sEndDate & ", "
    SQL = SQL & "allowsignups=" & BBS.ValidateNumeric(vEventInfo(CEV_Allowsignups)) & ", "
    SQL = SQL & "ownerstatus=" & BBS.ValidateNumeric(vEventInfo(CEV_Ownerstatus)) & " "
    SQL = SQL & "where calendareventid=" & BBS.ValidateNumeric(vEventInfo(CEV_Calendareventid))
    dbConnection.Execute (SQL)
    BBS.AddQuery(SQL)

    ' Flush the ListDateEvents cache
    BBS.CacheDeleteType("LDE")


  end function

Function GetCalendarInfoStruct()
  ' DESCRIPTION : Returns a calendar EventInfo structure
  dim vResult(3)
  GetCalendarInfoStruct = vResult
end function

Function GetCalendarInfo(byVal iCAcalendarid)
  ' DESCRIPTION : Get information about a calendar
  ' INPUTS      : iCAcalendarID - CalendarID
  ' RETURNS     : A Calendarinfo Structure

  DIM SQL, vFuncResult, rsInformation
  set rsInformation = server.CreateObject("ADODB.Recordset")
  iCAcalendarid = BBS.ValidateNumeric(iCAcalendarid)
  vFuncResult   = GetCalendarInfoStruct

  SQL = "select calendars.calendarid, calendars.calendarname, calendars.description from calendars where calendars.calendarid=" & BBS.ValidateNumeric(iCAcalendarid)

  rsInformation.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

  if not(rsInformation.EOF) then
     vFuncResult(CI_calendarid)					= clng(rsInformation.fields(0).value)
     vFuncResult(CI_CalendarName)				= rsInformation.fields(1).value
     vFuncResult(CI_Description)				= rsInformation.fields(2).value
  else
     vFuncResult(CI_calendarid)     = -1
  end if

  ' Close database connections
  rsInformation.Close
  set rsInformation = Nothing

  GetCalendarInfo = vFuncResult

end function

  Public Function GenerateCalendarDropdown()
    ' DESCRIPTION : Generates a form fragment listing all the available calendars
    ' RETURNS     : An HTML form fragment
    ' NOTES       : Descriptive fields have a value of -1

    dim rscalendarList, bAllowDisplay, sResult, vResult, index, iUpperBound, SQL
    set rscalendarList = server.createobject("ADODB.Recordset")

    SQL = "select calendarid, calendarname from calendars order by calendarid asc"
    rsCalendarList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    bAllowDisplay = True

    if (rsCalendarList.EOF) then
      rsCalendarList.Close
      exit function
    else
      vResult = rsCalendarList.GetRows
      rsCalendarList.Close
      iUpperBound = UBOUND(vResult, 2)
    end if

    for index=0 to iUpperBound
      ' Check if the user can list the forum
      if BBS.HasPermission(PERM_CALENDARACCESS, vResult(0, index)) then
        sResult = sResult &  "<option value='" & vResult(0, index) & "'> + " & BBS.ValidateField(vResult(1, index)) & "</option>"
      else
        ' Cannot list this calendar
      end if
    next
    GenerateCalendarDropdown = sResult

  end function

END CLASS

%>