<%
  ' MegaBBS extender API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp, include-constants.asp, include-calendar.asp

dim Extender
set Extender = new MegaBBSExtenderAPI

CLASS MegaBBSExtenderAPI

sub GetStatistics (byref iTotCategories, byref iTotForums, byref iTotThreads, byref iTotMessages, _
                   byref iTotUsers, byref iTotWeeklyPosts, byref iTotWeeklyUsers, iLogonsToday, _
                   iLogonsYesterday, iLogonsWeek, iLogonsMonth)

    dim rsStatistics, SQL, dDate, dDate2

    set rsStatistics = server.createObject("ADODB.Recordset")
    dDate = DateSerial(year(now), month(now), day(now)-7)
    dDate = BBS.GetSQLDate(dDate)

    SQL = "SELECT COUNT(*) AS memberTotal   FROM members"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotUsers        = rsStatistics("memberTotal")
    rsStatistics.Close

    SQL = "SELECT COUNT(*) AS categoryTotal FROM categories"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotCategories   = rsStatistics("categoryTotal")
    rsStatistics.Close

    SQL = "SELECT COUNT(*) AS forumTotal FROM forums"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotForums       = rsStatistics("forumTotal")
    rsStatistics.Close

    SQL = "SELECT COUNT(*) AS threadTotal   FROM threads"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotThreads      = rsStatistics("threadTotal")
    rsStatistics.Close

    SQL = "SELECT SUM(totalposts) AS Numtotalposts FROM threads"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotMessages     = rsStatistics("Numtotalposts")
    rsStatistics.Close

    SQL = "SELECT COUNT(*) AS memberWeeklyTotal   FROM members WHERE (dateregistered > " & sDateDelimiter & (dDate) & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotWeeklyUsers = rsStatistics("memberWeeklyTotal")
    rsStatistics.Close

    SQL = "SELECT COUNT(*) as messageWeeklyTotal  FROM messages where (dateposted > " & sDateDelimiter & (dDate) & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iTotWeeklyPosts = rsStatistics("messageWeeklyTotal")
    rsStatistics.Close

    dDate = BBS.GetSQLDate(now)
    SQL = "SELECT COUNT(*) as logonstoday  FROM visitorhistory where (logofftime >= " & sDateDelimiter & (dDate) & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iLogonsToday = rsStatistics("logonstoday")
    rsStatistics.Close

    dDate2 = DateSerial(year(now), month(now), day(now) -1)
    SQL = "SELECT COUNT(*) as logonsyesterday  FROM visitorhistory where (logofftime >= " & sDateDelimiter & BBS.GetSQLDate(dDate2) & sDateDelimiter & " and logofftime < " & sDateDelimiter & dDate & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iLogonsYesterday = rsStatistics("logonsyesterday")
    rsStatistics.Close

    dDate = DateSerial(year(now), month(now), day(now) - (weekday(now)-1)+7)
    dDate = BBS.GetSQLDate(dDate)
    dDate2 = DateSerial(year(now), month(now), day(now) - (weekday(now)-1))
    dDate2 = BBS.GetSQLDate(dDate2)
    SQL = "SELECT COUNT(*) as logonsweek  FROM visitorhistory where (logofftime >= " & sDateDelimiter & dDate2 & sDateDelimiter & " and logofftime < " & sDateDelimiter & dDate & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iLogonsWeek = rsStatistics("logonsweek")
    rsStatistics.Close


    dDate2 = DateSerial(year(now), month(now), 1)
    dDate2 = BBS.GetSQLDate(dDate2)
    SQL = "SELECT COUNT(*) as logonsmonth  FROM visitorhistory where (logofftime >= " & sDateDelimiter & dDate2 & sDateDelimiter & " and logofftime < " & sDateDelimiter & dDate & sDateDelimiter & ")"
    rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    iLogonsMonth = rsStatistics("logonsmonth")
    rsStatistics.Close

    set rsStatistics = Nothing

end sub

function ShowOnlineRegistered(bHonorInvisible)

  ' DESCRIPTION: Returns a string listing the online registered users, one after another.
  ' INPUTS     : bHonorInvisible : 0 or 1 - show invisible users?
  ' OUTPUTS    : A list of the online users, with links to their profiles.

   dim rsOnline, vUsers, index, length, SQL, vbOnline

   ShowOnlineRegistered = BBS.Cache("INFO-ONLINEREGISTERED")
   if IsEmpty(ShowOnlineRegistered) then

       set vbOnline = new StringBuilder
       set rsOnline = server.createobject("ADODB.Recordset")
       SQL = "select online.username, members.invisible from online LEFT OUTER JOIN members on " & _
             "online.username = members.username where online.registered = 1 order by online.lastactivity DESC;"
       rsOnline.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
       if not(rsOnline.EOF) then
          vUsers = rsOnline.GetRows
          rsOnline.Close
          for index=0 to ubound(vUsers, 2)
           if (bHonorInvisible = 0) or (vUsers(1, index) = 0) then
            vbOnline.Append BBS.CreateUsernameLink(vUsers(0, index)) & BBS.ValidateField(vUsers(0, index)) & "</a>, "
           end if
          next
          ShowOnlineRegistered = vbOnline.ToString()
          set vbOnline = Nothing

         length = len(ShowOnlineRegistered)
         if length > 2 then ShowOnlineRegistered = left(ShowOnlineRegistered, length-2)
       else
         rsOnline.close
       end if

       BBS.CacheAdd("INFO-ONLINEREGISTERED"), ShowOnlineRegistered
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if


end function



function GenerateTopList(byref iNumThreads, byref iforumid, byref sOrder, byRef iArraySize)

  ' DESCRIPTION : Returns information on the most recently active threads

  ' iNumThreads : The number of threads to return
  ' iforumid    : The forum ID, if forumid is "-1" then all public forums are returned
  ' Username &  :
  ' Password    : If supplied, these will return headers from restricted forums
  ' sOrder      : sort by "created" date or "lastactivity" date

  ' RETURNS     : An array containing the events, and supporting information

  ' GenerateTopList constants
  ' CONST TL_threadid = 0   : CONST TL_Hyperlink = 1    : CONST TL_threadsubject = 2
  ' CONST TL_NumReplies = 3 : CONST TL_lastactivity = 4 : CONST TL_datecreated = 5
  ' CONST TL_Owner = 6      : CONST TL_lastposter = 7   : CONST TL_ValidatedHyperlink = 8
  ' CONST TL_NumViews = 9   : CONST TL_ThreadOwner = 10 : CONST TL_forumid = 11

    dim rsTopThreads, SQL, index, vResult(), iEventforumid, bRestricted

    set rsTopThreads = server.createobject("ADODB.Recordset")
    index = 0

    ' Either look in a specific forum, or look in all forums
    SQL = "select threadid, memberid, guestname, isregistered, timesviewed, threads.anonymous, threads.datecreated, threads.lastactivity, lastpostermemberid, lastposterisregistered, lastposterguestname, lastposteranonymous, " & _
          "totalposts, forums.forumid, threadsubject from threads, forums where threads.forumid=forums.forumid"
    if iforumid <> -1 then SQL = SQL & " and forums.forumid=" & BBS.ValidateNumeric(iForumID)

    if ucase(sOrder) = "CREATED" then
       SQL = SQL & " Order by threads.datecreated DESC"
    else
       SQL = SQL & " Order by threads.lastactivity DESC"
    end if

    rsTopThreads.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    ' Generate an item
    do until (index > (iNumThreads-1)) or (rsTopThreads.EOF)

      ' Has access?
      if BBS.HasPermission(PERM_FORUMACCESS, rsTopThreads.fields("forumid").value) then

        index = index + 1
        redim preserve vResult(11, index)

        vResult(TL_threadid, (index-1))     = rsTopThreads("threadid")
        vResult(TL_Hyperlink, (index-1))    = sBBSForumROot & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&posts=" & rsTopThreads("totalposts")
        vResult(TL_ValidatedHyperlink, (index-1)) = sBBSValidatedBaseURL & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&posts=" & rsTopThreads("totalposts")
        vResult(TL_threadsubject, (index-1))= BBS.FilterView(rsTopThreads("threadsubject").value)
        vResult(TL_NumReplies, (index-1))   = (rsTopThreads("totalposts")-1)
        vResult(TL_lastactivity, (index-1)) = (rsTopThreads("lastactivity"))
        vResult(TL_datecreated, (index-1))  = (rsTopThreads("datecreated"))
        if rsTopThreads.fields("anonymous") = 1 then
          vResult(TL_Owner, (index-1))   = dictLanguage("GLOBAL-ANONYMOUS")
        else
          if rsTopThreads("isregistered") = 1 then
            vResult(TL_Owner, (index-1))   = BBS.GetUserInfobyID(rsTopThreads("memberid"))(UI_Username)
          else
            vResult(TL_Owner, (index-1))   = rsTopThreads("guestname")
          end if
        end if
        if rsTopThreads.fields("lastposteranonymous") = 1 then
          vResult(TL_lastposter, (index-1))   = dictLanguage("GLOBAL-ANONYMOUS")
        else
          if rsTopThreads("lastposterisregistered") = 1 then
            vResult(TL_lastposter, (index-1))   = BBS.GetUserInfobyID(rsTopThreads("lastpostermemberid"))(UI_Username)
          else
            vResult(TL_lastposter, (index-1))   = rsTopThreads("lastposterguestname")
          end if
        end if
        vResult(TL_NumViews, (index-1))     = BBS.ValidateNumeric(rsTopThreads("timesviewed"))
        vResult(TL_forumid, (index-1))      = rsTopThreads("forumid")
      end if

      ' Move to the next record
      rsTopThreads.movenext

    loop

    iArraySize      = index
    GenerateTopList = vResult

end function

function GenerateTopListbyExclude(byref iNumThreads, byref vExclude, byref sOrder, byRef iArraySize)

' DESCRIPTION : Returns information on the most recently active threads excluding any forum by given IDs

' iNumThreads : The number of threads to return
' vExclude : An array with forum IDs to exclude
' Username & :
' Password : If supplied, these will return headers from restricted forums
' sOrder : sort by "created" date or "lastactivity" date

' RETURNS : An array containing the events, and supporting information

' GenerateTopListbyExclude constants
' CONST TL_threadid = 0 : CONST TL_Hyperlink = 1 : CONST TL_threadsubject = 2
' CONST TL_NumReplies = 3 : CONST TL_lastactivity = 4 : CONST TL_datecreated = 5
' CONST TL_Owner = 6 : CONST TL_lastposter = 7 : CONST TL_ValidatedHyperlink = 8
' CONST TL_NumViews = 9 : CONST TL_ThreadOwner = 10 : CONST TL_forumid = 11

dim rsTopThreads, SQL, index, vResult(), iEventforumid, bRestricted

set rsTopThreads = server.createobject("ADODB.Recordset")
index = 0

SQL = "select threadid, memberid, guestname, isregistered, timesviewed, threads.anonymous, threads.datecreated, threads.lastactivity, lastpostermemberid, lastposterisregistered, lastposterguestname, lastposteranonymous, " & _
"totalposts, forums.forumid, threadsubject from threads, forums where threads.forumid=forums.forumid"

for i = 1 to ubound(vExclude)
  SQL = SQL & " and forums.forumid<>" & BBS.ValidateNumeric(vExclude(i)) & " "
next

if ucase(sOrder) = "CREATED" then
SQL = SQL & " Order by threads.datecreated DESC"
else
SQL = SQL & " Order by threads.lastactivity DESC"
end if

rsTopThreads.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

' Generate an item
do until (index > (iNumThreads-1)) or (rsTopThreads.EOF)

' Has access?
if BBS.HasPermission(PERM_FORUMACCESS, rsTopThreads.fields("forumid").value) then

index = index + 1
redim preserve vResult(11, index)

vResult(TL_threadid, (index-1)) = rsTopThreads("threadid")
vResult(TL_Hyperlink, (index-1)) = sBBSForumROot & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_ValidatedHyperlink, (index-1)) = sBBSValidatedBaseURL & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_threadsubject, (index-1))= BBS.FilterView(rsTopThreads("threadsubject").value)
vResult(TL_NumReplies, (index-1)) = (rsTopThreads("totalposts")-1)
vResult(TL_lastactivity, (index-1)) = (rsTopThreads("lastactivity"))
vResult(TL_datecreated, (index-1)) = (rsTopThreads("datecreated"))
if rsTopThreads.fields("anonymous") = 1 then
vResult(TL_Owner, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("isregistered") = 1 then
vResult(TL_Owner, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("memberid"))(UI_Username)
else
vResult(TL_Owner, (index-1)) = rsTopThreads("guestname")
end if
end if
if rsTopThreads.fields("lastposteranonymous") = 1 then
vResult(TL_lastposter, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("lastposterisregistered") = 1 then
vResult(TL_lastposter, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("lastpostermemberid"))(UI_Username)
else
vResult(TL_lastposter, (index-1)) = rsTopThreads("lastposterguestname")
end if
end if
vResult(TL_NumViews, (index-1)) = BBS.ValidateNumeric(rsTopThreads("timesviewed"))
vResult(TL_forumid, (index-1)) = rsTopThreads("forumid")
end if

' Move to the next record
rsTopThreads.movenext

loop

iArraySize = index
GenerateTopListbyExclude = vResult

end function

function GenerateTopListbySpecific(byref iNumThreads, byref vSpecific, byref sOrder, byRef iArraySize)

' DESCRIPTION : Returns information on the most recently active threads from specific forums

' iNumThreads : The number of threads to return
' vSpecific : An array with specific forum IDs to return data from
' Username & :
' Password : If supplied, these will return headers from restricted forums
' sOrder : sort by "created" date or "lastactivity" date

' RETURNS : An array containing the events, and supporting information

' GenerateTopListbySpecific constants
' CONST TL_threadid = 0 : CONST TL_Hyperlink = 1 : CONST TL_threadsubject = 2
' CONST TL_NumReplies = 3 : CONST TL_lastactivity = 4 : CONST TL_datecreated = 5
' CONST TL_Owner = 6 : CONST TL_lastposter = 7 : CONST TL_ValidatedHyperlink = 8
' CONST TL_NumViews = 9 : CONST TL_ThreadOwner = 10 : CONST TL_forumid = 11

dim rsTopThreads, SQL, index, vResult(), iEventforumid, bRestricted

set rsTopThreads = server.createobject("ADODB.Recordset")
index = 0

SQL = "select threadid, memberid, guestname, isregistered, timesviewed, threads.anonymous, threads.datecreated, threads.lastactivity, lastpostermemberid, lastposterisregistered, lastposterguestname, lastposteranonymous, " & _
"totalposts, forums.forumid, threadsubject from threads, forums where threads.forumid=forums.forumid"

for i = 1 to ubound(vSpecific)
if i = 1 then
SQL = SQL & " and (forums.forumid=" & BBS.ValidateNumeric(vSpecific(i)) & " "
else
SQL = SQL & " or forums.forumid=" & BBS.ValidateNumeric(vSpecific(i)) & " "
end if
next
SQL = SQL & ") "

if ucase(sOrder) = "CREATED" then
SQL = SQL & " Order by threads.datecreated DESC"
else
SQL = SQL & " Order by threads.lastactivity DESC"
end if

rsTopThreads.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

' Generate an item
do until (index > (iNumThreads-1)) or (rsTopThreads.EOF)

' Has access?
if BBS.HasPermission(PERM_FORUMACCESS, rsTopThreads.fields("forumid").value) then

index = index + 1
redim preserve vResult(11, index)

vResult(TL_threadid, (index-1)) = rsTopThreads("threadid")
vResult(TL_Hyperlink, (index-1)) = sBBSForumROot & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_ValidatedHyperlink, (index-1)) = sBBSValidatedBaseURL & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_threadsubject, (index-1))= BBS.FilterView(rsTopThreads("threadsubject").value)
vResult(TL_NumReplies, (index-1)) = (rsTopThreads("totalposts")-1)
vResult(TL_lastactivity, (index-1)) = (rsTopThreads("lastactivity"))
vResult(TL_datecreated, (index-1)) = (rsTopThreads("datecreated"))
if rsTopThreads.fields("anonymous") = 1 then
vResult(TL_Owner, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("isregistered") = 1 then
vResult(TL_Owner, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("memberid"))(UI_Username)
else
vResult(TL_Owner, (index-1)) = rsTopThreads("guestname")
end if
end if
if rsTopThreads.fields("lastposteranonymous") = 1 then
vResult(TL_lastposter, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("lastposterisregistered") = 1 then
vResult(TL_lastposter, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("lastpostermemberid"))(UI_Username)
else
vResult(TL_lastposter, (index-1)) = rsTopThreads("lastposterguestname")
end if
end if
vResult(TL_NumViews, (index-1)) = BBS.ValidateNumeric(rsTopThreads("timesviewed"))
vResult(TL_forumid, (index-1)) = rsTopThreads("forumid")
end if

' Move to the next record
rsTopThreads.movenext

loop

iArraySize = index
GenerateTopListbySpecific = vResult

end function

function GenerateTopListbyCategory(byref iNumThreads, byref icatid, byref sOrder, byRef iArraySize)

' DESCRIPTION : Returns information on the most recently active threads from a given category

' iNumThreads : The number of threads to return
' icatid : The category ID, if catid is "-1" then all public forums are returned
' Username & :
' Password : If supplied, these will return headers from restricted forums
' sOrder : sort by "created" date or "lastactivity" date

' RETURNS : An array containing the events, and supporting information

' GenerateTopListbyCategory constants
' CONST TL_threadid = 0 : CONST TL_Hyperlink = 1 : CONST TL_threadsubject = 2
' CONST TL_NumReplies = 3 : CONST TL_lastactivity = 4 : CONST TL_datecreated = 5
' CONST TL_Owner = 6 : CONST TL_lastposter = 7 : CONST TL_ValidatedHyperlink = 8
' CONST TL_NumViews = 9 : CONST TL_ThreadOwner = 10 : CONST TL_forumid = 11

dim rsTopThreads, SQL, index, vResult(), iEventforumid, bRestricted

set rsTopThreads = server.createobject("ADODB.Recordset")
index = 0

' Either look in a specific forum, or look in all forums
SQL = "select threadid, memberid, guestname, isregistered, timesviewed, threads.anonymous, threads.datecreated, threads.lastactivity, lastpostermemberid, lastposterisregistered, lastposterguestname, lastposteranonymous, " & _
"totalposts, forums.forumid, threadsubject from threads, forums where threads.forumid=forums.forumid"
if icatid <> -1 then SQL = SQL & " and forums.categoryid=" & BBS.ValidateNumeric(icatid)

if ucase(sOrder) = "CREATED" then
SQL = SQL & " Order by threads.datecreated DESC"
else
SQL = SQL & " Order by threads.lastactivity DESC"
end if

rsTopThreads.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

' Generate an item
do until (index > (iNumThreads-1)) or (rsTopThreads.EOF)

' Has access?
if BBS.HasPermission(PERM_FORUMACCESS, rsTopThreads.fields("forumid").value) then

index = index + 1
redim preserve vResult(11, index)

vResult(TL_threadid, (index-1)) = rsTopThreads("threadid")
vResult(TL_Hyperlink, (index-1)) = sBBSForumROot & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_ValidatedHyperlink, (index-1)) = sBBSValidatedBaseURL & "/forums/thread-view.asp?tid=" & rsTopThreads("threadid") & "&amp;posts=" & rsTopThreads("totalposts")
vResult(TL_threadsubject, (index-1))= BBS.FilterView(rsTopThreads("threadsubject").value)
vResult(TL_NumReplies, (index-1)) = (rsTopThreads("totalposts")-1)
vResult(TL_lastactivity, (index-1)) = (rsTopThreads("lastactivity"))
vResult(TL_datecreated, (index-1)) = (rsTopThreads("datecreated"))
if rsTopThreads.fields("anonymous") = 1 then
vResult(TL_Owner, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("isregistered") = 1 then
vResult(TL_Owner, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("memberid"))(UI_Username)
else
vResult(TL_Owner, (index-1)) = rsTopThreads("guestname")
end if
end if
if rsTopThreads.fields("lastposteranonymous") = 1 then
vResult(TL_lastposter, (index-1)) = dictLanguage("GLOBAL-ANONYMOUS")
else
if rsTopThreads("lastposterisregistered") = 1 then
vResult(TL_lastposter, (index-1)) = BBS.GetUserInfobyID(rsTopThreads("lastpostermemberid"))(UI_Username)
else
vResult(TL_lastposter, (index-1)) = rsTopThreads("lastposterguestname")
end if
end if
vResult(TL_NumViews, (index-1)) = BBS.ValidateNumeric(rsTopThreads("timesviewed"))
vResult(TL_forumid, (index-1)) = rsTopThreads("forumid")
end if

' Move to the next record
rsTopThreads.movenext

loop

iArraySize = index
GenerateTopListbyCategory = vResult

end function

function GetHeaders  (byval iforumid, byval iMaxHeaders, byval dStartDate, byval dEndDate, byval sOrder, byref iArraySize)

  ' Retrieves the first messages in each thread in order to create a 'news script'

  ' INPUTS  iforumid    : headers from which forum?
  '         iMaxHeaders : the BBS.Maximum number of headers to return (-1 returns all- be careful)
  '         dStartDate  : The 'upper' date.  "-1" signifies no upper bound
  '         dEndDate    : The 'lower' date.  "-1" signifies no lower bound
  '         sOrder      : Order by "created" or "lastactivity".
  '                     : Preserve sticky threads by adding 'sticky'. Example "created sticky" or "lastactivity sticky" (Thanks Jayson)

  ' OUTPUTS  iArraySize : The size of the returned array

  ' RETURNS             : A HeaderInfo array

  dim vFuncResult(), rsHeaders, index, sCommentLink, sOwner, SQL, sLInkName

  ' Initialize some variables
  set rsHeaders = server.createobject("ADODB.Recordset")
  index = 0

  ' Assign some default values
  if len(iMaxHeaders) = 0 then iMaxHeaders = -1
  if len(dStartDate)  = 0 then dStartDate  = date(now)                             ' Today
  if len(dEndDate)    = 0 then dEndDate    = dateserial(year(now), month(now), 1)  ' First day of the month

  if iforumid = -1 then
    SQL = "select threads.* , messages.body, messages.emoticons from messages, threads where threads.threadid=messages.threadid and inreplyto=-1  "
  else
    SQL = "select threads.*, messages.body, messages.emoticons from messages, threads where threads.threadid=messages.threadid AND threads.forumid=" & BBS.ValidateNumeric(iforumid) & " and inreplyto=-1  "
  end if

  if dStartDate <> -1 then  SQL = SQL & " and datecreated <=" & sDateDelimiter & BBS.GetSQLDate(dStartDate) & sDateDelimiter
  if dEndDate <> -1 then SQL = SQL & " and datecreated >= " & sDateDelimiter & BBS.GetSQLDate(dEndDate) & sDateDelimiter

  SQL = SQL & " order by "
  if InStr(ucase(sOrder), "STICKY") > 0 then
    SQL = SQL & "threads.sticky desc, "
  end if

  if InStr(ucase(sOrder), "CREATED") > 0 then
    SQL = SQL & "datecreated DESC"
  else
    SQL = SQL & "lastactivity DESC"
  end if

  rsHeaders.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

  ' Get a list of headers and prepare the results
  do until (rsHeaders.EOF) or ((index > (iMaxHeaders-1)) and iMaxHeaders <> -1)
    if BBS.HasPermission(PERM_FORUMVIEW, rsHeaders("forumid")) then
      redim preserve vFuncResult(8, Index)
      vFuncResult(HI_CommentLink, Index) = "<a href='" & sBBSForumRoot & "/forums/thread-view.asp?tid=" & rsHeaders("threadid") & "&amp;posts=" & rsHeaders("totalposts") & "'>"
      vFuncResult(HI_LongDate, Index)    = rsHeaders("datecreated").value
      vFuncResult(HI_ShortDate, Index)   = rsHeaders("datecreated").value
      vFuncResult(HI_NumComments, Index) = (rsHeaders("totalposts").value)-1
      vFuncResult(HI_MessageBody, index) = BBS.FilterView(BBS.MBBSDecode(rsHeaders.fields("body").value, BBS.ValidateBoolean(rsHeaders("emoticons"))))
      vFuncResult(HI_Subject, Index)     = BBS.FilterView(rsHeaders.fields("threadsubject").value)

      if rsHeaders("anonymous") = 1 then
        vFuncResult(HI_OwnerName, Index) = dictLanguage("GLOBAL-ANONYMOUS")
        vFuncResult(HI_OwnerLink, Index) = dictLanguage("GLOBAL-ANONYMOUS")
      else
        if rsHeaders("isregistered") = 1 then
          sLinkName = BBS.GetUserInfobyId(rsHeaders.fields("memberid").value)(UI_Username)
          vFuncResult(HI_OwnerName, Index) = sLinkName
          vFuncResult(HI_OwnerLink, Index) = BBS.CreateUsernameLinkbyID(rsHeaders("memberid")) & BBS.ValidateField(sLinkName) & "</a>"
        else
          vFuncResult(HI_OwnerName, index) = rsHeaders.fields("guestname").value
        end if
      end if

      Index = Index + 1
    end if
    rsHeaders.movenext
  loop
  GetHeaders = vFuncResult
  iArraySize = Index
end function

  function WriteInfoCenter
    dim rsInfoCenter, SQL, vCalendarEvents, sResult, iArraySize, sNewestUser, iTotalPosts, iTotalThreads, iTotalUsers, iTotalForums, i, bStarterRow
    dim vbCalendarBuilder

    set vbCalendarBuilder = new StringBuilder
    set rsInfoCenter = server.createobject("ADODB.Recordset")

    ' Show the most recent user to the forum
    if dictConfiguration("bCATEGORYSTATISTICSNEWUSER") = 1 then
      sNewestUser = BBS.Cache("INFO-NEWUSER")
      if IsEmpty(sNewestUser) then
        SQL = "select username from members order by dateregistered DESC"
        rsInfoCenter.Open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not rsInfoCenter.EOF then sNewestUser = rsInfoCenter.fields(0).value
        rsInfoCenter.close
        BBS.CacheAdd "INFO-NEWUSER", sNewestUser
      end if
      dictEnvironment.item("V-WELCOMEUSER") = dictConfiguration.item("sBBSNAME") & dictLanguage.item("CATEGORY-9") & BBS.CreateUsernameLink(sNewestUser) & BBS.ValidateField(sNewestUser) & "</a>" & dictLanguage.item("CATEGORY-10") & "<br/>"
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Show some interesting statistics!!  For great fun!! For justice!!
    if dictConfiguration("bCATEGORYSTATISTICSCOUNTS") = 1 then
      sResult = "<br/>"
      iTotalPosts   = BBS.Cache("INFO-TOTALPOSTS")
      iTotalThreads = BBS.Cache("INFO-TOTALTHREADS")
      iTotalForums  = BBS.Cache("INFO-TOTALFORUMS")

      if IsEmpty(iTotalPosts) or IsEmpty(iTotalThreads) or IsEmpty(iTotalForums) then
        SQL = "select count(*) as totalforums, sum(postcount) as totalposts, sum(threadcount) as totalthreads from forums"
        rsInfoCenter.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not(rsInfoCenter.EOF) then
          iTotalForums  = rsInfoCenter.fields(0).value
          iTotalPosts   = rsInfoCenter.fields(1).value
          iTotalThreads = rsInfoCenter.fields(2).value
        end if
        BBS.CacheAdd "INFO-TOTALPOSTS", iTotalPosts
        BBS.CacheAdd "INFO-TOTALTHREADS", iTotalThreads
        BBS.CacheAdd "INFO-TOTALFORUMS", iTotalForums
        rsInfoCenter.Close
      else
        iBBSCachedHits = iBBSCachedHits + 1
      end if

      iTotalUsers = BBS.Cache("INFO-TOTALUSERS")
      if IsEmpty(iTotalUsers) then
        SQL = "select count(*) as totalusers from members"
        rsInfoCenter.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not(rsInfoCenter.EOF) then iTotalUsers = rsInfoCenter.fields(0).value
        rsInfoCenter.Close
        BBS.CacheAdd "INFO-TOTALUSERS", iTotalUsers
      end if

      sResult = iTotalPosts & dictLanguage.item("CATEGORY-13") & iTotalThreads & dictLanguage.item("CATEGORY-14") & iTotalForums & dictLanguage.item("CATEGORY-15") & "<br/>"
      sResult = sResult &  dictLanguage.item("CATEGORY-16") & iTotalUsers & dictLanguage.item("CATEGORY-17") & "<br/>"
      dictEnvironment.item("V-STATCOUNTS") = sResult
   end if



   ' Show upcoming calendar events
   if dictConfiguration.item("bCATEGORYSTATISTICSEVENTS") = 1 and dictConfiguration.item("bENABLECALENDAR") = 1 then
     sResult = ""
     vCalendarEvents = Calendar.ListDateEvents(-1, date, dateadd("d",7 ,date), iArraySize)

     if iArraySize > 0 then
        vbCalendarBuilder.Append "<br/><span class='header6'>" & dictLanguage.item("GLOBAL-UPCOMINGEVENTS") & "</span><br/><table>" & CRLF
        for i = 0 to (iArraySize-1)
          vbCalendarBuilder.Append "<tr>" & CRLF
          vbCalendarBuilder.Append "<td nowrap><img src='" & sBBSValidatedBaseURL & "/images/spacer.gif' width='25' alt='' height='1'>" & BBS.GetShortDate(vCalendarEvents(i)(CEV_META_date))
          if vCalendarEvents(i)(CEV_AllDayEvent) = 0 then
            if vCalendarEvents(i)(CEV_timeofdayminute) < 10 then vCalendarEvents(i)(CEV_timeofdayminute) = "0" & vCalendarEvents(i)(CEV_timeofdayminute)
            if dictConfiguration("sTIMEFORMAT") = 24 then
              if len(vCalendarEvents(i)(CEV_TimeOfDayHour)) = 1 then vCalendarEvents(i)(CEV_TimeOfDayHour) = "0" & vCalendarEvents(i)(CEV_TimeOfDayHour)
            end if
            vbCalendarBuilder.Append " " & vCalendarEvents(i)(CEV_TimeOfDayHour) & ":" & vCalendarEvents(i)(CEV_TimeOfDayMinute) & " "
            if dictConfiguration("sTIMEFORMAT") = 12 then
                if vCalendarEvents(i)(CEV_timeofdaymeridian) = 0 then
                  vbCalendarBuilder.Append dictLanguage("GLOBAL-AM")
                else
                  vbCalendarBuilder.Append dictLanguage("GLOBAL-PM")
                end if
            end if
          end if
          vbCalendarBuilder.Append " <a href='" & sBBSValidatedBaseURL & "/calendar/event-view.asp?eventid=" & vCalendarEvents(i)(CEV_CalendarEventID) & "'>" & BBS.ValidateField(vCalendarEvents(i)(CEV_ShortDesc)) & "</a> - " & BBS.ValidateField(vCalendarEvents(i)(CEV_Owner)) & "</td>" & crlf
          vbCalendarBuilder.Append "</tr>"
        next
        vbCalendarBuilder.Append "</table>"
     else
        vbCalendarBuilder.Append dictLanguage.item("CATEGORY-19") & "<br/>"
     end if
     dictEnvironment.item("V-UPCOMINGCALENDAR") = vbCalendarBuilder.ToString()
   end if

   ' Show the online registered users
   if dictConfiguration.item("bCATEGORYSTATISTICSONLINE") = 1 then dictEnvironment.item("V-ONLINEUSERS") = "<br/>" & dictLanguage.item("GLOBAL-ONLINEUSERS") & " : " & ShowOnlineRegistered(BBS.ValidateBoolean(iBBSUserLevel < USERLEVEL_SUPPORTAdministrator)) & "<br/>"
   Filesystem.ExecuteFragmentTemplate ("/category-view-welcomebox.asp")
   WriteInfoCenter = sBBSFragmentOutput
   sBBSFragmentOutput = ""
 end function

 Function WriteRSSBox()
   ' DESCRIPTION : Gets the box displaying an RSS feed.
   ' RETURNS : HTML

   dim sRSSName, bCollapsed, oSource, oChannel, oImage, oItem, index, rsInfo, xmlhttp, sError, iError
   set rsInfo = server.createObject("ADODB.Recordset")

   ' Changing states
   if BBS.ValidateNumeric(request.querystring("collapserss")) = 1 then
     response.cookies(sBBSCookieRoot & "rsscollapsed") = 1
     response.cookies(sBBSCookieRoot & "rsscollapsed").expires = dateadd("m", 2, now)
   elseif BBS.ValidateNumeric(request.querystring("expandrss")) = 1 then
     response.cookies(sBBSCookieRoot & "rsscollapsed") = 0
     response.cookies(sBBSCookieRoot & "rsscollapsed").expires = dateadd("m", 2, now)
   end if

   ' Is it collapsed or expanded?
   if len(request.cookies(sBBSCookieRoot & "rsscollapsed")) > 0 then
     if BBS.ValidateBoolean(request.cookies(sBBSCookieRoot & "rsscollapsed")) = 1 then
       bCollapsed = 1
     else
       bCollapsed = 0
     end if
   else
     bCollapsed = BBS.ValidateBoolean(dictConfiguration("bCOLLAPSERSSBYDEFAULT"))
   end if

   if bCollapsed = 1 then
     sRSSName = "cat-col"
     dictEnvironment.item("U-EXPANDLINK") = sBBScurrentURLPath & "?expandrss=1"
   else
     sRSSName = "cat-exp"
     dictEnvironment.item("U-COLLAPSELINK") = sBBScurrentURLPath & "?collapserss=1"
   end if

   ' Is this feed cached in the database?
   SQL = "select expiration, feed from rssfeeds where rssname='" & sRSSName & "'"
   rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
   if not(rsInfo.EOF) then
     if rsInfo.fields("expiration") > now then
       ' Cache is still good
       WriteRSSBox = rsInfo.fields("feed").value
       set rsInfo = Nothing
       exit function
     end if
   end if
   rsInfo.Close


   ' Try to load the RSS feed
   set xmlhttp = server.CreateObject("Msxml2.ServerXMLHTTP")
   xmlhttp.open "GET", dictConfiguration.item("sRSSFEEDLOCATION"), false
   xmlhttp.SetTimeouts 2000,2000,2000,2000

   err.clear
   on error resume next
     xmlhttp.send()
     iError = err.number
     sError = err.description
   on error goto 0


   if xmlHTTP.status <> "200" then
     iError = "-1"
     sError = xmlHTTP.ResponseTEXT
   end if

   set oSource = xmlhttp.responseXML

   'set oSource = server.createobject("Msxml2.DomDocument")
   'oSource.async = false
   'oSource.setProperty "ServerHTTPRequest", true
   'oSource.setTimeouts 2000,2000,2000,2000
   'oSource.load(dictConfiguration.item("sRSSFEEDLOCATION"))

   ' If all was OK
   if oSource.parseError.errorCode = 0 and iError = 0 then

     dictConfiguration("iRSSITEMSTODISPLAY") = BBS.ValidateNumeric(dictConfiguration("iRSSITEMSTODISPLAY"))
     for each oChannel in oSource.getElementsByTagName("channel")
       on error resume next
       dictEnvironment.item("V-CHANNELTITLE") = oChannel.selectSingleNode("title").text
       dictEnvironment.item("V-CHANNELDESCRIPTION") = oChannel.selectSingleNode("description").text
       dictEnvironment.item("U-CHANNELLINK") = oChannel.selectSingleNode("link").text
       set oImage = oChannel.selectSingleNode("image")
       dictEnvironment.item("U-IMAGE") = oImage.selectSingleNode("url").text
       dictEnvironment.item("V-IMAGETITLE") = oImage.selectSingleNode("title").text
       dictEnvironment.item("C-IMAGE") = BBS.ValidateBoolean(len(dictEnvironment.item("U-IMAGE")) > 0)
       on error goto 0

       if bCollapsed = 1 then
         Filesystem.ExecuteFragmentTemplate("/rss-collapsed.asp")
         WriteRSSBox = WriteRSSBox & sBBSFragmentOutput
         sBBSFragmentOutput = ""

       else
         Filesystem.ExecuteFragmentTemplate("/rss-channel-start.asp")
         WriteRSSBox = WriteRSSBox & sBBSFragmentOutput
         sBBSFragmentOutput = ""

         index = 1
         for each oItem in oChannel.getElementsByTagName("item")
           on error resume next
           dictEnvironment.item("V-ITEMTITLE") = oItem.selectSingleNode("title").text
           dictEnvironment.item("V-ITEMDESCRIPTION") = oItem.selectSingleNode("description").text
           dictEnvironment.item("U-ITEMLINK") = oItem.selectSingleNode("link").text
           dictEnvironment.item("V-DATE") = oItem.selectSingleNode("pubDate").text
           err.clear
           on error goto 0
           dictEnvironment.item("C-DATE") = BBS.ValidateBoolean(len(dictEnvironment.item("V-DATE")) > 0)
           Filesystem.ExecuteFragmentTemplate("/rss-channel-item.asp")
           WriteRSSBox = WriteRSSBox & sBBSFragmentOutput
           sBBSFragmentOutput = ""
           index = index + 1
           if (index > dictConfiguration("iRSSITEMSTODISPLAY")) and (dictConfiguration("iRSSITEMSTODISPLAY") > 0) then exit for
         next

         Filesystem.ExecuteFragmentTemplate("/rss-channel-end.asp")
         WriteRSSBox = WriteRSSBox & sBBSFragmentOutput
       end if

       ' Stick this in the database to cache it.  Let it live for four hours
       on error resume next
       SQL = "select rssname, expiration, feed from rssfeeds where rssname='" & sRSSName & "'"
       if ucase(sBBSDatabaseType) = "MYSQL" Then
         rsInfo.CursorLocation   = adUseClient
         rsInfo.open SQL, sConnString & "OPTION=16387;", adOpenStatic, adLockOptimistic
       else
         rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockOptimistic
       end if

       if rsInfo.EOF then
         rsInfo.AddNew
         rsInfo.fields("rssname").value   = sRSSName
         rsInfo.update
       end if
       rsInfo.fields("expiration").value  = dateadd("h", 4, now)
       rsInfo.fields("feed").value        = WriteRSSBox
       rsInfo.update
       rsInfo.Close
       sBBSFragmentOutput = ""
     next
   else
     response.write "here"
     dictEnvironment.item("V-ERRNUM") = oSource.parseError.errorCode
     dictEnvironment.item("V-REASON") = oSource.parseError.reason & BBS.MBBSDecode(sError,0)
     Filesystem.ExecuteFragmentTemplate("/rss-error.asp")
     WriteRSSBox = sBBSFragmentOutput
     sBBSFragmentOutput = ""
   end if

   set rsInfo = Nothing
   set oSource = Nothing
   set xmlHTTP = Nothing
 end function

END CLASS
%>