<%
  ' MegaBBS forum, thread, and message API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp, include-constants.asp



dim Forum
set Forum = new MegaBBSForumAPI

CLASS MegaBBSForumAPI

  public function IsFlooding()
  ' DESCRIPTION: Checks whether or not a user is flooding based on the global flood
  '              limit as well as the user's individual limit, if any.
	' RETURNS    : 1 if the user is flooding
	'              0 if the user isn't flooding

	dim bFlooding, dLastPost, iFloodLimit
	bFlooding = 0
	' is the global flood control option activated at all?
	if dictConfiguration("bENABLEFLOODCONTROL") = 0 then
	  bFlooding = 0
	else
	  ' moderators and higher aren't checked
	  if iBBSUserLevel >= USERLEVEL_MODERATOR then
	    bFlooding = 0
	  else

      if iBBSMemberID > 0 then

	      ' the user's a mere mortal
        if sBBSDatabaseType = "MYSQL" then
          rsMaster.open "SELECT dateposted FROM messages WHERE memberid=" & BBS.ValidateNumeric(iBBSMemberID) & " ORDER BY dateposted DESC LIMIT 1", dbConnection, adOpenForwardOnly, adLockReadOnly
        else
          rsMaster.open "SELECT TOP 1 dateposted FROM messages WHERE memberid=" & BBS.ValidateNumeric(iBBSMemberID) & " ORDER BY dateposted DESC", dbConnection, adOpenForwardOnly, adLockReadOnly
        end if

      else

        ' User is a guest
        if sBBSDatabaseType = "MYSQL" then
          rsMaster.open "SELECT dateposted FROM messages WHERE hostname='" & BBS.ValidateSQL(request.servervariables("REMOTE_HOST")) & "' ORDER BY dateposted DESC LIMIT 1", dbConnection, adOpenForwardOnly, adLockReadOnly
        else
          rsMaster.open "SELECT TOP 1 dateposted FROM messages WHERE hostname='" & BBS.ValidateSQL(request.servervariables("REMOTE_HOST")) & "' ORDER BY dateposted DESC", dbConnection, adOpenForwardOnly, adLockReadOnly
        end if

      end if


	 	 if rsMaster.EOF then
		   ' the user hasn't posted anything, so there's nothing to check against
		   bFlooding = 0
	   else

		  ' get the time of the user's last post
		  dLastPost = rsMaster.fields(0).value
		  ' get the user's flood limit
		  iFloodLimit = GetFloodLimit(iBBSMemberID)
		  ' now that we have the user's flood limit,
		  ' let's see if he's been violating it
		  if ( dateadd("n", iFloodLimit, dLastPost) > now ) then
		    bFlooding = 1
		  else
		    bFlooding = 0
		  end if
		end if
		rsMaster.close
	  end if
	end if
	IsFlooding = bFlooding
  end function

  function GetFloodLimit(byref iMemberID)
    ' DESCRIPTION: Returns the flood limit for the specified user

    dim iFloodLimit
	  dim rsFlood
	  set rsFlood = server.createobject("ADODB.Recordset")

	  if dictConfiguration("bENABLEFLOODCONTROL") = 0 then
	    iFloodLimit = -1
    else
      ' first, get the global flood limit
      iFloodLimit = dictConfiguration("iFLOODLIMIT")

      ' if the user is in any groups, their limits override the global

      ' if the user is in several groups that have different limits we'll go with the biggest
      rsFlood.open "SELECT " & BBS.EscapeDBField("limit") & " FROM floodlimits, groups, groupmembers WHERE floodlimits.idtype=" & USERLEVEL_GROUP & " AND floodlimits.id=groups.groupid AND groups.groupid=groupmembers.groupid AND groupmembers.memberid=" & BBS.ValidateNumeric(iMemberID) & " ORDER BY  " & BBS.EscapeDBField("limit") & " DESC", dbConnection, adOpenForwardOnly, adLockReadOnly
      if not rsFlood.EOF then iFloodLimit = rsFlood.fields(0).value
      rsFlood.close

      ' if the user has an individual flood limit, it'll override all others - group and global
      rsFlood.open "SELECT " & BBS.EscapeDBField("limit") & "  FROM floodlimits WHERE idtype=" & USERLEVEL_MEMBER & " AND id=" & BBS.ValidateNumeric(iMemberID), dbConnection, adOpenForwardOnly, adLockReadOnly
      if not rsFlood.EOF then iFloodLimit = rsFlood.fields(0).value
      rsFlood.close
  	end if

	  set rsFlood = nothing
	  GetFloodLimit = iFloodLimit
  end function

  Public Function GetThreadInfoStruct()
    ' DESCRIPTION: Returns a ThreadInfo structure
    ' RETURNS    : A ThreadInfo structure

    dim stResult(22)
    GetThreadInfoStruct = stResult
  end function

  Public Function GetForumInfoStruct()
    ' DESCRIPTION: Returns a ForumInfo structure
    ' RETURNS    : A ForumInfo structure

    dim stResult(30)
    GetForumInfoStruct = stResult
  end function

  Public Function GetMessageInfoStruct()
    ' DESCRIPTION: Returns a MessageInfo structure
    ' RETURNS    : A ForumInfo structure

    dim stResult(25)
    GetMessageInfoStruct= stResult
  end function

  public Function CreateCategory(byref vCategoryInfo)
    ' DESCRIPTION : Creates a category
    ' RETURNS     : Newly created categoryid

    dim SQL, rsInfo
    set rsInfo = server.CreateObject("ADODB.Recordset")

    SQL = "insert into categories(name, url, locked, sortorder, schemedefault, forcescheme, collapsedbydefault) values ("
    SQL = SQL & "'" & BBS.SQLTrim(vCategoryInfo(CA_CategoryName), 50) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(vCategoryInfo(CA_CategoryURL), 75) & "', "
    SQL = SQL & BBS.ValidateBoolean(vCategoryInfo(CA_Locked)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vCategoryInfo(CA_Sortorder)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vCategoryInfo(CA_SchemeDefault)) & ", "
    SQL = SQL & BBS.ValidateBoolean(vCategoryInfo(CA_ForceScheme)) & ", "
    SQL = SQL & BBS.ValidateBoolean(vCategoryInfo(CA_CollapsedByDefault)) & ") "
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Get the new category id
    rsInfo.open "select @@identity", dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsInfo.EOF then
      vCategoryInfo(CA_CategoryID) = clng(rsInfo.fields(0).value)
      CreateCategory = vCategoryInfo(CA_CategoryID)
    end if
    rsInfo.Close
    set rsInfo = Nothing
  end function

  public function DeleteCategory(byval iCategoryID)
    ' DESCRIPTION : Deletes a category

    dim SQL, sKey
    sKey = "CI-" & iCategoryID

    SQL = "delete from categories where categoryid=" & BBS.ValidateNumeric(iCategoryID)
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    BBS.CacheDelete(sKey)
  end function

  public function EditCategory(byref vCategoryInfo)
    ' DESCRIPTION : Edits a category

    dim SQL, sKey
    sKey = "CI-" & iCategoryID

    SQL = "update categories set "
    SQL = SQL & "name='" & BBS.SQLTrim(vCategoryInfo(CA_CategoryName), 50) & "', "
    SQL = SQL & "url='" & BBS.SQLTrim(vCategoryInfo(CA_CategoryURL), 75) & "', "
    SQL = SQL & "locked=" & BBS.ValidateBoolean(vCategoryInfo(CA_Locked)) & ", "
    SQL = SQL & "sortorder=" & BBS.ValidateNumeric(vCategoryInfo(CA_Sortorder)) & ", "
    SQL = SQL & "schemedefault=" & BBS.ValidateNumeric(vCategoryInfo(CA_SchemeDefault)) & ", "
    SQL = SQL & "forcescheme=" & BBS.ValidateBoolean(vCategoryInfo(CA_ForceScheme)) & ", "
    SQL = SQL & "collapsedbydefault=" & BBS.ValidateBoolean(vCategoryInfo(CA_CollapsedByDefault)) & "  "
    SQL = SQL & "where categoryid=" & BBS.ValidateNumeric(vCategoryInfo(CA_CategoryID))
    dbConnection.execute SQL,, adTextNoRecords

    BBS.CacheDelete(sKey)
  end function

  Public Function GetForumInfo(byref iforumid)
    ' DESCRIPTION : Returns an array with information fields describing the forum
    ' INPUTES     : iForumID - ForumID
    ' RETURNS     : A ForumInfo struct

    dim vFuncResult, rsInformation, SQL, vForumInfo, sKey
    sKey = "FI-" & iForumID

    GetForumInfo = BBS.Cache(sKey)

    if not(IsEmpty(GetForumInfo)) then
      iBBSCachedHits = iBBSCachedHits + 1
      exit Function
    end if

    set rsInformation = server.createobject("ADODB.Recordset")
    vFuncResult = GetForumInfoStruct()

    SQL = "select forumid, categoryid, forumname, url, " '0-3
    SQL = SQL & "forumdescription, datecreated, lastactivity, sortbyactivity, shownavbars, " '4-8
    SQL = SQL & "forceunregistered, anonymous, defaultthreadview, defaultforumview, " '9-12
    SQL = SQL & "showquotes, hideemaillink, showprofilepicture, sortorder, threadcount, " '13-17
    SQL = SQL & "postcount, disableprinter, sortmessagesbyactivity, showonline, showranks,  " '18-22
    SQL = SQL & "hidereplybutton, lastactivethread, showips, emoticons, rss from forums where forumid=" & BBS.ValidateNumeric(iForumID)  '23-27

    rsInformation.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not(rsInformation.EOF) then
      vForumInfo = rsInformation.GetRows
      rsInformation.Close
      vFuncResult(FI_forumid)                 = clng(vForumInfo(0, 0))
      vFuncResult(FI_CategoryID)              = clng(vForumInfo(1, 0))
      vFuncResult(FI_ForumName)               = vForumInfo(2, 0)
      vFuncResult(FI_URL)                     = vForumInfo(3, 0)
      vFuncResult(FI_ForumDescription)        = vForumInfo(4, 0)
      vFuncResult(FI_DateCreated)             = vForumInfo(5, 0)
      vFuncResult(FI_lastactivity)            = vForumInfo(6, 0)
      vFuncResult(FI_sortbyactivity)          = vForumInfo(7, 0)
      vFuncResult(FI_shownavbars)             = clng(vForumInfo(8, 0))
      vFuncResult(FI_forceunregistered)       = clng(vForumInfo(9, 0))
      vFuncResult(FI_AnonymousAllowed)        = clng(vForumInfo(10, 0))
      vFuncResult(FI_defaultthreadview)       = vForumInfo(11, 0)
      vFuncResult(FI_defaultforumview)        = vForumInfo(12, 0)
      vFuncResult(FI_showquotes)              = clng(vForumInfo(13, 0))
      vFuncResult(FI_hideemaillink)           = clng(vForumInfo(14, 0))
      vFuncResult(FI_showprofilepicture)      = clng(vForumInfo(15, 0))
      vFuncResult(FI_sortorder )              = vForumInfo(16, 0)
      vFuncResult(FI_threadcount)             = clng(vForumInfo(17, 0))
      vFuncResult(FI_PostCount)               = clng(vForumInfo(18, 0))
      vFuncResult(FI_DisablePrinter)          = vForumInfo(19, 0)
      vFuncResult(FI_SortMessagesByActivity)  = vForumInfo(20, 0)
      vFuncResult(FI_showonline)              = clng(vForumInfo(21, 0))
      vFuncResult(FI_ShowRank)                = clng(vForumInfo(22, 0))
      vFuncResult(FI_HideReplyButton)         = clng(vForumInfo(23, 0))
      vFuncResult(FI_LastActiveThread)        = clng(vForumInfo(24, 0))
      vFuncResult(FI_ShowIPs)                 = clng(vForumInfo(25, 0))
      vFuncResult(FI_Emoticons)               = clng(vForumInfo(26, 0))
      vFuncResult(FI_RSS)                     = clng(vForumInfo(27, 0))
    else
      vFuncResult(FI_forumid) = -1
      rsInformation.Close
    end if
    set rsInformation = Nothing

    GetForumInfo = vFuncResult
    BBS.CacheAdd sKey, vFuncResult
  end function

  Public Function CreateForum(byref stForumInfo)
    ' DESCRIPTION : Creates a new forum
    ' INPUTS      : A ForumInfo structure
    ' RETURNS     : The newly create ForumID
    ' NOTES       : Supply a default value for all fields (FI_ForumID is ignored)

    dim rsForumID
    set rsForumID = server.createobject("ADODB.Recordset")

    SQL = "insert into forums(categoryid, forumname, url, forumdescription, datecreated, lastactivity, sortbyactivity, shownavbars, forceunregistered, "
    SQL = SQL & "anonymous, defaultthreadview, defaultforumview, showquotes, hideemaillink, showprofilepicture, sortorder, threadcount, postcount, disableprinter, sortmessagesbyactivity, showonline, showranks, hidereplybutton, lastactivethread, showips, rss) VALUES ("
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_CategoryID)) & ", '" & BBS.SQLTrim(stForumInfo(FI_ForumName), 50) & "', '" & BBS.SQLTrim(stForumInfo(FI_URL), 75) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(stForumInfo(FI_ForumDescription)) & "', " & sDateDelimiter & BBS.GetSQLDateTime(stForumInfo(FI_datecreated)) & sDateDelimiter & ", " & sDateDelimiter & BBS.GetSQLDateTime(stForumInfo(FI_LastActivity)) & sDateDelimiter & ", "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_sortbyactivity)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_shownavbars)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_forceunregistered)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_AnonymousAllowed)) & ", '" & BBS.SQLTrim(stForumInfo(FI_defaultthreadview), 20) & "', '" & BBS.SQLTrim(stForumInfo(FI_defaultforumview), 20) & "', "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_showquotes)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_hideemaillink)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_showprofilepicture)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_sortorder)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_threadcount)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_PostCount)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_DisablePrinter)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_SortMessagesByActivity)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_showonline)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stForumInfo(FI_ShowRank)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_HideReplyButton)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_LastActiveThread)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_ShowIPs)) & ", " & BBS.ValidateNumeric(stForumInfo(FI_RSS)) & ")"
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Get the new forum id
    rsForumID.open "select @@identity", dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not rsForumID.EOF then
      stForumInfo(FI_FOrumID) = clng(rsForumID.fields(0).value)
      CreateForum = stForumInfo(FI_FOrumID)
    end if
    rsForumID.Close
    set rsForumID = Nothing

  end function

  Public Function UpdateForum(byref stForumInfo)
    ' DESCRIPTION : Updates a forum
    ' INPUTS      : A ForumInfo structure
    ' RETURNS     : True if successful, false otherwise
    ' NOTES       : Supply a default value for all fields (FI_ForumID is used to specify the forum to udpate)

    dim sKey, SQL
    sKey = "FI-" & stForumInfo(FI_ForumID)

    SQL = "update forums set categoryid=" & BBS.ValidateNumeric(stForumInfo(FI_CategoryID)) & ", forumname='" & BBS.SQLTrim(stForumInfo(FI_ForumName), 50) & "', url='" & BBS.SQLTrim(stForumInfo(FI_URL), 75) & "', "
    SQL = SQL & "forumdescription='" & BBS.ValidateSQL(stForumInfo(FI_ForumDescription)) & "', datecreated=" & sDateDelimiter & BBS.GetSQLDateTime(stForumInfo(FI_datecreated)) & sDateDelimiter & ", lastactivity=" & sDateDelimiter & BBS.GetSQLDateTime(stForumInfo(FI_LastActivity)) & sDateDelimiter & ", "
    SQL = SQL & "sortbyactivity=" & BBS.ValidateNumeric(stForumInfo(FI_sortbyactivity)) & ", shownavbars=" & BBS.ValidateNumeric(stForumInfo(FI_shownavbars)) & ", forceunregistered=" & BBS.ValidateNumeric(stForumInfo(FI_forceunregistered)) & ", "
    SQL = SQL & "anonymous=" & BBS.ValidateNumeric(stForumInfo(FI_AnonymousAllowed)) & ", defaultthreadview='" & BBS.SQLTrim(stForumInfo(FI_defaultthreadview),20) & "', defaultforumview='" & BBS.SQLTrim(stForumInfo(FI_defaultforumview),20) & "', "
    SQL = SQL & "showquotes=" & BBS.ValidateNumeric(stForumInfo(FI_showquotes)) & ", hideemaillink=" & BBS.ValidateNumeric(stForumInfo(FI_hideemaillink)) & ", showprofilepicture=" & BBS.ValidateNumeric(stForumInfo(FI_showprofilepicture)) & ", "
    SQL = SQL & "sortorder=" & BBS.ValidateNumeric(stForumInfo(FI_sortorder)) & ", threadcount=" & BBS.ValidateNumeric(stForumInfo(FI_threadcount)) & ", postcount=" & BBS.ValidateNumeric(stForumInfo(FI_PostCount)) & ", "
    SQL = SQL & "disableprinter=" & BBS.ValidateNumeric(stForumInfo(FI_DisablePrinter)) & ", sortmessagesbyactivity=" & BBS.ValidateNumeric(stForumInfo(FI_SortMessagesByActivity)) & ", showonline=" & BBS.ValidateNumeric(stForumInfo(FI_showonline)) & ", "
    SQL = SQL & "showranks=" & BBS.ValidateNumeric(stForumInfo(FI_ShowRank)) & ", hidereplybutton=" & BBS.ValidateNumeric(stForumInfo(FI_HideReplyButton)) & ", lastactivethread=" & BBS.ValidateNumeric(stForumInfo(FI_LastActiveThread)) & ", "
    SQL = SQL & "showips=" & BBS.ValidateNumeric(stForumInfo(FI_ShowIPs)) & ", emoticons="  & BBS.ValidateNumeric(stForumInfo(FI_emoticons)) & ", rss="  & BBS.ValidateNumeric(stForumInfo(FI_RSS)) & " where forumid=" & BBS.ValidateNumeric(stForumInfo(FI_ForumID))
    dbConnection.Execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)

  end function


  Public Function OffsetThreadViewCount (byval iThreadID, byval iOffset)
    ' DESCRIPTION : Increases or decreases the timesviewed field of ithreadid by iOffset
    ' INPUTS      : vThreadInfo - The thread structure
    '             : iOffset      - How much to increment/decrement the timesviewed by
    ' RETURNS     : True if successful, false otherwise

    dim sKey, SQL, vThreadInfo
    sKEY = "TI-" & iThreadID
    vThreadInfo = GetThreadInfo(iThreadID)
    if vThreadInfo(TI_ThreadID) > 0 then

      SQL = "update threads set timesviewed=timesviewed+ " & BBS.ValidateNumeric(iOffset) & " where threadid=" & BBS.ValidateNumeric(iThreadID)
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
      vThreadInfo(TI_TimesViewed) = vThreadInfo(TI_TimesViewed) + 1
      BBS.CacheDelete(sKey)
    end if

    OffsetThreadViewCount = True
  end function

  Public Function OffsetThreadPostCount (byval iThreadID, byref iOffset)
    ' DESCRIPTION : Increases or decreases the totalposts field of ithreadid by iOffset
    ' INPUTS      : vThreadInfo - The thread structure
    '             : iOffset      - How much to increment/decrement the timesviewed by
    ' RETURNS     : True if successful, false otherwise

    dim sKey, SQL, vThreadInfo
    sKEY = "TI-" & iThreadID

    SQL = "update threads set totalposts=totalposts+ " & BBS.ValidateNumeric(iOffset) & " where threadid=" & BBS.ValidateNumeric(iThreadID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)
  end function

  Public Function OffsetForumThreadCount (byval iForumID, byref iOffset)
    ' DESCRIPTION : Increases or decreases the postcount field of a thread by iOffset
    ' INPUTS      : A threadinfo and numeric offset
    ' RETURNS     : True if successful, false otherwise

    dim SQL, sKey, vForumInfo
    sKey = "FI-" & iForumID

    SQL = "UPDATE forums set threadcount=threadcount+" & BBS.ValidateNumeric(iOffset) & " where forumid=" & BBS.ValidateNumeric(iForumID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)

    OffsetForumThreadCount = True
  end function

  Public Function OffsetForumPostCount (byval iForumID, byref iOffset)
    ' DESCRIPTION : Increases or decreases the timesviewed field of ithreadid by iOffset
    ' INPUTS      : A threadinfo and numeric offset
    ' RETURNS     : True if successful, false otherwise

    dim SQL, sKey, vForumInfo
    sKey = "FI-" & iForumID

    SQL = "UPDATE forums set forums.postcount=postcount+" & BBS.ValidateNumeric(iOffset) & " where forums.forumid=" & BBS.ValidateNumeric(iForumID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)

    OffsetForumPostCount = True
  end function

  Public Function OffsetUserPostcount (byVal iUserMemberID, byref iOffset)
    ' DESCRIPTION : Updates the user's totalposts field
    ' INPUTS      : Userinfo and the offset
    ' RETURNS     : True if successful, false otherwise

    dim SQL, sKey, vUserInfo, rsPostcount, iPostcount
    sKey = "UI-" & iUserMemberID

    set rsPostcount = server.createobject("ADODB.recordset")
    SQL = "select totalposts from members where memberid=" & BBS.ValidateNumeric(iUserMemberID)
    rsPostcount.open SQL, dbConnection, adOpenForwardOnly, adLockReadonly
    if not rsPostcount.EOF then
      iPostcount = BBS.ValidateNumeric(rsPostcount.fields(0).value)
    else
      iPostcount = 0
    end if
    rsPostcount.close
    set rsPostcount = nothing

    if (iPostcount+BBS.ValidateNumeric(iOffset)<0) then
      SQL = "update members set totalposts=0 where memberid=" & BBS.ValidateNumeric(iUserMemberID)
    else
      SQL = "update members set totalposts=totalposts+" & BBS.ValidateNumeric(iOffset) & " where memberid=" & BBS.ValidateNumeric(iUserMemberID)
    end if
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Update the cache
    BBS.CacheDelete(sKey)

    OffsetUserPostcount = True
  end function

  function UpdateLastThreadPoster (byval ithreadid)
    ' DESCRIPTION : Updates the lastposter & lastactivity fields for ithreadid
    ' INPUTS      : iThreadID - Thread ID

    dim SQL, rsThread, iLastPosterMemberID, sLastPosterGuestName, bLastPosterIsRegistered, bLastPosterAnonymous, dLastPosterDatePosted, vThreadInfo
    set rsThread = server.createobject("ADODB.Recordset")

    if ucase(sBBSDatabaseType) = "MYSQL" Then
      SQL = "select memberid, guestname, isregistered, anonymous, dateposted, messageid from messages where approved=1 and threadid=" & BBS.ValidateNumeric(iThreadID) & " order by dateposted desc limit 1"
    else
      SQL = "select top 1 memberid, guestname, isregistered, anonymous, dateposted, messageid from messages where approved=1 and threadid=" & BBS.ValidateNumeric(iThreadID) & " order by dateposted desc"
    end if
    rsThread.open SQL, dbConnection, adOpenForwardOnly, adLockReadonly
    BBS.AddQuery(SQL)

    if not rsThread.EOF then
      vThreadInfo = GetThreadInfo(iThreadID)
      iLastPosterMemberID     = rsThread.fields(0).value
      sLastPosterGuestName    = rsThread.fields(1).value
      bLastPosterIsRegistered = rsThread.fields(2).value
      bLastPosterAnonymous    = rsThread.fields(3).value
      dLastPosterDatePosted   = rsThread.fields(4).value

      vThreadInfo(TI_LastPosterMemberID)     = iLastPosterMemberID
      if iLastPosterMemberID > 0 then
        vThreadInfo(TI_LastPosterGuestName)    = BBS.GetUserName(iLastPosterMemberID)
        sLastPosterGuestName = vThreadInfo(TI_LastPosterGuestName)
      else
        vThreadInfo(TI_LastPosterGuestName)    = sLastPosterGuestName
        if len(vThreadInfo(TI_LastPosterGuestName)) = 0 then
          vThreadInfo(TI_LastPosterGuestName) = dictLanguage("GLOBAL-GUEST")
          sLastPosterGuestName = dictLanguage("GLOBAL-GUEST")
        end if
      end if
      vThreadInfo(TI_LastPosterIsRegistered) = bLastPosterIsRegistered
      vThreadInfo(TI_LastPosterAnonymous)    = bLastPosterAnonymous
      vThreadInfo(TI_LastActivity)           = dLastPosterDatePosted
      vThreadInfo(TI_LastPostID)             = rsThread.fields("messageid").value
      rsThread.Close

      ' Fix the seed too
      SQL = "select memberid, guestname, messageid from messages where threadid=" & BBS.ValidateNumeric(iThreadID) & " and inreplyto=-1"
      rsThread.open SQL, dbConnection, adOpenForwardOnly, adLockReadonly
      if not rsThread.EOF then
        vThreadInfo(TI_Seed) = rsThread.fields("messageid").value
        vThreadInfo(TI_MemberID) = rsThread.fields("memberid").value
        if vThreadinfo(TI_MemberID) > 0 then
          vThreadInfo(TI_GuestName) = BBS.GetUserName(vThreadinfo(TI_MemberID))
        else
          vThreadInfo(TI_GuestName)    = rsThread.fields("guestname").value
          if len(vThreadInfo(TI_GuestName)) = 0 then vThreadInfo(TI_GuestName) = dictLanguage("GLOBAL-GUEST")
        end if
      end if
      BBS.CacheDelete "TI-" & vThreadInfo(TI_ThreadID)
      UpdateLastThreadPoster = vThreadInfo

      SQL = "update threads set "
      SQL = SQL & "threads.lastpostermemberid=" & BBS.ValidateNumeric(iLastPosterMemberID) & ", "
      SQL = SQL & "threads.lastposterguestname='" & BBS.ValidateSQL(sLastPosterGuestName) & "', "
      SQL = SQL & "threads.lastposterisregistered=" & BBS.ValidateBoolean(bLastPosterIsRegistered) & ", "
      SQL = SQL & "threads.lastposteranonymous=" & BBS.ValidateBoolean(bLastPosterAnonymous) & ", "

      SQL = SQL & "threads.seed=" & BBS.validateNumeric(vThreadInfo(TI_Seed)) & ", "
      SQL = SQL & "threads.lastpostid=" & BBS.validateNumeric(vThreadInfo(TI_LastPostID)) & ", "
      SQL = SQL & "threads.guestname='" & BBS.ValidateSQL(vThreadInfo(TI_GuestName)) & "', "

      SQL = SQL & "threads.lastactivity=" & sDateDelimiter & BBS.GetSQLDateTime(dLastPosterDatePosted) & sDateDelimiter & "  "
      SQL = SQL & " where threads.threadid=" & BBS.ValidateNumeric(iThreadID)
      dbConnection.Execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
      UpdateLastThreadPoster = sLastPosterGuestName

    else
      rsThread.Close
      UpdateLastThreadPoster = GetThreadInfoStruct()
    end if
    set rsThread = Nothing
  end function

  function UpdateLastActiveThread(byval iForumID)
    ' DESCRIPTION : Updates the last active thread for a forum
    ' RETURNS     : A ForumInfo structure

    dim SQL, rsThread, sKey
    set rsThread = server.createobject("ADODB.RECORDSET")
    sKey = "FI-" & iForumID

    if ucase(sBBSDatabaseType) = "MYSQL" Then
      SQL = "select threadid from threads where approved=1 and forumid=" & BBS.ValidateNumeric(iForumID) & " order by lastactivity desc limit 1"
    else
      SQL = "select top 1 threadid from threads where approved=1 and forumid=" & BBS.ValidateNumeric(iForumID) & " order by lastactivity desc"
    end if
    rsThread.open SQL, dbConnection, adOpenForwardOnly, adlockReadOnly
    BBS.AddQuery(SQL)

    if not(rsThread.EOF) then
      SQL = "update forums set lastactivethread=" & BBS.ValidateNumeric(rsThread.fields(0).value) & " where forumid=" & BBS.ValidateNumeric(iForumID)
      dbConnection.execute SQL,,adTextNoRecords
      BBS.AddQuery(SQL)
    else
      SQL = "update forums set lastactivethread=0 where forumid=" & BBS.ValidateNumeric(iForumID)
      dbConnection.execute SQL,,adTextNoRecords
      BBS.AddQuery(SQL)
    end if
    rsThread.Close
    BBS.CacheDelete sKey
    set rsThread = Nothing
  end function


  Public Function GetThreadInfo (byRef iThreadID)
    ' DESCRIPTION : Returns information about a thread
    ' INPUTS      : iThreadID - ThreadID
    ' RETURNS     : A ThreadInfo structure

    dim rsThreadInfo, SQL, vThreadRows, stResult, sKey
    sKey = "TI-" & iThreadID
    stResult = BBS.Cache(sKey)

    if not(IsEmpty(stResult)) then
      iBBSCachedHits = iBBSCachedHits + 1
      GetThreadInfo = stResult
      Exit Function
    end if

    set rsThreadInfo = server.createobject("ADODB.Recordset")
    stResult = GetThreadInfoStruct()

    SQL = "select threads.threadid, threads.forumid, threads.totalposts, threads.datecreated, threads.lastactivity, threads.threadsubject, threads.anonymous, threads.closed, threads.timesviewed, " '0-9
    SQL = SQL & "threads.sticky, threads.haspoll, threads.pollid, threads.hasattachment, threads.lastposteranonymous, threads.lastpostermemberid, threads.lastposterisregistered, "               '10-16
    SQL = SQL & "threads.lastposterguestname, threads.memberid, threads.isregistered, threads.guestname, threads.approved, threads.seed, threads.lastpostid " ' 17-22
    SQL = SQL & "from threads where threads.threadid=" & BBS.ValidateNumeric(ithreadid)
    rsThreadInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not rsThreadInfo.EOF then
      vThreadRows = rsThreadInfo.GetRows
      rsThreadInfo.Close

      stResult(TI_ThreadID)              = vThreadRows(0,0)
      stResult(TI_ForumID)               = vThreadRows(1,0)
      stResult(TI_TotalPosts)            = vThreadRows(2,0)
      stResult(TI_DateCreated)           = vThreadRows(3,0)
      stResult(TI_LastActivity)          = vThreadRows(4,0)
      stResult(TI_Subject)               = vThreadRows(5,0)
      stResult(TI_Anonymous)             = vThreadRows(6,0)
      stResult(TI_Closed)                = vThreadRows(7,0)
      stResult(TI_TimesViewed)           = vThreadRows(8,0)
      stResult(TI_Sticky)                = vThreadRows(9,0)
      stResult(TI_HasPoll)               = vThreadRows(10,0)
      stResult(TI_PollID)                = vThreadRows(11,0)
      stResult(TI_HasAttachment)         = vThreadRows(12,0)
      stResult(TI_LastPosterAnonymous)   = vThreadRows(13,0)
      stResult(TI_LastPosterMemberID)    = vThreadRows(14,0)
      stResult(TI_LastPosterIsRegistered)= vThreadRows(15,0)
      stResult(TI_LastPosterGuestName)   = vThreadRows(16,0)
      stResult(TI_MemberID)              = vThreadRows(17,0)
      stResult(TI_IsRegistered)          = vThreadRows(18,0)
      stResult(TI_GuestName)             = vThreadRows(19,0)
      stResult(TI_Approved)              = vThreadRows(20,0)
      stResult(TI_Seed)                  = vThreadRows(21,0)
      stResult(TI_LastPostID)            = vThreadRows(22,0)

      ' 2.2 introduced some denormalization for performance benefits
      ' Might as well try to auto-correct any problems with the thread while we're here
      if len(trim(stResult(TI_GuestName) & "")) = 0 then
        if clng(stResult(TI_MemberID)) > 0 then
          stResult(TI_GuestName) = BBS.GetUserName(stResult(TI_MemberID))
        else
          stResult(TI_GuestName) = dictLanguage("GLOBAL-GUEST")
        end if
        SQL = "update threads set guestname='" & BBS.ValidateSQL(stResult(TI_GuestName)) & "' where threadid=" & stResult(TI_ThreadID)
        dbConnection.execute SQL
        BBS.AddQuery(SQL)
      end if

      if len(trim(stResult(TI_LastPosterGuestName)&"")) = 0 then
        if clng(stResult(TI_LastPosterMemberID)) > 0 then
          stResult(TI_LastPosterGuestName) = BBS.GetUserName(stResult(TI_LastPosterMemberID))
        else
          stResult(TI_LastPosterGuestName) = dictLanguage("GLOBAL-GUEST")
        end if
        SQL = "update threads set lastposterguestname='" & BBS.ValidateSQL(stResult(TI_LastPosterGuestName)) & "' where threadid=" & stResult(TI_ThreadID)
        dbConnection.execute SQL
        BBS.AddQuery(SQL)
      end if


      if stResult(TI_Seed) = 0 then
        SQL = "select messageid from messages where inreplyto=-1 and threadid=" & stResult(TI_ThreadID)
        rsThreadInfo.open SQL, dbConnection, adOpenforwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not(rsThreadInfo.EOF) then stResult(TI_Seed) = rsThreadInfo.fields(0).value
        rsThreadInfo.Close
        SQL = "Update threads set seed=" & stResult(TI_Seed) & " where threadid=" & stResult(TI_ThreadID)
        dbConnection.execute SQL
        BBS.AddQuery(SQL)
      end if

      if stResult(TI_LastPostID) = 0 then
        SQL = "select messageid from messages where threadid=" & BBS.ValidateNumeric(stResult(TI_ThreadID)) & " order by messageid desc"
        rsThreadInfo.open SQL, dbConnection, adOpenforwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not(rsThreadInfo.EOF) then stResult(TI_LastPostID) = rsThreadInfo.fields(0).value
        rsThreadInfo.Close
        SQL = "Update threads set lastpostid=" & stResult(TI_LastPostID) & " where threadid=" & stResult(TI_ThreadID)
        dbConnection.execute SQL
        BBS.AddQuery(SQL)
      end if

    else
      rsThreadInfo.close
      stResult(TI_ThreadID)           = -1
    end if
    set rsThreadInfo = Nothing
    BBS.CacheAdd sKey, stResult
    GetThreadInfo = stResult
  end function

  Public Function GenerateNestedThread (byref vForumInfo, byref vThreadInfo, byref vUserInfo)
    ' DESCRIPTION : Generates a nested thread
    ' INPUTS      : ForumInfo, ThreadInfo, and a UserInfo structure
    ' RETURNS     : HTML string

    dim rsThreadList, vMessageInfo, SQL, vResults, index, iUpperBound, sHTMLResult, vOutput
    set vOutput = new StringBuilder
    set rsThreadList = server.createobject("ADODB.Recordset")

    vMessageInfo = GetMessageInfoStruct()

    SQL = "select messageid, threadid, inreplyto, subject, body, anonymous, hostname, dateposted, messageicon, emoticons, replyorder, replylevel, signature, filterhtml, lasteditedname, lastediteddate, edited, hasattachment, isregistered, memberid, guestname, forcelinebreaks, approved, hasrevisions "
    SQL = SQL & "from messages where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
    if not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) then SQL = SQL & " and messages.approved=1 "
    SQL = SQL & " order by replyorder ASC, dateposted asc"

    rsThreadlist.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not rsThreadList.EOF then
      vResults = rsThreadList.GetRows
      rsThreadList.Close
      iUpperBound = UBOUND(vResults, 2)

      for index = 0 to iUpperBound
        ' Set Additional DisplayMessageInfo strucuture parameters
        vMessageInfo(MI_MessageID)     = vResults(0, index)
        vMessageInfo(MI_threadid)      = vResults(1, index)
        vMessageInfo(MI_inreplyto)     = vResults(2, index)
        vMessageInfo(MI_Subject)       = vResults(3, index)
        vMessageInfo(MI_Body)          = vResults(4, index)
        vMessageInfo(MI_Anonymous)     = vResults(5, index)
        vMessageInfo(MI_HostName)      = vResults(6, index)
        vMessageInfo(MI_DatePosted)    = vResults(7, index)
        vMessageInfo(MI_MessageIcon)   = vResults(8, index)
        vMessageInfo(MI_Emoticons)     = vResults(9, index)
        vMessageInfo(MI_ReplyOrder)    = vResults(10, index)
        vMessageInfo(MI_ReplyLevel)    = vResults(11, index)
        vMessageInfo(MI_Signature)     = vResults(12, index)
        vMessageInfo(MI_FilterHTML)    = vResults(13, index)
        vMessageInfo(MI_lasteditedname)= vResults(14, index)
        vMessageInfo(MI_lastediteddate)= vResults(15, index)
        vMessageInfo(MI_Edited)        = vResults(16, index)
        vMessageInfo(MI_HasAttachment) = vResults(17, index)
        vMessageInfo(MI_IsRegistered)  = vResults(18, index)
        vMessageInfo(MI_MemberID)      = vResults(19, index)
        vMessageInfo(MI_GuestName)     = vResults(20, index)
        vMessageInfo(MI_ForceLineBreaks)= vResults(21, index)
        vMessageInfo(MI_Approved)      = vResults(22, index)
        vMessageInfo(MI_HasRevisions)  = vResults(23, index)

        vOutput.Append "<table width='95%' align='center'><tr><td width='" & vMessageInfo(MI_ReplyLevel) * 40 & "'>"
        vOutput.Append "<img src='" & sBBSForumRoot & "/images/spacer.gif' width='" & vMessageInfo(MI_ReplyLevel) * 40 & "' height='1' border='0'></td><td>"
        vOutput.Append GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1) & "</td></tr></table>" & CRLF
       next
       GenerateNestedThread = vOutput.ToString
       set vOutput = Nothing

     end if
     set rsThreadList = Nothing
   end function


  Public Function GenerateFlatThread (byref vForumInfo, byref vThreadInfo, byref vUserInfo, byval iStart)
    ' DESCRIPTION : Generates a flat thread
    ' INPUTS      : ForumInfo, ThreadInfo, and a UserInfo structure
    ' RETURNS     : HTML string


    dim rsThreadList, vMessageInfo, SQL, vResults, index, iUpperBound, vOutput
    set rsThreadList = server.createobject("ADODB.Recordset")
    vMessageInfo = GetMessageInfoStruct()
    set vOutput = new StringBuilder

    SQL = "select messageid, threadid, inreplyto, subject, body, anonymous, hostname, dateposted,messageicon, emoticons, replylevel, replyorder, signature, filterhtml, lasteditedname, lastediteddate, edited, hasattachment, isregistered, memberid, guestname, forcelinebreaks, approved, hasrevisions "
    SQL = SQL & "from messages where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
    if not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) then SQL = SQL & " and messages.approved=1 "

    if vForumInfo(FI_SortMessagesByActivity) = 1 then
      SQL = SQL & " order by dateposted desc, messageid desc"
    else
      SQL = SQL & " order by dateposted asc, messageid asc"
    end if


    rsThreadList.CacheSize = 25
    if ucase(sBBSDatabaseType) = "MYSQL" Then
      rsThreadList.CursorLocation   = adUseClient
    end if
    rsThreadlist.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not(rsThreadList.EOF) then rsThreadList.move iStart

    if not rsThreadList.EOF then
      vResults = rsTHreadList.GetRows
      rsThreadList.Close
      iUpperBound = UBOUND(vResults, 2)

      for index = 0 to BBS.Minimum(iUpperBound, dictConfiguration("iFORUMFLATPAGESIZE")-1)
        ' Set Additional DisplayMessageInfo strucuture parameters
        vMessageInfo(MI_MessageID)     = vResults(0, index)
        vMessageInfo(MI_threadid)      = vResults(1, index)
        vMessageInfo(MI_inreplyto)     = vResults(2, index)
        vMessageInfo(MI_Subject)       = vResults(3, index)
        vMessageInfo(MI_Body)          = vResults(4, index)
        vMessageInfo(MI_Anonymous)     = vResults(5, index)
        vMessageInfo(MI_HostName)      = vResults(6, index)
        vMessageInfo(MI_DatePosted)    = vResults(7, index)
        vMessageInfo(MI_MessageIcon)   = vResults(8, index)
        vMessageInfo(MI_Emoticons)     = vResults(9, index)
        vMessageInfo(MI_ReplyLevel)    = vResults(10, index)
        vMessageInfo(MI_ReplyOrder)    = vResults(11, index)
        vMessageInfo(MI_Signature)     = vResults(12, index)
        vMessageInfo(MI_FilterHTML)    = vResults(13, index)
        vMessageInfo(MI_lasteditedname)= vResults(14, index)
        vMessageInfo(MI_lastediteddate)= vResults(15, index)
        vMessageInfo(MI_Edited)        = vResults(16, index)
        vMessageInfo(MI_HasAttachment) = vResults(17, index)
        vMessageInfo(MI_IsRegistered)  = vResults(18, index)
        vMessageInfo(MI_MemberID)      = vResults(19, index)
        vMessageInfo(MI_GuestName)     = vResults(20, index)
        vMessageInfo(MI_ForceLineBreaks)= vResults(21, index)
        vMessageInfo(MI_Approved)      = vResults(22, index)
        vMessageInfo(MI_HasRevisions)  = vResults(23, index)

        vOutput.Append GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 0)
       next
     end if
     set rsThreadList = Nothing
     GenerateFlatThread = vOutput.toString
     set vOutput = Nothing
   end function

  Public Function GenerateThreadedThread (byref vForumInfo, byref vThreadInfo, byref vUserInfo, byref iMessageID)
    ' DESCRIPTION : Generates a threaded.. thread
    ' INPUTS      : A Foruminfo, threadinfo, and userinfo structure
    '             : The message of the thread that is currently being viewed (It will be bolded)
    ' RETURNS     : HTML formatting

    dim SQL, rsThreadList, vResults, index, iUpperBound, iCurrentLevel, sResult, sSubject, sHyperLink, bFirstThread
    dim sThreadNotes, sUserColorCoding, sOwner, iThreadingIndex, vbThreadBuilder

    set rsThreadList = server.createobject("ADODB.Recordset")
    set vbThreadBuilder = new Stringbuilder
    bFirstThread = True
    iCurrentLevel = -1



    SQL = "select messages.messageid, messages.replylevel, messages.subject, messages.dateposted, messages.anonymous, messages.isregistered, "  '0-5
    SQL = SQL & "messages.memberid, messages.guestname, threads.sticky, threads.haspoll, threads.closed, messages.approved from messages, threads " '6-11
    SQL = SQL &  "where messages.threadid = threads.threadid and messages.threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
    if not(BBS.CanViewAllPosts(vForumInfo(FI_ForumID))) then SQL = SQL & " and messages.approved=1 "
    SQL = SQL & " order by messages.replyorder ASC, dateposted asc"

    rsThreadlist.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not rsThreadList.EOF then
      vResults = rsThreadList.GetRows
      rsThreadList.Close


      iUpperBound = UBOUND(vResults, 2)
      for index=0 to iUpperBound

        if iCurrentLevel < vResults(1, index) then
          vbThreadBuilder.Append "<ul>" & CRLF
          iCurrentLevel = vResults(1, index)
        elseif iCurrentLevel > vResults(1, index) then
          for iThreadingIndex=1 to (iCurrentLevel - vResults(1, index))
            vbThreadBuilder.Append "</ul>" & CRLF
          next
          iCurrentLevel = vResults(1, index)
        end if

        vbThreadBuilder.Append "<li>"

        ' Owner name
        if vResults(5, index) = 1 and vResults(4, index) = 0 then
          sOwner = "<span class='registeredname'>" & BBS.ValidateField(BBS.GetUsername(vResults(6, index))) & "</span>"
        elseif vResults(5, index) = 0 and vResults(4, index) = 0 then
          sOwner= "<span class='notregisteredname'>" & BBS.ValidateField(vResults(7, index)) & "</span>"
        elseif vResults(4, index) = 1 then
          sOwner= "<span class='notregisteredname'>" & dictLanguage("GLOBAL-ANONYMOUS") & "</span>"
        end if

        ' Message poster
        if dictConfiguration("bBADWORDFILTERONDISPLAY") = 1 then
          sSubject = BBS.FilterWords(BBS.ValidateField(vResults(2, index)))
        else
          sSubject = BBS.ValidateField(vResults(2, index))
        end if
        if len(sSubject) = 0  then sSubject = "RE:"

        if vResults(0, index) = iMessageID then sSubject = "<b>" & sSubject & "</b>"

        if dictEnvironment.item("C-HIGHLIGHT") = 1 then
          sSubject = BBS.Highlight(sSubject, dictEnvironment.item("V-HIGHLIGHT"), dictEnvironment.item("V-HIGHLIGHTMODE"))
        end if

        sHyperlink = "<a class='threadlink' href='thread-view.asp?tid=" & vThreadInfo(TI_ThreadID) & "&mid=" & vResults(0, index) & "#M" & vResults(0, index) & "'>"

        ' Thread notes
        if bFirstThread = True then
          ' if vResults(8, index) = 1 then sThreadNotes= sThreadNotes & "<span class='header6'>[" & dictLanguage("GLOBAL-STICKY") & "]</span> "
          if vResults(9, index)   = 1 then sThreadNotes= sThreadNotes & "<span class='header6'>[" & dictLanguage("GLOBAL-POLL") & "]</span> "
          if vResults(10, index)  = 1 then sThreadNotes= sThreadNotes & "<span class='header6'>[" & dictLanguage("GLOBAL-CLOSED") & "]</span> "
          if vResults(11, index)  = 0 then sThreadNotes= sThreadNotes & "<span class='header6 error'>[" & dictLanguage("GLOBAL-UNAPPROVED") & "]</span> "
          bFirstThread = False
        else
          if vResults(11, index)  = 0 then sThreadNotes= sThreadNotes & "<span class='header6 error'>[" & dictLanguage("GLOBAL-UNAPPROVED") & "]</span> "
        end if
        vbThreadBuilder.Append sHyperlink & sSubject & "</a> " & sThreadNotes & " - " & sOwner & "<span class='smalltext'> : " & BBS.GetShortDateTime(vResults(3, index)) & "</span>" & CRLF
        sThreadNotes = ""
        sResult = ""
      next

      ' Close up the ULs
      ' for index = 0 to iCurrentLevel
      for iThreadingIndex=0 to (iCurrentLevel)
        vbThreadBuilder.Append "</ul>" & CRLF
      next

      GenerateThreadedThread = vbThreadBuilder.ToString

    end if
    set vbThreadBuilder = Nothing
    set rsThreadList = Nothing
  end function

  Public Function GenerateMessage (byref vMessageInfo, byref vForumInfo, byref vThreadInfo, byref vUserInfo, byref bSelfContained)
   ' DESCRIPTION : Displays a message given the supplied information.
   ' INPUTS      : A messageinfo strucutre, a foruminfo structure, and a Userinfo structure
   '             : bSelfContained - Should the message template generate it's own bounding table
   ' RETURNS     : HTML
   ' NOTES       : Uses foruminfo and userinfo structures to determine characteristics of appearance

   dim iForumUserLevel, vAuthorInfo, sWidth, sBody, sSubject, sSignature, sBBSBodyFragment, sAuthor, rsAttachments, SQL, sExtension, bIsClosed, iEditTime
   set rsAttachments = server.createobject("ADODB.Recordset")

   dictEnvironment.item("C-SELFCONTAINED") = bSelfContained

   ' Get some permission values and temporarily cache them in a secondary dictionary
   if IsEmpty(dictGeneralCache("forumpermissions-" & vForumInfo(FI_ForumID))) then
     dictGeneralCache(PERM_forumviewpostrevisions & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumviewpostrevisions, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumfreeze & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumreplyown & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumreplyown, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumreplyothers & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumreplyothers, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumeditown & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumeditown, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumeditothers & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumeditothers, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumdeleteown & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumdeleteown, vForumInfo(FI_ForumID))
     dictGeneralCache(PERM_forumdeleteothers & "-" & vForumInfo(FI_ForumID)) = BBS.HasPermission(PERM_forumdeleteothers, vForumInfo(FI_ForumID))
     dictGeneralCache("edittime-" & vForumInfo(FI_ForumID)) = BBS.LookupPermission(MODULE_FORUMS, BBS.GetUserlevel(MODULE_Forums, vForumInfo(FI_ForumID)), PERM_forummaxedittime, vForumInfo(FI_ForumID))
     dictGeneralCache("forumpermissions-" & vForumInfo(FI_ForumID)) = "Y"
     dictGeneralCache("forumuserlevel-" & vForumInfo(FI_ForumID)) =  BBS.GetUserLevel(MODULE_Forums, vForumInfo(FI_ForumID))
   end if

   iForumUserLevel = dictGeneralCache("forumuserlevel-" & vForumInfo(FI_ForumID))
   iEditTime = dictGeneralCache("edittime-" & vForumInfo(FI_ForumID))

   ' ======
   ' AUTHOR
   ' ======
   if vMessageInfo(MI_IsRegistered) = 1 and vMessageInfo(MI_Anonymous) = 0 then
     vAuthorInfo = BBS.GetUserInfobyID(vMessageInfo(MI_MemberID))
     sAuthor = BBS.CreateUsernameLinkbyID(vMessageInfo(MI_MemberID)) & BBS.ValidateField(vAuthorInfo(UI_Username)) & "</a>"
   elseif vMessageInfo(MI_IsRegistered) = 0 and vMessageInfo(MI_Anonymous) = 0 then
     sAuthor = "<span class='notregisteredname'>" & BBS.ValidateField(vMessageInfo(MI_GuestName)) & "</span>"
     vAuthorInfo = BBS.GetUserInfoStruct()
     vAuthorInfo(UI_MemberID) = -1
   elseif vMessageInfo(MI_Anonymous) = 1 then
     sAuthor = "<span class='notregisteredname'>" & dictLanguage("GLOBAL-ANONYMOUS") & "</span>"
     if iForumUserLevel >= USERLEVEL_ModuleAdministrator then sAuthor = sAuthor & "<br/><span class='notregisteredname'>(" & BBS.ValidateField(BBS.GetUsername(vMessageInfo(MI_MemberID))) & ")</span>"
     vAuthorInfo = BBS.GetUserInfoStruct()
     vAuthorInfo(UI_MemberID) = -1
   end if

   dictEnvironment.item("V-USERLINK") = sAuthor
   dictEnvironment.item("V-USERINFO") = vAuthorInfo

   'Set Ignore Option by checking for Author in the Members Ingore List
   if BBS.InArray(vAuthorInfo(UI_MemberID), vIgnoreList) then
     dictEnvironment.item("C-AUTHORIGNORED") = true
   else
     dictEnvironment.item("C-AUTHORIGNORED") = false
   end if

   if vAuthorInfo(UI_MemberID) = -1 or dictEnvironment.item("C-AUTHORIGNORED") then
     ' Posts by unregistered users won't have these fields
     dictEnvironment.item("C-SHOWAVATAR") = 0
     dictEnvironment.item("C-SHOWTITLE")  = 0
     dictEnvironment.item("C-SHOWPOSTS")  = 0
     dictEnvironment.item("C-SHOWDECORATIONS") = 0
     dictEnvironment.item("C-ONLINE") = 0
     dictEnvironment.item("C-SHOWPROFILE") = 0
     dictEnvironment.item("C-PM") = 0
     dictEnvironment.item("C-SHOWEMAIL") = 0
     dictEnvironment.item("C-SHOWPROFILE") = 0
     dictEnvironment.item("V-LOCATION") = ""
     dictEnvironment.item("C-SHOWWWW") = 0
   else

     if vForumInfo(FI_ShowRank) = 1 then

       if not(vAuthorInfo(UI_disablepostcount) = 1 and vAuthorInfo(UI_UseCustomRank) = 0) then
         dictEnvironment.item("C-SHOWTITLE") = 1
       else
         dictEnvironment.item("C-SHOWTITLE") = 0
       end if

       if vAuthorInfo(UI_DisablePostCount) = 1 then
         dictEnvironment.item("C-SHOWDECORATIONS") = 0
       end if

       if vAuthorInfo(UI_DisablePostCount) = 0 or dictConfiguration("bFORUMENABLEPOSTCOUNT") = 1 then
         dictEnvironment.item("C-SHOWDECORATIONS") = 1
         dictEnvironment.item("V-DECORATIONS") = BBS.GetDecorations(vAuthorInfo(UI_TotalPosts))
       else
         dictEnvironment.item("C-SHOWPOSTS") = 0
         dictEnvironment.item("C-SHOWDECORATIONS") = 0
       end if
     end if

     if vAuthorInfo(UI_DisablePostCount) = 1 or dictConfiguration("bFORUMENABLEPOSTCOUNT") = 0 then
       dictEnvironment.item("C-SHOWPOSTS") = 0
     else
       dictEnvironment.item("C-SHOWPOSTS") = 1
       dictEnvironment.item("V-TOTALPOSTS") = dictLanguage.item("GLOBAL-POSTS") & " " & BBS.ValidateField(vAuthorInfo(UI_TotalPosts))
     end if

     if vForumInfo(FI_ShowOnline) = 1 and iBBSUserLevel > USERLEVEL_Guest then
       if BBS.IsOnline(vAuthorInfo(UI_UserName)) = true and vAuthorInfo(UI_Invisible) = 0 then
         dictEnvironment.item("C-ONLINE") = 1
       else
         dictEnvironment.item("C-ONLINE") = 2
       end if
     else
       dictEnvironment.item("C-ONLINE") = 0
     end if

     if ((vMessageInfo(MI_HasRevisions) > 0) and (bFeaturesUnlocked = 1)) then
       dictEnvironment.item("C-SHOWREVISIONS") = dictGeneralCache(PERM_forumviewpostrevisions & "-" & vForumInfo(FI_ForumID))
     else
       dictEnvironment.item("C-SHOWREVISIONS") = 0
     end if

     if len(vAuthorInfo(UI_Location)) > 0 then
       dictEnvironment.item("V-LOCATION") = dictLanguage("GLOBAL-LOCATION") & " " & BBS.ValidateField(vAuthorInfo(UI_Location))
     else
       dictEnvironment.item("V-LOCATION") = ""
     end if

     if vForumInfo(FI_ShowProfilePicture) = 1 and len(vAuthorInfo(UI_ProfileURL)) > 7 then
       dictEnvironment("C-SHOWAVATAR") = 1
       if dictConfiguration("iAVATARWIDTH") > 0 then sWidth = " width='" & dictConfiguration("iAVATARWIDTH") & "' "
       dictEnvironment("V-AVATAR") = "<img " & sWidth & " alt='' border='0' src='" & BBS.ValidateField(vAuthorInfo(UI_ProfileURL)) & "'>"
     else

       dictEnvironment("C-SHOWAVATAR") = 0
     end if

     if iBBSUserLevel > USERLEVEL_Guest then
       ' Only logged in users have access to these features
       dictEnvironment.item("C-SHOWALERT") = 1
       dictEnvironment.item("U-ALERT") = sBBSForumRoot & "/forums/alert-post.asp?mid=" & vMessageInfo(MI_MessageID)

       if vUserInfo(UI_ViewAvatars) = 0 then dictEnvironment("C-SHOWAVATAR") = 0

       if vAuthorInfo(UI_MemberID) > 0 then
         dictEnvironment.item("C-SHOWPROFILE") = 1
         dictEnvironment.item("U-PROFILE") = sBBSForumRoot & "/view-profile.asp?uid=" & vAuthorInfo(UI_MemberID)
         dictEnvironment.item("C-PM") = 1
         dictEnvironment.item("U-PM") = sBBSForumRoot & "/send-private-message.asp?uid=" & vAuthorInfo(UI_MemberID)

         if len(vAuthorInfo(UI_EmailAddr)) > 0 and vAuthorInfo(UI_ShowEmail) = 1 and (iBBSMemberID > 0 or dictConfiguration("bGUESTSVIEWPROFILE") = 1) then
           dictEnvironment.item("C-SHOWEMAIL") = 1
           dictEnvironment.item("U-MAILTO")    = "mailto:" & BBS.ValidateField(vAuthorInfo(UI_Emailaddr))
         else
           dictEnvironment.item("C-SHOWEMAIL") = 0
           dictEnvironment.item("U-MAILTO") = ""
         end if

         if len(vAuthorInfo(UI_Websiteaddr)) > 0 then
           dictEnvironment.item("C-SHOWWWW") = 1
           dictEnvironment.item("U-WWW")     = BBS.ValidateField(vAuthorInfo(UI_Websiteaddr))
         else
           dictEnvironment.item("C-SHOWWWW") = 0
           dictEnvironment.item("U-WWW")     = ""
         end if

       else
         dictEnvironment.item("C-SHOWALERT") = 0
         dictEnvironment.item("C-SHOWPROFILE") = 0
         dictEnvironment("U-PROFILE") = ""
         dictEnvironment("C-PM") = 0
         dictEnvironment("U-PM") = ""
         dictEnvironment("C-SHOWEMAIL") = 0
         dictEnvironment("C-MAILTO") = ""
     end if

     else
       dictEnvironment.item("C-SHOWPROFILE") = 0
       dictEnvironment("U-PROFILE") = ""
       dictEnvironment("C-PM") = 0
       dictEnvironment("U-PM") = ""
       dictEnvironment("C-SHOWEMAIL") = 0
       dictEnvironment("C-MAILTO") = ""
       dictEnvironment.item("C-SHOWWWW") = 0
       dictEnvironment.item("U-WWW")     = ""
     end if

   end if


   ' Show the IP
   if vForumInfo(FI_ShowIPs) = 1 or iForumUserLevel >= USERLEVEL_Moderator then
     dictEnvironment("C-SHOWIP") = 1
     dictEnvironment("V-IP") = BBS.ValidateField(vMessageInfo(MI_HostName))
   else
     dictEnvironment("C-SHOWIP") = 0
     dictEnvironment("V-IP") = ""
   end if

   ' ========
   ' CONTROLS
   ' ========
   bIsClosed = (vThreadInfo(TI_Closed) = 0 or dictGeneralCache(PERM_forumfreeze & "-" & vForumInfo(FI_ForumID)))
   if bIsClosed and vMessageInfo(MI_MessageID) > 0 and (dictGeneralCache(PERM_forumreplyown & "-" & vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) = iBBSMemberID)) or (dictGeneralCache(PERM_ForumReplyOthers & "-" & vForumInfo(FI_ForumID)) and (vThreadInfo(TI_MemberID) <> iBBSMemberID)) then
     dictEnvironment.item("C-SHOWQUOTE") = 1
     dictEnvironment.item("C-SHOWREPLY") = 1
     dictEnvironment.item("U-QUOTE")     = sBBSForumRoot & "/forums/thread-post.asp?action=reply&amp;replyto=" & vMessageInfo(MI_MessageID) & "&amp;quote=yes"
     dictEnvironment.item("U-REPLY")     = sBBSForumRoot & "/forums/thread-post.asp?action=reply&amp;replyto=" & vMessageInfo(MI_MessageID)
   else
     dictEnvironment.item("C-SHOWQUOTE") = 0
     dictEnvironment.item("C-SHOWREPLY") = 0
   end if

   if bIsClosed and vMessageInfo(MI_MessageID) > 0 and (dictGeneralCache(PERM_forumeditown & "-" & vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) = iBBSMemberID)) or (  dictGeneralCache(PERM_forumeditothers & "-" & vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) <> iBBSMemberID)) then
     ' Is their time limit up?
     if iEditTime > 0 then
       if DateDiff("n",vMessageInfo(MI_DatePosted), now) > iEditTime then
         dictEnvironment("C-SHOWEDIT") = 0
       else
         dictEnvironment.item("C-SHOWEDIT") = 1
         dictEnvironment.item("U-EDIT")     = sBBSForumRoot & "/forums/thread-post.asp?action=edit&amp;mid=" & vMessageInfo(MI_MessageID)
       end if
     else
       dictEnvironment.item("C-SHOWEDIT") = 1
       dictEnvironment.item("U-EDIT")     = sBBSForumRoot & "/forums/thread-post.asp?action=edit&amp;mid=" & vMessageInfo(MI_MessageID)
     end if
   else
     dictEnvironment.item("C-SHOWEDIT") = 0
   end if

   if bIsClosed and vMessageInfo(MI_MessageID) > 0 and (dictGeneralCache(PERM_forumdeleteown & "-" & vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) = iBBSMemberID)) or ( dictGeneralCache(PERM_forumdeleteothers & "-" & vForumInfo(FI_ForumID)) and (vMessageInfo(MI_MemberID) <> iBBSMemberID)) then
     dictEnvironment.item("C-SHOWDELETE") = 1
     dictEnvironment.item("U-DELETE")     = sBBSForumRoot & "/forums/message-delete.asp?mid=" & vMessageInfo(MI_MessageID)
   else
     dictEnvironment.item("C-SHOWDELETE") = 0
   end if

   if (vMessageInfo(MI_MessageID) > 0) and (vMessageInfo(MI_Approved) = 0) and (dictConfiguration("bFORCEPOSTVALIDATION") = 1) then
     dictEnvironment.item("C-SHOWAPPROVE") = 1
     dictEnvironment.item("U-APPROVE")     = sBBSForumRoot & "/forums/message-approve.asp?mid=" & vMessageInfo(MI_MessageID)
   else
     dictEnvironment.item("C-SHOWAPPROVE") = 0
   end if

   dictEnvironment.item("V-MESSAGEIDTEXT") = "<b>" &  "</b> " & vMessageInfo(MI_MessageID)
   if vMessageInfo(MI_InReplyTo) > 0 then
     dictEnvironment.item("V-MESSAGEID") = vMessageInfo(MI_MessageID) & " - " & dictLanguage("GLOBAL-MESSAGE2") & " #" & vMessageInfo(MI_InReplyTo)
   else
     dictEnvironment.item("V-MESSAGEID") = vMessageInfo(MI_MessageID)
   end if

   if dictEnvironment.item("C-AUTHORIGNORED") then
     sBody = dictLanguage.item("THREAD-IGNORED")
   else
       if vMessageInfo(MI_ForceLineBreaks) = 1 then sBody = replace(sBody, CRLF, "<br/>")
       if vMessageInfo(MI_FilterHTML) = 1 then
         dictEnvironment("C-MBBSDECODEFILTERHTML") = 1
         sBody = BBS.ValidateField(vMessageInfo(MI_Body))
       else
         dictEnvironment("C-MBBSDECODEFILTERHTML") = 0
         sBody= vMessageInfo(MI_Body)
       end if
       sBody = BBS.FilterView(BBS.MBBSDecode(sBody, vMessageInfo(MI_Emoticons)))
       dictEnvironment("C-MBBSDECODEFILTERHTML") = 0

       ' If appropriate, do some highlighting
       vMessageInfo(MI_Subject) = BBS.ValidateField(BBS.FilterView(vMessageInfo(MI_Subject)))
       if dictEnvironment.item("C-HIGHLIGHT") = 1 then
          vMessageInfo(MI_Subject) = BBS.Highlight(vMessageInfo(MI_Subject), dictEnvironment.item("V-HIGHLIGHT"), dictEnvironment.item("V-HIGHLIGHTMODE"))
          sBody = BBS.Highlight(sBody, dictEnvironment.item("V-HIGHLIGHT"), dictEnvironment.item("V-HIGHLIGHTMODE"))
       end if

       if vMessageInfo(MI_Edited) = 1 then
         sBody = sBody & "<br/><br/><span class='smalltext'>" & dictLanguage("GLOBAL-MESSAGE4") & " " & BBS.ValidateField(vMessageInfo(MI_Lasteditedname)) & " " & BBS.GetShortDateTime(vMessageInfo(MI_Lastediteddate)) & "</span><br/>" & CRLF
       end if

       if ((vMessageInfo(MI_HasRevisions) > 0) and (dictEnvironment.item("C-SHOWREVISIONS")) and (bFeaturesUnlocked = 1))  then
         sBody = sBody & "<span class='smalltext'><br/><br/>(" & dictLanguage("GLOBAL-MESSAGEREVISION1") & " <a href='" & sBBSForumRoot & "/forums/view-revisions.asp?mid=" & vMessageInfo(MI_MessageID) & "'>" & vMessageInfo(MI_HasRevisions) & " " & dictLanguage("GLOBAL-MESSAGEREVISION2") & "</a>)</span><br/>"
       end if

       ' Check for image attachments
       if vMessageInfo(MI_HasAttachment) = 1 then
         set rsAttachments = server.createobject("ADODB.Recordset")
         SQL = "select attachmentid, filename, filesize, downloadcount from attachments where messageid=" & vMessageInfo(MI_MessageID) & " order by sortorder asc"
         rsAttachments.open SQL, dbConnection, adOpenStatic, adLockReadOnly
         BBS.AddQuery(SQL)

         if not(rsAttachments.EOF) then
           if dictConfiguration("bEMBEDIMAGES") = 1 then
             sBody = sBody &  "<br/><br/>"
             do Until rsAttachments.EOF
               sExtension = lcase(right(rsAttachments.fields("filename"), 3))
               if sExtension = "jpg" or sExtension = "gif" or sExtension = "png" or sExtension = "bmp" then
                 sBody = sBody & "<br/><div><img src='" & sBBSForumRoot & "/forums/get-attachment.asp?action=view&attachmentid=" & rsAttachments.fields(0).value & "'><br/><span class='smalltext'>(" & BBS.ValidateField(rsAttachments.fields(1).value) & ")</span><br/></div><br/>"
               end if
               rsAttachments.movenext
             loop
             rsAttachments.MoveFirst
           end if

           sBody = sBody & "<br/><br/>" & dictLanguage("GLOBAL-MESSAGE6") & "<br/>----------------<br/>"

           do Until rsAttachments.EOF
             sBody = sBody & "<span class='smalltext'><img src='" & dictImages("FILE-ATTACH-SMALL") & "' alt='" & dictLanguage("GLOBAL-MESSAGE6") & "' align='middle'> <a target='_blank' href='" & sBBSForumRoot & "/forums/get-attachment.asp?attachmentid=" & rsAttachments.fields(0).value & "'>"
             sBody = sBody & BBS.ValidateField(rsAttachments.fields(1).value) & "</a> (" & rsAttachments.fields(2).value \ 1024 & "KB - "
             sBody = sBody & rsAttachments.fields(3).value & " " & dictLanguage("GLOBAL-MESSAGE7") & ")</span><br/>"
             rsAttachments.movenext
           loop
           rsAttachments.close
         end if
       end if

       if (vMessageInfo(MI_Signature)= 1) and (vMessageInfo(MI_Anonymous)= 0) and vAuthorInfo(UI_MemberID) > 0 and (vUserInfo(UI_ViewSignature) = 1) then
         if len(vAuthorInfo(UI_Signature)) > 0 then
           sSignature = BBS.FilterView(vAuthorInfo(UI_Signature))
           if dictConfiguration("bSIGNATUREFILTERHTML") = 1 then sSignature = BBS.ValidateField(sSignature)
           sSignature = "<br/>-----<br/>" & BBS.MBBSDecode(sSignature, 0)
           sBody = sBody & sSignature
         end if
       end if
   end if

   dictEnvironment.item("V-BODY") = sBody
   dictEnvironment.item("V-MESSAGE") = vMessageInfo

   sBBSFragmentOutput = ""
   Filesystem.ExecuteFragmentTemplate ("/message.asp")
   GenerateMessage = sBBSFragmentOutput
   sBBSFragmentOutput = ""
   set rsAttachments = Nothing
  end function

  Public Function GetMessageInfo (byref iMessageID)
    ' DESCRIPTION : Returns an array filled with information on a message
    '             : If the message doesn't exist, -1 is returned for the messageid
    ' INPUTS      : The MessageID
    ' RETURNS     : A MessageInfo structure

    dim SQL, rsMessage, stResult, sKey

    sKey = "MI-" & iMessageID
    stResult = BBS.Cache(sKey)
    if not(IsEmpty(stResult)) then
      iBBSCachedHits = iBBSCachedHits + 1
      GetMessageInfo = stResult
      Exit Function
    end if
    stResult = GetMessageInfoStruct()
    set rsMessage= server.createobject("ADODB.Recordset")

    SQL = "select messageid, threadid, inreplyto, subject, body, anonymous, hostname, dateposted,messageicon, emoticons, replylevel, replyorder, signature, filterhtml, lasteditedname, lastediteddate, edited, hasattachment, isregistered, memberid, guestname, forcelinebreaks, approved, hasrevisions "
    SQL = SQL & "from messages where messageid=" & BBS.ValidateNumeric(iMessageID)
    rsMessage.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not(rsMessage.EOF) then
      stResult(MI_MessageID)      = rsMessage.fields(0).value
      stResult(MI_threadid)       = rsMessage.fields(1).value
      stResult(MI_inreplyto)      = rsMessage.fields(2).value
      stResult(MI_Subject)        = rsMessage.fields(3).value
      stResult(MI_Body)           = rsMessage.fields(4).value
      stResult(MI_Anonymous)      = rsMessage.fields(5).value
      stResult(MI_HostName)       = rsMessage.fields(6).value
      stResult(MI_DatePosted)     = rsMessage.fields(7).value
      stResult(MI_MessageIcon)    = rsMessage.fields(8).value
      stResult(MI_Emoticons)      = rsMessage.fields(9).value
      stResult(MI_ReplyLevel)     = rsMessage.fields(10).value
      stResult(MI_ReplyOrder)     = rsMessage.fields(11).value
      stResult(MI_Signature)      = rsMessage.fields(12).value
      stResult(MI_FilterHTML)     = rsMessage.fields(13).value
      stResult(MI_lasteditedname) = rsMessage.fields(14).value
      stResult(MI_lastediteddate) = rsMessage.fields(15).value
      stResult(MI_Edited)         = rsMessage.fields(16).value
      stResult(MI_HasAttachment)  = rsMessage.fields(17).value
      stResult(MI_IsRegistered)   = rsMessage.fields(18).value
      stResult(MI_MemberID)       = rsMessage.fields(19).value
      stResult(MI_GuestName)      = rsMessage.fields(20).value
      stResult(MI_ForceLineBreaks)= rsMessage.fields(21).value
      stResult(MI_Approved)       = rsMessage.fields(22).value
      stResult(MI_HasRevisions)   = rsMessage.fields(23).value
    else
      stResult(MI_MessageID)      = -1
    end if

    rsMessage.close
    set rsMessage = Nothing
    BBS.CacheAdd sKey, stResult
    GetMessageInfo = stResult

  end function

  Public Function GenerateForumDropdown(byval iCatLock, byval vSelectedForum)
    ' DESCRIPTION : Generates a form fragment listing all the available forums, nicely ordered
    ' INPUTS      : iCatLock - limit forums to a specific category?  (Leave -1 for a global forum list)
    '             : vSelectedForum - Should a forum be selected by default?  Set to -1 for no default. Can contain an array of forums
    ' RETURNS     : An HTML form fragment
    ' NOTES       : Descriptive fields have a value of -1

    dim rsForumList, iOldCategory, iNewCategory, bAllowDisplay, sResult, vResult, index, iUpperBound, SQL
    set rsForumList = server.createobject("ADODB.Recordset")
    iCatLock = BBS.ValidateNumeric(iCatLock)
    if not(IsArray(vSelectedForum)) then vSelectedForum = BBS.ValidateNumeric(vSelectedForum)

    ' sResult = sResult & "<option selected value='-1'>" & dictLanguage("GLOBAL-PICKFORUM") & "</option>"

    if iCatLock > 0 then
      SQL = "select categories.name, categories.categoryid, forums.forumid, forums.forumname from forums left outer join categories on forums.categoryid=categories.categoryid where categories.categoryid=" & BBS.ValidateNumeric(iCatLock) & " order by categories.sortorder ASC, forums.sortorder ASC"
    else
      SQL = "select categories.name, categories.categoryid, forums.forumid, forums.forumname from forums left outer join categories on forums.categoryid=categories.categoryid  order by categories.sortorder, forums.sortorder"
    end if

    rsForumList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    bAllowDisplay = True

    if (rsForumList.EOF) then
      rsForumList.Close
      exit function
    else
      vResult = rsForumList.GetRows
      rsForumList.Close
      iUpperBound = UBOUND(vResult, 2)
    end if

    for index=0 to iUpperBound

      ' Check if the user can list the forum
      if BBS.HasPermission(PERM_FORUMACCESS, vResult(2, index)) then

        ' If this is a new category, list the category name
        iNewCategory = vResult(1, index)
        if BBS.ValidateNumeric(iNewCategory) <> BBS.ValidateNumeric(iOldCategory) then
          sResult = sResult & "<option value='-1'></option>"
          sResult = sResult & "<option value='-1'> " & BBS.ValidateField(vResult(0, index)) & "</option>"
          sResult = sResult & "<option value='-1'>----------------------</option>"
          iOldCategory = iNewCategory
        end if

        if IsArray(vSelectedForum) then
          sResult = sResult &  "<option " & BBS.IsSelected(BBS.InArray(vResult(2, index), vSelectedForum)) & " value='" & vResult(2, index) & "'> + " & BBS.ValidateField(vResult(3, index)) & "</option>"
        else
          sResult = sResult &  "<option " & BBS.IsSelected(vResult(2, index) = vSelectedForum) & " value='" & vResult(2, index) & "'> + " & BBS.ValidateField(vResult(3, index)) & "</option>"
        end if
      else
        ' Cannot list this forum
      end if

    next
    GenerateForumDropdown = sResult
  end function

  Public Function GetNotificationMethod(byref iMemberID, byref iThreadID)
    ' DESCRIPTION : Get a member's email notification preference for a thread
    ' INPUTS      : iMemberID - Member ID
    '             : iThreadID - Thread ID
    ' RETURNS     : The notification preference

    dim result, rsNotify, SQL, vUserInfo
    set rsNotify = server.createobject("ADODB.Recordset")

    SQL = "select type from notifications where memberid=" & BBS.ValidateNumeric(iMemberID) & " AND threadid=" & BBS.ValidateNumeric(iThreadID)
    rsNotify.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if rsNotify.EOF then
      rsNotify.Close
      SQL = "select notificationpreference from members where memberid=" & BBS.ValidateNumeric(iMemberID)
      rsNotify.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)
      if not(rsNotify.EOF) then
        GetNotificationMethod = rsNotify.fields(0).value
      else
        GetNotificationMethod = "none"
      end if
    else
      getNotificationMethod = rsNotify.fields(0).value
    end if

    rsNotify.Close
    set rsNotify = Nothing
  end function


  Public Function SetNotification(byref iMemberID, byref iThreadID, byref sType)
    ' DESCRIPTION : Sets a members notification preference for a thread
    ' INPUTS      : iMemberID - MemberID
    '             : iThreadID - ThreadID
    '             : sType     - Type of notification
    ' RETURNS     : True if successful, false otherwise

    dim result, rsNotify, SQL, iResults
    set rsNotify = server.createobject("ADODB.Recordset")


    SQL = "select count(memberid) from notifications where memberid=" & BBS.ValidateNumeric(iMemberID) & " AND threadid=" & BBS.ValidateNumeric(iThreadID)
    rsNotify.open SQL, dbConnection, adOpenStatic, adLockOptimistic
    BBS.AddQuery(SQL)

    if rsNotify.EOF then
      iResults = 0
    else
      iResults = BBS.ValidateNumeric(rsNotify.fields(0).value)
    end if
    rsNotify.Close

    if iResults = 0 then
      SQL = "Insert Into notifications(memberid, threadid, type) Values(" & BBS.ValidateNumeric(iMemberID) & ", " & BBS.ValidateNumeric(iThreadID) & ", "
      if ucase(sType) = "EMAIL" or sType="1" then
         SQL = SQL & "'email')"
       else
         SQL = SQL & "'none')"
      end if
    else
      if ucase(sType) = "EMAIL" or sType="1" then
         SQL = "update notifications set type = 'email'"
       else
         SQL = "update notifications set type = 'none'"
      end if
    end if
    dbconnection.execute SQL
    BBS.AddQuery(SQL)

    set rsNotify = Nothing
    SetNotification = True
  end function

  Public Sub DeleteNotification(byval iMemberID, byval iThreadID)
    ' DESCRIPTION : Deletes a notification
    dim SQL
    SQL = "delete from notifications where threadid=" & BBS.ValidateNumeric(iThreadID) & " and memberid=" & BBS.ValidateNumeric(iMemberID)
    dbConnection.execute SQL,, adTextNoRecords
  end Sub

  Public Sub DeleteAllNotifications(byval iMemberID)
    ' DESCRIPTION : Deletes all of a user's notifications
    dim SQL
    SQL = "delete from notifications where memberid=" & BBS.ValidateNumeric(iMemberID)
    dbConnection.execute SQL,, adTextNoRecords
  end sub

  Public function IsMassSubscribed(byval iMemberID, byval iForumID)
    dim SQL, rsInfo
    set rsInfo = server.createobject("ADODB.Recordset")

    SQL = "select memberid from massnotifications where memberid=" & BBS.ValidateNumeric(iMemberID) & " and forumid=" & BBS.ValidateNumeric(iForumID)
    rsInfo.open sql, dbConnection, adOpenStatic, adLockReadOnly
    IsMassSubscribed = not(rsInfo.EOF)
    rsInfo.Close
    set rsInfo = Nothing
  end function

  public function MassSubscribe(byval iMemberID, byval iForumID)
    dim SQL
    SQL = "insert into massnotifications (memberid, forumid) values(" & BBS.ValidateNumeric(iMemberID) & ", " & BBS.ValidateNumeric(iForumID) & ")"
    dbConnection.Execute SQL,, adTextNoRecords
  end function

  public function MassUnSubscribe(byval iMemberID, byval iForumID)
    dim SQL
    SQL = "delete from massnotifications where memberid=" & BBS.ValidateNumeric(iMemberID) & " and forumid=" & BBS.ValidateNumeric(iForumID)
    dbConnection.Execute SQL,, adTextNoRecords
  end function


  Public Function ProcessNotifications(byref sPosterUsername, byref bIsRegisteredUser, byref iNotifythreadid, byval sLastPostBody)
    ' DESCRIPTION : Sends out e-mail notifications to appropriate users
    ' INPUTS      : sPosterUsername - The name of the user who posted a message
    '             : bIsRegisteredUser - Was the poster a registered user?
    '             : iNotifyThreadID - The Thread ID
    ' RETURNS     : True if successful, false otherwise

    dim iForumID, sThreadSubject, sBody, vResult, index, iUpperBound, sBodyText, rsUserList, sSubject, dSentList, vThreadInfo
    vThreadInfo = GetThreadInfo(iNotifyThreadID)
    set rsUserList = server.createobject("ADODB.Recordset")
    sLastPostBody = BBS.StripHTML(sLastPostBody)

    SQL = "select forumid, threadsubject from threads where threadid=" & BBS.ValidateNumeric(iNotifyThreadID)
    rsUserList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if rsUserList.EOF then
      rsUserList.Close
      ProcessNotifications = False
      exit function
    else
      iForumID = rsUserList.fields(0).value
      sThreadSubject = rsUserList.fields(1).value
      rsUserList.Close
    end if

    ' The sent list will contain all the members we've sent notifications to, so they don't get sent twice
    set dSentList = server.createobject("Scripting.Dictionary")
    dSentList.Comparemode = 0
    if bIsRegisteredUser=1 then dSentList.add ucase(sPosterUsername), True

    sSubject = sThreadSubject & ": " & dictLanguage("GLOBAL-NOTIFICATION")
    if  bBBSBadWordFilterOnDisplay = 1 then sthreadsubject = BBS.FilterWords(sthreadsubject)

    sBody = sBody & dictLanguage("GLOBAL-NOTIFICATION1") & crlf
    sBody = sBody & sPosterUsername & " " & dictLanguage("GLOBAL-NOTIFICATION2") & CRLF & dictLanguage("GLOBAL-NOTIFICATION3") & CRLF
    sBody = sBody & sBBSUnvalidatedBaseURL & "/forums/thread-view.asp?tid=" & vThreadInfo(TI_ThreadID) & "#M" & vThreadInfo(TI_LastPostID) & CRLF & CRLF
    sBody = sBody & dictLanguage("GLOBAL-NOTIFICATION4") & CRLF & sBBSUnvalidatedBaseURL & "/profile/controlpanel.asp" & CRLF & CRLF
    sLastPostBody = "--------------------------------------------------------" & CRLF & sLastPostBody & CRLF & "--------------------------------------------------------"

    ' Send out notifications to users who have explicitly subscribed to this thread
    SQL = "select distinct members.username, members.memberid, members.emailaddress, includebody from notifications, members WHERE notifications.memberid=members.memberid and notifications.type='email' and notifications.threadid=" & BBS.ValidateNumeric(iNotifythreadID)
    rsUserList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if rsUserList.EOF then
      iUpperBound = -1
    else
      vResult = rsUserList.GetRows
      iUpperBound = UBOUND(vResult, 2)
    end if
    rsUserList.Close

    for index=0 to iUpperBound
      if not(dSentList.exists(ucase(vResult(0, index)))) then
        dSentList.add ucase(vResult(0, index)), True

        ' Only send the notification if the user really has access to this forum
        if BBS.MemberHasPermission(vResult(1, index), PERM_forumaccess, iForumID) then
          if vResult(3, index) = 1 then
            ' Include body
            Messenger.SendMail dictConfiguration("sMAILSERVERADDRESS"), vResult(2, index), dictConfiguration("sADMINEMAIL"), sSubject, sBody & sLastPostBody, dictConfiguration("sEMAILCOMPONENT")
          else
            Messenger.SendMail dictConfiguration("sMAILSERVERADDRESS"), vResult(2, index), dictConfiguration("sADMINEMAIL"), sSubject, sBody, dictConfiguration("sEMAILCOMPONENT")
          end if
        end if
      end if
    next

    ' send out notifications to users who have mass-subscribed to this forum
    SQL = "select distinct members.username, members.memberid, members.emailaddress, members.includebody from massnotifications, members WHERE massnotifications.memberid=members.memberid and massnotifications.forumid=" & BBS.ValidateNumeric(iForumID)
    rsUserList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if rsUserList.EOF then
      iUpperBound = -1
    else
      vResult = rsUserList.GetRows
      iUpperBound = UBOUND(vResult, 2)
    end if
    rsUserList.Close

    for index=0 to iUpperBound
      if not(dSentList.exists(ucase(vResult(0, index)))) then
        dSentList.add ucase(vResult(0, index)), True

        ' Only send the notification if the user really has access to this forum
        if BBS.MemberHasPermission(vResult(1, index), PERM_forumaccess, iForumID) and BBS.MemberHasPermission(vResult(1, index), PERM_canmasssubscribe, iForumID) then
          if vResult(3, index) = 1 then
            ' Include body
            Messenger.SendMail dictConfiguration("sMAILSERVERADDRESS"), vResult(2, index), dictConfiguration("sADMINEMAIL"), sSubject, sBody & sLastPostBody, dictConfiguration("sEMAILCOMPONENT")
          else
            Messenger.SendMail dictConfiguration("sMAILSERVERADDRESS"), vResult(2, index), dictConfiguration("sADMINEMAIL"), sSubject, sBody, dictConfiguration("sEMAILCOMPONENT")
          end if
        end if
      end if
    next


    ProcessNotifications = True
    set rsUserList = Nothing
  end function


  Public Function GeneratePagingDropdown(byref iforumid, byref iBookmark, byval sForumViewMode, byval sType)
    ' DESCRIPTION : For a given Forum, create a paging system with a dropdown box that allows the user to skip to a page of threads
    ' INPUTS      : iForumID - The ForumID
    '             : iBookmark - The current thread number
    '             : iNumberOfThreads - Number of threads per page
    '             : sType - "dropdown" or "list"
    ' RETURNS     : HTML string

    dim rsThreadCount, SQL, iThreadCount, iDivisor, iNumPages, iIndex, iCurrentPage, sResult
    dim iStartPage, iEndPage, iDayFilter

    set rsThreadCount = server.createobject("ADODB.Recordset")
    iDayFilter = BBS.ValidateNumeric(request.cookies(sBBSCookieRoot & "dayfilter"))
    ' if iDayFilter = 0 then iDayFilter = 90

    if BBS.ValidateNumeric(request.cookies(sBBSCookieRoot & "yearfilter")) > 0 then
      if BBS.ValidateNumeric(request.cookies(sBBSCookieRoot & "monthfilter")) > 0 then
        SQL = SQL & "select count(threadid) as threadcount from threads where lastactivity>=" & sDateDelimiter & BBS.GetSQLDate(dateserial(request.cookies(sBBSCookieRoot & "yearfilter"), request.cookies(sBBSCookieRoot & "monthfilter"), 1)) & sDateDelimiter & " "
        SQL = SQL & " and lastactivity<" & sDateDelimiter & BBS.GetSQLDate(dateserial(request.cookies(sBBSCookieRoot & "yearfilter"), request.cookies(sBBSCookieRoot & "monthfilter")+1, 1)) & sDateDelimiter & " and forumid=" & BBS.ValidateNumeric(iForumID)
      else
        SQL = SQL & "select count(threadid) as threadcount from threads where lastactivity>=" & sDateDelimiter & BBS.GetSQLDate(dateserial(request.cookies(sBBSCookieRoot & "yearfilter"), 1, 1)) & sDateDelimiter & " and forumid=" & BBS.ValidateNumeric(iForumID)
        SQL = SQL & " and lastactivity<" & sDateDelimiter & BBS.GetSQLDate(dateserial(request.cookies(sBBSCookieRoot & "yearfilter")+1, 1, 1)) & sDateDelimiter & " "
      end if
    elseif iDayFilter > 0 then
      SQL = SQL & "select count(threadid) as threadcount from threads where lastactivity>=" & sDateDelimiter & BBS.GetSQLDate(dateadd("D", -1 * iDayFilter, now)) & sDateDelimiter & "  and forumid=" & BBS.ValidateNumeric(iForumID)
    else
      SQL = "select threadcount from forums where forumid=" & BBS.ValidateNumeric(iForumID)
    end if
    rsThreadCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    iThreadCount = rsThreadCount.fields(0).value
    rsThreadCount.Close

    iDivisor = dictConfiguration("iFORUMTHREADPAGESIZE")

    iCurrentPage = int((iBookmark-1) / iDivisor)
    iNumPages = int((iThreadCount-1) / iDivisor)

    ' If we are generating a dropdown box, then create the initial form framework
    if ucase(sType) = "DROPDOWN" then
      'sResult = sResult & "<script type='text/javascript'>" & CRLF
      'sResult = sResult &  "function updatePage(iNewBookmark)" & CRLF
      'sResult = sResult &  "{" & CRLF
      'sResult = sResult &  "  window.location = document.location.pathname + ""?fid=" & vForumInfo(FI_ForumID) & " &amp;Bookmark="" + iNewBookmark + ""&amp;DisplayType=" & sForumViewMode & """" & CRLF
      'sResult = sResult &  "}</script>" & CRLF
      sResult = sResult & "<form name='containerBookmark' action='forum-view.asp?fid=" & vForumInfo(FI_ForumID) & "' method='post'>" & CRLF
      sResult = sResult & "<input type='hidden' name='forumid' value='" & BBS.ValidateNumeric(iforumid) & "'>" & CRLF
      sResult = sResult & "<input type='hidden' name='DisplayType' value='" & BBS.ValidateField(sForumViewMode) & "'>" & CRLF
      sResult = sResult & "<select class='bbsdropdownbox' name='Bookmark' onchange='updatePage(this.options.selectedIndex.value)' size='1'>" & CRLF
    end if

    ' If the viewmode is LIST, and there are more than six pages, then do things a little differently
    if ucase(sType) = "LIST" and iNumPages > 6 then
      ' Write the gofirst link
      sResult = sResult & " <a href='forum-view.asp?fid=" & BBS.ValidateNumeric(iforumid) & "&amp;bookmark=" & (1) & "&amp;displaytype=" & BBS.ValidateField(sForumViewMode) & "'><</a> "

      ' Find the starting page
      iIndex = BBS.Maximum(iCurrentPage - 6, 0)
      for iIndex = iIndex to iCurrentPage-1
        sResult = sResult & " <a href='forum-view.asp?fid=" & BBS.ValidateNumeric(iforumid) & "&amp;bookmark=" & (iIndex * iDivisor)+1 & "&amp;displaytype=" & BBS.ValidateField(sForumViewMode) & "'>" & iIndex + 1 & "</a> "
      next

      ' Write some ellipsis
      if iCurrentPage-6 > 0 then sResult = sResult & " ... "

      ' Write the current page
      sResult = sResult & " " & iIndex + 1 & " "

      ' Write the last pages (up to six)
      ' Find the starting page
      iEndPage= BBS.Minimum(iCurrentPage + 6, iNumPages)
      for iIndex = iCurrentPage+1 to iEndPage
        sResult = sResult & " <a href='forum-view.asp?fid=" & BBS.ValidateNumeric(iforumid) & "&amp;bookmark=" & (iIndex * iDivisor)+1 & "&amp;displaytype=" & BBS.ValidateField(sForumViewMode) & "'>" & iIndex + 1 & "</a> "
      next

      if iCurrentPage + 6 < iNumPages then sResult = sResult & " ... "


      ' Write the golast link
      sResult = sResult & " <a href='forum-view.asp?fid=" & BBS.ValidateNumeric(iforumid) & "&amp;bookmark=" & (iNumPages * iDivisor)+1 & "&amp;displaytype=" & BBS.ValidateField(sForumViewMode) & "'>></a> "

      GeneratePagingDropdown = sResult
      exit function
    end if

    for iIndex=0 to iNumPages
      if ucase(sType) = "LIST" then
        ' response.write iIndex & "-" & iCurrentPage
        if iIndex = iCurrentPage then
          sResult = sResult & " " & iIndex + 1 & " "
        else
          sResult = sResult & " <a href='forum-view.asp?fid=" & BBS.ValidateNumeric(iforumid) & "&amp;bookmark=" & (iIndex * iDivisor)+1 & "&amp;displaytype=" & BBS.ValidateField(sForumViewMode) & "'>" & iIndex + 1 & "</a> "
        end if

      elseif ucase(sType) = "DROPDOWN" then

        if iIndex = iCurrentPage then
          sResult = sResult & "<option SELECTED value='" & (iIndex * iDivisor)+1 & "'>" & iIndex + 1 & "</option>" & CRLF
        else
          sResult = sResult & "<option value='" & (iIndex * iDivisor)+1 & "'>" & iIndex + 1 & "</option>" & CRLF
        end if
      end if

    next

    ' If we are generating a dropdown box, then create the closing form framework
    if ucase(sType) = "DROPDOWN" then
      sResult = sResult & "</select>"
      sResult = sResult & " <input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-GO") & "'>"
      sResult = sResult & "</form>" & CRLF
    end if

    GeneratePagingDropdown = sResult
    set rsThreadCount = Nothing
  end function

  Public Function ReindexThread (iThreadID)
   ' DESCRIPTION : Corrects the ReplyOrder and ReplyLevel fields of a thread- Makes recursive calls to ReIndex()
   ' INPUTS      : iThreadID - ThreadID
   ' RETURNS     : True if successful, false otherwise

   dim SQL, iRootMessageID

   ' Use the global reindex recordset. Cheap? Yes
   set rsReindexer = Server.CreateObject("ADODB.Recordset")

   SQL = "update messages set replyorder=0, replylevel=0 where inreplyto=-1 and threadid=" & BBS.ValidateNumeric(ithreadid)
   dbConnection.Execute SQL,, adTextNoRecords
   BBS.AddQuery(SQL)

   ' Grab a snapshot of the thread
   SQL = "select messageid, replyorder, replylevel, inreplyto, dateposted from messages where threadid=" & BBS.ValidateNumeric(ithreadid)
   rsReindexer.cursorlocation = adUseClient
   rsReindexer.open SQL, dbConnection, adOpenStatic, adLockOptimistic

   if not rsReindexer.EOF then
     Reindex -1, 0, 0
     rsReindexer.Close
   end if

   ReindexThread = True
  end function

  Public Function ReIndex (byref iMessageID, byVal iReplyLevel, byref iReplyOrder)
    ' DESCRIPTION : Corrects the ReplyOrder and ReplyLevel fields of a thread beginning at a Message ID- Intended to be called recursively
    ' INPUTS      : iMessageID - MessageID to reindex
    '             : iReplyLevel - Reply level of the message, used in nested/threaded
    '             : iReplyOrder - Message's order ID
    ' RETURNS     : True if successful, false otherwise


    dim iLevel, iOrder, SQL, vResult, index, iUpperBound, iBookMark

    rsReindexer.filter = "inreplyto=" & iMessageID
    rsReindexer.sort = "dateposted asc"
    do until rsReindexer.EOF
      iBookMark = rsReindexer.Bookmark

      rsReindexer.fields("replylevel").value = iReplyLevel
      rsReindexer.fields("replyorder").value = iReplyOrder
      rsReindexer.Update
      iReplyOrder = iReplyOrder + 1

      ReIndex rsReindexer.fields("messageid").value, iReplyLevel + 1, iReplyOrder

      ' Reset the filter. Argh this is insane
      rsReindexer.filter = "inreplyto=" & iMessageID
      rsReindexer.Bookmark = iBookmark
      rsReindexer.MoveNext
    loop

  end function

  Public Function SetThreadAttachment(byref iThreadID, byref iStatus)
    ' DESCRIPTION : Sets a message's attachment status
    ' INPUTS      : iMessageID - MessageID
    '             : iStatus - 0 or 1

    dim SQL, sKey
    sKey = "TI-" & iThreadID
    SQL = "update threads set hasattachment=" & BBS.ValidateNumeric(iStatus) & " where threadid=" & BBS.ValidateNumeric(iThreadID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDelete(sKey)
  end function

  Public Function SetMessageAttachment(byref iMessageID, byref iStatus)
    ' DESCRIPTION : Sets a message's attachment status
    ' INPUTS      : iMessageID - MessageID
    '             : iStatus - 0 or 1

    dim SQL
    SQL = "update messages set hasattachment=" & BBS.ValidateNumeric(iStatus) & " where messageid=" & BBS.ValidateNumeric(iMessageID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDelete("MI-" & iMessageID)
  end function

  Public Function UpdateAttachments(byref iMessageID)
    ' DESCRIPTION : Updates thread and message database tables related to attachments
    '             : IF any messages in a thread have an attachment set, set the attachment property of the thread
    ' INPUTS      : iMessageID - The MessageID
    ' RETURNS     : True if attachments are found, false otherwise

    dim iThreadID, rsAttachment, SQL, iAttachCount

    set rsAttachment = server.createobject("ADODB.Recordset")
    ' If this message has attachments associated with it, set messages.hasattachment = 1
    SQL = "select messages.threadid from attachments, messages where messages.messageid = attachments.messageid and messages.messageid=" & BBS.ValidateNumeric(iMessageID)
    rsAttachment.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if rsAttachment.EOF then

      ' This particular message did not have an attachment
      rsAttachment.Close
      SetMessageAttachment iMessageID, 0

      ' Find out if the thread has any attachments at all
      SQL = "select threadid from messages where messageid=" & BBS.ValidateNumeric(iMessageID)
      rsAttachment.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)
      iThreadID = rsAttachment.fields(0).value
      rsAttachment.Close

      SQL = "select count(attachmentid) as attachcount from attachments, messages where attachments.messageid=messages.messageid and messages.threadid=" & BBS.ValidateNumeric(iThreadID)
      rsAttachment.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)

      if rsAttachment.EOF then
        iAttachCount = 0
      else
        iAttachCount = BBS.ValidateNumeric(rsAttachment.fields(0).value)
      end if
      rsAttachment.Close

      if iAttachCount = 0 then
        ' This thread has no attachments
        SetThreadAttachment iThreadID, 0
        UpdateAttachments = False
      else
        ' This thread has attachments
        SetThreadAttachment iThreadID, 1
        UpdateAttachments = True
      end if


    else

      ' This message has an attachment.  Set the attachment flag for both the message and the thread
      iThreadID = rsAttachment.fields(0).value
      rsAttachment.Close
      UpdateAttachments = True

      SetMessageAttachment iMessageID, 1
      SetThreadAttachment iThreadID, 1
    end if
    set rsAttachment = Nothing
  end function



  Public Function GetThreadPostCount(byref iThreadID)
    ' DESCRIPTION : Retrieves the number of posts in a thread
    ' INPUTS      : iThreadID - ThreadID

    dim SQL, rsPostCount
    set rsPostCount = server.createobject("ADODB.Recordset")

    SQL = "Select count(*) as totalposts from messages where threadid=" & BBS.ValidateNumeric(iThreadID)
    rsPostCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    GetThreadPostCount = rsPostCount(0).value
    rsPostCount.close
    set rsPostCount = Nothing
  end function

  Public Function GetForumPostCount(byref iforumid)
    ' DESCRIPTION : Retrieves the number of posts in a forum
    ' INPUTS      : iForumID - ForumID

    dim SQL, rsPostCount
    set rsPostCount = server.createobject("ADODB.Recordset")
    SQL = "select count(*) as totalposts from messages, threads where messages.threadid=threads.threadid and threads.forumid=" & BBS.ValidateNumeric(iforumid)
    rsPostCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    GetForumPostCount = rsPostCount(0).value
    rsPostCount.close
    set rsPostCount = Nothing
  end function

  Public Function GetForumThreadCount(byref iforumid)
    ' DESCRIPTION : Retrieves the number of threads in a forum
    ' INPUTS      : iForumID - ForumID

    dim SQL, rsThreadCount
    set rsThreadCount = server.createobject("ADODB.Recordset")
    SQL = "select count(*) as totalthreads from threads where forumid=" & BBS.ValidateNumeric(iforumid)
    rsThreadCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    GetForumThreadCount = rsThreadCount(0).value
    rsThreadCount.close
    set rsThreadCount = Nothing
  end function


  Public Function DeleteForum(byref iForumID, byref bUpdatePostcounts)
    ' DESCRIPTION : Deletes a forum
    ' INPUTS      : iForumID          - The forum ID
    '               bUpdatePostCounts - Set to 1 if you want to decrement users post counts after deleting the messages.
    ' RETURNS     : True if successful, false otherwise

    dim rsPostCount, SQL, vMessages, index, iUpperBound, rsAttachments
    set rsPostCount   = server.createobject("ADODB.Recordset")
    set rsAttachments = server.createobject("ADODB.Recordset")

    if bUpdatePostcounts = 1 then

      SQL = "select messages.memberid, count(*) as messagetotal from messages, threads where threads.threadid=messages.threadid and threads.forumid=" & BBS.ValidateNumeric(iForumID) & " and messages.isregistered =1 group by messages.memberid"
      rsPostCount.open SQL, dbCOnnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)

      if not(rsPostCount.EOF) then
        vMessages = rsPostCount.GetRows
        iUpperBound = UBOUND(vMessages, 2)
      else
        iUpperBound = -1
      end if
      rsPostCount.Close

      for index=0 to iUpperBound
        OffsetUserPostcount vMessages(0, index), vMessages(1, index) * -1
      next

    end if

    SQL = "select messageid from messages, threads where messages.threadid=threads.threadid and threads.forumid=" & BBS.ValidateNumeric(iForumID)
    rsPostCount.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    do until rsPostCount.EOF
       SQL = "select attachmentid from attachments where messageid=" & rsPostCount.Fields("messageid").value
       rsAttachments.open SQL, dbConnection, adOpenStatic, adLockReadOnly
       BBS.AddQuery(SQL)

       do until rsAttachments.EOF
         DeleteAttachment rsAttachments.fields("attachmentid").value, rsPostCount.fields("messageid").value
         rsAttachments.Movenext
       loop
       rsAttachments.Close
       rsPostCount.MoveNext
    loop
    rsPostCount.Close

    if ucase(sBBSDatabaseType) = "MYSQL" Then
      SQL = "delete notifications from notifications inner join threads on notifications.threadid=threads.threadid where threads.forumid=" & BBS.ValidateNumeric(iforumid)
    else
      SQL = "delete from notifications where threadid in (select threadid from threads where forumid = " & BBS.ValidateNumeric(iforumid) & ")"
    end if
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    if ucase(sBBSDatabaseType) = "MYSQL" Then
      SQL ="delete messages from messages inner join threads on messages.threadid=threads.threadid where threads.forumid = " & BBS.ValidateNumeric(iforumid)
    else
      SQL ="Delete from messages where threadid in (select threadid from threads where forumid = " & BBS.ValidateNumeric(iforumid) & ")"
    end if
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from userlevelmembers where moduleid=" & MODULE_Forums & " and targetid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from permissions where moduleid=" & MODULE_Forums & " and targetid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from forums  where forumid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from threads where forumid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from permissions where moduleid=" & MODULE_Forums & " and targetid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    SQL ="Delete from userlevelmembers where moduleid=" & MODULE_Forums & " and targetid=" & BBS.ValidateNumeric(iforumid)
    dbConnection.execute  SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDeleteall

    DeleteForum = True
    set rsPostCount   = Nothing
    set rsAttachments = Nothing

  end function

  Public Function CreateRank(byref sRankName, byref iMinPosts, byref iMinDays)
    ' DESCRIPTION : Creates a new rank
    ' INPTUS      : The rankname, minimum # of posts, min # of days
    ' RETURNS     : The newly created RankID

    dim SQL, iNewRankID, rsNewRank
    set rsNewRank = server.createobject("ADODB.Recordset")

    SQL = "insert into customranks (rankname, minposts, mindays) VALUES('" & BBS.ValidateSQL(sRankName) & "', " & BBS.ValidateNumeric(iMinPosts) & ", " & BBS.ValidateNumeric(iMinDays) & ")"
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDelete("CUSTOMRANKS")

    SQL = "select @@IDENTITY"
    rsNewRank.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)

    if rsNewRank.EOF then
      CreateRank = 0
    else
      CreateRank = clng(rsNewRank.fields(0).value)
    end if
    rsNewRank.Close
    set rsNewRank = Nothing
  end function

  Public Function DeleteRank(byref iRankID)
    ' DESCRIPTION : Deletes a rank
    ' INPUTS      : The rank ID
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from customranks where rankid=" & BBS.ValidateNumeric(iRankID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDelete("CUSTOMRANKS")
    DeleteRank = True
  end function

  Public Function CreateThread(byref vThreadInfo)
    ' DESCRIPTION : Creates a thread
    ' INPUTS      : A threadinfo structure
    ' RETURNS     : The newly created threadid

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into threads (forumid, totalposts, datecreated, lastactivity, threadsubject, anonymous, closed, timesviewed, sticky, haspoll, pollid, hasattachment, lastposteranonymous, lastpostermemberid, lastposterisregistered, lastposterguestname, memberid, isregistered, guestname,approved) VALUES("
    SQL = SQL & BBS.ValidateNumeric(vThreadInfo(TI_ForumID)) & ", " & BBS.ValidateNumeric(vThreadInfo(TI_TotalPosts)) & ", " & sDateDelimiter & BBS.GetSQLDateTime(vThreadInfo(TI_DateCreated)) & sDateDelimiter & ", " & sDateDelimiter & BBS.GetSQLDateTime(vThreadInfo(TI_LastActivity)) & sDateDelimiter & ", '" & BBS.SQLTrim(vThreadInfo(TI_Subject), 100) & "', " & BBS.ValidateNumeric(vThreadInfo(TI_Anonymous)) & ", " & BBS.ValidateNumeric(vThreadInfo(TI_Closed)) & ", " & BBS.ValidateNumeric(vThreadInfo(TI_Timesviewed)) & ", " & BBS.ValidateNumeric(vThreadInfo(TI_Sticky)) & ", " & BBS.ValidateNumeric(vThreadInfo(TI_HasPoll)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vThreadInfo(TI_PollID)) & ", "& BBS.ValidateNumeric(vThreadInfo(TI_HasAttachment)) & ", "& BBS.ValidateNumeric(vThreadInfo(TI_LastPosterAnonymous)) & ", "& BBS.ValidateNumeric(vThreadInfo(TI_LastPosterMemberID)) & ", "& BBS.ValidateNumeric(vThreadInfo(TI_LastPosterIsRegistered)) & ", '" & BBS.SQLTrim(vThreadInfo(TI_LastPosterGuestName), 20) & "', "& BBS.ValidateNumeric(vThreadInfo(TI_MemberID)) & ", "& BBS.ValidateNumeric(vThreadInfo(TI_IsRegistered)) & ", '" & BBS.SQLTrim(vThreadInfo(TI_Guestname), 20) & "'," & BBS.ValidateNumeric(vThreadInfo(TI_Approved)) & ")"

    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "select @@IDENTITY"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)
    if rsNewID.EOF then
      CreateThread= 0
    else
      CreateThread= clng(rsNewID.fields(0).value)
    end if
    rsNewID.Close
    set rsNewID = Nothing
  end function

  Public Function UpdateThread(byref vThreadInfo)
    ' DESCRIPTION : Updates a thread
    ' INPUTS      : A threadinfo structure
    ' RETURNS     : True if successful

    dim SQL, sKey
    sKey = "TI-" & vThreadInfo(TI_ThreadID)

    SQL = "update threads set forumid=" & BBS.ValidateNumeric(vThreadInfo(TI_ForumID)) & ", totalposts=" & BBS.ValidateNumeric(vThreadInfo(TI_TotalPosts)) & ", datecreated=" & sDateDelimiter &BBS.GetSQLDateTime(vThreadInfo(TI_DateCreated)) & sDateDelimiter &", BBS.GetSQLDateTime=" & sDateDelimiter &BBS.ValidateNumeric(vThreadInfo(TI_LastActivity)) & sDateDelimiter &", threadsubject='" & BBS.SQLTrim(vThreadInfo(TI_ForumID), 100) & "', anonymous=" & BBS.ValidateNumeric(vThreadInfo(TI_Anonymous)) & ", closed=" & BBS.ValidateNumeric(vThreadInfo(TI_Closed)) & ", timesviewed=" & BBS.ValidateNumeric(vThreadInfo(TI_Timesviewed)) & ", sticky=" & BBS.ValidateNumeric(vThreadInfo(TI_Sticky)) & ", haspoll=" & BBS.ValidateNumeric(vThreadInfo(TI_HasPoll)) & ", pollid=" & BBS.ValidateNumeric(vThreadInfo(TI_PollID)) & ", hasattachment=" & BBS.ValidateNumeric(vThreadInfo(TI_HasAttachment)) & ", lastposteranonymous=" & BBS.ValidateNumeric(vThreadInfo(TI_LastPosterAnonymous)) & ", lastpostermemberid=" & BBS.ValidateNumeric(vThreadInfo(TI_LastPosterMemberID)) & ", lastposterisregistered=" & BBS.ValidateNumeric(vThreadInfo(TI_LastPosterIsRegistered)) & ", lastposterguestname='" & BBS.SQLTrim(vThreadInfo(TI_LastPosterGuestName),20) & "', memberid=" & BBS.ValidateNumeric(vThreadInfo(TI_Memberid)) & ", isregistered=" & BBS.ValidateNumeric(vThreadInfo(TI_IsRegistered)) & ", guestname='" & BBS.SQLTrim(vThreadInfo(TI_Guestname),20) & "' where threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
    BBS.AddQuery(SQL)
    dbConnection.execute SQL,, adTextNoRecords

    ' Update the cache
    BBS.CacheDelete(sKey)
    UpdateThread = True
  end function

  Public Function DeleteThread(byref iThreadID, byref bUpdateCounts)
    ' DESCRIPTION : Deletes a thread
    ' INPUTS      : The thread ID
    ' RETURNS     : True if successful

    dim SQL, sKey, rsCounts, vThreadInfo, vUserInfo, rsAttachments, rsMID
    sKey = "TI-" & iThreadID

    set rsAttachments = server.CreateObject("ADODB.Recordset")
    set rsMID         = server.CreateObject("ADODB.Recordset")
    vThreadInfo = GetThreadInfo(iThreadID)

    ' Update post counts?
    if bUpdateCounts = 1 then
      set rsCounts = server.createobject("ADODB.Recordset")
      SQL = "select count(*) as messagecount, memberid from messages where isregistered=1 and threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID)) & " group by memberid"
      rsCounts.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      do until rsCounts.EOF
        OffsetUserPostcount rsCounts.fields(1).value, rsCounts.fields(0).value * -1
        rsCounts.MoveNext
      loop
      rsCounts.Close
    end if


    ' Delete the alerts attached to messages in this thread
    SQL = "select messageid from messages where threadid=" & BBS.ValidateNumeric(iThreadID)
    rsMID.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    do until rsMID.EOF
      SQL = "delete from alerts where messageid=" & rsMID.fields(0).value
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
      rsMID.MoveNExt
    loop
    rsMID.Close
    set rsMID = Nothing

    ' Delete attachments
    SQL = "select attachments.attachmentid, attachments.messageid from attachments, messages where messages.messageid=attachments.messageid and messages.threadid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
    rsAttachments.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    do until rsAttachments.EOF
      DeleteAttachment rsAttachments.fields("attachmentid").value, rsAttachments.fields("messageid").value
      rsAttachments.MoveNext
    loop

    ' Delete the messages
    SQL = "delete from messages where threadid=" & BBS.ValidateNumeric(iThreadID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    ' Delete the thread
    SQL = "delete from threads where threadid=" & BBS.ValidateNumeric(iThreadID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
    BBS.CacheDelete(sKey)
    OffsetForumThreadCount vThreadInfo(TI_ForumID), -1

    ' Update forum information
    OffsetForumPostCount vThreadInfo(TI_ForumID), vThreadInfo(TI_TotalPosts) * -1
    UpdateLastActiveThread vThreadInfo(TI_ForumID)

    ' Delete poll information
    if vThreadInfo(TI_HasPoll) = 1 then DeletePoll vThreadInfo(TI_PollID)
    DeleteThread = True
    set rsCounts = Nothing
    set rsAttachments = Nothing
  end function

  Public Function DeletePoll(byval iPollID)
  ' DESCRIPTION : Deletes a poll

    dim SQL, vPollInfo
    vPollInfo = Polls.GetPollInfo(iPollID)

    SQL = "delete from polls where pollid=" & BBS.ValidateNumeric(vPollInfo(PI_pollid))
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "delete from polloptions where pollid=" & BBS.ValidateNumeric(vPollInfo(PI_pollid))
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "delete from pollvoted where pollid=" & BBS.ValidateNumeric(vPollInfo(PI_pollid))
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    DeletePoll = True

  end Function

  Public Function CreateMessage(byref vMessageInfo)
    ' DESCRIPTION : Creates a message
    ' INPUTS      : A messageinfo structure
    ' RETURNS     : The newly created messageid

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into messages(threadid,inreplyto,subject,body,anonymous,hostname,dateposted,messageicon,emoticons,replyorder,replylevel,signature,filterhtml,lasteditedname,lastediteddate,edited,hasattachment,isregistered,memberid,guestname,forcelinebreaks,approved,hasrevisions) VALUES("
    SQL = SQL & BBS.ValidateNumeric(vMessageInfo(MI_threadid)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_inreplyto)) & ", '" & BBS.SQLTrim(vMessageInfo(MI_Subject),100) & "', '" & BBS.ValidateSQL(vMessageInfo(MI_Body)) & "', " & BBS.ValidateNumeric(vMessageInfo(MI_Anonymous)) & ", '" & BBS.SQLTrim(vMessageInfo(MI_HostName),75) & "', " & sDateDelimiter & BBS.GetSQLDateTime(vMessageInfo(MI_DatePosted)) & sDateDelimiter &", " & BBS.ValidateNumeric(vMessageInfo(MI_MessageIcon)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_Emoticons)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_ReplyOrder)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_ReplyLevel)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_Signature)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_FilterHTML)) & ", '" & BBS.SQLTrim(vMessageInfo(MI_lasteditedname),20) & "', " & sDateDelimiter & BBS.GetSQLDateTime(vMessageInfo(MI_lastediteddate)) & sDateDelimiter &", " & BBS.ValidateNumeric(vMessageInfo(MI_Edited)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_HasAttachment)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_IsRegistered)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_MemberID)) & ", '" & BBS.SQLTrim(vMessageInfo(MI_GuestName),20) & "', " & BBS.ValidateBoolean(vMessageInfo(MI_ForceLineBreaks)) &  ", " & BBS.ValidateNumeric(vMessageInfo(MI_Approved)) & ", " & BBS.ValidateNumeric(vMessageInfo(MI_HasRevisions)) & ")"
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)

    SQL = "select @@IDENTITY"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)

    if rsNewID.EOF then
      CreateMessage= 0
    else
      CreateMessage= clng(rsNewID.fields(0).value)
    end if
    rsNewID.Close
    set rsNewID = Nothing
  end function

  Public Function UpdateMessage(byref vMessageInfo)
    ' DESCRIPTION : Updates a message
    ' INPUTS      : A messageinfo structure
    ' RETURNS     : True if successful

    dim SQL, sKey
    sKey = "MI-" & vMessageInfo(MI_MessageID)
    SQL = "update messages set threadid=" & BBS.ValidateNumeric(vMessageInfo(MI_ThreadID)) & ",inreplyto=" & BBS.ValidateNumeric(vMessageInfo(MI_inreplyto)) & ",subject='" & BBS.SQLTrim(vMessageInfo(MI_Subject),100) & "',body='" & BBS.ValidateSQL(vMessageInfo(MI_Body)) & "',anonymous=" & BBS.ValidateNumeric(vMessageInfo(MI_Anonymous)) & ",hostname='" & BBS.SQLTrim(vMessageInfo(MI_HostName),75) & "',dateposted=" & sDateDelimiter & BBS.GetSQLDateTime(vMessageInfo(MI_DatePosted)) & sDateDelimiter & ",messageicon=" & BBS.ValidateNumeric(vMessageInfo(MI_MessageIcon)) & ",emoticons=" & BBS.ValidateNumeric(vMessageInfo(MI_Emoticons)) & ",replyorder=" & BBS.ValidateNumeric(vMessageInfo(MI_ReplyOrder)) & ",replylevel=" & BBS.ValidateNumeric(vMessageInfo(MI_ReplyLevel)) & ",signature=" & BBS.ValidateNumeric(vMessageInfo(MI_Signature)) & ",filterhtml=" & BBS.ValidateNumeric(vMessageInfo(MI_FilterHTML)) & ",lasteditedname='" & BBS.SQLTrim(vMessageInfo(MI_lasteditedname),20) & "',lastediteddate=" & sDateDelimiter & BBS.GetSQLDateTime(vMessageInfo(MI_lastediteddate)) & sDateDelimiter & ",edited=" & BBS.ValidateNumeric(vMessageInfo(MI_Edited)) & ",hasattachment=" & BBS.ValidateNumeric(vMessageInfo(MI_HasAttachment)) & ",isregistered=" & BBS.ValidateNumeric(vMessageInfo(MI_IsRegistered)) & ",memberid=" & BBS.ValidateNumeric(vMessageInfo(MI_MemberID)) & ",guestname='" & BBS.SQLTrim(vMessageInfo(MI_GuestName),20) & "', forcelinebreaks=" & BBS.ValidateBoolean(vMessageInfo(MI_ForceLineBreaks)) & ", hasrevisions=" & BBS.ValidateNumeric(vMessageInfo(MI_HasRevisions)) & " where messageid=" & BBS.ValidateNumeric(vMessageInfo(MI_MessageID))
    dbConnection.execute SQL,, adTextNoRecords
    BBS.CacheDelete(sKey)
    BBS.AddQuery(SQL)
    UpdateMessage = True
  end function

  Public Function DeleteMessage(byref iMessageID)
    ' DESCRIPTION : Deletes a message
    ' INPUTS      : The messageid
    ' RETURNS     : True if successful

    dim SQL, vMessageInfo, vThreadInfo, vForumInfo, vUserInfo, sKey, rsInfo
    sKey = "MI-" & iMessageID

    vMessageInfo = GetMessageInfo(iMessageID)
    vThreadInfo  = GetThreadInfo(vMessageInfo(MI_ThreadID))
    vForumInfo   = GetForumInfo(vThreadInfo(TI_ForumID))
    set rsInfo   = Server.CreateObject("ADODB.Recordset")

    ' Only delete the message if it's valid and not the parent message of a thread.
    if vMessageInfo(MI_MessageID) > 0 and vMessageInfo(MI_InReplyTo) > 0 then
      SQL = "select attachmentid from attachments where messageid=" & BBS.ValidateNumeric(iMessageID)
      rsInfo.open SQL, dbConnection, adOpenStatic, adLockReadOnly
      do until rsInfo.EOF
        DeleteAttachment rsInfo.fields("attachmentid").value, BBS.ValidateNumeric(iMessageID)
        rsInfo.MoveNext
      loop
      rsInfo.Close
      set rsInfo = Nothing

      ' Update attachments
      UpdateAttachments iMessageID

      SQL = "delete from messages where messageid=" & BBS.ValidateNumeric(iMessageID)
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)

      ' First, redirect all existing replies to the parent
      SQL = "update messages set inreplyto=" & vMessageInfo(MI_inreplyto) & " where inreplyto=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL

      ' Then any alerts attached to this message
      SQL = "delete from alerts where messageid=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL

      ' Now delete the message.
      SQL = "delete from messages where messageid=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL

      OffsetThreadPostCount vThreadInfo(TI_ThreadID), -1
      OffsetForumPostCount vForumInfo(FI_ForumID), -1
      if vMessageInfo(MI_IsRegistered) = 1 then
        ' Posted by a registered user, update their post counts
        OffsetUserPostcount vMessageInfo(MI_MemberID), -1
      end if
      UpdateLastThreadPoster vMessageInfo(MI_threadid)
      UpdateLastActiveThread vForumInfo(FI_ForumID)

      ' Delete all message revisions
      SQL = "delete from revisions where messageid=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery (SQL)
      dbConnection.execute SQL

      ' Delete all message caches, this is the simplest way to ensure messages with an inreplyto of this message are updated cleanly
      BBS.CacheDeleteType("MI-")
    end if
  end function

  Public Function MoveMessageToNewThread(byref iMessageID)
    ' DESCRIPTION : Moves a message to a new thread
    ' INPUTS      : The messageid
    ' RETURNS     : The new ThreadID if successful

    dim SQL, vMessageInfo, vThreadInfo, vForumInfo, vUserInfo, sKey, vNewThreadInfo, iNewThreadID
    sKey = "MI-" & iMessageID

    vMessageInfo = GetMessageInfo(iMessageID)
    vThreadInfo  = GetThreadInfo(vMessageInfo(MI_ThreadID))
    vForumInfo   = GetForumInfo(vThreadInfo(TI_ForumID))

    vNewThreadInfo = GetThreadInfoStruct()

    ' Only delete the message if it's valid and not the parent message of a thread.
    if vMessageInfo(MI_MessageID) > 0 and vMessageInfo(MI_InReplyTo) > 0 then

      ' First, redirect all existing replies to the parent
      SQL = "update messages set inreplyto=" & vMessageInfo(MI_inreplyto) & " where inreplyto=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL

      ' Now move the message.

      ' Create the anchor thread
      vThreadInfo(TI_ForumID)      = vForumInfo(FI_ForumID)
      vThreadInfo(TI_TotalPosts)   = 1
      vThreadInfo(TI_DateCreated)  = vMessageInfo(MI_DatePosted)
      vThreadInfo(TI_LastActivity) = vMessageInfo(MI_DatePosted)
      vThreadInfo(TI_Subject)      = BBS.FilterPost(vMessageInfo(MI_Subject))
      if len(vThreadInfo(TI_Subject)) = 0 then vThreadInfo(TI_Subject) = "---"
      vThreadInfo(TI_Anonymous)    = vMessageInfo(MI_Anonymous)
      vThreadInfo(TI_TimesViewed)  = 0
      vThreadInfo(TI_Sticky)       = 0
      vThreadInfo(TI_Closed)       = 0
      vThreadInfo(TI_HasPoll)      = 0
      vThreadInfo(TI_HasAttachment)= vMessageInfo(MI_HasAttachment)
      vThreadInfo(TI_LastPosterAnonymous)    = vThreadInfo(TI_Anonymous)
      vThreadInfo(TI_LastPosterMemberID)     = vMessageInfo(MI_MemberID)
      vThreadInfo(TI_LastPosterIsRegistered) = BBS.ValidateBoolean(vMessageInfo(MI_MemberID) > -1)
      vThreadInfo(TI_LastPosterGuestName)    = vMessageInfo(MI_GuestName)
      vThreadInfo(TI_MemberID)     = vMessageInfo(MI_MemberID)
      vThreadInfo(TI_IsRegistered) = vMessageInfo(MI_IsRegistered)
      vThreadInfo(TI_GuestName)    = vMessageInfo(MI_GuestName)
      if len(trim(vThreadInfo(TI_GuestName))) = 0 then vThreadInfo(TI_GuestName) = dictLanguage("GLOBAL-GUEST")
      vThreadInfo(TI_Approved) = vMessageInfo(MI_Approved)
      iNewThreadID = CreateThread(vThreadInfo)

      vMessageInfo(MI_ThreadID)  = iNewThreadID
      vMessageInfo(MI_InReplyTo) = -1
      vMessageInfo(MI_ReplyOrder)  = 0
      vMessageInfo(MI_ReplyLevel)  = 0
      UpdateMessage(vMessageInfo)

      OffsetThreadPostCount vThreadInfo(TI_ThreadID), -1
      OffsetForumThreadCount vThreadInfo(TI_ForumID), 1
      ReIndexThread(vThreadInfo(TI_ThreadID))

      UpdateLastThreadPoster vMessageInfo(MI_threadid)
      UpdateLastActiveThread vForumInfo(FI_ForumID)

      ' Delete all message caches, this is the simplest way to ensure messages with an inreplyto of this message are updated cleanly
      BBS.CacheDeleteType("MI-")

      MoveMessageToNewThread = iNewThreadID
    else
      MoveMessageToNewThread = -1
    end if
  end function


  Public Function MoveMessageToExistingThread(byval iMessageID, byval iNewThreadID, byval bRefreshTime)
    ' DESCRIPTION : Moves a message to a new thread
    ' INPUTS      : The messageid
    ' RETURNS     : The new ThreadID if successful

    dim SQL, vMessageInfo, vThreadInfo, vForumInfo, vUserInfo, sKey, vNewThreadInfo
    sKey = "MI-" & iMessageID

    vMessageInfo = GetMessageInfo(iMessageID)
    vThreadInfo  = GetThreadInfo(vMessageInfo(MI_ThreadID))
    vForumInfo   = GetForumInfo(vThreadInfo(TI_ForumID))

    vNewThreadInfo = GetThreadInfo(inewThreadID)

    ' Only move the message if it's valid and not the parent message of a thread.
    if vMessageInfo(MI_MessageID) > 0 and vMessageInfo(MI_InReplyTo) > 0 and (vThreadInfo(TI_ForumID) = vNewThreadInfo(TI_ForumID)) then

      ' First, redirect all existing replies to the parent
      SQL = "update messages set inreplyto=" & vMessageInfo(MI_inreplyto) & " where inreplyto=" & BBS.ValidateNumeric(iMessageID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL

      ' Now move the message.
      vMessageInfo(MI_ThreadID)  = iNewThreadID
      vMessageInfo(MI_InReplyTo) = vNewThreadInfo(TI_Seed)
      vMessageInfo(MI_ReplyOrder)  = 0
      vMessageInfo(MI_ReplyLevel)  = 0
      if bRefreshTime = 1 then
        vMessageInfo(MI_DatePosted) = now
      end if
      UpdateMessage(vMessageInfo)

      OffsetThreadPostCount vThreadInfo(TI_ThreadID), -1
      OffsetThreadPostCount vNewThreadInfo(TI_ThreadID), 1
      ReIndexThread(vThreadInfo(TI_ThreadID))
      ReIndexThread(vNewThreadInfo(TI_ThreadID))

      UpdateLastThreadPoster vThreadInfo(TI_ThreadID)
      UpdateLastThreadPoster vNewThreadInfo(TI_ThreadID)
      UpdateLastActiveThread vForumInfo(FI_ForumID)

      ' Delete all message caches, this is the simplest way to ensure messages with an inreplyto of this message are updated cleanly
      BBS.CacheDeleteType("MI-")

      MoveMessageToExistingThread = iNewThreadID
    else
      MoveMessageToExistingThread = -1
    end if
  end function

  Public Function MoveThreadToExistingThread(byval iThreadID, byval iNewThreadID, byval bRefreshTime)
    ' DESCRIPTION : Moves a message to a new thread
    ' INPUTS      : The messageid
    ' RETURNS     : The new ThreadID if successful

    dim SQL, vMessageInfo, vThreadInfo, vForumInfo, vUserInfo, sKey, vNewThreadInfo
    sKey = "MI-" & iMessageID

    vThreadInfo  = GetThreadInfo(iThreadID)
    vForumInfo   = GetForumInfo(vThreadInfo(TI_ForumID))
    vNewThreadInfo = GetThreadInfo(inewThreadID)

    ' Only move the message if it's valid and i
    if (vThreadInfo(TI_ForumID) = vNewThreadInfo(TI_ForumID)) then

      ' If we are correcting post time, then update the postdates of all the messages
      if bRefreshTime then
        SQL = "update messages set dateposted=" & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter & " where threadid=" & vThreadInfo(TI_ThreadID)
        BBS.AddQuery(SQL)
        dbConnection.execute SQL,, adTextNoRecords
      end if

      ' Redirect all existing replies to the parent
      SQL = "update messages set threadid=" & vNewThreadInfo(TI_ThreadID) & " where threadid=" & vThreadInfo(TI_ThreadID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL,, adTextNoRecords

      ' Update the root message to point to the seed of the new thread
      SQL = "update messages set inreplyto=" & vNewThreadInfo(TI_Seed) & " where messageid=" & vThreadInfo(TI_Seed)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL,, adTextNoRecords

      ' Delete the old thread stub
      SQL = "delete from threads where threadid=" & vThreadInfo(TI_ThreadID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL,, adTextNoRecords

      ' Recalc the totalposts for this thread
      SQL = "update threads set totalposts=" & Forum.GetThreadPostCount(vNewThreadInfo(TI_ThreadID)) & " where threadid=" & vNewThreadInfo(TI_ThreadID)
      BBS.AddQuery(SQL)
      dbConnection.execute SQL,, adTextNoRecords

      ' Misc maintenance
      OffsetForumThreadCount vNewThreadInfo(TI_ForumID), -1
      ReIndexThread(vNewThreadInfo(TI_ThreadID))
      UpdateLastThreadPoster vNewThreadInfo(TI_ThreadID)
      UpdateLastActiveThread vForumInfo(FI_ForumID)

      ' Delete all message caches, this is the simplest way to ensure messages with an inreplyto of this message are updated cleanly
      BBS.CacheDeleteType("MI-")
      BBS.CacheDelete("TI-" & vThreadInfo(TI_ThreadID))

      MoveThreadToExistingThread = iNewThreadID
    else
      MoveThreadToExistingThread = -1
    end if
  end function

  Public function ApproveMessage(byref iMessageID)
    ' DESCRIPTION : Approves a message for display to all users

    dbconnection.execute "update messages set approved=1 where messageid=" & BBS.ValidateNumeric(iMessageID)

  end function

  Public function ApproveThread(byref iThreadID)
    ' DESCRIPTION : Approves a thread for display to all users

    dbconnection.execute "update threads set approved=1 where threadid=" & BBS.ValidateNumeric(iThreadID)

  end function

  Public function ApproveMember(byref iMemberID)
    ' DESCRIPTION : sets a member OK to post, removing all his posts from the moderation queue

    dbconnection.execute "update members set oktopost=1 where memberid=" & BBS.ValidateNumeric(iMemberID)

    ' Also approve all messages and threads that still might be pending for this user
    SQL = "update messages set approved=1 where memberid=" & BBS.ValidateNumeric(iMemberID)
    BBS.AddQuery(SQL)
    dbconnection.execute SQL,, adTextNoRecords


    SQL = "update threads set approved=1 where memberid=" & BBS.ValidateNumeric(iMemberID)
    BBS.AddQuery(SQL)
    dbconnection.execute SQL,, adTextNoRecords

    SQL = "delete from alerts where memberid=" & BBS.ValidateNumeric(iMemberID) & " and type=" & ALERT_NewPost
    BBS.AddQuery(SQL)
    dbConnection.execute SQL,, adTextNoRecords

  end function

  Public function UnapproveMember(byref iMemberID)
    ' DESCRIPTION : sets a member not OK to post, forcing their future posts to go through the moderation queue

    dbconnection.execute "update members set oktopost=0 where memberid=" & BBS.ValidateNumeric(iMemberID)

  end function

  Public function DeleteAttachment(byref iAttachmentID, byref iMessageID)
    ' DESCRIPTION : Deletes an attachment
    dim SQL, rsInfo, FSO, sFullFile

    set rsInfo = Server.CreateObject("ADODB.Recordset")
    set FSO    = Server.CreateObject("Scripting.FileSystemObject")

    SQL = "select attachmentid, infilesystem, fileguid from attachments where attachmentid=" & BBS.ValidateNumeric(iAttachmentID)
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not(rsInfo.EOF) then

      if rsInfo.fields("infilesystem") = 1 then
        ' Delete this file from the filesystem too - Filter parent paths just to be safe
        sFullFile = Server.MapPath(sBBSForumRoot & "/forums/attachments") & "/" & iMessageID & "-" & replace(rsInfo.fields("fileguid").value, ".", "")

        if FSO.FileExists(sFullFile) then
          on error resume next
          Err.Clear
          FSO.DeleteFile(sFullFile)

          if Err.Number <> 0 then
            response.write "Could not delete file from filesystem. Check permissions."
          end if

          Err.Clear
          on error goto 0
        end if
      end if

    end if

    ' Delete the record from the database
    dbConnection.execute "delete from attachments where attachmentid=" & BBS.ValidateNumeric(iAttachmentID)
    UpdateAttachments iMessageID
  end function

  Public function GenerateEmoticonBox()
    dim SQL, sOutput, rsInfo, index, vbEmoticons
    set vbEmoticons = new StringBuilder
    set rsInfo = server.createobject("ADODB.Recordset")

    SQL = "select source, emoticonimage from emoticons order by emoticonid asc"
    rsInfo.open SQL, dbConnection, adOpenStatic, adLockReadOnly

    'this code is moved to templates\original\bbs\forum\thread-post.asp
'    sOutput = "<script type='text/javascript'>function inserttext(target, text) {"
'    sOutput = sOutput & "target.value = (target.value+ "" "" + text + "" "")"
'    sOutput = sOutput & "target.focus();}</script>"
'    sOutput = sOutput & "alert(target.value);"
'    sOutput = sOutput & "}</script>"

'     sOutput = sOutput & "target._htmlArea.insertHTML(text);}</script>"
'     sOutput = sOutput & "target.value = target.value.substring(0,target.selectionStart) + text + target.value.substring(target.selectionStart,target.value.length)}</script>"

    vbEmoticons.Append "<div style='height: 200px; width: 200px; overflow:auto'><table cellpadding='4'>"
    do until rsInfo.EOF
      vbEmoticons.Append"<tr>"

      for index=1 to 4
        if not(rsInfo.EOF) then
          vbEmoticons.Append"<td align='center'><img alt='' onclick=""inserttext(document.getElementById('messagebody'), '" & BBS.ValidateJavascript(BBS.UnvalidateRegex(rsInfo.fields("source").value)) & "')"" src='" & sBBSForumRoot & "/images/emoticons/" & BBS.ValidateField(BBS.UnvalidateRegex(rsInfo.fields("emoticonimage").value)) & "'></td>"
          rsInfo.MoveNext
        else
          vbEmoticons.Append"<td></td>"
        end if
      next
      vbEmoticons.Append"</tr>"
    loop
    rsInfo.Close
    set rsInfo = Nothing
    vbEmoticons.Append "</table></div>"
    GenerateEmoticonBox = vbEmoticons.ToString()
    set vbEmoticons = Nothing
  end function

  public function LogPostRevision(byval iMessageID, byref sOldBody, byref sOldName, byref dOldDate)
    dim SQL

    if (bFeaturesUnlocked = 1) then
      SQL = "insert into revisions(messageid, dateedited, editedbyname, editedbyid, revisionbody) VALUES("
      SQL = SQL & BBS.ValidateNumeric(iMessageID) & ", " & sDateDelimiter & BBS.GetSqlDateTime(dOldDate) & sDateDelimiter & ", "
      SQL = SQL & "'" & BBS.ValidateSQL(sOldName) & "', " & BBS.GetUserInfoByName(sOldName)(UI_MemberID) & ", "
      SQL = SQL & "'" & BBS.ValidateSQL(sOldBody) & "')"
      BBS.AddQuery(SQL)
      dbConnection.execute SQL
    end if

  end function

  Public Sub GetMaxReplyOrder(byval iThreadID, byval iReplyMessage, byref iMaxOrder)
    ' DESCRIPTION : Drills down a thread tree to find the maximum replyorder for that branch
    dim SQL, rsInfo, iMessageID
    set rsInfo = Server.CreateObject("ADODB.Recordset")

    if ucase(sBBSDatabaseType) = "MYSQL" Then
      SQL = "select messageid, replyorder from messages where threadid=" & BBS.ValidateNumeric(iThreadID) & " and inreplyto=" & BBS.ValidateNumeric(iReplyMessage) & " order by replyorder desc limit 1"
    else
      SQL = "select top 1 messageid, replyorder from messages where threadid=" & BBS.ValidateNumeric(iThreadID) & " and inreplyto=" & BBS.ValidateNumeric(iReplyMessage) & " order by replyorder desc"
    end if

    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if rsInfo.EOF then
      rsInfo.Close
      set rsInfo = Nothing
      exit sub
    else
      iMaxOrder = clng(rsInfo.fields(1).value)
      iMessageID = rsInfo.fields(0).value
      rsInfo.Close
      set rsInfo = Nothing
      GetMaxReplyOrder iThreadID, iMessageID, iMaxOrder
    end if

  end sub

END CLASS
%>