<%

' MegaBBS messenger API
' Copyright PD9 Software
' Please refer to the license agreement for more information on reuse

' Depends on : include.asp, constants.asp

dim Messenger
set Messenger = new MegaBBSMessengerAPI

CLASS MegaBBSMessengerAPI

  sub Initialize()
    ' DESCRIPTION : Checks if the mailer component has been initialized correctly.

    on error resume next
    if dictConfiguration("sBBSEMAILCOMPONENT") = "JMAIL" then
      set objMail = Server.CreateObject("JMail.SMTPMail")
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "ASPEMAIL" then
      Set objMail      = Server.CreateObject("Persits.MailSender")
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "JMAIL4" then
      set objMail = Server.CreateOBject( "JMail.Message" )
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "CDONTS" then
      set objMail     = Server.CreateObject("CDONTS.NewMail")
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "CDOSYS" then
      set iConf = Server.CreateObject("CDO.Configuration")
      Set objNewMail = Server.CreateObject("CDO.Message")
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "ASPMAIL" then
      Set objMail = Server.CreateObject("SMTPsvg.Mailer")
    elseif dictConfiguration("sBBSEMAILCOMPONENT") = "ASPSMARTMAIL" then
      Set objmail = Server.CreateObject("aspSmartMail.SmartMail")
    end if
    if err.Number > 0 then dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & dictLanguage("GLOBAL-ERRMAIL") & "<br/>"

  end sub
  function GetPrivateMessageStruct()
    ' DESCRIPTION : Generates an empty private message structure
    ' RETURNS     : Private message structure

    dim struct(9)
    GetPrivateMessageStruct = struct
  end function

  sub SetPrivateMessageStatus (byref iPrvMessageID, byref iStatus, byval iMoveToSentItems)
    ' DESCRIPTION : Marks a message as read, and optionally moves it to sent items
    ' INPUTS      : iPrvMessageID - The private message ID
    '             : iStatus - Set the status as read (1) or not read (0)
    '             : iMoveToSentItems - Move to sent items (1) or do not move (0)

    dim SQL, iPreviousStatus, rsPrvMessage
    set rsPrvMessage = server.createobject("ADODB.Recordset")

    SQL = "select prvmessageid, messageread from private where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
    rsPrvMessage.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not(rsPrvMessage.EOF) then
      iPreviousStatus = BBS.ValidateBoolean(rsPrvMessage("messageread"))
      rsPrvMessage.Close
      SQL = "update private set messageread=" & BBS.ValidateNumeric(iStatus) & " where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
      if BBS.validateBoolean(iMoveToSentItems) = 1 and iPreviousStatus = 0 then
         MoveToSentItems (iPrvMessageID)
      end if
    else
      rsPrvMessage.Close
    end if


  end sub

  function SendPrivateNotify(byref stMessageInfo)
    ' DESCRIPTION : Sends a notification of a new private message
    ' INPUTS      : stMessageInfo - a private message structure
    ' RETURNS     : True if successful, false otherwise

    dim rsUserNotify, SQL, bNotificationPreference, sEmailAddress, sBody, sMailSubject
    set rsUserNotify = server.createobject("ADODB.Recordset")

    SQL = "select sendprivatenotifications, emailaddress from members where memberid=" & BBS.GetUserInfoByName(vMessageInfo(PM_Toname))(UI_MemberID)
    rsUserNotify.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    ' If this user exists, send the message
    if rsUserNotify.EOF then
       rsUserNotify.Close
       set rsUserNotify  = Nothing
       SendPrivateNotify = False
       exit function
    else
      ' Only send the mail if the user has elected to recieve these messages.
      bNotificationPreference = rsUserNotify.fields(0).value
      sEmailAddress = rsUserNotify.fields(1).value
      rsUserNotify.Close
      set rsUserNotify = Nothing
      if bNotificationPreference = 1 and BBS.IsValidEmail(sEmailAddress) then
        sMailSubject = dictConfiguration("sBBSNAME") & " - " & dictLanguage("GLOBAL-MESSAGEALERT") & CRLF & CRLF

        sBody =          vMessageInfo(PM_Fromname) & " has just sent you a private message." & CRLF & """" & vMessageInfo(PM_Subject) & """" & CRLF & CRLF
        sBody = sBody    & "To view this message, follow the link below: "  & CRLF
        sBody = sBody    & sBBSUnvalidatedBaseURL & "/inbox.asp" & CRLF & CRLF
        sBody = sBody    & "To stop recieving these e-mails, edit your profile." & CRLF
        sBody = sBody    & sBBSUnvalidatedBaseURL & "/profile/controlpanel.asp"
        SendMail dictConfiguration("sMAILSERVERADDRESS"), sEmailAddress, dictConfiguration("sADMINEMAIL"), sMailSubject, sBody, dictConfiguration("sEMAILCOMPONENT")
      end if
    end if
  end function


  function SendPrivateMessage(byref stPrivateMessage)
    ' DESCRIPTION : Sends a new private message
    ' INPUTS      : stPrivateMessage - A private message structure
    ' RETURNS     : True if successful, false otherwise

    dim iSenderStatus
    iSenderStatus = 0

    if BBS.UserExists(stPrivateMessage(PM_ToName)) then
      if BBS.UserExists(stPrivateMessage(PM_FromName)) then iSenderStatus = 1
      SQL = "insert into private (toname, fromname, subject, datesent, messageread, body) VALUES('"
      SQL = SQL & BBS.SQLTrim(stPrivateMessage(PM_ToName), 20) &"', '" & BBS.SQLTrim(stPrivateMessage(PM_FromName),20) & "', "
      SQL = SQL & "'" & BBS.SQLTrim(BBS.FilterPost(stPrivateMessage(PM_Subject)), 100) & "', " & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter & ", 0, '" & BBS.ValidateSQL(BBS.FilterPost(stPrivateMessage(PM_Body))) & "')"
      SendPrivateMessage = True
      dbConnection.execute SQL,, adTextNoRecords
    else
      SendPrivateMessage = False
    end if
  end function


  function GetPrivateMessage (byRef iPrvMessageID)
    ' DESCRIPTION : Retrieves a private message
    ' INPUTS      : iPrvMessageID - Private message id
    ' RETURNS     : A private message structure

    dim rsMessage, SQL, prvMessage
    set rsMessage = server.createobject("ADODB.Recordset")
    prvMessage    = GetPrivateMessageStruct()

    SQL = "select prvmessageid, toname, fromname, subject, datesent, body from private where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
    rsMessage.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not rsMessage.EOF then
      prvMessage(PM_MessageID)  = rsMessage.fields(0).value
      prvMessage(PM_toname)     = rsMessage.fields(1).value
      prvMessage(PM_fromname)   = rsMessage.fields(2).value
      prvMessage(PM_subject)    = rsMessage.fields(3).value
      prvMessage(PM_datesent)   = rsMessage.fields(4).value
      prvMessage(PM_body)       = rsMessage.fields(5).value
    else
      prvMessage(PM_MessageID)  = -1
    end if

    rsMessage.close
    set rsMessage = nothing
    GetPrivateMessage = prvMessage
  end function

  function GetSentPrivateMessage (iPrvMessageID)
    ' DESCRIPTION : Retrieves a private message
    ' INPUTS      : iSentPrvMessageID - Private message id
    ' RETURNS     : A sent private message structure

    dim rsMessage, SQL, prvMessage
    set rsMessage = server.createobject("ADODB.Recordset")
    prvMessage = GetPrivateMessageStruct()

    SQL = "select prvmessageid, toname, fromname, subject, datesent, body, dateread from sentprivate where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
    rsMessage.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not rsMessage.EOF then
      prvMessage(PM_MessageID)  = rsMessage.fields(0).value
      prvMessage(PM_toname)     = rsMessage.fields(1).value
      prvMessage(PM_fromname)   = rsMessage.fields(2).value
      prvMessage(PM_subject)    = rsMessage.fields(3).value
      prvMessage(PM_datesent)   = rsMessage.fields(4).value
      prvMessage(PM_body)       = rsMessage.fields(5).value
      prvMessage(PM_dateread)   = rsMessage.fields(6).value
    else
      prvMessage(PM_MessageID)  = -1
    end if
    rsMessage.close
    set rsMessage = nothing
    GetSentPrivateMessage = prvMessage
  end function



  function MoveToSentItems (byref iPrvMessageID)
    ' DESCRIPTION : Copies an message from the private message table to the sent private message table
    '             : and sets the status of the original message to 'read'
    ' INPUTS      : The private message ID
    ' RETURNS     : True if successful, false otherwise

    dim stPrivateMessage, SQL
    stPrivateMessage = GetPrivateMessage (iPrvMessageID)
    if stPrivateMessage(PM_MessageID) > 0 and stPrivateMessage(PM_MessageRead) = 0 then
      SQL = "update private set messageread=1 where prvmessageid=" & stPrivateMessage(PM_MessageID)
      dbConnection.Execute SQL,, adTextNoRecords
      SQL = "insert into sentprivate (toname, fromname, subject, "
      SQL = SQL & "datesent, dateread, body) VALUES('" & BBS.ValidateSQL(trim(stPrivateMessage(PM_ToName))) & "', "
      SQL = SQL & "'" & BBS.ValidateSQL(trim(stPrivateMessage(PM_FromName))) & "', "
      SQL = SQL & "'" & BBS.ValidateSQL(stPrivateMessage(PM_Subject)) & "', "
      SQL = SQL & sDateDelimiter & BBS.GetSQLDateTime(stPrivateMessage(PM_DateSent)) & sDateDelimiter & ", "
      SQL = SQL & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter & ", '"
      SQL = SQL & BBS.ValidateSQL(stPrivateMessage(PM_Body)) & "')"
      dbConnection.execute SQL,, adTextNoRecords
      MoveToSentItems = True
    else
      MoveToSentItems = False
    end if
  end function

  function deletePrivateMessage(byref iPrvMessageID)
    ' DESCRIPTION : Deletes a private message
    ' INPUTS      : The private message ID
    ' RETURNS     : True if successful, false otherwise

    dim SQL
    SQL = "delete from private where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
    dbConnection.execute SQL,, adTextNoRecords
    deletePrivateMessage = True
  end function

  function deleteSentPrivateMessage(byref iPrvMessageID)
    ' DESCRIPTION : Deletes a sent private message
    ' INPUTS      : The sent private message ID
    ' RETURNS     : True if successful, false otherwise

    dim SQL
    SQL = "delete from sentprivate where prvmessageid=" & BBS.ValidateNumeric(iPrvMessageID)
    dbConnection.execute SQL,, adTextNoRecords
  end function

  Function SendMail (byref sServerAddress, byref sToEmail, byref sFromEmail, byref sSubject, byref sMessage, byref sComponent)
    ' DESCRIPTION : Sends an e-mail
    ' INPUTS      : sServerAddress - The mail server address
    '             : sToEmail       - The destination e-mail address
    '             : sFromEmail     - The source e-mail address
    '             : sSubject       - Message subject
    '             : sComponent     - Which e-mail componenet should be used?
    ' RETURNS     : True if successful, false otherwise

    on error resume next
    if not(BBS.IsValidEmail(sToEmail)) or not(BBS.IsValidEmail(sFromEmail)) then
      exit function
    end if

    dim objMail
    if ucase(sComponent) = "JMAIL" then

      ' JMAIL component available @ http://www.dimac.net/
      set objMail = Server.CreateObject("JMail.SMTPMail")
      objMail.Charset         = "UTF-8"
      objMail.Sender          = sFromEmail
      objMail.AddRecipient      sToEmail
      objMail.Subject         = sSubject
      objMail.lazysend        = True
      objMail.serveraddress   = sServerAddress
      objMail.body = sMessage
      objMail.Execute
      set objMail = nothing

    elseif ucase(sComponent) = "ASPEMAIL" then

      ' ASPEmail component available @ http://www.aspemail.com/
      Set objMail      = Server.CreateObject("Persits.MailSender")
      objMail.Host     = sServerAddress
      objMail.From     = sFromEmail
      objMail.AddAddress sToEmail
      objMail.Subject  = sSubject
      objMail.Body     = sMessage
      objMail.Send
      set objMail = nothing

    elseif ucase(sComponent) = "JMAIL4" then

      ' JMAIL component available @ http://www.dimac.net/
      set objMail = Server.CreateOBject( "JMail.Message" )
      objMail.Charset    = "UTF-8"
      objMail.Logging    = False
      objMail.silent     = True
      objMail.From       = sFromEmail
      objMail.Subject    = sSubject
      objMail.Body       = sMessage
      objMail.AddRecipient sToEmail
'      objMail.MailServerUserName = "yourusername"
'      objMail.MailServerPassword = "yourpassword
      objMail.Send(sServerAddress)
      set objMail = nothing

    elseif ucase(sComponent) = "CDONTS" then

      ' CDONTS object
      set objMail     = Server.CreateObject("CDONTS.NewMail")
      objMail.MailFormat = 0
      objMail.SetLocaleIDs(65001)
      objMail.From    = sFromEmail
      objMail.To      = sToEmail
      objMail.Subject = sSubject
      objMail.Body    = sMessage
      objMail.Send
      set objMail = Nothing

    elseif ucase(sComponent) = "CDOSYS" then

      ' CDOSYS
      dim iConf, Flds, objNewMail
      set iConf = Server.CreateObject("CDO.Configuration")
      set Flds = iConf.Fields

      'Set and update fields properties
      Flds("http://schemas.microsoft.com/cdo/configuration/smtpserver") = sServerAddress
      Flds("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25

      ' Configure some default values
      if dictConfiguration("iCDOSENDUSING") <> 1 then dictConfiguration("iCDOSENDUSING") = 2
      if len(dictConfiguration("sCDOPICKUPFOLDER")) = 0 then dictConfiguration("sCDOPICKUPFOLDER") = "C:\inetpub\mailroot\pickup\"

      if dictConfiguration("iCDOSENDUSING") = 2 then
        Flds("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2 ' cdoSendUsingPickup=1; cdoSendUsingPort=2
      else
        Flds("http://schemas.microsoft.com/cdo/configuration/sendusing") = 1 ' cdoSendUsingPickup=1; cdoSendUsingPort=2
        Flds("http://schemas.microsoft.com/cdo/configuration/smtpserverpickupdirectory") = dictConfiguration("sCDOPICKUPFOLDER")
      end if

      'Flds("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = cdoBasic
      'Flds("http://schemas.microsoft.com/cdo/configuration/sendusername") = "username"
      'Flds("http://schemas.microsoft.com/cdo/configuration/sendpassword") = "password"

      Flds("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 60
      Flds.Update
      Set objNewMail = Server.CreateObject("CDO.Message")
      objNewMail.bodypart.Charset = "utf-8"
      Set objNewMail.Configuration = iConf

      'Format and send message
      Err.Clear
      objNewMail.To = sToEmail
      objNewMail.From = sFromEmail
      objNewMail.Subject = sSubject
      objNewMail.TextBody = sMessage
      objNewMail.Send
      set objNewMail = Nothing
      set Flds = Nothing
      set iConf = Nothing

    elseif ucase(sComponent) = "ASPMAIL" then

      ' ASPEmail available from http://www.serverobjects.com/
      Set objMail = Server.CreateObject("SMTPsvg.Mailer")
      objMail.FromName = sFromEmail
      objMail.FromAddress= sFromEmail
      objMail.RemoteHost= sServerAddress
      objMail.AddRecipient "User:", sToEmail
      objMail.Subject = sSubject
      objMail.BodyText = sMessage
      objMail.CustomCharSet = "UTF-8"
      objMail.SendMail
      set objMail = nothing

    elseif ucase(sComponent) = "ASPSMARTMAIL" then

      ' ASP Smartmail
      Set objmail = Server.CreateObject("aspSmartMail.SmartMail")
      objmail.Server = sServerAddress
      objmail.SenderAddress = sFromEmail
      objmail.Recipients.Add sToEmail
      objmail.Subject = sSubject
      objmail.Body = sMessage
      objmail.charset = "UTF-8"
      objMail.SendMail
    end if

    If Err.Number <> 0 Then
      dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & "There was an error in sending an email to: " & sToEmail & "<br/>"
      dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & "The error message was (" & Err.Description & ")<br/>"
      dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & "Check your email component settings in /admin/bbs-configuration.asp, or set to 'none' to disable<br/>"
      Err.Clear
      SendMail = False
    else
      SendMail = True
    end if

  End Function

  function SendBroadcast(byref sSubject, byref sMessage)
    ' DESCRIPTION : Sends a broadcast to all administrators

    dim vUserList, Index

    ' Get a list of all administrators and send them a notification
    vUserlist = BBS.ListMembersArray (MODULE_BBS, USERLEVEL_GlobalAdministrator, -1)
    if IsArray(vUserList) then
      for index=0 to ubound(vUserList, 2)
        Messenger.SendMail dictConfiguration("sMAILSERVERADDRESS"), vUserList(2, index), dictConfiguration("sADMINEMAIL"), sSubject, sMessage, dictConfiguration("sEMAILCOMPONENT")
      next
    end if
  end function

  function NumberOfMessages(byref stBoxName)
    ' DESCRIPTION : Counts the number of messages in a box
    ' INPUTS      : stBoxName - the box of which you want to know the number of messages
    ' RETURNS     : Number of messages in a box

    if dictConfiguration("iMAXINBOXCOUNT") <> 0 and iBBSUserLevel < USERLEVEL_SupportAdministrator Then
      dim SQL, rsBox
      set rsBox = server.createobject("ADODB.Recordset")
      if stBoxName = "outbox" then
        SQL = "select count(prvmessageid) as CountInbox from private where messageread=0 and fromname='" & BBS.ValidateSQL(sBBSUserName) & "'"
      elseif stBoxName = "sentbox" then
        SQL = "select count(prvmessageid) as CountInbox from sentprivate where fromname='" & BBS.ValidateSQL(sBBSUserName) & "'"
      else 'Count the messages in inbox when no input is valid
        SQL = "select count(prvmessageid) as CountInbox from private where toname='" & BBS.ValidateSQL(sBBSUserName) & "'"
      end if
      rsBox.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      NumberOfMessages = rsBox.fields("CountInbox").value
      rsBox.close
      set rsBox = nothing
    else
      NumberOfMessages = 0
    end if
  end function

END CLASS
%>
