<%
' MegaBBS pollbooth API
' Copyright PD9 Software
' Please refer to the license agreement for more information on reuse

' Depends on : include.asp, constants.asp, include-forums.asp

dim Polls
set Polls = new MegaBBSPollsAPI



CLASS MegaBBSPollsAPI

  function GetPollInfoStruct()
    ' DESCRIPTION : Generates an empty poll info structure
    ' RETURNS     : A poll info structure

    dim vStructure(9)
    GetPollInfoStruct = vStructure
  end function

  function GetOptionInfoStruct()
    ' DESCRIPTION : Generates an empty poll info structure
    ' RETURNS     : A poll info structure

    dim vStructure(9)
    GetOptionInfoStruct = vStructure
  end function

  function CreatePoll (byref vPollInfo)
    ' DESCRIPTION  : Creates a poll
    ' INPUTS       : vPollInfo - A pollinfo structure
    ' RETURNS      : iPollID   - The PollID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into polls (unregisteredcanvote, unregisteredcanaddoptions, registeredcanaddoptions, displaynames, closed, multivoting, hideresults) values("
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_unregisteredcanvote)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_unregisteredcanaddoptions)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_registeredcanaddoptions)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_displaynames)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_closed)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_multivoting)) & ", "
    SQL = SQL & BBS.ValidateNumeric(vPollInfo(PI_hideresults)) & ") "
    dbConnection.execute SQL
    BBS.AddQuery(SQL)

    SQL = "select @@IDENTITY"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adlockReadonly
    BBS.AddQuery(SQL)

    if rsNewID.EOF then
      CreatePoll= 0
    else
      CreatePoll= clng(rsNewID.fields(0).value)
    end if
    rsNewID.Close
    set rsNewID = Nothing

  end function


  function GetPollInfo (byref ipollid)
    ' DESCRIPTION  : Gets all information related to a poll
    ' INPUTS       : iPollID - Poll ID
    ' RETURNS      : stPollStruct - A PollInfo structure

    dim SQL, rsPollInfo, stPollStruct, vPollRows
    set rsPollInfo = server.createObject("ADODB.Recordset")

    SQL = "select pollid, unregisteredcanvote, unregisteredcanaddoptions, "
    SQL = SQL & "registeredcanaddoptions, displaynames, closed, multivoting, hideresults "
    SQL = SQL & "from polls where pollid=" & BBS.ValidateNumeric(iPollID)
    rsPollInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    stPollStruct = GetPollInfoStruct()
    if not(rsPollInfo.EOF) then
      vPollRows = rsPollInfo.GetRows
      stPollStruct(PI_pollid)                    = vPollRows(0, 0)
      stPollStruct(PI_UnregisteredCanVote)       = vPollRows(1, 0)
      stPollStruct(PI_UnregisteredCanAddOptions) = vPollRows(2, 0)
      stPollStruct(PI_RegisteredCanAddOptions)   = vPollRows(3, 0)
      stPollStruct(PI_DisplayNames)              = vPollRows(4, 0)
      stPollStruct(PI_Closed)                    = vPollRows(5, 0)
      stPollStruct(PI_MultiVoting)               = vPollRows(6, 0)
      stPollStruct(PI_HideResults)               = vPollRows(7, 0)
      rsPollInfo.Close
      rsPolLInfo.open "select threadid from threads where pollid=" & BBS.ValidateNumeric(stPollStruct(PI_pollid)), dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)
      if rsPollInfo.EOF then
        stPollStruct(PI_ThreadID) = -1
      else
        stPollStruct(PI_ThreadID) = rsPollInfo.fields(0).value
      end if
    else
      stPollStruct(PI_pollid) = -1
    end if

    rsPollInfo.Close
    set rsPollInfo = Nothing
    GetPollInfo = stPollStruct
  end function

  function CreateOption(byref stOptionStruct)
    ' DESCRIPTION  : Creates a new poll option
    ' INPUTS       : stOptionStruct - An OptionInfo structure
    ' RETURNS      : True if successful, false otherwise

    dim SQL
    dim rsAddOption
    set rsAddOption = server.CreateObject("ADODB.Recordset")

    ' Make sure an option with this description doesn't already exist
    SQL = "select optionid from polloptions where pollid=" & BBS.ValidateNumeric(stOptionStruct(OI_PollID)) & " and description='" & BBS.ValidateSQL(stOptionStruct(OI_Description)) & "'"
    rsAddOption.Open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if rsAddOption.EOF then
      rsAddOption.Close
      SQL = "INSERT INTO polloptions (pollid, description, memberid, registered, votes, guestname) VALUES("
      SQL = SQL & BBS.ValidateNumeric(stOptionStruct(OI_PollID)) & ", "
      SQL = SQL & "'" & BBS.ValidateSQL(stOptionStruct(OI_Description)) & "', "
      SQL = SQL & BBS.ValidateSQL(stOptionStruct(OI_MemberID)) & ", "
      SQL = SQL & BBS.ValidateNumeric(stOptionStruct(OI_Registered)) & ", "
      SQL = SQL & BBS.ValidateNumeric(stOptionStruct(OI_Votes)) & ", "
      SQL = SQL & "'" & BBS.SQLTrim(stOptionStruct(OI_GuestName), 20) & "')"
      dbConnection.execute SQL
      BBS.AddQuery(SQL)

      ' Get the option ID of the newly created record
      SQL = "select optionid from polloptions where pollid=" & stOptionStruct(OI_PollID) & " and description='"
      SQL = SQL & BBS.ValidateSQL(stOptionStruct(OI_Description)) & "'"
      rsAddOption.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQL)
      CreateOption = rsAddOption.fields("optionid").value
    else
      CreateOption = rsAddOption.fields("optionid").value
    end if

    rsAddOption.CLose
    set rsAddOption = Nothing
  end function

  function HasVoted (byref ipollid, byref iOptionID, byref bAllowMultivoting)
    ' DESCRIPTION  : Checks if a user has voted for a poll/option
    '              :   If the poll allows multivoting (voting for more than one option), then the function
    '              :   only returns true if the user has voted for that specific option.  Otherwise,
    '              :   the function checks if the user has voted for any option in this poll at all.
    ' INPUTS       : sPollUsername     - The member's username
    '              : iPollID           - PollID
    '              : iOptionID         - OptionID
    '              : bAllowMultivoting - Does the poll allow multivoting?
    ' RETURNS      : True if the user has cast a vote. False otherwise

    dim SQL, rsHasVoted
    set rsHasVoted = server.createObject("ADODB.Recordset")

    if iBBSMemberID > 0 then
      if bAllowMultivoting = 0 then
        SQL = "select voteid from pollvoted where pollid="& BBS.ValidateNumeric(ipollid) & " and memberid=" & BBS.ValidateNumeric(iBBSMemberID)
      else
        SQL = "select voteid from pollvoted where pollid="& BBS.ValidateNumeric(ipollid) & " and optionid=" & BBS.ValidateNumeric(iOptionID) & " and memberid=" & BBS.ValidateNumeric(iBBSMemberID)
      end if
    else
      if bAllowMultivoting = 0 then
        SQL = "select voteid from pollvoted where pollid="& BBS.ValidateNumeric(ipollid) & " and hostname='" & BBS.SQLTrim(Request.ServerVariables("REMOTE_ADDR"), 15) & "'"
      else
        SQL = "select voteid from pollvoted where pollid="& BBS.ValidateNumeric(ipollid) & " and optionid=" & BBS.ValidateNumeric(iOptionID) & " and hostname='" & BBS.SQLTrim(Request.ServerVariables("REMOTE_ADDR"), 15) & "'"
      end if
    end if

    rsHasVoted.Open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    HasVoted = not(rsHasVoted.EOF)
    rsHasVoted.Close
    set rsHasVoted = Nothing

  end function

  function CastVote (byref ipollid, byref iOptionID)
    ' DESCRIPTION  : Casts a vote
    ' INPUTS       : iPollID     - The poll ID
    '              : iOptionID   - The option ID
    ' RETURNS      : True if successful, false otherwise

    dim rsCastVote, SQL
    set rsCastVote = server.CreateObject("ADODB.Recordset")

    ' Make sure this option ID is associated with the poll ID
    SQL = "select optionid from polloptions where pollid=" & BBS.ValidateNumeric(ipollid) & " and optionid=" & BBS.ValidateNumeric(iOptionID)
    rsCastVote.Open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if rsCastVote.EOF then
       CastVote = False
       rsCastVote.Close
       set rsCastVote = Nothing
       exit function
    else
       rsCastVote.Close

       '  If the user has already voted on this poll+option, don't duplicate the entry
       if iBBSMemberID > 0 then
         SQL = "select voteid from pollvoted where pollid=" & BBS.ValidateNumeric(iPollID) & " and memberid=" & BBS.ValidateNumeric(iBBSMEmberID) & " and optionid=" & BBS.ValidateNumeric(iOptionID)
       else
         SQL = "select voteid from pollvoted where pollid="& BBS.ValidateNumeric(ipollid) & " and optionid=" & BBS.ValidateNumeric(iOptionID) & " and hostname='" & BBS.SQLTrim(Request.ServerVariables("REMOTE_ADDR"), 15) & "'"
       end if

       rsCastVote.Open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
       BBS.AddQuery(SQL)

       if rsCastVote.EOF then
         SQL = "INSERT INTO pollvoted (pollid, optionid, registered, memberid, hostname) VALUES("
         SQL = SQL & BBS.ValidateNumeric(iPollID) & ", "
         SQL = SQL & BBS.ValidateNumeric(iOptionID) & ", "
         SQL = SQL & BBS.ValidateBoolean(iBBSMemberID > 0) & ", "
         SQL = SQL & BBS.ValidateNumeric(iBBSMemberID) & ", "
         SQL = SQL & "'" & BBS.SQLTrim(request.servervariables("REMOTE_HOST"), 15) & "')"
         dbConnection.Execute SQL
         BBS.AddQuery(SQL)

         ' Update the number of votes for this option
         SQL = "update polloptions set polloptions.votes=polloptions.votes+1 where polloptions.optionid=" & BBS.ValidateNumeric(iOptionID)
         dbConnection.execute SQL
         BBS.AddQuery(SQL)
       end if

       rsCastVote.Close
       set rsCastVote = Nothing
       CastVote = True
    end if
  end function


  function GetOptionInfo(byref ipollid)
    ' DESCRIPTION  : Gets all optioninfo structures related to a poll
    ' INPUTS       : iPollID    - The PollID
    ' RETURNS      : An array of OptionInfo structures

    dim SQL, rsOptionInfo, result(), iOptionIndex, vOptionArray, iTotalVotes, iUpperBound, Index
    set rsOptionInfo = server.createObject("ADODB.Recordset")
    index = 0

    SQL = "select sum(votes) as sumvotes from polloptions where pollid=" & BBS.ValidateNumeric(iPollID)
    rsOptionInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if not rsOptionInfo.EOF then iTotalVotes = BBS.ValidateNumeric(rsOptionInfo.fields(0).value)
    rsOptionInfo.Close

    SQL = "select optionid, pollid, description, memberid, registered, votes, guestname from polloptions where pollid=" & BBS.ValidateNumeric(iPollID) & " order by optionid"
    rsOptionInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly

    if not(rsOptionInfo.EOF) then

      ' Store the recordset in an array for faster retrieval
      vOptionArray = rsOptionInfo.GetRows
      iUpperBound = ubound(vOptionArray, 2)
      redim result(iUpperBound)

      for iOptionIndex= 0 to UBOUND(vOptionArray, 2)
        result(iOptionIndex) = GetOptionInfoStruct()
        result(iOptionIndex)(OI_OptionID)    = vOptionArray(0, iOptionIndex)
        result(iOptionIndex)(OI_PollID)      = vOptionArray(1, iOptionIndex)
        result(iOptionIndex)(OI_Description) = vOptionArray(2, iOptionIndex)
        result(iOptionIndex)(OI_MemberID)    = vOptionArray(3, iOptionIndex)
        result(iOptionIndex)(OI_Registered)  = vOptionArray(4, iOptionIndex)
        result(iOptionIndex)(OI_Votes)       = vOptionArray(5, iOptionIndex)
        result(iOptionIndex)(OI_Guestname)   = vOptionArray(6, iOptionIndex)

        if iTotalvotes = 0 then
          result(iOptionIndex)(OI_Percentage) = 0
        else
          result(iOptionIndex)(OI_Percentage)  = round((result(iOptionIndex)(OI_Votes) / iTotalVotes) * 100, 2)
        end if

      next

    else

      redim result(1)
      result(0) = GetOptionInfoStruct()
      result(0)(OI_OptionID) = -1

    end if

    rsOptionInfo.Close
    set rsOptionInfo = Nothing
    GetOptionInfo = result

  end function

  function GeneratePoll(byref iPollID, byref sRedirect)
    ' DESCRIPTION : Generates an HTML table that includes options for a poll and the ability to vote
    ' INPUTS      : The poll ID
    '             : The redirection URL after the vote is cast
    ' RETURNS     : HTML

    dim vPollInfo, vOptionInfo, iHasVoted, SQL, rsVotedFor, sVotedFor, iColumns, index, sType, sHeader, bCanVote, vThreadInfo

    vPollInfo   = GetPollInfo(iPollID)

    if not(vPollInfo(PI_PollID)) > 0 then exit function

    vOptionInfo = GetOptionInfo(vPollInfo(PI_PollID))
    if not(IsArray(vOptionInfo)) then exit function
    if vOptionInfo(0)(OI_OptionID) = -1 then exit function

    ' Has the user voted on _any_ options
    iHasVoted =  HasVoted(vPollInfo(PI_PollID), 0, 0)

    ' Get list of options the user voted for
    if iHasVoted then
      SQL = "select optionid from pollvoted where pollid=" & vPollInfo(PI_PollID) & " and memberid=" & iBBSMemberID & " and registered=1"
      set rsVotedFor = server.createobject("ADODB.Recordset")
      rsVotedFor.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      if not rsVotedFor.eof then
        do while not rsVotedFor.eof
          sVotedFor = sVotedFor & rsVotedFor.fields(0).value & ","
          rsVotedFor.movenext
        loop
      end if
      rsVotedFor.close
      set rsVotedFor = nothing
    end if

    ' Can the user vote on polls?
    vThreadInfo = Forum.GetThreadInfo(vPollInfo(PI_ThreadID))
    bCanVote = BBS.HasPermission(PERM_forumvotepoll, vThreadInfo(TI_ForumID))



    if vPolLInfo(PI_DisplayNames) = 1 then
      iColumns = 3
      sHeader = "<tr><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL3") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL4") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL5") & "</td></tr>"
    else
      iColumns = 2
      sHeader = "<tr><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL3") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL5") & "</td></tr>"
    end if

    if vPollInfo(PI_Multivoting) = 0 then
      sType = "type='radio' class='bbsradiobox'"
    else
      sType = "type='checkbox' class='bbscheckbox'"
    end if


    GeneratePoll= "<form method='post' action='" & sBBSForumRoot & "/pollbooth/castvote.asp'>"
    if len(sRedirect) > 0 then GeneratePoll = GeneratePoll & "<input type='hidden' name='redirect' value='" & BBS.ValidateField(sRedirect) & "'>"
    GeneratePoll = GeneratePoll & "<input type='hidden' name='pollid' value='" & BBS.ValidateNumeric(vPollInfo(PI_PollID)) & "'>"
    GeneratePoll = GeneratePoll & "<input type='hidden' name='action' value='vote'>"
    GeneratePoll = GeneratePoll & "<table class='bbstable' width='95%' align='center' cellspacing='1'><tr><td colspan='" & iColumns & "' class='messagecellheader'>" & BBS.FilterView(BBS.ValidateField(vThreadInfo(TI_Subject))) & "</td></tr>" & sHeader

    ' If the user is unregistered, give them a place to enter their guest name
    if (iBBSMemberID < 0) and vPollInfo(PI_UnregisteredCanVote) = 1 and bCanVote then
      GeneratePoll = GeneratePoll & "<tr><td class='messagecellbody' colspan='" & iColumns & "'>" & dictLanguage("GLOBAL-POLL8") & " <input type='text' class='bbstextbox' size='50' maxlength='50' name='guestname'></td></tr>"
    end if

    for index = 0 to UBOUND(vOptionInfo)
      GeneratePoll = GeneratePoll & "<tr><td class='messagecellbody'>"
      if vThreadInfo(TI_Closed) = 1 or (iHasVoted = 0 or vPollInfo(PI_MultiVoting) = 1) and bCanVote then GeneratePoll = GeneratePoll & "<input " & sType & " value='" & vOptionInfo(index)(OI_OptionID) & "' name='optionid'>"
      if inStr(sVotedFor, vOptionInfo(index)(OI_OptionID) & ",") > 0 then
        GeneratePoll = GeneratePoll & "<b>" & BBS.ValidateField(BBS.FilterView(vOptionInfo(index)(OI_Description))) & "</b></td>"
      else
        GeneratePoll = GeneratePoll & BBS.ValidateField(BBS.FilterView(vOptionInfo(index)(OI_Description))) & "</td>"
      end if
      if vPollInfo(PI_DisplayNames) = 1 then
        if vOptionInfo(index)(OI_Registered) = 1 then
          GeneratePoll = GeneratePoll & "<td class='messagecellbody'>" & BBS.CreateUsernameLinkbyID(vOptionInfo(index)(OI_MemberID)) & BBS.ValidateField(BBS.GetUserInfobyID(vOptionInfo(index)(OI_MemberID))(UI_Username)) & "</a></td>"
        else
          GeneratePoll = GeneratePoll & "<td class='messagecellbody'>" & BBS.ValidateField(vOptionInfo(index)(OI_Guestname)) & "</td>"
        end if
      end if
      GeneratePoll = GeneratePoll & "<td nowrap width='35%' class='messagecellbody' align='left'>"

      if (vPollInfo(PI_HideResults) = 0) or (vPollInfo(PI_HideResults) = 1 and iHasVoted) then
        GeneratePoll = GeneratePoll & vOptionInfo(index)(OI_Votes) & " " & dictLanguage("GLOBAL-POLL6")
        GeneratePoll = GeneratePoll & " - [" & vOptionInfo(index)(OI_Percentage) & "%]<br/><img src='" & dictImages("POLL-LEFT") & "' alt=''><img src='" & dictImages("POLL-CENTER") & "' width='" & round(vOptionInfo(index)(OI_Percentage) * 3) & "' height='11' alt=''><img src='" & dictImages("POLL-RIGHT") & "' alt=''>"
      end if

      GeneratePoll = GeneratePoll & "</td></tr>"
    next

    if (iBBSUserLevel >= USERLEVEL_Member and vPollInfo(PI_RegisteredCanAddOptions) = 1) or (iBBSUserLevel = USERLEVEL_GUEST and vPollInfo(PI_RegisteredCanAddOptions) = 0) and (iHasVoted = 0 or vPollInfo(PI_MultiVoting)=1) and bCanVote  then
      GeneratePoll = GeneratePoll & "<tr><td class='messagecellbody' colspan='" & iColumns & "'>" & dictLanguage("GLOBAL-POLL7") & "<br/>"
      GeneratePoll = GeneratePoll & "<input " & sType & " name='optionid' value='newoption'><input type='text' class='bbstextbox' name='newoptiontext' size='40' maxlength='75'></td></tr>"
    end if

    GeneratePoll = GeneratePoll & "<tr><td colspan='" & iColumns & "' class='messagecellbody' align='right'>"
    if vPollInfo(PI_MultiVoting) = 1 then GeneratePoll = GeneratePoll & dictLanguage("GLOBAL-POLL1") & "<br/>"
    if iHasVoted = True then GeneratePoll = GeneratePoll & dictLanguage("GLOBAL-POLL2") & "<br/>"
    GeneratePoll = GeneratePoll & "</td></tr><tr><td class='messagecellfooter' colspan='" & iColumns & "' align='center'>"
    if not(iHasVoted) or vPollInfo(PI_MultiVoting) = 1 then GeneratePoll = GeneratePoll & "<input class='bbsbutton' type='submit' value='" & dictLanguage("GLOBAL-SUBMIT") & "'>"
    GeneratePoll = GeneratePoll & "</td></tr></table></form><br/>"

  end function

  function PreviewPoll(byref vPollInfo, vOptionInfo, sSubject)
    ' DESCRIPTION : Generates a preview of a poll.
    ' INPUTS      : A poll information structure.
    '             : An array of option information structures.
    '             : The subject of the thread.
    ' RETURNS     : HTML

    dim iColumns, index, sType, sHeader

    if not(IsArray(vOptionInfo)) then exit function

    if vPolLInfo(PI_DisplayNames) = 1 then
      iColumns = 3
      sHeader = "<tr><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL3") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL4") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL5") & "</td></tr>"
    else
      iColumns = 2
      sHeader = "<tr><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL3") & "</td><td class='messagecellheader2'>" & dictLanguage("GLOBAL-POLL5") & "</td></tr>"
    end if

    if vPollInfo(PI_Multivoting) = 0 then
      sType = "type='radio' class='bbsradiobox'"
    else
      sType = "type='checkbox' class='bbscheckbox'"
    end if


    PreviewPoll = "<table class='bbstable' width='95%' align='center' cellspacing='1'><tr><td colspan='" & iColumns & "' class='messagecellheader'>" & BBS.ValidateField(BBS.FilterView(vThreadInfo(TI_Subject))) & "</td></tr>" & sHeader

    for index = 0 to UBOUND(vOptionInfo)
      vOptionInfo(index)(OI_Votes) = 10
      vOptionInfo(index)(OI_Percentage) = BBS.NiceNumber(100 / (ubound(vOptionInfo) + 1))
      PreviewPoll = PreviewPoll & "<tr><td class='messagecellbody'>"
      PreviewPoll = PreviewPoll & "<input " & sType & " value='" & vOptionInfo(index)(OI_OptionID) & "' name='optionid'>" & BBS.ValidateField(BBS.FilterView(vOptionInfo(index)(OI_Description))) & "</td>"
      if vPollInfo(PI_DisplayNames) = 1 then
        if vOptionInfo(index)(OI_Registered) = 1 then
          PreviewPoll = PreviewPoll & "<td class='messagecellbody'>" & BBS.CreateUsernameLinkbyID(vOptionInfo(index)(OI_MemberID)) & BBS.ValidateField(BBS.GetUserInfobyName(vOptionInfo(index)(OI_MemberID))(UI_Username)) & "</a></td>"
        else
          PreviewPoll = PreviewPoll & "<td class='messagecellbody'>" & BBS.ValidateField(vOptionInfo(index)(OI_Guestname)) & "</td>"
        end if
      end if
      PreviewPoll = PreviewPoll & "<td nowrap width='35%' class='messagecellbody' align='left'>"
      PreviewPoll = PreviewPoll & vOptionInfo(index)(OI_Votes) & " " & dictLanguage("GLOBAL-POLL6")
      PreviewPoll = PreviewPoll & " - [" & vOptionInfo(index)(OI_Percentage) & "%]<br/><img src='" & dictImages("POLL-LEFT") & "' alt=''><img src='" & dictImages("POLL-CENTER") & "' width='" & round(vOptionInfo(index)(OI_Percentage) * 3) & "' height='11' alt=''><img src='" & dictImages("POLL-RIGHT") & "' alt=''>"
      PreviewPoll = PreviewPoll & "</td></tr>"
    next

    PreviewPoll = PreviewPoll & "<tr><td class='messagecellfooter' colspan='" & iColumns & "' align='center'><button class='bbsbutton'>" & dictLanguage("GLOBAL-SUBMIT") & "</button>"
    PreviewPoll = PreviewPoll & "</td></tr></table><br/>"

  end function

END CLASS
%>