<%
' How-to: Later add a how-to-use tutorial

CONST sSettingsTable = "settings"

Dim Settings
Set Settings = New classSettings

Class classSettings
  Private dictSettings

  Private Sub Class_Initialize()
      Set dictSettings = Nothing
  End Sub

  private sub GetGroup(group)
      ' DESCRIPTION : Retrieves the list of setting values from the database and stores them in the dictSettings object
    ' Settings are loaded in groups.
    ' Each group is stored in its own a dictionary object.
    ' dictSettings is a dictionary object that stores all the group dictionary objects
    dim vSettingsArray, index, iUpperBound, SQL
    dim dictSettingsGroup

    If dictSettings Is Nothing Then
      Set dictSettings = server.createobject("SCRIPTING.DICTIONARY")
    end if

    if Not dictSettings.exists(group) Then
      Set dictSettingsGroup = server.createobject("SCRIPTING.DICTIONARY")
      ' Check if the config array is cached in the application cache
      ' (this is one of the few times we bypass the caching API)
      vSettingsArray = BBS.Cache(group)
      if IsEmpty(vSettingsArray) then
        'response.write BBS.ValidateSQL(group)
        'response.end
        SQL = "select " & BBS.EscapeDBField("settingskey") & ", " & BBS.EscapeDBField("settingsvalue") & ", " & BBS.EscapeDBField("settingsgroup") & " from " & BBS.EscapeDBField(sSettingsTable) & " where " & BBS.EscapeDBField("settingsgroup") & "='" & BBS.ValidateSQL(group) & "'"
        rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        BBS.AddQuery(SQL)
        if not(rsMaster.EOF) then vSettingsArray = rsMaster.GetRows
        BBS.CacheAdd group, vSettingsArray
        rsMaster.Close
      else
        iBBSCachedHits = iBBSCachedHits + 1
      end if

      if isArray(vSettingsArray) then
        iUpperBound = UBOUND(vSettingsArray, 2)
        for index=0 to iUpperBound
          dictSettingsGroup(vSettingsArray(0, index)) = vSettingsArray(1, index)
        next
      end if
      dictSettings.ADD group, dictSettingsGroup
    end if
  end sub

  sub SaveSetting(group, key, item)
    ' Adds a new key and value to the database
    ' Adds value to dictionary object
    ' Clears cache

    Dim sSQL, dictSettingsGroup

    GetGroup group
    if dictSettings.exists(group) then
      Set dictSettingsGroup = dictSettings.item(group)

      sSQL = ""
      If dictSettingsGroup.exists(key) Then
        if item<>dictSettingsGroup.item(key) then  ' If new value is not empty and not the same and it exists then update
          sSQL = "update " & BBS.EscapeDBField(sSettingsTable) & " set " & BBS.EscapeDBField("settingsvalue") & " = '" & BBS.ValidateSQL(item) & "' where " & BBS.EscapeDBField("settingskey") & "='" & BBS.ValidateSQL(key) & "' AND " & BBS.EscapeDBField("settingsgroup") & "='" & BBS.ValidateSQL(group) & "'"
        end if
      else   ' If new value is not empty and it doesn't exists then add
        sSQL = "insert into " & BBS.EscapeDBField(sSettingsTable) & " (" & BBS.EscapeDBField("settingskey") & ", " & BBS.EscapeDBField("settingsvalue") & ", " & BBS.EscapeDBField("settingsgroup") & ") VALUES ('" & BBS.ValidateSQL(key) & "','" & BBS.ValidateSQL(item) & "','" & BBS.ValidateSQL(group) & "')"
      end if
      if sSQL <> "" Then
        dbconnection.execute(sSQL)
        BBS.AddQuery(sSQL)
        dictSettingsGroup.item(key) = item
        BBS.CacheDelete group
      end if
    end if
  end sub

  function GetSetting(group, key)
    ' Loads setting value
    ' First loads settings group then retreives value
    dim dictSettingsGroup

    GetSetting = ""
    GetGroup group

    if dictSettings.exists(group) then
      Set dictSettingsGroup = dictSettings.item(group)
      if dictSettingsGroup.exists(key) then
        GetSetting = dictSettingsGroup.item(key)
      end if
    end if
  end function

  sub DeleteSetting(group, key)
    ' Deletes a setting, clears cache
    dim dictSettingsGroup, sSQL

    GetGroup group

    If Not dictSettings Is Nothing Then
      if dictSettings.exists(group) Then

        Set dictSettingsGroup = dictSettings.item(group)
        dictSettingsGroup.Remove key
        sSQL = "delete from " & BBS.EscapeDBField(sSettingsTable) & " where " & BBS.EscapeDBField("settingskey") & "='" & BBS.ValidateSQL(key) & "' AND " & BBS.EscapeDBField("settingsgroup") & "='" & BBS.ValidateSQL(group) & "'"
        BBS.AddQuery(sSQL)
        dbconnection.execute(sSQL)
      end if
    end if
    BBS.CacheDelete group
  end sub

  sub Clear(group)
    ' Deletes all settings in a group, clears cache
    dim dictSettingsGroup

    If Not dictSettings Is Nothing Then
      if dictSettings.exists(group) Then
        Set dictSettingsGroup = dictSettings.item(group)
        dictSettingsGroup.RemoveAll
      end if
    end if
    BBS.CacheDelete group
  end sub

  sub ShowSettingTextBoxes(group)
    ' Shows all settinsg in a groups as a set of text boxes
    ' text boxes are arranged in td and tr tags
    ' Function should be called inside <table></table> tags
    dim dictSettingsGroup, i, vKeys, item, key, iLen

    GetGroup group
    if dictSettings.exists(group) then
      Set dictSettingsGroup = dictSettings.item(group)
      vKeys = dictSettingsGroup.Keys
      For i=0 to UBOUND(vKeys)
        key = vKeys(i)
        item = dictSettingsGroup.item(vKeys(i))
        Response.write "<tr><td class=""messagecellbody"">" & key & "</td>"
        Response.write "<td class=""messagecellbody"">"
        iLen = len(item)
        if iLen < 100 then
          Response.write "<input type='text' size='100' class='bbstextbox' name='" & BBS.ValidateField(key) & "' value='" & BBS.ValidateField(item) & "'>"
        else
          Response.write "<textarea cols=""73"" rows=""5"" class='bbstextbox' name=""" & BBS.ValidateField(key) & """>" & BBS.ValidateField(item) & "</textarea>"
        end if
        Response.write "</td></tr>"
      next
    end if
  end sub

  sub SaveSettingsFromRequest(group)
    ' looks for setting values in request
    ' saves values
    ' note: SaveSetting only saves updated values
    dim dictSettingsGroup, i, vKeys, iKey, iItem

    GetGroup group
    if dictSettings.exists(group) then
      Set dictSettingsGroup = dictSettings.item(group)
      vKeys = dictSettingsGroup.Keys
      For i=0 to UBOUND(vKeys)
        iKey = vKeys(i)
        iItem = request.form(vKeys(i))
        if iItem <> "" then
          SaveSetting group, iKey, iItem
        else
          DeleteSetting group, iKey
        end if
      next
    end if
    BBS.CacheDelete group
  end sub

  sub ShowSetDropdownList(group)
    ' Creates a drop down list with all setting groups
    ' Appends a (new) to dropdown

    dim SQL, aSets, index, sIsChecked
    Response.write "<select class='bbsdropdownbox' name='group'>"

    SQL = "select " & BBS.EscapeDBField("settingsgroup") & " from " & BBS.EscapeDBField(sSettingsTable) & " GROUP BY " & BBS.EscapeDBField("settingsgroup")
    rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if not(rsMaster.EOF) then aSets = rsMaster.GetRows
    if isArray(aSets) then
      for index=0 to UBOUND(aSets, 2)
        if aSets(0, index) = group then
          sIsChecked = " selected "
        else
          sIsChecked = ""
        end if
        Response.write "<option " & sIsChecked & " value='" & BBS.ValidateField(aSets(0, index)) & "'>" & BBS.ValidateField(aSets(0, index)) & "</option>"
      next
      if "(new)" = group then
        sIsChecked = " selected "
        else
            sIsChecked = ""
          end if
    end if
    rsMaster.close
    Response.write "<option " & sIsChecked & " value='(new)'>(new)</option>"
    Response.write "</select>"
  end sub
End Class

%>