<%

  ' MegaBBS filesystem API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : includes.asp

dim Templates
set Templates = new TemplatesAPI

CLASS TemplatesAPI

  function GetTemplateInfoStruct()
    dim vResult(3)
    GetTemplateInfoStruct = vResult
  end function

  function GetTemplateInfo(byval iTemplateID)

    dim SQL, rsInfo, vResult
    set rsInfo = server.Createobject("ADODB.Recordset")
    vResult = GetTemplateInfoStruct()

    if BBS.ValidateNumeric(iTemplateID) = 0 then
      SQL = "select schemeid, schemepath, schemename, isdefault from schemes where isdefault=1"
    else
      SQL = "select schemeid, schemepath, schemename, isdefault from schemes where schemeid=" & BBS.ValidateNumeric(iTemplateID)
    end if

    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if not(rsInfo.EOF) then
      vResult(TMP_TemplateID)   = rsInfo.fields("schemeid").value
      vResult(TMP_TemplatePath) = rsInfo.fields("schemepath").value
      vResult(TMP_TemplateName) = rsInfo.fields("schemename").value
      vResult(TMP_IsDefault)    = rsInfo.fields("isdefault").value
    else
      vResult(TMP_TemplateID) = -1
    end if
    rsInfo.Close
    GetTemplateInfo = vResult
  end function

  function SetTemplate(byval iTemplateID)
    dim vUserInfo, SQL, vSchemeInfo
    vTemplateInfo = GetTemplateInfo(iTemplateID)
    if vTemplateInfo(TMP_TemplateID) > 0 then
      response.cookies(sBBSCookieRoot & "schemeid") = iTemplateID
      if iBBSMEmberID > 0 then
        if vTemplateInfo(TMP_IsDefault) =1 then
          SQL = "update members set schemeid=0 where memberid=" & BBS.ValidateNumeric(iBBSMemberID)
        else
          SQL = "update members set schemeid=" & BBS.ValidateNumeric(iTemplateID) & " where memberid=" & BBS.ValidateNumeric(iBBSMemberID)
        end if
        dbConnection.execute SQL
        BBS.CacheDelete("UI-" & iBBSMEmberID)
        BBS.AddQuery(SQL)
      end if
    end if
  end function

  function GetNumberOfUsers(iSchemeID, iIsDefault)
    dim SQL, rsInfo
    set rsInfo = server.createobject("ADODB.Recordset")

    if iIsDefault = 1 then
      SQL = "select count(*) as numusers from members where schemeid=0 or schemeid=" & BBS.ValidateNumeric(iSchemeID)
    else
      SQL = "select count(*) as numusers from members where schemeid=" & BBS.ValidateNumeric(iSchemeID)
    end if
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)

    if rsInfo.EOF then
      GetNumberOfUsers = 0
    else
      GetNumberOfUsers = rsInfo.fields("numusers").value
    end if
  end function

  function DeleteTemplate(iTemplateID)
    dim SQL, vTemplateInfo
    vTemplateInfo = GetTemplateInfo(iTemplateID)
    if vTemplateInfo(TMP_TemplateID) > 0 then
      SQL = "delete from schemes where schemeid=" & BBS.ValidateNumeric(iTemplateID) & " and isdefault<>1"
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)

      ' Redirect members using this template to use the default
      SQL = "update members set schemeid=" & BBS.ValidateNumeric(GetDefaultTemplate()) & " where schemeid=" & BBS.ValidateNumeric(iTemplateID)
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
    end if
  end function

  function GetDefaultTemplate()
    dim SQL, rsInfo
    set rsInfo = server.createobject("ADODB.Recordset")
    SQL = "select schemeid from schemes where isdefault=1"
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if rsInfo.EOF then
      GetDefaultTemplate = 0
    else
      GetDefaultTemplate = rsInfo.fields(0).value
    end if
    rsInfo.Close
    set rsInfo = nothing
  end function

  function SetDefault(iTemplateID)
    dim SQL, vTemplateInfo
    vTemplateInfo = GetTemplateInfo(iTemplateID)
    if vTemplateInfo(TMP_TemplateID) > 0 then
      SQL = "update schemes set isdefault=0"
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
      SQL = "update schemes set isdefault=1 where schemeid=" & BBS.ValidateNumeric(iTemplateID)
      dbConnection.execute SQL,, adTextNoRecords
      BBS.AddQuery(SQL)
    end if
  end function

  sub ToggleVisible(byval iTemplateID, byval bVisible)
    dim SQL
    SQL = "update schemes set hidden=" & BBS.BooleanNot(BBS.ValidateBoolean(bVisible)) & " where schemeid=" & BBS.ValidateNumeric(iTemplateID)
    dbConnection.execute SQL,, adTextNoRecords
    BBS.AddQuery(SQL)
  end sub

END CLASS
%>