<%
'***************************************
' File:   Upload.asp
' Author: Jacob "Beezle" Gilley
' Email:  avis7@airmail.net
' Date:   12/07/2000
' Comments: The code for the Upload, CByteString,
'     CWideString subroutines was originally
'     written by Philippe Collignon...or so
'     he claims. Also, I am not responsible
'     for any ill effects this script may
'     cause and provide this script "AS IS".
'     Enjoy!
'
'
' Some code copied from another upload
' component by Lewis Moten - Matt (pd9)
'
'
'****************************************

Class FileUploader
  Public  Files
  Private mcolFormElem

  Private Sub Class_Initialize()
    Set Files = Server.CreateObject("Scripting.Dictionary")
    Set mcolFormElem = Server.CreateObject("Scripting.Dictionary")
  End Sub

  Private Sub Class_Terminate()
    If IsObject(Files) Then
      Files.RemoveAll()
      Set Files = Nothing
    End If
    If IsObject(mcolFormElem) Then
      mcolFormElem.RemoveAll()
      Set mcolFormElem = Nothing
    End If
  End Sub

  Public Property Get Form(sIndex)
    Form = ""
    If mcolFormElem.Exists(LCase(sIndex)) Then Form = mcolFormElem.Item(LCase(sIndex))
  End Property

  Public Default Sub Upload()
    Dim biData, sInputName
    Dim nPosBegin, nPosEnd, nPos, vDataBounds, nDataBoundPos
    Dim nPosFile, nPosBound

    biData = Request.BinaryRead(Request.TotalBytes)
    nPosBegin = 1
    nPosEnd = InstrB(nPosBegin, biData, CByteString(Chr(13)))

    If (nPosEnd-nPosBegin) <= 0 Then Exit Sub

    vDataBounds = MidB(biData, nPosBegin, nPosEnd-nPosBegin)
    nDataBoundPos = InstrB(1, biData, vDataBounds)

    Do Until nDataBoundPos = InstrB(biData, vDataBounds & CByteString("--"))

      nPos = InstrB(nDataBoundPos, biData, CByteString("Content-Disposition"))
      nPos = InstrB(nPos, biData, CByteString("name="))
      nPosBegin = nPos + 6
      nPosEnd = InstrB(nPosBegin, biData, CByteString(Chr(34)))
      sInputName = CWideString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))
      nPosFile = InstrB(nDataBoundPos, biData, CByteString("filename="))
      nPosBound = InstrB(nPosEnd, biData, vDataBounds)

      If nPosFile <> 0 And  nPosFile < nPosBound Then
        Dim oUploadFile, sFileName
        Set oUploadFile = New UploadedFile

        nPosBegin = nPosFile + 10
        nPosEnd =  InstrB(nPosBegin, biData, CByteString(Chr(34)))
        sFileName = CWideString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))
        oUploadFile.FileName = Right(sFileName, Len(sFileName)-InStrRev(sFileName, "\"))

        nPos = InstrB(nPosEnd, biData, CByteString("Content-Type:"))
        nPosBegin = nPos + 14
        nPosEnd = InstrB(nPosBegin, biData, CByteString(Chr(13)))

        oUploadFile.ContentType = CWideString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))

        nPosBegin = nPosEnd+4
        nPosEnd = InstrB(nPosBegin, biData, vDataBounds) - 2
        if (lenb(MidB(biData, nPosBegin, nPosEnd-nPosBegin)) mod 2) = 1 then
          oUploadFile.FileData = MidB(biData, nPosBegin, nPosEnd-nPosBegin) & chrb(0)
        else
          oUploadFile.FileData = MidB(biData, nPosBegin, nPosEnd-nPosBegin)
        end if

        If oUploadFile.FileSize > 0 Then Files.Add LCase(sInputName), oUploadFile
      Else
        nPos = InstrB(nPos, biData, CByteString(Chr(13)))
        nPosBegin = nPos + 4
        nPosEnd = InstrB(nPosBegin, biData, vDataBounds) - 2
        If Not mcolFormElem.Exists(LCase(sInputName)) Then mcolFormElem.Add LCase(sInputName), CWideString(MidB(biData, nPosBegin, nPosEnd-nPosBegin))
        ' If Not mcolFormElem.Exists(LCase(sInputName)) Then mcolFormElem.Add LCase(sInputName), (Mid(biData, nPosBegin, nPosEnd-nPosBegin))
      End If

      nDataBoundPos = InstrB(nDataBoundPos + LenB(vDataBounds), biData, vDataBounds)
    Loop
  End Sub

  'String to byte string conversion
  Private Function CByteString(sString)
    Dim nIndex
    For nIndex = 1 to Len(sString)
       CByteString = CByteString & ChrB(AscB(Mid(sString,nIndex,1)))
    Next
  End Function

  'Byte string to string conversion
  Private Function CWideString(bsString)
    Dim nIndex
    CWideString =""
    For nIndex = 1 to LenB(bsString)
       CWideString = CWideString & Chr(AscB(MidB(bsString,nIndex,1)))
    Next
  End Function
End Class

Class UploadedFile
  Public ContentType
  Public FileName
  Public FileData

  Public Property Get FileSize()
    FileSize = LenB(FileData)
  End Property

  Public Sub SaveToDisk(sPath)
    Dim oFS, oFile
    Dim nIndex

    If sPath = "" Or FileName = "" Then Exit Sub
    If Mid(sPath, Len(sPath)) <> "\" Then sPath = sPath & "\"

    Set oFS = Server.CreateObject("Scripting.FileSystemObject")
    If Not oFS.FolderExists(sPath) Then Exit Sub

    Set oFile = oFS.CreateTextFile(sPath & FileName, True)

    For nIndex = 1 to LenB(FileData)
        oFile.Write Chr(AscB(MidB(FileData,nIndex,1)))
        'response.binarywrite FileData
        'oFile.Write FileData
    Next

    oFile.Close
  End Sub


  Public Sub SaveToDiskMBBSold(sPath)
    Dim oFS, oFile
    Dim nIndex

    If sPath = "" Then Exit Sub

    ' NO NO NO
    do until instr(sPath, "..") = 0
      sPath = replace(sPath, "..", "")
    loop

    Set oFS = Server.CreateObject("Scripting.FileSystemObject")
    ' If Not oFS.FolderExists(sPath) Then Exit Sub

    Set oFile = oFS.CreateTextFile(sPath, True)
    response.write sPath : response.flush

    For nIndex = 1 to LenB(FileData)
      response.write nIndex & "-<br/>" & CRLF
        oFile.Write Chr(AscB(MidB(FileData,nIndex,1)))
    Next

    oFile.Close
  End Sub

sub SaveToDiskMBBS(FileName)
      Dim lobjStream
      Dim lobjRs
      Dim lbinBytes

      Const adTypeBinary = 1
      Const adSaveCreateOverWrite = 2

      ' Don't save files that do not posess binary data
      If LenB(FileData) = 0 Then Exit Sub

      ' Create magical objects from never never land
      Set lobjStream = Server.CreateObject("ADODB.Stream")

      ' Let stream know we are working with binary data
      lobjStream.Type = adTypeBinary

      ' Open stream
      Call lobjStream.Open()

      ' Convert Integer Subtype Array to Byte Subtype Array
      lbinBytes = ASCII2Bytes(FileData)

      ' Write binary data to stream
      Call lobjStream.Write(lbinBytes)

      ' Save the binary data to file system
      ' Overwrites file if previously exists!
      Call lobjStream.SaveToFile(FileName, adSaveCreateOverWrite)

      ' Close the stream object
      Call lobjStream.Close()

      ' Release objects
    Set lobjStream = Nothing
end sub


  Private Function ASCII2Bytes(ByRef pbinBinaryData)

    Dim lobjRs
    Dim llngLength
    Dim lbinBuffer
    CONST adLongVarBinary = 205

    ' get number of bytes
    llngLength = LenB(pbinBinaryData)

    Set lobjRs = Server.CreateObject("ADODB.Recordset")

    ' create field in an empty recordset to hold binary data
    Call lobjRs.Fields.Append("BinaryData", adLongVarBinary, llngLength)

    ' Open recordset
    Call lobjRs.Open()

    ' Add a new record to recordset
    Call lobjRs.AddNew()

    ' Populate field with binary data
    Call lobjRs.Fields("BinaryData").AppendChunk(pbinBinaryData & ChrB(0))

    ' Update / Convert Binary Data
      ' Although the data we have is binary - it has still been
      ' formatted as 4 bytes to represent each byte.  When we
      ' update the recordset, the Integer Subtype Array that we
      ' passed into the Recordset will be converted into a
      ' Byte Subtype Array
    Call lobjRs.Update()

    ' Request binary data and save to stream
    lbinBuffer = lobjRs.Fields("BinaryData").GetChunk(llngLength)

    ' Close recordset
    Call lobjRs.Close()

    ' Release recordset from memory
    Set lobjRs = Nothing

    ' Return Bytes
    ASCII2Bytes = lbinBuffer

  End Function

  Public Sub SaveToDatabase(ByRef oField)
    If LenB(FileData) = 0 Then Exit Sub

    If IsObject(oField) Then
        oField.AppendChunk FileData & chrb(0)
    End If
  End Sub

End Class
%>