<!-- #include file="hooks\user-add.asp" -->
<!-- #include file="hooks\user-delete.asp" -->
<!-- #include file="hooks\user-update.asp" -->
<%

  ' MegaBBS Usermaintenance API
  ' Copyright PD9 Software
  ' Please refer to the license agreement for more information on reuse

  ' Depends on : include.asp, constants.asp

dim UserMaintenance
set UserMaintenance = new MegaBBSUserMaintenanceAPI

CLASS MegaBBSUserMaintenanceAPI

  function UpdateUser(byRef vUpdateUserInfo)

    ' DESCRIPTION : Updates a user in the forum database
    ' INPUTS      : vUpdateUserInfo - A UserInfo structure
    ' RETURNS     : 0 if successful, otherwise an error code

    dim rsUpdateUser, SQL, sKey
    set rsUpdateUser = server.CreateObject("ADODB.Recordset")

    SQL = "select * from members where memberid=" & BBS.ValidateNumeric(vUpdateUserInfo(UI_MemberID))
    rsUpdateUser.open SQL, dbConnection, adOpenStatic, adLockOptimistic

    if not(rsUpdateUser.EOF) then
      SQL = "update members set "
      SQL = SQL & "username='" & BBS.SQLTrim(vUpdateUserInfo(UI_Username), 20) & "', "
      SQL = SQL & BBS.EscapeDBField("password") & "='" & BBS.SQLTrim(vUpdateUserInfo(UI_Password), 50) & "', "
      SQL = SQL & " realname='" & BBS.SQLTrim(vUpdateUserInfo(UI_RealName),50) & "', "
      SQL = SQL & " emailaddress='" & BBS.SQLTrim(vUpdateUserInfo(UI_EMAILADDR), 75) & "', "
      SQL = SQL & " website='" & BBS.SQLTrim(vUpdateUserInfo(UI_Websiteaddr), 75) & "', "
      SQL = SQL & " icqnumber='" & BBS.SQLTrim(vUpdateUserInfo(UI_ICQNumber), 15) & "', "
      SQL = SQL & " aim='" & BBS.SQLTrim(vUpdateUserInfo(UI_AIM), 75) & "', "
      SQL = SQL & " msn='" & BBS.SQLTrim(vUpdateUserInfo(UI_MSN), 75) & "', "
      SQL = SQL & " yahoo='" & BBS.SQLTrim(vUpdateUserInfo(UI_Yahoo), 75) & "', "
      SQL = SQL & " showemail=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_ShowEmail)) & ", "
      SQL = SQL & " interests='" & BBS.ValidateSQL(vUpdateUserInfo(UI_Interests)) & "', "
      SQL = SQL & " usesignature=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_UseSignature)) & ", "
      SQL = SQL & " viewsignature=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_ViewSignature)) & ", "
      SQL = SQL & " signature='" & BBS.ValidateSQL(vUpdateUserInfo(UI_Signature)) & "', "
      SQL = SQL & " location='" & BBS.SQLTrim(vUpdateUserInfo(UI_Location), 50) & "', "
      SQL = SQL & " avatarurl='" & BBS.SQLTrim(vUpdateUserInfo(UI_ProfileURL), 150) & "', "
      SQL = SQL & " photourl='" & BBS.SQLTrim(vUpdateUserInfo(UI_PhotoURL), 150) & "', "
      SQL = SQL & " timeoffset=" & vUpdateUserInfo(UI_TimeOffset) & ", "
      SQL = SQL & " dateregistered=" & sDateDelimiter & BBS.GetSQLDateTime(vUpdateUserInfo(UI_dateregistered)) & sDateDelimiter & ", "
      SQL = SQL & " invisible=" & vUpdateUserInfo(UI_Invisible) & ", "
      SQL = SQL & " userichedit=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_userichedit)) & ", "
      SQL = SQL & " totalposts=" & vUpdateUserInfo(UI_TotalPosts) & ", "
      SQL = SQL & " lastlogon=" & sDateDelimiter & BBS.GetSQLDateTime(vUpdateUserInfo(UI_LastLogon)) & sDateDelimiter & ", "
      SQL = SQL & " active=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_Active)) & ", "
      SQL = SQL & " disablepostcount=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_disablepostcount)) & ", "
      SQL = SQL & " schemeid=" & vUpdateUserInfo(UI_TemplateID) & ", "
      SQL = SQL & " logoffurl='" & BBS.SQLTrim(vUpdateUserInfo(UI_Logoffurl), 100) & "', "
      SQL = SQL & " usecustomrank=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_UseCustomRank)) & ", "
      SQL = SQL & " customrank='" & BBS.ValidateSQL(BBS.ValidateBlank(vUpdateUserInfo(UI_Rank))) & "', "
      SQL = SQL & " sendprivatenotifications=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_SendPrivateNotifications)) & ", "
      SQL = SQL & " notificationpreference='" & BBS.SQLTrim(vUpdateUserInfo(UI_EmailNotifications), 20) & "', "
      SQL = SQL & " defaultthreadview='" & BBS.SQLTrim(vUpdateUserInfo(UI_defaultthreadview), 20) & "', "
      SQL = SQL & " defaultforumview='" & BBS.SQLTrim(vUpdateUserInfo(UI_defaultforumview), 20) & "', "
      SQL = SQL & " includebody=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_includebody)) & ", "
      SQL = SQL & " languageid=" & BBS.ValidateNumeric(vUpdateUserInfo(UI_LanguageID)) & ", "
      SQL = SQL & " oktopost=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_OkToPost)) & ", "
      SQL = SQL & " disallowbroadcasts=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_DisallowBroadcasts)) & ", "
      SQL = SQL & " viewavatars=" & BBS.ValidateBoolean(vUpdateUserInfo(UI_ViewAvatars)) & ", "
      SQL = SQL & " salt='" & BBS.SQLTrim(vUpdateUserInfo(UI_Salt), 10) & "', "
      SQL = SQL & " vcode='" & BBS.SQLTrim(BBS.ValidateBlank(vUpdateUserInfo(UI_VCode)), 10) & "', "
      SQL = SQL & " quickreplymode='" & BBS.SQLTrim(BBS.ValidateBlank(vUpdateUserInfo(UI_QuickReplyMode)), 7) & "', "
      SQL = SQL & " ignorelist='" & BBS.ValidateSQL(BBS.ValidateBlank(vUpdateUserInfo(UI_IgnoreList))) & "' "
      SQL = SQL & " WHERE memberid=" & BBS.ValidateNumeric(vUpdateUserInfo(UI_MemberID))
      dbConnection.Execute SQL
      BBS.AddQuery(SQL)

      rsUpdateUser.Close
      UpdateUser = ERR_None
      sKey = "UI-" & vUpdateUserInfo(UI_MemberID)
      BBS.CacheDelete sKey
      HookUserUpdate(vUpdateUserInfo)

    else
      UpdateUser = ERR_NoUserFound
      rsUpdateUser.Close
    end if

    set rsUpdateUser = Nothing

  end function


  function CreateUser(byref stUserInfo)

    ' DESCRIPTION : Creates a user
    ' INPUTS      : A userinfo structure
    ' RETURNS     : The newly created memberid
    ' NOTES       : Checks for existing username first

    dim SQL, rsNewID, sKey
    set rsNewId = server.createobject("ADODB.Recordset")

    ' Check for any obvious errors
    if BBS.UserExistsbyName(stUserInfo(UI_Username)) and len(trim(stUserInfo(UI_Username))) > 0 then
      CreateUser = -1
      exit function
    end if

    if not(IsDate(stUserInfo(UI_DateRegistered))) then
      stUserInfo(UI_DateRegistered) = sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter
    else
      stUserInfo(UI_DateRegistered) = sDateDelimiter & BBS.GetSQLDateTime(stUserInfo(UI_DateRegistered)) & sDateDelimiter
    end if
    if not(IsDate(stUserInfo(UI_LastLogon))) then
      stUserInfo(UI_LastLogon) = sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter
    else
      stUserInfo(UI_LastLogon) = sDateDelimiter & BBS.GetSQLDAteTime(stUserInfo(UI_LastLogon)) & sDateDelimiter
    end if

    if len(trim(stUserInfo(UI_EmailNotifications))) = 0 then stUserInfo(UI_EmailNotifications) = "default"
    if len(trim(stUserInfo(UI_DefaultThreadView))) = 0 then stUserInfo(UI_DefaultThreadView) = "default"
    if len(trim(stUserInfo(UI_DefaultForumView))) = 0 then stUserInfo(UI_DefaultForumView) = "default"

    SQL = "insert into members(username, " & BBS.EscapeDBField("password") & ", realname, website, emailaddress, icqnumber, aim, yahoo, msn, totalposts, showemail, active, interests, usesignature, viewsignature, signature, dateregistered, lastlogon, location, notificationpreference, invisible, avatarurl, photourl, defaultthreadview, defaultforumview, userichedit, disablepostcount, schemeid, timeoffset, logoffurl, customrank, usecustomrank, sendprivatenotifications, includebody, languageid, oktopost, disallowbroadcasts, viewavatars, salt, vcode, quickreplymode) values("
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_Username), 20) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_Password), 50) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_Realname), 50) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_WebsiteAddr), 75) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_EmailAddr), 75) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_ICQNumber), 15) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_AIM), 75) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_Yahoo), 75) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_MSN), 75) & "', "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_TotalPosts)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_ShowEmail)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_Active)) & ", "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_Interests)) & "', "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_UseSignature)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_ViewSignature)) & ", "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_Signature)) & "', "
    SQL = SQL & (stUserInfo(UI_DateRegistered)) & ", "
    SQL = SQL & (stUserInfo(UI_LastLogon)) & ", "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_Location), 50) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_EmailNotifications), 20) & "', "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_Invisible)) & ", "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_ProfileURL), 150) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_PhotoURL), 150) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_DefaultThreadView), 20) & "', "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_DefaultForumView), 20) & "', "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_UseRichedit)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_DisablePostCount)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_TemplateID)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_TimeOffset)) & ", "
    SQL = SQL & "'" & BBS.SQLTrim(stUserInfo(UI_LogoffURL), 100) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_Rank)) & "', "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_UseCustomRank)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_SendPrivateNotifications)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_IncludeBody)) & ", "
    SQL = SQL & BBS.ValidateNumeric(stUserInfo(UI_LanguageID)) & ", "
    SQL = SQL & BBS.ValidateBoolean(stUserInfo(UI_OkToPost)) & ", "
    SQL = SQL & BBS.ValidateBoolean(stUserInfo(UI_DisallowBroadcasts)) & ", "
    SQL = SQL & BBS.ValidateBoolean(stUserInfo(UI_ViewAvatars)) & ", "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_Salt)) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_VCode)) & "', "
    SQL = SQL & "'" & BBS.ValidateSQL(stUserInfo(UI_QuickReplyMode)) & "') "
    dbConnection.Execute SQL
    BBS.AddQuery(SQL)

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    BBS.AddQuery(SQL)
    if rsNewID.EOF then
      CreateUser = 0
    else
      CreateUser = clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close

    sKey = "UNAME-" & ucase(stUserInfo(UI_Username))
    BBS.CacheDelete sKey

    ' Call any hooks
    HookUserAdd(stUserInfo)
    set rsNewID = Nothing

  end function

  function DeleteUserByID(byVal iUserID, byVal bRemoveAlbums, byVal bRemoveQuotes, byVal bRemoveCalendarEvents)

    ' DESCRIPTION : Deletes a user from the forum
    ' INPUTS      : iUserID               - The MemberID
    '             : bRemoveAlbums         - Remove the user's photo albums?
    '             : bRemoveQuotes         - Remove the user's quotes?
    '             : bRemoveCalendarEvents - Remove the user's calendar events?
    ' RETURNS     : 0 if successful, otherwise an error code

    dim vUserInfo, sKey, sValidatedName, iValidatedID, FSOImage
    set FSOImage = Server.CreateObject("Scripting.FilesystemObject")
    vUserInfo = BBS.GetUserInfoBYID(iUserID)

    if vUserInfo(UI_MemberID) = -1 then
      DeleteUserByID = ERR_NoUserFound
      Exit Function
    end if
      sValidatedName = BBS.ValidateSQL(vUserInfo(UI_Username))
      iValidatedID   = BBS.ValidateNumeric(vUserInfo(UI_MemberID))
      dbconnection.execute "delete from alerts where memberid=" & iValidatedID
      dbconnection.execute "delete from members where username='" & sValidatedName & "'"
      dbconnection.execute "delete from calendarsevents where owner='"& sValidatedName & "' and ownerstatus=1"
      dbconnection.execute "delete from private where toname='"& sValidatedName & "'"
      dbconnection.execute "delete from sentprivate where fromname='"& sValidatedName & "'"
      dbconnection.execute "delete from memberphotos where memberid=" & iValidatedID
      dbConnection.execute "delete from massnotifications where memberid="& iValidatedID
      dbConnection.execute "delete from signups where memberid="& iValidatedID
      dbConnection.execute "delete from userlevelmembers where id=" & iValidatedID & " and idtype=" & USERLEVEL_MEMBER
      dbConnection.execute "delete from groupmembers where memberid=" & iValidatedID
      dbconnection.execute "delete from notifications where memberid=" & iValidatedID
      dbConnection.execute "update messages set memberid=-1, isregistered=" & ST_Unregistered & ", guestname='" & sValidatedName & "' where memberid=" & iValidatedID
      dbConnection.execute "update threads set memberid=-1, isregistered=" & ST_Unregistered & ", guestname='" & sValidatedName & "' where memberid=" & iValidatedID
      dbConnection.execute "update threads set lastpostermemberid=-1, lastposterisregistered=" & ST_Unregistered & ", lastposterguestname='" & sValidatedName & "' where memberid=" & iValidatedID
      dbConnection.execute "update photocomments set registered=0 where username='" & sValidatedName & "'"
      dbConnection.execute "update pollvoted set memberid=-1 where memberid=" & iValidatedID

      if (bRemoveQuotes) then
        dbConnection.execute "update randomquotes set registered=0 where owner='" & sValidatedName & "'"
      else
        dbConnection.execute "delete from randomquotes where owner='" & sValidatedName & "'"
      end if

      if (bRemoveAlbums) then
        dbConnection.execute "delete from albums where username='" & sValidatedName & "'"
        dbConnection.execute "delete from photos where username='" & sValidatedName & "'"
      end if

      if (bRemoveCalendarEvents) then
        if ucase(sBBSDatabaseType) = "MYSQL" Then
          dbConnection.execute "delete signups from signups inner join calendarsevents on signups.calendareventid=calendarsevents.calendareventid where calendarsevents.owner='" & BBS.ValidateSQL(vUserInfo(UI_Username)) & "'"
        else
          dbConnection.execute "delete from signups where calendareventid in (select calendareventid from calendarsevents where calendarsevents.owner='" & BBS.ValidateSQL(vUserInfo(UI_Username)) & "')"
        end if
        dbConnection.execute "delete from calendarsevents where owner='" & BBS.ValidateSQL(vUserInfo(UI_Username)) & "'"
      else
        dbConnection.execute "update calendarsevents set ownerstatus=" & ST_Unregistered & " where owner='" & sValidatedName & "'"
      end if

      on error resume next
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "p" & ".jpg")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "p" & ".jpeg")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "p" & ".gif")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "p" & ".bmp")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "p" & ".png")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "a" & ".jpg")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "a" & ".jpeg")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "a" & ".gif")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "a" & ".bmp")
         FSOImage.DeleteFile (server.mappath(sBBSForumRoot & "/profile/uploads") & "/" & vUserInfo(UI_MemberID) & "a" & ".png")
      on error goto 0

      DeleteUserByID = ERR_None

      ' Call any hooks
      HookUserDelete (vUserInfo)
      BBS.CacheDeleteAll
  end function

  function RenameUser(byval sOldName, byval sNewName)
    ' DESCRIPTION : Renames a user

    if not(BBS.UserExists(sOldName)) or BBS.UserExists(sNewName) then
      if not LCase(sOldName) = LCase(sNewName) then
        RenameUser = False
        exit function
      end if
    end if

    sOldName = BBS.ValidateSQL(sOldName)
    sNewName = BBS.ValidateSQL(sNewName)

    dbconnection.execute "update members set " & BBS.EscapeDBField("username") & "='"& sNewName & "' where " & BBS.EscapeDBField("username") & "='" & sOldName & "'"
    dbconnection.execute "update calendarsevents set owner='"& sNewName & "'  where owner='"& sOldName & "' and ownerstatus=1"
    dbconnection.execute "update private set toname='"& sNewName & "' where toname='"& sOldName & "'"
    dbconnection.execute "update sentprivate set fromname='"& sNewName & "' where fromname='"& sOldName & "'"
    dbConnection.execute "update photocomments set " & BBS.EscapeDBField("username") & "='"& sNewName & "'  where " & BBS.EscapeDBField("username") & "='" & sOldName & "'"
    dbConnection.execute "update randomquotes set owner='"& sNewName & "'  where owner='" & sOldName & "'"
    dbConnection.execute "update albums set " & BBS.EscapeDBField("username") & "='"& sNewName & "' where username='" & sOldName & "'"
    dbConnection.execute "update photos set " & BBS.EscapeDBField("username") & "='"& sNewName & "' where username='" & sOldName & "'"
    dbConnection.execute "update calendarsevents set owner='"& sNewName & "' where owner='" & sOldName & "'"
    RenameUser = True
    BBS.CacheDeleteAll
  end function

  Function GeneratePassword ()
    ' DESCRIPTION : Generates a random password
    ' RETURNS     : A password

    dim bUseOldStylePasswords
    Dim Hash1(15)
    Dim Hash2(15)
    dim X, Y, Z, index, iToLower, sCharValue

    bUseOldstylePasswords = False

    if bUseOldStylePasswords = False then
      Randomize()
      do until len(GeneratePassword) = 10
        sCharValue = Chr(Int((122 - 48 + 1) * Rnd + 48))
        if not(asc(sCharValue) >= 58 and asc(sCharValue) <= 64) and not(asc(sCharValue) >= 91 and asc(sCharValue) <= 96) then
          GeneratePassword = GeneratePassword & sCharValue
        end if
      loop
    else
      Hash1(0) = "big"
      Hash1(1) = "fur"
      Hash1(2) = "tiny"
      Hash1(3) = "hot"
      Hash1(4) = "red"
      Hash1(5) = "blue"
      Hash1(6) = "good"
      Hash1(7) = "sam"
      Hash1(8) = "nice"
      Hash1(9) = "blue"
      Hash1(10) = "pen"
      Hash1(11) = "walk"
      Hash1(12) = "ink"
      Hash1(13) = "light"
      Hash1(14) = "lamp"

      Hash2(0) = "pond"
      Hash2(1) = "weld"
      Hash2(2) = "heir"
      Hash2(3) = "wavy"
      Hash2(4) = "feet"
      Hash2(5) = "hands"
      Hash2(6) = "hose"
      Hash2(7) = "jobs"
      Hash2(8) = "wire"
      Hash2(9) = "cow"
      Hash2(10) = "book"
      Hash2(11) = "disk"
      Hash2(12) = "bear"
      Hash2(13) = "dog"
      Hash2(14) = "cat"

      Randomize()
      x = int((rnd * 14)+1): y = int((rnd * 14)+1): z = int((rnd * 100))
      GeneratePassword = Hash1(x) & Hash2(y) & Z
    end if
end Function


END CLASS

%>