<!-- #include file="../database/constants.asp"-->
<!-- #include file="include-filesystem.asp"-->
<!-- #include file="include-constants.asp"-->
<!-- #include file="../languages/language-config.asp"-->
<%

' ASP Forum : Master include file : Version 2.2 Beta 2
' Copyright PD9 Software
' Please refer to the license agreement for more information on reuse

' Depends on : constants.asp, include-constants.asp, include-filesystem.asp

dim BBS
set BBS = new MegaBBSAPI

CLASS MegaBBSAPI

  sub SetupBBS
    ' DESCRIPTION : Runs the initialization routines

    ' Temporarily force the cache to be application.  dictConfiguration isn't populated yet
    ' and clearing out the cache only makes sense with an application cache anyway.
    dictConfiguration("sCACHE") = "APPLICATION"
    sBBSCachePrefix = sBBSForumRoot
    if trim(sBBSForumRoot) = "" then sBBSCachePrefix = "_mb"
    if cdate(BBS.Cache("FLUSHDATE")) < now then
      BBS.CacheDeleteAll
      BBS.CacheAdd "FLUSHDATE", dateadd("n", 15, now)
    end if
    dictConfiguration("sCACHE") = ""
    GetConfigVariables
    SetupDatabase
  end sub

  Sub GetConfigVariables
    ' DESCRIPTION : Sets up complex global variables used by various MegaBBS functions

    iBBSCachedHits = 0

    ' Capture any information that may be provided by cookies
    iBBSCookieID       = request.cookies(sBBSCookieRoot & "bbsmid")
    sBBSPassword       = request.cookies(sBBSCookieRoot & "password")

    sBBSForumViewMode  = request.cookies(sBBSCookieRoot & "ForumViewMode")
    sBBSThreadViewMode = request.cookies(sBBSCookieRoot & "ThreadViewMode")
    iBBSGuestID        = request.cookies(sBBSCookieRoot & "guestID")

    ' Get the name of the current file (from the last forward or backslash to the end of the string)
    sBBSPageName = replace(request.servervariables("SCRIPT_NAME"), "\", "/")
    sBBSPageName = mid(sBBSPageName, instrrev(sBBSPageName , "/")+1)

    ' The path to the script, ex "/megaBBS/index.asp"
    sBBScurrentURLPath = request.Servervariables("PATH_INFO")

    ' The complete list of querystrings, ex "reply=true&name=bobsmith"
    sBBSCurrentQueryString = request.Servervariables("QUERY_STRING")

    ' The complete URL and script name, including querystrings, ex "/megabbs/hi.asp?&reply=true&name=bobsmith"
    sBBSCompleteURL = sBBScurrentURLPath & "?" & sBBSCurrentQueryString

    ' The base portion of the URL, minus the path or script name, ex "http://www.mydomain.com"
    if ucase(left(sBBSPreferredDomain,7)) = "HTTP://" or ucase(left(sBBSPreferredDomain,7)) = "HTTP:\\" then
      sBBSBaseURL = sBBSPreferredDomain
    elseif ucase(left(sBBSPreferredDomain,8)) = "HTTPS://" or ucase(left(sBBSPreferredDomain,8)) = "HTTPS:\\" then
      sBBSBaseURL = sBBSPreferredDomain
    else
      sBBSBaseURL = "http://" & sBBSPreferredDomain
    end if

    ' The referring URL
    sBBSReferer = request.ServerVariables("HTTP_REFERER")

    ' http://www.yourdomain.com/megabbs (html encoded)
    sBBSValidatedBaseURL = BBS.ValidateField(sBBSBaseURL & sBBSForumRoot)

    ' http://www.yourdomain.com/megabbs (html encoded)
    sBBSUnvalidatedBaseURL = sBBSBaseURL & sBBSForumRoot

    ' Look for a catlock
    if len(Trim(request.querystring("catlock"))) > 0 then
      iBBSCatLock = BBS.ValidateNumeric(request.querystring("catlock"))
      response.cookies(sBBSCookieRoot & "catlock") = BBS.ValidateNumeric(iBBSCatLock)
    elseif len(trim(request.cookies(sBBSCookieRoot & "catlock"))) > 0 then
      iBBSCatLock = BBS.ValidateNumeric(request.cookies(sBBSCookieRoot & "catlock"))
    else
      iBBSCatLock = -1
    end if

    ' Check if first run for installation
    if bNoSetup = 1 and sBBSPageName = "category-view.asp" then
      response.redirect "admin/bbs-start.asp"
    elseif bNoSetup = True and not sBBSPageName = "category-view.asp" then
      response.write "BBS has not yet been configured. Please run BBS configuration to generate a valid constant file."
      response.end
    end if

  end Sub

  Sub SetupDatabase()
    ' DESCRIPTION : Creates the database connection and a default recordset
    dim index, iUpperBound, sHostAddr, vImpersonateInfo, iDatabaseVersion, vUserInfo

    ' Initialize database connections
    err.clear

    on error resume next
    set dbConnection = server.createobject("ADODB.Connection")
    set rsMaster     = server.createobject("ADODB.Recordset")
    dbConnection.CursorLocation   = adUseServer
    dbConnection.ConnectionString = sConnString
    dbConnection.ConnectionTimeout = 30
    dbConnection.Open
    rsMaster.cachesize = 25

    if err.Number <> 0 then
      response.redirect sBBSForumRoot & "/closed.asp"
    end if
    on error goto 0

    if ucase(sBBSDatabaseType) = "MSSQL" and ucase(sBBSSQLFormat) = "ISO" then
      dbConnection.execute "set dateformat ymd"
    elseif ucase(sBBSDatabaseType) = "MSSQL" and ucase(sBBSSQLFormat) = "EUR" then
      dbConnection.execute "set dateformat dmy"
    elseif ucase(sBBSDatabaseType) = "MSSQL" and ucase(sBBSSQLFormat) = "US" then
      dbConnection.execute "set dateformat mdy"
    end if

    iDatabaseVersion = GetDBVersion
    if iDatabaseVersion < 2.2 and instr(sBBSPageName, "database-upgrade.asp") = 0 and instr(sBBSPageName, "bbs-setup.asp") = 0 and instr(sBBSPageName, "setup.asp") = 0 then response.redirect sBBSForumRoot & "/closed.asp"

    if dbConnection.State <> 0 then
      ' Get values from BBS configuration table
      GetBBSConfigVariables
      GetGlobalVariables

      ' Get the user logon type and global variables
      if sBBSUsername = "12345678901234567890logoff" or iBBSCookieID = -100 then
        iBBSLogonType = US_NotRegistered
        sBBSUsername  = ""
        sBBSPassword  = ""
      else
        iBBSLogonType = CheckUsernameByID (iBBSCookieID, sBBSPassword)
      end if

      ' Now set by CheckUsernameByID
      'if iBBSLogonType = US_Registered then
      '  iBBSMemberID = GetMemberID(sBBSUsername)
      'else
      '  iBBSMemberID = -1
      '  sBBSUsername  = ""
      '  sBBSPassword  = ""
      'end if

      iBBSUserLevel = GetUserLevel(MODULE_BBS, -1)

      if ((len(request.cookies(sBBSCookieRoot & "impersonate")) > 0) AND (iBBSUserLevel = USERLEVEL_GlobalAdministrator)) then
        vImpersonateInfo = BBS.GetUserInfobyID(request.cookies(sBBSCookieRoot & "impersonate"))
        if vImpersonateInfo(UI_MemberID) > 0 then
          ChangeSecurityContext vImpersonateInfo(UI_Username), vImpersonateInfo(UI_Password)
          dictEnvironment("C-IMPERSONATION-ACTIVE") = 1
          dictEnvironment("U-IMPERSONATION-END") = sBBSForumRoot & "/admin/impersonate.asp?action=end&redirect=" & server.urlencode(sBBSForumRoot & "/admin/user-maintenance.asp")
        else
          response.cookies(sBBSCookieRoot & "impersonate") = ""
        end if
      end if

      ' Check if IP is banned
      if IsArray(vBannedIPs) and bEmergencyMode <> 1 then
        iUpperBound = UBOUND(vBannedIPs, 2)
        sHostAddr = ucase(request.servervariables("REMOTE_ADDR"))
        for index = 0 to iUpperBound
          if right(vBannedIPs(0, index), 2) = ".*" then
            ' Remove the .*
            vBannedIPs(0,index) = replace(vBannedIPs(0,index), ".*", "") & "."

            ' Substring match
            if left(sHostAddr, len(vBannedIPs(0, index))) = ucase(vBannedIPs(0, index)) and instr(sBBSPageName, "banned.asp") <= 0 then
              response.redirect sBBSValidatedBaseURL & "/banned.asp"
            end if
          else
            ' Match whole IP
            if sHostAddr = ucase(vBannedIPs(0, index)) and instr(sBBSPageName, "banned.asp") <= 0 then
              response.redirect sBBSValidatedBaseURL & "/banned.asp"
            end if

          end if
        next
      end if

      ' Set the language
      Language.SetLanguage()

      ' If the BBS is locked
      if ValidateBoolean(dictConfiguration("bFORUMLOCKED")) = 1 then
        if iBBSUserLevel < USERLEVEL_GlobalAdministrator and (instr(sBBScurrentURLPath, "/admin") <= 0) and sBBSPageName <> "impersonate.asp" and sBBSPageName <> "bbs-setup.asp" and sBBSPageName <> "database-upgrade.asp" then
          if sBBSLangPage <> "logon" then response.redirect sBBSForumRoot & "/closed.asp?l=1"
        else
          dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & dictLanguage("GLOBAL-ERRLOCK") & "<BR>"
        end if
      end if


      if dBBSLastMaintenance < dateadd("D", -1, now) then
        ' Time to run daily maintenance
        RunMaintenance
      end if

      ' A good place to put the "Who is online" hook
      if dictconfiguration.item("bDISABLEONLINETRACKING") = 0 then
    if sBBSUsername <> "12345678901234567890logoff" and dictEnvironment("C-IMPERSONATION-ACTIVE") = 0 then

      if (iBBSLogonType = US_Registered) then

      if len(iBBSGuestID) = 0 then
        updateLocation sBBSUsername, sBBScurrentURLPath, request.servervariables("REMOTE_ADDR"), 1
      else
        ' The user still has an old guest ID!
        DeleteUserFromLocation ("Guest " & iBBSGuestID)
        response.cookies(sBBSCookieRoot & "guestID") = ""
        response.cookies(sBBSCookieRoot & "guestID").path = "/"
        updateLocation sBBSUsername, sBBScurrentURLPath, request.servervariables("REMOTE_ADDR"), 1

      end if

      elseif len(iBBSGuestID) <> 0 then
      updateLocation "Guest " & iBBSGuestID, sBBScurrentURLPath, request.servervariables("REMOTE_ADDR"), 0

      else
      ' This is the guest's sessions first visit
      Randomize
      response.cookies(sBBSCookieRoot & "guestID") = int( 1000 * rnd + 1 )
      response.cookies(sBBSCookieRoot & "guestID").path = "/"
      end if

    end if

      end if

      if dictConfiguration.item("sSOFTWAREVERSION")<> "2.2" then
        if instr(request.Servervariables("PATH_INFO"), "bbs-setup.asp") = 0 and instr(request.Servervariables("PATH_INFO"), "retrieve-scheme.asp") = 0 then
          dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & dictLanguage("GLOBAL-ERRVER1") & " " & dictConfiguration.item("sSOFTWAREVERSION") & " : " & dictLanguage("GLOBAL-ERRVER2") & "<br/><br/>"
        end if
      end if

      if bEmergencyMode = 1 then
        if instr(request.Servervariables("PATH_INFO"), "bbs-setup.asp") = 0 and instr(request.Servervariables("PATH_INFO"), "retrieve-scheme.asp") = 0 then
          dictEnvironment("V-ERRORS") = dictEnvironment("V-ERRORS") & dictLanguage("GLOBAL-ERREMGC") & "<br/>"
        end if
      end if

    else
      ' Database connection not established
      sBBSUsername = ""
      sBBSPassword = ""
    end if

    ' Set the time offset
    if iBBSLogonType = US_Registered then
      vUserInfo = GetUserInfobyID(iBBSMemberID)
      iBBSTimeOffset = vUserInfo(UI_TimeOffset)
      vIgnoreList    = split(vUserInfo(UI_IgnoreList), ",")
    else
      iBBSTimeOffset = 0
    end if

    ' Set the default value for the

    dictEnvironment("V-LOCATIONLINKS") = "<a href='" & sBBSForumRoot & "/category-view.asp'>" & BBS.ValidateField(dictConfiguration("sBBSNAME")) & "</a>"
  end Sub

  sub GetBBSConfigVariables
    ' DESCRIPTION : Retrieves the list of BBS configuration values from the database and stores them in the dictConfiguration object
    dim vConfigArray, index, iUpperBound, SQL

    ' Check if the config array is cached in the application cache
    ' (this is one of the few times we bypass the caching API)
    vConfigArray = application.contents(sBBSCachePrefix & "CONFIGURATION")
    if IsEmpty(vConfigArray) then
      SQL = "select configname, configvalue from bbsconfiguration;"
      rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
      AddQuery(SQL)
      if not(rsMaster.EOF) then vConfigArray = rsMaster.GetRows
      BBS.CacheAdd "CONFIGURATION", vConfigArray
      rsMaster.Close
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    if isArray(vConfigArray) then
      iUpperBound = UBOUND(vConfigArray, 2)
      for index=0 to iUpperBound
        dictConfiguration(vConfigArray(0, index)) = vConfigArray(1, index)
      next
    end if
  end sub

  sub GetGlobalVariables()
    ' DESCRIPTION : Calculates global variables relating to the user's experience, such as color scheme and time offset

    dim vUserInfo, index, SQL

    ' Part 2 : Get emoticons array
    vBBSEmoticonsArray = BBS.Cache("EMOTICONS")
    if IsEmpty(vBBSEmoticonsArray) then

      if ucase(sBBSDatabaseType) = "MSACCESS" or ucase(sBBSDatabaseType) = "MSSQL" then
        SQL = "select source, emoticonimage from emoticons order by len(source) desc"
      elseif ucase(sBBSDatabaseType) = "MYSQL" then
        SQL = "select source, emoticonimage from emoticons order by CHAR_LENGTH(source) desc"
      end if

      rsMaster.open SQL, dbconnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.EOF then
        vBBSEmoticonsArray = rsMaster.GetRows
      else
        vBBSEmoticonsArray = -1
      end if
      rsMaster.Close
      BBS.CacheAdd "EMOTICONS", vBBSEmoticonsArray
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Part 3 : Get MBBSCode array
    vBBSDecodeArray = BBS.Cache("MBBSCODES")
    if IsEmpty(vBBSDecodeArray) then
      SQL = "select code, html, closecode, closehtml from mbbscode"
      rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.EOF then
        vBBSDecodeArray = rsMaster.GetRows
      else
        vBBSDecodeArray = -1
      end if
      rsMaster.Close
      BBS.CacheAdd "MBBSCODES", vBBSDecodeArray
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Part 4 : Get ranks array
    vBBSRankArray = BBS.Cache("CUSTOMRANKS")
    if IsEmpty(vBBSRankArray) then
      SQL = "select minposts, mindays, rankname from customranks order by minposts ASC"
      rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.EOF then
        vBBSRankArray = rsMaster.GetRows
      else
        vBBSRankArray = -1
      end if
      rsMaster.Close
      BBS.CacheAdd "CUSTOMRANKS", vBBSRankArray
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Part 6 : Get the decorations array
    vBBSDecorationArray = BBS.Cache("DECORATIONS")
    if IsEmpty(vBBSDecorationArray ) then
      sql = "select posts, imagename from decorations order by posts desc"
      rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.eof then
        vBBSDecorationArray = rsMaster.GetRows
      else
        vBBSDecorationArray = -1
      end if
      rsMaster.Close
      BBS.CacheAdd "DECORATIONS", vBBSDecorationArray
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Part 7 : Get the bad word array
    vBBSBadWordFilter = BBS.Cache("FILTEREDWORDS")
    if IsEmpty(vBBSBadWordFilter) then
      SQL = "select word, replacement from filteredwords"
      rsMaster.open SQL , dbConnection, adOpenFOrwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.EOF then
        vBBSBadWordFilter = rsMaster.GetRows
      else
        vBBSBadWordFilter = -1
      end if
      rsMaster.Close
      BBS.CacheAdd "FILTEREDWORDS", vBBSBadWordFilter
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

    ' Part 8 : Configure the language <--- redundant now, actually :) language is set in the SetupDatabase sub

    ' Part 9 : Get the banned IP list
    vBannedIPs = BBS.Cache("BANNEDIPS")
    if IsEmpty(vBannedIPs) then
      SQL = "select ip from bannedips"
      rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsMaster.EOF then
        vBannedIPs = rsMaster.GetRows
      else
        vBannedIPs = -1
      end if
      rsMaster.close
      BBS.CacheAdd "BANNEDIPS", vBannedIPs
    else
      iBBSCachedHits = iBBSCachedHits + 1
    end if

  end sub

  function SetScheme(byref iSchemeCategoryID)
    ' DESCRIPTION : Attempts to set the scheme
    ' INPUTS      : iSchemeCategoryID - The category the user is presently in - '0' if not applicable
    ' RETURNS     : The actual scheme that was set

    dim rsScheme, sStyleID, iCategoryID, vCategoryInfo, SQL, vUserInfo
    set rsScheme = server.createobject("ADODB.Recordset")

    sBBSOriginalRoot = sBBSForumRoot & "/templates/original"

    ' Determine the default root
    SQL = "select schemeid, schemepath from schemes where isdefault=1"
    rsScheme.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)
    if not rsScheme.EOF then
      sBBSDefaultRoot = sBBSForumRoot & "/templates" & rsScheme.fields(1).value
    else
      sBBSDefaultRoot = sBBSForumRoot & "/templates/original"
    end if
    rsScheme.Close

    ' ===================================================================
    ' Part 1 : Determine the active scheme ID (harder than it might seem)
    ' ===================================================================

    sStyleID = 0

    ' ===================================================================
    ' A catlock is passed to the page via either a querystring or a cookie
    ' This is set when viewing a page in a locked category, and it applies
    ' to the duration of the user's visit, unless they choose to break out
    '
    ' A categoryID is passed to the function when the user is viewing
    ' a forum/calendar/album/etc that resides inside a BBS category
    '
    ' The catlock or iSchemeCategoryID is checked to see if they force a scheme.
    ' If they are, then this overrides any preference the user might have
    ' chosen
    '
    ' A schemeID of 0 means to use the BBS default scheme, or the user's preference,
    ' or the user's cookie.
    '
    ' Anything else should be a valid category ID
    '
    ' It's very confusing, I know, and I feel sorry that you are going
    ' to attempt to read this
    '
    ' ===================================================================

    ' ==========================================
    ' A category/catlock was specified, attempt
    ' to apply any forced schemes
    ' ==========================================

    if (iBBSCatLock) > 0 or iSchemeCategoryID > 0 then

      ' Checked in order of precidence
      if BBS.ValidateNumeric(iBBSCatLock) > 0 then
         iCategoryID = iBBSCatLock
      else
         iCategoryID = iSchemeCategoryID
      end if

      vCategoryInfo = GetCategoryInfo(iCategoryID)

      ' If the category isn't set to force a scheme, use the user's scheme
      if dictConfiguration.item("bENABLETEMPLATES")= 1 and vCategoryInfo(CA_SchemeDefault) = 0 then

        ' Retrieve the user's default scheme
        if iBBSLogonType = US_Registered then
          ' Lookup the user's color scheme (overrides a category lock if set to anything other than default)
          vUserInfo = GetUserInfobyID(iBBSMemberID)
          if vUserInfo(UI_TemplateID) <> 0 then sBBSStyleID = vUserInfo(UI_TemplateID)

        else
          ' Not logged in, check for a cookie
          sBBSStyleID = ValidateNumeric(request.cookies(sBBSCookieRoot & "schemeid"))

        end if

      ' The category is forcing a scheme, use it.
      elseif vCategoryInfo(CA_SchemeDefault) > 0 then
        sBBSStyleID = vCategoryInfo(CA_SchemeDefault)
      end if

    ' ==========================================
    ' A category/catlock was NOT specified
    ' Apply the user's scheme
    ' ==========================================

    else
      if dictConfiguration.item("bENABLETEMPLATES")= 1 then

        if iBBSLogonType = US_Registered then
          ' Lookup the user's color scheme
          vUserInfo = GetUserInfobyID(iBBSMemberID)
          sBBSStyleID = vUserInfo(UI_TemplateID)

        else
          ' Not logged in, check for a cookie
          sBBSStyleID = ValidateNumeric(request.cookies(sBBSCookieRoot & "schemeid"))
        end if

      else
        sBBSStyleID = 0
      end if

    end if

    ' =================================================================
    ' Part 2a : Check if the non-bbs default scheme exists, if it does,
    '         : use it's path for the template variables
    ' =================================================================
    '
    if sBBSStyleID <> 0 then
       SQL = "select schemeid, schemepath from schemes where schemeid=" & sBBSStyleID
       rsScheme.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
       AddQuery(SQL)
       if rsScheme.EOF then
         sBBSStyleID = 0
       else
         sBBSTemplateRoot = sBBSForumRoot & "/templates" & rsScheme.fields(1).value
         sBBSTemplateImagesRoot = sBBSTemplateRoot & "/images/common"
       end if
       rsScheme.Close
    end if

    ' =======================================================================
    ' Part 2b : If the scheme specified didn't exist, or we're set to
    '         : use the default scheme, then look up the BBS's default scheme
    ' =======================================================================
    '
    if sBBSStyleID = 0 then
      SQL = "select schemeid, schemepath from schemes where isdefault=1"
      rsScheme.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if len(sBBSDefaultroot) = 0 then
        sBBSTemplateRoot = sBBSOriginalRoot
        sBBSTemplateImagesRoot = sBBSOriginalRoot & "/images/common"
        sBBSStyleID = 0
      else
        if Filesystem.FolderExists(server.mappath(sBBSDefaultroot)) then
          sBBSTemplateRoot = sBBSDefaultroot
          sBBSTemplateImagesRoot = sBBSDefaultroot & "/images/common"
          if rsScheme.EOF then
            sBBSStyleID = 0
          else
            sBBSStyleID = rsScheme.fields(0).value
          end if
        else
          sBBSTemplateRoot = sBBSOriginalRoot
          sBBSTemplateImagesRoot = sBBSOriginalRoot & "/images/common"
          sBBSStyleID = 0
        end if
      end if
      rsScheme.Close
    end if

    'response.write "Default: " & sbbsdefaultroot & "<br/>"
    'response.write "Original: " & sbbsoriginalroot & "<br/>"
    'response.write "Active: " & sBBSTemplateRoot & "<br/>"

    ' =======================================================================
    ' Part 3 : Execute the template configurator thingy.
    ' =======================================================================
    '

    Filesystem.ExecuteTemplateConfig

  end function

  Function ValidateSQL(byref sSQLstring)
   ' DESCRIPTION: Properly formats a string for use in an SQL statement. Preserves value
   if isNull(sSQLString) then
     ValidateSQL = ""
   else
     ValidateSQL = trim(sSQLstring)
     if ucase(sBBSDatabaseType) = "MYSQL" then
       ValidateSQL = replace(ValidateSQL, "\", "\\")
       'ValidateSQL = replace(ValidateSQL, "_", "\_")
     end if
     ValidateSQL = replace(ValidateSQL, "'", "''")
   end if
  end function

  function FilterView(byref sString)
    ' DESCRIPTION : Conditionally filters a string
    if dictConfiguration("bBADWORDFILTERONDISPLAY") = 1 then
      FilterView = FilterWords(sString)
    else
      FilterView = sString
    end if
  end function

  function FilterPost(byref sString)
    ' DESCRIPTION : Conditionally filters a string
    if dictConfiguration("bBADWORDFILTERONDISPLAY") = 0 then
      FilterPost= FilterWords(sString)
    else
      FilterPost= sString
    end if
  end function

  function ValidateRegEX(byref sRegEx)
    ' DESCRIPTION : Escapes a string for use in a regex string
    if isNull(sRegEx) then
      ValidateRegEX = ""
    else
      if ucase(sBBSDatabaseType) = "MYSQL" then
        ValidateRegEX = replace(sRegEx, "\", "\\")
        ValidateRegEX = replace(ValidateRegEX , "*", "\\*")
        ValidateRegEX = replace(ValidateRegEX , "?", "\\?")
        ValidateRegEX = replace(ValidateRegEX , ".", "\\.")
        ValidateRegEX = replace(ValidateRegEX , ",", "\\,")
        ValidateRegEX = replace(ValidateRegEX , "~", "\\~")
        ValidateRegEX = replace(ValidateRegEX , "^", "\\^")
        ValidateRegEX = replace(ValidateRegEX , "#", "\\#")
        ValidateRegEX = replace(ValidateRegEX , "", "\\")
        ValidateRegEX = replace(ValidateRegEX , ">", "\\>")
        ValidateRegEX = replace(ValidateRegEX , "@", "\\@")
        ValidateRegEX = replace(ValidateRegEX , "|", "\\|")
        ValidateRegEX = replace(ValidateRegEX , ";", "\\;")
        ValidateRegEX = replace(ValidateRegEX , "[", "\\[")
        ValidateRegEX = replace(ValidateRegEX , "]", "\\]")
        ValidateRegEX = replace(ValidateRegEX , "{", "\\{")
        ValidateRegEX = replace(ValidateRegEX , "}", "\\}")
        ValidateRegEX = replace(ValidateRegEX , "(", "\\(")
        ValidateRegEX = replace(ValidateRegEX , ")", "\\)")
      else
        ValidateRegEX = replace(sRegEx, "\", "\\")
        ValidateRegEX = replace(ValidateRegEX , "*", "\*")
        ValidateRegEX = replace(ValidateRegEX , "?", "\?")
        ValidateRegEX = replace(ValidateRegEX , ".", "\.")
        ValidateRegEX = replace(ValidateRegEX , ",", "\,")
        ValidateRegEX = replace(ValidateRegEX , "~", "\~")
        ValidateRegEX = replace(ValidateRegEX , "^", "\^")
        ValidateRegEX = replace(ValidateRegEX , "#", "\#")
        ValidateRegEX = replace(ValidateRegEX , "", "\")
        ValidateRegEX = replace(ValidateRegEX , ">", "\>")
        ValidateRegEX = replace(ValidateRegEX , "@", "\@")
        ValidateRegEX = replace(ValidateRegEX , "|", "\|")
        ValidateRegEX = replace(ValidateRegEX , ";", "\;")
        ValidateRegEX = replace(ValidateRegEX , "[", "\[")
        ValidateRegEX = replace(ValidateRegEX , "]", "\]")
        ValidateRegEX = replace(ValidateRegEX , "{", "\{")
        ValidateRegEX = replace(ValidateRegEX , "}", "\}")
        ValidateRegEX = replace(ValidateRegEX , "(", "\(")
        ValidateRegEX = replace(ValidateRegEX , ")", "\)")
      end if
    end if
  end function

  function UnValidateRegEX(byref sRegEX)
    ' DESCRIPTION : Reverses the process of ValidateRegEX-- probably so you can display it as HTML
    if isNull(sRegEx) then
      UnValidateRegEX = ""
    else
      UnValidateRegEX= replace(sRegEx, "\\", "\")
      UnValidateRegEX= replace(UnValidateRegEX, "\*", "*")
      UnValidateRegEX= replace(UnValidateRegEX, "\?", "?")
      UnValidateRegEX= replace(UnValidateRegEX, "\.", ".")
      UnValidateRegEX= replace(UnValidateRegEX, "\,", ",")
      UnValidateRegEX= replace(UnValidateRegEX, "\~", "~")
      UnValidateRegEX= replace(UnValidateRegEX, "\^", "^")
      UnValidateRegEX= replace(UnValidateRegEX, "\#", "#")
      UnValidateRegEX= replace(UnValidateRegEX, "\", "")
      UnValidateRegEX= replace(UnValidateRegEX, "\>", ">")
      UnValidateRegEX= replace(UnValidateRegEX, "\@", "@")
      UnValidateRegEX= replace(UnValidateRegEX, "\|", "|")
      UnValidateRegEX= replace(UnValidateRegEX, "\;", ";")
      UnValidateRegEX= replace(UnValidateRegEX, "\[", "[")
      UnValidateRegEX= replace(UnValidateRegEX, "\]", "]")
      UnValidateRegEX= replace(UnValidateRegEX, "\{", "{")
      UnValidateRegEX= replace(UnValidateRegEX, "\}", "}")
      UnValidateRegEX= replace(UnValidateRegEX, "\(", "(")
      UnValidateRegEX= replace(UnValidateRegEX, "\)", ")")
    end if
  end function

  function SQLTrim(byref sSQLString, byref iLength)
   ' DESCRIPTION: Properly formats a string for use in an SQL statement. Preserves value
   if isNull(sSQLString) then
     SQLTrim= ""
   else
     SQLTrim= left(trim(sSQLString), iLength)
     SQLTrim= replace(SQLTrim, "'", "''")
   end if
  end function

  Function ValidateJavascript(byref sFieldText)
    ' DESCRIPTION : Escapes quotes and apostrophes for javascript
    ' INPUTS      : A piece of text which will be sent to the browser
    ' RETURNS     : Javascrript escaped text

    if IsNull(sFieldText) then sFieldText = ""
    ValidateJavascript = Replace (sFieldText, "\", "\\")
    ValidateJavascript = Replace (ValidateJavascript, "'", "\'")
    ValidateJavascript = Replace (ValidateJavascript, """", "\""")
  End Function

  function StripHTML(byref sHTML)
    ' DESCRIPTION : Removes HTML tags from content, preserves line breaks
    ' INPUTS      :
    dim sResult
    sResult = sHTML & ""
    sResult = replace(sResult, "<br>", CRLF)
    sResult = replace(sResult, "<br />", CRLF)
    sResult = replace(sResult, "&nbsp;", " ")
    sResult = replace(sResult, "<p", CRLF & "<p")

    mBBSREgEx.IgnoreCase = True
    mBBSREgEx.Global = True
    mBBSREgEx.Pattern = "<[^>]*>"
    sResult = mBBSREgEx.Replace(sResult, "")

    StripHTML = sResult
  end function

  Function ValidateField(byref sFieldText)
    ' DESCRIPTION : Escapes out HTML-unsafe characters
    ' INPUTS      : A piece of text which will be sent to the browser
    ' RETURNS     : HTML escaped text

    if IsNull(sFieldText) then sFieldText = ""
    ValidateField = Replace (sFieldText, "'", "&#39;")
    ValidateField = Replace (ValidateField, """", "&quot;")
    ValidateField = Replace (ValidateField, "<", "&lt;")
    ValidateField = Replace (ValidateField, ">", "&gt;")
    'ValidateField = Replace (ValidateField, ")", "&#41;")
    'ValidateField = Replace (ValidateField, "(", "&#40;")
    ValidateField = Replace (ValidateField, "+", "&#43;")
  End Function

  Function HTMLEncodeDec(byref sFieldText)
    ' DESCRIPTION : Encodes a piece of text for HTML output using decimal HTML encoding
    ' INPUTS      : A piece of text to encode
    ' RETURNS     : Encoded text
    ' NOTES       : Probably only handles low unicode characters (< 255) properly

    dim vOutputArray(), index, iLength

    iLength = len(sFieldText)
    redim vOutputArray(iLength)

    for index=1 to iLength
      vOutputArray(index) = "&#" & asc(mid(sFieldText, index, 1)) & ";"
    next

    HTMLEncodeDec = Join(vOutputArray, "")

  End Function


  Function ValidateURL(byval sString)
   ' DESCRIPTION: Properly formats a string for use in a URL
   if isNull(sString) then sString = ""
   sString = trim(sString)
   ValidateURL = server.urlencode(sString)
  end Function

  function ValidateBoolean(byval bBoolean)
    ' DESCRIPTION: If bBoolean is True or 1 then 1 is returned, otherwise zero is returned.
    on error resume next
    Validateboolean = 0
    if bBoolean = 0 or bBoolean = False  or IsEmpty(bBoolean) or IsNull(bBoolean) then
      ValidateBoolean = 0
    else
      ValidateBoolean = 1
    end if
    on error goto 0
  end function

  Function BooleanNot(byval bBoolean)
    ' DESCRIPTION: Toggles (1 <-> 0)

    if bBoolean = 1 then
      BooleanNot = 0
    else
      BooleanNot = 1
    end if
  end function

  function ValidateNumeric(byval iInteger)
    ' DESCRIPTION: If iInteger is numeric, then it is just returned.  Otherwise, a zero is returned.
    on error resume next
    ValidateNumeric = 0
    if not(isnumeric(iInteger)) or isEmpty(iInteger) then
      ValidateNumeric = 0
    else
      ValidateNumeric = clng(iInteger)
    end if
    on error goto 0
  end function

  function ValidateDecimal(byval nDecimal)
    ' DESCRIPTION: If iInteger is numeric, then it is just returned.  Otherwise, a zero is returned.
    on error resume next
    ValidateDecimal = 0
    if not(isnumeric(nDecimal)) or isEmpty(nDecimal) then
      ValidateDecimal = 0
    else
      ValidateDecimal = cdbl(nDecimal)
    end if
    on error goto 0
  end function

  function Maximum(byref iInt1, byref iInt2)
    ' DESCRIPTION : Determines the maximum of two numbers
    ' INPUTS      : Two numbers
    ' RETURNS     : The maximum of the two.

    if ValidateNumeric(iInt1) > ValidateNumeric(iInt2) then
      Maximum = ValidateNumeric(iInt1)
    else
      Maximum = ValidateNumeric(iInt2)
    end if
  end function

  function Minimum(byref iInt1, byref iInt2)
    ' DESCRIPTION : Determines the minimum of two numbers
    ' INPUTS      : Two numbers
    ' RETURNS     : The minimum of the two.

    if ValidateNumeric(iInt1) < ValidateNumeric(iInt2) then
      Minimum = ValidateNumeric(iInt1)
    else
      Minimum = ValidateNumeric(iInt2)
    end if
  end function

  sub Swap(byref iObj1, byref iObj2)
    ' DESCRIPTION : Swaps the two values
    dim objTemp
    objTemp = iObj1
    iObj1 = iObj2
    iObj2 = objTemp
  end sub

  Function IsBlank(byval sString)
    ' DESCRIPTION : If a string is blank or null then TRUE is returned, otherwise FALSE is returned

    if isNull(sString) or len(sString)=0 then
      IsBlank = True
    else
      IsBlank = False
    end if
  end Function

  public Function IsValidReferer()
    dim sLocalDomain, sReferer

    sReferer = lcase(sBBSReferer)
    sLocalDomain = lcase(Request.ServerVariables("SERVER_NAME"))

    ' Strip out the "www." if it exists
    if left(sLocalDomain, 4) = "www." then
      sLocalDomain = mid(sLocalDomain, 5)
    end if

    ' Some browsers do not supply a referer, so allow them through anyway
    if len(trim(sReferer)) = 0 or instr(sReferer, sLocalDomain) > 0 then
      IsValidReferer = True
    else
      IsValidReferer = False
    end if

  end function

  Function ValidateBlank(byval sString)
    ' DESCRIPTION : Checks for null values in strings.  Returns a 0 length string instead.
    on error resume next
    if isNull(sString) or len(sString)=0 then
      ValidateBlank = ""
    elseif IsEmpty(sString) then
      ValidateBlank = ""
    else
      ValidateBlank = sString
    end if
   on error goto 0
   End Function

Function NiceNumber(byval uglynumber)
    ' Return a number that is usually nicely rounded to three decimal places.
    ' Handles null values, floating point numbers, integers, and zeros.

    dim sDecimalMarker, sTestNumber

    sTestNumber = 10 / 3
    sDecimalMarker = mid(sTestNumber, 2, 1)
    if isnull(uglyNumber) then uglynumber=0
    uglynumber = CStr(Round(uglynumber, 4))

    If uglynumber = 0 Then
        uglynumber = "0" & sDecimalMarker & "000"
    ElseIf InStr(uglynumber, sDecimalMarker) = 0 Then
        uglynumber = uglynumber & sDecimalMarker & "000"
    ElseIf InStr(uglynumber, sDecimalMarker) = Len(uglynumber) - 1 Then
        uglynumber = uglynumber & "0"
    end if

    if len(uglynumber) = 6 then uglynumber=left(uglynumber, 5)
    NiceNumber = uglynumber

End Function



function ParsePhone(byval sTelephoneNumber)

dim sResult, i, tempChar

  ' Description : Attempts to return a 'pure' phone number, stripping out extra characters
  ' Inputs      : A string representing a telephone number
  ' Returns     : A telephone number stripped of extra characters

  if isnull(sTelephoneNumber) then sTelephoneNumber = ""

  for i = 1 to len(sTelephoneNumber)
     tempChar = mid(sTelephoneNumber, i, 1)
     if IsNumeric(tempChar) then sResult = sResult & tempChar
  next

  ' If the telephone number so far is xxx-xxx-xxxx, then append a '1' in front of it
  if len(sResult) = 10 then
     sResult = "1" & sResult
  end if

  ParsePhone = sResult

end function

Function IsValidEmail(sEmail)
' Description : Attempts to determine if an e-mail address is valid
' Inputs      : An e-mail address
' Returns     : TRUE or FALSE, based on whether the function thinks the address might be valid

  Dim regEx, retVal
  Set regEx = New RegExp

  ' Set pattern
  regEx.Pattern ="^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$"
  regEx.IgnoreCase = true

  ' Set case sensitivity.
  IsValidEmail = regEx.Test(sEmail)

end Function

  Function Weekdays(byval MyDay)

    ' Description : Select a string representing the day of the week
    ' Inputs      : An integer from 1 to 7, representing the day of the week
    ' Returns     : The name of the day of the week

    if isnull(Myday) then Myday = 1

    Select Case MyDay
      Case 1
        Weekdays = dictLanguage("GLOBAL-SUNDAY")
      Case 2
        Weekdays = dictLanguage("GLOBAL-MONDAY")
      Case 3
        Weekdays = dictLanguage("GLOBAL-TUESDAY")
      Case 4
        Weekdays = dictLanguage("GLOBAL-WEDNESDAY")
      Case 5
        Weekdays = dictLanguage("GLOBAL-THURSDAY")
      Case 6
        Weekdays = dictLanguage("GLOBAL-FRIDAY")
      Case 7
        Weekdays = dictLanguage("GLOBAL-SATURDAY")
    End Select
  End Function

  Function Months(byval MyMonth)
    ' DESCRIPTION: Select a string representing the month

    if isnull(MyMonth) then MyMonth = 1

    Select Case MyMonth
      Case 1
        Months = dictLanguage("GLOBAL-JAN")
      Case 2
        Months = dictLanguage("GLOBAL-FEB")
      Case 3
        Months = dictLanguage("GLOBAL-MAR")
      Case 4
        Months = dictLanguage("GLOBAL-APR")
      Case 5
        Months = dictLanguage("GLOBAL-MAY")
      Case 6
        Months = dictLanguage("GLOBAL-JUN")
      Case 7
        Months = dictLanguage("GLOBAL-JUL")
      Case 8
        Months = dictLanguage("GLOBAL-AUG")
      Case 9
        Months = dictLanguage("GLOBAL-SEP")
      Case 10
        Months = dictLanguage("GLOBAL-OCT")
      Case 11
        Months = dictLanguage("GLOBAL-NOV")
      Case 12
        Months = dictLanguage("GLOBAL-DEC")
    End Select
  End Function

  Function GetDateFormat(byref sDateFormat)
    ' DESCRIPTION : Returns the date format used during manually entering dates.
    ' NOTES       : All manually entered dates should be run through ParseDate() first

    if ucase(sDateFormat) = "ISO" then
      GetDateFormat = "yyyy-mm-dd"
    elseif ucase(sDateFormat) = "US" then
      GetDateFormat = "mm/dd/yyyy"
    elseif ucase(sDateFormat) = "EUR" then
      GetDateFormat = "dd/mm/yyyy"
    end if
  end function

  Function GetCalendarDateFormat()
    ' DESCRIPTION: Returns the appropriate date format for the JS Calendar

    GetCalendarDateFormat = GetDateFormat(dictConfiguration("sDATEFORMAT"))
    GetCalendarDateFormat = replace(GetCalendarDateFormat, "yyyy", "%Y")
    GetCalendarDateFormat = replace(GetCalendarDateFormat, "mm", "%m")
    GetCalendarDateFormat = replace(GetCalendarDateFormat, "dd", "%d")
  end function

  function ParseDate(byref sDateString, byref sDateFormat)
  ' DESCRIPTION : Some servers do not correctly cast strings to date values.
  '             : This function will take over the role of vbscript's cdate()
  '             : and cast a string to a date value
  ' INPUTS      : sDateString - A simple short-form string date
  '             : sDateFormat - The expected locale of the input string
  ' RETURNS     : A DATE, not a string representing a date
  '             : Returns false if the function was unsucsessful
  ' NOTES       : Always run manually typed dates through ParseDate() first
  '             : even if it doesn't appear to be neccessary.
  '             : It becomes useful on non-us locale based servers

  dim fields

  sDateString = replace (sDateString, "-", "/")
  sDateString = replace (sDateString, ".", "/")
  fields = split(sDateString, "/")

  if ubound(fields) < 2 then
    ' Not a date
    ParseDate = ""
    exit function
  elseif not(isNumeric(fields(0))) or not(isNumeric(fields(1))) or not(isNumeric(fields(2))) then
    ParseDate = ""
    Exit function
  end if

  if ucase(sDateFormat) = "EUR" then
    parsedate = dateserial(fields(2), fields (1), fields(0))
  elseif ucase(sDateFormat) = "US" then
    parsedate = dateserial(fields(2), fields (0), fields(1))
  elseif ucase(sDateFormat) = "ISO" then
    parsedate = dateserial(fields(0), fields(1), fields(2))
  end if

  end function

Function GetShortDate(byval dTime)
    dim iTimeOffset

    if not(isDate(dTime)) then
       GetShortDate = ""
       exit function
    end if


    if dictConfiguration("sDATEFORMAT") = "US" then
       GetShortDate = month(dTime) & "/" & day(dTime) & "/" & year(dTime)
    elseif dictConfiguration("sDATEFORMAT") = "EUR" then
       GetShortDate = day(dTime) & "/" & month(dTime) & "/" & year(dTime)
    else
       GetShortDate = year(dTime) & "-" & Right(Cstr(month(dTime) + 100),2) & "-" & Right(Cstr(day(dTime) + 100),2)
    end if

End Function

Function FormatShortDate(byval dTime, byval sFormat)
    if not(isDate(dTime)) then
       GetShortDate = ""
       exit function
    end if

    if ucase(sFormat) = "US" then
       FormatShortDate = month(dTime) & "/" & day(dTime) & "/" & year(dTime)
    elseif ucase(sFormat) = "EUR" then
       FormatShortDate = day(dTime) & "/" & month(dTime) & "/" & year(dTime)
    else
       FormatShortDate = year(dTime) & "-" & Right(Cstr(month(dTime) + 100),2) & "-" & Right(Cstr(day(dTime) + 100),2)
    end if
end function

Function GetSQLDate(byref dTime)

   ' Description : SQL statements require dates to be in yyyy-mm-dd format

   if not(isDate(dTime)) then
      GetSQLDate = ""
      exit function
   end if
   dim sMonth
   dim sYear
   dim sday
   sMonth = month(dTime)
   sYear = year(dTime)
   sDay = day(dTime)
   if sMonth <= 9 then sMonth = "0" & sMonth
   if sYear <= 9 then sYear = "0" & sYear
   if sDay <= 9 then sYear = "0" & sDay

   if ucase(sBBSSQLFormat) = "US" then
     GetSQLDate = month(dTime) & "/" & day(dtime) & "/" & year(dTime)
   elseif ucase(sBBSSQLFormat) = "EUR" then
     GetSQLDate = day(dTime) & "/" & month(dtime) & "/" & year(dTime)
   else
     GetSQLDate = year(dTime) & "-" & month(dTime) & "-" & day(dTime)
   end if
End Function

function GetSQLTime(byref dTime)
  if not(IsDate(dTime)) then
    GetSQLTime = ""
    Exit function
  end if

  dim iHour, iMinute, iSecond
  iHour = hour(dTime)
  iMinute = minute(dtime)
  iSecond = second(dTime)

  if iHour <= 9 then iHour = "0" & iHour
  if iMinute <= 9 then iMinute = "0" & iMinute
  if iSecond <= 9 then iSecond = "0" & isecond

  GetSQLTime = iHour & ":" & iMinute & ":" & iSecond
end function

Function GetSQLDateTime(byref dTime)

   ' Description : SQL statements require dates to be in yyyy-mm-dd format

   if not(isDate(dTime)) then
      GetSQLDateTime = ""
      exit function
   end if

   GetSQLDateTime = GetSQLDate(dTime) & " " & GetSQLTime(dTime)

End Function

Function GetShortTime(byref dTime)

    if not(isDate(dTime)) then
       GetShortTime = ""
       exit function
    end if

    dim sMeridiem, sMinutes, iHour
    ihour    = hour(dTime)
    sMinutes = minute(dTime)

    if dictConfiguration("sTIMEFORMAT") = "24" then

      if len(iHour) = 1 then iHour = "0" & iHour
      if len(sMinutes) = 1 then sMinutes = "0" & sMinutes
      GetShortTime = (iHour) & ":" & sMinutes


    else
      if iHour >= 12 then
         sMeridiem = "PM"
      else
         sMeridiem = "AM"
      end if
      if sMinutes < 10 then sMinutes = "0" & sMinutes
      iHour = (iHour mod 12)
      if iHour = 0 then iHour = 12
      GetShortTime = (iHour) & ":" & sMinutes & " " & sMeridiem
    end if
End Function

Function GetShortDateTime(byval dTime)

    dim dOffsetDate
    if not(isDate(dTime)) then
       GetShortDateTime = ""
       exit function
    end if

    dOffsetDate = datevalue(dTime) + TimeSerial((hour(dTime) + iBBSTimeOffset) , minute(dTime), 0)
    GetShortDateTime = GetShortDate(dOffsetDate) & "  " & getShortTime(dOffsetDate)

end FUnction


  Function GetNumberExtension(byval iNumber)
    ' DESCRIPTION : Given an integer, return a character string used to write the number's "suffix"
    dim sNumber, sLastDigit, sResult

    sNumber = cstr(ValidateNumeric(iNumber))
    sLastDigit = right(sNumber, 1)

    select case sLastDigit
      Case "1"
       sResult = dictLanguage("GLOBAL-FIRST")
      Case "2"
       sResult = dictLanguage("GLOBAL-SECOND")
      Case "3"
       sResult = dictLanguage("GLOBAL-THIRD")
      Case Else
       sResult = dictLanguage("GLOBAL-FOURTH")
    End Select

    ' Override result for teens
    if sNumber = "11" or sNumber="12" or sNumber="13" then sResult = dictLanguage("GLOBAL-FOURTH")
    GetNumberExtension = sResult
  end Function

function Highlight(ByRef sText, ByRef sHighlight, ByRef iMode)
  ' DESCRIPTION : Highlights words or a phrase in a piece of text.
  ' INPUT       : sText - the text to highlight in
  '             : sHighlight - the words (separated by spaces) or a phrase to highlight
  '             : iMode - 1 = highlight individual words, 2 = highlight phrase
  ' RETURNS     : Formatted text. Words/phrase surrounded by <span class='highlight'>...</span>

  iMode = BBS.ValidateNumeric(iMode)
  sHighlight = trim(sHighlight)

  if len(sHighlight) = 0 then
    Highlight = sText
    exit function
  end if

  ' Pattern for replacement
  if iMode = 2 then
    mbbsRegEx.pattern = "(^|\>)([^\<]*?)(" & ValidateRegEx(sHighlight) & ")"
  else
    mbbsRegEx.pattern = "(^|\>)([^\<]*?)(" & replace(ValidateRegEx(sHighlight), " ", "|") & ")"
  end if

  ' Do the highlighting
  mbbsRegEx.global = true
  mbbsRegEx.ignorecase = true
  Highlight = mbbsRegEx.replace(sText, "$1$2<span class='highlight'>$3</span>")
end function

function spc(iCount)
  ' DESCRIPTION : Returns a specified number of spaces

  for i = 1 to iCount
    sReturn = sReturn & " "
  next
  spc = sReturn

end function

function HexToDec(sChar)
' Description: Converts a hexadecimal character into a decimal value
  dim iResult, uChar

  if isnumeric(sChar) then
     iResult = int(sChar)
  else
     uChar = ucase(sChar)
     select case uChar
        Case "A"
           iResult = 10
        Case "B"
           iResult = 11
        Case "C"
           iResult = 12
        Case "D"
           iResult = 13
        Case "E"
           iResult = 14
        Case "F"
           iResult = 15
     end select
  end if
  HexToDec = iResult
end function

  function IsChecked (byval bChecked)
    ' DESCRIPTION : Returns the string " checked " if bChecked is True or "1"
    if ValidateBoolean(bChecked) = 1 then IsChecked = " checked "
  end function

  function IsSelected (byval bSelected)
    ' DESCRIPTION : Returns the string " selected " if bChecked is True or "1"
    if ValidateBoolean(bSelected) = 1 then IsSelected = " selected "
  end function

  Function InArray(byref sValue, byref vArray)
    ' DESCRIPTION : Checks if sValue is in the array
    dim iUpper, index

    if not(IsArray(vArray)) then
      InArray = False
      Exit function
    end if

    iUpper = UBOUND(vArray)
    for index=0 to iUpper
      if trim(cstr(vArray(index))) = trim(cstr(sValue)) then
        InArray = True
        Exit Function
      end if
    next

    ' Search value not found
    InArray = False
  End Function


  function Canonize(byval sValue)
  ' Description: Decodes hex-encoded strings (such as strings encoded with validateURL() )
   dim sResult, iPos, char1, char2, iValue, iStart
   if len(sValue) = 0 or isNull(sValue) then exit function

   sResult = replace(sValue, "+", " ")
   iStart = 1

   do while (instr(iStart, sResult, "%"))
      iPos = instr(iStart, sresult, "%")
      Char1 = mid(sResult, iPos+1, 1)
      Char2 = mid(sResult, iPos+2, 1)

      iValue = 16 * HexToDec(Char1)
      iValue = iValue + HexToDec(Char2)

      sResult = replace(sResult, CSTR("%" & Char1 & Char2), chr(iValue))
      iStart = iPos + 1
   loop
   Canonize = sResult
  end function


  function GenerateLogonLink()
  ' DESCRIPTION : Generates a link to login page
  ' RETURNS: /logon.asp?redirect=[current page]
    GenerateLogonLink = sBBSForumRoot & "/logon.asp?redirect=" & ValidateField(ValidateURL(sBBSCompleteURL))
  end function

  function CheckUsername (byRef sCheckUsername, byref sCheckPassword)
    ' DESCRIPTION : Checks a username & password.
    ' INPUTS      : sCheckUsername - The username to check
    '             : sCheckPassword - The password to check
    ' RETURNS     : A userstatus
    ' NOTES       : sCheckUsername is changed to reflect proper capitalization per user database

    CheckUsername = CheckUsernameByID(GetMemberID(sCheckUsername), sCheckPassword)

  end function

  function CheckUsernameByID (byval iMemberID, byref sCheckPassword)
    ' DESCRIPTION : Checks a username & password.
    ' INPUTS      : sCheckUsername - The username to check
    '             : sCheckPassword - The password to check
    ' RETURNS     : A userstatus
    ' NOTES       : sCheckUsername is changed to reflect proper capitalization per user database

    dim vUserInfo

    vUserInfo = GetUserInfoByID(iMemberID)

    if vUserInfo(UI_MemberID) = -1 then
      CheckUsernameByID = US_NotRegistered
      iBBSMemberID = -1
    elseif vUserInfo(UI_Password) <> trim(sCheckPassword) then
      CheckUsernameByID = US_BadPassword
      iBBSMemberID = -1
    elseif vUserInfo(UI_Password) = trim(sCheckPassword) and vUserInfo(UI_Active) = 1 then
      CheckUsernameByID = US_Registered
      sBBSUsername  = vUserInfo(UI_Username) ' Standard capitalization
      iBBSMemberID = clng(iMemberID)
    elseif vUserInfo(UI_Password) = trim(sCheckPassword) and vUserInfo(UI_Active) = 0 then
      CheckUsernameByID = US_Inactive
      iBBSMemberID = -1
    else
      CheckUsernameByID = US_Undefined
      iBBSMemberID = -1
    end if

  end function

  function ChangeSecurityContext(byval sChangeUsername, byval sChangePassword)
    ' DESCRIPTION : Changes the active security context

    dim vUserInfo

    iBBSLogonType = CheckUsername (sChangeUsername, sChangePassword)

    if iBBSLogonType = US_Registered then
      iBBSMemberID = GetMemberID(sChangeUsername)
    sBBSUsername = sChangeUsername
      sBBSPassword = sChangePassword
    else
      iBBSMemberID = -1
      sBBSUsername  = ""
      sBBSPassword  = ""
    end if
    iBBSUserLevel = GetUserLevel(MODULE_BBS, -1)

    if iBBSLogonType = US_Registered then
      vUserInfo = GetUserInfobyID(iBBSMemberID)
      iBBSTimeOffset = vUserInfo(UI_TimeOffset)
      vIgnoreList    = split(vUserInfo(UI_IgnoreList), ",")
    else
      iBBSTimeOffset = 0
    end if

  end function

  function RevertSecurityContext()

    iBBSCookieID    = request.cookies(sBBSCookieRoot & "bbsmid")
    sBBSPassword    = request.cookies(sBBSCookieRoot & "password")

    ' Get the user logon type and global variables
    if sBBSUsername = "12345678901234567890logoff" or iBBSCookieID = -100 then
      iBBSLogonType = US_NotRegistered
      sBBSUsername  = ""
      sBBSPassword  = ""
    else
      iBBSLogonType = CheckUsernameByID (iBBSCookieID, sBBSPassword)
    end if

    iBBSUserLevel = GetUserLevel(MODULE_BBS, -1)

    if iBBSLogonType = US_Registered then
      vUserInfo = GetUserInfobyID(iBBSMemberID)
      iBBSTimeOffset = vUserInfo(UI_TimeOffset)
      vIgnoreList    = split(vUserInfo(UI_IgnoreList), ",")
    else
      iBBSTimeOffset = 0
    end if

  end function


Function MBBSReplace(sSource, sPattern, sReplace)
  Dim regEx
  Set regEx = Server.CreateObject("VBScript.RegExp")
  regEx.Pattern = sPattern
  regEx.IgnoreCase = True
  MBBSReplace = regEx.Replace(sSource, sReplace)
End Function



  function GetMemberID(byref sIDUsername)
   ' DESCRIPTION   : Lookup a memberid
   ' INPUTS        : A username
   ' RETURNS       : memberid if successful, -1 otherwise

   dim SQL, rsLookupUser, sKey
   sKey = "UNAME-" & ucase(sIDUsername)
   GetMemberID = BBS.Cache(sKey)

    if not(IsEmpty(GetMemberID)) then
      iBBSCachedHits = iBBSCachedHits + 1
      exit Function
    end if

    set rsLookupUser = server.createobject("ADODB.Recordset")
    SQL = "select memberid from members where username='" & ValidateSQL(sIDUsername) & "'"
    rsLookupUser.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    if rsLookupUser.EOF then
      GetMemberID = -1
    else
      GetMemberID = rsLookupUser.fields(0).value
    end if

    rsLookupUser.Close
    BBS.CacheAdd sKey, GetMemberID

  end function

  function GetGroupID(byref sGroupName)
   ' DESCRIPTION   : Lookup a groupid
   ' INPUTS        : A group name
   ' RETURNS       : groupid if successful, -1 otherwise

   dim SQL, rsLookupGroup, sKey
   sKey = "GID-" & sGroupName

    if dictGeneralCache.Exists(sKey) then
      GetGroupID = dictGeneralCache.Item(sKey)
      iBBSCachedHits = iBBSCachedHits + 1
    else
      set rsLookupGroup= server.createobject("ADODB.Recordset")
      SQL = "select groupid from groups where groupname='" & ValidateSQL(sGroupName) & "'"
      rsLookupGroup.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)

      if rsLookupGroup.EOF then
        GetGroupID = -1
      else
        GetGroupID = rsLookupGroup.fields(0).value
      end if

      rsLookupGroup.Close
      dictGeneralCache.add sKey, GetGroupID
    end if
  end function

  function IsIngroup(iGroupID, iMemberID)
    ' DESCRIPTION   : Is a user in a group?
    ' INPUTS        : A groupid and memberid
    ' RETURNS       : True or false
    ' NOTES         : You can use GetGroupID to look up a group name, but it is faster if you can hard-code the groupid
    dim SQL, rsInfo
    set rsInfo = server.createobject("ADODB.Recordset")
    SQL = "select memberid from groupmembers where memberid=" & BBS.ValidateNumeric(iMemberID) & " and groupid=" & BBS.ValidateNumeric(iGroupID)
    rsInfo.open SQL, dbConnection, adOpenStatic, adLockReadOnly
    IsInGroup = not(rsInfo.eof)
    rsInfo.Close
    set rsInfo = Nothing
  end function

  function GetUsername(iMemberID)
    ' DESCRIPTION   : Lookup a username
    ' INPUTS        : A memberid
    ' RETURNS       : The username, or a zero length string if not found

    dim vUserInfo
    vUserInfo = GetUserInfobyID(iMemberID)
    GetUsername = vUserInfo(UI_Username)

  end function

  function GetGroupName(iGroupID)
    ' DESCRIPTION : Gets a group's name given a supplied ID number

    dim SQL, rsGroupInfo
    set rsGroupInfo = server.CreateObject("ADODB.Recordset")
    SQL = "select groupname from groups where groupid=" & ValidateNumeric(iGroupID)
    rsGroupInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    if not(rsGroupInfo.EOF) then
      GetGroupName = rsGroupInfo.fields(0).value
    else
      GetGroupname = ""
    end if
    rsGroupInfo.Close
  end function

  function CanViewAllPosts(iForumID)
    ' DESCRIPTION : Determines if we will filter out unapproved posts for this user in this forum
    dim iResult

    if dictConfiguration.item("bFORCEPOSTVALIDATION") <> 1 then
      CanViewAllPosts = True
      exit function
    end if

    ' If we have activated post validation, we'll want to filter posts.
    ' We can always override it later if necessary
    if dictConfiguration.item("bFORCEPOSTVALIDATION") = 1 then iResult = False

    ' if the user is at least a module admin, they'll get to see all posts
    if iBBSUserLevel >= USERLEVEL_ModuleAdministrator then iResult = True

    ' Let forum moderators see their own posts
    if GetUserLevel(MODULE_FORUMS, iForumID) >= USERLEVEL_MODERATOR then iResult = True

    CanViewAllPosts = iResult

  end function

  function CanApprovePosts(iForumID)
    ' DESCRIPTION : Determines if we will filter out unapproved posts for this user in this forum
    dim iResult

    ' if the user is at least a module admin, they'll get to see all posts
    if iBBSUserLevel >= USERLEVEL_ModuleAdministrator then iResult = True

    ' Let forum moderators see their own posts
    if GetUserLevel(MODULE_FORUMS, iForumID) >= USERLEVEL_MODERATOR then iResult = True

    CanApprovePosts = iResult

  end function

  function GetUserInfoStruct()
    ' DESCRIPTION : Returns a UserInfo structure
    dim result(44)
    result(UI_MemberID) = -1
    GetUserInfoStruct   = Result
  end function


  function GetUserInfo (byref sInfoUserName)
    GetUserInfo = GetUserInfobyID(GetMemberID(sInfoUsername))
  end function

  function GetUserInfobyName (byref sInfoUserName)
    GetUserInfobyName = GetUserInfobyID(GetMemberID(sInfoUsername))
  end function

  function GetUserInfobyID (byref iMemberID)
    ' DESCRIPTION  : Gets all information related to a user
    ' INPUTS       : iMemberID - The MemberID
    ' RETURNS      : A UserInfo structure

    on error resume next
    dim SQL, vUserRows, result, rsUserInfo, sKey

    sKey = "UI-" & iMemberID

    result = BBS.Cache(sKey)

    if not(IsEmpty(result)) then
      result(UI_IsOnline) = IsOnline(result(UI_Username))
      GetUserInfoByID = result
      iBBSCachedHits = iBBSCachedHits + 1
      exit function
    end if

      result = GetUserInfoStruct
      SQL = "select memberid, username, realname, website, emailaddress, icqnumber, yahoo, msn, aim, active, interests, usesignature, viewsignature, " ' 0-12
      SQL = SQL & "signature, dateregistered, totalposts, showemail, password, location, notificationpreference, invisible, avatarurl, photourl, defaultthreadview, " ' 13-23
      SQL = SQL & "defaultforumview, userichedit, lastlogon, disablepostcount, timeoffset, logoffurl, usecustomrank, " ' 24-30
      SQL = SQL & "customrank, sendprivatenotifications, schemeid, includebody , languageid, oktopost, disallowbroadcasts, " ' 31-37
      SQL = SQL & "viewavatars, salt, vcode, quickreplymode, ignorelist " '38-42
      SQL = SQL & "from members where memberid=" & ValidateNumeric(iMemberID)
      set rsUserInfo = server.createobject("ADODB.Recordset")
      rsUserInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)

      if not(rsUserInfo.EOF) then
        vUserRows = rsUserInfo.GetRows
        rsUserInfo.Close
        result(UI_memberid)           = BBS.ValidateNumeric(vUserRows(0, 0))
        result(UI_Username)           = BBS.ValidateBlank(vUserRows(1, 0))
        result(UI_RealName)           = BBS.ValidateBlank(vUserRows(2, 0))
        result(UI_Websiteaddr)        = BBS.ValidateBlank(vUserRows(3, 0))
        result(UI_emailaddr)          = BBS.ValidateBlank(vUserRows(4, 0))
        result(UI_ICQNumber)          = BBS.ValidateBlank(vUserRows(5, 0))
        result(UI_Yahoo)              = BBS.ValidateBlank(vUserRows(6, 0))
        result(UI_MSN)                = BBS.ValidateBlank(vUserRows(7, 0))
        result(UI_AIM)                = BBS.ValidateBlank(vUserRows(8, 0))
        result(UI_Active)             = BBS.ValidateNumeric(vUserRows(9, 0))
        result(UI_Interests)          = BBS.ValidateBlank(vUserRows(10, 0))
        result(UI_usesignature)       = BBS.ValidateNumeric(vUserRows(11, 0))
        result(UI_viewsignature)      = BBS.ValidateNumeric(vUserRows(12, 0))
        result(UI_signature)          = BBS.ValidateBlank(vUserRows(13, 0))
        result(UI_dateregistered)     = BBS.ValidateBlank(vUserRows(14, 0))
        result(UI_totalposts)         = BBS.ValidateNumeric(vUserRows(15, 0))
        result(UI_ShowEmail)          = BBS.ValidateNumeric(vUserRows(16, 0))
        result(UI_Password)           = BBS.ValidateBlank(vUserRows(17, 0))
        result(UI_location)           = BBS.ValidateBlank(vUserRows(18, 0))
        result(UI_emailnotifications) = BBS.ValidateBlank(vUserRows(19, 0))
        result(UI_Invisible)          = BBS.ValidateNumeric(vUserRows(20, 0))
        result(UI_ProfileURL)         = BBS.ValidateBlank(vUserRows(21, 0))
        result(UI_photourl)           = BBS.ValidateBlank(vUserRows(22, 0))
        result(UI_defaultthreadview)  = BBS.ValidateBlank(vUserRows(23, 0))
        result(UI_defaultforumview)   = BBS.ValidateBlank(vUserRows(24, 0))
        result(UI_userichedit)        = BBS.ValidateNumeric(vUserRows(25, 0))
        result(UI_LastLogon)          = BBS.ValidateBlank(vUserRows(26, 0))
        result(UI_disablepostcount)   = BBS.ValidateNumeric(vUserRows(27, 0))
        result(UI_TimeOffset)         = BBS.ValidateNumeric(vUserRows(28, 0))
        result(UI_LogoffURL)          = BBS.ValidateBlank(vUserRows(29, 0))
        result(UI_UseCustomRank)      = BBS.ValidateBlank(vUserRows(30, 0))
        result(UI_IsOnline)                 = IsOnline(vUserRows(1, 0))
        result(UI_SendPrivateNotifications) = BBS.ValidateBlank(vUserRows(32, 0))
        result(UI_TemplateID)               = ValidateNumeric(vUserRows(33, 0))
        result(UI_IncludeBody)              = BBS.ValidateBlank(vUserRows(34, 0))
        result(UI_LanguageID)               = BBS.ValidateNumeric(vUserRows(35, 0))
        result(UI_OKtopost)                 = BBS.ValidateNumeric(vUserRows(36, 0))
        result(UI_DisallowBroadcasts)       = BBS.ValidateNumeric(vUserRows(37, 0))
        result(UI_ViewAvatars)              = BBS.ValidateNumeric(vUserRows(38, 0))
        result(UI_Salt)                     = BBS.ValidateBlank(vUserRows(39, 0))
        result(UI_VCode)                    = BBS.ValidateBlank(vUserRows(40, 0))
        result(UI_QuickReplyMode)           = BBS.ValidateBlank(vUserRows(41, 0))
        result(UI_IgnoreList)               = BBS.ValidateBlank(vUserRows(42, 0))

        ' A custom rank?
        if vUserRows(30, 0) = 1 then
           result(UI_Rank) = vUserRows(31, 0)
        else
           result(UI_Rank) = GetRank(result(UI_totalposts), DateDiff("d", result(UI_dateregistered), now))
        end if

      else
        result(UI_memberid) = -1
        rsUserInfo.Close
      end if
      set rsUserInfo = Nothing

      BBS.CacheAdd sKey, result
      GetUserInfobyID = result
      on error goto 0

  end function

  function InIgnoreList(byval iViewingMember, byval iTargetMember)
    ' DESCRIPTION : If iTargetMember is in iViewingMember's ignore list, true is returned
    dim vUserInfo
    vUserInfo = GetUserInfoByID(iViewingMember)
    InIgnoreList = InArray(iTargetMember, split(vUserInfo(UI_IgnoreList), ","))
  end function


  Function GetCategoryInfoStruct()
    ' DESCRIPTION: Returns a CategoryInfo structure
    ' RETURNS    : A CategoryInfo structure

    dim stResult(7)
    GetCategoryInfoStruct = stResult
  end function

  Function GetCategoryInfo (byref iCategoryID)
    ' DESCRIPTION : Returns an array with information fields describing the category
    ' INPUTS      : iCategoryID - CategoryID
    ' RETURNS     : CategoryInfo structure

    dim vFuncResult, rsCategoryInfo, SQL, sKey

    sKey = "CI-" & iCategoryID
    GetCategoryInfo = BBS.Cache(sKey)


    if not(IsEmpty(GetCategoryInfo)) then
      iBBSCachedHits = iBBSCachedHits + 1
      exit function
    end if


      set rsCategoryInfo = server.createobject("ADODB.Recordset")
      vFuncResult = GetCategoryInfoStruct()
      SQL = "select name, url, locked, schemedefault, forcescheme, sortorder, collapsedbydefault from categories where categoryid=" & ValidateNumeric(iCategoryID)
      rsCategoryInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)

      if rsCategoryInfo.EOF then
        vFuncResult(CA_CategoryID) = -1
      else
        vFuncResult(CA_CategoryID)         = iCategoryID
        vFuncResult(CA_CategoryName)       = rsCategoryInfo(0)
        vFuncResult(CA_CategoryURL)        = rsCategoryInfo(1)
        vFuncResult(CA_Locked)             = rsCategoryInfo(2)
        vFuncResult(CA_SchemeDefault)      = rsCategoryInfo(3)
        vFuncResult(CA_ForceScheme)        = rsCategoryInfo(4)
        vFuncResult(CA_SortOrder)          = rsCategoryInfo(5)
        vFuncResult(CA_CollapsedByDefault) = rsCategoryInfo(6)
      end if

      rsCategoryInfo.Close
      set rsCategoryInfo = Nothing
      GetCategoryInfo = vFuncResult
      BBS.CacheAdd sKey, vFuncResult

  end Function

  Function IsOnline(byval sOnlineUserName)
   ' DESCRIPTION : Determines if a user is online

   IsOnline = dictOnline.exists("1-" & ucase(sOnlineUsername))
  end function

function GetRank(byref iPosts, byref iDaysRegistered)
    ' DESCRIPTION : Calculates user rank
    dim sUserRank, iUpperBound, index, sKey
    if IsArray(vBBSRankArray) then
      iUpperBound = UBOUND(vBBSRankArray, 2)
      for index = 0 to iUpperBound
        if iPosts >= vBBSRankArray(0, index) and iDaysRegistered >= vBBSRankArray(1, index) then GetRank = vBBSRankArray(2, index)
      next
    end if

end function

function GetDecorations(byref iPosts)
   dim index, iProvisionalPosts, sResult
   if IsArray(vBBSDecorationArray) then
      if dictConfiguration("iDECORATIONMODE") = 1 or len(dictConfiguration("iDECORATIONMODE")) = 0 then
        ' Multiple images (build up)
        iProvisionalPosts = ValidateNumeric(iPosts)
        do until index > ubound(vBBSDecorationArray, 2)
          if vBBSDecorationArray(0, index) = 0 then
            if len(sResult) = 0 then
              sResult = "<img alt=""" & vBBSDecorationArray(0, index) & """ src=""" & sBBSValidatedBaseURL & "/images/decorations/multiple/" & BBS.ValidateField(vBBSDecorationArray(1, index)) & """>"
              exit do
            else
              exit do
            end if
          end if
          if vBBSDecorationArray(0, index) > iProvisionalPosts then
            index = index + 1
          else
            iProvisionalPosts = iProvisionalPosts - vBBSDecorationArray(0, index)
            sResult = sResult & "<img alt=""" & vBBSDecorationArray(0, index) & """ src=""" & sBBSValidatedBaseURL & "/images/decorations/multiple/" & BBS.ValidateField(vBBSDecorationArray(1, index)) & """>"
          end if
        loop
      else
        ' Single image
        iPosts = ValidateNumeric(iPosts)
        for index = 0 to ubound(vBBSDecorationArray, 2)
          if iPosts >= vBBSDecorationArray(0, index) then
            sResult = sResult & "<img alt=""" & vBBSDecorationArray(0, index) & """ src=""" & sBBSValidatedBaseURL & "/images/decorations/single/" & BBS.ValidateField(vBBSDecorationArray(1, index)) & """>"
            exit for
          end if
        next
      end if
   end if
   GetDecorations = sResult
end function

  function GetUserRankbyName(byref sRankName)
    GetUserrankbyName = GetUserrankbyID(GetMemberID(sRankName))
  end function

  function GetUserRank(byref sRankName)
    GetUserrank = GetUserrankbyID(GetMemberID(sRankName))
  end function

  function GetUserRankbyID(byref iMemberID)
    ' DESCRIPTION : Figures out a user's rank
    ' INPUTS      : iMemberID - The memberID
    ' RETURNS     : A string containing the user's rank

    dim rsUserRank, SQL, sKey
    sKey = "UR-" & iMemberID

    if dictGeneralCache.Exists(sKey) then
      GetUserRankbyID = dictGeneralCache.Item(sKey)
      iBBSCachedHits = iBBSCachedHits + 1
    else
      set rsUserRank = server.createobject("ADODB.Recordset")
      SQL = "select usecustomrank, customrank, totalposts, dateregistered from members where memberid=" & ValidateSQL(iMemberID)
      rsUserRank.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not(rsUserRank.EOF) then
        if rsUserRank.fields(0).value = 1 then
          GetUserRankbyID = rsUserRank.fields(1).value
        else
          GetUserRankbyID = GetRank(rsUserRank.fields(2).value, DateDiff("d", rsUserRank.fields(3).value, now))
        end if
      end if
      dictGeneralCache.add sKey, GetUserRankbyID
      rsUserRank.Close
      set rsUserRank = Nothing
    end if

  end function

function EmailAddressExists (sEmailAddress)

  ' Description : Checks to see if an email address already exists in the system
  ' Inputs      : An e-mail address
  ' Returns     : True or False

    dim result, SQL, rsEmail

    set rsEmail = server.createobject("ADODB.Recordset")

    SQL = "select emailaddress from members where emailaddress='" & ValidateSQL(sEmailAddress) & "'"
    rsEmail.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    if not(rsEmail.EOF) then
       result = true
    else
       result = false
    end if
    rsEmail.Close
    set rsEmail = Nothing

    EmailAddressExists = Result

end function

function IsBannedEmail(sEmailAddress)

  ' Description : Checks to see if an email address is banned
  ' Inputs      : An e-mail address
  ' Returns     : True or False
  dim result, SQL, rsEmail

    set rsEmail = server.createobject("ADODB.Recordset")

    SQL = "select emailaddress from bannedemails"
    rsEmail.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    bResult = False
    do until (rsEmail.EOF) or (bResult = True)
       if instr(sEmailAddress, rsEmail.fields(0).value) >= 1 then Result = True
       rsEmail.movenext
    loop
    rsEmail.Close
    set rsEmail = Nothing

    IsBannedEmail = Result
end function

  function ListMembers (byref iModuleID, byref iUserLevel, byref iTargetID)
    ' DESCRIPTION : Lists all the users in a given target/module/userlevel
    ' INPUTS      : The module, userlevel and target
    ' RETURNS     : An HTML string listing the members and groups

    dim rsMembers, sResult, SQL, vArray, index, iUpperBound, iRecordset, sKey
    set rsMembers = server.createobject("ADODB.Recordset")

    sKEY = "LM-" & iModuleID & "-" & iUserlevel & "-" & iTargetID
    ListMembers = BBS.Cache(sKey)
    if not(IsEmpty(ListMembers)) then
      iBBSCachedHits = iBBSCachedHits + 1
      exit function
    end if

    SQL = "select id, idtype from userlevelmembers where moduleid=" & ValidateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iTargetID) & " and userlevel=" & ValidateNumeric(iUserLevel)
    rsMembers.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    if not(rsMembers.EOF) then
      vArray = rsMembers.GetRows
      rsMembers.Close
      iUpperBound = UBOUND(vArray, 2)
      for index = 0 to iUpperBound
        if vArray(1, index) = USERLEVEL_MEMBER then
          sResult = sResult & CreateUsernameLinkbyID(vArray(0, index)) & validateField(GetUsername(vArray(0, index))) & "</a>, "
        else
          sResult = sResult & CreateGroupnameLink(vArray(0, index)) & validateField(GetGroupName(vArray(0, index))) & "</a>, "
        end if
      next
    else
      rsMembers.Close
    end if
    if not(len(sResult)=0) then
      ListMembers = left(sResult, len(sResult)-2)
    else
      ListMembers = ""
    end if
    BBS.CacheAdd sKey, ListMembers
  end function

  function ListGroupMembers(iGroupID)
    ' DESCRIPTION : Lists the members of a group
    dim SQL, rsInfo, sOutput
    set rsInfo = server.createobject("ADODB.Recordset")

    SQL = "select groups.groupname, groups.groupid, members.memberid, members.username from groups, groupmembers, members where groups.groupid=groupmembers.groupid and groupmembers.memberid=members.memberid and groups.groupid=" & BBS.ValidateNumeric(iGroupID) & " order by groupname asc, username asc"
    rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    BBS.AddQuery(SQL)
    if not (rsInfo.EOF) then
      do until rsInfo.EOF
        sOutput = sOutput & BBS.CreateusernameLInkbyID(rsinfo.fields("memberid").value) & BBS.ValidateField(rsinfo.fields("username").value) & "</a><br>"
        rsInfo.MoveNext
      loop
    end if
    rsInfo.close
    if len(sOutput) > 0 then sOutput = left(sOutput, len(sOutput)-4)
    ListGroupMembers = sOutput
  end function

  function ListMembersArray (byref iModuleID, byref iUserLevel, byref iTargetID)
    ' DESCRIPTION : Lists all the users in a given target/module/userlevel
    ' INPUTS      : The module, userlevel and target
    ' RETURNS     : An array, giving you the memberid, username, and email of everyone in the list

    dim rsMembers, sResult, SQL
    set rsMembers = server.createobject("ADODB.Recordset")

    SQL = "select members.memberid, members.username, members.emailaddress from userlevelmembers, members where members.memberid=userlevelmembers.id and moduleid=" & ValidateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iTargetID) & " and userlevel=" & ValidateNumeric(iUserLevel) & " and idtype=" & USERLEVEL_MEMBER
    SQL = SQL & " union select groupmembers.memberid, members.username, members.emailaddress from userlevelmembers, groupmembers, members where groupmembers.memberid=members.memberid and groupmembers.groupid=userlevelmembers.id and moduleid=" & ValidateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iTargetID) & " and userlevel=" & ValidateNumeric(iUserLevel) & " and idtype=" & USERLEVEL_GROUP & ""
    rsMembers.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)
    if not(rsMembers.EOF) then
      ListMembersArray = rsMembers.GetRows
    end if
    rsMembers.Close
    set rsMembers = Nothing
  end function

function HTMLTidy(byref sBody)
  dim vSource, vDest
  sBody = replace(sBody, CRLF, "")
  clean "/\&nbsp\;/", " ", sBody
  clean "/ class=[^\s|>]*/i", " ", sBody
  clean "/ style=\""[^>]*\""/i", " ", sBody
  clean "/ align=[^\s|>]*/i", " ", sBody
  clean "/<b [^>]*>/i", " ", sBody
  clean "/<i [^>]*>/i", " ", sBody
  clean "/<li [^>]*>/i", " ", sBody
  clean "/<ul [^>]*>/i", " ", sBody
  clean "/<em>/i", "<i>", sBody
  clean "/<\/em>/i", "</i>", sBody
  clean "/<\?xml:[^>]*>/", " ", sBody
  clean "/<\/?st1:[^>]*>/", " ", sBody
  clean "/<\/?[a-z]\:[^>]*>/", " ", sBody

  clean "/<([a-z][a-z]*)> *<\/\1>/i", " ", sBody
  clean "/<([a-z][a-z]*)> *<([a-z][^>]*)> *<\/\1>/i", "<$2>", sBody
  clean "/<([a-z][a-z]*)><\1>/i", "<$1>", sBody
  clean "/<\/([a-z][a-z]*)><\/\1>/i", "<\/$1>", sBody

  HTMLTidy=sBody
end function

sub clean(byref sSource, byref sReplace, byref sBody)
  mbbsRegEx.IgnoreCase = True
  mbbsRegEx.global = True
  mbbsregex.pattern = sSource
  sBody= mbbsregex.Replace(sBody, sReplace)
end sub

function MBBSDecode(byRef sBodyText, byref bEmoticons)

  ' DESCRIPTION : Encodes a message for display.
  ' INPUTS      : sBodyText  - Text to be decoded to HTML
  '               bEmoticons - Convert smileys to emoticon images?
  ' RETURNS     : Encoded HTML

  dim sNewText, iFinishLocation, sHref, iFinishLocation1, iFinishLocation2
  dim iSearchStartPos, iPreviousCharacter, limitbreak, sReplacementText, rsDecode
  dim sSourceEmoticon, sDestEmoticon, index, iUpperBound, sDecode, sDecodeHTML, sDecodeParam, lstrMatches, lstrMatch
  dim sReplaceString


  mBBSRegEx.IgnoreCase = true
  bEmoticons = validateBoolean(bEmoticons)
  MBBSDecode = ValidateBlank(sBodyText)

  ' Break up large strings
  if dictConfiguration.item("bDISABLEWORDWRAP") = 0 then
    mBBSRegEx.pattern = "^\S{150,}"
    set lstrMatches = mBBSRegEx.Execute(MBBSDecode)
    for each lstrMatch in lstrMatches
      index = 1
      sReplaceString = ""
      do until index > len(lstrMatch.Value)
         sReplaceString = sReplaceString & mid(lstrMatch.value,index, 150) & CRLF
         index = index + 100
      loop
      MBBSDecode = replace(MBBSDecode, lstrMatch.value, sReplaceString)

    next
  end if

  if bEmoticons = 1 and dictConfiguration.item("bDISABLEEMOTICONS") = 0 then
     if IsArray(vBBSEmoticonsArray) then
       iUpperBound = UBOUND(vBBSEmoticonsArray, 2)
       for index = 0 to iUpperBound
         mBBSRegEx.global = true
         mBBSRegEx.pattern = "(" & vBBSEmoticonsArray(0, index) & ")"
         MBBSDecode = mBBSRegEx.Replace(MBBSDecode, "<img align='middle' src='" & sBBSValidatedBaseURL & "/images/emoticons/" & BBS.UnValidateRegEX(vBBSEmoticonsArray(1, index)) & "'>")
         'mBBSRegEx.pattern = vBBSEmoticonsArray(0, index)
         'MBBSDecode = mBBSRegEx.Replace(MBBSDecode, "<img align='middle' src='" & sBBSValidatedBaseURL & "/images/emoticons/" & BBS.UnValidateRegEX(vBBSEmoticonsArray(1, index)) & "'>")
       next
     end if
  end if

  ' Always filter these potentially harmful characters.
  ' If any reader has suggestions for further filter additions,
  ' please contact info@pd9soft.com

  MBBSDecode= replace(MBBSDecode , CRLF, " <br/>" & CRLF)
  MBBSDecode= replace(MBBSDecode , "<link", "&lt;link", 1, -1, 1)


  MBBSDecode= replace(MBBSDecode , "<iframe", "&lt;iframe", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<applet", "&lt;applet", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<body", "&lt;body", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<embed", "&lt;embed", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<form", "&lt;form", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<frame", "&lt;frame", 1, -1, 1)
  'MBBSDecode= replace(MBBSDecode , "<layer", "&lt;layer", 1, -1, 1)
  'MBBSDecode= replace(MBBSDecode , "<ilayer", "&lt;ilayer", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<script", "&lt;script", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<object", "&lt;object", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<meta", "&lt;meta", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "<style", "&lt;style", 1, -1, 1)

  MBBSDecode= replace(MBBSDecode , "<noscript", "&lt;noscript", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#40", "&amp;#40", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#41", "&amp;#41", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#0000040", "&amp;#0000040", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#0000041", "&amp;#0000041", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#0", "&amp;#0", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#x28", "&amp;#x28", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "&#x29", "&amp;#x29", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , "(", "<b></b>(", 1, -1, 1)
  MBBSDecode= replace(MBBSDecode , ")", "<b></b>)", 1, -1, 1)


  ' Autohyperlink
  if dictConfiguration.item("bDISABLEAUTOHYPERLINKS") = 0 then

    ' First replace links under 60 characters long
    mBBSRegEx.global = true
    mbbsregex.pattern = "(\s|^)(http[s]?:)[/|\\]{2}([^\s\x3C]{0,60})(\s|\x3C|$)"
    MBBSDecode = mbbsregex.Replace(MBBSDecode, "$1<a href=""$2//$3"" target=""_blank"" title=""$2//$3"">$2//$3</a>$4")

    ' Now replace links > 60 characters long with a trimmed-down hyperlink
    mbbsregex.pattern = "(\s|^)(http[s]?:)[/|\\]{2}(\S{0,60})([^\s\x3C]*)"
    MBBSDecode = mbbsregex.Replace(MBBSDecode, "$1<a href=""$2//$3$4"" target=""_blank"" title=""$2//$3$4"">$2//$3...</a>")

    ' Auto-list turns lines that being with ". " into bulleted lists
    'mBBSRegEx.global = true
    'mBBSRegEx.Pattern = "(\s|^)\.\ (.*?)(\s|$)"
    'MBBSDecode = mBBSRegEx.Replace(MBBSDecode, "$1<li>$2</li>$3")

  end if


  ' MBBS Code
  if dictConfiguration.item("bDISABLEMBBSCODE") = 0 then
    if IsArray(vBBSDecodeArray) then
    iUpperBound = UBOUND(vBBSDecodeArray, 2)
    for index=0 to iUpperBound
        if len(vBBSDecodeArray(0, index)) > 0 then

           if instr(vBBSDecodeArray(0, index), "{param}") > 0 then
             if dictEnvironment("C-MBBSDECODEFILTERHTML") = 1 then
               sDecode = replace(ValidateField(vBBSDecodeArray(0, index)), "{param}", "([^\]]*)")
             else
               sDecode = replace(vBBSDecodeArray(0, index), "{param}", "([^\]]*)")
             end if
             sDecodeHTML = replace(vBBSDecodeArray(1, index), "{param}", "$1")
             mBBSRegEx.pattern = sDecode
             MBBSDecode = mBBSRegEx.Replace(MBBSDecode, sDecodeHTML)
           else
             mBBSRegEx.pattern = vBBSDecodeArray(0, index)
             MBBSDecode = mBBSRegEx.replace(MBBSDecode, vBBSDecodeArray(1, index))
           end if

        end if

        if len(vBBSDecodeArray(2, index)) > 0 then
           if dictEnvironment("C-MBBSDECODEFILTERHTML") = 1 then
             mBBSRegEx.pattern = vBBSDecodeArray(2, index)
           else
             mBBSRegEx.pattern = ValidateField(vBBSDecodeArray(2, index))
           end if
           MBBSDecode = mBBSRegEx.replace(MBBSDecode, vBBSDecodeArray(3, index))
        end if
    next
    end if
  else
    ' the QUOTE MBBS code always applies
    MBBSDecode = replace(MBBSDecode, "[quote]", "<div class=""quotation"">", 1, -1, 1)
    MBBSDecode = replace(MBBSDecode, "[/quote]", "</div>", 1, -1, 1)
  end if

end function





  sub UpdateLocation (byref sLocationUsername, byref sLocation, byref sIP, byref bRegistered)
    ' DESCRIPTION : Updates a user in the online table
    ' NOTES       : Since this is already an expensive function, it is rare in the fact that it reuses RSMASTER inside the API,
    '             : (in order to save some processing time), so make sure that rsmaster is closed before using this function

    dim SQL, newtime, oldtime, sComparison, index, iUpperBound, vOnlineInfo(6), vOnlineArray, sKey, item

    if instr(sBBSCurrentURLPath, "profile/get-photo.asp") <= 0 and instr(sBBSCurrentURLPath, "photos/get-photo.asp") <= 0 and instr(sBBSCurrentURLPath, "photos/getimage.aspx") <= 0 then

    ' Clear out all the old usernames
    oldtime = DateAdd("n", -30, now)
    SQL = "select recordid, username, bbslocation, logontime, lastactivity, ip, registered from online"
    rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)
    if not rsMaster.EOF then
      vOnlineArray= rsMaster.GetRows
      rsMaster.CLose
      iUpperBound = UBOUND(vOnlineArray, 2)
      for index=0 to iUpperBound
        if cdate(vOnlineArray(4, index)) < cdate(oldTime) then
          if vOnlineArray(6, index) = 1 then UpdateLastLogon vOnlineArray(1, index), vOnlineArray(4, index)
          LogOffUser vOnlineArray(1, index), vOnlineArray(5, index), vOnlineArray(3, index), vOnlineArray(4, index), vOnlineArray(6, index)
        else
          vOnlineInfo(ON_RecordID)    = vOnlineArray(0, index)
          vOnlineInfo(ON_Username)    = vOnlineArray(1, index)
          vOnlineInfo(ON_Location)    = vOnlineArray(2, index)
          vOnlineInfo(ON_Logontime)   = vOnlineArray(3, index)
          vOnlineInfo(ON_Lastactivity)= vOnlineArray(4, index)
          vOnlineInfo(ON_IP)          = vOnlineArray(5, index)
          vOnlineInfo(ON_Registered)  = vOnlineArray(6, index)
          sKey = bRegistered & "-" & ucase(vOnlineArray(1, index))
          dictOnline(sKey) = vOnlineInfo
        end if
      next
    else
      rsMaster.CLose
    end if

    SQL = "select username from online where username='" & ValidateSQL(sLocationUsername) & "' and registered=" & ValidateNumeric(bRegistered)
    rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    if rsMaster.EOF then
       SQL = "insert into online (username, logontime, registered, bbslocation, lastactivity, ip) VALUES ("
       SQL = SQL & "'" & ValidateSQL(sLocationUsername) & "', " & sDateDelimiter & GetSQLDateTime(now) & sDateDelimiter
       SQL = SQL & ", " & ValidateBoolean(bRegistered) & ", '" & ValidateSQL(sLocation) & "', "
       SQL = SQL & sDateDelimiter & GetSQLDateTime(now) & sDateDelimiter & ", '" & ValidateSQL(sIP) & "')"
       dbConnection.execute SQL,, adTextNoRecords
       AddQuery(SQL)
    else
       SQL = "update online set bbslocation='" & ValidateSQL(sLocation) & "', lastactivity=" & sDateDelimiter & GetSQLDateTime(now) & sDateDelimiter
       SQL = SQL & ", ip='" & ValidateSQL(sIP) & "' where username='" & ValidateSQL(sLocationUsername) & "' and registered=" & ValidateBoolean(bRegistered)
       dbConnection.execute SQL,, adTextNoRecords
       AddQuery(SQL)
    end if
    rsMaster.close

    end if

  end sub

  sub UpdateLastLogon(sLogoffName, dDate)
    dim SQL
    SQL = "update members set lastlogon=" & sDateDelimiter & GetSQLDateTime(dDate) & sDateDelimiter & " where username='" & ValidateSQL(sLogoffName) & "'"
    dbConnection.Execute SQL,, adTextNoRecords
    AddQuery(SQL)
  end sub

  sub LogOffUser(sLogOffUserName, sIP, logontime, lastactivity, bRegistered)
    dim SQL

    SQL = "delete from online where username='" & ValidateSQL(sLogOffUserName) & "' and registered=" & ValidateNumeric(bRegistered)
    dbConnection.Execute SQL,, adTextNoRecords
    AddQuery(SQL)

    SQL = "insert into visitorhistory (username, ip, logontime, logofftime) VALUES("
    SQL = SQL & "'" & ValidateSQL(sLogoffUsername) & "', '" & ValidateSQL(sIP) & "', " & sDateDelimiter & GetSQLDateTime(logontime) & sDateDelimiter
    SQL = SQL & ", " & sDateDelimiter & GetSQLDateTime(lastactivity) & sDateDelimiter & ");"
    dbConnection.Execute SQL,, adTextNoRecords
    AddQuery(SQL)
  end sub

sub DeleteUserFromLocation (sLocationUsername)
    dim rsLocation, SQL
    SQL = "delete from online where username='" & ValidateSQL(sLocationUsername) & "'"
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
end sub

  function CreateUsernameLinkbyID(byref iBBSMemberID)
    ' DESCRIPTION : Given a username, it will generate the HTML used to link to that user's profile
    ' INPUTS      : A memberid
    CreateUsernameLinkbyID= "<a href='" & sBBSForumRoot & "/view-profile.asp?action=view&amp;uid=" & ValidateNumeric(iBBSMemberID) & "'>"
  end function

  function CreateUsernameLink(byref sLinkUsername)
    CreateUsernameLink = CreateUsernameLinkbyID(GetMemberID(sLinkUsername))
  end function

  function CreateUsernameLinkbyName(byref sLinkUsername)
    CreateUsernameLinkbyName = CreateUsernameLinkbyID(GetMemberID(sLinkUsername))
  end function

  function CreateGroupnameLink(byref sLinkGroupID)
    CreateGroupnameLink= "<a href='" & sBBSForumRoot & "/view-group.asp?gid=" & ValidateNumeric(sLinkGroupID) & "'>"
  end function

function GetRandomQuote()
  ' DESCRIPTION : Pick a random quote from the quotes table and return
  ' RETURNS     : A random quote

  dim SQL, rsQuote, vArray, iCount, iRandomPosition, sAuthor, sQuote, bIsRegistered

  if IsEmpty(BBS.Cache("RANDOMQUOTES")) then
    set rsQuote = server.createobject("ADODB.Recordset")
    SQL = "select message, owner, registered from randomquotes"
    rsQuote.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)
    if not(rsQuote.EOF) then
      vArray = rsQuote.GetRows
      BBS.CacheAdd "RANDOMQUOTES", vArray
    else
      BBS.CacheDelete "RANDOMQUOTES"
    end if
    rsQuote.Close
    set rsQuote = Nothing
  end if

  vArray = BBS.Cache("RANDOMQUOTES")
  if IsArray(vArray) then
    iCount = Ubound(vArray, 2)+1
  else
    icount = 0
  end if

  if iCount > 0 then
    randomize
    iRandomPosition = int(rnd * (iCount))
    sAuthor       = BBS.Cache("RANDOMQUOTES")(1, iRandomPosition)
    sQuote        = ValidateField(FilterView(BBS.Cache("RANDOMQUOTES")(0, iRandomPosition)))
    bIsRegistered = BBS.Cache("RANDOMQUOTES")(2, iRandomPosition)

    GetRandomQuote= sQuote
    if bIsRegistered = 1 and dictConfiguration("bSHOWQUOTEAUTHOR") = 1 then GetRandomQuote= GetRandomQuote & "<br/><span style=""white-space : nowrap""> - (" & dictLanguage("GLOBAL-QUOTE1") & " " & CreateUserNameLinkbyName(sAuthor) & ValidateField(sAuthor) & "</a>)</span>"
  end if

end function


function FilterWords(byref sMessage)
   ' DESCRIPTION : Filters bad words from messages

   dim sNewText, index
   sNewText = sMessage

   ' Filter out any bad words!
   if IsArray(vBBSBadWordFilter) then
     for index=0 to UBOUND(vBBSBadWordFilter, 2)
       sNewText= replace(sNewText , vBBSBadWordFilter(0, index), vBBSBadWordFilter(1, index), 1, -1, 1)
     next
   end if

   FilterWords = sNewText
end function

Function XORCrypt(ByRef astring, ByRef key)
  XORCrypt = astring
'Dim S
'Dim C
'Dim i
'   S=""
'   For i=1 to Len(String)
'       C=Chr((Asc(Mid(string,i,1)) Xor Asc(Mid(key,i,1))) Mod 256)
'       S=S&c
'   Next
'   XORCrypt=S
End Function

Function GetLastLogon(byref sLogonUsername, byref LastLogon)

  ' Returns the last logon date.  If a user doesn't exist, the function returns False

  dim SQL, rsUserInfo
  set rsUserInfo = server.createobject("ADODB.Recordset")
  SQL = "select lastlogon from members where username='" & ValidateSQL(sLogonUserName) & "'"

  set rsUserInfo = server.createobject("ADODB.Recordset")
  rsUserInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
  AddQuery(SQL)

  if not(rsUserInfo.EOF) then
     LastLogon=rsUserInfo("LastLogon")
     GetLastLogon = True
  else
     LastLogon = ""
     GetLastLogon = False
  end if
  rsUserInfo.Close
  set rsUserInfo = Nothing

end Function

Function DecodeTemplate(byref vUserInfo, byval sMessage)

  ' Description : Decodes a template message.  Used during new user registrations,
  '               when sending the welcome e-mail and optional welcome inbox message.

  sMessage = replace(sMessage, "%%username%%", vUserInfo(UI_Username), 1, -1, 1)
  sMessage = replace(sMessage, "%%password%%", vUserInfo(UI_Password), 1, -1, 1)
  sMessage = replace(sMessage, "%%adminemail%%", dictConfiguration("sADMINEMAIL"), 1, -1, 1)
  sMessage = replace(sMessage, "%%bbsname%%", dictConfiguration("sBBSNAME"), 1, -1, 1)
  sMessage = replace(sMessage, "%%bbsaddress%%", "http://" & sBBSPreferredDomain & sBBSForumRoot, 1, -1, 1)
  sMessage = replace(sMessage, "%%inboxmax%%", dictConfiguration("iMAXINBOXCOUNT"), 1, -1, 1)
  sMessage = replace(sMessage, "%%realname%%", vUserInfo(UI_RealName), 1, -1, 1)
  sMessage = replace(sMessage, "%%email%%", vUserInfo(UI_EmailAddr), 1, -1, 1)
  sMessage = replace(sMessage, "%%vcode%%", vUserInfo(UI_VCode), 1, -1, 1)

  DecodeTemplate = sMessage

end Function


  function UserExistsbyID(byRef iMemberID)
    ' DESCRIPTION : Checks to see if a user exists in the system
    ' INPUTS      : iMemberID - MemberID
    ' RETURNS     : True or False

    dim vUserInfo
    vUserInfo = GetUserInfobyID(iMemberID)
    if vUserInfo(UI_MemberID) = -1 then
      UserExistsbyID = False
    else
      UserExistsbyID = True
    end if
  end function

  function UserExists (byref sInfoUsername)
    UserExists = UserExistsByID(GetMemberID(sInfoUsername))
  end function

  function UserExistsbyName(byref sInfoUsername)
    UserExistsbyName = UserExistsByID(GetMemberID(sInfoUsername))
  end function

  function GetComplexVariable(byref iVariable)
    ' DESCRIPTION : Some values are too computationaly intentsive to be worthwhile
    '             : to generate whether they're needed or not.  This function
    '             : will calculate some of those values on demand (and cache them)
    ' INPUTS      : iVariable - Which complex variable should be returned
    ' RETURNS     : The result of the calculation.

    dim SQL, rsStatistics, sKey

    sKey = "COMPLEX-" & iVariable
    if dictComplexVariables.exists(sKey) then
      iBBSCachedHits = iBBSCachedHits + 1
      GetComplexVariable = dictComplexVariables.item(sKey)
      exit function
    end if

    set rsStatistics = server.createobject("ADODB.Recordset")

    ' Only calculate these values if the current user is registered
    if iBBSLogonType = US_Registered then
      if iVariable = CV_NewInbox then
        SQL = "select count(*) as newmessages from private where messageread=0 and toname='" & ValidateSQL(sBBSUsername) & "'"
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = rsStatistics.fields(0).value
      elseif iVariable = CV_OldInbox then
        SQL = "select count(*) as newmessages from private where messageread=1 and toname='" & ValidateSQL(sBBSUsername) & "'"
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = rsStatistics.fields(0).value
      elseif iVariable = CV_InboxTotal then
        SQL = "select count(*) as newmessages from private where toname='" & ValidateSQL(sBBSUsername) & "'"
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = rsStatistics.fields(0).value
      elseif iVariable = CV_OutboxTotal then
        SQL = "select count(*) as newmessages from private where messageread=0 and fromname='" & ValidateSQL(sBBSUsername) & "'"
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = rsStatistics.fields(0).value
      end if
    end if

    ' Only calculate these values if the current user is a moderator or higher
    if iVariable = CV_BadPostAlerts then
      if BBS.GetUserLevel(MODULE_Forums, -1) >= USERLEVEL_Moderator then
        SQL = "select count(*) as newalerts from alerts where approved=0 and type=" & ALERT_BadPost
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = ValidateNumeric(rsStatistics.fields(0).value)
      end if
    end if

    ' Only calculate if post validation is on and we have permission to
    if iVariable = CV_NewPostAlerts then
      if (dictConfiguration.item("bFORCEPOSTVALIDATION") = 1 and BBS.GetUserLevel(MODULE_Forums, -1) >= USERLEVEL_Moderator) then
        SQL = "select count(*) as newalerts from alerts where approved=0 and type=" & ALERT_NewPost
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = ValidateNumeric(rsStatistics.fields(0).value)
      end if
    end if

    ' Only calculate if we can edit user details
    if iVariable = CV_NewUserAlerts then
      if BBS.HasPermission(PERM_admineditusers, -1) then
        SQL = "select count(*) as newalerts from alerts where approved=0 and type=" & ALERT_NewUser
        rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
        AddQuery(SQL)
        GetComplexVariable = ValidateNumeric(rsStatistics.fields(0).value)
      end if
    end if

    if iVariable = CV_OnlineUsers then
      SQL = "select count(*) as totalusers from online"
      rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      GetComplexVariable= rsStatistics.fields(0).value
    elseif iVariable = CV_OnlineRegisteredUsers then
      SQL = "select count(*) as totalusers from online where registered=1"
      rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      GetComplexVariable = rsStatistics.fields(0).value
    elseif iVariable = CV_OnlineGuestUsers then
      SQL = "select count(*) as totalusers from online where registered=0"
      rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      GetComplexVariable = ValidateNumeric(rsStatistics.fields(0).value)
    elseif iVariable = CV_SessionsToday then
      SQL = "select count(*) as userstoday from visitorhistory where logofftime >= " & sDateDelimiter & GetSQLDate(now) & sDateDelimiter
      rsStatistics.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      GetComplexVariable = ValidateNumeric(rsStatistics.fields(0).value)
    end if

    if rsStatistics.state <> 0 then rsStatistics.Close
    set rsStatistics = Nothing

    dictComplexVariables(sKey) = GetComplexVariable
  end function

  function GetUserList()
    dim SQL, vArray, rsInfo, index, sOutput
    set rsInfo = server.CreateObject("ADODB.RECORDSET")

    sOutput = BBS.Cache("USERLIST")
    if IsEmpty(sOutput) then
      SQL = "select memberid, username from members order by username asc"
      rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)
      if not rsInfo.eof then
        vArray = rsInfo.GetRows
        rsInfo.Close
        for index=0 to ubound(vArray, 2)
          vbString.append ("<option value='" & vArray(0, index) & "'>" & BBS.ValidateField(vArray(1, index)) & "</option>")
        next
        sOutput = vbString.ToString
        vbSTring.Clear
        CacheAdd "USERLIST", sOutput
        GetUserList = sOutput
      else
        vArray = -1
        rsInfo.close
      end if
    else
      iBBSCachedHits = iBBSCachedHits + 1
      GetUserList = sOutput
    end if
  end function

  function MemberHasPermission(byval iNewMemberID, byval iAction, byval sParameter1)
    dim vUserInfo
    vUserInfo = BBS.GetUserInfoByID(iNewMemberID)

    ' Change security context
    BBS.ChangeSecurityContext vUserInfo(UI_Username), vUserInfo(UI_Password)
    MemberHasPermission = HasPermission(iAction, sParameter1)

    ' Revert
    BBS.RevertSecurityContext
  end function


  function HasPermission(byref iAction, byref sParameter1)
    ' DESCRIPTION : Determines if a user has the ability to perform an action
    ' INPUTS      : iAction     - The action that is being attempted
    '             : sParameter1 - Expected value depends on the context of the action (may be optional)
    ' RETURNS     : True if granted, false otherwise
    '             : REFER TO SECURITY SPECS FOR MORE INFORMATION
    '             : USES THE CURRENT SECURITY CONTEXT

    dim iLogonType, iUserLevel, iAccessValue, iModule

    if iAction >= 0 and iAction <= 199 then
      iModule = MODULE_BBS
    elseif iAction >= 400 and iAction <= 599 then
      iModule = MODULE_Forums
    elseif iAction >= 700 and iAction <= 799 then
      iModule = MODULE_Quotes
    elseif iAction >= 800 and iAction <= 999 then
      iModule = MODULE_Calendars
    elseif iAction >= 1000 and iAction <= 1199 then
      iModule = MODULE_Albums
    end if

    ' Special condition, PERM_modeditmoderators and PERM_modeditspecialaccess exist in the BBS permission space but are shared for all modules
    ' WORK IN PROGRESS
    ' if iAction = PERM_modeditspecialaccess or iAction = PERM_modeditmoderators then

    '   iModule = sParameter1
    ' end if

    iLogonType = GetUserLevel(iModule, sParameter1)

    ' The PERM_ViewBBS permission is checked no matter what action we are performing
    if (iLogonType = USERLEVEL_Guest) and cInt(dictConfiguration.item("bGUESTSCANENTER")) = 0 then
      HasPermission = False
      exit function
    elseif iLogonType = USERLEVEL_InactiveBanned and cInt(dictConfiguration("bINACTIVEBANNEDCANENTER")) = 0 then
      HasPermission = False
      exit function
    end if

    ' If our permission is actually PERM_ViewBBS, then we've already validated the condition. Go ahead and exit now.
    if iAction = PERM_ViewBBS then
      HasPermission = True
      exit function
    end if




    if iAction >= 0 and iAction <= 199 then

      ' ===========================================
      ' BBS ADMINISTRATIVE FUNCTIONS 0-199 RESERVED
      ' ===========================================
      if iLogonType = USERLEVEL_GlobalAdministrator then
        ' Global admins always have access
        HasPermission = True
      elseif iLogonType = USERLEVEL_SupportAdministrator then
        ' Look up support administrator privelages
        iAccessValue = LookupPermission(MODULE_BBS, USERLEVEL_SupportAdministrator, iAction, sParameter1)
        if iAccessValue = 1 then
          HasPermission = True
        else
          HasPermission = False
        end if
      else
        ' Don't even bother lookup up a permission for a userlevel less than support administrator
        HasPermission = False
      end if

    elseif iAction >= 400 and iAction <= 599 then

      ' ================================
      ' FORUM FUNCTIONS 400-599 RESERVED
      ' ================================
      if iLogonType = USERLEVEL_GlobalAdministrator or iLogonType = USERLEVEL_SupportAdministrator then
        ' Global & support admins always have access inside a module
        HasPermission = True
      elseif iLogonType = USERLEVEL_ModuleAdministrator and (iAction >= 400 and iAction <= 499) then
        ' Module administrators automatically have permissions to all actions of moderators and below
        HasPermission = True
      else
        ' Look up privelages
        iAccessValue = LookupPermission(MODULE_Forums, iLogonType, iAction, sParameter1)

        if iAccessValue = 1 then
          HasPermission = True
        else
          HasPermission = False
        end if
      end if

    elseif iAction >= 800 and iAction <= 999 then

      ' =====================================
      ' CALENDAR PERMISSIONS 800-999 RESERVED
      ' =====================================

      if iLogonType >= USERLEVEL_SupportAdministrator then
        ' Global & support admins always have access inside a module
        HasPermission = True
      elseif iLogonType = USERLEVEL_ModuleAdministrator and (iAction >= 800 and iAction <= 899) then
        ' Module administrators automatically have permissions to all actions of moderators and below
        HasPermission = True
      else
        ' Look up privelages
        iAccessValue = LookupPermission(MODULE_Calendars, iLogonType, iAction, sParameter1)
        if iAccessValue = 1 then
          HasPermission = True
        else
          HasPermission = False
        end if
      end if


    elseif iAction >= 1000 and iAction <= 1999 then

      ' =====================================
      ' ALBUM PERMISSIONS 1000-1999 RESERVED
      ' =====================================

      if iLogonType >= USERLEVEL_ModuleAdministrator then
        ' Global & support admins always have access inside a module
        HasPermission = True
      else
        ' Look up privelages
        iAccessValue = LookupPermission(MODULE_Albums, iLogonType, iAction, sParameter1)
        if iAccessValue = 1 then
          HasPermission = True
        else
          HasPermission = False
        end if
      end if
    end if

  end function

  function GetUserLevel(byref iModule, byref iTarget)
    ' DESCRIPTION : Determines the maximum userlevel the member holds in a module/BBS
    ' INPUTS      : iModule  - A module constant
    ' INPUTS      : iTarget  - A target in the module (-1 if not applicable)
    ' RETURNS     : A userlevel constant
    ' NOTES       : . If iTarget is -1, then a global check is performed in that module
    '             : . Sometimes a module does not support a target!  Check design specs for the module
    '             : (For example: MODULE_BBS takes a -1 targetid)
    '             : . USES CURRENT SECURITY CONTEXT
    dim iBBSLevel, iModuleLevel, sKey, iUserLevel

    ' Users who are inactive/banned/badpassword/guests cannot achieve userlevels higher than inactive/guest
    if (iBBSLogonType = US_Banned) or (iBBSLogonType = US_Inactive) then
      GetUserLevel = USERLEVEL_InactiveBanned
      Exit Function
    elseif (iBBSLogonType = US_BadPassword) or (iBBSLogonType = US_NotRegistered) then
      GetUserLevel = USERLEVEL_Guest
      Exit Function
    end if

    sKey = "UL-" & iModule & "-" & iBBSMemberID & "-" & iTarget

    '  Debugging info (hope you don't need this)
    '  response.write sBBSUsername & "(" & iBBSMEmberID & ") has entered for module=" & iModule & " , target=" & iTarget & "<br/>"
    '  response.write "Key: " & sKey & "<br/>"
    '  response.write "Present in cache table? : " & cstr(not(IsEmpty(BBS.Cache(sKey)))) & "<br/>"
    '  response.write "Cache contents: " & BBS.Cache(sKey) & "<br/><br/>"

    iUserLevel = BBS.Cache(sKey)
    if not(IsEmpty(iUserLevel)) then
      GetUserLevel = iUserLevel
      iBBSCachedHits = iBBSCachedHits + 1
    else
      if iModule = MODULE_BBS then
        GetUserLevel = GetModuleuserlevel(MODULE_BBS, -1)
      else
        ' First check if the user is a BBS administrator, if not, then check the specific module
        if iBBSUserLevel >= Userlevel_SupportAdministrator then
          GetUserLevel = iBBSUserLevel
        else
          GetUserLevel = GetModuleuserlevel(iModule, iTarget)
        end if
      end if
      BBS.CacheAdd sKey, GetUserLevel
    end if
  end function

  function GetModuleuserlevel(byref iModule, byref iTarget)
    ' DESCRIPTION : Determines the maximum userlevel the member holds in a module
    ' INPUTS      : iModule  - A module constant
    ' INPUTS      : iTarget  - A target in the module
    ' RETURNS     : A userlevel constant
    ' NOTES       : . If iTarget is -1, then a global check is performed in that module
    '             : . You probably want to use GetUserLevel, not this function
    '             : . CHECK BBSUSERLEVEL FIRST!
    '             : . USES CURRENT SECURITY CONTEXT

    dim rsModuleLevel, SQLSingular, SQLGroup, iMemberRank, iGroupRank, iFinalRank, sKey
    sKey = "UL-" & iModule & "-" & iBBSMemberID & "-" & iTarget
    iMemberRank = 0 : iGroupRank = 0

      if iTarget = "-1" then
        ' Check all targets in the module
        SQLSingular = "select userlevel from userlevelmembers  where idtype=" & USERLEVEL_Member & " and id=" & ValidateNumeric(iBBSMemberID) & " and moduleid=" & ValidateNumeric(iModule) & " order by userlevel DESC"
        SQLGroup    = "select userlevel from userlevelmembers, groupmembers where userlevelmembers.idtype=" & USERLEVEL_Group & " and groupmembers.groupid=userlevelmembers.id and groupmembers.memberid=" & ValidateNumeric(iBBSMemberID) & " and moduleid=" & ValidateNumeric(iModule) & " order by userlevel DESC"
      else
        ' Check a specific target
        SQLSingular = "select userlevel from userlevelmembers  where idtype=" & USERLEVEL_Member & " and id=" & ValidateNumeric(iBBSMemberID) & " and (targetid=" & ValidateNumeric(iTarget) & " or targetid=-1) and moduleid=" & ValidateNumeric(iModule) & " order by userlevel DESC"
        SQLGroup    = "select userlevel from userlevelmembers, groupmembers where userlevelmembers.idtype=" & USERLEVEL_Group & " and groupmembers.groupid=userlevelmembers.id and groupmembers.memberid=" & ValidateNumeric(iBBSMemberID) & " and (targetid=" & ValidateNumeric(iTarget) & " or targetid=-1) and moduleid=" & ValidateNumeric(iModule) & " order by userlevel DESC"
      end if

      set rsModuleLevel= server.createobject("ADODB.Recordset")

      ' Debugging info
      ' response.write SQLSingular & "<br/>"
      ' response.write SQLGroup & "<br/>"
      ' response.flush

      rsModuleLevel.open SQLSingular, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQLSingular)
            if not(rsModuleLevel.EOF) then
        iMemberRank = rsModuleLevel.fields(0).value
      end if
      rsModuleLevel.Close

      rsModuleLevel.open SQLGroup, dbConnection, adOpenForwardOnly, adLockReadOnly
      BBS.AddQuery(SQLGroup)
      if not(rsModuleLevel.EOF) then
        iGroupRank = rsModuleLevel.fields(0).value
      end if
      rsModuleLevel.Close


      ' Debugging info
      ' response.write "<br/>Member rank: " & iMemberRank & "<br/>"
      ' response.write "Group rank: " & iGroupRank & "<br/>"

      iFinalRank = maximum(iMemberRank, iGroupRank)

      if iFinalRank > 0 then
        ' The user is in an mutable group (higher privilege than 'user')
        GetModuleUserLevel = iFinalRank
      else
        ' Return the user's logon type
        if iBBSLogonType = US_Registered then
          GetModuleUserLevel = USERLEVEL_User
        elseif iBBSLogonType = US_Inactive or iBBSLogonType = US_Banned then
          GetModuleUserLevel = USERLEVEL_InactiveBanned
        else
          GetModuleUserLevel = USERLEVEL_Guest
        end if
      end if
      set rsModuleLevel = Nothing
  end function

  function LookupPermission(byref iModuleID, byref iUserLevel, byref iPermRequest, byref iTargetID)
    ' DESCRIPTION : Looks up the permission for a userlevel in a given module/target
    ' INPUTS      : iModuleID    - The module
    '             : iUserLevel   - The userlevel
    '             : iPermRequest - The permission that we are querying
    '             : iTargetID    - The target inside the module (optional or set -1 for a global target search)
    ' RETURNS     : The access value of the request permission

    dim SQL, rsPermission, iAccessValue, sKey

    sKey = "LP-" & iModuleID & "-" & iUserLevel & "-" & iTargetID & "-" & iPermRequest
    if not(IsEmpty(BBS.Cache(sKey))) then
      LookupPermission = BBS.Cache(sKey)
      iBBSCachedHits = iBBSCachedHits + 1
    else
      set rsPermission = server.createobject("ADODB.Recordset")
      SQL = "select accessvalue from permissions where moduleid=" & ValidateNumeric(iModuleID) & " and userlevel=" & ValidateNumeric(iUserLevel) & " and permission=" & ValidateNumeric(iPermRequest)
      if iTargetID <> -1 then
        SQL = SQL & " and targetid=" & ValidateNumeric(iTargetID)
      end if

      rsPermission.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      AddQuery(SQL)

      if rsPermission.EOF then
        LookupPermission = 0
      else
        LookupPermission = rsPermission.fields(0).value
      end if

      BBS.CacheAdd sKey, LookupPermission
      rsPermission.Close
      set rsPermission = Nothing
    end if

  end function

  function SetPermission(byref iModuleID, byref iUserlevel, byref iTargetID, byref iPermission, byref iValue)
    ' DESCRIPTION : Sets a permission in the database
    ' INPUTS      : Permission parameters

    dim sKey
    sKey = "LP-" & iModuleID & "-" & iUserLevel & "-" & iTargetID & "-" & iPermission

    ' First clear the way
    SQL = "delete from permissions where moduleid=" & ValidateNumeric(iModuleID) & " and userlevel=" & ValidateNumeric(iUserLevel)
    SQL = SQL & " and permission=" & ValidateNumeric(iPermission) & " and targetid=" & ValidateNumeric(iTargetID)


    dbConnection.Execute SQL,, adTextNoRecords
    AddQuery(SQL)

    ' Add the permission
    if ValidateNumeric(iValue) <> 0 then
      SQL = "insert into permissions (moduleid, userlevel, targetid, permission, accessvalue) VALUES("
      SQL = SQL & ValidateNumeric(iModuleID) & ", " & ValidateNumeric(iUserLevel) & ", " & ValidateNumeric(iTargetID)
      SQL = SQL & ", " & ValidateNumeric(iPermission) & ", " & ValidateNumeric(iValue) & ")"
      dbConnection.execute SQL,, adTextNoRecords
      AddQuery(SQL)

    end if
    BBS.CacheDelete(sKey)

  end function

  function GenerateChoiceBox(byref iModuleID, byref iUserlevel, byref iTargetID, byref iPermission, byref iType)
    ' DESCRIPTION : Generates an HTML dropdown box for setting a permission
    ' INPUTS      : iModuleID  - The module ID
    '             : iUserLevel - The userlevel
    '             : iPermission- Permission ID
    '             : iType      - A ChoiceBox constant
    ' RETURNS     : HTML configuration box

    dim sFormFragment, sYesChecked, sNoChecked

    if iType = TYPE_DROPDOWN then

      if LookupPermission(iModuleID, iUserLevel , iPermission, iTargetID) = 1 then
        sYesChecked = " selected "
      else
        sNoChecked = " selected "
      end if
      sFormFragment= "<select class='bbsdropdownbox' name='" & iModuleID & "|" & iUserLevel & "|" & iTargetID &  "|" & iPermission &"'><option " & sYesChecked & " value='1'>" & dictLanguage("GLOBAL-YES") & "</option><option " & sNoChecked & " value='0'>" & dictLanguage("GLOBAL-NO") & "</option></select>"
    elseif iType = TYPE_TEXT then
      sFormFragment = "<input type='text' size='3' maxlength='5' class='bbstextbox' name='" & iModuleID & "|" & iUserLevel & "|" & iTargetID &  "|" & iPermission & "' value='" & ValidateField(LookupPermission(iModuleID, iUserLevel , iPermission, iTargetID)) & "'>"
    end if

    GenerateChoiceBox = sFormFragment
  end function

  function GenerateBBSConfigurationBox(byref sConfigItem, byref iType, byref sFormList)
    ' DESCRIPTION : Generates an HTML dropdown box for setting a bbs configuration option
    ' INPUTS      : sPermission - The bbs configuration option
    ' OUTPUTS     : sFormList - a comma delimted list of all previously generated options
    ' RETURNS     : HTML configuration box

    dim sFormFragment, sYesChecked, sNochecked

    if iType = TYPE_DROPDOWN then
      if validateNumeric(dictConfiguration.item(sConfigItem)) = 1 then
        sYesChecked = " selected "
      else
        sNoChecked = " selected "
      end if

      sFormFragment= "<select class='bbsdropdownbox' name='" & sConfigItem & "'><option " & sYesChecked & " value='1'>" & dictLanguage("GLOBAL-YES") & "</option><option " & sNoChecked & " value='0'>" & dictLanguage("GLOBAL-NO")& "</option></select>"
    elseif iType = TYPE_TEXT then
      sFormFragment = "<input type='text' size='15' maxlength='100' class='bbstextbox' name='" & sConfigItem & "' value='" & ValidateField(dictConfiguration.item(sConfigItem)) & "'>"
    end if

    if len(sFormList ) = 0 then
      sFormList = sConfigItem
    else
      sFormList = sFormList & "," & sConfigItem
    end if

    GenerateBBSConfigurationBox = sFormFragment

  end function

  sub RipPermissionTokens(byref sToken, byref iRipModuleID, byref iRipUserlevel, byref iRipTargetID, byref iRipPermissionID)
    ' DESCRIPTION : Dissassembles the tokens created by GenerateChoiceBox
    ' OUTPUTS     : iRipModuleID, iRipUserlevel, iRipTargetID, iRipPermissionID  - The tokens

    dim vTokens
    vTokens = split(sToken, "|")

    if isArray(vTokens) then
      if ubound(vTokens) = 3 then
        iRipModuleID    = ValidateNumeric(vTokens(0))
        iRipUserLevel   = ValidateNumeric(vTokens(1))
        iRipTargetID    = ValidateNumeric(vTokens(2))
        iRipPermissionID= ValidateNumeric(vTokens(3))
      end if
    end if
  end sub

  function CopyUserlists(byref iModuleID, byref iSourceTarget, byref iDestTarget)
    ' DESCRIPTION : Copies members and group userlevels from one target in a module to another
    ' INPUTS      : iModuleID - A module ID. Since not all modules take targets, this only makes sense to use to copy within a module
    ' RETURNS     : True if successful, false otherwise
    ' NOTES       : Clears items from the cache as well
    dim SQL, vUserList, sCacheKey, rsUserList, sKey, index, iUpperBound
    set rsUserList = server.createobject("ADODB.Recordset")
    sKey = "UL-" & iModuleID & "-" & iDestTarget & "-"

    ' Delete from the destination forum
    SQL = "delete from userlevelmembers where moduleid=" & ValidateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iDestTarget)
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)

    ' Get a list of the source's members
    SQL = "select userlevel, id, idtype from userlevelmembers where moduleid=" & ValidateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iSourceTarget)
    rsUserList.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
    AddQuery(SQL)

    if not(rsUserList.EOF) then
      vUserList = rsUserList.GetRows
      rsUserList.Close
      iUpperBound = UBOUND(vUserList, 2)

      for index=0 to iUpperBound
        SQL = "insert into userlevelmembers (moduleid, userlevel, id, targetid, idtype) VALUES"
        SQL = SQL & "(" & ValidateNumeric(iModuleID) & ", " & ValidateNumeric(vUserList(0, index)) & ", " & ValidateNumeric(vUserList(1, index)) & ", "& ValidateNumeric(iDestTarget) & ", " & ValidateNumeric(vUserList(2, index)) & ")"
        dbConnection.execute SQL,, adTextNoRecords
        SQL = ""
      next
      AddQuery(SQL)
      CopyUserlists = True
    end if
    set rsUserList = Nothing
    BBS.CacheDeleteAll


  end function

  function CopyModulePermissions(byref iModuleID, byref iSourceTarget, byref iDestTarget)
    ' DESCRIPTION : Copies one target in a module's permissions to another target
    ' INPUTS      : iSourceTarget- The source target
    '             : iDestTarget  - The destination target
    '             : iModuleID    - The module in which the targets lie
    ' NOTES       : Only use this function for modules which use targets
    ' RETURNS     : True if successful

    dim rsPermList, SQL, vPermArray, index, iUpperBound
    set rsPermList = server.createobject("ADODB.Recordset")

    SQL = "select userlevel, permission, accessvalue from permissions where moduleid=" & validateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iSourceTarget)
    rsPermList.open SQL, dbConnection, adOpenForwardOnly, adlockReadOnly
    AddQuery(SQL)
    if not(rsPermList.EOF) then
      vPermArray = rsPermList.GetRows
      rsPermList.Close
      iUpperBound = UBOUND(vPermArray, 2)

      SQL = "delete from permissions where moduleid=" & validateNumeric(iModuleID) & " and targetid=" & ValidateNumeric(iDestTarget)
      dbConnection.execute SQL,, adTextNoRecords
      BBS.CacheDeleteAll
      for index = 0 to iUpperBound
        SetPermission iModuleID, vPermArray(0, index), iDestTarget, vPermArray(1, index), vPermArray(2, index)
      next
    else
      rsPermList.Close
    end if
    set rsPermList = Nothing
    CopyModulePermissions = True

  end function

  function AddEmoticon(byref sSource, byref sDestination)
    ' DESCRIPTION : Adds an emoticon
    ' INPUTS      : sSource      - The source emoticon text :)
    '             : sDestination - The image replacement
    ' RETURNS     : The newly created EmoticonID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into emoticons (source, emoticonimage) VALUES('" & SQLTrim(ValidateRegEX(sSource), 20) & "', '" & SQLTrim(ValidateRegEX(sDestination), 50) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("EMOTICONS")

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      AddEmoticon = 0
    else
      AddEmoticon = clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewId = Nothing
  end function

  function DeleteEmoticon(byref iEmoticonID)
    ' DESCRIPTION : Deltes an emoticon
    ' INPUTS      : The Emoticon ID
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from emoticons where emoticonid=" & ValidateNumeric(iEmoticonID)
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("EMOTICONS")
    DeleteEmoticon = True
  end function

  function AddMBBSCode(byval sCode, byref sHTML, byval sCloseCode, byref sCloseHTML)
    ' DESCRIPTION : Adds an MBBS Code
    ' INPUTS      : The source MBBS code, source HTML, and closing tags
    ' RETURNS     : The newly created MBBSCode ID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    sCode = ValidateRegex(sCode)
    sCloseCode = ValidateRegex(sCloseCode)
    sCode = replace(sCode, "\{param\}", "{param}")
    sCloseCode = replace(sCloseCode, "\{param\}", "{param}")

    SQL = "insert into mbbscode (code,html,closecode,closehtml) VALUES('" & SQLTrim((sCode), 50) & "', '" & ValidateSQL(sHTML) & "', '" & SQLTrim((sCloseCode), 50) & "', '" & ValidateSQL(sCloseHTML) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("MBBSCODES")


    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      AddMBBSCode= 0
    else
      AddMBBSCode= clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewId = Nothing
  end function

  function DeleteMBBSCode(byref iCodeID)
    ' DESCRIPTION : Deltes an MBBSCode
    ' INPUTS      : The Code ID
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from mbbscode where codeid=" & ValidateNumeric(iCodeID)
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("MBBSCODES")
    DeleteMBBSCode = True
  end function

  function AddIPBan(byref sIP)
    ' DESCRIPTION : Adds an IP ban
    ' INPUTS      : The IP
    ' RETURNS     : The newly created Ban ID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into bannedips (ip) VALUES('" & SQLTrim(sIP, 15) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("BANNEDIPS")

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      AddIPBan= 0
    else
      AddIPBan= clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewId = Nothing

  end function

  function DeleteIPBan(byref iBanID)
    ' DESCRIPTION : Deltes an IP Ban
    ' INPUTS      : The Code ID
    ' RETURNS     : True if successful

    dim SQL

    SQL = "delete from bannedips where banid=" & ValidateNumeric(iBanID)
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("BANNEDIPS")

    DeleteIPBan= True
  end function

  function CreateEmailBan(byref sEmailDomain)
    ' DESCRIPTION : Adds an e-mail ban
    ' INPUTS      : The e-mail fragment
    ' RETURNS     : The newly created ban ID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into bannedemails (emailaddress) VALUES('" & SQLTrim(sEmailDomain, 50) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      CreateEmailBan= 0
    else
      CreateEmailBan= clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewID = Nothing
  end function

  function DeleteEmailBan(byref iBanID)
    ' DESCRIPTION : Deltes an MBBSCode
    ' INPUTS      : The Code ID
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from bannedemails where banid=" & ValidateNumeric(iBanID)
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    DeleteEmailBan= True
  end function

  function ToggleEmailConfig(byref sValue)
    ' DESCRIPTION : Toggles the configuration value of email-bans (either allow or deny all addresses from registring except the ones given
    ' INPUTS      : ALLOW or DENY
    ' RETURNS     : True if succesfull

    dim SQL, rsInfo
    set rsInfo = Server.CreateObject("ADODB.Recordset")

    SQL = "select * from bbsconfiguration where configname='bREGISTRATIONBANNEDEMAILS'"
    rsInfo.open SQL, dbConnection, adOpenstatic, adLockOptimistic
    AddQuery(SQL)
    if rsInfo.EOF then
      rsInfo.AddNew
      rsInfo.fields("configname") = "bREGISTRATIONBANNEDEMAILS"
    end if
    rsInfo.fields("configvalue").value = sValue
    rsInfo.Update
    dictConfiguration("bREGISTRATIONBANNEDEMAILS") = sValue
    ToggleEmailConfig = True
  end function

  function CreateFilteredWord(byref sWord, byref sReplacement)
    ' DESCRIPTION : Adds a filtered words
    ' INPUTS      : The word and the replacement
    ' RETURNS     : The newly created ban ID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")

    SQL = "insert into filteredwords (word, replacement) VALUES('" & SQLTrim(sWord, 100) & "', '" & SQLTrim(sReplacement, 100) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("FILTEREDWORDS")

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      CreateFilteredWord= 0
    else
      CreateFilteredWord= clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewId = Nothing
  end function

  function DeleteFilteredWord(byref iBanID)
    ' DESCRIPTION : Deltes a filtered word
    ' INPUTS      : The Code ID
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from filteredwords where wordid=" & ValidateNumeric(iBanID)
    BBS.CacheUnlock
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("FILTEREDWORDS")
    BBS.CacheUnlock

    DeleteFilteredWord= True
  end function

  function CreateDecoration(byref iPosts, byref sImageName)
    ' DESCRIPTION : Adds a decoration
    ' INPUTS      : The post count and the image name
    ' RETURNS     : The newly created decoration ID

    dim SQL, rsNewID
    set rsNewID = server.createobject("ADODB.Recordset")


    SQL = "insert into decorations (posts, imagename) VALUES(" & ValidateNumeric(iPosts) & ", '" & SQLTrim(sImageName, 200) & "')"
    dbConnection.execute SQL,,adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("DECORATIONS")

    SQL = "select @@identity"
    rsNewID.open SQL, dbConnection, adOpenForwardOnly, adLockReadONly
    AddQuery(SQL)
    if rsNewID.EOF then
      CreateDecoration= 0
    else
      CreateDecoration= clng(rsNewId.fields(0).value)
    end if
    rsNewID.Close
    set rsNewID = Nothing
  end function

  function DeleteDecoration(byref iDecorationID)
    ' DESCRIPTION : Deltes a decoration
    ' INPUTS      : The decoration id
    ' RETURNS     : True if successful

    dim SQL
    SQL = "delete from decorations where decorationid=" & ValidateNumeric(iDecorationID)
    BBS.CacheUnlock
    dbConnection.execute SQL,, adTextNoRecords
    AddQuery(SQL)
    BBS.CacheDelete("DECORATIONS")
    BBS.CacheUnlock

    DeleteDecoration= True
  end function

  function GetDBDateNull()
    ' DESCRIPTION : Returns the value for a null date value for the current database backend

    if ucase(sBBSDatabaseType) = "MSACCESS" then
      GetDBDateNull = "Null"
    elseif ucase(sBBSDatabaseType) = "MSSQL" then
      GetDBDateNull = "''"
    elseif ucase(sBBSDatabaseType) = "MYSQL" then
      GetDBDateNull = "''"
    end if

  end function

  function GetDBVersion
    on error resume next
    rsMaster.open "select * from dbconfigs", dbConnection, adOpenForwardOnly, adLockReadOnly
    if rsMaster.EOF then
      GetDBVersion = 0
      dBBSLastMaintenance = now
    else
      GetDBVersion = rsMaster.fields("bbsversion").value
    end if

    if Err.Number <> 0 then GetDBVersion = 1
    dBBSLastMaintenance = cdate(rsMaster.fields("lastmaintenance").value)
    if not isdate(dBBSLastMaintenance) then dBBSLastMaintenance = now
    bFooterUnlocked = ValidateBoolean(rsMaster.fields("footerunlocked").value)
    if IsBlank(bFooterUnlocked) then bFooterUnlocked = 0
    bFeaturesUnlocked = ValidateBoolean(rsMaster.fields("featuresunlocked").value)
    if IsBlank(bFeaturesUnlocked) then bFeaturesUnlocked = 0
    rsMaster.Close
    on error goto 0
  end function

  function EscapeDBField(byref sField)
    ' DESCRIPTION : Sometimes a field name will conflict with reserved keywords. This function delimits them properly
    if ucase(sBBSDatabaseType) = "MSACCESS" or ucase(sBBSDatabaseType) = "MSSQL" then
      EscapeDBField = "[" & sField & "]"
    elseif ucase(sBBSDatabaseType) = "MYSQL" then
      EscapeDBField = "`" & sField & "`"
    else
      EscapeDBField = sField
    end if
  end function

  function EscapeString(byref sField)
    ' DESCRIPTION: If a database needs to delimit a unicode field in a certain way, this function does it.

    if ucase(sBBSDatabaseType="MSSQL") then
      EscapeString = "N'" & ValidateSQL(sField) & "'"
    else
      EscapeString = "'" & ValidateSQL(sField) & "'"
    end if
  end function

  function EscapeStringTrim(byref sField, byval iLen)
    ' DESCRIPTION: If a database needs to delimit a unicode field in a certain way, this function does it.

    if ucase(sBBSDatabaseType="MSSQL") then
      EscapeString = "N'" & SQLTrim(sField, iLen) & "'"
    else
      EscapeString = "'" & SQLTrim(sField, iLen) & "'"
    end if
  end function

  sub AddQuery(byref SQL)
    ' DESCRIPTION : Adds a SQL statement to the SQL debugging list
    iBBSExecutedQueries = iBBSExecutedQueries + 1
    if dictConfiguration("bSQLLOG") = 1 then
      vbSqlLog.Append SQL & " (" & NiceNumber((timer - dBBSDebugTime)) & ")<br/>"
    end if
  end sub

  function DetectUploadComponent()

    ' DESCRIPTION : Checks for available upload components has been initialized correctly.
    dim objUpload

    on error resume next
    Set objUpload = Server.CreateObject("Dundas.Upload.2")
    if Err.Number = 0 then DetectUploadComponent = "DUNDAS"
    err.clear

    ' This is the default component if all else fails.
    if len(DetectUploadComponent) = 0 then DetectUploadComponent = "PUREASP"
    on error goto 0
    set objUpload = Nothing
  end function

  function GetExtension(byval sFileName)
    sFileName= lcase(sFileName)
    if right(sFileName, 4) = ".jpg" then
      GetExtension = "jpg"
    elseif right(sFileName, 4) = ".gif" then
      GetExtension = "gif"
    elseif right(sFileName, 4) = ".png" then
      GetExtension = "png"
    elseif right(sFileName, 4) = ".bmp" then
      GetExtension = "bmp"
    elseif right(sFileName, 5) = ".jpeg" then
      GetExtension = "jpeg"
    else
      GetExtension = ""
    end if
  end function

  function IsAllowed(byval sExt)
     sExt = lcase(sExt)

     if instr(sExt, "gif") > 0 or _
        instr(sExt, "jpg") > 0 or _
        instr(sExt, "png") > 0 or _
        instr(sExt, "bmp") > 0 or _
        instr(sExt, "jpeg") > 0 then

       IsAllowed = True
     else
       IsAllowed = False
     end if
  end function


  function GenerateVerificationCode()
    ' DESCRIPTION : Returns a random 6-digit verification code

    dim iCount, sCode

    randomize timer * rnd ^ rnd

    for iCount = 1 to 6
      sCode = sCode & int(((rnd * 10) * (rnd * 10)) / 10)
      randomize iCount * rnd ^ rnd
    next
    GenerateVerificationCode = sCode
  end function

  function CacheAdd(byref sKey, byval vCachedItem)
    if dictConfiguration("sCACHE") = "APPLICATION" then
      application.contents(sBBSCachePrefix & sKey) = vCachedItem
    elseif dictConfiguration("sCACHE") = "PAGE" then
      dictGeneralCache.item(sBBSCachePrefix & sKey) = vCachedItem
    else
      ' Do nothing
    end if
    CacheAdd = True
  end function

  function CacheDelete(byref sKey)
    on error resume next
    if dictConfiguration("sCACHE") = "APPLICATION" then
      Application.Contents.Remove(sBBSCachePrefix & sKey)
    elseif dictConfiguration("sCACHE") = "PAGE" then
      dictGeneralCache.remove(sBBSCachePrefix & sKey)
    else
      ' Do nothing
    end if
    CacheDelete = True
    on error goto 0
  end function

  function CacheDeleteType(byref sKey)
    dim iCount, vRemoveArray(), item, index, iGrowthSize

    iGrowthSize = 100

    if dictConfiguration("sCACHE") = "APPLICATION" then
      ' Deleting from the application object is a hassle.
      ' First iterate through and find all objects that match the prefix.
      ' Then go back through and delete them.

      ' Get a list of application items present
      redim preserve vRemoveArray(iGrowthSize)
      iCount = -1

      for each item in application.contents
        if left(item, len(sBBSCachePrefix & sKey)) = sBBSCachePrefix & sKey then
          iCount = iCount + 1
          if ubound(vRemoveArray) <= iCount then
            redim preserve vRemoveArray(iCount + iGrowthSize)
          end if
          vRemoveArray(iCount) = item
        end if
      next

      ' Now delete them
      if iCount > -1 then
        for index=0 to ubound(vRemoveArray)
          application.contents.remove(vRemoveArray(index))
        next
      end if
    End If
    CacheDeleteType = True
  end function

  function Cache(byref sKey)
    if dictConfiguration("sCACHE") = "APPLICATION" then
      cache = Application.Contents(sBBSCachePrefix & sKey)
    elseif dictConfiguration("sCACHE") = "PAGE" then
      cache = dictGeneralCache.item(sBBSCachePrefix & sKey)
    else
      ' Do nothing
    end if
  end function

  function CacheDeleteAll()
    dim item, index, iCount, vRemoveArray(), iGrowthSize

    iGrowthSize = 250

    if dictConfiguration("sCACHE") = "APPLICATION" then
      ' Deleting from the application object is a hassle.
      ' First iterate through and find all objects that match the prefix.
      ' Then go back through and delete them.

      ' Get a list of application items present
      redim preserve vRemoveArray(iGrowthSize)
      iCount = -1
      for each item in application.contents
        if left(item, len(sBBSCachePrefix)) = sBBSCachePrefix then
          iCount = iCount + 1
          if ubound(vRemoveArray) <= iCount then
            redim preserve vRemoveArray(iCount + iGrowthSize)
          end if
          vRemoveArray(iCount) = item
        end if
      next

      ' Now delete them
      if iCount > -1 then
        for index=0 to iCount
          application.contents.remove(vRemoveArray(index))
        next
      end if

      ' application.contents.removeall

    elseif dictConfiguration("sCACHE") = "PAGE" then
      dictConfiguration.removeall
    end if
    CacheDeleteAll = True
  end function

  function CacheLock()
    if dictConfiguration("sCACHE") = "APPLICATION" then Application.Lock
  end function

  function CacheUnlock()
    if dictConfiguration("sCACHE") = "APPLICATION" then Application.Unlock
  end function

  function RunMaintenance()
    dim SQL, rsInfo, dStartDate, dFinalDate, dStopDate
    set rsInfo = server.createobject("ADODB.Recordset")

    ' Reset the value in dbconfig
    ' You might think this would be better placed at the end of RunMaintenance,
    ' but if a fatal error occurs during the routine, we don't want to lock the user out of their
    ' bbs permanently!  Let's be safe and put it here. If an error occurs, we'll track it down later.
    SQL = "update dbconfigs set lastmaintenance=" & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter
    dbConnection.execute SQL

    ' First let's clear out the visitor history
    if clng(dictConfiguration("iPURGEHISTORYDAYS")) > 0 then
      ' Get the last date in visitor history. Delete values by month otherwise connections may time out on very large tables
      SQL = "select min(logofftime) from visitorhistory"
      rsInfo.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
      if not(rsInfo.EOF) then
        dStopdate = rsInfo.fields(0).value
      end if
      rsInfo.Close

      if IsDate(dStopDate) then

        dStartDate = dateadd("D", -1 * clng(dictConfiguration("iPURGEHISTORYDAYS")), now)

        do until dStartDate < dStopDate
          dFinalDate = dateadd("D", -30, dStartDate)
          SQL = "delete from visitorhistory where logofftime <" & sDateDelimiter & BBS.GetSQLDate(dStartDate) & sDateDelimiter & " and logofftime >=" & sDateDelimiter & BBS.GetSQLDate(dFinalDate) & sDateDelimiter
          dbConnection.execute SQL
          BBS.AddQuery(SQL)
          dStartDate = dateadd("D", -30, dStartDate)
        loop

      end if
    end if

  end function

  function GetFileList(byref sPath)
    ' DESCRIPTION : Returns an alphabetized list of all files in a folder

    dim FSO, fsoFolder, fsoFile, iFileCount, vResults(), index, OuterIndex, InnerIndex, sTemp

    on error resume next

    set fso = CreateObject("Scripting.fileSystemObject")
    set fsoFolder = fso.getFolder(sPath)
    iFileCount = fsoFolder.files.count
    index = 0

    redim vResults(iFileCount-1)

    for each fsoFile in fsoFolder.files
        vResults(index) = lcase(fsoFile.name)
        index=index+1
    next

    ' Alphabetize
    for OuterIndex = 0 to iFileCount-1
      for InnerIndex = (OuterIndex+ 1) to iFileCount-1
        if strComp(vResults(outerindex),vResults(innerindex),0)=1 then
          sTemp = vResults(outerindex)
          vResults(OuterIndex) = vResults(innerindex)
          vResults(InnerIndex) = sTemp
        end if
      next
    next

    on error goto 0

    GetFileList = vResults
  end Function

  Function GetRichTextConstructor()
    dim sRichEdit

    if dictConfiguration("bFULLPLUGINSMCE") = 1 then
        sRichEdit = "<script language='javascript' type='text/javascript' src='" & sBBSForumRoot & "/jscripts/tiny_mce/tiny_mce.js'></script>" & _
        "<script language='javascript' type='text/javascript'>" & CRLF & _
        "tinyMCE.init({" & CRLF & _
        "mode : ""textareas""," & CRLF & _
        "theme : ""advanced""," & CRLF & _
        "elements : ""messagebody""," & CRLF & _
        "plugins : ""table,save,advhr,advimage,advlink,emotions,iespell,insertdatetime,preview,zoom,searchreplace,print""," & CRLF & _
        "theme_advanced_buttons1_add_before : ""save,separator""," & CRLF & _
        "theme_advanced_buttons1_add : ""fontselect,fontsizeselect""," & CRLF & _
        "theme_advanced_buttons2_add : ""separator,insertdate,inserttime,preview,zoom,separator,forecolor,backcolor""," & CRLF & _
        "theme_advanced_buttons2_add_before: ""cut,copy,paste,separator,search,replace,separator""," & CRLF & _
        "theme_advanced_buttons3_add_before : ""tablecontrols,separator""," & CRLF & _
        "theme_advanced_buttons3_add : ""emotions,flash,advhr,separator,print""," & CRLF & _
        "theme_advanced_toolbar_location : ""top""," & CRLF & _
        "theme_advanced_toolbar_align : ""left""," & CRLF & _
        "theme_advanced_path_location : ""bottom""," & CRLF & _
        "content_css : ""example_full.css""," & CRLF & _
        "plugin_insertdate_dateFormat : ""%Y-%m-%d""," & CRLF & _
        "plugin_insertdate_timeFormat : ""%H:%M:%S""," & CRLF & _
        "extended_valid_elements : ""a[name|href|target|title|onclick],img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name],hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]""," & CRLF
        if len(dictLanguage("GLOBAL-EDITORLANGUAGE")) > 0 then
          sRichEdit = sRichEdit & "language : """ & dictLanguage("GLOBAL-EDITORLANGUAGE") & """," & CRLF
        end if
        sRichEdit = sRichEdit & "external_link_list_url : ""example_link_list.js""," & CRLF & _
        "external_image_list_url : ""example_image_list.js""," & CRLF & _
        "flash_external_list_url : ""example_flash_list.js""});" & CRLF & _
        "</script>" & CRLF
    else
        sRichEdit = "<script language='javascript' type='text/javascript' src='" & sBBSForumRoot & "/jscripts/tiny_mce/tiny_mce.js'></script>" & _
        "<script language='javascript' type='text/javascript'>" & CRLF & _
        "tinyMCE.init({" & CRLF & _
        "mode : ""textareas""," & CRLF & _
        "theme : ""advanced""," & CRLF & _
        "elements : ""messagebody""," & CRLF & _
        "plugins : ""advlink,advhr,iespell,searchreplace""," & CRLF & _
        "theme_advanced_buttons1_add : ""fontselect,fontsizeselect,zoom""," & CRLF & _
        "theme_advanced_buttons2_add : ""separator,insertdate,inserttime,preview,zoom,forecolor,backcolor""," & CRLF & _
        "theme_advanced_buttons2_add_before: ""cut,copy,paste,separator,search,replace,separator""," & CRLF & _
        "theme_advanced_buttons3_add : ""advhr,separator,""," & CRLF & _
        "theme_advanced_toolbar_location : ""top""," & CRLF & _
        "theme_advanced_toolbar_align : ""left""," & CRLF & _
        "theme_advanced_path_location : ""bottom""," & CRLF
        if len(dictLanguage("GLOBAL-EDITORLANGUAGE")) > 0 then
          sRichEdit = sRichEdit & "language : """ & dictLanguage("GLOBAL-EDITORLANGUAGE") & """," & CRLF
        end if
        sRichEdit = sRichEdit & "extended_valid_elements : ""a[name|href|target|title|onclick],img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name],hr[class|width|size|noshade],font[face|size|color|style],span[class|align|style]""});" & CRLF & _
        "</script>"
    end if

    GetRichTextConstructor = sRichEdit

  end Function

END CLASS

dim vbString, vbSqlLog
set vbString = new StringBuilder
set vbSqlLog = new StringBuilder

Class StringBuilder
  Dim arr, growthrate, itemcount

  Private Sub Class_Initialize()
    growthRate = 50
    itemCount = 0
    ReDim arr(growthRate)
  End Sub

  Public Sub Append(ByVal strValue)
    If itemCount > UBound(arr) Then
      ReDim Preserve arr(UBound(arr) + growthRate)
    End If

    arr(itemCount) = strValue
    itemCount = itemCount + 1
  End Sub

  Public Function ToString()
    ToString = Join(arr, "")
  End Function

  Public Function Clear()
    redim arr(growthRate)
    itemCount = 0
  end Function
End Class
%>