<%@ Page Language="VB" Debug="true"%>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Data.OleDb" %>
<%@ Import Namespace="System.Data.Odbc" %>
<%@ import namespace="System.Drawing" %>
<%@ import namespace="System.Drawing.Imaging" %>
<%@ import namespace="System.IO" %>
<script runat="server">
Function NewthumbSize(byval currentwidth as Integer, byval currentheight as Integer, byval iWidth as Integer)
  try
  ' Calculate the Size of the New image
  dim tempMultiplier as Double
  if currentheight > currentwidth then ' portrait
    tempMultiplier = iWidth / currentheight
  Else
    tempMultiplier = iWidth / currentwidth
  end if
  dim NewSize as New Size(CInt(currentwidth * tempMultiplier), CInt(currentheight * tempMultiplier))
  return NewSize
  catch
  end try
End Function

Sub sendError()
  try
  ' if no height, width, src then output "error"
  dim imgOutput as New bitmap(100, 100, pixelformat.format24bpprgb)
  dim g as graphics = graphics.fromimage(imgOutput) ' create a New graphic object from the above bmp
  g.clear(color.yellow) ' blank the image
  g.drawString("ERROR!", New font("verdana",14,fontstyle.bold),systembrushes.windowtext, New pointF(5,10))
  g.drawString("Photo does", New font("verdana",10,fontstyle.bold),systembrushes.windowtext, New pointF(5,40))
  g.drawString("not exists", New font("verdana",10,fontstyle.bold),systembrushes.windowtext, New pointF(5,60))
  ' Set the contenttype
  response.contenttype="image/gif"

  ' send the resized image to the viewer
  imgOutput.save(response.outputstream, imageformat.gif) ' output to the user

  ' tidy up
  g.dispose()
  imgOutput.dispose()
  catch
  end try
end sub
</script>

<!-- #Include File="..\database\constants.asp" -->
<%

  server.scripttimeout = 20

  'Extract the ID out of the URL
  Dim imgid as String   = Request.QueryString("photoid")
  dim iWidth as Integer = clng(request.querystring("width"))
  dim sAlbumPath, sFullFile, sGUID, SQLText as String

  Dim g as System.Drawing.Image
  Dim imgFull As System.Drawing.Image
  dim imgOutput as Bitmap
  dim ici as ImageCodecInfo
  dim codec as ImageCodecInfo
  Dim myDSN
  Dim MyCommand
  Dim dr


  If imgid="" or not(isnumeric(imgid)) Then
    Call SendError()
    Response.End
  End If

  if not(isnumeric(iwidth)) or iWidth=0 then iWidth=150

  ' Does the thumbnail exist on the filesystem?
  ' Thanks to the GDI+ FAQ for help with this section of code
  ' http://www.bobpowell.net/jpeg_compression.htm
  '
  sAlbumPath = server.mappath(sBBSForumRoot & "/photos/uploads") & "/"

  if File.Exists(sAlbumPath & imgid & "t.jpg") then
    ' A thumbnail exists? Redirect to it!
    response.redirect (sBBSForumRoot & "/photos/uploads" & "/" & imgid & "t.jpg" )
  end if

  ' A thumbnail doesn't exist. Let's see if the fullfile exists and make a thumbnail out of it.
  ' First, prepare the codec that will generate a low quality thumbnail
  dim codecs() as ImageCodecInfo
  codecs = ImageCodecInfo.GetImageEncoders()
  for each codec in codecs
    if codec.MimeType ="image/jpeg" then
      ici=codec
    end if
  next


  dim ep as new EncoderParameters()
  ep.Param(0) = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality,60)

  ' Get the FileGUID
  sqlText = "select fileguid from photos where PhotoID=" & imgid

  If ucase(sBBSDatabaseType) = "MYSQL" Then
    myDSN = New OdbcConnection(sConnString)
    MyCommand = New OdbcCommand(sqlText, myDSN)
  else
    myDSN = New OleDbConnection(sConnString)
    MyCommand = New OleDbCommand(sqlText, myDSN)
  end if

  Try
    myDSN.Open()
    dr = MyCommand.ExecuteReader()
    If dr.Read()
      sGUID = dr(0)
    else
      sGUID = ""
    end if
  catch
    sGUID = ""
  end try
  dr.Close()
  myDSN.Close()

  sFullFile = ""
  ' Does the full file exist on the filesystem?
  if File.Exists(sAlbumPath & sGUID) then
    sFullFile = (sAlbumPath & sGUID)

  elseif File.Exists(sAlbumPath & imgid & "f.jpg") then
    sFullFile = (sAlbumPath & imgid & "f.jpg")

  elseif File.Exists(sAlbumPath & imgid & "f.gif") then
    sFullFile = (sAlbumPath & imgid & "f.gif")

  elseif  File.Exists(sAlbumPath & imgid & "f.png") then
    sFullFile = (sAlbumPath & imgid & "f.png")

  elseif  File.Exists(sAlbumPath & imgid & "f.bmp") then
    sFullFile = (sAlbumPath & imgid & "f.bmp")

  elseif  File.Exists(sAlbumPath & imgid & "f.jpeg") then
    sFullFile = (sAlbumPath & imgid & "f.jpeg")
  end if


  if sFullFile <> "" then
    ' A file is on the filesystem. Let's create a thumbnail

    if File.Exists(sFullFile) then
      try
        ' Generate a thumbnail
         imgFull = System.Drawing.Image.FromFile(sFullFile)

         g = imgFull
         dim thisFormat=g.rawformat
         dim thumbSize as New size
         if g.width > iwidth then
          thumbSize=NewthumbSize(g.width,g.height,iWidth)
         else
          thumbsize= new size(g.width, g.height)
         end if
         imgOutput = New Bitmap(g, thumbSize.width, thumbSize.height)

         ' Set the contenttype
         response.contenttype="image/jpeg"
         sFullFile = server.mappath(sBBSForumRoot & "/photos/uploads") & "/" & imgid & "t.jpg"
         imgOutput.save(sFullFile,ici,ep) ' output to the user

         imgFull.dispose()
         g.dispose()
         imgOutput.dispose()

         response.redirect (sBBSForumRoot & "/photos/uploads" & "/" & imgid & "t.jpg" )
      catch
      end try

    Else
      Call SendError()
      Response.End
    End If


  else
    ' Not stored in the filesystem. It must be in the database.

    sqlText = "select picture, fullfile from photos where PhotoID =" & imgid

    response.expires = 360000

    If ucase(sBBSDatabaseType) = "MYSQL" Then
      myDSN = New OdbcConnection(sConnString)
      MyCommand = New OdbcCommand(sqlText, myDSN)
    else
      myDSN = New OleDbConnection(sConnString)
      MyCommand = New OleDbCommand(sqlText, myDSN)
    end if

    Try
      myDSN.Open()
      dr = MyCommand.ExecuteReader()
    catch
    end try

    Try
        If dr.Read()
          Dim bytImage(DR(0).length - 1) As Byte
          bytImage = DR(0)
          'Create the mememorystream object and fill it with the byte array
          Dim memStream As New IO.MemoryStream(bytImage)
          'Fill the big image
          imgFull = System.Drawing.Image.FromStream(memStream)
          g = imgFull
          dim thisFormat=g.rawformat
          dim thumbSize as New size
          if g.width > iwidth then
            thumbSize=NewthumbSize(g.width,g.height,iWidth)
          else
            thumbsize= new size(g.width, g.height)
          end if
          imgOutput = New Bitmap(g, thumbSize.width, thumbSize.height)

          ' Set the contenttype
          Response.AddHeader ("Content-Disposition", "attachment;")
          response.contenttype="image/jpeg"
          imgOutput.save(response.outputstream, ici, ep) ' output to the user

          imgFull.dispose()
          g.dispose()
          imgOutput.dispose()
        Else
          Call SendError()
          Response.End
        End If
    Catch
    End Try

    dr.Close()
    myDSN.Close()

  end if
%>