<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-albums.asp"-->
<% sBBSLangPage = "albums"
   BBS.SetupBBS
   BBS.SetScheme(0)

   dim iAlbumID, vAlbumInfo, vPhotoInfo, SQL, sOutput, iModuleUserlevel, bCanEdit

   ' Check for permission
   if not(BBS.HasPermission(PERM_ViewBBS, -1)) then response.redirect sBBSForumRoot & "/logon.asp?error=needregistration"
   if not(BBS.HasPermission(PERM_AlbumView, -1)) then response.redirect sBBSForumRoot & "/restricted-page.asp"

   if dictConfiguration("bENABLEPHOTOALBUMS") = 0 then response.redirect "../category-view.asp"

   iAlbumID = request.querystring("albumid")
   vAlbumInfo = Albums.GetAlbumInfo(iAlbumID)
   if vAlbumInfo(AI_AlbumID) < 0 then response.redirect "photo-main.asp"
   iModuleUserlevel = BBS.GetUserlevel(MODULE_Albums, -1)

   ' Get photo information
   vPhotoInfo = Albums.GetPhotoInfo(request.querystring("photoid"))

   ' Something isn't right. Mismatching albumid and photoid
   if vPhotoInfo(PI_AlbumID) <> vAlbumInfo(AI_AlbumID) then response.redirect "photo-main.asp"

   ' Get the previous and next photoid, if available
   SQL = "select photoid from photos where albumid=" & BBS.ValidateNumeric(vPhotoInfo(PI_AlbumID)) & " order by photoid asc"
   rsMaster.open SQL, dbConnection, adOpenStatic, adLockReadOnly
   if not rsMaster.BOF then
     rsMaster.find "photoid=" & BBS.ValidateNumeric(request.querystring("photoid"))
     rsMaster.MovePrevious
     if rsMaster.BOF then
        rsMaster.MoveNext
        dictEnvironment("C-BACK") = 0
     else
        dictEnvironment("C-BACK") = 1
        dictEnvironment("C-BACKID") = rsmaster.fields("photoid").value
        rsMaster.MoveNext
     end if

     rsMaster.MoveNext
     if rsMaster.EOF then
        rsMaster.MovePrevious
        dictEnvironment("C-NEXT") = 0
     else
       dictEnvironment("C-NEXT") = 1
       dictEnvironment("C-NEXTID") = rsmaster.fields("photoid").value
     end if
   end if
   rsMaster.Close

   bCanEdit = (ucase(sBBSUsername) = ucase(vAlbumInfo(AI_Username))) or iModuleUserLevel >= USERLEVEL_Moderator

   Albums.IncreaseViewCount(vPhotoInfo(PI_PhotoID))

   if request("action") = "postcomment" then
     ' Post a comment
     if (iModuleUserLevel >= USERLEVEL_User and vAlbumInfo(AI_AllowUserComments) = 1) or (iModuleUserLevel < USERLEVEL_User and vAlbumInfo(AI_AllowGuestComments) = 1) then
       SQL = "insert into photocomments (photoid, username, comment, registered, dateposted) values("
       SQL = SQL & vPhotoInfo(PI_PhotoID) & ","
       if iModuleUserLevel >= USERLEVEL_User then
         SQL = SQL & "'" & BBS.ValidateSQL(sBBSUsername) & "',"
       else
         SQL = SQL & "'" & dictLanguage("GLOBAL-GUEST") & "',"
       end if
       SQL = SQL & "'" & BBS.ValidateSQL(BBS.FilterPost(request.form("comment"))) & "',"
       SQL = SQL & BBS.ValidateBoolean(iBBSMemberID > 0) & ","
       SQL = SQL & sDateDelimiter & BBS.GetSQLDateTime(now) & sDateDelimiter & ")"
       dbConnection.Execute SQL
       BBS.AddQuery(SQL)
     end if
     vAlbumInfo(AI_CommentCount) = Albums.GetNumberOfAlbumComments(vAlbumInfo(AI_AlbumID))
     Albums.EditAlbum(vAlbumInfo)
   end if

   if request("action") = "deletecomment" then
     SQL = "select * from photocomments where commentid=" & BBS.ValidateNumeric(request.querystring("commentid"))
     rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockOptimistic
     BBS.AddQuery(SQL)
     if not rsMaster.EOF then
       if ucase(vAlbumInfo(AI_Username)) = ucase(sBBSUsername) or _
          (rsMaster.fields("registered")=1 and ucase(rsMaster.fields("username")) = ucase(sBBSUsername)) or _
          (iModuleUserLevel >= USERLEVEL_MODERATOR) then

          ' delete the comment
          SQL = "delete from photocomments where commentid=" & BBS.ValidateNumeric(request.querystring("commentid"))
          dbConnection.execute SQL
          BBS.AddQuery(SQL)
       end if
     end if
     rsMaster.Close
     vAlbumInfo(AI_CommentCount) = Albums.GetNumberOfAlbumComments(vAlbumInfo(AI_AlbumID))
     Albums.EditAlbum(vAlbumInfo)
   end if

   ' Get the comments list
   if vAlbumInfo(AI_AllowUserComments) = 1 and iBBSUserLevel >= USERLEVEL_User or (vAlbumInfo(AI_AllowGuestComments)=1 and iBBSUserLevel < USERLEVEL_User) then
     dictEnvironment("C-SHOWCOMMENTS") = 1
     SQL = "select * from photocomments where photoid=" & BBS.ValidateNumeric(vPhotoInfo(PI_PhotoID)) & " order by dateposted asc"
     rsMaster.open SQL, dbConnection, adOpenForwardOnly, adLockReadOnly
     sOutput = "<table cellspacing='" & dictTemplate("CELLSPACING") & "' width='100%' class='bbstable'><tr><td class='messagecellheader'>" & dictLanguage("ALBUMS-COMMENTS") & "</td></tr>"
     do until rsMaster.EOF

       sOutput = sOutput & "<tr><td class='messagecellbody'>"
       if rsMaster.fields("registered") = 1 then
         sOutput = sOutput & dictLanguage("ALBUMS-COMMENTBY") & ": " & BBS.CreateUsernameLinkbyName(rsMaster("username").value) & BBS.ValidateField(rsMaster("username").value) & "</a> (" & BBS.GetShortDateTime(rsMaster.fields("dateposted").value) & ")<br/>"
       else
         sOutput = sOutput & dictLanguage("ALBUMS-COMMENTBY") & ": " & BBS.ValidateField(rsMaster("username").value) & " (" & rsMaster.fields("dateposted").value & ")<br/>"
       end if
       sOutput = sOutput & BBS.MBBSDecode(rsMaster.fields("comment"), 0)

       ' If the user owns this album, owns this comment, or is a moderator. Let them delete the comment.
       if ucase(vAlbumInfo(AI_Username)) = ucase(sBBSUsername) or _
          (rsMaster.fields("registered")=1 and ucase(rsMaster.fields("username")) = ucase(sBBSUsername)) or _
          (iModuleUserLevel >= USERLEVEL_MODERATOR) then
          sOutput = sOutput & "<div align='right'><a href='show-album.asp?commentid=" & BBS.ValidateNumeric(rsMaster.fields("commentid")) & "&amp;albumid=" & vAlbumInfo(AI_AlbumID) & "&amp;photoid=" & vPhotoInfo(PI_PhotoID) & "&amp;action=deletecomment'>" & dictLanguage("GLOBAL-DELETE") & "</div>"
       end if
       sOutput = sOutput & "</td></tr>"
       rsMaster.Movenext
     loop
     rsMaster.Close
     sOutput = sOutput & "</table>"
     dictENvironment("V-COMMENTS") = sOutput
     sOutput = ""
   else
     dictEnvironment("C-SHOWCOMMENTS") = 0
   end if

   'Create the comments form
   if dictEnvironment("C-SHOWCOMMENTS") = 1 then
     dictEnvironment("C-SHOWCOMMENTSFORM") = 1
     sOutput = "<form method='post' action='show-album.asp?photoid=" & vPhotoInfo(PI_PhotoID) & "&amp;albumid=" & vAlbumInfo(AI_AlbumID) & "&amp;action=postcomment'>" & dictLanguage("ALBUMS-POSTCOMMENT") & "<br/>"
     sOutput = sOutput & "<textarea class='bbstextbox' name='comment' cols='50' rows='5'></textarea><br/><input type='submit' class='bbsbutton' value='" & dictLanguage("GLOBAL-SUBMIT") & "'></form>"
     dictEnvironment("V-COMMENTSFORM") = sOutput
     sOutput = ""
   else
     dictEnvironment("C-SHOWCOMMENTS") = 0
   end if

   dictEnvironment("V-PHOTOINFO") = vPhotoInfo
   dictEnvironment("V-ALBUMINFO") = vAlbumInfo
   dictEnvironment("V-ALBUMOWNERID") = BBS.GetUserInfo(vAlbumInfo(AI_Username))(UI_MemberID)
   dictEnvironment("U-RETURNLINK")   = "photo-thumbnails.asp?albumid=" & dictEnvironment("V-ALBUMINFO")(AI_AlbumID) & "&amp;useralbum=" & dictEnvironment("V-ALBUMOWNERID")
   dictEnvironment("U-PHOTOLINK")    = sBBSBaseURL & sBBSForumRoot & "/photos/get-photo.asp?photoid=" & dictEnvironment("V-PHOTOINFO")(PI_PhotoID)

   if bCanEdit then
     dictEnvironment("C-SHOWEDIT") = 1
     dictEnvironment("U-EDITLINK")   = "image-edit.asp?albumid=" & dictEnvironment("V-ALBUMINFO")(AI_AlbumID) & "&amp;photoid=" & dictEnvironment("V-PHOTOINFO")(PI_PhotoID)
     dictEnvironment("U-DELETELINK") = "image-edit.asp?albumid=" & dictEnvironment("V-ALBUMINFO")(AI_AlbumID) & "&amp;photoid=" & dictEnvironment("V-PHOTOINFO")(PI_PhotoID)
   else
     dictEnvironment("C-SHOWEDIT") = 0
   end if

   dictEnvironment.add "V-TITLE", dictLanguage.item("ALBUMS-TITLE")
   dictEnvironment.add "C-SHOWRANDOMQUOTES", dictConfiguration("bDISPLAYBBSQUOTES")
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1
%>


<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/photos/show-album.asp") %>
<!-- #include file="../includes/footer.asp" -->


