<%@ CodePage=65001 Language="VBScript"%>
<% Option Explicit %>
<!-- #include file="../includes/include.asp"-->
<!-- #include file="../includes/include-forums.asp"-->
<!-- #include file="../includes/include-polls.asp"-->
<!-- #include file="../includes/include-alerts.asp"-->
<% sBBSLangPage = "create-poll"
   BBS.SetupBBS

   dim iForumID, vForumInfo, vCategoryInfo, vMessageInfo, vThreadInfo, vUserInfo, bIsPreview, sAction
   dim vPollInfo, iPollID, vOptionInfo, index, SQL, bHasError, bCanPostHTML, sRichEdit, bEditorChange
   dim bHasPoll

   ' Capture some important variables used in the processing of the page
   iForumID      = BBS.ValidateNumeric(request.querystring("fid"))
   vForumInfo    = Forum.GetForumInfo(iForumID)
   vCategoryInfo = BBS.GetCategoryInfo(vForumInfo(FI_CategoryID))
   vThreadInfo   = Forum.GetThreadInfoStruct()
   vUserInfo     = BBS.GetUserInfobyID(iBBSMemberID)
   bIsPreview    = BBS.ValidateBoolean(request.form("preview")=dictLanguage("GLOBAL-PREVIEW"))
   bEditorChange = BBS.ValidateBoolean((request.form("editorchange")=dictLanguage("POLL-23")) or (request.form("editorchange")=dictLanguage("POLL-24")))
   sAction       = request.form("action")
   bHasError     = False
   BBS.SetScheme(vCategoryInfo(CA_CategoryID))
   bCanPostHTML  = BBS.HasPermission(PERM_forumposthtml, vForumInfo(FI_ForumID))

   ' Check for access to the forum
   if vForumInfo(FI_ForumID) < 1 then response.redirect sBBSForumRoot & "/category-view.asp"
   if not(BBS.HasPermission(PERM_FORUMACCESS, vForumInfo(FI_ForumID))) then response.redirect sBBSForumRoot & "/restricted-page.asp"
   if not(BBS.HasPermission(PERM_forumcreatepoll, vForumInfo(FI_ForumID))) then response.redirect sBBSForumRoot & "/restricted-page.asp"

   ' Set default values, template variables, set up template conditionals, etc
   dictEnvironment("C-SHOWSIGCHECKED")       = vUserInfo(UI_UseSignature)
   dictEnvironment("SHOWDISABLEHTMLCHECKED") = 0
   dictEnvironment("C-SHOWLINEBREAKSCHECKED")= BBS.BooleanNot(vUserInfo(UI_UseRichEdit))
   dictEnvironment("C-SHOWANONYMOUSCHECKED") = 0
   dictEnvironment.add("V-FORUM"), vForumInfo
   dictEnvironment.add("V-CATEGORY"), vCategoryInfo
   dictEnvironment.add("U-FORMACTION"), sBBSForumRoot & "/pollbooth/create-poll.asp?fid=" & vForumInfo(FI_ForumID)
   dictEnvironment.add("V-POSTACTION"), "create"
   dictEnvironment.add("V-USER"), vUserInfo
   dictEnvironment.add "C-SHOWPREVIEW", bIsPreview

   dictEnvironment.add "C-SHOWSIG", BBS.ValidateBoolean(iBBSMemberID > -1)
   dictEnvironment.add "C-SHOWDISABLEHTML", BBS.ValidateBoolean(bCanPostHTML)
   dictEnvironment.add "C-SHOWLINEBREAKS", dictEnvironment("C-SHOWDISABLEHTML")
   dictEnvironment.add "C-SHOWANONYMOUS", vForumInfo(FI_AnonymousAllowed)
   dictEnvironment.add "C-SHOWEMOTICONS", vForumInfo(FI_Emoticons)
   dictEnvironment.add "C-SHOWATTACH", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumattach, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-ISGUEST", BBS.ValidateBoolean(iBBSMemberID = -1)
   dictEnvironment.add "C-SHOWSTICKY", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumsticky, vForumInfo(FI_ForumID)))
   dictEnvironment.add "C-SHOWFREEZE", BBS.ValidateBoolean(BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)))
   dictEnvironment.add "U-FORUMLINK", sBBSForumRoot & "/forums/forum-view.asp?fid=" & vForumInfo(FI_ForumID)
   dictEnvironment.add "U-CATEGORYLINK", sBBSForumRoot & "/category-view.asp"
   dictEnvironment.add "U-CATEGORYLINKALL", sBBSForumRoot & "/category-view.asp?action=showall"
   dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vUserInfo(UI_UseSignature))
   dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = ""
   dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(BBS.BooleanNot(vUserInfo(UI_UseRichEdit)))
   dictEnvironment("C-SHOWANONYMOUSCHECKED")   = ""
   dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(1)
   vMessageInfo = Forum.GetMessageInfoStruct()

   if (BBS.LookupPermission(MODULE_FORUMS, USERLEVEL_Guest, PERM_forumvotepoll, vForumInfo(FI_ForumID))) = 1 then
     dictEnvironment.add "C-SHOWUNREGISTEREDCANVOTE",1
   else
     dictEnvironment.add "C-SHOWUNREGISTEREDCANVOTE",0
   end if

   dictEnvironment.add "C-SHOWRANDOMQUOTES", vForumInfo(FI_ShowQuotes)
   if iBBSUserLevel >= USERLEVEL_SupportAdministrator then dictEnvironment.add "C-SHOWADMINLINK", 1

   ' Which editor to use
   if bEditorChange = 1 then
     ' We have only just changed
     if (BBS.ValidateBoolean(request.form("editorchange")=dictLanguage("POLL-23")) = 1) and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=1"
     elseif BBS.ValidateBoolean(request.form("editorchange")=dictLanguage("POLL-24")) = 1 then
       dictEnvironment.add "C-USERICHEDIT", 0
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=0"
     end if

   elseif not isempty(request.querystring("richedit")) then
     ' Changed earlier and passed on in the querystring
     if (BBS.ValidateNumeric(request.querystring("richedit")) = 1) and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=1"
     elseif BBS.ValidateNumeric(request.querystring("richedit")) = 0 then
       dictEnvironment.add "C-USERICHEDIT", 0
       dictEnvironment.item("U-FORMACTION") = dictEnvironment.item("U-FORMACTION") & "&richedit=0"
     end if

   else
     ' Decide from the preferences of the user
     if dictEnvironment("V-USER")(UI_UseRichEdit) = 1 and bCanPostHTML then
       dictEnvironment.add "C-USERICHEDIT", 1
     else
       dictEnvironment.add "C-USERICHEDIT", 0
     end if
   end if

   if dictEnvironment("C-USERICHEDIT") = 1 then
     dictEnvironment.item("C-EXTRAHEADTAG") = BBS.GetRichTextConstructor()
   end if



   if request.form("action") = "create" then

     dictEnvironment("C-SHOWSIGCHECKED")         = BBS.IsChecked(vUserInfo(UI_UseSignature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED") = ""
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")  = BBS.IsChecked(BBS.BooleanNot(vUserInfo(UI_UseRichEdit)))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")   = ""
     dictEnvironment("C-SHOWEMOTICONSCHECKED")   = BBS.IsChecked(1)

     ' Get the poll data
     vPollInfo = Polls.GetPollInfoStruct()
     if (BBS.LookupPermission(MODULE_FORUMS, USERLEVEL_Guest, PERM_forumvotepoll, vForumInfo(FI_ForumID))) = 1 then
       vPollInfo(PI_UnregisteredCanVote) = BBS.ValidateBoolean(request.form("unregisteredcanvote"))
       vPollInfo(PI_UnregisteredCanAddOptions) = BBS.ValidateBoolean(request.form("unregisteredcanaddoptions"))
     else
       vPollInfo(PI_UnregisteredCanVote) = 0
       vPollInfo(PI_UnregisteredCanAddOptions) = 0
     end if
     vPollInfo(PI_RegisteredCanAddOptions) = BBS.ValidateBoolean(request.form("registeredcanaddoptions"))
     vPollInfo(PI_DisplayNames) = BBS.ValidateBoolean(request.form("displaynames"))
     vPollInfo(PI_Closed)       = 0
     vPollInfo(PI_Multivoting)  = BBS.ValidateBoolean(request.form("multivoting"))
     vPollInfo(PI_hideresults)  = BBS.ValidateBoolean(request.form("hideresults"))

     ' Create the anchor thread
     vThreadInfo(TI_ForumID)      = vForumInfo(FI_ForumID)
     vThreadInfo(TI_TotalPosts)   = 1
     vThreadInfo(TI_DateCreated)  = now
     vThreadInfo(TI_LastActivity) = vThreadInfo(TI_DateCreated)
     vThreadInfo(TI_Subject)      = BBS.ValidateField(BBS.FilterPost(request.form("subject")))
     if len(vThreadInfo(TI_Subject)) = 0 and bEditorChange = 0 then
       bHasError = True
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POLL-NEEDSUBJECT") & "<br/>"
     end if

     vThreadInfo(TI_TimesViewed)  = 0

     if (vForumInfo(FI_AnonymousAllowed) = 1) and (request.form("anonymous") = "1") and (iBBSLogonType >= US_Inactive) then
       vThreadInfo(TI_Anonymous)  = 1
     else
       vThreadInfo(TI_Anonymous)  = 0
     end if

     if BBS.HasPermission(PERM_forumfreeze, vForumInfo(FI_ForumID)) then
       vThreadInfo(TI_Closed)     = request.form("freeze")
     else
       vThreadInfo(TI_Closed)     = 0
     end if

     if BBS.HasPermission(PERM_forumsticky, vForumInfo(FI_ForumID)) then
       vThreadInfo(TI_Sticky)     = request.form("sticky")
     else
       vThreadInfo(TI_Sticky)     = 0
     end if
     vThreadInfo(TI_HasPoll)      = 1
     vThreadInfo(TI_HasAttachment)= 0
     vThreadInfo(TI_LastPosterAnonymous)    = vThreadInfo(TI_Anonymous)
     vThreadInfo(TI_LastPosterMemberID)     = iBBSMemberID
     vThreadInfo(TI_LastPosterIsRegistered) = BBS.ValidateBoolean(iBBSMemberID > -1)
     vThreadInfo(TI_LastPosterGuestName)    = request.form("guestname")
     vThreadInfo(TI_MemberID)     = iBBSMemberID
     vThreadInfo(TI_IsRegistered) = vThreadInfo(TI_LastPosterIsRegistered)
     vThreadInfo(TI_GuestName)    = request.form("guestname")
     vThreadInfo(TI_Approved) = BBS.validateBoolean(vUserInfo(UI_OkToPost)=1 or iBBSUserLevel >= USERLEVEL_SupportAdministrator or dictConfiguration("bFORCEPOSTVALIDATION") = 0)
     if iBBSMemberID > 0 then
       vThreadInfo(TI_GuestName) = sBBSUsername
       vThreadInfo(TI_LastPosterGuestName) = sBBSUsername
     end if

     ' Create the message
     vMessageInfo = Forum.GetMessageInfoStruct()
     vMessageInfo(MI_InReplyTo) = -1
     vMessageInfo(MI_Subject)   = vThreadInfo(TI_Subject)
     vMessageInfo(MI_Body)      = BBS.FilterPost(request.form("messagebody"))
     if not(bCanPostHTML) or (request.form("disablehtml") = 1) then
       vMessageInfo(MI_Body)    = BBS.ValidateField(vMessageInfo(MI_Body))
       vMessageInfo(MI_FilterHTML) = 1
     else
       vMessageInfo(MI_FilterHTML) = 0
     end if

     if (len(trim(vMessageInfo(MI_Body))) = 0 or trim(vMessageInfo(MI_Body)) = "<br />" & CRLF) and bEditorChange = 0 then
       bHasError = True
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POLL-NEEDBODY") & "<br/>"
     end if

     ' check if the user is flooding
     if Forum.IsFlooding() = 1 then
       bHasError = true
       dictEnvironment("V-ERROR") = dictEnvironment("V-ERROR") & dictLanguage("POST-FLOODING-1") & Forum.GetFloodLimit(iBBSMemberID) & dictLanguage("POST-FLOODING-2")
     end if

     if vUserInfo(UI_UseRichEdit) =1 and bCanPostHTML then vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "")

     if BBS.ValidateBoolean(request.form("filtercrlf")) = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "")
     elseif BBS.ValidateBoolean(request.form("filtercrlf")) = 0 and bEditorChange = 1 then
       vMessageInfo(MI_Body) = replace(vMessageInfo(MI_Body), crlf, "<br />")
     end if

     vMessageInfo(MI_Hostname)    = request.servervariables("REMOTE_HOST")
     vMessageInfo(MI_Anonymous)   = vThreadInfo(TI_Anonymous)
     vMessageInfo(MI_DatePosted)  = vThreadInfo(TI_DateCreated)
     vMessageInfo(MI_MessageIcon) = -1
     vMessageInfo(MI_Emoticons)   = request.form("emoticons")
     vMessageInfo(MI_ReplyOrder)  = 0
     vMessageInfo(MI_ReplyLevel)  = 0
     if (iBBSMemberID > -1) then
       vMessageInfo(MI_Signature) = request.form("signature")
     else
       vMessageInfo(MI_Signature) = 0
     end if
     vMessageInfo(MI_LastEditedName)  = ""
     vMessageInfo(MI_LastEditedDate)  = vThreadInfo(TI_DateCreated)
     vMessageInfo(MI_Edited)          = 0
     vMessageInfo(MI_HasAttachment)   = 0
     vMessageInfo(MI_IsRegistered)    = BBS.ValidateBoolean(iBBSMemberID > -1)
     vMessageInfo(MI_MemberID)        = iBBSMemberID
     vMessageInfo(MI_GuestName)       = vThreadInfo(TI_GuestName)
     if len(trim(vMessageInfo(MI_Guestname))) = 0 then vMessageInfo(MI_Guestname) = dictLanguage("GLOBAL-GUEST")
     vMessageInfo(MI_ForceLineBreaks) = request.form("forcelinebreaks")
     vMessageInfo(MI_Approved)        = vThreadInfo(TI_Approved)

     dictEnvironment("C-SHOWSIGCHECKED")           = BBS.IsChecked(vMessageInfo(MI_Signature))
     dictEnvironment("C-SHOWDISABLEHTMLCHECKED")   = BBS.IsChecked(vMessageInfo(MI_FilterHTML))
     dictEnvironment("C-SHOWLINEBREAKSCHECKED")    = BBS.IsChecked(vMessageInfo(MI_ForceLineBreaks))
     dictEnvironment("C-SHOWANONYMOUSCHECKED")     = BBS.IsChecked(vMessageInfo(MI_Anonymous))
     dictEnvironment("C-SHOWEMOTICONSCHECKED")     = BBS.IsChecked(vMessageInfo(MI_Emoticons))
     dictEnvironment("C-REGISTEREDCANADDOPTIONS")  = BBS.IsChecked(request.form("registeredcanaddoptions"))
     dictEnvironment("C-MULTIVOTING")              = BBS.IsChecked(request.form("multivoting"))
     dictEnvironment("C-HIDERESULTS")              = BBS.IsChecked(request.form("hideresults"))
     dictEnvironment("C-UNREGISTEREDCANVOTE")      = BBS.IsChecked(request.form("unregisteredcanvote"))
     dictEnvironment("C-UNREGISTEREDCANADDOPTIONS")= BBS.IsChecked(request.form("unregisteredcanaddoptions"))
     dictEnvironment("C-DISPLAYNAMES")             = BBS.IsChecked(request.form("displaynames"))


     if bIsPreview = 0 and bEditorChange = 0 and bHasError = False then
       ' Create the poll if any options were submitted
       bHasPoll = False
       for index=1 to 20
         if len(trim(request.form("option"&index))) > 0 then
           bHasPoll = True
         end if
       next

       if bHasPoll then
         iPollID = Polls.CreatePoll(vPollInfo)

         ' Add all the options
         vOptionInfo = Polls.GetOptionInfoStruct()
         vOptionInfo(OI_PollID)     = iPollID
         vOptionInfo(OI_MemberID)   = iBBSMemberID
         vOptionInfo(OI_Registered) = BBS.ValidateBoolean(iBBSMemberID > 0)
         vOptionInfo(OI_Guestname)  = request.form("guestname")
         for index=1 to 20
          if len(trim(request.form("option"&index))) > 0 then
            vOptionInfo(OI_Description) = BBS.FilterPost(trim(request.form("option"&index)))
            Polls.CreateOption(vOptionInfo)
          end if
         next
       end if



       ' Create the thread and get the newly created Thread ID
       if bHasPoll then
         vThreadInfo(TI_PollID)    = iPollID
       else
         vThreadInfo(TI_PollID)    = -1
         vThreadInfo(TI_HasPoll)   = 0
       end if
       vThreadInfo(TI_ThreadID)  = Forum.CreateThread(vThreadInfo)
       vMessageInfo(MI_ThreadID) = vThreadInfo(TI_ThreadID)
       vMessageInfo(MI_MessageID) = Forum.CreateMessage(vMessageInfo)

       ' Create a new post alert if appropriate
       if vMessageInfo(MI_Approved) = 0 then
         dim vAlertInfo
         vAlertInfo = Alerts.GetAlertInfoStruct()
         vAlertInfo(AL_Type)      = ALERT_NewPost
         vAlertInfo(AL_MessageID) = vMessageInfo(MI_MessageID)
         vAlertInfo(AL_MemberID)  = iBBSMemberID
         vAlertInfo(AL_Approved)  = 0
         vAlertInfo(AL_Reported)  = now()
         Alerts.CreateAlert(vAlertInfo)
       end if

       ' Update the seed & last post
       SQL = "update threads set lastpostid=" & vMessageInfo(MI_MessageID) & ", seed=" & vMessageInfo(MI_MessageID) & " where threadid=" & vThreadInfo(TI_ThreadID)
       dbConnection.execute SQL

       ' Update lastactive thread, postcounts, threadcounts in the forum object.
       ' Normally we would just use Forum.UpdateLastActiveThread, but speed is critical here
       SQL = "update forums set lastactivethread=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID)) & ", threadcount=threadcount+1, postcount=postcount+1 where forumid=" & vForumInfo(FI_ForumID) & ";"
       dbConnection.execute SQL,, adTextNoRecords
       BBS.AddQuery(SQL)
       BBS.CacheDelete "FI-" & vForumInfo(FI_ForumID)

       if iBBSMemberID > -1 then Forum.OffsetUserPostcount iBBSMemberID, 1
       response.redirect sBBSForumRoot & "/forums/thanks.asp?tid=" & BBS.ValidateNumeric(vThreadInfo(TI_ThreadID))
     else

       ' Get array of option information structures so we can create a preview of the poll
       dim iOptionCount
       iOptionCount = 0
       redim vOptionInfo(0)
       for index=1 to 20
         if len(trim(request.form("option"&index))) > 0 then
           vOptionInfo(iOptionCount)                 = Polls.GetOptionInfoStruct()
           vOptionInfo(iOptionCount)(OI_MemberID)    = iBBSMemberID
           vOptionInfo(iOptionCount)(OI_Registered)  = BBS.ValidateBoolean(iBBSMemberID > 0)
           vOptionInfo(iOptionCount)(OI_Guestname)   = request.form("guestname")
           vOptionInfo(iOptionCount)(OI_Description) = BBS.FilterPost(trim(request.form("option"&index)))
           redim preserve vOptionInfo(ubound(vOptionInfo) + 1)
           iOptionCount = iOptionCount + 1
         end if
       next
       redim preserve vOptionInfo(ubound(vOptionInfo) - 1)

       ' Generate previews
       dictEnvironment.add "V-POLLPREVIEW", Polls.PreviewPoll(vPollInfo, vOptionInfo, vThreadInfo(TI_Subject))
       dictEnvironment.add "V-POSTPREVIEW", Forum.GenerateMessage (vMessageInfo, vForumInfo, vThreadInfo, vUserInfo, 1)
     end if
   end if

   dictEnvironment.add "V-TITLE", dictLanguage.item("POLL-TITLE")
   dictEnvironment.add "V-MESSAGEINFO", vMessageInfo
   dictEnvironment("V-EMOTICONLIST") = Forum.GenerateEmoticonBox

   if (dictConfiguration("bENABLESPELLCHECKER") = 1) and (bFeaturesUnlocked = 1) and (instr(request.servervariables("HTTP_USER_AGENT"), "MSIE") > 0) then
     dictEnvironment("C-ENABLESPELLCHECKER") = 1
     dictEnvironment("U-SPELLCHECKOBJECT")    = sBBSForumRoot & "/registered/wspellam.cab#version=5,15,0,0"
     dictEnvironment("U-SPELLCHECKOBJECTLPK") = sBBSForumRoot & "/registered/wspell.lpk"
   end if


%>

<!-- #include file="../includes/header.asp" -->
<% Filesystem.ExecuteBBSTemplate("/pollbooth/create-poll.asp") %>
<!-- #include file="../includes/footer.asp"-->