<?php
error_reporting(0);
define('IN_PAIPAI',true);
$baseDir = dirname(__FILE__);
$errors = array();
$dbConf = $baseDir.'/paipai/code/conf/standard/db.conf.php';
if(!is_file($dbConf))
{
	if(!is_file($dbConf.'.sample'))
	{
		$errors[]	= '没有找到数据库配置文件，安装无法继续，请重新上传安装';
	}
	else
	{
		if(!rename($dbConf.'.sample',$dbConf))
		{
			$errors[]	= '重命名数据库配置文件出错，请手工修改'.$dbConf.'.sample'.'文件名为'.$dbConf.'后再安装';
		}
	}
}
if (version_compare(PHP_VERSION, '6.0.0-dev', '<') && get_magic_quotes_gpc())
{
	$in = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
	while (list ($k, $v) = each($in))
	{
		foreach ($v as $key => $val)
		{
			if (! is_array($val))
			{
				$in[$k][$key] = stripslashes($val);
				continue;
			}
			$in[] = &$in[$k][$key];
		}
	}
	unset($in);
}

$projDir	= $baseDir . '/paipai/code/';

if(version_compare(PHP_VERSION, '5.2.0', '<'))
{
	//版本检测
	$errors[]	= '您的服务器PHP版本低于5.2.0，安装程序无法继续，请升级PHP版本到5.2.0以上';
}

if(!function_exists('scandir') && (!function_exists('opendir') || !function_exists('readdir')))
{
	//scandir检测
	$errors[]	= '您的服务器PHP屏蔽了scandir方法的使用，安装程序无法继续，请在php.ini中将scandir方法从disable_functions中去除';
}

//检查临时目录是否可以创建子目录
$tmpDir		= $projDir.'tmp/test/test/';
if(!is_dir($tmpDir))
{
	if(!mkdir($tmpDir,0777,true))
	{
		$errors[]	= '你的服务器不支持创建临时目录，安装程序无法继续，请联系空间商修改目录操作权限';
	}
}

//检查临时目录是否可写
if(!is_file("$tmpDir/write_test.txt"))
{
	if($fp = @fopen("$tmpDir/write_test.txt", 'w'))
	{
		@fclose($fp);
	}
	else
	{
		$errors[]	= '你的服务器不支持创建临时文件，安装程序无法继续，请联系空间商修改目录操作权限';
	}
}

if(is_file($projDir."tmp/install.lock"))
{
	$errors[]	= '你已经安装过程序，如果想重新安装，请先删除paipai/code/tmp目录下的install.lock文件';
}

if(!empty($errors))
{
	$p			= strpos($_SERVER['SCRIPT_NAME'], 'install.php');
	$baseurl	= substr($_SERVER['SCRIPT_NAME'], 0, $p);
	include($projDir.'view/install/layout/error.php');
	exit;
}

date_default_timezone_set('Etc/GMT-8');

$lotusHome = $baseDir.'/paipai/framework/';

include $lotusHome . 'runtime/Lotus.php';

$lotus = new Lotus();

$lotus->option['proj_dir'] = $projDir;

$lotus->option['app_dir'] = $baseDir . '/paipai/code/app/';

$lotus->option['app_name'] = 'install';

$lotus->option['load_function'] = true;
$lotus->option['runtime_filemap'] = true;

$lotus->devMode = false;

$lotus->init();

