<?php
class AdminResetAction extends PiscesAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'password';
	}

	public function execute()
	{
		if(!C('LtConfig')->get('password.reset'))
		{
			$this->data['message'] = "无权访问,如果你要重置管理员密码，请手动修改配置文件，开启密码重置功能，方法：将paipai\code\conf\standard\setting.conf.php中\$config['password.reset'] = false;修改为\$config['password.reset'] = true;";
		}
		else
		{
			$password = C('CommonFunction')->random(6,1);
			$adminService = new AdminService();
			$user = $adminService->get(1);
			if($user)
			{
				$adminService->updateUserPassword($user['id'], $password, $user['secques']);
				if($this->disableReset())
				{
					$this->data['message'] = '新的密码：'.$password.",请用该密码进行登录，登录后请尽快修改密码";
				}
				else
				{
					$this->data['message'] = '新的密码：'.$password.",请用该密码进行登录，登录后请尽快修改密码，注意关闭配置中的管理员密码重置功能：paipai\code\conf\standard\setting.conf.php中\$config['password.reset'] = true;修改为\$config['password.reset'] = false;";
				}
			}
			else
			{
				$this->data['message'] = '重置密码出错';
			}
		}
	}
	
	private function disableReset()
	{
		$confBaseDir	= substr(dirname(__FILE__), 0, strrpos(__FILE__, "app")).'conf/standard/';
		$confFile		= $confBaseDir.'setting.conf.php';
		
		$content = file_get_contents($confFile);
		$content = str_replace('$config[\'password.reset\'] = true;', '$config[\'password.reset\'] = false;', $content);
		
		$length = file_put_contents($confFile, $content);
		return $length>0;
	}
}
