<?php
class CacheDeleteAction extends AdminAction
{
	public function __construct()
	{
		parent::__construct();
		$this->responseType = 'tpl';
		$this->layout = 'admin';
	}

	public function execute()
	{
		$numPerTime		= $this->context->post('num');
		if(!$numPerTime)
		{
			$numPerTime		= $this->context->get('num');
		}
		if(!is_numeric($numPerTime) || $numPerTime<=0)
		{
			$numPerTime = 500;
		}
		
		$productCacheService	= new ProductCacheService();
		$num = $productCacheService->deleteAll($numPerTime);
		if($num==$numPerTime)
		{
			$this->data['nextUrl'] = C('LtUrl')->generate('Cache','Delete',array('num'=>$numPerTime));
		}
		
		$this->data['menu']		= 'tool';
		$this->data['submenu']	= 'tool_cache';
	}
}
